package com.ejie.aa00j.service;

import com.ejie.aa00j.dao.Aa00j07s01Dao;
import com.ejie.aa00j.dao.Aa00j10s01Dao;
import com.ejie.aa00j.dao.Aa00j20s01Dao;
import com.ejie.aa00j.dao.Aa00j30s01Dao;
import com.ejie.aa00j.dao.ComunDao;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa00j.model.Aa00j07s01;
import com.ejie.aa00j.model.Option;

/**
 * Aa00j07s01ServiceImpl generated by UDA, 16-oct-2013 13:02:12.
 * 
 * @author UDA
 */

@Service(value = "aa00j07s01Service")
public class Aa00j07s01ServiceImpl implements Aa00j07s01Service {

	@Autowired
	private ReloadableResourceBundleMessageSource appMessageSource;

	@Autowired
	private ComunDao comunDao;

	@Autowired
	private Aa00j07s01Dao aa00j07s01Dao;

	@Autowired
	private Aa00j10s01Dao aa00j10s01Dao;

	@Autowired
	private Aa00j20s01Dao aa00j20s01Dao;

	@Autowired
	private Aa00j30s01Dao aa00j30s01Dao;

	/**
	 * Inserts a single row in the Aa00j07s01 table.
	 * 
	 * @param aa00j07s01
	 *            Aa00j07s01
	 * @return Aa00j07s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa00j07s01 add(Aa00j07s01 aa00j07s01) throws Exception {
		String mensaje = "etErrorCrearDepartamento";
		try {
			// 1º Comprobamos que se haya introducido algún nombre para el nuevo
			// departamento
			if (aa00j07s01.getDescc07().trim().length() <= 0) {
				mensaje = "etNombreDepartamentoObligatorio";
				throw new Exception();
			} else {
				// 2º Comprobamos que no exista
				if (this.aa00j07s01Dao.existe(aa00j07s01.getDescc07().trim(),
						null)) {
					mensaje = "etYaExisteDepartamento";
					throw new Exception();
				} else {
					// 3º Lo insertamos
					return this.aa00j07s01Dao.add(aa00j07s01);
				}
			}
		} catch (Exception e) {
			throw new Exception(this.appMessageSource.getMessage(mensaje, null,
					LocaleContextHolder.getLocale()));
		}
	}

	/**
	 * Updates a single row in the Aa00j07s01 table.
	 * 
	 * @param aa00j07s01
	 *            Aa00j07s01
	 * @return Aa00j07s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa00j07s01 update(Aa00j07s01 aa00j07s01) throws Exception {
		String mensaje = "etErrorActualizarDepartamento";
		try {
			// 1º Comprobamos que se haya introducido algún nombre para el nuevo
			// departamento
			if (aa00j07s01.getDescc07().trim().length() <= 0) {
				mensaje = "etNombreDepartamentoObligatorio";
				throw new Exception();
			} else {
				// 2º Comprobamos que no exista
				if (this.aa00j07s01Dao.existe(aa00j07s01.getDescc07().trim(),
						aa00j07s01.getCdep07())) {
					mensaje = "etYaExisteDepartamento";
					throw new Exception();
				} else {
					// 3º Lo actualizamos
					return this.aa00j07s01Dao.update(aa00j07s01);
				}
			}
		} catch (Exception e) {
			throw new Exception(this.appMessageSource.getMessage(mensaje, null,
					LocaleContextHolder.getLocale()));
		}
	}

	/**
	 * Finds a single row in the Aa00j07s01 table.
	 * 
	 * @param aa00j07s01
	 *            Aa00j07s01
	 * @return Aa00j07s01
	 */
	public Aa00j07s01 find(Aa00j07s01 aa00j07s01) {
		return (Aa00j07s01) this.aa00j07s01Dao.find(aa00j07s01);
	}

	/**
	 * Deletes a single row in the Aa00j07s01 table.
	 * 
	 * @param aa00j07s01
	 *            Aa00j07s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Aa00j07s01 aa00j07s01) throws Exception {
		String mensaje = "etErrorBorrarDepartamento";
		try {
			// 1º Comprobamos que no exista ninguna Sala para este departamento
			if (this.aa00j10s01Dao.existeDepartamento(aa00j07s01.getCdep07())) {
				mensaje = "etExisteSalaDepartamento";
				throw new Exception();
				// 2º Comprobamos que no exista ninguna Reserva de sala para
				// este edificio
			} else if (this.aa00j20s01Dao.existeDepartamento(aa00j07s01
					.getCdep07())) {
				mensaje = "etExisteReservaSalaDepartamento";
				throw new Exception();
			} else if (this.aa00j30s01Dao.existeDepartamento(aa00j07s01
					.getCdep07())) {
				mensaje = "etExisteReservaRecursoDepartamento";
				throw new Exception();
			} else {
				// 3º La borramos
				this.aa00j07s01Dao.remove(aa00j07s01);
			}
		} catch (Exception e) {
			throw new Exception(this.appMessageSource.getMessage(mensaje, null,
					LocaleContextHolder.getLocale()));
		}
	}

	/**
	 * Finds a list of rows in the Aa00j07s01 table.
	 * 
	 * @param aa00j07s01
	 *            Aa00j07s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa00j07s01>
	 */
	public List<Aa00j07s01> findAll(Aa00j07s01 aa00j07s01,
			JQGridRequestDto jqGridRequestDto) {
		return (List<Aa00j07s01>) this.aa00j07s01Dao.findAll(aa00j07s01,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the Aa00j07s01 table using like.
	 * 
	 * @param aa00j07s01
	 *            Aa00j07s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa00j07s01>
	 */
	public List<Aa00j07s01> findAllLike(Aa00j07s01 aa00j07s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<Aa00j07s01>) this.aa00j07s01Dao.findAllLike(aa00j07s01,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Aa00j07s01 table.
	 * 
	 * @param filterAa00j07s01
	 *            Aa00j07s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	public void removeMultiple(Aa00j07s01 filterAa00j07s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith)
			throws Exception {
		String mensajeError = "etErrorBorrarDepartamento";
		String mensajeExisteSala = "etExisteSalaDepartamento";
		String mensajeExisteReservaSala = "etExisteReservaSalaDepartamento";
		String mensajeExisteReservaRecurso = "etExisteReservaRecursoDepartamento";

		String strError = "";
		String strExisteSala = "";
		String strExisteReservaSala = "";
		String strExisteReservaRecurso = "";

		if (jqGridRequestDto != null
				&& jqGridRequestDto.getMultiselection() != null
				&& jqGridRequestDto.getMultiselection().getSelected(
						Aa00j07s01.class) != null) {
			for (Aa00j07s01 selected : jqGridRequestDto.getMultiselection()
					.getSelected(Aa00j07s01.class)) {
				try {
					// 1º Comprobamos que no exista ninguna Sala para este
					// departamento
					if (this.aa00j10s01Dao.existeDepartamento(selected
							.getCdep07())) {
						strExisteSala = strExisteSala
								.concat("<br/>")
								.concat("-")
								.concat(this.aa00j07s01Dao.find(selected)
										.getDescc07());
						// 2º Comprobamos que no exista ninguna Reserva de sala
						// para este departamento
					} else if (this.aa00j20s01Dao.existeDepartamento(selected
							.getCdep07())) {
						strExisteReservaSala = strExisteReservaSala
								.concat("<br/>")
								.concat("-")
								.concat(this.aa00j07s01Dao.find(selected)
										.getDescc07());
						// 3º Comprobamos que no exista ninguna Reserva de
						// recurso para este departamento
					} else if (this.aa00j30s01Dao.existeDepartamento(selected
							.getCdep07())) {
						strExisteReservaRecurso = strExisteReservaRecurso
								.concat("<br/>")
								.concat("-")
								.concat(this.aa00j07s01Dao.find(selected)
										.getDescc07());
					} else {
						// 3º La borramos
						this.aa00j07s01Dao.remove(selected);
					}
				} catch (Exception e) {
					strError = strError
							.concat("<br/>")
							.concat("-")
							.concat(this.aa00j07s01Dao.find(selected)
									.getDescc07());
				}
			}
		}

		if (strExisteSala.length() > 0 || strExisteReservaSala.length() > 0
				|| strExisteReservaRecurso.length() > 0
				|| strError.length() > 0) {
			String mensaje = "";
			if (strExisteSala.length() > 0) {
				mensaje = mensaje
						.concat(this.appMessageSource.getMessage(
								mensajeExisteSala, null,
								LocaleContextHolder.getLocale())).concat(":")
						.concat(strExisteSala);
			}
			if (strExisteReservaSala.length() > 0) {
				if (mensaje.length() > 0) {
					mensaje = mensaje.concat("<br/><br/>");
				}
				mensaje = mensaje
						.concat(this.appMessageSource.getMessage(
								mensajeExisteReservaSala, null,
								LocaleContextHolder.getLocale())).concat(":")
						.concat(strExisteReservaSala);
			}
			if (strExisteReservaRecurso.length() > 0) {
				if (mensaje.length() > 0) {
					mensaje = mensaje.concat("<br/><br/>");
				}
				mensaje = mensaje
						.concat(this.appMessageSource.getMessage(
								mensajeExisteReservaRecurso, null,
								LocaleContextHolder.getLocale())).concat(":")
						.concat(strExisteReservaRecurso);
			}
			if (strError.length() > 0) {
				if (mensaje.length() > 0) {
					mensaje = mensaje.concat("<br/><br/>");
				}
				mensaje = mensaje
						.concat(this.appMessageSource.getMessage(mensajeError,
								null, LocaleContextHolder.getLocale()))
						.concat(":").concat(strError);
			}
			throw new Exception(mensaje);
		}
	}

	/**
	 * Filter method in the Aa00j07s01 table.
	 * 
	 * @param filterAa00j07s01
	 *            Aa00j07s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<Aa00j07s01>
	 */
	public JQGridResponseDto<Aa00j07s01> filter(Aa00j07s01 filterAa00j07s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<Aa00j07s01> listaAa00j07s01 = this.aa00j07s01Dao.findAllLike(
				filterAa00j07s01, jqGridRequestDto, false);
		Long recordNum = this.aa00j07s01Dao.findAllLikeCount(
				filterAa00j07s01 != null ? filterAa00j07s01 : new Aa00j07s01(),
				false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Aa00j07s01>> reorderSelection = this.aa00j07s01Dao
					.reorderSelection(filterAa00j07s01, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<Aa00j07s01>(jqGridRequestDto,
					recordNum, listaAa00j07s01, reorderSelection);
		}
		return new JQGridResponseDto<Aa00j07s01>(jqGridRequestDto, recordNum,
				listaAa00j07s01);
	}

	/**
	 * Searches rows in the Aa00j07s01 table.
	 * 
	 * @param filterAa00j07s01
	 *            Aa00j07s01
	 * @param searchAa00j07s01
	 *            Aa00j07s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j07s01>>
	 */
	public List<TableRowDto<Aa00j07s01>> search(Aa00j07s01 filterAa00j07s01,
			Aa00j07s01 searchAa00j07s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return this.aa00j07s01Dao.search(filterAa00j07s01, searchAa00j07s01,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Aa00j07s01 table.
	 * 
	 * @param filterAa00j07s01
	 *            Aa00j07s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	public Object reorderSelection(Aa00j07s01 filterAa00j07s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.aa00j07s01Dao.reorderSelection(filterAa00j07s01,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Aa00j07s01 table.
	 * 
	 * @param filterAa00j07s01
	 *            Aa00j07s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<JerarquiaDto<Aa00j07s01>>
	 */
	public JQGridResponseDto<JerarquiaDto<Aa00j07s01>> jerarquia(
			Aa00j07s01 filterAa00j07s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		List<JerarquiaDto<Aa00j07s01>> listaAa00j07s01 = this.aa00j07s01Dao
				.findAllLikeJerarquia(filterAa00j07s01, jqGridRequestDto);
		Long recordNum = this.aa00j07s01Dao.findAllLikeCountJerarquia(
				filterAa00j07s01, jqGridRequestDto);
		return new JQGridResponseDto<JerarquiaDto<Aa00j07s01>>(
				jqGridRequestDto, recordNum, listaAa00j07s01);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the Aa00j07s01 table.
	 * 
	 * @param filterAa00j07s01
	 *            Aa00j07s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return JQGridResponseDto<JerarquiaDto<Aa00j07s01>>
	 */
	public JQGridResponseDto<JerarquiaDto<Aa00j07s01>> jerarquiaChildren(
			Aa00j07s01 filterAa00j07s01, JQGridRequestDto jqGridRequestDto) {
		JQGridResponseDto<JerarquiaDto<Aa00j07s01>> jqGridResponseDto = new JQGridResponseDto<JerarquiaDto<Aa00j07s01>>();
		jqGridResponseDto.addAdditionalParam(JQGridResponseDto.CHILDREN,
				this.aa00j07s01Dao.findAllChild(filterAa00j07s01,
						jqGridRequestDto));
		return jqGridResponseDto;
	}

	public boolean bloquear(Long cdep07) {

		return this.comunDao.bloquear("cdep07", cdep07.toString());
	}

	public boolean desbloquear(Long cdep07) {

		return this.comunDao.desbloquear("cdep07", cdep07.toString());
	}

	public List<Aa00j07s01> obtenerCombo() {
		return (List<Aa00j07s01>) this.aa00j07s01Dao.obtenerCombo();
	}

	public String obtenerCodigoXlnet(Long cdep07) {
		return this.aa00j07s01Dao.obtenerCodigoXlnet(cdep07);
	}

	public Long obtenerCodigoPorXlnet(String codDeptoXlnet) {
		return this.aa00j07s01Dao.obtenerCodigoPorXlnet(codDeptoXlnet);
	}

	/**
	 * Controla el usuario, si no es administrador ni tecnico solamente se el
	 * devuelve el suyo
	 * 
	 * @return
	 */
	public List<Aa00j07s01> obtenerComboControlado() {
		return this.aa00j07s01Dao.obtenerComboControlado();
	}

	/**
	 * Devuelve los edificios en los que hay salas que tienen que aparecer en un
	 * listado especial de edificios
	 * 
	 * @return
	 */
	public List<Option> obtenerComboListado() {
		return this.aa00j07s01Dao.obtenerComboListado();
	}

	/**
	 * Modifica la situacion de los registros ids en la tabla
	 * 
	 * 
	 * @param ids
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public boolean cambiarSituacion(String ids) {
		return this.comunDao.cambiarSituacion("07", "CDEP07", ids);
	}
}