package com.ejie.aa00j.service;

import com.ejie.aa00j.classes.aa00jConstantes;
import com.ejie.aa00j.dao.Aa00j06s01Dao;
import com.ejie.aa00j.dao.Aa00j10s01Dao;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa00j.model.Aa00j06s01;

/**
 * Aa00j06s01ServiceImpl generated by UDA, 16-oct-2013 13:02:12.
 * 
 * @author UDA
 */

@Service(value = "aa00j06s01Service")
public class Aa00j06s01ServiceImpl implements Aa00j06s01Service {

	@Autowired
	private ReloadableResourceBundleMessageSource appMessageSource;

	@Autowired
	private Aa00j06s01Dao aa00j06s01Dao;

	@Autowired
	private Aa00j10s01Dao aa00j10s01Dao;

	/**
	 * Inserts a single row in the Aa00j06s01 table.
	 * 
	 * @param aa00j06s01
	 *            Aa00j06s01
	 * @return Aa00j06s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa00j06s01 add(Aa00j06s01 aa00j06s01) throws Exception {
		String mensaje = "etErrorCrearTextoReserva";
		try {
			// 1º Comprobamos que se haya introducido algúna descripción en
			// castellano y en euskera para la nueva restricción
			if (aa00j06s01.getDescc06().trim().length() <= 0) {
				mensaje = "etDescEsRestriccionObligatorio";
				throw new Exception();
			} else if (aa00j06s01.getDesce06().trim().length() <= 0) {
				mensaje = "etDescEuRestriccionObligatorio";
				throw new Exception();
			} else {
				// 2º Comprobamos que no exista
				if (this.aa00j06s01Dao.existe(aa00j06s01.getDescc06().trim(),
						null)) {
					mensaje = "etYaExisteRestriccion";
					throw new Exception();
				} else {
					// 3º Lo insertamos
					return this.aa00j06s01Dao.add(aa00j06s01);
				}
			}
		} catch (Exception e) {
			throw new Exception(this.appMessageSource.getMessage(mensaje, null,
					LocaleContextHolder.getLocale()));
		}
	}

	/**
	 * Updates a single row in the Aa00j06s01 table.
	 * 
	 * @param aa00j06s01
	 *            Aa00j06s01
	 * @return Aa00j06s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa00j06s01 update(Aa00j06s01 aa00j06s01) throws Exception {
		String mensaje = "etErrorActualizarRestriccion";
		try {
			// 1º Comprobamos que se haya introducido algúna descripción en
			// castellano y en euskera para la nueva restricción
			if (aa00j06s01.getDescc06().trim().length() <= 0) {
				mensaje = "etDescEsRestriccionObligatorio";
				throw new Exception();
			} else if (aa00j06s01.getDesce06().trim().length() <= 0) {
				mensaje = "etDescEuRestriccionObligatorio";
				throw new Exception();
			} else {
				// 2º Comprobamos que no exista
				if (this.aa00j06s01Dao.existe(aa00j06s01.getDescc06().trim(),
						aa00j06s01.getCrest06())) {
					mensaje = "etYaExisteRestriccion";
					throw new Exception();
				} else {
					// 3º Lo actualizamos
					return this.aa00j06s01Dao.update(aa00j06s01);
				}
			}
		} catch (Exception e) {
			throw new Exception(this.appMessageSource.getMessage(mensaje, null,
					LocaleContextHolder.getLocale()));
		}
	}

	/**
	 * Finds a single row in the Aa00j06s01 table.
	 * 
	 * @param aa00j06s01
	 *            Aa00j06s01
	 * @return Aa00j06s01
	 */
	public Aa00j06s01 find(Aa00j06s01 aa00j06s01) {
		return (Aa00j06s01) this.aa00j06s01Dao.find(aa00j06s01);
	}

	/**
	 * Deletes a single row in the Aa00j06s01 table.
	 * 
	 * @param aa00j06s01
	 *            Aa00j06s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Aa00j06s01 aa00j06s01) throws Exception {
		String mensaje = "etErrorBorrarRestriccion";
		try {
			// 1º Comprobamos que no exista ninguna sala con esta restricción
			if (this.aa00j10s01Dao.existeRestriccion(aa00j06s01.getCrest06())) {
				mensaje = "etExisteSalaRestriccion";
				throw new Exception();
			} else {
				// 2º La borramos
				this.aa00j06s01Dao.remove(aa00j06s01);
			}
		} catch (Exception e) {
			throw new Exception(this.appMessageSource.getMessage(mensaje, null,
					LocaleContextHolder.getLocale()));
		}
	}

	/**
	 * Finds a list of rows in the Aa00j06s01 table.
	 * 
	 * @param aa00j06s01
	 *            Aa00j06s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa00j06s01>
	 */
	public List<Aa00j06s01> findAll(Aa00j06s01 aa00j06s01,
			JQGridRequestDto jqGridRequestDto) {
		return (List<Aa00j06s01>) this.aa00j06s01Dao.findAll(aa00j06s01,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the Aa00j06s01 table using like.
	 * 
	 * @param aa00j06s01
	 *            Aa00j06s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa00j06s01>
	 */
	public List<Aa00j06s01> findAllLike(Aa00j06s01 aa00j06s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<Aa00j06s01>) this.aa00j06s01Dao.findAllLike(aa00j06s01,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Aa00j06s01 table.
	 * 
	 * @param filterAa00j06s01
	 *            Aa00j06s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	public void removeMultiple(Aa00j06s01 filterAa00j06s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith)
			throws Exception {
		String mensajeError = "etErrorBorrarRestriccion";
		String mensajeExiste = "etExisteSalaRestriccion";
		String strError = "";
		String strExiste = "";
		String aux = "";

		if (jqGridRequestDto != null
				&& jqGridRequestDto.getMultiselection() != null
				&& jqGridRequestDto.getMultiselection().getSelected(
						Aa00j06s01.class) != null) {
			for (Aa00j06s01 selected : jqGridRequestDto.getMultiselection()
					.getSelected(Aa00j06s01.class)) {
				try {
					// 1º Comprobamos que no exista nunguna sala para esta
					// restricción
					if (this.aa00j10s01Dao.existeRestriccion(selected
							.getCrest06())) {
						if (LocaleContextHolder.getLocale().equals(
								aa00jConstantes.IDIOMA_EUSKERA)) {
							aux = this.aa00j06s01Dao.find(selected)
									.getDesce06();
						} else {
							aux = this.aa00j06s01Dao.find(selected)
									.getDescc06();
						}
						strExiste = strExiste.concat("<br/>").concat("-")
								.concat(aux);
					} else {
						// 2º La borramos
						this.aa00j06s01Dao.remove(selected);
					}
				} catch (Exception e) {
					if (LocaleContextHolder.getLocale().equals(
							aa00jConstantes.IDIOMA_EUSKERA)) {
						aux = this.aa00j06s01Dao.find(selected).getDesce06();
					} else {
						aux = this.aa00j06s01Dao.find(selected).getDescc06();
					}
					strError = strError.concat("<br/>").concat("-").concat(aux);
				}
			}
		}

		if (strExiste.length() > 0 || strError.length() > 0) {
			String mensaje = "";
			if (strExiste.length() > 0) {
				mensaje = mensaje
						.concat(this.appMessageSource.getMessage(mensajeExiste,
								null, LocaleContextHolder.getLocale()))
						.concat(":").concat(strExiste);
			}
			if (strError.length() > 0) {
				if (mensaje.length() > 0) {
					mensaje = mensaje.concat("<br/><br/>");
				}
				mensaje = mensaje
						.concat(this.appMessageSource.getMessage(mensajeError,
								null, LocaleContextHolder.getLocale()))
						.concat(":").concat(strError);
			}
			throw new Exception(mensaje);
		}
	}

	/**
	 * Filter method in the Aa00j06s01 table.
	 * 
	 * @param filterAa00j06s01
	 *            Aa00j06s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<Aa00j06s01>
	 */
	public JQGridResponseDto<Aa00j06s01> filter(Aa00j06s01 filterAa00j06s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<Aa00j06s01> listaAa00j06s01 = this.aa00j06s01Dao.findAllLike(
				filterAa00j06s01, jqGridRequestDto, false);
		Long recordNum = this.aa00j06s01Dao.findAllLikeCount(
				filterAa00j06s01 != null ? filterAa00j06s01 : new Aa00j06s01(),
				false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Aa00j06s01>> reorderSelection = this.aa00j06s01Dao
					.reorderSelection(filterAa00j06s01, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<Aa00j06s01>(jqGridRequestDto,
					recordNum, listaAa00j06s01, reorderSelection);
		}
		return new JQGridResponseDto<Aa00j06s01>(jqGridRequestDto, recordNum,
				listaAa00j06s01);
	}

	/**
	 * Searches rows in the Aa00j06s01 table.
	 * 
	 * @param filterAa00j06s01
	 *            Aa00j06s01
	 * @param searchAa00j06s01
	 *            Aa00j06s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j06s01>>
	 */
	public List<TableRowDto<Aa00j06s01>> search(Aa00j06s01 filterAa00j06s01,
			Aa00j06s01 searchAa00j06s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return this.aa00j06s01Dao.search(filterAa00j06s01, searchAa00j06s01,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Aa00j06s01 table.
	 * 
	 * @param filterAa00j06s01
	 *            Aa00j06s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	public Object reorderSelection(Aa00j06s01 filterAa00j06s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.aa00j06s01Dao.reorderSelection(filterAa00j06s01,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Aa00j06s01 table.
	 * 
	 * @param filterAa00j06s01
	 *            Aa00j06s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<JerarquiaDto<Aa00j06s01>>
	 */
	public JQGridResponseDto<JerarquiaDto<Aa00j06s01>> jerarquia(
			Aa00j06s01 filterAa00j06s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		List<JerarquiaDto<Aa00j06s01>> listaAa00j06s01 = this.aa00j06s01Dao
				.findAllLikeJerarquia(filterAa00j06s01, jqGridRequestDto);
		Long recordNum = this.aa00j06s01Dao.findAllLikeCountJerarquia(
				filterAa00j06s01, jqGridRequestDto);
		return new JQGridResponseDto<JerarquiaDto<Aa00j06s01>>(
				jqGridRequestDto, recordNum, listaAa00j06s01);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the Aa00j06s01 table.
	 * 
	 * @param filterAa00j06s01
	 *            Aa00j06s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return JQGridResponseDto<JerarquiaDto<Aa00j06s01>>
	 */
	public JQGridResponseDto<JerarquiaDto<Aa00j06s01>> jerarquiaChildren(
			Aa00j06s01 filterAa00j06s01, JQGridRequestDto jqGridRequestDto) {
		JQGridResponseDto<JerarquiaDto<Aa00j06s01>> jqGridResponseDto = new JQGridResponseDto<JerarquiaDto<Aa00j06s01>>();
		jqGridResponseDto.addAdditionalParam(JQGridResponseDto.CHILDREN,
				this.aa00j06s01Dao.findAllChild(filterAa00j06s01,
						jqGridRequestDto));
		return jqGridResponseDto;
	}

	public List<Aa00j06s01> obtenerCombo() {
		return (List<Aa00j06s01>) this.aa00j06s01Dao.obtenerCombo();
	}

	@Transactional(rollbackFor = Throwable.class)
	public String anyadir(String DescripcionEs, String DescripcionEu,
			String mensajeEs, String mensajeEu) {
		try {
			// 1º Comprobamos que se haya introducido algún titulo para la nueva
			// restricción
			if (DescripcionEs.trim().length() <= 0) {
				return this.appMessageSource.getMessage(
						"etDescEsRestriccionObligatorio", null,
						LocaleContextHolder.getLocale());
			} else {
				// 2º Comprobamos que no exista
				if (this.aa00j06s01Dao.existe(DescripcionEs.trim(), null)) {
					return this.appMessageSource.getMessage(
							"etYaExisteRestriccion", null,
							LocaleContextHolder.getLocale());
				} else {
					// 3º Lo insertamos
					Aa00j06s01 aa00j06s01 = this.aa00j06s01Dao.anyadir(
							DescripcionEs, DescripcionEu, mensajeEs, mensajeEu);
					if (aa00j06s01 != null && aa00j06s01.getCrest06() > 0) {
						return aa00j06s01.getCrest06().toString();
					} else {
						return this.appMessageSource.getMessage(
								"etErrorCrearRestriccion", null,
								LocaleContextHolder.getLocale());
					}
				}
			}
		} catch (Exception e) {
			return this.appMessageSource.getMessage("etErrorCrearRestriccion",
					null, LocaleContextHolder.getLocale());
		}
	}
}