package com.ejie.aa00j.service;

import com.ejie.aa00j.dao.Aa00j03s01Dao;
import com.ejie.aa00j.dao.Aa00j05s01Dao;
import com.ejie.aa00j.dao.ComunDao;
import com.ejie.aa00j.model.Aa00j03s01;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.dto.TableRowDto;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa00j.model.Aa00j05s01;

/**
 * Aa00j05s01ServiceImpl generated by UDA, 16-oct-2013 13:02:12.
 * 
 * @author UDA
 */

@Service(value = "aa00j05s01Service")
public class Aa00j05s01ServiceImpl implements Aa00j05s01Service {

	@Autowired
	private ReloadableResourceBundleMessageSource appMessageSource;

	@Autowired
	private ComunDao comunDao;

	@Autowired
	private Aa00j05s01Dao aa00j05s01Dao;

	@Autowired
	private Aa00j03s01Dao aa00j03s01Dao;

	/**
	 * Inserts a single row in the Aa00j05s01 table.
	 * 
	 * @param aa00j05s01
	 *            Aa00j05s01
	 * @return Aa00j05s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa00j05s01 add(Aa00j05s01 aa00j05s01) throws Exception {
		String mensaje = "etErrorCrearResponsable";
		try {
			// 1º Comprobamos que se haya introducido algún nombre para el nuevo
			// responsable
			if (aa00j05s01.getNom05().trim().length() <= 0) {
				mensaje = "etNombreResponsableObligatorio";
				throw new Exception();
			} else {
				// 2º Comprobamos que no exista
				if (this.aa00j05s01Dao.existeCodigo(aa00j05s01.getCresp05()
						.trim(), null)) {
					mensaje = "etYaExisteResponsableCodigo";
					throw new Exception();
				} else if (this.aa00j05s01Dao.existe(aa00j05s01.getNom05()
						.trim(), null)) {
					mensaje = "etYaExisteResponsable";
					throw new Exception();
				} else {
					// 3º Lo insertamos
					return this.aa00j05s01Dao.add(aa00j05s01);
				}
			}
		} catch (Exception e) {
			throw new Exception(this.appMessageSource.getMessage(mensaje, null,
					LocaleContextHolder.getLocale()));
		}
	}

	/**
	 * Updates a single row in the Aa00j05s01 table.
	 * 
	 * @param aa00j05s01
	 *            Aa00j05s01
	 * @return Aa00j05s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa00j05s01 update(Aa00j05s01 aa00j05s01) throws Exception {
		String mensaje = "etErrorActualizarResponsable";
		try {
			// 1º Comprobamos que se haya introducido algún nombre para el nuevo
			// responsable
			if (aa00j05s01.getNom05().trim().length() <= 0) {
				mensaje = "etNombreResponsableObligatorio";
				throw new Exception();
			} else {
				// 2º Comprobamos que no exista
				if (this.aa00j05s01Dao.existeCodigo(aa00j05s01.getCresp05()
						.trim(), aa00j05s01.getCresp05())) {
					mensaje = "etYaExisteResponsableCodigo";
					throw new Exception();
				} else if (this.aa00j05s01Dao.existe(aa00j05s01.getNom05()
						.trim(), aa00j05s01.getCresp05())) {
					mensaje = "etYaExisteResponsable";
					throw new Exception();
				} else {
					// 3º Lo actualizamos
					return this.aa00j05s01Dao.update(aa00j05s01);
				}
			}
		} catch (Exception e) {
			throw new Exception(this.appMessageSource.getMessage(mensaje, null,
					LocaleContextHolder.getLocale()));
		}
	}

	/**
	 * Finds a single row in the Aa00j05s01 table.
	 * 
	 * @param aa00j05s01
	 *            Aa00j05s01
	 * @return Aa00j05s01
	 */
	public Aa00j05s01 find(Aa00j05s01 aa00j05s01) {
		return (Aa00j05s01) this.aa00j05s01Dao.find(aa00j05s01);
	}

	/**
	 * Deletes a single row in the Aa00j05s01 table.
	 * 
	 * @param aa00j05s01
	 *            Aa00j05s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Aa00j05s01 aa00j05s01) throws Exception {
		String mensaje = "etErrorBorrarResponsable";
		try {
			// 1º Comprobamos que no exista ningún edificio para este
			// responsable
			if (this.aa00j03s01Dao.existeResponsable(aa00j05s01.getCresp05())) {
				mensaje = "etExisteEdificioResponsable";
				throw new Exception();
			} else {
				// 2º La borramos
				this.aa00j05s01Dao.remove(aa00j05s01);
			}
		} catch (Exception e) {
			throw new Exception(this.appMessageSource.getMessage(mensaje, null,
					LocaleContextHolder.getLocale()));
		}
	}

	/**
	 * Finds a list of rows in the Aa00j05s01 table.
	 * 
	 * @param aa00j05s01
	 *            Aa00j05s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa00j05s01>
	 */
	public List<Aa00j05s01> findAll(Aa00j05s01 aa00j05s01,
			JQGridRequestDto jqGridRequestDto) {
		return (List<Aa00j05s01>) this.aa00j05s01Dao.findAll(aa00j05s01,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the Aa00j05s01 table using like.
	 * 
	 * @param aa00j05s01
	 *            Aa00j05s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa00j05s01>
	 */
	public List<Aa00j05s01> findAllLike(Aa00j05s01 aa00j05s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<Aa00j05s01>) this.aa00j05s01Dao.findAllLike(aa00j05s01,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Aa00j05s01 table.
	 * 
	 * @param filterAa00j05s01
	 *            Aa00j05s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	public void removeMultiple(Aa00j05s01 filterAa00j05s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith)
			throws Exception {
		String mensajeError = "etErrorBorrarResponsable";
		String mensajeExiste = "etExisteEdificioResponsable";
		String strError = "";
		String strExiste = "";

		if (jqGridRequestDto != null
				&& jqGridRequestDto.getMultiselection() != null
				&& jqGridRequestDto.getMultiselection().getSelected(
						Aa00j05s01.class) != null) {
			for (Aa00j05s01 selected : jqGridRequestDto.getMultiselection()
					.getSelected(Aa00j05s01.class)) {
				try {
					// 1º Comprobamos que no exista ningún edificio para este
					// responsable
					if (this.aa00j03s01Dao.existeResponsable(selected
							.getCresp05())) {
						strExiste = strExiste
								.concat("<br/>")
								.concat("-")
								.concat(this.aa00j05s01Dao.find(selected)
										.getNom05());
					} else {
						// 2º La borramos
						this.aa00j05s01Dao.remove(selected);
					}
				} catch (Exception e) {
					strError = strError
							.concat("<br/>")
							.concat("-")
							.concat(this.aa00j05s01Dao.find(selected)
									.getNom05());
				}
			}
		}

		if (strExiste.length() > 0 || strError.length() > 0) {
			String mensaje = "";
			if (strExiste.length() > 0) {
				mensaje = mensaje
						.concat(this.appMessageSource.getMessage(mensajeExiste,
								null, LocaleContextHolder.getLocale()))
						.concat(":").concat(strExiste);
			}
			if (strError.length() > 0) {
				if (mensaje.length() > 0) {
					mensaje = mensaje.concat("<br/><br/>");
				}
				mensaje = mensaje
						.concat(this.appMessageSource.getMessage(mensajeError,
								null, LocaleContextHolder.getLocale()))
						.concat(":").concat(strError);
			}
			throw new Exception(mensaje);
		}
	}

	/**
	 * Filter method in the Aa00j05s01 table.
	 * 
	 * @param filterAa00j05s01
	 *            Aa00j05s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<Aa00j05s01>
	 */
	public JQGridResponseDto<Aa00j05s01> filter(Aa00j05s01 filterAa00j05s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<Aa00j05s01> listaAa00j05s01 = this.aa00j05s01Dao.findAllLike(
				filterAa00j05s01, jqGridRequestDto, false);
		Long recordNum = this.aa00j05s01Dao.findAllLikeCount(
				filterAa00j05s01 != null ? filterAa00j05s01 : new Aa00j05s01(),
				false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Aa00j05s01>> reorderSelection = this.aa00j05s01Dao
					.reorderSelection(filterAa00j05s01, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<Aa00j05s01>(jqGridRequestDto,
					recordNum, listaAa00j05s01, reorderSelection);
		}
		return new JQGridResponseDto<Aa00j05s01>(jqGridRequestDto, recordNum,
				listaAa00j05s01);
	}

	/**
	 * Searches rows in the Aa00j05s01 table.
	 * 
	 * @param filterAa00j05s01
	 *            Aa00j05s01
	 * @param searchAa00j05s01
	 *            Aa00j05s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j05s01>>
	 */
	public List<TableRowDto<Aa00j05s01>> search(Aa00j05s01 filterAa00j05s01,
			Aa00j05s01 searchAa00j05s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return this.aa00j05s01Dao.search(filterAa00j05s01, searchAa00j05s01,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Aa00j05s01 table.
	 * 
	 * @param filterAa00j05s01
	 *            Aa00j05s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	public Object reorderSelection(Aa00j05s01 filterAa00j05s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.aa00j05s01Dao.reorderSelection(filterAa00j05s01,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Aa00j05s01 table.
	 * 
	 * @param filterAa00j05s01
	 *            Aa00j05s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<JerarquiaDto<Aa00j05s01>>
	 */
	public JQGridResponseDto<JerarquiaDto<Aa00j05s01>> jerarquia(
			Aa00j05s01 filterAa00j05s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		List<JerarquiaDto<Aa00j05s01>> listaAa00j05s01 = this.aa00j05s01Dao
				.findAllLikeJerarquia(filterAa00j05s01, jqGridRequestDto);
		Long recordNum = this.aa00j05s01Dao.findAllLikeCountJerarquia(
				filterAa00j05s01, jqGridRequestDto);
		return new JQGridResponseDto<JerarquiaDto<Aa00j05s01>>(
				jqGridRequestDto, recordNum, listaAa00j05s01);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the Aa00j05s01 table.
	 * 
	 * @param filterAa00j05s01
	 *            Aa00j05s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return JQGridResponseDto<JerarquiaDto<Aa00j05s01>>
	 */
	public JQGridResponseDto<JerarquiaDto<Aa00j05s01>> jerarquiaChildren(
			Aa00j05s01 filterAa00j05s01, JQGridRequestDto jqGridRequestDto) {
		JQGridResponseDto<JerarquiaDto<Aa00j05s01>> jqGridResponseDto = new JQGridResponseDto<JerarquiaDto<Aa00j05s01>>();
		jqGridResponseDto.addAdditionalParam(JQGridResponseDto.CHILDREN,
				this.aa00j05s01Dao.findAllChild(filterAa00j05s01,
						jqGridRequestDto));
		return jqGridResponseDto;
	}

	/**
	 * Inserts a single row in the Aa00j09s01 table.
	 * 
	 * @param aa00j05s01
	 *            Aa00j05s01
	 * @return Aa00j05s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa00j05s01 addAa00j09s01(Aa00j05s01 aa00j05s01) {
		return this.aa00j05s01Dao.addAa00j09s01(aa00j05s01);
	}

	/**
	 * Deletes a single row in the Aa00j09s01 table.
	 * 
	 * @param aa00j05s01
	 *            Aa00j05s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeAa00j09s01(Aa00j05s01 aa00j05s01) {
		this.aa00j05s01Dao.removeAa00j09s01(aa00j05s01);
	}

	/**
	 * Find a single row in the findAa00j09s01 Many To Many relationship.
	 * 
	 * @param aa00j05s01
	 *            Aa00j05s01
	 * @param aa00j03s01
	 *            Aa00j03s01
	 * @param pagination
	 *            Pagination
	 * @return Aa00j05s01
	 */
	public Aa00j05s01 findAa00j09s01(Aa00j05s01 aa00j05s01,
			Aa00j03s01 aa00j03s01, Pagination pagination) {
		return this.aa00j05s01Dao.findAa00j09s01(aa00j05s01, aa00j03s01,
				pagination);
	}

	/**
	 * Counts rows in the Aa00j09s01 table.
	 * 
	 * @param aa00j05s01
	 *            Aa00j05s01
	 * @param aa00j03s01
	 *            Aa00j03s01
	 * @return Long
	 */
	public Long findAa00j09s01Count(Aa00j05s01 aa00j05s01, Aa00j03s01 aa00j03s01) {
		return this.aa00j05s01Dao.findAa00j09s01Count(aa00j05s01, aa00j03s01);
	}

	public boolean bloquear(String cresp05) {

		return this.comunDao.bloquear("cresp05", cresp05.toString());
	}

	public boolean desbloquear(String cresp05) {

		return this.comunDao.desbloquear("cresp05", cresp05.toString());
	}

	public List<Aa00j05s01> obtenerCombo() {
		return (List<Aa00j05s01>) this.aa00j05s01Dao.obtenerCombo();
	}

	@Transactional(rollbackFor = Throwable.class)
	public String anyadir(String codigo, String nombre) {
		try {
			// 1º Comprobamos que se haya introducido algún nombre para el nuevo
			// responsable
			if (nombre.trim().length() <= 0) {
				return this.appMessageSource.getMessage(
						"etNombreResponsableObligatorio", null,
						LocaleContextHolder.getLocale());
			} else {
				// 2º Comprobamos que no exista
				if (this.aa00j05s01Dao.existeCodigo(codigo, null)) {
					return this.appMessageSource.getMessage(
							"etYaExisteResponsableCodigo", null,
							LocaleContextHolder.getLocale());
				} else if (this.aa00j05s01Dao.existe(nombre.trim(), null)) {
					return this.appMessageSource.getMessage(
							"etYaExisteResponsable", null,
							LocaleContextHolder.getLocale());
				} else {
					// 3º Lo insertamos
					Aa00j05s01 aa00j05s01 = this.aa00j05s01Dao.anyadir(codigo,
							nombre);
					if (aa00j05s01 != null
							&& aa00j05s01.getCresp05() + "" != "") {
						return aa00j05s01.getCresp05();
					} else {
						return this.appMessageSource.getMessage(
								"etErrorCrearResponsable", null,
								LocaleContextHolder.getLocale());
					}
				}
			}
		} catch (Exception e) {
			return this.appMessageSource.getMessage("etErrorCrearResponsable",
					null, LocaleContextHolder.getLocale());
		}
	}

	public List<Aa00j05s01> obtenerResponsablesEdificio(Long cedif03) {
		return (List<Aa00j05s01>) this.aa00j05s01Dao
				.obtenerResponsablesEdificio(cedif03);
	}

	public List<Aa00j05s01> obtenerResponsablesEdificioLibres(Long cedif03) {
		return (List<Aa00j05s01>) this.aa00j05s01Dao
				.obtenerResponsablesEdificioLibres(cedif03);
	}

	/**
	 * Modifica la situacion de los registros ids en la tabla
	 * 
	 * 
	 * @param ids
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public boolean cambiarSituacion(String ids) {
		String[] idsarr = ids.split(",");
		StringBuffer ids2 = new StringBuffer();

		for (int i = 0; i < idsarr.length; i++) {
			if (i != 0)
				ids2.append(",");
			ids2.append("'");
			ids2.append(idsarr[i]);
			ids2.append("'");

		}
		return this.comunDao.cambiarSituacion("05", "CRESP05", ids2.toString());
	}
}