package com.ejie.aa00j.service;

import com.ejie.aa00j.dao.Aa00j04s01Dao;
import com.ejie.aa00j.dao.Aa00j10s01Dao;
import com.ejie.aa00j.dao.ComunDao;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa00j.model.Aa00j04s01;

/**
 * Aa00j04s01ServiceImpl generated by UDA, 16-oct-2013 13:02:12.
 * 
 * @author UDA
 */

@Service(value = "aa00j04s01Service")
public class Aa00j04s01ServiceImpl implements Aa00j04s01Service {

	@Autowired
	private ReloadableResourceBundleMessageSource appMessageSource;

	@Autowired
	private Aa00j04s01Dao aa00j04s01Dao;

	@Autowired
	private Aa00j10s01Dao aa00j10s01Dao;
	@Autowired
	private ComunDao comunDao;

	/**
	 * Inserts a single row in the Aa00j04s01 table.
	 * 
	 * @param aa00j04s01
	 *            Aa00j04s01
	 * @return Aa00j04s01
	 * @throws Exception
	 * @throws
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa00j04s01 add(Aa00j04s01 aa00j04s01) throws Exception {
		String mensaje = "etErrorCrearTextoReserva";
		try {
			// 1º Comprobamos que se haya introducido algún título para el nuevo
			// texto reserva
			if (aa00j04s01.getTtexto04().trim().length() <= 0) {
				mensaje = "etTituloTextoReservaObligatorio";
				throw new Exception();
			} else {
				// 2º Comprobamos que no exista
				if (this.aa00j04s01Dao.existe(aa00j04s01.getTtexto04().trim(),
						null)) {
					mensaje = "etYaExisteTextoReserva";
					throw new Exception();
				} else {
					// 3º Lo insertamos
					return this.aa00j04s01Dao.add(aa00j04s01);
				}
			}
		} catch (Exception e) {
			throw new Exception(this.appMessageSource.getMessage(mensaje, null,
					LocaleContextHolder.getLocale()));
		}
	}

	/**
	 * Updates a single row in the Aa00j04s01 table.
	 * 
	 * @param aa00j04s01
	 *            Aa00j04s01
	 * @return Aa00j04s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa00j04s01 update(Aa00j04s01 aa00j04s01) throws Exception {
		String mensaje = "etErrorActualizarTextoReserva";
		try {
			// 1º Comprobamos que se haya introducido algún titulo para el nuevo
			// texto reserva
			if (aa00j04s01.getTtexto04().trim().length() <= 0) {
				mensaje = "etTituloTextoReservaObligatorio";
				throw new Exception();
			} else {
				// 2º Comprobamos que no exista
				if (this.aa00j04s01Dao.existe(aa00j04s01.getTtexto04().trim(),
						aa00j04s01.getCtexto04())) {
					mensaje = "etYaExisteTextoReserva";
					throw new Exception();
				} else {
					// 3º Lo actualizamos
					return this.aa00j04s01Dao.update(aa00j04s01);
				}
			}
		} catch (Exception e) {
			throw new Exception(this.appMessageSource.getMessage(mensaje, null,
					LocaleContextHolder.getLocale()));
		}
	}

	/**
	 * Finds a single row in the Aa00j04s01 table.
	 * 
	 * @param aa00j04s01
	 *            Aa00j04s01
	 * @return Aa00j04s01
	 */
	public Aa00j04s01 find(Aa00j04s01 aa00j04s01) {
		return (Aa00j04s01) this.aa00j04s01Dao.find(aa00j04s01);
	}

	/**
	 * Deletes a single row in the Aa00j04s01 table.
	 * 
	 * @param aa00j04s01
	 *            Aa00j04s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Aa00j04s01 aa00j04s01) throws Exception {
		String mensaje = "etErrorBorrarTextoReserva";
		try {
			if (aa00j04s01.getCtexto04() != 1) {// es el texto base, no se
												// puede borrar
				// 1º Comprobamos que no exista ninguna sala con este texto
				// reserva
				if (this.aa00j10s01Dao.existeTextoReserva(aa00j04s01
						.getCtexto04())) {
					mensaje = "etExisteSalaTextoReserva";
					throw new Exception();
				} else {
					// 2º La borramos
					this.aa00j04s01Dao.remove(aa00j04s01);
				}
			} else {
				mensaje = "etTextoReservaBaseBorrar";
				throw new Exception();

			}
		} catch (Exception e) {
			throw new Exception(this.appMessageSource.getMessage(mensaje, null,
					LocaleContextHolder.getLocale()));
		}
	}

	/**
	 * Finds a list of rows in the Aa00j04s01 table.
	 * 
	 * @param aa00j04s01
	 *            Aa00j04s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa00j04s01>
	 */
	public List<Aa00j04s01> findAll(Aa00j04s01 aa00j04s01,
			JQGridRequestDto jqGridRequestDto) {
		return (List<Aa00j04s01>) this.aa00j04s01Dao.findAll(aa00j04s01,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the Aa00j04s01 table using like.
	 * 
	 * @param aa00j04s01
	 *            Aa00j04s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa00j04s01>
	 */
	public List<Aa00j04s01> findAllLike(Aa00j04s01 aa00j04s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<Aa00j04s01>) this.aa00j04s01Dao.findAllLike(aa00j04s01,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Aa00j04s01 table.
	 * 
	 * @param filterAa00j04s01
	 *            Aa00j04s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	public void removeMultiple(Aa00j04s01 filterAa00j04s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith)
			throws Exception {
		String mensajeError = "etErrorBorrarTextoReserva";
		String mensajeExiste = "etExisteSalaTextoReserva";
		String strError = "";
		String strExiste = "";

		if (jqGridRequestDto != null
				&& jqGridRequestDto.getMultiselection() != null
				&& jqGridRequestDto.getMultiselection().getSelected(
						Aa00j04s01.class) != null) {
			for (Aa00j04s01 selected : jqGridRequestDto.getMultiselection()
					.getSelected(Aa00j04s01.class)) {
				try {
					// 1º Comprobamos que no exista nunguna sala para este texto
					// reserva
					if (this.aa00j10s01Dao.existeTextoReserva(selected
							.getCtexto04())) {
						strExiste = strExiste
								.concat("<br/>")
								.concat("-")
								.concat(this.aa00j04s01Dao.find(selected)
										.getTtexto04());
					} else {
						// 2º La borramos
						this.aa00j04s01Dao.remove(selected);
					}
				} catch (Exception e) {
					strError = strError
							.concat("<br/>")
							.concat("-")
							.concat(this.aa00j04s01Dao.find(selected)
									.getTtexto04());
				}
			}
		}

		if (strExiste.length() > 0 || strError.length() > 0) {
			String mensaje = "";
			if (strExiste.length() > 0) {
				mensaje = mensaje
						.concat(this.appMessageSource.getMessage(mensajeExiste,
								null, LocaleContextHolder.getLocale()))
						.concat(":").concat(strExiste);
			}
			if (strError.length() > 0) {
				if (mensaje.length() > 0) {
					mensaje = mensaje.concat("<br/><br/>");
				}
				mensaje = mensaje
						.concat(this.appMessageSource.getMessage(mensajeError,
								null, LocaleContextHolder.getLocale()))
						.concat(":").concat(strError);
			}
			throw new Exception(mensaje);
		}
	}

	/**
	 * Filter method in the Aa00j04s01 table.
	 * 
	 * @param filterAa00j04s01
	 *            Aa00j04s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<Aa00j04s01>
	 */
	public JQGridResponseDto<Aa00j04s01> filter(Aa00j04s01 filterAa00j04s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<Aa00j04s01> listaAa00j04s01 = this.aa00j04s01Dao.findAllLike(
				filterAa00j04s01, jqGridRequestDto, false);
		Long recordNum = this.aa00j04s01Dao.findAllLikeCount(
				filterAa00j04s01 != null ? filterAa00j04s01 : new Aa00j04s01(),
				false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Aa00j04s01>> reorderSelection = this.aa00j04s01Dao
					.reorderSelection(filterAa00j04s01, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<Aa00j04s01>(jqGridRequestDto,
					recordNum, listaAa00j04s01, reorderSelection);
		}
		return new JQGridResponseDto<Aa00j04s01>(jqGridRequestDto, recordNum,
				listaAa00j04s01);
	}

	/**
	 * Searches rows in the Aa00j04s01 table.
	 * 
	 * @param filterAa00j04s01
	 *            Aa00j04s01
	 * @param searchAa00j04s01
	 *            Aa00j04s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j04s01>>
	 */
	public List<TableRowDto<Aa00j04s01>> search(Aa00j04s01 filterAa00j04s01,
			Aa00j04s01 searchAa00j04s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return this.aa00j04s01Dao.search(filterAa00j04s01, searchAa00j04s01,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Aa00j04s01 table.
	 * 
	 * @param filterAa00j04s01
	 *            Aa00j04s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	public Object reorderSelection(Aa00j04s01 filterAa00j04s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.aa00j04s01Dao.reorderSelection(filterAa00j04s01,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Aa00j04s01 table.
	 * 
	 * @param filterAa00j04s01
	 *            Aa00j04s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<JerarquiaDto<Aa00j04s01>>
	 */
	public JQGridResponseDto<JerarquiaDto<Aa00j04s01>> jerarquia(
			Aa00j04s01 filterAa00j04s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		List<JerarquiaDto<Aa00j04s01>> listaAa00j04s01 = this.aa00j04s01Dao
				.findAllLikeJerarquia(filterAa00j04s01, jqGridRequestDto);
		Long recordNum = this.aa00j04s01Dao.findAllLikeCountJerarquia(
				filterAa00j04s01, jqGridRequestDto);
		return new JQGridResponseDto<JerarquiaDto<Aa00j04s01>>(
				jqGridRequestDto, recordNum, listaAa00j04s01);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the Aa00j04s01 table.
	 * 
	 * @param filterAa00j04s01
	 *            Aa00j04s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return JQGridResponseDto<JerarquiaDto<Aa00j04s01>>
	 */
	public JQGridResponseDto<JerarquiaDto<Aa00j04s01>> jerarquiaChildren(
			Aa00j04s01 filterAa00j04s01, JQGridRequestDto jqGridRequestDto) {
		JQGridResponseDto<JerarquiaDto<Aa00j04s01>> jqGridResponseDto = new JQGridResponseDto<JerarquiaDto<Aa00j04s01>>();
		jqGridResponseDto.addAdditionalParam(JQGridResponseDto.CHILDREN,
				this.aa00j04s01Dao.findAllChild(filterAa00j04s01,
						jqGridRequestDto));
		return jqGridResponseDto;
	}

	public List<Aa00j04s01> obtenerCombo() {
		return (List<Aa00j04s01>) this.aa00j04s01Dao.obtenerCombo();
	}

	@Transactional(rollbackFor = Throwable.class)
	public String anyadir(String titulo, String textoEs, String textoEu) {
		try {
			// 1º Comprobamos que se haya introducido algún titulo para el nuevo
			// texto reserva
			if (titulo.trim().length() <= 0) {
				return this.appMessageSource.getMessage(
						"etTituloTextoReservaObligatorio", null,
						LocaleContextHolder.getLocale());
			} else {
				// 2º Comprobamos que no exista
				if (this.aa00j04s01Dao.existe(titulo.trim(), null)) {
					return this.appMessageSource.getMessage(
							"etYaExisteTextoReserva", null,
							LocaleContextHolder.getLocale());
				} else {
					// 3º Lo insertamos
					Aa00j04s01 aa00j04s01 = this.aa00j04s01Dao.anyadir(titulo,
							textoEs, textoEu);
					if (aa00j04s01 != null && aa00j04s01.getCtexto04() > 0) {
						return aa00j04s01.getCtexto04().toString();
					} else {
						return this.appMessageSource.getMessage(
								"etErrorCrearTextoReserva", null,
								LocaleContextHolder.getLocale());
					}
				}
			}
		} catch (Exception e) {
			return this.appMessageSource.getMessage("etErrorCrearTextoReserva",
					null, LocaleContextHolder.getLocale());
		}
	}

	/**
	 * Modifica la situacion de los registros ids en la tabla
	 * 
	 * 
	 * @param ids
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public boolean cambiarSituacion(String ids) {
		return this.comunDao.cambiarSituacion("04", "ctexto04", ids);
	}

	public boolean bloquear(Long ctexto04) {

		return this.comunDao.bloquear("ctexto04", ctexto04.toString());
	}

	public boolean desbloquear(Long ctexto04) {

		return this.comunDao.desbloquear("ctexto04", ctexto04.toString());
	}
}