package com.ejie.aa00j.service;

import com.ejie.aa00j.dao.Aa00j03s01Dao;
import com.ejie.aa00j.dao.Aa00j10s01Dao;
import com.ejie.aa00j.dao.Aa00j13s01Dao;
import com.ejie.aa00j.dao.ComunDao;
import com.ejie.aa00j.model.Aa00j05s01;
import com.ejie.aa00j.model.Option;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.dto.TableRowDto;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa00j.model.Aa00j03s01;

/**
 * Aa00j03s01ServiceImpl generated by UDA, 16-oct-2013 13:02:12.
 * 
 * @author UDA
 */

@Service(value = "aa00j03s01Service")
public class Aa00j03s01ServiceImpl implements Aa00j03s01Service {

	@Autowired
	private ReloadableResourceBundleMessageSource appMessageSource;

	@Autowired
	private ComunDao comunDao;

	@Autowired
	private Aa00j03s01Dao aa00j03s01Dao;

	@Autowired
	private Aa00j10s01Dao aa00j10s01Dao;

	@Autowired
	private Aa00j13s01Dao aa00j13s01Dao;

	/**
	 * Inserts a single row in the Aa00j03s01 table.
	 * 
	 * @param aa00j03s01
	 *            Aa00j03s01
	 * @return Aa00j03s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa00j03s01 add(Aa00j03s01 aa00j03s01) throws Exception {
		String mensaje = "etErrorCrearEdificio";
		try {
			// 1º Comprobamos que se haya introducido algún nombre para el nuevo
			// edificio
			if (aa00j03s01.getNombre03().trim().length() <= 0) {
				mensaje = "etNombreEdificioObligatorio";
				throw new Exception();
			} else {
				// 2º Comprobamos que no exista
				if (this.aa00j03s01Dao.existe(aa00j03s01.getNombre03().trim(),
						null)) {
					mensaje = "etYaExisteEdificio";
					throw new Exception();
				} else {
					// 3º Lo insertamos
					Aa00j03s01 ret = null;
					ret = this.aa00j03s01Dao.add(aa00j03s01);
					ret = this.aa00j03s01Dao.addAa00j09s01(aa00j03s01);
					return ret;
				}
			}
		} catch (Exception e) {
			throw new Exception(this.appMessageSource.getMessage(mensaje, null,
					LocaleContextHolder.getLocale()));
		}
	}

	/**
	 * Updates a single row in the Aa00j03s01 table.
	 * 
	 * @param aa00j03s01
	 *            Aa00j03s01
	 * @return Aa00j03s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa00j03s01 update(Aa00j03s01 aa00j03s01) throws Exception {
		String mensaje = "etErrorActualizarSitio";
		try {
			// 1º Comprobamos que se haya introducido algún nombre para el nuevo
			// sitio
			if (aa00j03s01.getNombre03().trim().length() <= 0) {
				mensaje = "etNombreSitioObligatorio";
				throw new Exception();
			} else {
				// 2º Comprobamos que no exista
				if (this.aa00j03s01Dao.existe(aa00j03s01.getNombre03().trim(),
						aa00j03s01.getCedif03())) {
					mensaje = "etYaExisteSitio";
					throw new Exception();
				} else {
					// 3º Lo actualizamos
					aa00j03s01 = this.aa00j03s01Dao.update(aa00j03s01);
					this.aa00j03s01Dao
							.removeAa00j09s01(aa00j03s01.getCedif03());
					aa00j03s01 = this.aa00j03s01Dao.addAa00j09s01(aa00j03s01);
					return aa00j03s01;
				}
			}
		} catch (Exception e) {
			throw new Exception(this.appMessageSource.getMessage(mensaje, null,
					LocaleContextHolder.getLocale()));
		}
	}

	/**
	 * Finds a single row in the Aa00j03s01 table.
	 * 
	 * @param aa00j03s01
	 *            Aa00j03s01
	 * @return Aa00j03s01
	 */
	public Aa00j03s01 find(Aa00j03s01 aa00j03s01) {
		return (Aa00j03s01) this.aa00j03s01Dao.find(aa00j03s01);
	}

	/**
	 * Deletes a single row in the Aa00j03s01 table.
	 * 
	 * @param aa00j03s01
	 *            Aa00j03s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Aa00j03s01 aa00j03s01) throws Exception {
		String mensaje = "etErrorBorrarEdificio";
		try {
			// 1º Comprobamos que no exista ningún Recurso general para este
			// edificio
			if (this.aa00j13s01Dao.existeEdificio(aa00j03s01.getCedif03())) {
				mensaje = "etExisteRecursoGeneralEdificio";
				throw new Exception();
				// 2º Comprobamos que no exista ninguna Sala para este edificio
			} else if (this.aa00j10s01Dao.existeEdificio(aa00j03s01
					.getCedif03())) {
				mensaje = "etExisteSalaEdificio";
				throw new Exception();
			} else {
				// 3º La borramos
				this.aa00j03s01Dao.removeAa00j09s01(aa00j03s01.getCedif03());
				this.aa00j03s01Dao.remove(aa00j03s01);
			}
		} catch (Exception e) {
			throw new Exception(this.appMessageSource.getMessage(mensaje, null,
					LocaleContextHolder.getLocale()));
		}
	}

	/**
	 * Finds a list of rows in the Aa00j03s01 table.
	 * 
	 * @param aa00j03s01
	 *            Aa00j03s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa00j03s01>
	 */
	public List<Aa00j03s01> findAll(Aa00j03s01 aa00j03s01,
			JQGridRequestDto jqGridRequestDto) {
		return (List<Aa00j03s01>) this.aa00j03s01Dao.findAll(aa00j03s01,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the Aa00j03s01 table using like.
	 * 
	 * @param aa00j03s01
	 *            Aa00j03s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa00j03s01>
	 */
	public List<Aa00j03s01> findAllLike(Aa00j03s01 aa00j03s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<Aa00j03s01>) this.aa00j03s01Dao.findAllLike(aa00j03s01,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Devuelve una lista de edificios con sus situaciones
	 * 
	 * @return
	 */
	public List<Option> getListForOption(boolean conSalas,
			boolean controlarRespEdif) {
		return this.aa00j03s01Dao.getListForOption(conSalas, controlarRespEdif);

	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Aa00j03s01 table.
	 * 
	 * @param filterAa00j03s01
	 *            Aa00j03s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	public void removeMultiple(Aa00j03s01 filterAa00j03s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith)
			throws Exception {
		String mensajeError = "etErrorBorrarEdificio";
		String mensajeExisteRecurso = "etExisteRecursoGeneralEdificio";
		String mensajeExisteSala = "etExisteSalaEdificio";
		String strError = "";
		String strExisteRecurso = "";
		String strExisteSala = "";

		if (jqGridRequestDto != null
				&& jqGridRequestDto.getMultiselection() != null
				&& jqGridRequestDto.getMultiselection().getSelected(
						Aa00j03s01.class) != null) {
			for (Aa00j03s01 selected : jqGridRequestDto.getMultiselection()
					.getSelected(Aa00j03s01.class)) {
				try {
					// 1º Comprobamos que no exista ningún Recurso general para
					// este
					// edificio
					if (this.aa00j13s01Dao
							.existeEdificio(selected.getCedif03())) {
						strExisteRecurso = strExisteRecurso
								.concat("<br/>")
								.concat("-")
								.concat(this.aa00j03s01Dao.find(selected)
										.getNombre03());
						// 2º Comprobamos que no exista ninguna Sala para este
						// edificio
					} else if (this.aa00j10s01Dao.existeEdificio(selected
							.getCedif03())) {
						strExisteSala = strExisteSala
								.concat("<br/>")
								.concat("-")
								.concat(this.aa00j03s01Dao.find(selected)
										.getNombre03());
					} else {
						// 3º La borramos
						this.aa00j03s01Dao.removeAa00j09s01(selected
								.getCedif03());
						this.aa00j03s01Dao.remove(selected);
					}
				} catch (Exception e) {
					strError = strError
							.concat("<br/>")
							.concat("-")
							.concat(this.aa00j03s01Dao.find(selected)
									.getNombre03());
				}
			}
		}

		if (strExisteRecurso.length() > 0 || strExisteSala.length() > 0
				|| strError.length() > 0) {
			String mensaje = "";
			if (strExisteRecurso.length() > 0) {
				mensaje = mensaje
						.concat(this.appMessageSource.getMessage(
								mensajeExisteRecurso, null,
								LocaleContextHolder.getLocale())).concat(":")
						.concat(strExisteRecurso);
			}
			if (strExisteSala.length() > 0) {
				if (mensaje.length() > 0) {
					mensaje = mensaje.concat("<br/><br/>");
				}
				mensaje = mensaje
						.concat(this.appMessageSource.getMessage(
								mensajeExisteSala, null,
								LocaleContextHolder.getLocale())).concat(":")
						.concat(strExisteSala);
			}
			if (strError.length() > 0) {
				if (mensaje.length() > 0) {
					mensaje = mensaje.concat("<br/><br/>");
				}
				mensaje = mensaje
						.concat(this.appMessageSource.getMessage(mensajeError,
								null, LocaleContextHolder.getLocale()))
						.concat(":").concat(strError);
			}
			throw new Exception(mensaje);
		}
	}

	/**
	 * Filter method in the Aa00j03s01 table.
	 * 
	 * @param filterAa00j03s01
	 *            Aa00j03s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<Aa00j03s01>
	 */
	public JQGridResponseDto<Aa00j03s01> filter(Aa00j03s01 filterAa00j03s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<Aa00j03s01> listaAa00j03s01 = this.aa00j03s01Dao.findAllLike(
				filterAa00j03s01, jqGridRequestDto, false);
		Long recordNum = this.aa00j03s01Dao.findAllLikeCount(
				filterAa00j03s01 != null ? filterAa00j03s01 : new Aa00j03s01(),
				false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Aa00j03s01>> reorderSelection = this.aa00j03s01Dao
					.reorderSelection(filterAa00j03s01, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<Aa00j03s01>(jqGridRequestDto,
					recordNum, listaAa00j03s01, reorderSelection);
		}
		return new JQGridResponseDto<Aa00j03s01>(jqGridRequestDto, recordNum,
				listaAa00j03s01);
	}

	/**
	 * Searches rows in the Aa00j03s01 table.
	 * 
	 * @param filterAa00j03s01
	 *            Aa00j03s01
	 * @param searchAa00j03s01
	 *            Aa00j03s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j03s01>>
	 */
	public List<TableRowDto<Aa00j03s01>> search(Aa00j03s01 filterAa00j03s01,
			Aa00j03s01 searchAa00j03s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return this.aa00j03s01Dao.search(filterAa00j03s01, searchAa00j03s01,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Aa00j03s01 table.
	 * 
	 * @param filterAa00j03s01
	 *            Aa00j03s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	public Object reorderSelection(Aa00j03s01 filterAa00j03s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.aa00j03s01Dao.reorderSelection(filterAa00j03s01,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Aa00j03s01 table.
	 * 
	 * @param filterAa00j03s01
	 *            Aa00j03s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<JerarquiaDto<Aa00j03s01>>
	 */
	public JQGridResponseDto<JerarquiaDto<Aa00j03s01>> jerarquia(
			Aa00j03s01 filterAa00j03s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		List<JerarquiaDto<Aa00j03s01>> listaAa00j03s01 = this.aa00j03s01Dao
				.findAllLikeJerarquia(filterAa00j03s01, jqGridRequestDto);
		Long recordNum = this.aa00j03s01Dao.findAllLikeCountJerarquia(
				filterAa00j03s01, jqGridRequestDto);
		return new JQGridResponseDto<JerarquiaDto<Aa00j03s01>>(
				jqGridRequestDto, recordNum, listaAa00j03s01);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the Aa00j03s01 table.
	 * 
	 * @param filterAa00j03s01
	 *            Aa00j03s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return JQGridResponseDto<JerarquiaDto<Aa00j03s01>>
	 */
	public JQGridResponseDto<JerarquiaDto<Aa00j03s01>> jerarquiaChildren(
			Aa00j03s01 filterAa00j03s01, JQGridRequestDto jqGridRequestDto) {
		JQGridResponseDto<JerarquiaDto<Aa00j03s01>> jqGridResponseDto = new JQGridResponseDto<JerarquiaDto<Aa00j03s01>>();
		jqGridResponseDto.addAdditionalParam(JQGridResponseDto.CHILDREN,
				this.aa00j03s01Dao.findAllChild(filterAa00j03s01,
						jqGridRequestDto));
		return jqGridResponseDto;
	}

	/**
	 * Inserts a single row in the Aa00j09s01 table.
	 * 
	 * @param aa00j03s01
	 *            Aa00j03s01
	 * @return Aa00j03s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa00j03s01 addAa00j09s01(Aa00j03s01 aa00j03s01) {
		return this.aa00j03s01Dao.addAa00j09s01(aa00j03s01);
	}

	/**
	 * Deletes a single row in the Aa00j09s01 table.
	 * 
	 * @param aa00j03s01
	 *            Aa00j03s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeAa00j09s01(Aa00j03s01 aa00j03s01) {
		this.aa00j03s01Dao.removeAa00j09s01(aa00j03s01);
	}

	/**
	 * Find a single row in the findAa00j09s01 Many To Many relationship.
	 * 
	 * @param aa00j03s01
	 *            Aa00j03s01
	 * @param aa00j05s01
	 *            Aa00j05s01
	 * @param pagination
	 *            Pagination
	 * @return Aa00j03s01
	 */
	public Aa00j03s01 findAa00j09s01(Aa00j03s01 aa00j03s01,
			Aa00j05s01 aa00j05s01, Pagination pagination) {
		return this.aa00j03s01Dao.findAa00j09s01(aa00j03s01, aa00j05s01,
				pagination);
	}

	/**
	 * Counts rows in the Aa00j09s01 table.
	 * 
	 * @param aa00j03s01
	 *            Aa00j03s01
	 * @param aa00j05s01
	 *            Aa00j05s01
	 * @return Long
	 */
	public Long findAa00j09s01Count(Aa00j03s01 aa00j03s01, Aa00j05s01 aa00j05s01) {
		return this.aa00j03s01Dao.findAa00j09s01Count(aa00j03s01, aa00j05s01);
	}

	public boolean bloquear(Long cedif03) {

		return this.comunDao.bloquear("cedif03", cedif03.toString());
	}

	public boolean desbloquear(Long cedif03) {

		return this.comunDao.desbloquear("cedif03", cedif03.toString());
	}

	public List<Aa00j03s01> obtenerCombo() {
		return (List<Aa00j03s01>) this.aa00j03s01Dao.obtenerCombo();
	}

	public Long obtenerEdificioResponsable(String cresp09) {
		Long ret = (long) -1;
		try {

			ret = this.aa00j03s01Dao.obtenerEdificioResponsable(cresp09);
		} catch (Exception e) {
			ret = (long) -1;
		}
		return ret;
	}

	/**
	 * Devuelve los edificios en los que hay salas que tienen que aparecer en un
	 * listado especial de edificios
	 * 
	 * @return
	 */
	public List<Option> obtenerComboListado() {
		return this.aa00j03s01Dao.obtenerComboListado();
	}

	/**
	 * Modifica la situacion de los registros ids en la tabla
	 * 
	 * 
	 * @param ids
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public boolean cambiarSituacion(String ids) {
		return this.comunDao.cambiarSituacion("03", "CEDIF03", ids);
	}
}