package com.ejie.aa00j.service;

import com.ejie.aa00j.dao.Aa00j02s01Dao;
import com.ejie.aa00j.dao.Aa00j03s01Dao;
import com.ejie.aa00j.dao.ComunDao;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa00j.model.Aa00j02s01;

/**
 * Aa00j02s01ServiceImpl generated by UDA, 16-oct-2013 13:02:12.
 * 
 * @author UDA
 */

@Service(value = "aa00j02s01Service")
public class Aa00j02s01ServiceImpl implements Aa00j02s01Service {
	private static final Logger logger = LoggerFactory
			.getLogger(Aa00j02s01ServiceImpl.class);
	@Autowired
	private ReloadableResourceBundleMessageSource appMessageSource;

	@Autowired
	private ComunDao comunDao;

	@Autowired
	private Aa00j02s01Dao aa00j02s01Dao;

	@Autowired
	private Aa00j03s01Dao aa00j03s01Dao;

	/**
	 * Inserts a single row in the Aa00j02s01 table.
	 * 
	 * @param aa00j02s01
	 *            Aa00j02s01
	 * @return Aa00j02s01
	 * @throws Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa00j02s01 add(Aa00j02s01 aa00j02s01) throws Exception {
		String mensaje = "etErrorCrearSitio";
		Aa00j02s01ServiceImpl.logger.info("add");
		try {
			// 1º Comprobamos que se haya introducido algún nombre para el nuevo
			// sitio
			if (aa00j02s01.getNombre02().trim().length() <= 0) {
				mensaje = "etNombreSitioObligatorio";
				throw new Exception();
			} else {
				// 2º Comprobamos que no exista
				if (this.aa00j02s01Dao.existe(aa00j02s01.getNombre02().trim(),
						null)) {
					mensaje = "etYaExisteSitio";
					throw new Exception();
				} else {
					// 3º Lo insertamos
					return this.aa00j02s01Dao.add(aa00j02s01);
				}
			}
		} catch (Exception e) {
			Aa00j02s01ServiceImpl.logger.info("Error ");
			throw new Exception(this.appMessageSource.getMessage(mensaje, null,
					LocaleContextHolder.getLocale()));
		}
	}

	/**
	 * Updates a single row in the Aa00j02s01 table.
	 * 
	 * @param aa00j02s01
	 *            Aa00j02s01
	 * @return Aa00j02s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa00j02s01 update(Aa00j02s01 aa00j02s01) throws Exception {
		Aa00j02s01ServiceImpl.logger.info("update");
		String mensaje = "etErrorActualizarSitio";
		try {
			// 1º Comprobamos que se haya introducido algún nombre para el nuevo
			// sitio
			if (aa00j02s01.getNombre02().trim().length() <= 0) {
				mensaje = "etNombreSitioObligatorio";
				throw new Exception();
			} else {
				// 2º Comprobamos que no exista
				if (this.aa00j02s01Dao.existe(aa00j02s01.getNombre02().trim(),
						aa00j02s01.getCsitio02())) {
					mensaje = "etYaExisteSitio";
					throw new Exception();
				} else {
					// 3º Lo actualizamos
					return this.aa00j02s01Dao.update(aa00j02s01);
				}
			}
		} catch (Exception e) {
			Aa00j02s01ServiceImpl.logger.info("Error");
			throw new Exception(this.appMessageSource.getMessage(mensaje, null,
					LocaleContextHolder.getLocale()));
		}
	}

	/**
	 * Finds a single row in the Aa00j02s01 table.
	 * 
	 * @param aa00j02s01
	 *            Aa00j02s01
	 * @return Aa00j02s01
	 */
	public Aa00j02s01 find(Aa00j02s01 aa00j02s01) {
		Aa00j02s01ServiceImpl.logger.info("find");
		return (Aa00j02s01) this.aa00j02s01Dao.find(aa00j02s01);
	}

	/**
	 * Deletes a single row in the Aa00j02s01 table.
	 * 
	 * @param aa00j02s01
	 *            Aa00j02s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Aa00j02s01 aa00j02s01) throws Exception {
		String mensaje = "etErrorBorrarSitio";
		try {
			Aa00j02s01ServiceImpl.logger.info("remove");
			// 1º Comprobamos que no exista ningún edificio para este sitio /
			// ubicación
			if (this.aa00j03s01Dao.existeSitio(aa00j02s01.getCsitio02())) {
				mensaje = "etExisteEdificioSitio";
				throw new Exception();
			} else {
				// 2º La borramos
				this.aa00j02s01Dao.remove(aa00j02s01);
			}
		} catch (Exception e) {
			Aa00j02s01ServiceImpl.logger.info("error");
			throw new Exception(this.appMessageSource.getMessage(mensaje, null,
					LocaleContextHolder.getLocale()));
		}
	}

	/**
	 * Finds a list of rows in the Aa00j02s01 table.
	 * 
	 * @param aa00j02s01
	 *            Aa00j02s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa00j02s01>
	 */
	public List<Aa00j02s01> findAll(Aa00j02s01 aa00j02s01,
			JQGridRequestDto jqGridRequestDto) {
		Aa00j02s01ServiceImpl.logger.info("find all");
		return (List<Aa00j02s01>) this.aa00j02s01Dao.findAll(aa00j02s01,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the Aa00j02s01 table using like.
	 * 
	 * @param aa00j02s01
	 *            Aa00j02s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa00j02s01>
	 */
	public List<Aa00j02s01> findAllLike(Aa00j02s01 aa00j02s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		Aa00j02s01ServiceImpl.logger.info("find all like");
		return (List<Aa00j02s01>) this.aa00j02s01Dao.findAllLike(aa00j02s01,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Aa00j02s01 table.
	 * 
	 * @param filterAa00j02s01
	 *            Aa00j02s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	public void removeMultiple(Aa00j02s01 filterAa00j02s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith)
			throws Exception {
		Aa00j02s01ServiceImpl.logger.info("removeMultiple");
		String mensajeError = "etErrorBorrarSitio";
		String mensajeExiste = "etExisteEdificioSitio";
		String strError = "";
		String strExiste = "";

		if (jqGridRequestDto != null
				&& jqGridRequestDto.getMultiselection() != null
				&& jqGridRequestDto.getMultiselection().getSelected(
						Aa00j02s01.class) != null) {
			for (Aa00j02s01 selected : jqGridRequestDto.getMultiselection()
					.getSelected(Aa00j02s01.class)) {
				try {
					// 1º Comprobamos que no exista ningún edificio para este
					// sitio / ubicación
					if (this.aa00j03s01Dao.existeSitio(selected.getCsitio02())) {
						strExiste = strExiste
								.concat("<br/>")
								.concat("-")
								.concat(this.aa00j02s01Dao.find(selected)
										.getNombre02());
					} else {
						// 2º La borramos
						this.aa00j02s01Dao.remove(selected);
					}
				} catch (Exception e) {
					strError = strError
							.concat("<br/>")
							.concat("-")
							.concat(this.aa00j02s01Dao.find(selected)
									.getNombre02());
				}
			}
		}

		if (strExiste.length() > 0 || strError.length() > 0) {
			String mensaje = "";
			if (strExiste.length() > 0) {
				mensaje = mensaje
						.concat(this.appMessageSource.getMessage(mensajeExiste,
								null, LocaleContextHolder.getLocale()))
						.concat(":").concat(strExiste);
			}
			if (strError.length() > 0) {
				if (mensaje.length() > 0) {
					mensaje = mensaje.concat("<br/><br/>");
				}
				mensaje = mensaje
						.concat(this.appMessageSource.getMessage(mensajeError,
								null, LocaleContextHolder.getLocale()))
						.concat(":").concat(strError);
			}
			throw new Exception(mensaje);
		}
	}

	/**
	 * Filter method in the Aa00j02s01 table.
	 * 
	 * @param filterAa00j02s01
	 *            Aa00j02s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<Aa00j02s01>
	 */
	public JQGridResponseDto<Aa00j02s01> filter(Aa00j02s01 filterAa00j02s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		Aa00j02s01ServiceImpl.logger.info("filter");
		List<Aa00j02s01> listaAa00j02s01 = this.aa00j02s01Dao.findAllLike(
				filterAa00j02s01, jqGridRequestDto, false);
		Long recordNum = this.aa00j02s01Dao.findAllLikeCount(
				filterAa00j02s01 != null ? filterAa00j02s01 : new Aa00j02s01(),
				false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Aa00j02s01>> reorderSelection = this.aa00j02s01Dao
					.reorderSelection(filterAa00j02s01, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<Aa00j02s01>(jqGridRequestDto,
					recordNum, listaAa00j02s01, reorderSelection);
		}
		return new JQGridResponseDto<Aa00j02s01>(jqGridRequestDto, recordNum,
				listaAa00j02s01);
	}

	/**
	 * Searches rows in the Aa00j02s01 table.
	 * 
	 * @param filterAa00j02s01
	 *            Aa00j02s01
	 * @param searchAa00j02s01
	 *            Aa00j02s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j02s01>>
	 */
	public List<TableRowDto<Aa00j02s01>> search(Aa00j02s01 filterAa00j02s01,
			Aa00j02s01 searchAa00j02s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		Aa00j02s01ServiceImpl.logger.info("search");
		return this.aa00j02s01Dao.search(filterAa00j02s01, searchAa00j02s01,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Aa00j02s01 table.
	 * 
	 * @param filterAa00j02s01
	 *            Aa00j02s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	public Object reorderSelection(Aa00j02s01 filterAa00j02s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		Aa00j02s01ServiceImpl.logger.info("reorderSelection");
		return this.aa00j02s01Dao.reorderSelection(filterAa00j02s01,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Aa00j02s01 table.
	 * 
	 * @param filterAa00j02s01
	 *            Aa00j02s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<JerarquiaDto<Aa00j02s01>>
	 */
	public JQGridResponseDto<JerarquiaDto<Aa00j02s01>> jerarquia(
			Aa00j02s01 filterAa00j02s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		Aa00j02s01ServiceImpl.logger.info("jerarquia");
		List<JerarquiaDto<Aa00j02s01>> listaAa00j02s01 = this.aa00j02s01Dao
				.findAllLikeJerarquia(filterAa00j02s01, jqGridRequestDto);
		Long recordNum = this.aa00j02s01Dao.findAllLikeCountJerarquia(
				filterAa00j02s01, jqGridRequestDto);
		return new JQGridResponseDto<JerarquiaDto<Aa00j02s01>>(
				jqGridRequestDto, recordNum, listaAa00j02s01);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the Aa00j02s01 table.
	 * 
	 * @param filterAa00j02s01
	 *            Aa00j02s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return JQGridResponseDto<JerarquiaDto<Aa00j02s01>>
	 */
	public JQGridResponseDto<JerarquiaDto<Aa00j02s01>> jerarquiaChildren(
			Aa00j02s01 filterAa00j02s01, JQGridRequestDto jqGridRequestDto) {
		Aa00j02s01ServiceImpl.logger.info("jerarquiaChildren");
		JQGridResponseDto<JerarquiaDto<Aa00j02s01>> jqGridResponseDto = new JQGridResponseDto<JerarquiaDto<Aa00j02s01>>();
		jqGridResponseDto.addAdditionalParam(JQGridResponseDto.CHILDREN,
				this.aa00j02s01Dao.findAllChild(filterAa00j02s01,
						jqGridRequestDto));
		return jqGridResponseDto;
	}

	public boolean bloquear(Long csitio02) {
		Aa00j02s01ServiceImpl.logger.info("bloquear");
		return this.comunDao.bloquear("csitio02", csitio02.toString());
	}

	public boolean desbloquear(Long csitio02) {
		Aa00j02s01ServiceImpl.logger.info("desbloquear");
		return this.comunDao.desbloquear("csitio02", csitio02.toString());
	}

	public List<Aa00j02s01> obtenerCombo() {
		Aa00j02s01ServiceImpl.logger.info("obtenerCombo");
		return (List<Aa00j02s01>) this.aa00j02s01Dao.obtenerCombo();
	}

	@Transactional(rollbackFor = Throwable.class)
	public String anyadir(String nombre) {
		Aa00j02s01ServiceImpl.logger.info("añadir");
		try {
			// 1º Comprobamos que se haya introducido algún nombre para el nuevo
			// sitio
			if (nombre.trim().length() <= 0) {
				return this.appMessageSource.getMessage(
						"etNombreSitioObligatorio", null,
						LocaleContextHolder.getLocale());
			} else {
				// 2º Comprobamos que no exista
				if (this.aa00j02s01Dao.existe(nombre.trim(), null)) {
					return this.appMessageSource.getMessage("etYaExisteSitio",
							null, LocaleContextHolder.getLocale());
				} else {
					// 3º Lo insertamos
					Aa00j02s01 aa00j02s01 = this.aa00j02s01Dao.anyadir(nombre);
					if (aa00j02s01 != null && aa00j02s01.getCsitio02() > 0) {
						return aa00j02s01.getCsitio02().toString();
					} else {
						return this.appMessageSource.getMessage(
								"etErrorCrearSitio", null,
								LocaleContextHolder.getLocale());
					}
				}
			}
		} catch (Exception e) {
			return this.appMessageSource.getMessage("etErrorCrearSitio", null,
					LocaleContextHolder.getLocale());
		}
	}

	/**
	 * Modifica la situacion de los registros ids en la tabla
	 * 
	 * 
	 * @param ids
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public boolean cambiarSituacion(String ids) {
		return this.comunDao.cambiarSituacion("02", "CSITIO02", ids);
	}
}