package com.ejie.aa00j.model;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

import javax.xml.parsers.ParserConfigurationException;

import org.springframework.context.i18n.LocaleContextHolder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * Representación dela reserva de una sala, con los recursos.
 * 
 * @author iaizpurl
 * 
 */
public class SalaReserva implements ImprimibleEnPdf {
	private int codReserva;
	private int codSala;
	private String departamento;

	private Date fecha;

	private String horaFin;

	private String horaInicio;

	private String observaciones;

	private String recursosFijo;

	private String recursosMoviles;

	private String responsable;
	private String nombreSala;
	private String telefono;
	private String asunto;

	/**
	 * @return the telefono
	 */
	public String getTelefono() {
		return telefono;
	}

	/**
	 * @param telefono
	 *            the telefono to set
	 */
	public void setTelefono(String telefono) {
		this.telefono = telefono;
	}

	/**
	 * @return the asunto
	 */
	public String getAsunto() {
		return asunto;
	}

	/**
	 * @param asunto
	 *            the asunto to set
	 */
	public void setAsunto(String asunto) {
		this.asunto = asunto;
	}

	/**
	 * @return the nombreSala
	 */
	public String getNombreSala() {
		return nombreSala;
	}

	/**
	 * @param nombreSala
	 *            the nombreSala to set
	 */
	public void setNombreSala(String nombreSala) {
		this.nombreSala = nombreSala;
	}

	/**
	 * @return the codReserva
	 */
	public int getCodReserva() {
		return codReserva;
	}

	/**
	 * @return the codSala
	 */
	public int getCodSala() {
		return codSala;
	}

	/**
	 * @return the departamento
	 */
	public String getDepartamento() {
		return departamento;
	}

	/**
	 * @return the fecha
	 */
	public Date getFecha() {
		return fecha;
	}

	/**
	 * @return the horaFin
	 */
	public String getHoraFin() {
		return horaFin;
	}

	/**
	 * @return the horaInicio
	 */
	public String getHoraInicio() {
		return horaInicio;
	}

	/**
	 * @return the observaciones
	 */
	public String getObservaciones() {
		return observaciones;
	}

	/**
	 * @return the recursosFijo
	 */
	public String getRecursosFijo() {
		return recursosFijo;
	}

	/**
	 * @return the recursosMoviles
	 */
	public String getRecursosMoviles() {
		return recursosMoviles;
	}

	/**
	 * @return the responsable
	 */
	public String getResponsable() {
		return responsable;
	}

	/**
	 * @param codReserva
	 *            the codReserva to set
	 */
	public void setCodReserva(int codReserva) {
		this.codReserva = codReserva;
	}

	/**
	 * @param codSala
	 *            the codSala to set
	 */
	public void setCodSala(int codSala) {
		this.codSala = codSala;
	}

	/**
	 * @param departamento
	 *            the departamento to set
	 */
	public void setDepartamento(String departamento) {
		this.departamento = departamento;
	}

	/**
	 * @param fecha
	 *            the fecha to set
	 */
	public void setFecha(Date fecha) {
		this.fecha = fecha;
	}

	/**
	 * @param horaFin
	 *            the horaFin to set
	 */
	public void setHoraFin(String horaFin) {
		this.horaFin = horaFin;
	}

	/**
	 * @param horaInicio
	 *            the horaInicio to set
	 */
	public void setHoraInicio(String horaInicio) {
		this.horaInicio = horaInicio;
	}

	/**
	 * @param observaciones
	 *            the observaciones to set
	 */
	public void setObservaciones(String observaciones) {
		this.observaciones = observaciones;
	}

	/**
	 * @param recursosFijo
	 *            the recursosFijo to set
	 */
	public void setRecursosFijo(String recursosFijo) {
		this.recursosFijo = recursosFijo;
	}

	/**
	 * @param recursosMoviles
	 *            the recursosMoviles to set
	 */
	public void setRecursosMoviles(String recursosMoviles) {
		this.recursosMoviles = recursosMoviles;
	}

	/**
	 * @param responsable
	 *            the responsable to set
	 */
	public void setResponsable(String responsable) {
		this.responsable = responsable;
	}

	@Override
	public Element toXML(Document doc) throws ParserConfigurationException {
		Locale locale = LocaleContextHolder.getLocale();
		// TODO Auto-generated method stub
		String localeStr;
		if (locale.getLanguage().contains("eu"))
			localeStr = "yyyy/MM/dd";
		else
			localeStr = "dd/MM/yyyy";
		DateFormat df = new SimpleDateFormat(localeStr);

		Element rootElement = doc.createElement("elemento");
		Element elemento;

		elemento = doc.createElement("nombreSala");
		if (this.nombreSala != null)
			elemento.appendChild(doc.createTextNode(this.nombreSala));
		else
			elemento.appendChild(doc.createTextNode(" "));
		rootElement.appendChild(elemento);
		elemento = doc.createElement("departamento");
		if (this.departamento != null)
			elemento.appendChild(doc.createTextNode(this.departamento));
		else
			elemento.appendChild(doc.createTextNode(" "));
		rootElement.appendChild(elemento);
		elemento = doc.createElement("asunto");
		if (this.asunto != null)
			elemento.appendChild(doc.createTextNode(this.asunto));
		else
			elemento.appendChild(doc.createTextNode(" "));
		rootElement.appendChild(elemento);
		elemento = doc.createElement("responsable");
		if (this.responsable != null)
			elemento.appendChild(doc.createTextNode(this.responsable));
		else
			elemento.appendChild(doc.createTextNode(" "));
		rootElement.appendChild(elemento);
		elemento = doc.createElement("telefono");
		if (this.telefono != null)
			elemento.appendChild(doc.createTextNode(this.telefono));
		else
			elemento.appendChild(doc.createTextNode(" "));
		rootElement.appendChild(elemento);
		elemento = doc.createElement("horaInicio");
		if (this.horaInicio != null)
			elemento.appendChild(doc.createTextNode(this.horaInicio));
		else
			elemento.appendChild(doc.createTextNode(" "));
		rootElement.appendChild(elemento);
		elemento = doc.createElement("horaFin");
		if (this.horaFin != null)
			elemento.appendChild(doc.createTextNode(this.horaFin));
		else
			elemento.appendChild(doc.createTextNode(" "));
		rootElement.appendChild(elemento);
		elemento = doc.createElement("codReserva");
		elemento.appendChild(doc.createTextNode(this.codReserva + ""));

		rootElement.appendChild(elemento);
		elemento = doc.createElement("fecha");
		if (this.fecha != null)
			elemento.appendChild(doc.createTextNode(df.format(this.fecha)));
		else
			elemento.appendChild(doc.createTextNode(" "));
		rootElement.appendChild(elemento);

		return rootElement;

	}
}
