package com.ejie.aa00j.ldap;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import n38a.exe.N38APISesion;
import n38c.exe.N38API;
import n38c.exe.N38Estructura;

import org.apache.xpath.XPathAPI;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

import com.ejie.aa00j.classes.aa00jConstantes;

import com.ejie.x38.security.UserCredentials;
import org.w3c.dom.Node;

/**
 * Clase auxiliar para tratar con LDAP
 */
public class SecurityHelpperXLNets implements ISecurityInfo {

	/**
	 * Final static logger.
	 */
	private static final Logger logger = LoggerFactory
			.getLogger(SecurityHelpperXLNets.class);

	private HttpServletRequest request;
	private N38API n38API;

	// private Locale clocLocale = Locale.getDefault();

	public SecurityHelpperXLNets() {
		HttpServletRequest currentRequest = ((ServletRequestAttributes) RequestContextHolder
				.currentRequestAttributes()).getRequest();
		try {
			this.setHttpRequest(currentRequest);
			this.getSecurityObject(aa00jConstantes.XLNET_OBJETO_SEGURIDAD);
		} catch (SecurityHelpperException e) {
			logger.error("ERROR: " + e.getMessage());
			throw new SecurityException(
					"SecurityHelpperException:SecurityHelpperXLNets: " + e);
		}
	}

	public SecurityHelpperXLNets(String kk) {

	}

	/* Asociar la request de la sesi�n N38 */
	public void setHttpRequest(HttpServletRequest request)
			throws SecurityHelpperException {
		try {
			this.request = request;
			n38API = new N38API(request);
		} catch (Exception e) {
			throw new SecurityHelpperException(
					"Error al obtener instancia del api N38");
		}
	}

	/* Obtener los perfiles asociados al Usuario que realiza Login. */
	public String[] getPerfiles() throws SecurityHelpperException {
		try {
			return this.n38API.n38ItemSesion("n38perfiles");
		} catch (Throwable e) {
			throw new SecurityHelpperException("SecurityHelpper:getPerfiles");
		}
	}

	/* Obtener el idioma asociado al Usuario que realiza Login. */
	public String getIdioma() throws SecurityHelpperException {
		try {
			return this.n38API.n38ItemSesion("n38idioma")[0];
		} catch (Exception e) {
			throw new SecurityHelpperException("SecurityHelpper:getIdioma");
		}
	}

	/* Obtener la Persona asociada al Usuario que realiza Login. */
	public String getPersonaNombre() throws SecurityHelpperException {
		try {
			String uidPersona = this.getPersonaUID();
			Document personaDocument = this.n38API
					.n38ItemObtenerPersonas("n38PuestoUID=" + uidPersona);

			String filtro = "//elemento[@subtipo=\"n38persona\"]/parametro[@id=\"cn\"]/valor/text()";
			// El cn contiene el nombre y apellidos de la persona.
			String nombre = XPathAPI.selectNodeList(personaDocument, filtro)
					.item(0).getNodeValue();
			return nombre;
		} catch (Exception e) {
			throw new SecurityHelpperException(
					"SecurityHelpper:getPersonaNombre");
		}
	}

	/* Obtener la Persona asociada al Usuario que realiza Login. */
	public String getPersonaNombreYApellidos() throws SecurityHelpperException {
		try {
			Document personaDocument = this.n38API
					.n38ItemObtenerPersonas("uid=" + this.getUsuario());
			String filtro = "//elemento[@subtipo=\"n38persona\"]/parametro[@id=\"givenname\"]/valor/text()";
			String nombre = XPathAPI.selectNodeList(personaDocument, filtro)
					.item(0).getNodeValue();
			filtro = "//elemento[@subtipo=\"n38persona\"]/parametro[@id=\"sn\"]/valor/text()";
			String apellidos = XPathAPI.selectNodeList(personaDocument, filtro)
					.item(0).getNodeValue();
			return nombre + " " + apellidos;
		} catch (Exception e) {
			throw new SecurityHelpperException(
					"SecurityHelpper:getPersonaNombreYApellidos");
		}
	}

	/* Obtener el c�digo del usuario al Usuario que realiza Login. */
	public String getUsuario() throws SecurityHelpperException {
		try {
			UserCredentials userCredentials = (UserCredentials) SecurityContextHolder
					.getContext().getAuthentication().getCredentials();

			return userCredentials.getUserName();

			// return this.n38API.n38ItemSesion("n38personauid")[0];
		} catch (Exception e) {
			throw new SecurityHelpperException("SecurityHelpper:getUsuario"
					+ e.getMessage());
		}
	}

	/* Obtener el dni del usuario al Usuario que realiza Login. */
	public String getDni() throws SecurityHelpperException {
		try {
			return this.n38API.n38ItemSesion("dni")[0];
		} catch (Exception e) {
			throw new SecurityHelpperException("SecurityHelpper:getUsuario"
					+ e.getMessage());
		}
	}

	/* Obtener el uid del usuario que realiza Login. */
	public String getPersonaUID() throws SecurityHelpperException {
		try {
			return this.n38API.n38ItemSesion("n38puestouid")[0];
		} catch (Exception e) {
			throw new SecurityHelpperException("SecurityHelpper:getPersonaUID");
		}
	}

	/* Obtener el grupo orgánico del usuario que realiza Login. */
	public String getPersonaGrupoOrganicoUID() throws SecurityHelpperException {
		try {
			return this.n38API.n38ItemSesion("n38grupoorganicouid")[0];
		} catch (Exception e) {
			throw new SecurityHelpperException(
					"SecurityHelpper:getPersonaGrupoOrganicoUID");
		}
	}

	/* Comprobar si el usuario tiene permiso para la funci�n dada */
	public boolean hasPermission(String uidFuncion)
			throws SecurityHelpperException {
		NodeList lista;
		try {
			Document itemSeguridad = this.n38API.n38ItemSeguridad(uidFuncion);
			lista = XPathAPI.selectNodeList(itemSeguridad, "//elementos");
		} catch (Exception e) {
			throw new SecurityHelpperException(
					"SecurityHelpperXLNets:hasPermision");
		}
		return (lista.getLength() != 0);
	}

	/*
	 * public void cambioIdioma() { if (getIdIdioma().equals("eu"))
	 * setIdIdioma("es"); else setIdIdioma("eu"); clocLocale = new
	 * Locale(cstrIdIdioma, cstrIdIdioma); }
	 */
	/**
	 * Crea un objecto de seguridad para una funcion dada. Si devuelve Null es
	 * que no se tiene permiso para esa Funci�n o recurso de LDAP.
	 */
	public SecurityObject getSecurityObject(String uidFuncion)
			throws SecurityHelpperException {

		StringBuffer strLog = new StringBuffer();
		SecurityObject objetoSeguridad = null;
		String clocLocale = "ES";
		String XLNetsIdioma = "";

		try {
			objetoSeguridad = new SecurityObject(this.getPersonaUID());

			strLog.append(" - objetoSeguridad.getPuesto(): ").append(
					objetoSeguridad.getPuesto());

			objetoSeguridad.setUsuario(this.getUsuario());
			strLog.append(" - objetoSeguridad.getUsuario(): ").append(
					objetoSeguridad.getUsuario());

			objetoSeguridad.setPerfiles(this.getPerfiles());
			XLNetsIdioma = this.getIdioma();
			strLog.append(" - this.getIdioma(): ").append(this.getIdioma());

			if (XLNetsIdioma != null) {
				objetoSeguridad.setIdioma(XLNetsIdioma);
				if ("1".equals(XLNetsIdioma)) {
					clocLocale = "ES";
				} else {
					clocLocale = "EU";
				}
				objetoSeguridad.setPersona(this.getPersonaNombre());
				strLog.append(" - objetoSeguridad.getPersona(): ").append(
						objetoSeguridad.getPersona());
				Locale idioma = new Locale(clocLocale, "");

				HttpSession session = this.request.getSession(true);
				session.setAttribute("IdiomaActual", idioma);
			}
		} catch (Exception e) {
			logger.error("Error al obtener el uidFuncion: " + uidFuncion
					+ " - ERROR: " + e.getMessage());
			throw new SecurityException(
					"SecurityHelpperException:getSecurityObject: " + e);
		} finally {
			logger.info(strLog.toString());
		}
		return objetoSeguridad;
	}

	public ArrayList<aa00jDepartamentoXLNET> getDepartamentosGrupoOrganicoXLNETs(
			String grupoOrganico) throws SecurityHelpperException {

		ArrayList<aa00jDepartamentoXLNET> listaDepartamentos = new ArrayList<aa00jDepartamentoXLNET>();
		try {
			N38Estructura estructura = new N38Estructura();
			estructura.setTipoEntrada("GO");
			estructura.setUidEntrada(grupoOrganico);
			Document document = this.n38API.n38ItemOrganizacion(estructura);

			NodeList lista;
			try {
				lista = XPathAPI.selectNodeList(document,
						"//elemento[@subtipo=\"n38gruposorganicos\"]");
			} catch (TransformerException e) {
				logger.error("ERROR con grupoOrganico: " + grupoOrganico
						+ " - ERROR: " + e.getMessage());
				throw new SecurityHelpperException(
						"SecurityHelpperXLNets:getDepartamentosXLNETs");
			}

			aa00jDepartamentoXLNET departamento;

			if (lista != null) {
				int nNodos = lista.getLength();
				if (nNodos > 0) {
					for (int i = 0; i < nNodos; i++) {
						if (lista.item(i).getChildNodes().getLength() > 0) {

							String v1 = XPathAPI
									.selectNodeList(lista.item(i),
											"parametro[@id=\"n38uidgrupoorganico\"]/valor/text()")
									.item(0).getNodeValue();
							String v2 = XPathAPI
									.selectNodeList(lista.item(i),
											"parametro[@id=\"n38cadescripcion\"]/valor/text()")
									.item(0).getNodeValue();
							String v3 = XPathAPI
									.selectNodeList(lista.item(i),
											"parametro[@id=\"n38eudescripcion\"]/valor/text()")
									.item(0).getNodeValue();

							departamento = new aa00jDepartamentoXLNET();
							departamento.setCodigo(v1);
							departamento.setDescC(v2);
							departamento.setDescE(v3);

							listaDepartamentos.add(departamento);
						}
					}
				}
			}
		} catch (Exception e) {
			logger.error("ERROR con grupoOrganico: " + grupoOrganico
					+ " - ERROR: " + e.getMessage());
		}

		return listaDepartamentos;
	}

	public ArrayList<aa00jServicioXLNET> getServiciosXLNETs(String ou)
			throws SecurityHelpperException {

		ArrayList<aa00jServicioXLNET> listaServicios = new ArrayList<aa00jServicioXLNET>();
		try {
			N38Estructura estructura = new N38Estructura();
			estructura.setTipoEntrada("GO*");
			estructura.setUidEntrada(ou);
			Document document = this.n38API.n38ItemOrganizacion(estructura);

			NodeList lista;
			try {
				// lista = XPathAPI.selectNodeList(document,
				// "/n38/elementos/elemento/elemento[@subtipo=\"n38gruposorganicos\"]");
				lista = XPathAPI.selectNodeList(document,
						"//elemento[@subtipo=\"n38organizationalunit\"]");
			} catch (TransformerException e) {
				this.logger.error("Error con ou: " + ou + " - ERROR: "
						+ e.getMessage());
				throw new SecurityHelpperException(
						"SecurityHelpperXLNets:getServiciosXLNETs");
			}

			aa00jServicioXLNET servicio;

			if (lista != null) {
				int nNodos = lista.getLength();
				Node n;
				if (nNodos > 0) {
					for (int i = 0; i < nNodos; i++) {
						if (lista.item(i).getChildNodes().getLength() > 0) {
							n = lista.item(i);
							String v1 = XPathAPI
									.selectNodeList(n,
											"parametro[@id=\"n38uidorgunit\"]/valor/text()")
									.item(0).getNodeValue();
							String v2 = XPathAPI
									.selectNodeList(n,
											"parametro[@id=\"n38cadescripcion\"]/valor/text()")
									.item(0).getNodeValue();
							String v3 = "";
							try {
								v3 = XPathAPI
										.selectNodeList(n,
												"parametro[@id=\"n38eudescripcion\"]/valor/text()")
										.item(0).getNodeValue();
							} catch (Exception e) {
								// e.printStackTrace();

							}
							NodeList nl = XPathAPI.selectNodeList(n,
									"parametro[@id=\"n38padre\"]/valor/text()");

							servicio = new aa00jServicioXLNET();
							servicio.setCodigo(v1);
							servicio.setDescC(v2);
							servicio.setDescE(v3);
							if (nl.getLength() > 0)
								servicio.setPadre(nl.item(0).getNodeValue());
							else
								servicio.setPadre("-inicial");

							listaServicios.add(servicio);
						}
					}
				}
			}
		} catch (Exception e) {
			logger.error("Error con ou: " + ou + " - ERROR: " + e.getMessage());
		}

		listaServicios = reordernar(listaServicios, "-inicial", 0);
		return listaServicios;
	}

	private ArrayList<aa00jServicioXLNET> reordernar(
			ArrayList<aa00jServicioXLNET> datos, String padre, int nivel) {
		ArrayList<aa00jServicioXLNET> padres = new ArrayList<aa00jServicioXLNET>();
		ArrayList<aa00jServicioXLNET> hijos = new ArrayList<aa00jServicioXLNET>();
		for (aa00jServicioXLNET s : datos) {
			if (s.getPadre().equals(padre)) {
				padres.add(s);
			} else {
				hijos.add(s);
			}
		}
		ArrayList<aa00jServicioXLNET> resultado = new ArrayList<aa00jServicioXLNET>();
		for (aa00jServicioXLNET s : padres) {
			s.setNivel(nivel);
			resultado.add(s);
			resultado.addAll(reordernar(hijos, s.getCodigo(), nivel + 1));
		}
		return resultado;

	}

	public aa00jDireccionXLNET getDireccionPuestoXLNETs(String puesto)
			throws SecurityHelpperException {

		try {
			Document documentPuesto = this.n38API
					.n38ItemObtenerPuestos("n38uidpuesto=" + puesto);
			NodeList lista = XPathAPI.selectNodeList(documentPuesto,
					"//elemento[@subtipo=\"n38puesto\"]");
			String codEstrus = XPathAPI
					.selectNodeList(lista.item(0),
							"parametro[@id=\"n38codestrus\"]/valor/text()")
					.item(0).getNodeValue();
			String grupoOrganico = XPathAPI
					.selectNodeList(lista.item(0),
							"parametro[@id=\"n38grupoorganicouid\"]/valor/text()")
					.item(0).getNodeValue();

			// Con el código cogemos ahora las descripciones en castellano y en
			// euskera
			N38Estructura estructura = new N38Estructura();
			estructura.setTipoEntrada("GO*");
			estructura.setUidEntrada(grupoOrganico);
			Document documentDireccion = this.n38API
					.n38ItemOrganizacion(estructura);

			try {
				lista = XPathAPI.selectNodeList(documentDireccion,
						"//elemento[@subtipo=\"n38organizationalunit\"]");

				if (lista != null) {
					String codigo = "";
					String descc = "";
					String desce = "";
					for (int i = 0; i < lista.getLength(); i++) {
						codigo = XPathAPI
								.selectNodeList(lista.item(i),
										"parametro[@id=\"n38codestrus\"]/valor/text()")
								.item(0).getNodeValue();
						if (codigo.substring(0, 4).equals(
								codEstrus.substring(0, 4))) {
							descc = XPathAPI
									.selectNodeList(lista.item(i),
											"parametro[@id=\"n38cadescripcion\"]/valor/text()")
									.item(0).getNodeValue();
							desce = XPathAPI
									.selectNodeList(lista.item(i),
											"parametro[@id=\"n38eudescripcion\"]/valor/text()")
									.item(0).getNodeValue();
							aa00jDireccionXLNET direccion = new aa00jDireccionXLNET();
							direccion.setCodigo(codigo.substring(0, 4));
							direccion.setDescC(descc);
							direccion.setDescE(desce);

							return direccion;
						}
					}
				}

			} catch (TransformerException e) {
				logger.error("Error con puesto: " + puesto + " - ERROR: "
						+ e.getMessage());
				throw new SecurityHelpperException(
						"SecurityHelpperXLNets:getServiciosXLNETs");
			}
		} catch (Exception e) {
			logger.error("Error con puesto: " + puesto + " - ERROR: "
					+ e.getMessage());
		}

		return null;
	}

	public ArrayList<aa00jDepartamentoXLNET> getDepartamentosXLNETs()
			throws SecurityHelpperException {

		ArrayList<aa00jDepartamentoXLNET> listaDepartamentos = new ArrayList<aa00jDepartamentoXLNET>();
		try {
			N38Estructura estructura = new N38Estructura();
			estructura.setTipoEntrada("ALL");
			estructura.setUidEntrada("1");
			Document document = this.n38API.n38ItemOrganizacion(estructura); // "ALL",
			// "1"

			NodeList lista;
			try {
				// lista = XPathAPI.selectNodeList(document,
				// "/n38/elementos/elemento/elemento[@subtipo=\"n38gruposorganicos\"]");
				lista = XPathAPI.selectNodeList(document,
						"//elemento[@subtipo=\"n38gruposorganicos\"]");
			} catch (TransformerException e) {
				logger.error("Error: " + e.getMessage());
				throw new SecurityHelpperException(
						"SecurityHelpperXLNets:getDepartamentosXLNETs");
			}

			aa00jDepartamentoXLNET departamento;

			if (lista != null) {
				int nNodos = lista.getLength();
				if (nNodos > 0) {
					for (int i = 0; i < nNodos; i++) {
						if (lista.item(i).getChildNodes().getLength() > 0) {

							String v1 = XPathAPI
									.selectNodeList(lista.item(i),
											"parametro[@id=\"n38uidgrupoorganico\"]/valor/text()")
									.item(0).getNodeValue();
							String v2 = XPathAPI
									.selectNodeList(lista.item(i),
											"parametro[@id=\"n38cadescripcion\"]/valor/text()")
									.item(0).getNodeValue();
							String v3 = XPathAPI
									.selectNodeList(lista.item(i),
											"parametro[@id=\"n38eudescripcion\"]/valor/text()")
									.item(0).getNodeValue();

							departamento = new aa00jDepartamentoXLNET();
							departamento.setCodigo(v1);
							departamento.setDescC(v2);
							departamento.setDescE(v3);

							listaDepartamentos.add(departamento);
						}
					}
				}
			}
		} catch (Exception e) {
			logger.error("ERROR: " + e.getMessage());
		}

		return listaDepartamentos;
	}

	public ArrayList<aa00jDepartamentoXLNET> getOrganismosXLNETs(String cod)
			throws SecurityHelpperException {

		ArrayList<aa00jDepartamentoXLNET> listaDepartamentos = new ArrayList<aa00jDepartamentoXLNET>();
		try {
			N38Estructura estructura = new N38Estructura();
			estructura.setTipoEntrada("ALL");
			estructura.setUidEntrada(cod);
			Document document = this.n38API.n38ItemOrganizacion(estructura); // "ALL",
			// "1"

			NodeList lista;
			try {
				// lista = XPathAPI.selectNodeList(document,
				// "/n38/elementos/elemento/elemento[@subtipo=\"n38gruposorganicos\"]");
				lista = XPathAPI.selectNodeList(document,
						"//elemento[@subtipo=\"n38gruposorganicos\"]");
			} catch (TransformerException e) {
				logger.error("Error: " + e.getMessage());
				throw new SecurityHelpperException(
						"SecurityHelpperXLNets:getDepartamentosXLNETs");
			}

			aa00jDepartamentoXLNET departamento;

			if (lista != null) {
				int nNodos = lista.getLength();
				if (nNodos > 0) {
					for (int i = 0; i < nNodos; i++) {
						if (lista.item(i).getChildNodes().getLength() > 0) {

							String v1 = XPathAPI
									.selectNodeList(lista.item(i),
											"parametro[@id=\"n38uidgrupoorganico\"]/valor/text()")
									.item(0).getNodeValue();
							String v2 = XPathAPI
									.selectNodeList(lista.item(i),
											"parametro[@id=\"n38cadescripcion\"]/valor/text()")
									.item(0).getNodeValue();
							String v3 = XPathAPI
									.selectNodeList(lista.item(i),
											"parametro[@id=\"n38eudescripcion\"]/valor/text()")
									.item(0).getNodeValue();

							departamento = new aa00jDepartamentoXLNET();
							departamento.setCodigo(v1);
							departamento.setDescC(v2);
							departamento.setDescE(v3);
							if (!cod.equals(v1))
								listaDepartamentos.add(departamento);
						}
					}
				}
			}
		} catch (Exception e) {
			logger.error("ERROR: " + e.getMessage());
		}

		return listaDepartamentos;
	}

	public ArrayList<String> getCodDepartamentosXLNETs()
			throws SecurityHelpperException {

		ArrayList<String> listaDepartamentos = new ArrayList<String>();
		try {
			N38Estructura estructura = new N38Estructura();
			estructura.setTipoEntrada("ALL");
			estructura.setUidEntrada("1");
			Document document = this.n38API.n38ItemOrganizacion(estructura); // "ALL","1"

			NodeList lista;
			try {
				lista = XPathAPI.selectNodeList(document,
						"//elemento[@subtipo=\"n38gruposorganicos\"]");
			} catch (TransformerException e) {
				logger.error("ERROR: " + e.getMessage());
				throw new SecurityHelpperException(
						"SecurityHelpperXLNets:getDepartamentosXLNETs");
			}

			if (lista != null) {
				int nNodos = lista.getLength();
				if (nNodos > 0) {
					for (int i = 0; i < nNodos; i++) {
						if (lista.item(i).getChildNodes().getLength() > 0) {
							listaDepartamentos
									.add(XPathAPI
											.selectNodeList(lista.item(i),
													"parametro[@id=\"n38uidgrupoorganico\"]/valor/text()")
											.item(0).getNodeValue());
						}
					}
				}
			}
		} catch (Exception e) {
			logger.error("ERROR: " + e.getMessage());
		}

		return listaDepartamentos;
	}

	public ArrayList<aa00jDepartamentoXLNET> getDepartamentosYOrganismosXLNETs()
			throws SecurityHelpperException {

		ArrayList<aa00jDepartamentoXLNET> listaDepartamentos = new ArrayList<aa00jDepartamentoXLNET>();
		try {
			// listaDepartamentos = this.getDepartamentosXLNETs();
			N38Estructura estructura = new N38Estructura();
			estructura.setTipoEntrada("ALL");
			estructura.setUidEntrada("ALL");
			Document document = this.n38API.n38ItemOrganizacion(estructura); // "ALL","ALL"

			NodeList lista;
			try {
				lista = XPathAPI.selectNodeList(document,
						"//elemento[@subtipo=\"n38organization\"]");
			} catch (TransformerException e) {
				logger.error("Error: " + e.getMessage());
				throw new SecurityHelpperException(
						"SecurityHelpperXLNets:getDepartamentosYOrganismosXLNETs");
			}

			aa00jDepartamentoXLNET departamento;

			if (lista != null) {
				int nNodos = lista.getLength();
				if (nNodos > 0) {
					for (int i = 0; i < nNodos; i++) {
						if (lista.item(i).getChildNodes().getLength() > 0) {

							String v1 = XPathAPI
									.selectNodeList(lista.item(i),
											"parametro[@id=\"n38uidorg\"]/valor/text()")
									.item(0).getNodeValue();
							if ("1".equals(v1)) // GV
							{
								// El grupo �rganico del GV no lo tratamos
								// porque para el cogemos todos sus
								// departamentos
								// con la funci�n getDepartamentosXLNETs
								ArrayList<aa00jDepartamentoXLNET> departamentosGV = this
										.getDepartamentosXLNETs();
								listaDepartamentos.addAll(departamentosGV);
							} else {
								String v2 = XPathAPI
										.selectNodeList(lista.item(i),
												"parametro[@id=\"n38cadescripcion\"]/valor/text()")
										.item(0).getNodeValue();
								String v3 = XPathAPI
										.selectNodeList(lista.item(i),
												"parametro[@id=\"n38eudescripcion\"]/valor/text()")
										.item(0).getNodeValue();

								departamento = new aa00jDepartamentoXLNET();
								departamento.setCodigo(v1);
								departamento.setDescC(v2);
								departamento.setDescE(v3);

								listaDepartamentos.add(departamento);

								listaDepartamentos.addAll(this
										.getOrganismosXLNETs(v1));
							}
						}
					}
				}
			}
		} catch (Exception e) {
			logger.error("Error: " + e.getMessage());
		}

		return listaDepartamentos;
	}

	public ArrayList<String> getCodDepartamentosYOrganismosGXLNETs()
			throws SecurityHelpperException {

		ArrayList<String> listaDepartamentos = new ArrayList<String>();
		try {
			N38Estructura estructura = new N38Estructura();
			estructura.setTipoEntrada("ALL");
			estructura.setUidEntrada("ALL");
			Document document = this.n38API.n38ItemOrganizacion(estructura); // "ALL","ALL"

			NodeList lista;
			try {
				lista = XPathAPI.selectNodeList(document,
						"//elemento[@subtipo=\"n38organization\"]");
			} catch (TransformerException e) {
				logger.error("Error: " + e.getMessage());
				throw new SecurityHelpperException(
						"SecurityHelpperXLNets:getCodDepartamentosYOrganismosXLNETs");
			}

			if (lista != null) {
				int nNodos = lista.getLength();
				if (nNodos > 0) {
					String v1 = "";
					String v2 = "";
					for (int i = 0; i < nNodos; i++) {
						if (lista.item(i).getChildNodes().getLength() > 0) {
							v1 = XPathAPI
									.selectNodeList(lista.item(i),
											"parametro[@id=\"n38uidorg\"]/valor/text()")
									.item(0).getNodeValue();
							if ("1".equals(v1)) // GV
							{
								// El grupo Órganico del GV no lo tratamos
								// porque para él cogemos todos sus
								// departamentos
								// con la función getDepartamentosXLNETs
								ArrayList<String> departamentosGV = this
										.getCodDepartamentosXLNETs();
								listaDepartamentos.addAll(departamentosGV);
							} else {
								v2 = XPathAPI
										.selectNodeList(lista.item(i),
												"parametro[@id=\"n38idtipoorganizacion\"]/valor/text()")
										.item(0).getNodeValue();
								if ("G".equals(v2)) {
									listaDepartamentos.add(v1);
								}
							}
						}
					}
				}
			}
		} catch (Exception e) {
			logger.error("Error: " + e.getMessage());
		}

		return listaDepartamentos;
	}

	@SuppressWarnings("unchecked")
	public ArrayList<aa00jPersonaXLNET> getPersonasXLNETs(String servicio)
			throws SecurityHelpperException {
		ArrayList<aa00jPersonaXLNET> listaPersonas = new ArrayList<aa00jPersonaXLNET>();
		StringBuffer filtro = new StringBuffer();
		if (servicio != null && !servicio.equals("")) {
			filtro.append("ou=").append(servicio);
		}
		Document document = this.n38API
				.n38ItemObtenerPuestos(filtro.toString());

		NodeList lista;

		try {
			lista = XPathAPI.selectNodeList(document,
					"//elemento//parametro[@id=\"roleoccupant\"]//valor");

			aa00jPersonaXLNET persona;

			if (lista != null) {
				int nNodos = lista.getLength();
				if (nNodos > 0) {
					StringBuffer filtroPersona = new StringBuffer("(|");

					for (int i = 0; i < nNodos; i++) {
						filtroPersona.append("(dni=");
						filtroPersona.append(lista.item(i).getTextContent());
						filtroPersona.append(")");
					}
					filtroPersona.append(")");
					document = this.n38API.n38ItemObtenerPersonas(filtroPersona
							.toString());
					try {
						lista = XPathAPI.selectNodeList(document,
								"//elemento[@subtipo=\"n38persona\"]");
					} catch (TransformerException e) {
						logger.error("Error con código: " + servicio
								+ " - ERROR: " + e.getMessage());
						throw new SecurityHelpperException(
								"SecurityHelpperXLNets:getPersonasXLNETs");
					}
					if (lista != null) {
						nNodos = lista.getLength();
						if (nNodos > 0) {
							for (int i = 0; i < nNodos; i++) {
								if (lista.item(i).getChildNodes().getLength() > 0) {
									String v1 = XPathAPI
											.selectNodeList(lista.item(i),
													"parametro[@id=\"uid\"]/valor/text()")
											.item(0).getNodeValue();
									String v2 = XPathAPI
											.selectNodeList(lista.item(i),
													"parametro[@id=\"dni\"]/valor/text()")
											.item(0).getNodeValue();
									String v3 = XPathAPI
											.selectNodeList(lista.item(i),
													"parametro[@id=\"givenname\"]/valor/text()")
											.item(0).getNodeValue();
									String v4 = XPathAPI
											.selectNodeList(lista.item(i),
													"parametro[@id=\"sn\"]/valor/text()")
											.item(0).getNodeValue();
									// String v5 = XPathAPI
									// .selectNodeList(lista.item(i),
									// "parametro[@id=\"n38puestouid\"]/valor/text()")
									// .item(0).getNodeValue();
									String v6 = "";
									String v7 = "";
									String v8 = "";
									String v9 = "";
									String v10 = "";
									String v11 = "";
									String v12 = "";
									String v13 = "";
									String v14 = "";
									NodeList nlm = XPathAPI
											.selectNodeList(lista.item(i),
													"parametro[@id=\"mail\"]/valor/text()");
									if (nlm.getLength() > 0) {
										v9 = nlm.item(0).getNodeValue();
									}

									NodeList nlt = XPathAPI
											.selectNodeList(lista.item(i),
													"parametro[@id=\"telephonenumber\"]/valor/text()");
									if (nlt.getLength() > 0) {
										v10 = nlt.item(0).getNodeValue();
									}

									persona = new aa00jPersonaXLNET();
									persona.setCodigo(v1);
									persona.setDni(v2);
									persona.setNombre(v3);
									persona.setApellidos(v4);
									persona.setEMail(v9);
									persona.setTelefono(v10);

									persona.setCodDepto(v6);
									persona.setDescDeptoC(v7);
									persona.setDescDeptoE(v8);
									persona.setCodDireccion(v12);
									persona.setDescDireccionC(v13);
									persona.setDescDireccionE(v14);
									persona.setCargo("");
									persona.setPuesto(v11);

									listaPersonas.add(persona);

								}
							}
						}
					}
				}
			}
		} catch (TransformerException e) {
			logger.error("Error con servicio: " + servicio + " - ERROR: "
					+ e.getMessage());
			throw new SecurityHelpperException(
					"SecurityHelpperXLNets:getPersonasXLNETs");
		}
		Collections.sort(listaPersonas);
		return listaPersonas;
	}

	public ArrayList<aa00jPersonaXLNET> getPersonasXLNETs(String codigo,
			String dni, String nombre, String apellidos, String grupoOrganicoUID)
			throws SecurityHelpperException {

		ArrayList<aa00jPersonaXLNET> listaPersonas = new ArrayList<aa00jPersonaXLNET>();
		ArrayList<aa00jDepartamentoXLNET> listaDepartamentos;
		ArrayList<aa00jServicioXLNET> listaServicios = null;
		aa00jDireccionXLNET direccion;
		try {
			StringBuffer filtro = new StringBuffer();
			if (codigo != null && !codigo.equals("")) {
				filtro.append("uid=").append(codigo);
			}
			if (dni != null && !dni.equals("")) {
				filtro.append("dni=").append(dni);
			}
			if (nombre != null && !nombre.equals("")
					&& (apellidos == null || apellidos.equals(""))) {
				filtro.append("givenname=").append(nombre);
			} else if (nombre != null && !nombre.equals("")
					&& apellidos != null && !apellidos.equals("")) {
				filtro.append("cn=").append(apellidos).append(", ")
						.append(nombre);
			}
			if (apellidos != null && !apellidos.equals("")
					&& (nombre == null || nombre.equals(""))) {
				filtro.append("sn=").append(apellidos);
			}
			// if (filtro.length() > 0) {
			// if (grupoOrganicoUID != null && !grupoOrganicoUID.equals("")) {
			// filtro.append("n38grupoorganicouid=").append(grupoOrganicoUID);
			// }
			// }

			Document document = this.n38API.n38ItemObtenerPersonas(filtro
					.toString());
			Document documentPuesto;

			NodeList lista;
			NodeList listaDepto;
			try {
				lista = XPathAPI.selectNodeList(document,
						"//elemento[@subtipo=\"n38persona\"]");
			} catch (TransformerException e) {
				logger.error("Error con código: " + codigo + " - ERROR: "
						+ e.getMessage());
				throw new SecurityHelpperException(
						"SecurityHelpperXLNets:getPersonasXLNETs");
			}

			aa00jPersonaXLNET persona;

			if (lista != null) {
				int nNodos = lista.getLength();
				if (nNodos > 0) {
					for (int i = 0; i < nNodos; i++) {
						if (lista.item(i).getChildNodes().getLength() > 0) {
							String v1 = XPathAPI
									.selectNodeList(lista.item(i),
											"parametro[@id=\"uid\"]/valor/text()")
									.item(0).getNodeValue();
							String v2 = XPathAPI
									.selectNodeList(lista.item(i),
											"parametro[@id=\"dni\"]/valor/text()")
									.item(0).getNodeValue();
							String v3 = XPathAPI
									.selectNodeList(lista.item(i),
											"parametro[@id=\"givenname\"]/valor/text()")
									.item(0).getNodeValue();
							String v4 = XPathAPI
									.selectNodeList(lista.item(i),
											"parametro[@id=\"sn\"]/valor/text()")
									.item(0).getNodeValue();
							String v5 = XPathAPI
									.selectNodeList(lista.item(i),
											"parametro[@id=\"n38puestouid\"]/valor/text()")
									.item(0).getNodeValue();
							String v6 = "";
							String v7 = "";
							String v8 = "";
							String v9 = "";
							String v10 = "";
							String v11 = "";
							String v12 = "";
							String v13 = "";
							String v14 = "";
							NodeList nlm = XPathAPI.selectNodeList(
									lista.item(i),
									"parametro[@id=\"mail\"]/valor/text()");
							if (nlm.getLength() > 0) {
								v9 = nlm.item(0).getNodeValue();
							}

							NodeList nlt = XPathAPI
									.selectNodeList(lista.item(i),
											"parametro[@id=\"telephonenumber\"]/valor/text()");
							if (nlt.getLength() > 0) {
								v10 = nlt.item(0).getNodeValue();
							}

							persona = new aa00jPersonaXLNET();
							persona.setCodigo(v1);
							persona.setDni(v2);
							persona.setNombre(v3);
							persona.setApellidos(v4);
							persona.setEMail(v9);
							persona.setTelefono(v10);

							/* CON EL PUESTO OBTENEMOS EL DEPARTAMENTO */
							try {
								documentPuesto = this.n38API
										.n38ItemObtenerPuestos("n38uidpuesto="
												+ v5);
								listaDepto = XPathAPI.selectNodeList(
										documentPuesto,
										"//elemento[@subtipo=\"n38puesto\"]");

								NodeList nlp = XPathAPI
										.selectNodeList(listaDepto.item(0),
												"parametro[@id=\"n38cadescripcion\"]/valor/text()");
								if (nlp.getLength() > 0) {
									v11 = nlp.item(0).getNodeValue();
								}

								v6 = XPathAPI
										.selectNodeList(listaDepto.item(0),
												"parametro[@id=\"n38grupoorganicouid\"]/valor/text()")
										.item(0).getNodeValue();

								listaDepartamentos = this
										.getDepartamentosGrupoOrganicoXLNETs(v6);
								if (listaDepartamentos != null
										&& listaDepartamentos.size() > 0) {
									v6 = listaDepartamentos.get(0).getCodigo();
									v7 = listaDepartamentos.get(0).getDescC();
									v8 = listaDepartamentos.get(0).getDescE();
								}

								v12 = XPathAPI
										.selectNodeList(listaDepto.item(0),
												"parametro[@id=\"ou\"]/valor/text()")
										.item(0).getNodeValue();

								// NUEVO
								direccion = this.getDireccionPuestoXLNETs(v5);
								v12 = direccion.getCodigo();
								v13 = direccion.getDescC();
								v14 = direccion.getDescE();
								//

								listaServicios = this.getServiciosXLNETs(v6);
								/*
								 * if (listaServicios != null &&
								 * listaServicios.size() > 0) { v12 =
								 * listaServicios.get(0).getCodigo(); v13 =
								 * listaServicios.get(0).getDescC(); v14 =
								 * listaServicios.get(0).getDescE(); }
								 */

							} catch (Exception e) {
								logger.error("Error con código: " + codigo
										+ " - ERROR: " + e.getMessage());
							}
							/**/

							persona.setCodDepto(v6);
							persona.setDescDeptoC(v7);
							persona.setDescDeptoE(v8);
							persona.setCodDireccion(v12);
							persona.setDescDireccionC(v13);
							persona.setDescDireccionE(v14);
							persona.setCargo("");
							persona.setPuesto(v11);
							persona.setServicios(listaServicios);
							if (grupoOrganicoUID != null
									&& grupoOrganicoUID.length() > 0) {
								if (persona.getCodDepto().equals(
										grupoOrganicoUID)) {
									listaPersonas.add(persona);
								}
							} else {
								listaPersonas.add(persona);
							}
						}
					}
				}
			}
		} catch (Exception e) {
			logger.error("Error con código: " + codigo + " - ERROR: "
					+ e.getMessage());
		}

		return listaPersonas;
	}

	public boolean usuarioLogueadoPuedeSolicitar() {

		try {
			// Para que en desarrollo funcione con cualquier persona logueada
			// en XLNETs independientemente del departamento, añadimos ésto:
			try {
				logger.info(request.getRequestURL().toString());
				if (StringUtils.startsWithIgnoreCase(request.getRequestURL()
						.toString(),
						"http://desarrollo.jakina.ejiedes.net:7001")) {
					logger.info("ESTAMOS EN LOCAL...");
					return true;
				} else if (StringUtils
						.startsWithIgnoreCase(request.getRequestURL()
								.toString(), "http://www.des.ejgv.jaso")) {
					logger.info("ESTAMOS EN DESARROLLO...");
					return true;
				} else if (StringUtils
						.startsWithIgnoreCase(request.getRequestURL()
								.toString(), "http://www.pru.ejgv.jaso")) {
					logger.info("ESTAMOS EN PRUEBAS...");
					return true;
				}
			} catch (Exception e) {
				logger.error("ERROR: " + e.getMessage());
			}

			// Para que el usuario pueda solicitar tiene que:
			// Ser miembro de un departamento del gv o de una administración
			// pública,
			// o bien ser miembro del grupo técnico de la aplicación.
			String codDeptoUsuario = this.getPersonaGrupoOrganicoUID();
			ArrayList<String> listaDeptos = this
					.getCodDepartamentosYOrganismosGXLNETs();
			if (listaDeptos != null && listaDeptos.size() > 0) {
				for (int i = 0; i < listaDeptos.size(); i++) {
					if (listaDeptos.get(i).equals(codDeptoUsuario)) {
						return true;
					}
				}
			}

			String perfiles[] = this.getPerfiles();
			if (perfiles != null && perfiles.length > 0) {
				for (int i = 0; i < perfiles.length; i++) {
					if (perfiles[i]
							.equals(aa00jConstantes.XLNET_PERFIL_TECNICO)) {
						logger.info("XLNET_PERFIL_TECNICO=true");
						return true;
					}
				}
			}
		} catch (Exception e) {
			logger.error("ERROR: " + e.getMessage());
		}

		return false;
	}

	public boolean usuarioLogueadoEsTecnico() {

		try {
			String perfiles[] = this.getPerfiles();
			if (perfiles != null && perfiles.length > 0) {
				for (int i = 0; i < perfiles.length; i++) {
					if (perfiles[i]
							.equals(aa00jConstantes.XLNET_PERFIL_TECNICO)) {
						logger.info("XLNET_PERFIL_TECNICO=true");
						return true;
					}
				}
			}
		} catch (Exception e) {
			logger.error("ERROR: " + e.getMessage());
		}

		return false;
	}

	public boolean usuarioLogueadoEsAdminDepto() {

		try {
			String perfiles[] = this.getPerfiles();
			if (perfiles != null && perfiles.length > 0) {
				for (int i = 0; i < perfiles.length; i++) {
					if (perfiles[i]
							.equals(aa00jConstantes.XLNET_PERFIL_ADMIN_DEPTO)) {
						logger.info("XLNET_PERFIL_ADMIN_DEPTO=true");
						return true;
					}
				}
			}
		} catch (Exception e) {
			logger.error("ERROR: " + e.getMessage());
		}

		return false;
	}

	public boolean usuarioLogueadoEsAdmin() {

		try {
			String perfiles[] = this.getPerfiles();
			if (perfiles != null && perfiles.length > 0) {
				for (int i = 0; i < perfiles.length; i++) {
					if (perfiles[i].equals(aa00jConstantes.XLNET_PERFIL_ADMIN)) {
						logger.info("XLNET_PERFIL_ADMIN=true");
						return true;
					}
				}
			}
		} catch (Exception e) {
			logger.error("ERROR: " + e.getMessage());
		}

		return false;
	}

	/**
	 * Obtiene el token XLNets de aplicacion
	 * 
	 * @param idAplic
	 *            la ID de aplicacion
	 * @return el token de aplicacion
	 */
	public static String getTokenXLNets(String idAplic) {
		String token = null;

		try {
			N38APISesion miAPISesion = new N38APISesion();
			Document miSesion;
			miSesion = miAPISesion.n38APISesionCrearApp(idAplic);
			token = SecurityHelpperXLNets.DOM2String(miSesion);
		} catch (Exception e) {
			logger.error("Excepcion creando el token de aplicacion");
			e.printStackTrace();
		}
		return token;
	}

	/**
	 * Convierte en String un documento org.w3c.dom.Document
	 * 
	 * @param doc
	 *            Documento de tipo org.w3c.dom.Document
	 * @return String en el que se ha convertido el Document
	 */
	public static String DOM2String(Document doc) {

		TransformerFactory transformerFactory = TransformerFactory
				.newInstance();
		Transformer transformer = null;

		try {
			transformer = transformerFactory.newTransformer();
		} catch (javax.xml.transform.TransformerConfigurationException error) {
			logger.error("DOM2String - Error al crear la instancia de Transformer");
		}

		Source source = new DOMSource(doc);
		StringWriter writer = new StringWriter();
		Result result = new StreamResult(writer);

		try {
			transformer.transform(source, result);
		} catch (javax.xml.transform.TransformerException error) {
			logger.error("DOM2String - Error al transformar el Document");
		}

		return writer.toString();
	}
}