package com.ejie.aa00j.ldap;

/**
 Interfaz que utilizaremos para el control de seguridad de la aplicacion.
 La implementan dos clases:
 1.SecurityHelpperDefault que devuelve una configuracion de seguridad por defecto (no basada en XLnets)
 2.SecurityHelpperXLNets que devuelve una configuracion de seguridad basada en XLnets.
 **/

import javax.servlet.http.*;

public interface ISecurityInfo {

	/* Obtener los perfiles asociados al Usuario que realiza Login. */
	public String[] getPerfiles() throws SecurityHelpperException;

	/* Comprobar si el usuario tiene permiso para la funci�n dada */
	public boolean hasPermission(String uidFunction)
			throws SecurityHelpperException;

	/* Asociar la request de la sesi�n */
	public void setHttpRequest(HttpServletRequest request)
			throws SecurityHelpperException;

	/*
	 * Obtener el Objeto de Seguridad que se utilizar� a lo largo de la
	 * aplicaci�n
	 */
	public SecurityObject getSecurityObject(String uidFuncion)
			throws SecurityHelpperException;
}