package com.ejie.aa00j.dao;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa00j.classes.aa00jPersonaSesion;
import com.ejie.aa00j.classes.aa00jSeguridad;
import com.ejie.aa00j.model.DatosOcupacion;
import com.ejie.aa00j.model.SalaHorariosReservados;

/**
 * Aa00j99s01DaoImpl generated by UDA, 16-oct-2013 13:02:12.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class SalaReservasDaoImpl implements SalaReservasDao {
	private JdbcTemplate jdbcTemplate;

	private static final Logger logger = LoggerFactory
			.getLogger(SalaReservasDaoImpl.class);

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
 * 
 */
	public ArrayList<SalaHorariosReservados> getHorarios(Date dia,
			Integer departamento, Integer edificio, Integer sala) {
		SalaReservasDaoImpl.logger.info("Método getHorarios");
		SalaReservasDaoImpl.logger.info("Obteniendo horarios para el día "
				+ dia.toString());
		StringBuffer sql = new StringBuffer();
		List<Object> params = new ArrayList<Object>();
		params.add(new java.sql.Timestamp(dia.getTime()));
		sql.append(" SELECT cod20, ");
		sql.append("   csala10, ");
		sql.append("   nombre10, ");
		sql.append("   sit20, ");
		sql.append("   bloq20, ");
		sql.append("   reser20, ");
		sql.append("   TO_CHAR(dhcom20,'HH24:mi')AS desde, ");
		sql.append("   TO_CHAR(dhfin20,'HH24:mi')AS hasta, ");
		sql.append("   extract( YEAR FROM dhfin20) ");
		sql.append(" FROM aa00j10S01 ");
		sql.append(" LEFT JOIN ");
		sql.append("   ( SELECT ");
		sql.append("  *  FROM aa00j20S01 ");
		sql.append("   WHERE ? =TRUNC(dhcom20) ");

		sql.append("   ) ");
		sql.append(" ON csala20                               =csala10 ");
		sql.append("   WHERE SIT10='A' ");
		if (sala != null) {// se busca por codigo de sala
			sql.append(" and csala10 = ?");
			params.add(sala.intValue());
		} else {
			if (edificio != null) {
				sql.append(" AND CDEP10 is null");// Está en modo no
													// departamentales, mostrar
													// solo
													// las que tienen codsala
				if (edificio.intValue() != -1) {
					sql.append(" and cedif10 = ?");
					params.add(edificio.intValue());
				}
			}
			if (departamento != null) {
				if (departamento.intValue() != -1) {
					sql.append(" AND CDEP10= ?");// Está en modo departamentales
					params.add(departamento.intValue());
				} else {

					aa00jPersonaSesion ps = new aa00jSeguridad().getUsuario();
					if (ps.isEsAdminDepto() || ps.isEsTecnico()
							|| ps.isEsAdmin()) {

						sql.append(" AND CDEP10 IS not  NULL");

					} else {
						if (ps.getDepartamentoInterno() != null) {
							sql.append(" AND CDEP10=?");
							params.add(Long.parseLong(ps
									.getDepartamentoInterno()));
						} else {
							sql.append(" AND CDEP10 IS NULL  ");// (t1.CDEP10=?
																// OR
																// t1.CDEP10
																// IS
																// NULL
																// )");
						}
						// params.add(Long.parseLong(ps.getDepartamentoInterno()));
					}
				}

			}
		}
		sql.append(" ORDER BY nombre10, ");
		sql.append("   dhcom20  ");

		SalaReservasDaoImpl.logger.info("SQL " + sql);
		SalaReservasDaoImpl.logger.info("PARAMS " + params);
		SqlRowSet srs = this.jdbcTemplate.queryForRowSet(sql.toString(),
				params.toArray());
		ArrayList<SalaHorariosReservados> resultado = new ArrayList<SalaHorariosReservados>();
		ArrayList<DatosOcupacion> ocupaciones = null;
		int codigo;
		int lastcodigo = -1;
		SalaHorariosReservados salaActual;
		DatosOcupacion ocupacion;
		while (srs.next()) {
			codigo = srs.getInt("csala10");
			if (codigo != lastcodigo) {
				lastcodigo = codigo;
				salaActual = new SalaHorariosReservados();
				resultado.add(salaActual);
				salaActual.setCodigo(srs.getInt("csala10"));
				salaActual.setNombre(srs.getString("nombre10"));
				ocupaciones = new ArrayList<DatosOcupacion>();
				salaActual.setOcupaciones(ocupaciones);

			}
			if (srs.getString("desde") != null) {
				ocupacion = new DatosOcupacion();
				ocupaciones.add(ocupacion);
				ocupacion.setHoraFin(srs.getString("hasta"));
				ocupacion.setHoraInicio(srs.getString("desde"));
				ocupacion.setCodigoReserva(srs.getInt("cod20"));
				ocupacion.setReservado(srs.getString("reser20"));
				ocupacion.setSituacion(srs.getString("sit20"));
			}
			// ocupacion.setBloqueado(srs.getBoolean("bloq20"));

		}
		SalaReservasDaoImpl.logger.info("Sentencia finalizada");
		return resultado;

	}

	/**
	 * Devuelve una lista de reservas para una sala , en unos días
	 * 
	 * @param dias
	 * @param sala
	 * @return
	 */
	public ArrayList<SalaHorariosReservados> getHorarios(ArrayList<Date> dias,
			Integer sala) {
		SalaReservasDaoImpl.logger.info("Método getHorarios");
		SalaReservasDaoImpl.logger
				.info("Obteniendo horarios para la sala unos días"
						+ dias.toString());
		StringBuffer sql = new StringBuffer();
		List<Object> params = new ArrayList<Object>();

		sql.append(" SELECT cod20, trunc(dhcom20)as fecha,");
		sql.append("   csala10, ");
		sql.append("   nombre10, ");
		sql.append("   sit20, ");
		sql.append("   bloq20, ");
		sql.append("   reser20, ");
		sql.append("   TO_CHAR(dhcom20,'HH24:mi')AS desde, ");
		sql.append("   TO_CHAR(dhfin20,'HH24:mi')AS hasta, ");
		sql.append("   extract( YEAR FROM dhfin20) ");
		sql.append(" FROM aa00j10S01 ");
		sql.append(" LEFT JOIN ");
		sql.append("   aa00j20S01 ");
		sql.append(" ON csala20                               =csala10 ");
		sql.append("   WHERE 1=1 ");
		sql.append(" and csala10 = ? and (");
		params.add(sala.intValue());
		boolean primero = true;
		for (Date dia : dias) {
			if (!primero) {
				sql.append(" OR ");
			}
			sql.append("  ? =TRUNC(dhcom20)");

			primero = false;
			SalaReservasDaoImpl.logger.info(dia.toString());
			params.add(new java.sql.Timestamp(dia.getTime()));
		}
		sql.append(" ) ");
		sql.append(" ORDER BY csala20, ");
		sql.append("   dhcom20  ");

		try {

			SalaReservasDaoImpl.logger.info("SQL " + sql);
			SalaReservasDaoImpl.logger.info("PARAMS " + params);
			SqlRowSet srs = this.jdbcTemplate.queryForRowSet(sql.toString(),
					params.toArray());
			ArrayList<SalaHorariosReservados> resultado = new ArrayList<SalaHorariosReservados>();
			ArrayList<DatosOcupacion> ocupaciones = null;

			Date fecha;
			Date lastFecha = null;
			SalaHorariosReservados salaActual, sala2;
			DatosOcupacion ocupacion;
			// tenemos una sala varios dias
			// añadir vacios para los días que no tengan reserva
			Date lDate = null;
			Iterator<Date> iter = dias.iterator();
			// if (iter.hasNext())
			// lDate = iter.next();
			int countDias = -1;
			boolean fechasencontradas[] = new boolean[dias.size()];

			SimpleDateFormat sdf;
			sdf = new SimpleDateFormat("dd/MM/yyyy");

			while (srs.next()) {

				fecha = srs.getDate("fecha");
				if (lastFecha == null || !fecha.equals(lastFecha)) {
					// la fecha del anterior registro es diferente
					// buscamos la siguiente
					lDate = iter.next();
					countDias++;
				}
				while (iter.hasNext() && !lDate.equals(fecha)
						&& !fechasencontradas[countDias]) {
					// hay un hueco entre la fecha del siguiente registro y una
					// de las fechas pedidas
					// añadimos al resultado un registro vacío
					sala2 = new SalaHorariosReservados();
					sala2.setCodigo(sala.intValue());
					sala2.setNombre(sdf.format(lDate));
					sala2.setOcupaciones(new ArrayList<DatosOcupacion>());
					resultado.add(sala2);
					lDate = iter.next();
					countDias++;
					// lastFecha = (Date) fecha.clone();
				}
				if (lDate.equals(fecha)) {
					fechasencontradas[countDias] = true;

				}
				if (lastFecha == null || !fecha.equals(lastFecha)) {
					lastFecha = (Date) fecha.clone();
					salaActual = new SalaHorariosReservados();
					resultado.add(salaActual);
					salaActual.setCodigo(srs.getInt("csala10"));
					salaActual.setNombre(sdf.format(fecha));
					ocupaciones = new ArrayList<DatosOcupacion>();
					salaActual.setOcupaciones(ocupaciones);

				}
				if (srs.getString("desde") != null) {
					ocupacion = new DatosOcupacion();
					ocupaciones.add(ocupacion);
					ocupacion.setHoraFin(srs.getString("hasta"));
					ocupacion.setHoraInicio(srs.getString("desde"));
					ocupacion.setCodigoReserva(srs.getInt("cod20"));
					ocupacion.setReservado(srs.getString("reser20"));
					ocupacion.setSituacion(srs.getString("sit20"));
				}
				// ocupacion.setBloqueado(srs.getBoolean("bloq20"));

			}
			while (iter.hasNext()) {
				lDate = iter.next();
				sala2 = new SalaHorariosReservados();
				sala2.setCodigo(sala.intValue());
				sala2.setNombre(sdf.format(lDate));
				sala2.setOcupaciones(new ArrayList<DatosOcupacion>());
				resultado.add(sala2);

			}
			SalaReservasDaoImpl.logger.info("Sentencia finalizada");
			return resultado;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}
	/*
	 * 
	 * select Nombre10,asun20,dhcom20,anomd20 from aa00j10S01 inner join
	 * aa00j20S01 on csala20=csala10 where SWCONF20=0 and SIT20='A' AND
	 * (reser20='IORTEGAG' or ANOMD20='IORTEGAG')
	 */
}
