package com.ejie.aa00j.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa00j.classes.aa00jConstantes;
import com.ejie.aa00j.classes.aa00jPersonaSesion;
import com.ejie.aa00j.classes.aa00jSeguridad;
import com.ejie.aa00j.model.SalaReserva;

@Repository
@Transactional
public class ListadosDaoImpl implements ListadosDao {
	private JdbcTemplate jdbcTemplate;

	private static final Logger logger = LoggerFactory
			.getLogger(ListadosDaoImpl.class);

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	private RowMapper<SalaReserva> rwMap = new RowMapper<SalaReserva>() {
		public SalaReserva mapRow(ResultSet rs, int rowNum) throws SQLException {
			SalaReserva res = new SalaReserva();
			res.setCodReserva(rs.getInt("codReserva"));
			res.setCodSala(rs.getInt("codSala"));
			res.setNombreSala(rs.getString("nombre"));
			res.setFecha(rs.getDate("fecha"));
			res.setHoraInicio(rs.getString("desde"));
			res.setHoraFin(rs.getString("hasta"));
			res.setDepartamento(rs.getString("departamento"));
			res.setResponsable(rs.getString("organizador"));
			res.setRecursosFijo(rs.getString("aparatosfijos"));
			res.setRecursosMoviles(rs.getString("aparatosmoviles"));
			res.setObservaciones(rs.getString("observaciones"));
			res.setAsunto(rs.getString("asunto"));
			res.setTelefono(rs.getString("telefono"));
			return res;
		}
	};

	/**
	 * devuelve un array con las salas reservadas según los parametros para el
	 * listado
	 * 
	 * @param orden
	 * @param departamental
	 * @param edificio
	 * @param departamento
	 * @param sala
	 * @param fecha1
	 * @param fecha2
	 * @return
	 */
	public ArrayList<SalaReserva> listadoSalas(int orden, int departamental,
			Integer edificio, Integer departamento, Integer sala, Date fecha1,
			Date fecha2, boolean nuevas) {
		ListadosDaoImpl.logger.info("Método listadoSalas");
		List<Object> params = new ArrayList<Object>();
		ListadosDaoImpl.logger.info("Listado de salas según paametros");
		StringBuilder sql = new StringBuilder();
		sql.append(" SELECT v.cod20 as codReserva,");
		sql.append("   u.csala10 as codSala,");
		sql.append("   u.nombre10 as nombre,");
		sql.append("   v.dhcom20 as fecha,");
		sql.append("   TO_CHAR(v.dhcom20,'HH24:mi') desde,");
		sql.append("   TO_CHAR(v.dhfin20,'HH24:mi') hasta,");
		sql.append("   anomd20 as organizador,");
		sql.append("   obs20 as observaciones,");
		sql.append("   descc07 as departamento,");
		sql.append("   asun20 as asunto,");
		sql.append("   tlfno20 as telefono,");
		sql.append("   (SELECT (RTRIM(XMLAGG(xmlelement(X, AA00J12S01.nom12");
		sql.append("     ||',')");
		sql.append("   ORDER BY AA00J12S01.nom12).extract('//text()'),','))");
		sql.append("   FROM AA00J12S01");
		sql.append("   INNER JOIN aa00j21S01");
		sql.append("   ON aa00j21S01.cmedf21 = AA00J12S01.cmedf12");
		sql.append("   WHERE csala12         =u.csala10");
		sql.append("   AND cres21            =v.cod20");
		sql.append("   ) AS aparatosfijos ,");
		sql.append("   (SELECT (RTRIM(XMLAGG(xmlelement(X, AA00J13S01.nomc13");
		sql.append("     ||',')");
		sql.append("   ORDER BY AA00J13S01.nomc13).extract('//text()'),','))");
		sql.append("   FROM AA00J13S01");
		sql.append("   INNER JOIN aa00j30S01");
		sql.append("   ON aa00j13S01.crec13 = AA00J30S01.crec30");
		sql.append("   WHERE codrsala30     =v.cod20");
		sql.append("   ) AS aparatosmoviles");
		sql.append(" FROM aa00j10S01 u");
		sql.append(" INNER JOIN aa00j20S01 v");
		sql.append(" ON csala20=csala10 ");

		sql.append(" left join aa00j07S01");
		sql.append(" on CDEPR20=cdep07");
		sql.append(" WHERE ");
		if (nuevas)
			sql.append("  SIT20='A' AND ");
		if (departamental == 0) {
			sql.append(" cdep10 is null");
			if (edificio != null && edificio != -1) {
				sql.append(" and cedif10=?");
				params.add(edificio);
			}
		} else {
			sql.append(" 1=1");
			aa00jPersonaSesion ps = new aa00jSeguridad().getUsuario();
			if (ps.isEsAdminDepto() || ps.isEsTecnico() || ps.isEsAdmin()) {
				if (departamento == null || departamento == -1)
					sql.append(" AND CDEP10 IS not NULL");
				else {
					sql.append(" AND CDEP10=?");
					params.add(departamento);
				}

			} else {
				if (departamento != null && ps.getDepartamentoInterno() != null) {
					sql.append(" AND CDEP10=?");
					params.add(Long.parseLong(ps.getDepartamentoInterno()));
				} else {
					sql.append(" AND CDEP10 IS NULL  ");// (t1.CDEP10=? OR
														// t1.CDEP10 IS NULL
														// )");
				}
				// params.add(Long.parseLong(ps.getDepartamentoInterno()));
			}
		}
		if (sala != null && sala != -1) {
			sql.append(" and csala10=?");
			params.add(sala);
		}
		sql.append(" and trunc(dhcom20)>=? and trunc(dhfin20)<=?");
		params.add(new Timestamp(fecha1.getTime()));
		params.add(new Timestamp(fecha2.getTime()));

		if (orden != aa00jConstantes.ORDENSALAS)
			sql.append(" order by dhcom20,desde,codsala");
		else
			sql.append(" order by cedif10,nombre,dhcom20,desde");

		ListadosDaoImpl.logger.info("SQL " + sql);
		ListadosDaoImpl.logger.info("PARAMS " + params);
		return (ArrayList<SalaReserva>) this.jdbcTemplate.query(sql.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * devuelve un array con los recursos reservados según los parametros para
	 * el listado
	 * 
	 * @param orden
	 * @param edificio
	 * @param departamento
	 * @param sala
	 * @param fecha1
	 * @param fecha2
	 * @return
	 */
	public ArrayList<SalaReserva> listadoRecursos(int orden, Integer edificio,
			Integer recurso, Date fecha1, Date fecha2) {
		ListadosDaoImpl.logger.info("Método listadoRecursos");
		List<Object> params = new ArrayList<Object>();
		ListadosDaoImpl.logger.info("Listado de salas según paametros");
		StringBuilder sql = new StringBuilder();
		sql.append(" SELECT  v.cod30 AS codReserva,");
		sql.append("   u.crec13    AS codSala,");
		sql.append("   u.nomc13   AS nombre,");
		sql.append("   v.dhcom30    AS fecha,");
		sql.append("    TO_CHAR(v.dhcom30,'HH24:mi') desde,");
		sql.append("   TO_CHAR(v.dhfin30,'HH24:mi') hasta,");
		sql.append("   anomd30 AS organizador,");
		sql.append("    obs30   AS observaciones,");
		sql.append("   descc07 as departamento,");
		sql.append("    asun30  AS asunto,");
		sql.append("   tlfno30 as telefono,");
		sql.append("   null as aparatosfijos,");
		sql.append("   null as aparatosmoviles");
		sql.append(" FROM aa00j13S01 u");
		sql.append(" INNER JOIN aa00j30S01 v");
		sql.append(" ON crec13=crec30 ");
		sql.append(" left join aa00j07S01");
		sql.append(" on cdep30=cdep07");
		sql.append(" WHERE 1=1");
		if (edificio != null && edificio != -1) {
			sql.append(" and cedif13=?");
			params.add(edificio);
		}
		if (recurso != null && recurso != -1) {
			sql.append(" and crec13=?");
			params.add(recurso);
		}
		sql.append(" and trunc(dhcom30)>=? and trunc(dhfin30)<=?");
		params.add(new Timestamp(fecha1.getTime()));
		params.add(new Timestamp(fecha2.getTime()));

		if (orden != aa00jConstantes.ORDENSALAS)
			sql.append(" order by dhcom30,desde,codsala");
		else
			sql.append(" order by codsala,dhcom30,desde");

		ListadosDaoImpl.logger.info("SQL " + sql);
		ListadosDaoImpl.logger.info("PARAMS " + params);
		return (ArrayList<SalaReserva>) this.jdbcTemplate.query(sql.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Devuelve un array list para el listado de reservas
	 * 
	 * @param fechas
	 * @param fecha
	 * @return
	 */
	public ArrayList<SalaReserva> listadoSalas(int salas, Date fecha,
			boolean esListadoDepartamento) {
		ListadosDaoImpl.logger.info("Método listadoSalas");
		List<Object> params = new ArrayList<Object>();
		ListadosDaoImpl.logger.info("Listado de salas según paametros");
		StringBuilder sql = new StringBuilder();
		sql.append("SELECT  count(*) OVER (PARTITION BY csala10) AS codReserva,");
		sql.append(" csala10    AS codSala,");
		sql.append(" nombre10   AS nombre,");
		sql.append(" dhcom20    AS fecha,");
		sql.append(" TO_CHAR(dhcom20,'HH24:mi') desde,");
		sql.append(" TO_CHAR(dhfin20,'HH24:mi') hasta,");
		sql.append(" anomd20 AS organizador,");
		sql.append(" obs20   AS observaciones,");
		sql.append(" descc07 AS departamento,");
		sql.append(" asun20  AS asunto,");
		sql.append(" tlfno20 AS telefono,");
		sql.append(" null as aparatosfijos,");
		sql.append(" null as aparatosmoviles");
		sql.append(" FROM aa00j10S01");
		sql.append(" LEFT JOIN aa00j20S01");
		sql.append(" ON csala20 =csala10 and SIT20='A' ");
		sql.append(" AND TRUNC(dhcom20) =?");
		sql.append(" LEFT JOIN aa00j07S01 on cdep20= cdep07");
		params.add(new Timestamp(fecha.getTime()));
		if (esListadoDepartamento)
			sql.append(" WHERE  infdep10=1 and cdep10=?");
		else
			sql.append(" WHERE  infedif10=1 and cedif10=?");
		sql.append(" ORDER BY csala10,desde,hasta");
		params.add(salas);

		ListadosDaoImpl.logger.info("SQL " + sql);
		ListadosDaoImpl.logger.info("PARAMS " + params);
		return (ArrayList<SalaReserva>) this.jdbcTemplate.query(sql.toString(),
				this.rwMap, params.toArray());
	}

	public ArrayList<SalaReserva> listadoSalas(int tipoinf, Date fecha) {
		ListadosDaoImpl.logger.info("Método listadoSalas");
		List<Object> params = new ArrayList<Object>();
		ListadosDaoImpl.logger.info("Listado de salas según paametros");
		StringBuilder sql = new StringBuilder();
		sql.append("SELECT  count(*) OVER (PARTITION BY csala10) AS codReserva,");
		sql.append(" csala10    AS codSala,");
		sql.append(" nombre10   AS nombre,");
		sql.append(" dhcom20    AS fecha,");
		sql.append(" TO_CHAR(dhcom20,'HH24:mi') desde,");
		sql.append(" TO_CHAR(dhfin20,'HH24:mi') hasta,");
		sql.append(" anomd20 AS organizador,");
		sql.append(" obs20   AS observaciones,");
		sql.append(" descc07 AS departamento,");
		sql.append(" asun20  AS asunto,");
		sql.append(" tlfno20 AS telefono,");
		sql.append(" null as aparatosfijos,");
		sql.append(" null as aparatosmoviles");
		sql.append(" FROM aa00j10S01");
		sql.append(" LEFT JOIN aa00j20S01");
		sql.append(" ON csala20 =csala10 and SIT20='A'");
		sql.append(" AND TRUNC(dhcom20) =?");
		sql.append(" LEFT JOIN aa00j07S01 on cdep20= cdep07 ");
		sql.append(" INNER JOIN aa00j17S01 on csala17= csala10");
		params.add(new Timestamp(fecha.getTime()));
		sql.append(" WHERE   tipo17=?");

		sql.append(" ORDER BY orden17 asc,desde,hasta");
		params.add(tipoinf);

		ListadosDaoImpl.logger.info("SQL " + sql);
		ListadosDaoImpl.logger.info("PARAMS " + params);
		return (ArrayList<SalaReserva>) this.jdbcTemplate.query(sql.toString(),
				this.rwMap, params.toArray());
	}
}
