package com.ejie.aa00j.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa00j.classes.aa00jPersonaSesion;
import com.ejie.aa00j.classes.aa00jSeguridad;
import com.ejie.aa00j.model.SalaEstadistica;

@Repository
@Transactional
public class EstadisticasDaoImpl implements EstadisticasDao {
	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<SalaEstadistica> rwMap = new RowMapper<SalaEstadistica>() {
		public SalaEstadistica mapRow(ResultSet rs, int rowNum)
				throws SQLException {
			SalaEstadistica salida = new SalaEstadistica();
			salida.setAnio(rs.getInt("anio"));
			salida.setMes(rs.getInt("mes"));
			salida.setHorasOcupadas(rs.getDouble("suma"));
			salida.setIdSala(rs.getInt("id"));
			salida.setSala(rs.getString("nombre"));
			salida.setNumdias(rs.getInt("numdias"));
			return salida;
		}
	};
	private JdbcTemplate jdbcTemplate;
	private static final Logger logger = LoggerFactory
			.getLogger(EstadisticasDaoImpl.class);

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Devuelve una lista de estadísticas
	 * 
	 * @param idSala
	 * @param sitio
	 * @param departamento
	 * @param anio
	 * @return
	 */
	public ArrayList<SalaEstadistica> estadisticasMensuales(Integer idSala,
			Integer sitio, Integer departamento, Integer anio) {
		EstadisticasDaoImpl.logger.info("Método estadisticasMensuales");
		EstadisticasDaoImpl.logger.info("Entra en estadisticas mensuales");
		EstadisticasDaoImpl.logger.info("sala=" + idSala);
		EstadisticasDaoImpl.logger.info("sitio=" + sitio);
		EstadisticasDaoImpl.logger.info("departamento=" + departamento);
		aa00jPersonaSesion ps = new aa00jSeguridad().getUsuario();

		StringBuffer sql = new StringBuffer();
		List<Object> params = new ArrayList<Object>();
		sql.append(" SELECT ");
		sql.append(" csala10 as id  ,");
		sql.append(" Nombre10 as nombre,");
		sql.append(" to_char(DHCOM20,'yyyy') anio,");
		sql.append(" to_char(DHCOM20,'MM') mes,");
		sql.append(" sum((DHFIN20-DHCOM20)*24) as suma,");
		sql.append(" count (distinct TO_CHAR(DHCOM20,'dd/MM')) as numdias");
		sql.append(" FROM aa00j10S01");
		sql.append(" INNER JOIN aa00j20S01");
		sql.append(" ON csala20=csala10");
		sql.append(" INNER JOIN aa00j03S01");
		sql.append(" ON cedif10=cedif03");
		sql.append(" WHERE  swconf20=1 and to_char(DHCOM20,'yyyy')=?");

		int year = anio;
		params.add(year);

		if (idSala != null && idSala != -1) {// se busca por codigo de sala
			sql.append(" and csala10 = ?");
			params.add(idSala);
		} else {
			if (sitio != -1 || departamento != -1) {
				if (sitio != null && sitio != -1) {
					sql.append(" AND CDEP10 is null");// Está en modo no
														// departamentales,
														// mostrar
														// solo
														// las que tienen
														// codsala
					if (sitio != -1) {
						sql.append(" and csitio03 = ?");
						params.add(sitio);
					}
				}
				if (departamento != null && departamento != -1) {
					sql.append(" AND CDEP10= ?");// Está en modo departamentales
					params.add(departamento.intValue());
				} else {
					sql.append(" AND CDEP10 IS  NULL");// está en modo no
														// departamentales

				}
			} else {// solamente tiene día--> para usuarios no administradores
					// buscar los de su departamento o los que no tienen
					// departamento
				if (!ps.isEsAdminDepto() && !ps.isEsTecnico()
						&& !ps.isEsAdmin()) {
					sql.append(" AND (CDEP10=? OR CDEP10 IS NULL)");
					params.add(Long.parseLong(ps.getDepartamentoInterno()));

				}

			}

		}
		// if (idSala != null && idSala != -1) {
		// sql.append(" and csala10=?");
		// params.add(idSala);
		// } else if (departamento != null && departamento != -1) {
		// sql.append(" and cdep10=?");
		// params.add(departamento);
		// } else if (sitio != null && sitio != -1) {
		// sql.append(" and csitio03=?");
		// params.add(sitio);
		// }

		sql.append(" group by csala10,Nombre10,  to_char(DHCOM20,'yyyy'), to_char(DHCOM20,'MM')");
		sql.append(" order by anio,mes,csala10");
		EstadisticasDaoImpl.logger.info("SQL " + sql);
		EstadisticasDaoImpl.logger.info("PARAMS " + params);
		return (ArrayList<SalaEstadistica>) this.jdbcTemplate.query(
				sql.toString(), this.rwMap, params.toArray());

	}

	/**
	 * Devuelve una lista de estadísticas anuales (últimos 5 años)
	 * 
	 * @param idSala
	 * @param sitio
	 * @param departamento
	 * @return
	 */
	public ArrayList<SalaEstadistica> estadisticasAnuales(Integer idSala,
			Integer sitio, Integer departamento) {
		EstadisticasDaoImpl.logger.info("Método estadisticasAnuales");
		EstadisticasDaoImpl.logger
				.info("Entra en estadisticas anuales, últimos 5 años");
		EstadisticasDaoImpl.logger.info("sala=" + idSala);
		EstadisticasDaoImpl.logger.info("sitio=" + sitio);
		EstadisticasDaoImpl.logger.info("departamento=" + departamento);
		aa00jPersonaSesion ps = new aa00jSeguridad().getUsuario();
		StringBuffer sql = new StringBuffer();
		List<Object> params = new ArrayList<Object>();
		sql.append(" SELECT ");
		sql.append(" csala10 as id  ,");
		sql.append(" Nombre10 as nombre,");
		sql.append(" to_char(DHCOM20,'yyyy') anio,");
		sql.append(" 0 mes,");
		sql.append(" sum((DHFIN20-DHCOM20)*24) as suma,");
		sql.append(" count (distinct TO_CHAR(DHCOM20,'dd/MM/yyyy')) as numdias");
		sql.append(" FROM aa00j10S01");
		sql.append(" INNER JOIN aa00j20S01");
		sql.append(" ON csala20=csala10");
		sql.append(" INNER JOIN aa00j03S01");
		sql.append(" ON cedif10=cedif03");
		sql.append(" WHERE  swconf20=1 and to_char(DHCOM20,'yyyy')>=?");// SIT20
																		// ='A'
																		// and
		int year = Calendar.getInstance().get(Calendar.YEAR) - 5;
		params.add(year);

		if (idSala != null && idSala != -1) {// se busca por codigo de sala
			sql.append(" and csala10 = ?");
			params.add(idSala);
		} else {
			if (sitio != -1 || departamento != -1) {
				if (sitio != null && sitio != -1) {
					sql.append(" AND CDEP10 is null");// Está en modo no
														// departamentales,
														// mostrar
														// solo
														// las que tienen
														// codsala
					if (sitio != -1) {
						sql.append(" and csitio03 = ?");
						params.add(sitio);
					}
				}
				if (departamento != null && departamento != -1) {
					sql.append(" AND CDEP10= ?");// Está en modo departamentales
					params.add(departamento.intValue());
				} else {
					sql.append(" AND CDEP10 IS  NULL");// está en modo no
														// departamentales

				}
			} else {// solamente tiene día--> para usuarios no administradores
					// buscar los de su departamento o los que no tienen
					// departamento
				if (!ps.isEsAdminDepto() && !ps.isEsTecnico()
						&& !ps.isEsAdmin()) {
					sql.append(" AND (CDEP10=? OR CDEP10 IS NULL)");
					params.add(Long.parseLong(ps.getDepartamentoInterno()));

				}

			}

		}

		// if (idSala != null && idSala != -1) {
		// sql.append(" and csala10=?");
		// params.add(idSala);
		// } else if (departamento != null && departamento != -1) {
		// sql.append(" and cdep10=?");
		// params.add(departamento);
		// } else if (sitio != null && sitio != -1) {
		// sql.append(" and csitio03=?");
		// params.add(sitio);
		// }
		sql.append(" group by csala10,Nombre10,  to_char(DHCOM20,'yyyy')");
		sql.append(" order by anio,csala10");
		EstadisticasDaoImpl.logger.info("SQL " + sql);
		EstadisticasDaoImpl.logger.info("PARAMS " + params);
		return (ArrayList<SalaEstadistica>) this.jdbcTemplate.query(
				sql.toString(), this.rwMap, params.toArray());

	}

}
