package com.ejie.aa00j.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa00j.classes.aa00jConstantes;
import com.ejie.aa00j.classes.aa00jSeguridad;

@Repository
@Transactional
public class ComunDaoImpl implements ComunDao {
	private JdbcTemplate jdbcTemplate;
	private static final Logger logger = LoggerFactory
			.getLogger(ComunDaoImpl.class);

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	@Override
	public boolean bloquear(String campoClave, String valorClave) {
		ComunDaoImpl.logger.info("Método bloquear");
		String codTabla = campoClave.substring(Math.max(
				campoClave.length() - 2, 0));
		String usuario = "";
		try {
			usuario = new aa00jSeguridad().getUsuario().getPersonaXLNET()
					.getCodigo();
		} catch (Exception e) {
		}
		String query = "UPDATE AA00J" + codTabla + "S01 SET BLOQ" + codTabla
				+ "=?, USUB" + codTabla + "=? WHERE " + campoClave
				+ "=? AND (BLOQ" + codTabla + "=? OR USUB" + codTabla + "=?)";

		// 1 = BLOQUEADA POR OTRO USUARIO
		// 0 = LIBRE (SE PUEDE MODIFICAR)
		ComunDaoImpl.logger.info("SQL " + query);
		ComunDaoImpl.logger.info("PARAM1 " + 1);
		ComunDaoImpl.logger.info("PARAM2 " + usuario);
		ComunDaoImpl.logger.info("PARAM3 " + valorClave);
		ComunDaoImpl.logger.info("PARAM4 " + 0);
		ComunDaoImpl.logger.info("PARAM5 " + usuario);

		return this.jdbcTemplate.update(query, 1, usuario, valorClave, 0,
				usuario) > 0;
	}

	@Override
	public boolean bloquearSiAlta(String campoClave, String valorClave) {
		ComunDaoImpl.logger.info("Método bloquearSiAlta");
		String codTabla = campoClave.substring(Math.max(
				campoClave.length() - 2, 0));
		String usuario = "";
		try {
			usuario = new aa00jSeguridad().getUsuario().getPersonaXLNET()
					.getCodigo();
		} catch (Exception e) {
		}
		String query = "UPDATE AA00J" + codTabla + "S01 SET BLOQ" + codTabla
				+ "=?, USUB" + codTabla + "=? WHERE " + campoClave
				+ "=? AND (BLOQ" + codTabla + "=? OR USUB" + codTabla
				+ "=?) AND SIT" + codTabla + "=?";

		// 1 = BLOQUEADA POR OTRO USUARIO
		// 0 = LIBRE (SE PUEDE MODIFICAR)
		ComunDaoImpl.logger.info("SQL " + query);
		ComunDaoImpl.logger.info("PARAM1 " + 1);
		ComunDaoImpl.logger.info("PARAM2 " + usuario);
		ComunDaoImpl.logger.info("PARAM3 " + valorClave);
		ComunDaoImpl.logger.info("PARAM4 " + 0);
		ComunDaoImpl.logger.info("PARAM5 " + usuario);
		ComunDaoImpl.logger.info("PARAM6 " + aa00jConstantes.SITUACION_ALTA);
		return this.jdbcTemplate.update(query, 1, usuario, valorClave, 0,
				usuario, aa00jConstantes.SITUACION_ALTA) > 0;
	}

	@Override
	public boolean desbloquear(String campoClave, String valorClave) {
		ComunDaoImpl.logger.info("Método desbloquear");
		String codTabla = campoClave.substring(Math.max(
				campoClave.length() - 2, 0));
		String usuario = "";
		try {
			usuario = new aa00jSeguridad().getUsuario().getPersonaXLNET()
					.getCodigo();
		} catch (Exception e) {
		}
		String query = "UPDATE AA00J" + codTabla + "S01 SET BLOQ" + codTabla
				+ "=?, USUB" + codTabla + "=? WHERE " + campoClave
				+ "=? AND USUB" + codTabla + "=?";
		ComunDaoImpl.logger.info("SQL " + query);
		ComunDaoImpl.logger.info("PARAM1 " + 0);
		ComunDaoImpl.logger.info("PARAM2 " + null);
		ComunDaoImpl.logger.info("PARAM3 " + valorClave);
		ComunDaoImpl.logger.info("PARAM4 " + usuario);

		return this.jdbcTemplate.update(query, 0, null, valorClave, usuario) > 0;
	}

	/**
	 * Modifica la situacion de los registros ids en la tabla
	 * 
	 * @param tabla
	 * @param ids
	 * @return
	 */
	public boolean cambiarSituacion(String tabla, String clave, String ids) {

		ComunDaoImpl.logger.info("Método cambiarSituacion");
		String query = "update aa00J" + tabla + "s01 set sit" + tabla
				+ "= case when sit" + tabla
				+ "='B' then 'A' ELSE 'B' END where " + clave + " IN (" + ids
				+ ")";
		ComunDaoImpl.logger.info("SQL " + query);
		return this.jdbcTemplate.update(query) > 0;
	}

	public ArrayList<String> obtenerNombres(String sql) {
		return (ArrayList<String>) this.jdbcTemplate.query(sql.toString(),
				new RowMapper<String>() {
					public String mapRow(ResultSet resultSet, int rowNum)
							throws SQLException {

						return resultSet.getString("nombre");
					}
				});
	}

	public boolean updatePr(String sql, String nombre, String codigo,
			String email) {
		return this.jdbcTemplate.update(sql, codigo, email, nombre) > 0;
	}
}