package com.ejie.aa00j.dao;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.bea.core.repackaged.springframework.dao.DataAccessException;
import com.ejie.aa00j.classes.aa00jConstantes;
import com.ejie.aa00j.model.Aa00j97s01;
import com.ejie.aa00j.model.Aa00j98s01;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa00jDesbloqueosTablasDaoImpl generated by VDIAZSAN, 18-mar-2014 12:33:50.
 * 
 * @author VDIAZSAN
 */

@Repository
@Transactional
public class Aa00jDesbloqueosTablasDaoImpl implements Aa00jDesbloqueosTablasDao {
	private JdbcTemplate jdbcTemplate;

	private static final Logger logger = LoggerFactory
			.getLogger(Aa00jDesbloqueosTablasDaoImpl.class);
	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Aa00j97s01> rwMapTablas = new RowMapper<Aa00j97s01>() {
		public Aa00j97s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa00j97s01(resultSet.getString("TABLA97"),
					resultSet.getString("DESC97"),
					resultSet.getString("DESE97"),
					resultSet.getString("CAMPO97"), null);
		}
	};

	private RowMapper<Aa00j98s01> rwMapTablaDetalle = new RowMapper<Aa00j98s01>() {
		public Aa00j98s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			return new Aa00j98s01(resultSet.getString("TABLA98"),
					resultSet.getLong("ORDV98"),
					resultSet.getString("CAMPO98"),
					resultSet.getString("ALIAS98"),
					resultSet.getString("ALIASE98"),
					resultSet.getLong("LONG98"), resultSet.getString("TIPO98"),
					resultSet.getInt("CLAVE98"), resultSet.getInt("VIS98"));
		}
	};

	private RowMapper<Aa00j97s01> rwMapPK = new RowMapper<Aa00j97s01>() {
		public Aa00j97s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa00j97s01(resultSet.getString("TABLA97"));
		}
	};

	private RowMapper<Aa00j97s01> rwMapDescTabla = new RowMapper<Aa00j97s01>() {
		public Aa00j97s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Aa00j97s01 aa00j97s01 = new Aa00j97s01();
			aa00j97s01.setDesc97(resultSet.getString("DESC97"));
			aa00j97s01.setDese97(resultSet.getString("DESE97"));
			return aa00j97s01;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Finds a list of rows in the Aa00j97s01 table.
	 * 
	 * @param aa00j97s01
	 *            Aa00j97s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa00j97s01>
	 */
	@Transactional(readOnly = true)
	public List<Aa00j97s01> findAll(Aa00j97s01 aa00j97s01,
			JQGridRequestDto jqGridRequestDto) {
		Aa00jDesbloqueosTablasDaoImpl.logger.info("Método findAll");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TABLA97 TABLA97,t1.DESC97 DESC97,t1.DESE97 DESE97,t1.CAMPO97 CAMPO97 ");
		query.append("FROM AA00J97S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa00j97s01);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		List<Aa00j97s01> listaTablasBloqueos = (List<Aa00j97s01>) this.jdbcTemplate
				.query(query.toString(), this.rwMapTablas, params.toArray());

		StringBuilder whereBloqPorTabla = new StringBuilder("");
		StringBuilder queryBloqPorTabla = new StringBuilder("");
		for (int i = 0; i < listaTablasBloqueos.size(); i++) {
			queryBloqPorTabla = new StringBuilder("");
			whereBloqPorTabla = new StringBuilder(" WHERE 1=1 ");
			Aa00j97s01 aa00j97s01Bloqueo = new Aa00j97s01();
			aa00j97s01Bloqueo = (Aa00j97s01) listaTablasBloqueos.get(i);
			if (aa00j97s01Bloqueo != null) {

				queryBloqPorTabla = new StringBuilder("SELECT COUNT(1) FROM "
						+ aa00j97s01Bloqueo.getTabla97() + " t1 ");

				// Where clause & Params
				Map<String, ?> mapaWhereBloqPorTabla = this
						.getWhereMapBloqPorTabla(aa00j97s01Bloqueo);

				whereBloqPorTabla.append(mapaWhereBloqPorTabla.get("query"));
				queryBloqPorTabla.append(whereBloqPorTabla);

				List<?> params2 = (List<?>) mapaWhereBloqPorTabla.get("params");
				Aa00jDesbloqueosTablasDaoImpl.logger.info("SQL "
						+ queryBloqPorTabla);
				Long bloqueados = this.jdbcTemplate.queryForLong(
						queryBloqPorTabla.toString(), params2.toArray());

				aa00j97s01Bloqueo.setNumBloqueados(bloqueados);

				listaTablasBloqueos.set(i, aa00j97s01Bloqueo);
			}

		}

		return listaTablasBloqueos;

	}

	/**
	 * Counts rows in the Aa00j97s01 table.
	 * 
	 * @param aa00j97s01
	 *            Aa00j97s01
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Aa00j97s01 aa00j97s01) {
		Aa00jDesbloqueosTablasDaoImpl.logger.info("Método findAllCount");
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA00J97S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa00j97s01);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00jDesbloqueosTablasDaoImpl.logger.info("SQL " + query);
		Aa00jDesbloqueosTablasDaoImpl.logger.info("PARAMS " + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Aa00j97s01 selected for rup_table
	 * 
	 * @param aa00j97s01
	 *            Aa00j97s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j97s01>>
	 */
	@Override
	public List<TableRowDto<Aa00j97s01>> reorderSelection(
			Aa00j97s01 aa00j97s01, JQGridRequestDto jqGridRequestDto) {
		Aa00jDesbloqueosTablasDaoImpl.logger.info("Método reorderSelection");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TABLA97 TABLA97,t1.DESC97 DESC97,t1.DESE97 DESE97,t1.CAMPO97 CAMPO97 ");
		// FROM
		query.append("FROM AA00J97S01 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa00j97s01);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, Aa00j97s01.class, filterParamList,
				"TABLA97");
		Aa00jDesbloqueosTablasDaoImpl.logger.info("SQL "
				+ sbReorderSelectionSQL);
		Aa00jDesbloqueosTablasDaoImpl.logger.info("PARAMS " + filterParamList);
		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa00j97s01>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa00j97s01 entity
	 * 
	 * @param aa00j97s01
	 *            Aa00j97s01 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Aa00j97s01 aa00j97s01) {

		StringBuilder where = new StringBuilder(
				Aa00jDesbloqueosTablasDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		where.append(" AND t1.CAMPO97 is not null ");

		if (aa00j97s01 != null && aa00j97s01.getTabla97() != null
				&& !aa00j97s01.getTabla97().trim().equals("")) {
			where.append(" AND t1.TABLA97 = ?");
			params.add(aa00j97s01.getTabla97());
		}

		if (aa00j97s01 != null && aa00j97s01.getDesc97() != null
				&& !aa00j97s01.getDesc97().trim().equals("")) {
			where.append(" AND t1.DESC97 = ?");
			params.add(aa00j97s01.getDesc97());
		}

		if (aa00j97s01 != null && aa00j97s01.getDese97() != null
				&& aa00j97s01.getDese97().trim().equals("")) {
			where.append(" AND t1.DESE97 = ?");
			params.add(aa00j97s01.getDese97());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa00j97s01 entity
	 * 
	 * @param aa00j97s01
	 *            Aa00j97s01 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMapBloqPorTabla(Aa00j97s01 aa00j97s01) {
		Aa00jDesbloqueosTablasDaoImpl.logger
				.info("Método getWhereMapBloqPorTabla");
		StringBuilder where = new StringBuilder(
				Aa00jDesbloqueosTablasDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa00j97s01 != null && aa00j97s01.getCampo97() != null) {
			where.append(" AND t1." + aa00j97s01.getCampo97() + "  = ? ");
			params.add("1");
		}
		/*
		 * if (aa00j12s01 != null && aa00j12s01.getCDepar12() != null) {
		 * where.append(" AND t1.CDEPAR12 = ?");
		 * params.add(aa00j12s01.getCDepar12()); }
		 */

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	@Override
	public Aa00j97s01 find(Aa00j97s01 aa00j97s01) {
		Aa00jDesbloqueosTablasDaoImpl.logger.info("Método find");
		String query = "SELECT  t1.TABLA97 TABLA97,t1.DESC97 DESC97,t1.DESE97 DESE97,t1.CAMPO97 CAMPO97 FROM AA00J97S01 t1  WHERE t1.TABLA97 = ?  ";
		Aa00jDesbloqueosTablasDaoImpl.logger.info("SQL " + query);
		Aa00jDesbloqueosTablasDaoImpl.logger.info("PARAM1 "
				+ aa00j97s01.getTabla97());
		List<Aa00j97s01> aa00j97s01List = this.jdbcTemplate.query(query,
				this.rwMapTablas, aa00j97s01.getTabla97());
		return (Aa00j97s01) DataAccessUtils.uniqueResult(aa00j97s01List);
	}

	@Override
	public List<Aa00j98s01> findDetalle(Aa00j98s01 aa00j98s01) {
		Aa00jDesbloqueosTablasDaoImpl.logger.info("Método findDetalle");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TABLA98 TABLA98,t1.ORDV98 ORDV98,t1.CAMPO98 CAMPO98,t1.ALIAS98 ALIAS98,NVL2(t1.ALIASE98,t1.ALIAS98,t1.ALIASE98) ALIASE98, t1.LONG98 LONG98, t1.TIPO98 TIPO98, t1.CLAVE98 CLAVE98, t1.VIS98 VIS98 ");
		query.append("FROM AA00J98S01 t1 ");
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		// Where clause & Params

		List<Object> params = new ArrayList<Object>();

		if (aa00j98s01 != null && aa00j98s01.getTabla98() != null
				&& !aa00j98s01.getTabla98().trim().equals("")) {
			where.append(" AND t1.TABLA98 = ?");
			params.add(aa00j98s01.getTabla98());
		}
		query.append(where);
		Aa00jDesbloqueosTablasDaoImpl.logger.info("SQL " + query);
		Aa00jDesbloqueosTablasDaoImpl.logger.info("PARAMS " + params);
		return (List<Aa00j98s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMapTablaDetalle, params.toArray());

	}

	@Override
	public List<Aa00j97s01> findTabla(Aa00j97s01 aa00j97s01, Boolean startsWith) {
		Aa00jDesbloqueosTablasDaoImpl.logger.info("Método findTabla");
		List<Object> params = new ArrayList<Object>();

		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		StringBuilder order = new StringBuilder("");
		StringBuilder query = new StringBuilder(
				"SELECT DISTINCT t1.DESC97 DESC97, t1.DESE97 DESE97 ");
		query.append("FROM AA00J97S01 t1 ");
		if (aa00j97s01 != null && aa00j97s01.getDesc97() != null) {
			where.append(" AND UPPER(t1.DESC97) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add("%" + aa00j97s01.getDesc97().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j97s01.getDesc97().toUpperCase() + "%");
			}

			order = new StringBuilder(" ORDER BY DESC97 asc ");
		}
		if (aa00j97s01 != null && aa00j97s01.getDese97() != null) {
			where.append(" AND UPPER(t1.DESE97) like ? ESCAPE '\\'");
			if (startsWith) {
				params.add("%" + aa00j97s01.getDese97().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j97s01.getDese97().toUpperCase() + "%");
			}

			order = new StringBuilder(" ORDER BY DESE97 asc ");

		}
		query.append(where);
		query.append(order);
		Aa00jDesbloqueosTablasDaoImpl.logger.info("SQL " + query);
		Aa00jDesbloqueosTablasDaoImpl.logger.info("PARAMS " + params);
		return (List<Aa00j97s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMapDescTabla, params.toArray());
	}

	/**
	 * Crea la sql para obtener los registros bloqueados de la tabla
	 * 
	 * @param tabla
	 * @return
	 */
	private String obtenerSelectTabla(String tabla, String campobloqueo) {
		Aa00jDesbloqueosTablasDaoImpl.logger.info("Método obtenerSelectTabla");
		int idioma = 2;
		String alias = "";
		if (LocaleContextHolder.getLocale().getLanguage().contains("eu")) {
			idioma = aa00jConstantes.DESBLOQUEOCOLEUSKERA;
			alias = aa00jConstantes.DESBLOQUEOALIASEUSK;
		} else {
			alias = aa00jConstantes.DESBLOQUEOALIASCAST;
			idioma = aa00jConstantes.DESBLOQUEOCOLCASTELLANO;
		}
		String id = obtenerIdTabla(alias, idioma, tabla);

		String campos = obtenerCamposTabla(alias, idioma, tabla);
		// Creamos la select
		StringBuilder salida = new StringBuilder();
		salida.append("select ");
		salida.append(id);
		salida.append(", ");
		salida.append(campos);
		salida.append(" FROM ");
		salida.append(tabla);
		salida.append(" where ");
		salida.append(campobloqueo);
		salida.append("=1");
		return salida.toString().replaceAll("#", "'#'");
	}

	/**
	 * Devuelve en un string los campos clave de la tabla, para que luego puedan
	 * ser usados para desbloquar un registro en concreto
	 * 
	 * @param alias
	 * @param idioma
	 * @param tabla
	 * @return
	 */
	private String obtenerIdTabla(String alias, int idioma, String tabla) {
		Aa00jDesbloqueosTablasDaoImpl.logger.info("Método obtenerIdTabla");
		StringBuilder query = new StringBuilder();
		query.append("SELECT (RTRIM(XMLAGG(xmlelement(X, campo98");
		query.append(" ||'||#||')");
		query.append(" ORDER BY campo98).extract('//text()'),'||#||')) AS columnas");
		query.append(" FROM aa00j98S01");
		query.append(" WHERE tabla98= UPPER(?) and  CLAVE98  =1");
		Aa00jDesbloqueosTablasDaoImpl.logger.info("SQL " + query);
		Aa00jDesbloqueosTablasDaoImpl.logger.info("PARAM1 " + tabla);
		return (String) this.jdbcTemplate.queryForObject(query.toString(),
				String.class, tabla);
	}

	/**
	 * Crea un String con los campos que hay que mostrar de la tabla
	 * 
	 * @param alias
	 * @param idioma
	 * @param tabla
	 * @return
	 */
	private String obtenerCamposTabla(String alias, int idioma, String tabla) {
		Aa00jDesbloqueosTablasDaoImpl.logger.info("Método obtenerCamposTabla");
		StringBuilder query = new StringBuilder();
		// Creamos un string con el resto de campos
		query.append("SELECT (RTRIM(XMLAGG(xmlelement(X, campo98");
		query.append("	  ||' AS '");
		query.append(" ||");
		query.append(alias);
		query.append(" ||',')");
		query.append(" ORDER BY campo98).extract('//text()'),',')) AS columnas");
		query.append(" FROM aa00j98S01");
		query.append(" WHERE tabla98= UPPER(?) and vis98 in (0,");
		query.append(idioma);
		query.append(")");
		Aa00jDesbloqueosTablasDaoImpl.logger.info("SQL " + query);
		Aa00jDesbloqueosTablasDaoImpl.logger.info("PARAM1 " + tabla);
		return (String) this.jdbcTemplate.queryForObject(query.toString(),
				String.class, tabla);
	}

	/**
	 * Devuelve una lista de registros bloqueados en la tabla. Es genérico,
	 * utiliza la tabla 98 para poder crear la select de la tabla El primer
	 * elemento del Map que devuelve siempre es el identificador, el valor del
	 * key es del estilo CAMPO1||#||CAMPO2 el valor del value es del estilo
	 * VALUE1#VALUE2
	 * 
	 * @param tabla
	 * @param campobloqueo
	 * @return
	 */
	public ArrayList<LinkedHashMap<Object, Object>> obtenerRegistrosBloqueados(
			String tabla, String campobloqueo) {
		Aa00jDesbloqueosTablasDaoImpl.logger
				.info("Método obtenerRegistrosBloqueados");
		String sql = obtenerSelectTabla(tabla, campobloqueo);
		Aa00jDesbloqueosTablasDaoImpl.logger
				.info("Obtener registros bloqueados " + tabla + " "
						+ campobloqueo);
		Aa00jDesbloqueosTablasDaoImpl.logger.info("SQL de tabla=" + sql);
		ArrayList<LinkedHashMap<Object, Object>> salida = this.jdbcTemplate
				.query(sql,
						new ResultSetExtractor<ArrayList<LinkedHashMap<Object, Object>>>() {

							@Override
							public ArrayList<LinkedHashMap<Object, Object>> extractData(
									ResultSet rs) throws SQLException,
									DataAccessException {
								ResultSetMetaData rsmd = rs.getMetaData();
								int columnCount = ((java.sql.ResultSetMetaData) rsmd)
										.getColumnCount();
								LinkedHashMap<Object, Object> registro;
								ArrayList<LinkedHashMap<Object, Object>> columns = new ArrayList<LinkedHashMap<Object, Object>>();
								while (rs.next()) {
									registro = new LinkedHashMap<Object, Object>();
									for (int i = 1; i <= columnCount; i++) {
										registro.put(rsmd.getColumnName(i)
												.replaceAll("'", ""), rs
												.getObject(i));

									}
									columns.add(registro);
								}
								return columns;
							}
						});
		return salida;
	}

	/**
	 * Desbloquea el registro de la tabla tabla identificado por campos y
	 * registros
	 * 
	 * @param tabla
	 * @param campos
	 * @param registros
	 * @param campoBloq
	 * @return
	 */

	public int desbloquearRegistro(String tabla, String[] campos,
			String[] registros, String campoBloq) {
		Aa00jDesbloqueosTablasDaoImpl.logger.info("Método desbloquearRegistro");
		Aa00jDesbloqueosTablasDaoImpl.logger.info("Desbloqueando un registro "
				+ tabla);
		StringBuilder sql = new StringBuilder();
		sql.append("UPDATE ");
		sql.append(tabla);
		sql.append(" set ");
		sql.append(campoBloq);
		sql.append("=0 WHERE ");
		sql.append("1=1 ");
		if (campos != null && campos.length > 0) {
			for (int i = 0; i < registros.length; i++) {
				sql.append(" and ");
				sql.append(campos[i]);
				sql.append("='");
				sql.append(registros[i]);
				sql.append("'");
			}
		}
		Aa00jDesbloqueosTablasDaoImpl.logger.info("sql" + sql.toString());
		return this.jdbcTemplate.update(sql.toString());

	}
}