package com.ejie.aa00j.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa00j.classes.aa00jConstantes;
import com.ejie.aa00j.model.Aa00j03s01;
import com.ejie.aa00j.model.Aa00j06s01;
import com.ejie.aa00j.model.Aa00j07s01;
import com.ejie.aa00j.model.Aa00j13s01;
import com.ejie.aa00j.model.Aa00j20s01;
import com.ejie.aa00j.model.Aa00j30s01;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa00j30s01DaoImpl generated by UDA, 16-oct-2013 13:02:12.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class Aa00j30s01DaoImpl implements Aa00j30s01Dao {
	private JdbcTemplate jdbcTemplate;
	private static final Logger logger = LoggerFactory
			.getLogger(Aa00j30s01DaoImpl.class);
	/*
	 * /* ROW_MAPPERS
	 */
	private RowMapper<Aa00j30s01> rwMap = new RowMapper<Aa00j30s01>() {
		public Aa00j30s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			return new Aa00j30s01(resultSet.getLong("COD30"),
					resultSet.getString("SIT30"), resultSet.getInt("BLOQ30"),
					resultSet.getInt("SWFHOR30"),
					resultSet.getInt("SWMAILE30"),
					resultSet.getString("ASUN30"),
					resultSet.getTimestamp("DHCOM30"),
					resultSet.getTimestamp("DHFIN30"),
					resultSet.getString("ORGAN30"),
					resultSet.getString("RESER30"),
					resultSet.getString("TLFNO30"),
					resultSet.getString("ANOMD30"),
					resultSet.getString("CRESP30"),
					resultSet.getString("TLFNOR30"),
					resultSet.getString("OBS30"),
					resultSet.getString("USUB30"), new Aa00j07s01(
							resultSet.getLong("Aa00j07s01CDEP07"),
							resultSet.getString("Aa00j07s01DESCC07"),
							resultSet.getString("Aa00j07s01DESCE07"),
							resultSet.getString("Aa00j07s01SIT07"),
							resultSet.getInt("Aa00j07s01BLOQ07"),
							resultSet.getString("Aa00j07s01USUB07"),
							resultSet.getString("Aa00j07s01COD_XLNET_07")),
					new Aa00j07s01(resultSet.getLong("Aa00j07s01CDEP07_r"),
							resultSet.getString("Aa00j07s01DESCC07_r"),
							resultSet.getString("Aa00j07s01DESCE07_r"),
							resultSet.getString("Aa00j07s01SIT07_r"), resultSet
									.getInt("Aa00j07s01BLOQ07_r"), resultSet
									.getString("Aa00j07s01USUB07_r"), resultSet
									.getString("Aa00j07s01COD_XLNET_07_r")),
					new Aa00j13s01(resultSet.getLong("Aa00j13s01CREC13"),
							resultSet.getString("Aa00j13s01SIT13"), resultSet
									.getInt("Aa00j13s01BLOQ13"), resultSet
									.getString("Aa00j13s01NOMC13"), resultSet
									.getString("Aa00j13s01DESCC13"), resultSet
									.getString("Aa00j13s01NOME13"), resultSet
									.getString("Aa00j13s01DESCE13"), resultSet
									.getInt("Aa00j13s01SWDISP13"), resultSet
									.getString("Aa00j13s01USUB13"),
							new Aa00j03s01(resultSet
									.getLong("Aa00j13s01CEDIF13"), null, null,
									null, null, null, null, null, null, null),
							new Aa00j06s01(resultSet
									.getLong("Aa00j13s01CREST13"), null, null,
									null, null, null, null, null, null, null),
							new Aa00j07s01(resultSet
									.getLong("Aa00j13s01CDEP13"), null, null,
									null, null, null, null)), new Aa00j20s01(
							resultSet.getLong("Aa00j20s01COD20")),
					resultSet.getInt("SWMAILER30"),
					resultSet.getString("EMAIL30"),
					resultSet.getString("EMAILR30"));
		}
	};

	private RowMapper<Aa00j30s01> rwMapPK = new RowMapper<Aa00j30s01>() {
		public Aa00j30s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa00j30s01(resultSet.getLong("COD30"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Aa00j30s01>> rwMapJerarquia = new RowMapper<JerarquiaDto<Aa00j30s01>>() {
		public JerarquiaDto<Aa00j30s01> mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Aa00j30s01 aa00j30s01 = new Aa00j30s01(resultSet.getLong("COD30"),
					resultSet.getString("SIT30"), resultSet.getInt("BLOQ30"),
					resultSet.getInt("SWFHOR30"),
					resultSet.getInt("SWMAILE30"),
					resultSet.getString("ASUN30"),
					resultSet.getTimestamp("DHCOM30"),
					resultSet.getTimestamp("DHFIN30"),
					resultSet.getString("ORGAN30"),
					resultSet.getString("RESER30"),
					resultSet.getString("TLFNO30"),
					resultSet.getString("ANOMD30"),
					resultSet.getString("CRESP30"),
					resultSet.getString("TLFNOR30"),
					resultSet.getString("OBS30"),
					resultSet.getString("USUB30"), new Aa00j07s01(
							resultSet.getLong("Aa00j07s01CDEP07"),
							resultSet.getString("Aa00j07s01DESCC07"),
							resultSet.getString("Aa00j07s01DESCE07"),
							resultSet.getString("Aa00j07s01SIT07"),
							resultSet.getInt("Aa00j07s01BLOQ07"),
							resultSet.getString("Aa00j07s01USUB07"),
							resultSet.getString("Aa00j07s01COD_XLNET_07")),
					new Aa00j07s01(resultSet.getLong("Aa00j07s01CDEP07_r"),
							resultSet.getString("Aa00j07s01DESCC07_r"),
							resultSet.getString("Aa00j07s01DESCE07_r"),
							resultSet.getString("Aa00j07s01SIT07_r"), resultSet
									.getInt("Aa00j07s01BLOQ07_r"), resultSet
									.getString("Aa00j07s01USUB07_r"), resultSet
									.getString("Aa00j07s01COD_XLNET_07_r")),
					new Aa00j13s01(resultSet.getLong("Aa00j13s01CREC13"),
							resultSet.getString("Aa00j13s01SIT13"), resultSet
									.getInt("Aa00j13s01BLOQ13"), resultSet
									.getString("Aa00j13s01NOMC13"), resultSet
									.getString("Aa00j13s01DESCC13"), resultSet
									.getString("Aa00j13s01NOME13"), resultSet
									.getString("Aa00j13s01DESCE13"), resultSet
									.getInt("Aa00j13s01SWDISP13"), resultSet
									.getString("Aa00j13s01USUB13"),
							new Aa00j03s01(resultSet
									.getLong("Aa00j13s01CEDIF13"), null, null,
									null, null, null, null, null, null, null),
							new Aa00j06s01(resultSet
									.getLong("Aa00j13s01CREST13"), null, null,
									null, null, null, null, null, null, null),
							new Aa00j07s01(resultSet
									.getLong("Aa00j13s01CDEP13"), null, null,
									null, null, null, null)), new Aa00j20s01(
							resultSet.getLong("Aa00j20s01COD20")),
					resultSet.getInt("SWMAILER30"),
					resultSet.getString("EMAIL30"),
					resultSet.getString("EMAILR30"));

			JerarquiaDto<Aa00j30s01> jerarquia = new JerarquiaDto<Aa00j30s01>();
			jerarquia.setModel(aa00j30s01);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet
					.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet
					.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Aa00j30s01 table.
	 * 
	 * @param aa00j30s01
	 *            Aa00j30s01
	 * @return Aa00j30s01
	 */
	public Aa00j30s01 add(final Aa00j30s01 aa00j30s01) {
		Aa00j30s01DaoImpl.logger.info("Método add");
		final String queryUltimoId = "(SELECT NVL(MAX(TO_NUMBER(COD30)), 0) + 1 FROM AA00J30S01)";
		final String query = "INSERT INTO AA00J30S01 (COD30, CDEPR30, CDEP30, CREC30, SIT30, BLOQ30, SWFHOR30, SWMAILE30, ASUN30, DHCOM30, DHFIN30, ORGAN30, RESER30, TLFNO30, ANOMD30, TLFNOR30, OBS30, USUB30, CODRSALA30,CRESP30, SWMAILER30,EMAIL30,EMAILR30) VALUES ("
				+ queryUltimoId
				+ ",?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

		final Object getAa00j07s01ByCdepr30Cdep07Aux;
		if (aa00j30s01.getAa00j07s01ByCdepr30() != null
				&& aa00j30s01.getAa00j07s01ByCdepr30().getCdep07() != null) {
			getAa00j07s01ByCdepr30Cdep07Aux = aa00j30s01
					.getAa00j07s01ByCdepr30().getCdep07();
		} else {
			getAa00j07s01ByCdepr30Cdep07Aux = null;
		}
		final Object getAa00j07s01ByCdep30Cdep07Aux;
		if (aa00j30s01.getAa00j07s01ByCdep30() != null
				&& aa00j30s01.getAa00j07s01ByCdep30().getCdep07() != null) {
			getAa00j07s01ByCdep30Cdep07Aux = aa00j30s01.getAa00j07s01ByCdep30()
					.getCdep07();
		} else {
			getAa00j07s01ByCdep30Cdep07Aux = null;
		}
		final Object getAa00j13s01Crec13Aux;
		if (aa00j30s01.getAa00j13s01() != null
				&& aa00j30s01.getAa00j13s01().getCrec13() != null) {
			getAa00j13s01Crec13Aux = aa00j30s01.getAa00j13s01().getCrec13();
		} else {
			getAa00j13s01Crec13Aux = null;
		}
		final Object getAa00j20s01Cod20Aux;
		if (aa00j30s01.getAa00j20s01() != null
				&& aa00j30s01.getAa00j20s01().getCod20() != null) {
			getAa00j20s01Cod20Aux = aa00j30s01.getAa00j20s01().getCod20();
		} else {
			getAa00j20s01Cod20Aux = null;
		}

		KeyHolder keyHolder = new GeneratedKeyHolder();
		Aa00j30s01DaoImpl.logger.info("SQL " + query);
		Aa00j30s01DaoImpl.logger.info("PARAM1 "
				+ getAa00j07s01ByCdepr30Cdep07Aux);
		Aa00j30s01DaoImpl.logger.info("PARAM2 "
				+ getAa00j07s01ByCdep30Cdep07Aux);
		Aa00j30s01DaoImpl.logger.info("PARAM3 " + getAa00j13s01Crec13Aux);
		Aa00j30s01DaoImpl.logger.info("PARAM4 " + aa00j30s01.getSit30());
		Aa00j30s01DaoImpl.logger.info("PARAM5 " + 0);
		Aa00j30s01DaoImpl.logger.info("PARAM6 " + aa00j30s01.getSwfhor30());
		Aa00j30s01DaoImpl.logger.info("PARAM7 " + aa00j30s01.getSwmaile30());
		Aa00j30s01DaoImpl.logger.info("PARAM8 " + aa00j30s01.getAsun30());
		Aa00j30s01DaoImpl.logger.info("PARAM9 "
				+ aa00j30s01.getDhcom30().getTime());
		Aa00j30s01DaoImpl.logger.info("PARAM10 "
				+ aa00j30s01.getDhfin30().getTime());
		Aa00j30s01DaoImpl.logger.info("PARAM11 " + aa00j30s01.getOrgan30());
		Aa00j30s01DaoImpl.logger.info("PARAM12 " + aa00j30s01.getReser30());
		Aa00j30s01DaoImpl.logger.info("PARAM13 " + aa00j30s01.getTlfno30());
		Aa00j30s01DaoImpl.logger.info("PARAM14 " + aa00j30s01.getAnomd30());
		Aa00j30s01DaoImpl.logger.info("PARAM15 " + aa00j30s01.getTlfnor30());
		Aa00j30s01DaoImpl.logger.info("PARAM16 " + aa00j30s01.getObs30());
		Aa00j30s01DaoImpl.logger.info("PARAM17 " + aa00j30s01.getUsub30());
		Aa00j30s01DaoImpl.logger.info("PARAM18 " + getAa00j20s01Cod20Aux);
		Aa00j30s01DaoImpl.logger.info("PARAM18 " + aa00j30s01.getCresp30());
		Aa00j30s01DaoImpl.logger.info("PARAM19 " + aa00j30s01.getSwmailer30());
		Aa00j30s01DaoImpl.logger.info("PARAM20 " + aa00j30s01.getEmail30());
		Aa00j30s01DaoImpl.logger.info("PARAM21 " + aa00j30s01.getEmailr30());
		jdbcTemplate.update(new PreparedStatementCreator() {
			public PreparedStatement createPreparedStatement(
					Connection connection) throws SQLException {
				PreparedStatement ps = connection.prepareStatement(query,
						new String[] { "COD30" });
				ps.setObject(1, getAa00j07s01ByCdepr30Cdep07Aux);
				ps.setObject(2, getAa00j07s01ByCdep30Cdep07Aux);
				ps.setObject(3, getAa00j13s01Crec13Aux);
				ps.setObject(4, aa00j30s01.getSit30());
				ps.setObject(5, 0);
				ps.setObject(6, aa00j30s01.getSwfhor30());
				ps.setObject(7, aa00j30s01.getSwmaile30());
				ps.setObject(8, aa00j30s01.getAsun30());
				ps.setTimestamp(9, new java.sql.Timestamp(aa00j30s01
						.getDhcom30().getTime()));
				ps.setTimestamp(10, new java.sql.Timestamp(aa00j30s01
						.getDhfin30().getTime()));
				ps.setObject(11, aa00j30s01.getOrgan30());
				ps.setObject(12, aa00j30s01.getReser30());
				ps.setObject(13, aa00j30s01.getTlfno30());
				ps.setObject(14, aa00j30s01.getAnomd30());
				ps.setObject(15, aa00j30s01.getTlfnor30());
				ps.setObject(16, aa00j30s01.getObs30());
				ps.setObject(17, aa00j30s01.getUsub30());
				ps.setObject(18, getAa00j20s01Cod20Aux);
				ps.setObject(19, aa00j30s01.getCresp30());
				ps.setObject(20, aa00j30s01.getSwmailer30());
				ps.setObject(21, aa00j30s01.getEmail30());
				ps.setObject(22, aa00j30s01.getEmailr30());

				return ps;
			}
		}, keyHolder);

		aa00j30s01.setCod30(keyHolder.getKey().longValue());

		return aa00j30s01;
	}

	/**
	 * Updates a single row in the Aa00j30s01 table.
	 * 
	 * @param aa00j30s01
	 *            Aa00j30s01
	 * @return Aa00j30s01
	 */
	public Aa00j30s01 update(Aa00j30s01 aa00j30s01) {
		Aa00j30s01DaoImpl.logger.info("Método update");
		String query = "UPDATE AA00J30S01 SET CDEPR30=?, CDEP30=?, CREC30=?, SIT30=?, BLOQ30=?, SWFHOR30=?, SWMAILE30=?, ASUN30=?, DHCOM30=?, DHFIN30=?, ORGAN30=?, RESER30=?, TLFNO30=?, ANOMD30=?, TLFNOR30=?, OBS30=?, USUB30=?, CODRSALA30=? ,CRESP30=?, SWMAILER30=?,EMAIL30=?,EMAILR30=? WHERE COD30=?";
		Object getAa00j07s01ByCdepr30Cdep07Aux = null;
		if (aa00j30s01.getAa00j07s01ByCdepr30() != null
				&& aa00j30s01.getAa00j07s01ByCdepr30().getCdep07() != null) {
			getAa00j07s01ByCdepr30Cdep07Aux = aa00j30s01
					.getAa00j07s01ByCdepr30().getCdep07();
		}
		Object getAa00j07s01ByCdep30Cdep07Aux = null;
		if (aa00j30s01.getAa00j07s01ByCdep30() != null
				&& aa00j30s01.getAa00j07s01ByCdep30().getCdep07() != null) {
			getAa00j07s01ByCdep30Cdep07Aux = aa00j30s01.getAa00j07s01ByCdep30()
					.getCdep07();
		}
		Object getAa00j13s01Crec13Aux = null;
		if (aa00j30s01.getAa00j13s01() != null
				&& aa00j30s01.getAa00j13s01().getCrec13() != null) {
			getAa00j13s01Crec13Aux = aa00j30s01.getAa00j13s01().getCrec13();
		}
		Object getAa00j20s01Cod20Aux = null;
		if (aa00j30s01.getAa00j20s01() != null
				&& aa00j30s01.getAa00j20s01().getCod20() != null) {
			getAa00j20s01Cod20Aux = aa00j30s01.getAa00j20s01().getCod20();
		}
		Aa00j30s01DaoImpl.logger.info("SQL " + query);
		Aa00j30s01DaoImpl.logger.info("PARAM1 "
				+ getAa00j07s01ByCdepr30Cdep07Aux);
		Aa00j30s01DaoImpl.logger.info("PARAM2 "
				+ getAa00j07s01ByCdep30Cdep07Aux);
		Aa00j30s01DaoImpl.logger.info("PARAM3 " + getAa00j13s01Crec13Aux);
		Aa00j30s01DaoImpl.logger.info("PARAM4 " + aa00j30s01.getSit30());
		Aa00j30s01DaoImpl.logger.info("PARAM5 " + aa00j30s01.getBloq30());
		Aa00j30s01DaoImpl.logger.info("PARAM6 " + aa00j30s01.getSwfhor30());
		Aa00j30s01DaoImpl.logger.info("PARAM7 " + aa00j30s01.getSwmaile30());
		Aa00j30s01DaoImpl.logger.info("PARAM8 " + aa00j30s01.getAsun30());
		Aa00j30s01DaoImpl.logger.info("PARAM9 "
				+ aa00j30s01.getDhcom30().getTime());
		Aa00j30s01DaoImpl.logger.info("PARAM10 "
				+ aa00j30s01.getDhfin30().getTime());
		Aa00j30s01DaoImpl.logger.info("PARAM11 " + aa00j30s01.getOrgan30());
		Aa00j30s01DaoImpl.logger.info("PARAM12 " + aa00j30s01.getReser30());
		Aa00j30s01DaoImpl.logger.info("PARAM13 " + aa00j30s01.getTlfno30());
		Aa00j30s01DaoImpl.logger.info("PARAM14 " + aa00j30s01.getAnomd30());
		Aa00j30s01DaoImpl.logger.info("PARAM15 " + aa00j30s01.getTlfnor30());
		Aa00j30s01DaoImpl.logger.info("PARAM16 " + aa00j30s01.getObs30());
		Aa00j30s01DaoImpl.logger.info("PARAM17 " + aa00j30s01.getUsub30());
		Aa00j30s01DaoImpl.logger.info("PARAM18 " + aa00j30s01.getCod30());
		Aa00j30s01DaoImpl.logger.info("PARAM19 " + aa00j30s01.getCresp30());
		Aa00j30s01DaoImpl.logger.info("PARAM20 " + aa00j30s01.getSwmailer30());
		Aa00j30s01DaoImpl.logger.info("PARAM20 " + aa00j30s01.getEmail30());
		Aa00j30s01DaoImpl.logger.info("PARAM20 " + aa00j30s01.getEmailr30());
		Aa00j30s01DaoImpl.logger.info("PARAM21 " + getAa00j20s01Cod20Aux);
		this.jdbcTemplate.update(query, getAa00j07s01ByCdepr30Cdep07Aux,
				getAa00j07s01ByCdep30Cdep07Aux, getAa00j13s01Crec13Aux,
				aa00j30s01.getSit30(), aa00j30s01.getBloq30(),
				aa00j30s01.getSwfhor30(), aa00j30s01.getSwmaile30(),
				aa00j30s01.getAsun30(), aa00j30s01.getDhcom30(),
				aa00j30s01.getDhfin30(), aa00j30s01.getOrgan30(),
				aa00j30s01.getReser30(), aa00j30s01.getTlfno30(),
				aa00j30s01.getAnomd30(), aa00j30s01.getTlfnor30(),
				aa00j30s01.getObs30(), aa00j30s01.getUsub30(),
				aa00j30s01.getCod30(), aa00j30s01.getCresp30(),
				aa00j30s01.getSwmailer30(), aa00j30s01.getEmail30(),
				aa00j30s01.getEmailr30(), getAa00j20s01Cod20Aux);
		return aa00j30s01;
	}

	/**
	 * Finds a single row in the Aa00j30s01 table.
	 * 
	 * @param aa00j30s01
	 *            Aa00j30s01
	 * @return Aa00j30s01
	 */
	@Transactional(readOnly = true)
	public Aa00j30s01 find(Aa00j30s01 aa00j30s01) {
		Aa00j30s01DaoImpl.logger.info("Método find");
		String query = "SELECT t1.COD30 COD30, t1.SIT30 SIT30, t1.BLOQ30 BLOQ30,t1.EMAIL30 EMAIL30,t1.EMAILR30 EMAILR30, t1.SWFHOR30 SWFHOR30, t1.SWMAILE30 SWMAILE30,  t1.SWMAILER30 SWMAILER30,t1.ASUN30 ASUN30, t1.DHCOM30 DHCOM30, t1.DHFIN30 DHFIN30, t1.ORGAN30 ORGAN30, t1.RESER30 RESER30, t1.TLFNO30 TLFNO30, t1.ANOMD30 ANOMD30, t1.CRESP30 CRESP30,t1.TLFNOR30 TLFNOR30, t1.OBS30 OBS30, t1.USUB30 USUB30, t2.CDEP07 AA00J07S01CDEP07, t2.DESCC07 AA00J07S01DESCC07, t2.DESCE07 AA00J07S01DESCE07, t2.SIT07 AA00J07S01SIT07, t2.BLOQ07 AA00J07S01BLOQ07, t2.USUB07 AA00J07S01USUB07, t2.COD_XLNET_07 AA00J07S01COD_XLNET_07, t3.CDEP07 AA00J07S01CDEP07_r, t3.DESCC07 AA00J07S01DESCC07_r, t3.DESCE07 AA00J07S01DESCE07_r, t3.SIT07 AA00J07S01SIT07_r, t3.BLOQ07 AA00J07S01BLOQ07_r, t3.USUB07 AA00J07S01USUB07_r, t3.COD_XLNET_07 AA00J07S01COD_XLNET_07_r, t4.CREC13 AA00J13S01CREC13, t4.SIT13 AA00J13S01SIT13, t4.BLOQ13 AA00J13S01BLOQ13, t4.NOMC13 AA00J13S01NOMC13, t4.DESCC13 AA00J13S01DESCC13, t4.NOME13 AA00J13S01NOME13, t4.DESCE13 AA00J13S01DESCE13, t4.SWDISP13 AA00J13S01SWDISP13, t4.CDEP13 AA00J13S01CDEP13, t4.USUB13 AA00J13S01USUB13, t4.CEDIF13 AA00J13S01CEDIF13, t4.CREST13 AA00J13S01CREST13, t1.CODRSALA30 Aa00j20s01COD20 FROM AA00J30S01 t1 , AA00J07S01 t2 , AA00J07S01 t3 , AA00J13S01 t4  WHERE t1.COD30 = ?   AND t1.CDEPR30= t2.CDEP07(+) AND t1.CDEP30= t3.CDEP07(+) AND t1.CREC30= t4.CREC13(+)";
		Aa00j30s01DaoImpl.logger.info("SQL " + query);
		Aa00j30s01DaoImpl.logger.info("PARAM1 " + aa00j30s01.getCod30());
		List<Aa00j30s01> aa00j30s01List = this.jdbcTemplate.query(query,
				this.rwMap, aa00j30s01.getCod30());
		return (Aa00j30s01) DataAccessUtils.uniqueResult(aa00j30s01List);
	}

	/**
	 * Removes a single row in the Aa00j30s01 table.
	 * 
	 * @param aa00j30s01
	 *            Aa00j30s01
	 * @return
	 */
	public void remove(Aa00j30s01 aa00j30s01) {
		Aa00j30s01DaoImpl.logger.info("Método remove");
		String query = "DELETE FROM AA00J30S01 WHERE COD30=?";
		Aa00j30s01DaoImpl.logger.info("SQL " + query);
		Aa00j30s01DaoImpl.logger.info("PARAM1 " + aa00j30s01.getCod30());
		this.jdbcTemplate.update(query, aa00j30s01.getCod30());
	}

	/**
	 * Finds a list of rows in the Aa00j30s01 table.
	 * 
	 * @param aa00j30s01
	 *            Aa00j30s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa00j30s01>
	 */
	@Transactional(readOnly = true)
	public List<Aa00j30s01> findAll(Aa00j30s01 aa00j30s01,
			JQGridRequestDto jqGridRequestDto, String codDepto,
			String codUsuario) {
		Aa00j30s01DaoImpl.logger.info("Método findAll");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.COD30 COD30,t1.SIT30 SIT30,t1.BLOQ30 BLOQ30,t1.EMAIL30 EMAIL30,t1.EMAILR30 EMAILR30,t1.SWFHOR30 SWFHOR30,t1.SWMAILE30 SWMAILE30, t1.SWMAILER30 SWMAILER30,t1.ASUN30 ASUN30,t1.DHCOM30 DHCOM30,t1.DHFIN30 DHFIN30,t1.ORGAN30 ORGAN30,t1.RESER30 RESER30,t1.TLFNO30 TLFNO30,t1.ANOMD30 ANOMD30,t1.CRESP30 CRESP30,t1.TLFNOR30 TLFNOR30,t1.OBS30 OBS30,t1.USUB30 USUB30,t2.CDEP07 AA00J07S01CDEP07,t2.DESCC07 AA00J07S01DESCC07,t2.DESCE07 AA00J07S01DESCE07,t2.SIT07 AA00J07S01SIT07,t2.BLOQ07 AA00J07S01BLOQ07,t2.USUB07 AA00J07S01USUB07,t2.COD_XLNET_07 AA00J07S01COD_XLNET_07,t3.CDEP07 AA00J07S01CDEP07_r,t3.DESCC07 AA00J07S01DESCC07_r,t3.DESCE07 AA00J07S01DESCE07_r,t3.SIT07 AA00J07S01SIT07_r,t3.BLOQ07 AA00J07S01BLOQ07_r,t3.USUB07 AA00J07S01USUB07_r,t3.COD_XLNET_07 AA00J07S01COD_XLNET_07_r,t4.CREC13 AA00J13S01CREC13,t4.SIT13 AA00J13S01SIT13,t4.BLOQ13 AA00J13S01BLOQ13,t4.NOMC13 AA00J13S01NOMC13,t4.DESCC13 AA00J13S01DESCC13,t4.NOME13 AA00J13S01NOME13,t4.DESCE13 AA00J13S01DESCE13,t4.SWDISP13 AA00J13S01SWDISP13,t4.CDEP13 AA00J13S01CDEP13,t4.USUB13 AA00J13S01USUB13,t4.CEDIF13 AA00J13S01CEDIF13,t4.CREST13 AA00J13S01CREST13, t1.CODRSALA30 Aa00j20s01COD20 ");
		query.append("FROM AA00J30S01 t1 ,AA00J07S01 t2 ,AA00J07S01 t3 ,AA00J13S01 t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa00j30s01);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CDEPR30= t2.CDEP07(+) AND t1.CDEP30= t3.CDEP07(+) AND t1.CREC30= t4.CREC13(+) ");
		where.append(mapaWhere.get("query"));

		/* WHERE DE XLNETS */
		if (!codDepto.isEmpty()) {
			where.append(" AND (t1.CDEP30='").append(codDepto)
					.append("' OR t1.CDEPR30='").append(codDepto).append("')");
		}
		if (!codUsuario.isEmpty()) {
			// where.append(" AND (t1.ORGAN30='").append(codUsuario)
			// .append("' OR t1.RESER30='").append(codUsuario)
			// .append("' OR t1.ANOMD30='").append(codUsuario)
			// .append("')");
			where.append(" AND (t1.ORGAN30='").append(codUsuario)
					.append("' OR t1.CRESP30='").append(codUsuario)
					.append("')");
		}
		/**/

		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		Aa00j30s01DaoImpl.logger.info("SQL " + query);
		Aa00j30s01DaoImpl.logger.info("PARAMS " + params);
		return (List<Aa00j30s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Aa00j30s01 table using like.
	 * 
	 * @param aa00j30s01
	 *            Aa00j30s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa00j30s01>
	 */
	@Transactional(readOnly = true)
	public List<Aa00j30s01> findAllLike(Aa00j30s01 aa00j30s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith,
			String codDepto, String codUsuario, Locale locale) {
		Aa00j30s01DaoImpl.logger.info("Método findAllLike");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.COD30 COD30,t1.SIT30 SIT30,t1.BLOQ30 BLOQ30,t1.EMAIL30 EMAIL30,t1.EMAILR30 EMAILR30,t1.SWFHOR30 SWFHOR30,t1.SWMAILE30 SWMAILE30, t1.SWMAILER30 SWMAILER30,t1.ASUN30 ASUN30,t1.DHCOM30 DHCOM30,t1.DHFIN30 DHFIN30,t1.ORGAN30 ORGAN30,t1.RESER30 RESER30,t1.TLFNO30 TLFNO30,t1.ANOMD30 ANOMD30,t1.CRESP30 CRESP30,t1.TLFNOR30 TLFNOR30,t1.OBS30 OBS30,t1.USUB30 USUB30,t2.CDEP07 AA00J07S01CDEP07,t2.DESCC07 AA00J07S01DESCC07,t2.DESCE07 AA00J07S01DESCE07,t2.SIT07 AA00J07S01SIT07,t2.BLOQ07 AA00J07S01BLOQ07,t2.USUB07 AA00J07S01USUB07,t2.COD_XLNET_07 AA00J07S01COD_XLNET_07,t3.CDEP07 AA00J07S01CDEP07_r,t3.DESCC07 AA00J07S01DESCC07_r,t3.DESCE07 AA00J07S01DESCE07_r,t3.SIT07 AA00J07S01SIT07_r,t3.BLOQ07 AA00J07S01BLOQ07_r,t3.USUB07 AA00J07S01USUB07_r,t3.COD_XLNET_07 AA00J07S01COD_XLNET_07_r,t4.CREC13 AA00J13S01CREC13,t4.SIT13 AA00J13S01SIT13,t4.BLOQ13 AA00J13S01BLOQ13,t4.NOMC13 AA00J13S01NOMC13,t4.DESCC13 AA00J13S01DESCC13,t4.NOME13 AA00J13S01NOME13,t4.DESCE13 AA00J13S01DESCE13,t4.SWDISP13 AA00J13S01SWDISP13,t4.CDEP13 AA00J13S01CDEP13,t4.USUB13 AA00J13S01USUB13,t4.CEDIF13 AA00J13S01CEDIF13,t4.CREST13 AA00J13S01CREST13, t1.CODRSALA30 Aa00j20s01COD20 ");
		query.append("FROM AA00J30S01 t1 ,AA00J07S01 t2 ,AA00J07S01 t3 ,AA00J13S01 t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa00j30s01, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CDEPR30= t2.CDEP07(+) AND t1.CDEP30= t3.CDEP07(+) AND t1.CREC30= t4.CREC13(+) ");
		String q = mapaWhere.get("query").toString();
		if (locale.getLanguage().contains("eu"))
			where.append(q
					.replaceAll(":f", aa00jConstantes.FORMATOFECHAEUSKERA));
		else
			where.append(q.replaceAll(":f",
					aa00jConstantes.FORMATOFECHACASTELLANO));

		/* WHERE DE XLNETS */
		if (!codDepto.isEmpty()) {
			where.append(" AND (t1.CDEP30='").append(codDepto)
					.append("' OR t1.CDEPR30='").append(codDepto).append("')");
		}
		if (!codUsuario.isEmpty()) {
			// where.append(" AND (t1.ORGAN30='").append(codUsuario)
			// .append("' OR t1.RESER30='").append(codUsuario)
			// .append("' OR t1.ANOMD30='").append(codUsuario)
			// .append("')");
			where.append(" AND (t1.ORGAN30='").append(codUsuario)
					.append("' OR t1.CRESP30='").append(codUsuario)
					.append("')");
		}
		/**/

		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		Aa00j30s01DaoImpl.logger.info("SQL " + query);
		Aa00j30s01DaoImpl.logger.info("PARAMS " + params);
		return (List<Aa00j30s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Aa00j30s01 table.
	 * 
	 * @param aa00j30s01
	 *            Aa00j30s01
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Aa00j30s01 aa00j30s01, String codDepto,
			String codUsuario) {
		Aa00j30s01DaoImpl.logger.info("Método findAllCount");
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA00J30S01 t1 , AA00J07S01 t2 , AA00J07S01 t3 , AA00J13S01 t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa00j30s01);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CDEPR30= t2.CDEP07(+) AND t1.CDEP30= t3.CDEP07(+) AND t1.CREC30= t4.CREC13(+) ");
		where.append(mapaWhere.get("query"));

		/* WHERE DE XLNETS */
		if (!codDepto.isEmpty()) {
			where.append(" AND (t1.CDEP30='").append(codDepto)
					.append("' OR t1.CDEPR30='").append(codDepto).append("')");
		}
		if (!codUsuario.isEmpty()) {
			// where.append(" AND (t1.ORGAN30='").append(codUsuario)
			// .append("' OR t1.RESER30='").append(codUsuario)
			// .append("' OR t1.ANOMD30='").append(codUsuario)
			// .append("')");
			where.append(" AND (t1.ORGAN30='").append(codUsuario)
					.append("' OR t1.CRESP30='").append(codUsuario)
					.append("')");
		}
		/**/

		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j30s01DaoImpl.logger.info("SQL " + query);
		Aa00j30s01DaoImpl.logger.info("PARAMS " + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Aa00j30s01 table using like.
	 * 
	 * @param aa00j30s01
	 *            Aa00j30s01
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Aa00j30s01 aa00j30s01, Boolean startsWith,
			String codDepto, String codUsuario, Locale locale) {
		Aa00j30s01DaoImpl.logger.info("Método findAllLikeCount");
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA00J30S01 t1 ,AA00J07S01 t2 ,AA00J07S01 t3 ,AA00J13S01 t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa00j30s01, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CDEPR30= t2.CDEP07(+) AND t1.CDEP30= t3.CDEP07(+) AND t1.CREC30= t4.CREC13(+) ");

		String q = mapaWhere.get("query").toString();
		if (locale.getLanguage().contains("eu"))
			where.append(q
					.replaceAll(":f", aa00jConstantes.FORMATOFECHAEUSKERA));
		else
			where.append(q.replaceAll(":f",
					aa00jConstantes.FORMATOFECHACASTELLANO));
		/* WHERE DE XLNETS */
		if (!codDepto.isEmpty()) {
			where.append(" AND (t1.CDEP30='").append(codDepto)
					.append("' OR t1.CDEPR30='").append(codDepto).append("')");
		}
		if (!codUsuario.isEmpty()) {
			// where.append(" AND (t1.ORGAN30='").append(codUsuario)
			// .append("' OR t1.RESER30='").append(codUsuario)
			// .append("' OR t1.ANOMD30='").append(codUsuario)
			// .append("')");
			where.append(" AND (t1.ORGAN30='").append(codUsuario)
					.append("' OR t1.CRESP30='").append(codUsuario)
					.append("')");
		}
		/**/

		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j30s01DaoImpl.logger.info("SQL " + query);
		Aa00j30s01DaoImpl.logger.info("PARAMS " + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Aa00j30s01 selected for rup_table
	 * 
	 * @param aa00j30s01
	 *            Aa00j30s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j30s01>>
	 */
	@Override
	public List<TableRowDto<Aa00j30s01>> reorderSelection(
			Aa00j30s01 aa00j30s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith, String codDepto, String codUsuario) {
		Aa00j30s01DaoImpl.logger.info("Método reorderSelection");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.COD30 COD30,t1.SIT30 SIT30,t1.BLOQ30 BLOQ30,t1.EMAIL30 EMAIL30,t1.EMAILR30 EMAILR30,t1.SWFHOR30 SWFHOR30,t1.SWMAILE30 SWMAILE30, t1.SWMAILER30 SWMAILER30,t1.ASUN30 ASUN30,t1.DHCOM30 DHCOM30,t1.DHFIN30 DHFIN30,t1.ORGAN30 ORGAN30,t1.RESER30 RESER30,t1.TLFNO30 TLFNO30,t1.ANOMD30 ANOMD30,t1.CRESP30 CRESP30,t1.TLFNOR30 TLFNOR30,t1.OBS30 OBS30,t1.USUB30 USUB30,t2.CDEP07 AA00J07S01CDEP07,t2.DESCC07 AA00J07S01DESCC07,t2.DESCE07 AA00J07S01DESCE07,t2.SIT07 AA00J07S01SIT07,t2.BLOQ07 AA00J07S01BLOQ07,t2.USUB07 AA00J07S01USUB07,t2.COD_XLNET_07 AA00J07S01COD_XLNET_07,t3.CDEP07 AA00J07S01CDEP07_r,t3.DESCC07 AA00J07S01DESCC07_r,t3.DESCE07 AA00J07S01DESCE07_r,t3.SIT07 AA00J07S01SIT07_r,t3.BLOQ07 AA00J07S01BLOQ07_r,t3.USUB07 AA00J07S01USUB07_r,t3.COD_XLNET_07 AA00J07S01COD_XLNET_07_r,t4.CREC13 AA00J13S01CREC13,t4.SIT13 AA00J13S01SIT13,t4.BLOQ13 AA00J13S01BLOQ13,t4.NOMC13 AA00J13S01NOMC13,t4.DESCC13 AA00J13S01DESCC13,t4.NOME13 AA00J13S01NOME13,t4.DESCE13 AA00J13S01DESCE13,t4.SWDISP13 AA00J13S01SWDISP13,t4.CDEP13 AA00J13S01CDEP13,t4.USUB13 AA00J13S01USUB13,t4.CEDIF13 AA00J13S01CEDIF13,t4.CREST13 AA00J13S01CREST13, t1.CODRSALA30 Aa00j20s01COD20 ");
		// FROM
		query.append("FROM AA00J30S01 t1 ,AA00J07S01 t2 ,AA00J07S01 t3 ,AA00J13S01 t4 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa00j30s01, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CDEPR30= t2.CDEP07(+) AND t1.CDEP30= t3.CDEP07(+) AND t1.CREC30= t4.CREC13(+) ");
		where.append(mapaWhere.get("query"));

		/* WHERE DE XLNETS */
		if (!codDepto.isEmpty()) {
			where.append(" AND (t1.CDEP30='").append(codDepto)
					.append("' OR t1.CDEPR30='").append(codDepto).append("')");
		}
		if (!codUsuario.isEmpty()) {
			// where.append(" AND (t1.ORGAN30='").append(codUsuario)
			// .append("' OR t1.RESER30='").append(codUsuario)
			// .append("' OR t1.ANOMD30='").append(codUsuario)
			// .append("')");
			where.append(" AND (t1.ORGAN30='").append(codUsuario)
					.append("' OR t1.CRESP30='").append(codUsuario)
					.append("')");
		}
		/**/

		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, Aa00j30s01.class, filterParamList,
				"COD30");
		Aa00j30s01DaoImpl.logger.info("SQL " + sbReorderSelectionSQL);
		Aa00j30s01DaoImpl.logger.info("PARAMS " + filterParamList);
		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa00j30s01>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * @param filterParams
	 *            Aa00j30s01
	 * @param searchParams
	 *            Aa00j30s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j30s01>>
	 */
	@Override
	public List<TableRowDto<Aa00j30s01>> search(Aa00j30s01 filterParams,
			Aa00j30s01 searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith, String codDepto, String codUsuario) {
		Aa00j30s01DaoImpl.logger.info("Método search");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.COD30 COD30,t1.SIT30 SIT30,t1.BLOQ30 BLOQ30,t1.EMAIL30 EMAIL30,t1.EMAILR30 EMAILR30,t1.SWFHOR30 SWFHOR30,t1.SWMAILE30 SWMAILE30, t1.SWMAILER30 SWMAILER30,t1.ASUN30 ASUN30,t1.DHCOM30 DHCOM30,t1.DHFIN30 DHFIN30,t1.ORGAN30 ORGAN30,t1.RESER30 RESER30,t1.TLFNO30 TLFNO30,t1.ANOMD30 ANOMD30,t1.CRESP30 CRESP30,t1.TLFNOR30 TLFNOR30,t1.OBS30 OBS30,t1.USUB30 USUB30,t2.CDEP07 AA00J07S01CDEP07,t2.DESCC07 AA00J07S01DESCC07,t2.DESCE07 AA00J07S01DESCE07,t2.SIT07 AA00J07S01SIT07,t2.BLOQ07 AA00J07S01BLOQ07,t2.USUB07 AA00J07S01USUB07,t2.COD_XLNET_07 AA00J07S01COD_XLNET_07,t3.CDEP07 AA00J07S01CDEP07_r,t3.DESCC07 AA00J07S01DESCC07_r,t3.DESCE07 AA00J07S01DESCE07_r,t3.SIT07 AA00J07S01SIT07_r,t3.BLOQ07 AA00J07S01BLOQ07_r,t3.USUB07 AA00J07S01USUB07_r,t3.COD_XLNET_07 AA00J07S01COD_XLNET_07_r,t4.CREC13 AA00J13S01CREC13,t4.SIT13 AA00J13S01SIT13,t4.BLOQ13 AA00J13S01BLOQ13,t4.NOMC13 AA00J13S01NOMC13,t4.DESCC13 AA00J13S01DESCC13,t4.NOME13 AA00J13S01NOME13,t4.DESCE13 AA00J13S01DESCE13,t4.SWDISP13 AA00J13S01SWDISP13,t4.CDEP13 AA00J13S01CDEP13,t4.USUB13 AA00J13S01USUB13,t4.CEDIF13 AA00J13S01CEDIF13,t4.CREST13 AA00J13S01CREST13, t1.CODRSALA30 Aa00j20s01COD20 ");
		// FROM
		query.append("FROM AA00J30S01 t1 ,AA00J07S01 t2 ,AA00J07S01 t3 ,AA00J13S01 t4 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");
		from_alias.add(" t3 ");
		from_alias.add(" t4 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CDEPR30= t2.CDEP07(+) AND t1.CDEP30= t3.CDEP07(+) AND t1.CREC30= t4.CREC13(+) ");
		where.append(mapaWhereFilter.get("query"));

		/* WHERE DE XLNETS */
		if (!codDepto.isEmpty()) {
			where.append(" AND (t1.CDEP30='").append(codDepto)
					.append("' OR t1.CDEPR30='").append(codDepto).append("')");
		}
		if (!codUsuario.isEmpty()) {
			// where.append(" AND (t1.ORGAN30='").append(codUsuario)
			// .append("' OR t1.RESER30='").append(codUsuario)
			// .append("' OR t1.ANOMD30='").append(codUsuario)
			// .append("')");
			where.append(" AND (t1.ORGAN30='").append(codUsuario)
					.append("' OR t1.CRESP30='").append(codUsuario)
					.append("')");
		}
		/**/

		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, Aa00j30s01.class, filterParamList,
				searchSQL, searchParamList, from_alias, "COD30");
		Aa00j30s01DaoImpl.logger.info("SQL " + sbReorderSelectionSQL);
		Aa00j30s01DaoImpl.logger.info("PARAMS " + filterParamList);
		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa00j30s01>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 * 
	 * @param filteraa00j30s01
	 *            Aa00j30s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Aa00j30s01 filteraa00j30s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		Aa00j30s01DaoImpl.logger.info("Método removeMultiple");
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.COD30 COD30,t1.SIT30 SIT30,t1.BLOQ30 BLOQ30,t1.EMAIL30 EMAIL30,t1.EMAILR30 EMAILR30,t1.SWFHOR30 SWFHOR30,t1.SWMAILE30 SWMAILE30, t1.SWMAILER30 SWMAILER30,t1.ASUN30 ASUN30,t1.DHCOM30 DHCOM30,t1.DHFIN30 DHFIN30,t1.ORGAN30 ORGAN30,t1.RESER30 RESER30,t1.TLFNO30 TLFNO30,t1.ANOMD30 ANOMD30,t1.CRESP30 CRESP30,t1.TLFNOR30 TLFNOR30,t1.OBS30 OBS30,t1.USUB30 USUB30,t2.CDEP07 AA00J07S01CDEP07,t2.DESCC07 AA00J07S01DESCC07,t2.DESCE07 AA00J07S01DESCE07,t2.SIT07 AA00J07S01SIT07,t2.BLOQ07 AA00J07S01BLOQ07,t2.USUB07 AA00J07S01USUB07,t2.COD_XLNET_07 AA00J07S01COD_XLNET_07,t3.CDEP07 AA00J07S01CDEP07_r,t3.DESCC07 AA00J07S01DESCC07_r,t3.DESCE07 AA00J07S01DESCE07_r,t3.SIT07 AA00J07S01SIT07_r,t3.BLOQ07 AA00J07S01BLOQ07_r,t3.USUB07 AA00J07S01USUB07_r,t3.COD_XLNET_07 AA00J07S01COD_XLNET_07_r,t4.CREC13 AA00J13S01CREC13,t4.SIT13 AA00J13S01SIT13,t4.BLOQ13 AA00J13S01BLOQ13,t4.NOMC13 AA00J13S01NOMC13,t4.DESCC13 AA00J13S01DESCC13,t4.NOME13 AA00J13S01NOME13,t4.DESCE13 AA00J13S01DESCE13,t4.SWDISP13 AA00J13S01SWDISP13,t4.CDEP13 AA00J13S01CDEP13,t4.USUB13 AA00J13S01USUB13,t4.CEDIF13 AA00J13S01CEDIF13,t4.CREST13 AA00J13S01CREST13, t1.CODRSALA30 Aa00j20s01COD20 ");
		// FROM
		query.append("FROM AA00J30S01 t1 ,AA00J07S01 t2 ,AA00J07S01 t3 ,AA00J13S01 t4 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filteraa00j30s01,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto, Aa00j30s01.class,
						query, params, "COD30");
		Aa00j30s01DaoImpl.logger.info("SQL " + sbRemoveMultipleSQL);
		Aa00j30s01DaoImpl.logger.info("PARAMS " + params);
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical Aa00j30s01 table.
	 * 
	 * @param filterAa00j30s01
	 *            Aa00j30s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Aa00j30s01>>
	 */
	@Override
	public List<JerarquiaDto<Aa00j30s01>> findAllLikeJerarquia(
			Aa00j30s01 filterAa00j30s01, JQGridRequestDto jqGridRequestDto) {
		Aa00j30s01DaoImpl.logger.info("Método findAllLikeJerarquia");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.COD30 COD30,t1.SIT30 SIT30,t1.BLOQ30 BLOQ30,t1.EMAIL30 EMAIL30,t1.EMAILR30 EMAILR30,t1.SWFHOR30 SWFHOR30,t1.SWMAILE30 SWMAILE30, t1.SWMAILER30 SWMAILER30,t1.ASUN30 ASUN30,t1.DHCOM30 DHCOM30,t1.DHFIN30 DHFIN30,t1.ORGAN30 ORGAN30,t1.RESER30 RESER30,t1.TLFNO30 TLFNO30,t1.ANOMD30 ANOMD30,t1.CRESP30 CRESP30,t1.TLFNOR30 TLFNOR30,t1.OBS30 OBS30,t1.USUB30 USUB30,t2.CDEP07 AA00J07S01CDEP07,t2.DESCC07 AA00J07S01DESCC07,t2.DESCE07 AA00J07S01DESCE07,t2.SIT07 AA00J07S01SIT07,t2.BLOQ07 AA00J07S01BLOQ07,t2.USUB07 AA00J07S01USUB07,t2.COD_XLNET_07 AA00J07S01COD_XLNET_07,t3.CDEP07 AA00J07S01CDEP07_r,t3.DESCC07 AA00J07S01DESCC07_r,t3.DESCE07 AA00J07S01DESCE07_r,t3.SIT07 AA00J07S01SIT07_r,t3.BLOQ07 AA00J07S01BLOQ07_r,t3.USUB07 AA00J07S01USUB07_r,t3.COD_XLNET_07 AA00J07S01COD_XLNET_07_r,t4.CREC13 AA00J13S01CREC13,t4.SIT13 AA00J13S01SIT13,t4.BLOQ13 AA00J13S01BLOQ13,t4.NOMC13 AA00J13S01NOMC13,t4.DESCC13 AA00J13S01DESCC13,t4.NOME13 AA00J13S01NOME13,t4.DESCE13 AA00J13S01DESCE13,t4.SWDISP13 AA00J13S01SWDISP13,t4.CDEP13 AA00J13S01CDEP13,t4.USUB13 AA00J13S01USUB13,t4.CEDIF13 AA00J13S01CEDIF13,t4.CREST13 AA00J13S01CREST13, t1.CODRSALA30 Aa00j20s01COD20 ");
		// FROM
		// StringBuilder from = new
		// StringBuilder("FROM AA00J30S01 t1 ,AA00J07S01 t2 ,AA00J07S01 t3 ,AA00J13S01 t4 ");
		List<String> from = new ArrayList<String>();
		from.add("AA00J30S01");
		from.add("AA00J07S01");
		from.add("AA00J07S01");
		from.add("AA00J13S01");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");
		from_alias.add(" t3 ");
		from_alias.add(" t4 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa00j30s01, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
				mapaWhere, "COD30", "ID_PADRE", "NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j30s01DaoImpl.logger.info("SQL " + query.toString());
		Aa00j30s01DaoImpl.logger.info("PARAMS " + params);
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAa00j30s01
	 *            Aa00j30s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Aa00j30s01 filterAa00j30s01,
			JQGridRequestDto jqGridRequestDto) {
		Aa00j30s01DaoImpl.logger.info("Método findAllLikeCountJerarquia");
		// FROM
		// StringBuilder from = new
		// StringBuilder("FROM AA00J30S01 t1 ,AA00J07S01 t2 ,AA00J07S01 t3 ,AA00J13S01 t4 ");
		List<String> from = new ArrayList<String>();
		from.add("AA00J30S01");
		from.add("AA00J07S01");
		from.add("AA00J07S01");
		from.add("AA00J13S01");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");
		from_alias.add(" t3 ");
		from_alias.add(" t4 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa00j30s01, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(
				jqGridRequestDto, mapaWhere, "COD30", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j30s01DaoImpl.logger.info("SQL " + query.toString());
		Aa00j30s01DaoImpl.logger.info("PARAMS " + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAa00j30s01
	 *            Aa00j30s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Aa00j30s01>>
	 */
	@Override
	public List<TableRowDto<Aa00j30s01>> findAllChild(
			Aa00j30s01 filterAa00j30s01, JQGridRequestDto jqGridRequestDto) {
		Aa00j30s01DaoImpl.logger.info("Método findAllChild");
		// FROM
		// StringBuilder from = new
		// StringBuilder("FROM AA00J30S01 t1 ,AA00J07S01 t2 ,AA00J07S01 t3 ,AA00J13S01 t4 ");
		List<String> from = new ArrayList<String>();
		from.add("AA00J30S01");
		from.add("AA00J07S01");
		from.add("AA00J07S01");
		from.add("AA00J13S01");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");
		from_alias.add(" t3 ");
		from_alias.add(" t4 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa00j30s01, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(
				jqGridRequestDto, mapaWhere, "COD30", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j30s01DaoImpl.logger.info("SQL " + query.toString());
		Aa00j30s01DaoImpl.logger.info("PARAMS " + params);
		return this.jdbcTemplate
				.query(query.toString(),
						new RowNumResultSetExtractor<Aa00j30s01>(this.rwMapPK,
								"COD30"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa00j30s01 entity
	 * 
	 * @param aa00j30s01
	 *            Aa00j30s01 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Aa00j30s01 aa00j30s01) {

		StringBuilder where = new StringBuilder(
				Aa00j30s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa00j30s01 != null && aa00j30s01.getCod30() != null) {
			where.append(" AND t1.COD30 = ?");
			params.add(aa00j30s01.getCod30());
		}
		if (aa00j30s01 != null && aa00j30s01.getAa00j07s01ByCdepr30() != null
				&& aa00j30s01.getAa00j07s01ByCdepr30().getCdep07() != null) {
			where.append(" AND t2.CDEP07 = ?");
			params.add(aa00j30s01.getAa00j07s01ByCdepr30().getCdep07());
		}
		if (aa00j30s01 != null && aa00j30s01.getAa00j07s01ByCdepr30() != null
				&& aa00j30s01.getAa00j07s01ByCdepr30().getDescc07() != null) {
			where.append(" AND t2.DESCC07 = ?");
			params.add(aa00j30s01.getAa00j07s01ByCdepr30().getDescc07());
		}
		if (aa00j30s01 != null && aa00j30s01.getAa00j07s01ByCdepr30() != null
				&& aa00j30s01.getAa00j07s01ByCdepr30().getDesce07() != null) {
			where.append(" AND t2.DESCE07 = ?");
			params.add(aa00j30s01.getAa00j07s01ByCdepr30().getDesce07());
		}
		if (aa00j30s01 != null && aa00j30s01.getAa00j07s01ByCdepr30() != null
				&& aa00j30s01.getAa00j07s01ByCdepr30().getSit07() != null) {
			where.append(" AND t2.SIT07 = ?");
			params.add(aa00j30s01.getAa00j07s01ByCdepr30().getSit07());
		}
		if (aa00j30s01 != null && aa00j30s01.getAa00j07s01ByCdepr30() != null
				&& aa00j30s01.getAa00j07s01ByCdepr30().getBloq07() != null) {
			where.append(" AND t2.BLOQ07 = ?");
			params.add(aa00j30s01.getAa00j07s01ByCdepr30().getBloq07());
		}
		if (aa00j30s01 != null && aa00j30s01.getAa00j07s01ByCdepr30() != null
				&& aa00j30s01.getAa00j07s01ByCdepr30().getUsub07() != null) {
			where.append(" AND t2.USUB07 = ?");
			params.add(aa00j30s01.getAa00j07s01ByCdepr30().getUsub07());
		}
		if (aa00j30s01 != null && aa00j30s01.getAa00j07s01ByCdepr30() != null
				&& aa00j30s01.getAa00j07s01ByCdepr30().getCodxlnet07() != null) {
			where.append(" AND t2.COD_XLNET_07 = ?");
			params.add(aa00j30s01.getAa00j07s01ByCdepr30().getCodxlnet07());
		}
		if (aa00j30s01 != null && aa00j30s01.getAa00j07s01ByCdep30() != null
				&& aa00j30s01.getAa00j07s01ByCdep30().getCdep07() != null) {
			where.append(" AND t3.CDEP07 = ?");
			params.add(aa00j30s01.getAa00j07s01ByCdep30().getCdep07());
		}
		if (aa00j30s01 != null && aa00j30s01.getAa00j07s01ByCdep30() != null
				&& aa00j30s01.getAa00j07s01ByCdep30().getDescc07() != null) {
			where.append(" AND t3.DESCC07 = ?");
			params.add(aa00j30s01.getAa00j07s01ByCdep30().getDescc07());
		}
		if (aa00j30s01 != null && aa00j30s01.getAa00j07s01ByCdep30() != null
				&& aa00j30s01.getAa00j07s01ByCdep30().getDesce07() != null) {
			where.append(" AND t3.DESCE07 = ?");
			params.add(aa00j30s01.getAa00j07s01ByCdep30().getDesce07());
		}
		if (aa00j30s01 != null && aa00j30s01.getAa00j07s01ByCdep30() != null
				&& aa00j30s01.getAa00j07s01ByCdep30().getSit07() != null) {
			where.append(" AND t3.SIT07 = ?");
			params.add(aa00j30s01.getAa00j07s01ByCdep30().getSit07());
		}
		if (aa00j30s01 != null && aa00j30s01.getAa00j07s01ByCdep30() != null
				&& aa00j30s01.getAa00j07s01ByCdep30().getBloq07() != null) {
			where.append(" AND t3.BLOQ07 = ?");
			params.add(aa00j30s01.getAa00j07s01ByCdep30().getBloq07());
		}
		if (aa00j30s01 != null && aa00j30s01.getAa00j07s01ByCdep30() != null
				&& aa00j30s01.getAa00j07s01ByCdep30().getUsub07() != null) {
			where.append(" AND t3.USUB07 = ?");
			params.add(aa00j30s01.getAa00j07s01ByCdep30().getUsub07());
		}
		if (aa00j30s01 != null && aa00j30s01.getAa00j07s01ByCdep30() != null
				&& aa00j30s01.getAa00j07s01ByCdep30().getCodxlnet07() != null) {
			where.append(" AND t3.COD_XLNET_07 = ?");
			params.add(aa00j30s01.getAa00j07s01ByCdep30().getCodxlnet07());
		}
		if (aa00j30s01 != null && aa00j30s01.getAa00j13s01() != null
				&& aa00j30s01.getAa00j13s01().getCrec13() != null) {
			where.append(" AND t4.CREC13 = ?");
			params.add(aa00j30s01.getAa00j13s01().getCrec13());
		}
		if (aa00j30s01 != null
				&& aa00j30s01.getAa00j13s01() != null
				&& aa00j30s01.getAa00j13s01().getAa00j03s01() != null
				&& aa00j30s01.getAa00j13s01().getAa00j03s01().getCedif03() != null) {
			where.append(" AND t4.CEDIF13 = ?");
			params.add(aa00j30s01.getAa00j13s01().getAa00j03s01().getCedif03());
		}
		if (aa00j30s01 != null
				&& aa00j30s01.getAa00j13s01() != null
				&& aa00j30s01.getAa00j13s01().getAa00j06s01() != null
				&& aa00j30s01.getAa00j13s01().getAa00j06s01().getCrest06() != null) {
			where.append(" AND t4.CREST13 = ?");
			params.add(aa00j30s01.getAa00j13s01().getAa00j06s01().getCrest06());
		}
		if (aa00j30s01 != null && aa00j30s01.getAa00j13s01() != null
				&& aa00j30s01.getAa00j13s01().getSit13() != null) {
			where.append(" AND t4.SIT13 = ?");
			params.add(aa00j30s01.getAa00j13s01().getSit13());
		}
		if (aa00j30s01 != null && aa00j30s01.getAa00j13s01() != null
				&& aa00j30s01.getAa00j13s01().getBloq13() != null) {
			where.append(" AND t4.BLOQ13 = ?");
			params.add(aa00j30s01.getAa00j13s01().getBloq13());
		}
		if (aa00j30s01 != null && aa00j30s01.getAa00j13s01() != null
				&& aa00j30s01.getAa00j13s01().getNomc13() != null) {
			where.append(" AND t4.NOMC13 = ?");
			params.add(aa00j30s01.getAa00j13s01().getNomc13());
		}
		if (aa00j30s01 != null && aa00j30s01.getAa00j13s01() != null
				&& aa00j30s01.getAa00j13s01().getDescc13() != null) {
			where.append(" AND t4.DESCC13 = ?");
			params.add(aa00j30s01.getAa00j13s01().getDescc13());
		}
		if (aa00j30s01 != null && aa00j30s01.getAa00j13s01() != null
				&& aa00j30s01.getAa00j13s01().getNome13() != null) {
			where.append(" AND t4.NOME13 = ?");
			params.add(aa00j30s01.getAa00j13s01().getNome13());
		}
		if (aa00j30s01 != null && aa00j30s01.getAa00j13s01() != null
				&& aa00j30s01.getAa00j13s01().getDesce13() != null) {
			where.append(" AND t4.DESCE13 = ?");
			params.add(aa00j30s01.getAa00j13s01().getDesce13());
		}
		if (aa00j30s01 != null && aa00j30s01.getAa00j13s01() != null
				&& aa00j30s01.getAa00j13s01().getSwdisp13() != null) {
			where.append(" AND t4.SWDISP13 = ?");
			params.add(aa00j30s01.getAa00j13s01().getSwdisp13());
		}
		if (aa00j30s01 != null
				&& aa00j30s01.getAa00j13s01() != null
				&& aa00j30s01.getAa00j13s01().getAa00j07s01() != null
				&& aa00j30s01.getAa00j13s01().getAa00j07s01().getCdep07() != null) {
			where.append(" AND t4.CDEP13 = ?");
			params.add(aa00j30s01.getAa00j13s01().getAa00j07s01().getCdep07());
		}
		if (aa00j30s01 != null && aa00j30s01.getAa00j13s01() != null
				&& aa00j30s01.getAa00j13s01().getUsub13() != null) {
			where.append(" AND t4.USUB13 = ?");
			params.add(aa00j30s01.getAa00j13s01().getUsub13());
		}
		if (aa00j30s01 != null && aa00j30s01.getSit30() != null) {
			where.append(" AND t1.SIT30 = ?");
			params.add(aa00j30s01.getSit30());
		}
		if (aa00j30s01 != null && aa00j30s01.getBloq30() != null) {
			where.append(" AND t1.BLOQ30 = ?");
			params.add(aa00j30s01.getBloq30());
		}
		if (aa00j30s01 != null && aa00j30s01.getSwfhor30() != null) {
			where.append(" AND t1.SWFHOR30 = ?");
			params.add(aa00j30s01.getSwfhor30());
		}
		if (aa00j30s01 != null && aa00j30s01.getSwmaile30() != null) {
			where.append(" AND t1.SWMAILE30 = ?");
			params.add(aa00j30s01.getSwmaile30());
		}
		if (aa00j30s01 != null && aa00j30s01.getSwmailer30() != null) {
			where.append(" AND t1.SWMAILER30 = ?");
			params.add(aa00j30s01.getSwmailer30());
		}
		if (aa00j30s01 != null && aa00j30s01.getAsun30() != null) {
			where.append(" AND t1.ASUN30 = ?");
			params.add(aa00j30s01.getAsun30());
		}
		if (aa00j30s01 != null && aa00j30s01.getDhcom30() != null) {
			where.append(" AND t1.DHCOM30 = ?");
			params.add(aa00j30s01.getDhcom30());
		}
		if (aa00j30s01 != null && aa00j30s01.getDhfin30() != null) {
			where.append(" AND t1.DHFIN30 = ?");
			params.add(aa00j30s01.getDhfin30());
		}
		if (aa00j30s01 != null && aa00j30s01.getOrgan30() != null) {
			where.append(" AND t1.ORGAN30 = ?");
			params.add(aa00j30s01.getOrgan30());
		}
		if (aa00j30s01 != null && aa00j30s01.getReser30() != null) {
			where.append(" AND t1.RESER30 = ?");
			params.add(aa00j30s01.getReser30());
		}
		if (aa00j30s01 != null && aa00j30s01.getTlfno30() != null) {
			where.append(" AND t1.TLFNO30 = ?");
			params.add(aa00j30s01.getTlfno30());
		}
		if (aa00j30s01 != null && aa00j30s01.getAnomd30() != null) {
			where.append(" AND t1.ANOMD30 = ?");
			params.add(aa00j30s01.getAnomd30());
		}
		if (aa00j30s01 != null && aa00j30s01.getTlfnor30() != null) {
			where.append(" AND t1.TLFNOR30 = ?");
			params.add(aa00j30s01.getTlfnor30());
		}
		if (aa00j30s01 != null && aa00j30s01.getObs30() != null) {
			where.append(" AND t1.OBS30 = ?");
			params.add(aa00j30s01.getObs30());
		}
		if (aa00j30s01 != null && aa00j30s01.getUsub30() != null) {
			where.append(" AND t1.USUB30 = ?");
			params.add(aa00j30s01.getUsub30());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa00j30s01 entity
	 * 
	 * @param aa00j30s01
	 *            Aa00j30s01 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Aa00j30s01 aa00j30s01,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				Aa00j30s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa00j30s01 != null && aa00j30s01.getCod30() != null) {
			where.append(" AND t1.COD30 = ?");
			params.add(aa00j30s01.getCod30());
		}
		if (aa00j30s01 != null && aa00j30s01.getAa00j07s01ByCdepr30() != null
				&& aa00j30s01.getAa00j07s01ByCdepr30().getCdep07() != null) {
			where.append(" AND t2.CDEP07 = ?");
			params.add(aa00j30s01.getAa00j07s01ByCdepr30().getCdep07());
		}
		if (aa00j30s01 != null && aa00j30s01.getAa00j07s01ByCdepr30() != null
				&& aa00j30s01.getAa00j07s01ByCdepr30().getDescc07() != null) {
			where.append(" AND UPPER(t2.DESCC07) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j30s01.getAa00j07s01ByCdepr30().getDescc07()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j30s01.getAa00j07s01ByCdepr30().getDescc07()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.DESCC07 IS NOT NULL");
		}
		if (aa00j30s01 != null && aa00j30s01.getAa00j07s01ByCdepr30() != null
				&& aa00j30s01.getAa00j07s01ByCdepr30().getDesce07() != null) {
			where.append(" AND UPPER(t2.DESCE07) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j30s01.getAa00j07s01ByCdepr30().getDesce07()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j30s01.getAa00j07s01ByCdepr30().getDesce07()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.DESCE07 IS NOT NULL");
		}
		if (aa00j30s01 != null && aa00j30s01.getAa00j07s01ByCdepr30() != null
				&& aa00j30s01.getAa00j07s01ByCdepr30().getSit07() != null) {
			where.append(" AND UPPER(t2.SIT07) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j30s01.getAa00j07s01ByCdepr30().getSit07()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j30s01.getAa00j07s01ByCdepr30().getSit07()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.SIT07 IS NOT NULL");
		}
		if (aa00j30s01 != null && aa00j30s01.getAa00j07s01ByCdepr30() != null
				&& aa00j30s01.getAa00j07s01ByCdepr30().getBloq07() != null) {
			where.append(" AND t2.BLOQ07 = ?");
			params.add(aa00j30s01.getAa00j07s01ByCdepr30().getBloq07());
		}
		if (aa00j30s01 != null && aa00j30s01.getAa00j07s01ByCdepr30() != null
				&& aa00j30s01.getAa00j07s01ByCdepr30().getUsub07() != null) {
			where.append(" AND UPPER(t2.USUB07) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j30s01.getAa00j07s01ByCdepr30().getUsub07()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j30s01.getAa00j07s01ByCdepr30().getUsub07()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.USUB07 IS NOT NULL");
		}
		if (aa00j30s01 != null && aa00j30s01.getAa00j07s01ByCdepr30() != null
				&& aa00j30s01.getAa00j07s01ByCdepr30().getCodxlnet07() != null) {
			where.append(" AND UPPER(t2.COD_XLNET_07) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j30s01.getAa00j07s01ByCdepr30().getCodxlnet07()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j30s01.getAa00j07s01ByCdepr30().getCodxlnet07()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.COD_XLNET_07 IS NOT NULL");
		}
		if (aa00j30s01 != null && aa00j30s01.getAa00j07s01ByCdep30() != null
				&& aa00j30s01.getAa00j07s01ByCdep30().getCdep07() != null) {
			where.append(" AND t3.CDEP07 = ?");
			params.add(aa00j30s01.getAa00j07s01ByCdep30().getCdep07());
		}
		if (aa00j30s01 != null && aa00j30s01.getAa00j07s01ByCdep30() != null
				&& aa00j30s01.getAa00j07s01ByCdep30().getDescc07() != null) {
			where.append(" AND UPPER(t3.DESCC07) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j30s01.getAa00j07s01ByCdep30().getDescc07()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j30s01.getAa00j07s01ByCdep30().getDescc07()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.DESCC07 IS NOT NULL");
		}
		if (aa00j30s01 != null && aa00j30s01.getAa00j07s01ByCdep30() != null
				&& aa00j30s01.getAa00j07s01ByCdep30().getDesce07() != null) {
			where.append(" AND UPPER(t3.DESCE07) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j30s01.getAa00j07s01ByCdep30().getDesce07()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j30s01.getAa00j07s01ByCdep30().getDesce07()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.DESCE07 IS NOT NULL");
		}
		if (aa00j30s01 != null && aa00j30s01.getAa00j07s01ByCdep30() != null
				&& aa00j30s01.getAa00j07s01ByCdep30().getSit07() != null) {
			where.append(" AND UPPER(t3.SIT07) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j30s01.getAa00j07s01ByCdep30().getSit07()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j30s01.getAa00j07s01ByCdep30().getSit07()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.SIT07 IS NOT NULL");
		}
		if (aa00j30s01 != null && aa00j30s01.getAa00j07s01ByCdep30() != null
				&& aa00j30s01.getAa00j07s01ByCdep30().getBloq07() != null) {
			where.append(" AND t3.BLOQ07 = ?");
			params.add(aa00j30s01.getAa00j07s01ByCdep30().getBloq07());
		}
		if (aa00j30s01 != null && aa00j30s01.getAa00j07s01ByCdep30() != null
				&& aa00j30s01.getAa00j07s01ByCdep30().getUsub07() != null) {
			where.append(" AND UPPER(t3.USUB07) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j30s01.getAa00j07s01ByCdep30().getUsub07()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j30s01.getAa00j07s01ByCdep30().getUsub07()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.USUB07 IS NOT NULL");
		}
		if (aa00j30s01 != null && aa00j30s01.getAa00j07s01ByCdep30() != null
				&& aa00j30s01.getAa00j07s01ByCdep30().getCodxlnet07() != null) {
			where.append(" AND UPPER(t3.COD_XLNET_07) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j30s01.getAa00j07s01ByCdep30().getCodxlnet07()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j30s01.getAa00j07s01ByCdep30().getCodxlnet07()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.COD_XLNET_07 IS NOT NULL");
		}
		if (aa00j30s01 != null && aa00j30s01.getAa00j13s01() != null
				&& aa00j30s01.getAa00j13s01().getCrec13() != null) {
			where.append(" AND t4.CREC13 = ?");
			params.add(aa00j30s01.getAa00j13s01().getCrec13());
		}
		if (aa00j30s01 != null
				&& aa00j30s01.getAa00j13s01() != null
				&& aa00j30s01.getAa00j13s01().getAa00j03s01() != null
				&& aa00j30s01.getAa00j13s01().getAa00j03s01().getCedif03() != null) {
			where.append(" AND t4.CEDIF13 = ?");
			params.add(aa00j30s01.getAa00j13s01().getAa00j03s01().getCedif03());
		}
		if (aa00j30s01 != null
				&& aa00j30s01.getAa00j13s01() != null
				&& aa00j30s01.getAa00j13s01().getAa00j06s01() != null
				&& aa00j30s01.getAa00j13s01().getAa00j06s01().getCrest06() != null) {
			where.append(" AND t4.CREST13 = ?");
			params.add(aa00j30s01.getAa00j13s01().getAa00j06s01().getCrest06());
		}
		if (aa00j30s01 != null && aa00j30s01.getAa00j13s01() != null
				&& aa00j30s01.getAa00j13s01().getSit13() != null) {
			where.append(" AND UPPER(t4.SIT13) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j30s01.getAa00j13s01().getSit13().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j30s01.getAa00j13s01().getSit13().toUpperCase()
						+ "%");
			}
			where.append(" AND t4.SIT13 IS NOT NULL");
		}
		if (aa00j30s01 != null && aa00j30s01.getAa00j13s01() != null
				&& aa00j30s01.getAa00j13s01().getBloq13() != null) {
			where.append(" AND t4.BLOQ13 = ?");
			params.add(aa00j30s01.getAa00j13s01().getBloq13());
		}
		if (aa00j30s01 != null && aa00j30s01.getAa00j13s01() != null
				&& aa00j30s01.getAa00j13s01().getNomc13() != null) {
			where.append(" AND UPPER(t4.NOMC13) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j30s01.getAa00j13s01().getNomc13().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j30s01.getAa00j13s01().getNomc13().toUpperCase()
						+ "%");
			}
			where.append(" AND t4.NOMC13 IS NOT NULL");
		}
		if (aa00j30s01 != null && aa00j30s01.getAa00j13s01() != null
				&& aa00j30s01.getAa00j13s01().getDescc13() != null) {
			where.append(" AND UPPER(t4.DESCC13) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j30s01.getAa00j13s01().getDescc13()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j30s01.getAa00j13s01().getDescc13().toUpperCase()
						+ "%");
			}
			where.append(" AND t4.DESCC13 IS NOT NULL");
		}
		if (aa00j30s01 != null && aa00j30s01.getAa00j13s01() != null
				&& aa00j30s01.getAa00j13s01().getNome13() != null) {
			where.append(" AND UPPER(t4.NOME13) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j30s01.getAa00j13s01().getNome13().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j30s01.getAa00j13s01().getNome13().toUpperCase()
						+ "%");
			}
			where.append(" AND t4.NOME13 IS NOT NULL");
		}
		if (aa00j30s01 != null && aa00j30s01.getAa00j13s01() != null
				&& aa00j30s01.getAa00j13s01().getDesce13() != null) {
			where.append(" AND UPPER(t4.DESCE13) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j30s01.getAa00j13s01().getDesce13()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j30s01.getAa00j13s01().getDesce13().toUpperCase()
						+ "%");
			}
			where.append(" AND t4.DESCE13 IS NOT NULL");
		}
		if (aa00j30s01 != null && aa00j30s01.getAa00j13s01() != null
				&& aa00j30s01.getAa00j13s01().getSwdisp13() != null) {
			where.append(" AND t4.SWDISP13 = ?");
			params.add(aa00j30s01.getAa00j13s01().getSwdisp13());
		}
		if (aa00j30s01 != null
				&& aa00j30s01.getAa00j13s01() != null
				&& aa00j30s01.getAa00j13s01().getAa00j07s01() != null
				&& aa00j30s01.getAa00j13s01().getAa00j07s01().getCdep07() != null) {
			where.append(" AND t4.CDEP13 = ?");
			params.add(aa00j30s01.getAa00j13s01().getAa00j07s01().getCdep07());
		}
		if (aa00j30s01 != null && aa00j30s01.getAa00j13s01() != null
				&& aa00j30s01.getAa00j13s01().getUsub13() != null) {
			where.append(" AND UPPER(t4.USUB13) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j30s01.getAa00j13s01().getUsub13().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j30s01.getAa00j13s01().getUsub13().toUpperCase()
						+ "%");
			}
			where.append(" AND t4.USUB13 IS NOT NULL");
		}
		if (aa00j30s01 != null && aa00j30s01.getSit30() != null) {
			where.append(" AND UPPER(t1.SIT30) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j30s01.getSit30().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j30s01.getSit30().toUpperCase() + "%");
			}
			where.append(" AND t1.SIT30 IS NOT NULL");
		}
		if (aa00j30s01 != null && aa00j30s01.getBloq30() != null) {
			where.append(" AND t1.BLOQ30 = ?");
			params.add(aa00j30s01.getBloq30());
		}
		if (aa00j30s01 != null && aa00j30s01.getSwfhor30() != null) {
			where.append(" AND t1.SWFHOR30 = ?");
			params.add(aa00j30s01.getSwfhor30());
		}
		if (aa00j30s01 != null && aa00j30s01.getSwmaile30() != null) {
			where.append(" AND t1.SWMAILE30 = ?");
			params.add(aa00j30s01.getSwmaile30());
		}
		if (aa00j30s01 != null && aa00j30s01.getSwmailer30() != null) {
			where.append(" AND t1.SWMAILER30 = ?");
			params.add(aa00j30s01.getSwmailer30());
		}
		if (aa00j30s01 != null && aa00j30s01.getAsun30() != null) {
			where.append(" AND UPPER(t1.ASUN30) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j30s01.getAsun30().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j30s01.getAsun30().toUpperCase() + "%");
			}
			where.append(" AND t1.ASUN30 IS NOT NULL");
		}
		if (aa00j30s01 != null && aa00j30s01.getDhcom30() != null) {
			where.append(" AND t1.DHCOM30 = ?");
			params.add(aa00j30s01.getDhcom30());
		}
		if (aa00j30s01 != null && aa00j30s01.getDhfin30() != null) {
			where.append(" AND t1.DHFIN30 = ?");
			params.add(aa00j30s01.getDhfin30());
		}
		if (aa00j30s01 != null && aa00j30s01.getOrgan30() != null) {
			where.append(" AND UPPER(t1.ORGAN30) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j30s01.getOrgan30().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j30s01.getOrgan30().toUpperCase() + "%");
			}
			where.append(" AND t1.ORGAN30 IS NOT NULL");
		}
		if (aa00j30s01 != null && aa00j30s01.getReser30() != null) {
			where.append(" AND UPPER(t1.RESER30) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j30s01.getReser30().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j30s01.getReser30().toUpperCase() + "%");
			}
			where.append(" AND t1.RESER30 IS NOT NULL");
		}
		if (aa00j30s01 != null && aa00j30s01.getTlfno30() != null) {
			where.append(" AND UPPER(t1.TLFNO30) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j30s01.getTlfno30().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j30s01.getTlfno30().toUpperCase() + "%");
			}
			where.append(" AND t1.TLFNO30 IS NOT NULL");
		}
		if (aa00j30s01 != null && aa00j30s01.getAnomd30() != null) {
			where.append(" AND UPPER(t1.ANOMD30) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j30s01.getAnomd30().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j30s01.getAnomd30().toUpperCase() + "%");
			}
			where.append(" AND t1.ANOMD30 IS NOT NULL");
		}
		if (aa00j30s01 != null && aa00j30s01.getTlfnor30() != null) {
			where.append(" AND UPPER(t1.TLFNOR30) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j30s01.getTlfnor30().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j30s01.getTlfnor30().toUpperCase() + "%");
			}
			where.append(" AND t1.TLFNOR30 IS NOT NULL");
		}
		if (aa00j30s01 != null && aa00j30s01.getObs30() != null) {
			where.append(" AND UPPER(t1.OBS30) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j30s01.getObs30().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j30s01.getObs30().toUpperCase() + "%");
			}
			where.append(" AND t1.OBS30 IS NOT NULL");
		}
		if (aa00j30s01 != null && aa00j30s01.getUsub30() != null) {
			where.append(" AND UPPER(t1.USUB30) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j30s01.getUsub30().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j30s01.getUsub30().toUpperCase() + "%");
			}
			where.append(" AND t1.USUB30 IS NOT NULL");
		}
		// Iker días y horas
		if (aa00j30s01 != null && aa00j30s01.getDias() != null) {
			where.append(" AND ( 1=2 ");
			String diaswhere = " OR TRUNC(DHCOM30)=to_date(?,':f')";
			String[] dias = aa00j30s01.getDias().split(",");
			for (String dia : dias) {
				where.append(diaswhere);
				params.add(dia);
			}
			where.append(" )");
		} else {
			where.append(" AND ( TRUNC(DHCOM30)>=TRUNC(SYSDATE))");
		}

		if (aa00j30s01 != null && aa00j30s01.getHoraIni() != null) {
			where.append(" AND to_char(DHCOM30,'HH24:MM')>= ? ");
			params.add(aa00j30s01.getHoraIni());
		}

		if (aa00j30s01 != null && aa00j30s01.getHoraFin() != null) {
			where.append(" AND to_char(DHFIN30,'HH24:MM')<= ? ");
			params.add(aa00j30s01.getHoraFin());
		}
		//

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	public boolean existeDepartamento(Long cdep30) {
		Aa00j30s01DaoImpl.logger.info("Método existeDepartamento");
		String query = "SELECT COUNT(1) FROM AA00J30S01 WHERE UPPER(CDEP30) = ?";
		Aa00j30s01DaoImpl.logger.info("SQL " + query.toString());
		Aa00j30s01DaoImpl.logger.info("PARAMS " + cdep30);
		return this.jdbcTemplate.queryForInt(query, cdep30) > 0;
	}

	public boolean existeRecurso(Long crec30) {
		Aa00j30s01DaoImpl.logger.info("Método existeRecurso");
		String query = "SELECT COUNT(1) FROM AA00J30S01 WHERE UPPER(CREC30) = ?";
		Aa00j30s01DaoImpl.logger.info("SQL " + query.toString());
		Aa00j30s01DaoImpl.logger.info("PARAMS " + crec30);
		return this.jdbcTemplate.queryForInt(query, crec30) > 0;
	}

	public boolean existeRecursoDisponible(Long crec30, Date fechaHoraIni,
			Date fechaHoraFin, Long codReservaExcluir,
			Long codReservaSalaExcluir) {
		Aa00j30s01DaoImpl.logger.info("Método existeRecursoDisponible");

		StringBuilder query = new StringBuilder(
				Aa00j20s01DaoImpl.STRING_BUILDER_INIT);
		query.append("SELECT COUNT(1) FROM AA00J30S01 WHERE SIT30=? AND CREC30 = ?");
		query.append(" AND TO_DATE(TO_CHAR(DHCOM30, :f), :f) < TO_DATE(TO_CHAR(?, :f), :f) ");
		query.append(" AND TO_DATE(TO_CHAR(DHFIN30, :f), :f) > TO_DATE(TO_CHAR(?, :f), :f) ");
		if (codReservaExcluir != null) {
			query.append(" AND COD30 <> ? ");
		}
		if (codReservaSalaExcluir != null) {
			query.append(" AND CODRSALA30 <> ? ");
		}

		String strQuery = query.toString();
		strQuery = strQuery.replace(":f", aa00jConstantes.FORMATOFECHAHORA_BD);

		List<Object> params = new ArrayList<Object>();
		params.add(aa00jConstantes.SITUACION_ALTA);
		params.add(crec30);
		params.add(fechaHoraFin);
		params.add(fechaHoraIni);
		if (codReservaExcluir != null) {
			params.add(codReservaExcluir);
		}
		if (codReservaSalaExcluir != null) {
			params.add(codReservaSalaExcluir);
		}
		Aa00j30s01DaoImpl.logger.info("SQL " + strQuery);
		Aa00j30s01DaoImpl.logger.info("PARAMS " + params);
		return this.jdbcTemplate.queryForInt(strQuery, params.toArray()) == 0;
	}

	public List<Aa00j30s01> obtenerOcupacionesFechas(Long crec30,
			Date fechaHoraIni, Date fechaHoraFin, Long codReservaExcluir,
			Long codReservaSalaExcluir) {
		Aa00j30s01DaoImpl.logger.info("Método obtenerOcupacionesFechas");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.COD30 COD30,t1.SIT30 SIT30,t1.BLOQ30 BLOQ30,t1.EMAIL30 EMAIL30,t1.EMAILR30 EMAILR30,t1.SWFHOR30 SWFHOR30,t1.SWMAILE30 SWMAILE30,t1.SWMAILER30 SWMAILER30,t1.ASUN30 ASUN30,t1.DHCOM30 DHCOM30,t1.DHFIN30 DHFIN30,t1.ORGAN30 ORGAN30,t1.RESER30 RESER30,t1.TLFNO30 TLFNO30,t1.ANOMD30 ANOMD30,t1.CRESP30 CRESP30,t1.TLFNOR30 TLFNOR30,t1.OBS30 OBS30,t1.USUB30 USUB30,null AA00J07S01CDEP07,null AA00J07S01DESCC07,null AA00J07S01DESCE07,null AA00J07S01SIT07,null AA00J07S01BLOQ07,null AA00J07S01USUB07,null AA00J07S01COD_XLNET_07,null AA00J07S01CDEP07_r,null AA00J07S01DESCC07_r,null AA00J07S01DESCE07_r,null AA00J07S01SIT07_r,null AA00J07S01BLOQ07_r,null AA00J07S01USUB07_r,null AA00J07S01COD_XLNET_07_r,null AA00J13S01CREC13,null AA00J13S01SIT13,null AA00J13S01BLOQ13,null AA00J13S01NOMC13,null AA00J13S01DESCC13,null AA00J13S01NOME13,null AA00J13S01DESCE13,null AA00J13S01SWDISP13,null AA00J13S01CDEP13,null AA00J13S01USUB13,null AA00J13S01CEDIF13,null AA00J13S01CREST13, t1.CODRSALA30 Aa00j20s01COD20 ");

		query.append("FROM AA00J30S01 t1 ");
		query.append(" WHERE SIT30=? AND CREC30 = ? ");
		query.append(" AND TO_DATE(TO_CHAR(DHCOM30, :f), :f) < TO_DATE(TO_CHAR(?, :f), :f) ");
		query.append(" AND TO_DATE(TO_CHAR(DHFIN30, :f), :f) > TO_DATE(TO_CHAR(?, :f), :f) ");
		if (codReservaExcluir != null) {
			query.append(" AND COD30 <> ? ");
		}
		if (codReservaSalaExcluir != null) {
			query.append(" AND CODRSALA30 <> ? ");
		}
		query.append(" ORDER BY DHCOM30,DHFIN30 ");

		String strQuery = query.toString();
		strQuery = strQuery.replace(":f", aa00jConstantes.FORMATOFECHAHORA_BD);

		List<Object> params = new ArrayList<Object>();
		params.add(aa00jConstantes.SITUACION_ALTA);
		params.add(crec30);
		params.add(fechaHoraFin);
		params.add(fechaHoraIni);
		if (codReservaExcluir != null) {
			params.add(codReservaExcluir);
		}
		if (codReservaSalaExcluir != null) {
			params.add(codReservaSalaExcluir);
		}
		Aa00j30s01DaoImpl.logger.info("SQL " + strQuery);
		Aa00j30s01DaoImpl.logger.info("PARAMS " + params);
		return (List<Aa00j30s01>) this.jdbcTemplate.query(strQuery, this.rwMap,
				params.toArray());
	}

	/**
	 * Devuelve la lista de ocupaciones en las fechas de entrada parael recurso
	 * de entrada de entrada
	 * 
	 * @param csala20
	 * @param fechas
	 * 
	 * @return
	 */
	public List<Aa00j30s01> obtenerOcupacionesRecursosFechas(Long csala20,
			ArrayList<Date> fechas) {
		Aa00j30s01DaoImpl.logger
				.info("Método obtenerOcupacionesRecursosFechas");
		List<Object> params = new ArrayList<Object>();
		params.add(aa00jConstantes.SITUACION_ALTA);
		params.add(csala20);

		StringBuilder query = new StringBuilder(
				"SELECT  t1.COD30 COD30,t1.SIT30 SIT30,t1.BLOQ30 BLOQ30,t1.EMAIL30 EMAIL30,t1.EMAILR30 EMAILR30,t1.SWFHOR30 SWFHOR30,t1.SWMAILE30 SWMAILE30,t1.SWMAILER30 SWMAILER30,t1.ASUN30 ASUN30,t1.DHCOM30 DHCOM30,t1.DHFIN30 DHFIN30,t1.ORGAN30 ORGAN30,t1.RESER30 RESER30,t1.TLFNO30 TLFNO30,t1.ANOMD30 ANOMD30,t1.CRESP30 CRESP30,t1.TLFNOR30 TLFNOR30,t1.OBS30 OBS30,t1.USUB30 USUB30,null AA00J07S01CDEP07,null AA00J07S01DESCC07,null AA00J07S01DESCE07,null AA00J07S01SIT07,null AA00J07S01BLOQ07,null AA00J07S01USUB07,null AA00J07S01COD_XLNET_07,null AA00J07S01CDEP07_r,null AA00J07S01DESCC07_r,null AA00J07S01DESCE07_r,null AA00J07S01SIT07_r,null AA00J07S01BLOQ07_r,null AA00J07S01USUB07_r,null AA00J07S01COD_XLNET_07_r,null AA00J13S01CREC13,null AA00J13S01SIT13,null AA00J13S01BLOQ13,null AA00J13S01NOMC13,null AA00J13S01DESCC13,null AA00J13S01NOME13,null AA00J13S01DESCE13,null AA00J13S01SWDISP13,null AA00J13S01CDEP13,null AA00J13S01USUB13,null AA00J13S01CEDIF13,null AA00J13S01CREST13, t1.CODRSALA30 Aa00j20s01COD20 ");

		query.append("FROM AA00J30S01 t1 ");
		query.append(" WHERE SIT30=? AND CREC30 = ? ");
		if (fechas.size() > 0)
			query.append(" AND ( ");
		boolean init = true;
		for (Date cur : fechas) {
			if (!init)
				query.append(" OR ");
			query.append("  trunc(DHCOM30)= ?");
			init = false;
			params.add(new java.sql.Timestamp(cur.getTime()));
		}
		if (fechas.size() > 0)
			query.append(" ) ");
		query.append(" ORDER BY DHCOM30,DHFIN30, CREC30 ");

		String strQuery = query.toString();
		// strQuery = strQuery.replace(":f",
		// aa00jConstantes.FORMATOFECHAHORA_BD);
		Aa00j30s01DaoImpl.logger.info("SQL " + strQuery);
		Aa00j30s01DaoImpl.logger.info("PARAMS " + params);
		return (List<Aa00j30s01>) this.jdbcTemplate.query(strQuery, this.rwMap,
				params.toArray());
	}

	public boolean actualizarMailsEnviados(Long cod30, int mailsEnviados,
			int mailsEnviadoR) {
		Aa00j30s01DaoImpl.logger.info("Método actualizarMailsEnviados");
		String query = "UPDATE AA00J30S01 SET SWMAILE30=?,SWMAILER30=? WHERE COD30=?";
		Aa00j30s01DaoImpl.logger.info("SQL " + query);
		Aa00j30s01DaoImpl.logger.info("PARAM1 " + mailsEnviados);
		Aa00j30s01DaoImpl.logger.info("PARAM2 " + mailsEnviadoR);
		Aa00j30s01DaoImpl.logger.info("PARAM3 " + cod30);
		return this.jdbcTemplate.update(query, mailsEnviados, mailsEnviadoR,
				cod30) > 0;
	}

	public boolean actualizarMailsEnviadosReservaSala(Long codrsala30,
			int mailsEnviados, int mailsEnviadoR) {
		Aa00j30s01DaoImpl.logger
				.info("Método actualizarMailsEnviadosReservaSala");
		String query = "UPDATE AA00J30S01 SET SWMAILE30=?,SWMAILER30=?  WHERE CODRSALA30=?";
		Aa00j30s01DaoImpl.logger.info("SQL " + query);
		Aa00j30s01DaoImpl.logger.info("PARAM1 " + mailsEnviados);
		Aa00j30s01DaoImpl.logger.info("PARAM2 " + mailsEnviadoR);
		Aa00j30s01DaoImpl.logger.info("PARAM3 " + codrsala30);
		return this.jdbcTemplate.update(query, mailsEnviados, mailsEnviadoR,
				codrsala30) > 0;
	}

	public boolean anularPorReservaSala(Long codrsala30, String usuario) {
		Aa00j30s01DaoImpl.logger.info("Método anularPorReservaSala");
		String query = "UPDATE AA00J30S01 SET SIT30=?, USUANUL30=? WHERE CODRSALA30=? AND SIT30=?";
		Aa00j30s01DaoImpl.logger.info("SQL " + query);
		Aa00j30s01DaoImpl.logger.info("PARAM1 "
				+ aa00jConstantes.SITUACION_BAJA);
		Aa00j30s01DaoImpl.logger.info("PARAM2 " + usuario);
		Aa00j30s01DaoImpl.logger.info("PARAM3 " + codrsala30);
		Aa00j30s01DaoImpl.logger.info("PARAM4 "
				+ aa00jConstantes.SITUACION_ALTA);
		return this.jdbcTemplate.update(query, aa00jConstantes.SITUACION_BAJA,
				usuario, codrsala30, aa00jConstantes.SITUACION_ALTA) > 0;
	}

	public boolean confirmarPorReservaSala(Long codrsala30, String usuario) {
		Aa00j30s01DaoImpl.logger.info("Método confirmarPorReservaSala");
		String query = "UPDATE AA00J30S01 SET SWCONF30=?, USUANUL30=? WHERE CODRSALA30=? AND SIT30=? AND NVL(SWCONF,0)=?";
		Aa00j30s01DaoImpl.logger.info("SQL " + query);

		Aa00j30s01DaoImpl.logger.info("PARAM1 " + usuario);
		Aa00j30s01DaoImpl.logger.info("PARAM2 " + codrsala30);
		Aa00j30s01DaoImpl.logger.info("PARAM3 "
				+ aa00jConstantes.SITUACION_ALTA);
		return this.jdbcTemplate.update(query, 1, usuario, codrsala30,
				aa00jConstantes.SITUACION_ALTA, 0) > 0;
	}

	public boolean anular(Long cod30, String usuario) {
		Aa00j30s01DaoImpl.logger.info("Método anular");
		Aa00j30s01DaoImpl.logger.info("Anulando reserva de recurso");
		String query = "UPDATE AA00J30S01 SET SIT30=?, USUANUL30=? WHERE COD30=? AND SIT30=?";

		Aa00j30s01DaoImpl.logger.info("SQL " + query);
		Aa00j30s01DaoImpl.logger.info("PARAM1 "
				+ aa00jConstantes.SITUACION_BAJA);
		Aa00j30s01DaoImpl.logger.info("PARAM2 " + usuario);
		Aa00j30s01DaoImpl.logger.info("PARAM3 " + cod30);
		Aa00j30s01DaoImpl.logger.info("PARAM4 "
				+ aa00jConstantes.SITUACION_ALTA);
		return this.jdbcTemplate.update(query, aa00jConstantes.SITUACION_BAJA,
				usuario, cod30, aa00jConstantes.SITUACION_ALTA) > 0;
	}

	public boolean confirmar(Long cod30, String usuario) {

		Aa00j30s01DaoImpl.logger.info("Método confirmar");
		String query = "UPDATE AA00J30S01 SET SWCONF30=?, USUANUL30=? WHERE COD30=? AND SIT30=? AND NVL(SWCONF,0)=?";
		Aa00j30s01DaoImpl.logger.info("SQL " + query);

		Aa00j30s01DaoImpl.logger.info("PARAM2 " + usuario);
		Aa00j30s01DaoImpl.logger.info("PARAM3 " + cod30);
		Aa00j30s01DaoImpl.logger.info("PARAM4 "
				+ aa00jConstantes.SITUACION_ALTA);
		return this.jdbcTemplate.update(query, 1, usuario, cod30,
				aa00jConstantes.SITUACION_ALTA, 0) > 0;
	}

	public boolean eliminarPorReservaSala(Long codrsala30) {
		Aa00j30s01DaoImpl.logger.info("Método eliminarPorReservaSala");
		String query = "DELETE AA00J30S01 WHERE CODRSALA30=?";
		Aa00j30s01DaoImpl.logger.info("SQL " + query);

		Aa00j30s01DaoImpl.logger.info("PARAM1 " + codrsala30);

		return this.jdbcTemplate.update(query, codrsala30) > 0;
	}

	public boolean actualizarDatos(Long cod30, String obs30, String asun30,
			Date dhcom30, Date dhfin30, Integer swfhor30, Long crec30) {
		Aa00j30s01DaoImpl.logger.info("Método actualizarDatos");
		String query = "UPDATE AA00J30S01 SET OBS30=?, ASUN30=?, DHCOM30=?, DHFIN30=?, SWFHOR30=?, CREC30=? WHERE COD30=?";

		List<Object> params = new ArrayList<Object>();
		params.add(obs30);
		params.add(asun30);
		params.add(new java.sql.Timestamp(dhcom30.getTime()));
		params.add(new java.sql.Timestamp(dhfin30.getTime()));
		params.add(swfhor30);
		params.add(crec30);
		params.add(cod30);
		Aa00j30s01DaoImpl.logger.info("SQL " + query);

		Aa00j30s01DaoImpl.logger.info("PARAMS " + params);
		return this.jdbcTemplate.update(query, params.toArray()) > 0;
	}

	/**
	 * Devuelve una lista de reservas que tengan alguno de los estados de mail
	 * sin enviar
	 * 
	 * @return
	 */

	public ArrayList<Aa00j30s01> obtenerReservasSinEnviar() {
		Aa00j30s01DaoImpl.logger.info("Método obtenerReservasSinEnviar");

		StringBuilder query = new StringBuilder(
				"SELECT  t1.COD30 COD30,t1.SIT30 SIT30,t1.BLOQ30 BLOQ30,t1.EMAIL30 EMAIL30,t1.EMAILR30 EMAILR30,t1.SWFHOR30 SWFHOR30,t1.SWMAILE30 SWMAILE30,t1.SWMAILER30 SWMAILER30,t1.ASUN30 ASUN30,t1.DHCOM30 DHCOM30,t1.DHFIN30 DHFIN30,t1.ORGAN30 ORGAN30,t1.RESER30 RESER30,t1.TLFNO30 TLFNO30,t1.ANOMD30 ANOMD30,t1.CRESP30 CRESP30,t1.TLFNOR30 TLFNOR30,t1.OBS30 OBS30,t1.USUB30 USUB30,null AA00J07S01CDEP07,null AA00J07S01DESCC07,null AA00J07S01DESCE07,null AA00J07S01SIT07,null AA00J07S01BLOQ07,null AA00J07S01USUB07,null AA00J07S01COD_XLNET_07,null AA00J07S01CDEP07_r,null AA00J07S01DESCC07_r,null AA00J07S01DESCE07_r,null AA00J07S01SIT07_r,null AA00J07S01BLOQ07_r,null AA00J07S01USUB07_r,null AA00J07S01COD_XLNET_07_r,null AA00J13S01CREC13,null AA00J13S01SIT13,null AA00J13S01BLOQ13,null AA00J13S01NOMC13,null AA00J13S01DESCC13,null AA00J13S01NOME13,null AA00J13S01DESCE13,null AA00J13S01SWDISP13,null AA00J13S01CDEP13,null AA00J13S01USUB13,null AA00J13S01CEDIF13,null AA00J13S01CREST13, t1.CODRSALA30 Aa00j20s01COD20 ");

		query.append("FROM AA00J30S01 t1  where trunc(DHCOM30)>trunc(SYSDATE)   and SIT30='A' and codrsala30 is null   and (swmaile30=0 or swmailer30=0)");
		Aa00j30s01DaoImpl.logger.info("sql " + query.toString());

		return (ArrayList<Aa00j30s01>) this.jdbcTemplate.query(
				query.toString(), this.rwMap);

	}

	/**
	 * Dar de baja reservas sin confirmar con fecha menor o igual a la actual
	 * que no estén confirmadas y estén de alta
	 * 
	 * @return
	 */
	/*
	 * public int darDeBajaAntiguas() {
	 * Aa00j30s01DaoImpl.logger.info("Método darDeBajaAntiguas");
	 * Aa00j30s01DaoImpl.logger.info("Dar de baja antiguas "); String query =
	 * "update  aa00j30S01 	set SIT30='B'	, USUANUL30='Sistema' WHERE SWCONF30     =0	AND SIT30          ='A'		AND TRUNC(dhcom30)<=TRUNC(SYSDATE)"
	 * ; Aa00j30s01DaoImpl.logger.info("sql " + query); int count =
	 * this.jdbcTemplate.update(query); Aa00j30s01DaoImpl.logger
	 * .info("Registros dados de baja automáticamente " + count); return count;
	 * }
	 */
}