package com.ejie.aa00j.dao;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import com.ejie.aa00j.model.Aa00j30s01;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa00j30s01Dao generated by UDA, 16-oct-2013 13:02:12.
 * 
 * @author UDA
 */

public interface Aa00j30s01Dao {

	/**
	 * Inserts a single row in the Aa00j30s01 table.
	 * 
	 * @param aa00j30s01
	 *            Aa00j30s01
	 * @return Aa00j30s01
	 */
	Aa00j30s01 add(Aa00j30s01 aa00j30s01);

	/**
	 * Updates a single row in the Aa00j30s01 table.
	 * 
	 * @param aa00j30s01
	 *            Aa00j30s01
	 * @return Aa00j30s01
	 */
	Aa00j30s01 update(Aa00j30s01 aa00j30s01);

	/**
	 * Finds a single row in the Aa00j30s01 table.
	 * 
	 * @param aa00j30s01
	 *            Aa00j30s01
	 * @return Aa00j30s01
	 */
	Aa00j30s01 find(Aa00j30s01 aa00j30s01);

	/**
	 * Removes a single row in the Aa00j30s01 table.
	 * 
	 * @param aa00j30s01
	 *            Aa00j30s01
	 */
	void remove(Aa00j30s01 aa00j30s01);

	/**
	 * Finds a List of rows in the Aa00j30s01 table.
	 * 
	 * @param aa00j30s01
	 *            Aa00j30s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List
	 */
	List<Aa00j30s01> findAll(Aa00j30s01 aa00j30s01,
			JQGridRequestDto jqGridRequestDto, String codDepto,
			String codUsuario);

	/**
	 * Finds rows in the Aa00j30s01 table using like.
	 * 
	 * @param aa00j30s01
	 *            Aa00j30s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Aa00j30s01> findAllLike(Aa00j30s01 aa00j30s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith,
			String codDepto, String codUsuario, Locale locale);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter in the Aa00j30s01 table.
	 * 
	 * @param filterAa00j30s01
	 *            Aa00j30s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(Aa00j30s01 filterAa00j30s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Counts rows in the Aa00j30s01 table using like.
	 * 
	 * @param aa00j30s01
	 *            Aa00j30s01
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Aa00j30s01 aa00j30s01, Boolean startsWith,
			String codDepto, String codUsuario, Locale locale);

	/**
	 * Counts rows in the Aa00j30s01 table.
	 * 
	 * @param aa00j30s01
	 *            Aa00j30s01
	 * @return Long
	 */
	Long findAllCount(Aa00j30s01 aa00j30s01, String codDepto, String codUsuario);

	/**
	 * Reorder selection.
	 * 
	 * @param filterAa00j30s01
	 *            Aa00j30s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j30s01>>
	 */
	List<TableRowDto<Aa00j30s01>> reorderSelection(Aa00j30s01 filterAa00j30s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith,
			String codDepto, String codUsuario);

	/**
	 * Searches in the Usuario table.
	 * 
	 * @param filterAa00j30s01
	 *            Aa00j30s01
	 * @param searchAa00j30s01
	 *            Aa00j30s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j30s01>>
	 */
	List<TableRowDto<Aa00j30s01>> search(Aa00j30s01 filterAa00j30s01,
			Aa00j30s01 searchAa00j30s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith, String codDepto, String codUsuario);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Filter in the hierarchical Aa00j30s01 table.
	 * 
	 * @param filterAa00j30s01
	 *            Aa00j30s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Aa00j30s01>>
	 */
	List<JerarquiaDto<Aa00j30s01>> findAllLikeJerarquia(
			Aa00j30s01 filterAa00j30s01, JQGridRequestDto jqGridRequestDto);

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAa00j30s01
	 *            Aa00j30s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	Long findAllLikeCountJerarquia(Aa00j30s01 filterAa00j30s01,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAa00j30s01
	 *            Aa00j30s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Aa00j30s01>>
	 */
	List<TableRowDto<Aa00j30s01>> findAllChild(Aa00j30s01 filterAa00j30s01,
			JQGridRequestDto jqGridRequestDto);

	boolean existeDepartamento(Long cdep30);

	boolean existeRecurso(Long crec30);

	boolean existeRecursoDisponible(Long crec30, Date fechaHoraIni,
			Date fechaHoraFin, Long codReservaExcluir,
			Long codReservaSalaExcluir);

	public List<Aa00j30s01> obtenerOcupacionesFechas(Long crec30,
			Date fechaHoraIni, Date fechaHoraFin, Long codReservaExcluir,
			Long codReservaSalaExcluir);

	boolean actualizarMailsEnviados(Long cod30, int mailsEnviados,
			int mailsEnviadoR);

	boolean actualizarMailsEnviadosReservaSala(Long codrsala30,
			int mailsEnviados, int mailsEnviadoR);

	public boolean anularPorReservaSala(Long codrsala30, String usuario);

	public boolean confirmarPorReservaSala(Long codrsala30, String usuario);

	public boolean anular(Long cod30, String usuario);

	public boolean confirmar(Long cod30, String usuario);

	public boolean eliminarPorReservaSala(Long codrsala30);

	boolean actualizarDatos(Long cod30, String obs30, String asun30,
			Date dhcom30, Date dhfin30, Integer swfhor30, Long crec30);

	/**
	 * Devuelve la lista de ocupaciones en las fechas de entrada parael recurso
	 * de entrada de entrada
	 * 
	 * @param csala20
	 * @param fechas
	 * 
	 * @return
	 */
	public List<Aa00j30s01> obtenerOcupacionesRecursosFechas(Long csala20,
			ArrayList<Date> fechas);

	/**
	 * Devuelve una lista de reservas que tengan alguno de los estados de mail
	 * sin enviar
	 * 
	 * @return
	 */

	public ArrayList<Aa00j30s01> obtenerReservasSinEnviar();
}