package com.ejie.aa00j.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import weblogic.utils.StringUtils;

import com.ejie.aa00j.classes.aa00jConstantes;
import com.ejie.aa00j.classes.aa00jPersonaSesion;
import com.ejie.aa00j.classes.aa00jSeguridad;

import com.ejie.aa00j.model.Aa00j03s01;
import com.ejie.aa00j.model.Aa00j04s01;
import com.ejie.aa00j.model.Aa00j06s01;
import com.ejie.aa00j.model.Aa00j07s01;
import com.ejie.aa00j.model.Aa00j10s01;
import com.ejie.aa00j.model.Aa00j11s01;
import com.ejie.aa00j.model.Aa00j12s01;
import com.ejie.aa00j.model.Aa00j20s01;

import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.dto.PaginationManager;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa00j20s01DaoImpl generated by UDA, 16-oct-2013 13:02:12.
 * 
 * @author UDA
 */

@Repository
public class Aa00j20s01DaoImpl implements Aa00j20s01Dao {
	private JdbcTemplate jdbcTemplate;
	private static final Logger logger = LoggerFactory
			.getLogger(Aa00j20s01DaoImpl.class);
	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Aa00j20s01> rwMap = new RowMapper<Aa00j20s01>() {
		public Aa00j20s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Aa00j20s01 aa00j20s01 = new Aa00j20s01(
					resultSet.getLong("COD20"),
					resultSet.getString("SIT20"),
					resultSet.getInt("BLOQ20"),
					resultSet.getInt("SWFHOR20"),
					resultSet.getInt("SWCONF20"),
					resultSet.getInt("SWMAILE20"),
					resultSet.getInt("SWAUTC20"),
					resultSet.getString("ASUN20"),
					resultSet.getTimestamp("DHCOM20"),
					resultSet.getTimestamp("DHFIN20"),
					resultSet.getString("ORGAN20"),
					resultSet.getString("RESER20"),
					resultSet.getString("ANOMD20"),
					resultSet.getString("TLFNOR20"),
					resultSet.getString("OBS20"),
					resultSet.getString("DNI20"),
					resultSet.getString("IP20"),
					resultSet.getString("USUB20"),
					resultSet.getString("TLFNO20"),
					new Aa00j07s01(resultSet.getLong("Aa00j07s01CDEP07"),
							resultSet.getString("Aa00j07s01DESCC07"), resultSet
									.getString("Aa00j07s01DESCE07"), resultSet
									.getString("Aa00j07s01SIT07"), resultSet
									.getInt("Aa00j07s01BLOQ07"), resultSet
									.getString("Aa00j07s01USUB07"), resultSet
									.getString("Aa00j07s01COD_XLNET_07")),
					new Aa00j10s01(resultSet.getLong("Aa00j10s01CSALA10"),
							resultSet.getString("Aa00j10s01NOMBRE10"),
							resultSet.getString("Aa00j10s01SIT10"), resultSet
									.getInt("Aa00j10s01BLOQ10"), resultSet
									.getInt("Aa00j10s01SWDISP10"), resultSet
									.getString("Aa00j10s01DESC10"), resultSet
									.getString("Aa00j10s01TLFNO10"), resultSet
									.getString("Aa00j10s01USUB10"), resultSet
									.getString("Aa00j10s01PLANTA10"), resultSet
									.getString("Aa00j10s01DCAPC10"), resultSet
									.getString("Aa00j10s01DCAPE10"), resultSet
									.getLong("Aa00j10s01NCAP10"),
							new Aa00j07s01(resultSet
									.getLong("Aa00j10s01CDEP10"), null, null,
									null, null, null, null, null, null, null,
									null, null), new Aa00j03s01(resultSet
									.getLong("Aa00j10s01CEDIF10"), null, null,
									null, null, null, null, null, null, null),
							new Aa00j06s01(resultSet
									.getLong("Aa00j10s01CREST10"), null, null,
									null, null, null, null, null, null, null),
							new Aa00j04s01(resultSet
									.getLong("Aa00j10s01CTEXTO10"), null, null,
									null, null, null, null, null),
							new Aa00j11s01(resultSet
									.getLong("Aa00j10s01CSALA10"), null, null)),
					new Aa00j07s01(resultSet.getLong("Aa00j07s01CDEP07_r"),
							resultSet.getString("Aa00j07s01DESCC07_r"),
							resultSet.getString("Aa00j07s01DESCE07_r"),
							resultSet.getString("Aa00j07s01SIT07_r"), resultSet
									.getInt("Aa00j07s01BLOQ07_r"), resultSet
									.getString("Aa00j07s01USUB07_r"), resultSet
									.getString("Aa00j07s01COD_XLNET_07_r")),
					resultSet.getInt("SWMAILEr20"));
			try {
				aa00j20s01.setEmail20(resultSet.getString("email20"));
				aa00j20s01.setEmailr20(resultSet.getString("emailr20"));
			} catch (Exception e) {

			}
			return aa00j20s01;
		}
	};

	private RowMapper<Aa00j20s01> rwMapPK = new RowMapper<Aa00j20s01>() {
		public Aa00j20s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa00j20s01(resultSet.getLong("COD20"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Aa00j20s01>> rwMapJerarquia = new RowMapper<JerarquiaDto<Aa00j20s01>>() {
		public JerarquiaDto<Aa00j20s01> mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Aa00j20s01 aa00j20s01 = new Aa00j20s01(
					resultSet.getLong("COD20"),
					resultSet.getString("SIT20"),
					resultSet.getInt("BLOQ20"),
					resultSet.getInt("SWFHOR20"),
					resultSet.getInt("SWCONF20"),
					resultSet.getInt("SWMAILE20"),
					resultSet.getInt("SWAUTC20"),
					resultSet.getString("ASUN20"),
					resultSet.getTimestamp("DHCOM20"),
					resultSet.getTimestamp("DHFIN20"),
					resultSet.getString("ORGAN20"),
					resultSet.getString("RESER20"),
					resultSet.getString("ANOMD20"),
					resultSet.getString("TLFNOR20"),
					resultSet.getString("OBS20"),
					resultSet.getString("DNI20"),
					resultSet.getString("IP20"),
					resultSet.getString("USUB20"),
					resultSet.getString("TLFNO20"),
					new Aa00j07s01(resultSet.getLong("Aa00j07s01CDEP07"),
							resultSet.getString("Aa00j07s01DESCC07"), resultSet
									.getString("Aa00j07s01DESCE07"), resultSet
									.getString("Aa00j07s01SIT07"), resultSet
									.getInt("Aa00j07s01BLOQ07"), resultSet
									.getString("Aa00j07s01USUB07"), resultSet
									.getString("Aa00j07s01COD_XLNET_07")),
					new Aa00j10s01(resultSet.getLong("Aa00j10s01CSALA10"),
							resultSet.getString("Aa00j10s01NOMBRE10"),
							resultSet.getString("Aa00j10s01SIT10"), resultSet
									.getInt("Aa00j10s01BLOQ10"), resultSet
									.getInt("Aa00j10s01SWDISP10"), resultSet
									.getString("Aa00j10s01DESC10"), resultSet
									.getString("Aa00j10s01TLFNO10"), resultSet
									.getString("Aa00j10s01USUB10"), resultSet
									.getString("Aa00j10s01PLANTA10"), resultSet
									.getString("Aa00j10s01DCAPC10"), resultSet
									.getString("Aa00j10s01DCAPE10"), resultSet
									.getLong("Aa00j10s01NCAP10"),
							new Aa00j07s01(resultSet
									.getLong("Aa00j10s01CDEP10"), null, null,
									null, null, null, null, null, null, null,
									null, null), new Aa00j03s01(resultSet
									.getLong("Aa00j10s01CEDIF10"), null, null,
									null, null, null, null, null, null, null),
							new Aa00j06s01(resultSet
									.getLong("Aa00j10s01CREST10"), null, null,
									null, null, null, null, null, null, null),
							new Aa00j04s01(resultSet
									.getLong("Aa00j10s01CTEXTO10"), null, null,
									null, null, null, null, null),
							new Aa00j11s01(resultSet
									.getLong("Aa00j10s01CSALA10"), null, null)),
					new Aa00j07s01(resultSet.getLong("Aa00j07s01CDEP07_r"),
							resultSet.getString("Aa00j07s01DESCC07_r"),
							resultSet.getString("Aa00j07s01DESCE07_r"),
							resultSet.getString("Aa00j07s01SIT07_r"), resultSet
									.getInt("Aa00j07s01BLOQ07_r"), resultSet
									.getString("Aa00j07s01USUB07_r"), resultSet
									.getString("Aa00j07s01COD_XLNET_07_r")),
					resultSet.getInt("SWMAILEr20"));

			JerarquiaDto<Aa00j20s01> jerarquia = new JerarquiaDto<Aa00j20s01>();
			jerarquia.setModel(aa00j20s01);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet
					.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet
					.getString("FILTER")));
			return jerarquia;
		}
	};
	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Aa00j20s01> rwMap2 = new RowMapper<Aa00j20s01>() {
		public Aa00j20s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Aa00j20s01 lag = new Aa00j20s01(resultSet.getLong("COD20"), null,
					null, null, null, null, null,
					resultSet.getString("ASUN20"),
					resultSet.getTimestamp("DHCOM20"),
					resultSet.getTimestamp("DHFIN20"), null, null,
					resultSet.getString("ANOMD20"), null, null, null, null,
					null, null, null, new Aa00j10s01(
							resultSet.getLong("Aa00j10s01CSALA10"),
							resultSet.getString("Aa00j10s01NOMBRE10")), null,
					null);
			lag.setHoraIni(resultSet.getString("horaIni"));
			lag.setHoraFin(resultSet.getString("horafin"));
			lag.setEmail20(resultSet.getString("email20"));
			lag.setEmailr20(resultSet.getString("emailr20"));

			return lag;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Aa00j20s01 table.
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01
	 * @return Aa00j20s01
	 */
	public Aa00j20s01 add(final Aa00j20s01 aa00j20s01) {
		Aa00j20s01DaoImpl.logger.info("Método add");
		final String queryUltimoId = "(SELECT NVL(MAX(TO_NUMBER(COD20)), 0) + 1 FROM AA00J20S01)";
		final String query = "INSERT INTO AA00J20S01 (COD20, CDEP20, CSALA20, CDEPR20, SIT20, BLOQ20, SWFHOR20, SWCONF20, SWMAILE20, SWAUTC20, ASUN20, DHCOM20, DHFIN20, ORGAN20, RESER20, ANOMD20, TLFNOR20, OBS20, DNI20, IP20, USUB20, TLFNO20,EMAIL20,EMAILR20, SWMAILER20) VALUES ("
				+ queryUltimoId
				+ ",?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

		final Object getAa00j07s01ByCdep20Cdep07Aux;
		if (aa00j20s01.getAa00j07s01ByCdep20() != null
				&& aa00j20s01.getAa00j07s01ByCdep20().getCdep07() != null) {
			getAa00j07s01ByCdep20Cdep07Aux = aa00j20s01.getAa00j07s01ByCdep20()
					.getCdep07();
		} else {
			getAa00j07s01ByCdep20Cdep07Aux = null;
		}
		final Object getAa00j10s01Csala10Aux;
		if (aa00j20s01.getAa00j10s01() != null
				&& aa00j20s01.getAa00j10s01().getCsala10() != null) {
			getAa00j10s01Csala10Aux = aa00j20s01.getAa00j10s01().getCsala10();
		} else {
			getAa00j10s01Csala10Aux = null;
		}
		final Object getAa00j07s01ByCdepr20Cdep07Aux;
		if (aa00j20s01.getAa00j07s01ByCdepr20() != null
				&& aa00j20s01.getAa00j07s01ByCdepr20().getCdep07() != null) {
			getAa00j07s01ByCdepr20Cdep07Aux = aa00j20s01
					.getAa00j07s01ByCdepr20().getCdep07();
		} else {
			getAa00j07s01ByCdepr20Cdep07Aux = null;
		}

		KeyHolder keyHolder = new GeneratedKeyHolder();
		Aa00j20s01DaoImpl.logger.info("SQL " + query);
		Aa00j20s01DaoImpl.logger.info("PARAM1 "
				+ getAa00j07s01ByCdep20Cdep07Aux);
		Aa00j20s01DaoImpl.logger.info("PARAM2 " + getAa00j10s01Csala10Aux);
		Aa00j20s01DaoImpl.logger.info("PARAM3 "
				+ getAa00j07s01ByCdepr20Cdep07Aux);
		Aa00j20s01DaoImpl.logger.info("PARAM4 " + aa00j20s01.getSit20());
		Aa00j20s01DaoImpl.logger.info("PARAM5 " + 0);
		Aa00j20s01DaoImpl.logger.info("PARAM6 " + aa00j20s01.getSwfhor20());
		Aa00j20s01DaoImpl.logger.info("PARAM7 " + aa00j20s01.getSwconf20());
		Aa00j20s01DaoImpl.logger.info("PARAM8 " + aa00j20s01.getSwmaile20());
		Aa00j20s01DaoImpl.logger.info("PARAM9 " + aa00j20s01.getSwautc20());
		Aa00j20s01DaoImpl.logger.info("PARAM10 " + aa00j20s01.getAsun20());
		Aa00j20s01DaoImpl.logger.info("PARAM11 "
				+ aa00j20s01.getDhcom20().getTime());
		Aa00j20s01DaoImpl.logger.info("PARAM12 "
				+ aa00j20s01.getDhfin20().getTime());
		Aa00j20s01DaoImpl.logger.info("PARAM13 " + aa00j20s01.getOrgan20());
		Aa00j20s01DaoImpl.logger.info("PARAM14 " + aa00j20s01.getReser20());
		Aa00j20s01DaoImpl.logger.info("PARAM15 " + aa00j20s01.getAnomd20());
		Aa00j20s01DaoImpl.logger.info("PARAM16 " + aa00j20s01.getTlfnor20());
		Aa00j20s01DaoImpl.logger.info("PARAM17 " + aa00j20s01.getObs20());
		Aa00j20s01DaoImpl.logger.info("PARAM18 " + aa00j20s01.getDni20());
		Aa00j20s01DaoImpl.logger.info("PARAM19 " + aa00j20s01.getIp20());
		Aa00j20s01DaoImpl.logger.info("PARAM20 " + aa00j20s01.getUsub20());
		Aa00j20s01DaoImpl.logger.info("PARAM21 " + aa00j20s01.getTlfno20());
		Aa00j20s01DaoImpl.logger.info("PARAM22 " + aa00j20s01.getEmail20());
		Aa00j20s01DaoImpl.logger.info("PARAM23 " + aa00j20s01.getEmailr20());
		Aa00j20s01DaoImpl.logger.info("PARAM24 " + aa00j20s01.getSwmailer20());
		jdbcTemplate.update(new PreparedStatementCreator() {
			public PreparedStatement createPreparedStatement(
					Connection connection) throws SQLException {
				PreparedStatement ps = connection.prepareStatement(query,
						new String[] { "COD20" });
				ps.setObject(1, getAa00j07s01ByCdep20Cdep07Aux);
				ps.setObject(2, getAa00j10s01Csala10Aux);
				ps.setObject(3, getAa00j07s01ByCdepr20Cdep07Aux);
				ps.setObject(4, aa00j20s01.getSit20());
				ps.setObject(5, 0);
				ps.setObject(6, aa00j20s01.getSwfhor20());
				ps.setObject(7, aa00j20s01.getSwconf20());
				ps.setObject(8, aa00j20s01.getSwmaile20());
				ps.setObject(9, aa00j20s01.getSwautc20());
				ps.setObject(10, aa00j20s01.getAsun20());
				ps.setTimestamp(11, new java.sql.Timestamp(aa00j20s01
						.getDhcom20().getTime()));
				ps.setTimestamp(12, new java.sql.Timestamp(aa00j20s01
						.getDhfin20().getTime()));
				ps.setObject(13, aa00j20s01.getOrgan20());
				ps.setObject(14, aa00j20s01.getReser20());
				ps.setObject(15, aa00j20s01.getAnomd20());
				ps.setObject(16, aa00j20s01.getTlfnor20());
				ps.setObject(17, aa00j20s01.getObs20());
				ps.setObject(18, aa00j20s01.getDni20());
				ps.setObject(19, aa00j20s01.getIp20());
				ps.setObject(20, aa00j20s01.getUsub20());
				ps.setObject(21, aa00j20s01.getTlfno20());
				ps.setObject(22, aa00j20s01.getEmail20());
				ps.setObject(23, aa00j20s01.getEmailr20());
				ps.setObject(24, aa00j20s01.getSwmailer20());
				return ps;
			}
		}, keyHolder);

		aa00j20s01.setCod20(keyHolder.getKey().longValue());

		return aa00j20s01;
	}

	/**
	 * Updates a single row in the Aa00j20s01 table.
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01
	 * @return Aa00j20s01
	 */
	public Aa00j20s01 update(Aa00j20s01 aa00j20s01) {
		Aa00j20s01DaoImpl.logger.info("Método update");
		String query = "UPDATE AA00J20S01 SET CDEP20=?, CSALA20=?, CDEPR20=?, SIT20=?, BLOQ20=?, SWFHOR20=?, SWCONF20=?, SWMAILE20=?, SWAUTC20=?, ASUN20=?, DHCOM20=?, DHFIN20=?, ORGAN20=?, RESER20=?, ANOMD20=?, TLFNOR20=?, OBS20=?, DNI20=?, IP20=?, USUB20=?, TLFNO20=?,EMAIL20=?,EMAILR20=?, SWMAILER20=? WHERE COD20=?";
		Object getAa00j07s01ByCdep20Cdep07Aux = null;
		if (aa00j20s01.getAa00j07s01ByCdep20() != null
				&& aa00j20s01.getAa00j07s01ByCdep20().getCdep07() != null) {
			getAa00j07s01ByCdep20Cdep07Aux = aa00j20s01.getAa00j07s01ByCdep20()
					.getCdep07();
		}
		Object getAa00j10s01Csala10Aux = null;
		if (aa00j20s01.getAa00j10s01() != null
				&& aa00j20s01.getAa00j10s01().getCsala10() != null) {
			getAa00j10s01Csala10Aux = aa00j20s01.getAa00j10s01().getCsala10();
		}
		Object getAa00j07s01ByCdepr20Cdep07Aux = null;
		if (aa00j20s01.getAa00j07s01ByCdepr20() != null
				&& aa00j20s01.getAa00j07s01ByCdepr20().getCdep07() != null) {
			getAa00j07s01ByCdepr20Cdep07Aux = aa00j20s01
					.getAa00j07s01ByCdepr20().getCdep07();
		}
		Aa00j20s01DaoImpl.logger.info("SQL " + query);
		Aa00j20s01DaoImpl.logger.info("PARAM1 "
				+ getAa00j07s01ByCdep20Cdep07Aux);
		Aa00j20s01DaoImpl.logger.info("PARAM2 " + getAa00j10s01Csala10Aux);
		Aa00j20s01DaoImpl.logger.info("PARAM3 "
				+ getAa00j07s01ByCdepr20Cdep07Aux);
		Aa00j20s01DaoImpl.logger.info("PARAM4 " + aa00j20s01.getSit20());
		Aa00j20s01DaoImpl.logger.info("PARAM5 " + aa00j20s01.getBloq20());
		Aa00j20s01DaoImpl.logger.info("PARAM6 " + aa00j20s01.getSwfhor20());
		Aa00j20s01DaoImpl.logger.info("PARAM7 " + aa00j20s01.getSwconf20());
		Aa00j20s01DaoImpl.logger.info("PARAM8 " + aa00j20s01.getSwmaile20());
		Aa00j20s01DaoImpl.logger.info("PARAM9 " + aa00j20s01.getSwautc20());
		Aa00j20s01DaoImpl.logger.info("PARAM10 " + aa00j20s01.getAsun20());
		Aa00j20s01DaoImpl.logger.info("PARAM11 "
				+ aa00j20s01.getDhcom20().getTime());
		Aa00j20s01DaoImpl.logger.info("PARAM12 "
				+ aa00j20s01.getDhfin20().getTime());
		Aa00j20s01DaoImpl.logger.info("PARAM13 " + aa00j20s01.getOrgan20());
		Aa00j20s01DaoImpl.logger.info("PARAM14 " + aa00j20s01.getReser20());
		Aa00j20s01DaoImpl.logger.info("PARAM15 " + aa00j20s01.getAnomd20());
		Aa00j20s01DaoImpl.logger.info("PARAM16 " + aa00j20s01.getTlfnor20());
		Aa00j20s01DaoImpl.logger.info("PARAM17 " + aa00j20s01.getObs20());
		Aa00j20s01DaoImpl.logger.info("PARAM18 " + aa00j20s01.getDni20());
		Aa00j20s01DaoImpl.logger.info("PARAM19 " + aa00j20s01.getIp20());
		Aa00j20s01DaoImpl.logger.info("PARAM20 " + aa00j20s01.getUsub20());
		Aa00j20s01DaoImpl.logger.info("PARAM21 " + aa00j20s01.getTlfno20());
		Aa00j20s01DaoImpl.logger.info("PARAM22 " + aa00j20s01.getEmail20());
		Aa00j20s01DaoImpl.logger.info("PARAM23 " + aa00j20s01.getEmailr20());
		Aa00j20s01DaoImpl.logger.info("PARAM24 " + aa00j20s01.getSwmailer20());
		Aa00j20s01DaoImpl.logger.info("PARAM25 " + aa00j20s01.getCod20());
		this.jdbcTemplate.update(query, getAa00j07s01ByCdep20Cdep07Aux,
				getAa00j10s01Csala10Aux, getAa00j07s01ByCdepr20Cdep07Aux,
				aa00j20s01.getSit20(), aa00j20s01.getBloq20(), aa00j20s01
						.getSwfhor20(), aa00j20s01.getSwconf20(), aa00j20s01
						.getSwmaile20(), aa00j20s01.getSwautc20(), aa00j20s01
						.getAsun20(), new java.sql.Timestamp(aa00j20s01
						.getDhcom20().getTime()), new java.sql.Timestamp(
						aa00j20s01.getDhfin20().getTime()), aa00j20s01
						.getOrgan20(), aa00j20s01.getReser20(), aa00j20s01
						.getAnomd20(), aa00j20s01.getTlfnor20(), aa00j20s01
						.getObs20(), aa00j20s01.getDni20(), aa00j20s01
						.getIp20(), aa00j20s01.getUsub20(), aa00j20s01
						.getTlfno20(), aa00j20s01.getEmail20(), aa00j20s01
						.getEmailr20(), aa00j20s01.getSwmailer20(), aa00j20s01
						.getCod20());

		return aa00j20s01;
	}

	/**
	 * Finds a single row in the Aa00j20s01 table.
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01
	 * @return Aa00j20s01
	 */
	@Transactional(readOnly = true)
	public Aa00j20s01 find(Aa00j20s01 aa00j20s01) {
		Aa00j20s01DaoImpl.logger.info("Método find");
		String query = "SELECT t1.COD20 COD20, t1.SIT20 SIT20, t1.BLOQ20 BLOQ20, t1.SWFHOR20 SWFHOR20, t1.SWCONF20 SWCONF20, t1.SWMAILE20 SWMAILE20, t1.SWMAILEr20 SWMAILEr20, t1.SWAUTC20 SWAUTC20, t1.ASUN20 ASUN20, t1.DHCOM20 DHCOM20, t1.DHFIN20 DHFIN20, t1.ORGAN20 ORGAN20, t1.RESER20 RESER20, t1.ANOMD20 ANOMD20, t1.TLFNOR20 TLFNOR20, t1.OBS20 OBS20, t1.DNI20 DNI20, t1.IP20 IP20, t1.USUB20 USUB20, t1.TLFNO20 TLFNO20, t2.CDEP07 AA00J07S01CDEP07, t2.DESCC07 AA00J07S01DESCC07, t2.DESCE07 AA00J07S01DESCE07, t2.SIT07 AA00J07S01SIT07, t2.BLOQ07 AA00J07S01BLOQ07, t2.USUB07 AA00J07S01USUB07, t2.COD_XLNET_07 AA00J07S01COD_XLNET_07, t3.CSALA10 AA00J10S01CSALA10, t3.NOMBRE10 AA00J10S01NOMBRE10, t3.SIT10 AA00J10S01SIT10, t3.BLOQ10 AA00J10S01BLOQ10, t3.SWDISP10 AA00J10S01SWDISP10, t3.DESC10 AA00J10S01DESC10, t3.TLFNO10 AA00J10S01TLFNO10, t3.USUB10 AA00J10S01USUB10, t3.PLANTA10 AA00J10S01PLANTA10, t3.DCAPC10 AA00J10S01DCAPC10, t3.DCAPE10 AA00J10S01DCAPE10, t3.NCAP10 AA00J10S01NCAP10, t4.CDEP07 AA00J07S01CDEP07_r, t4.DESCC07 AA00J07S01DESCC07_r, t4.DESCE07 AA00J07S01DESCE07_r, t4.SIT07 AA00J07S01SIT07_r, t4.BLOQ07 AA00J07S01BLOQ07_r, t4.USUB07 AA00J07S01USUB07_r, t4.COD_XLNET_07 AA00J07S01COD_XLNET_07_r, t3.CDEP10 AA00J10S01CDEP10, t3.CEDIF10 AA00J10S01CEDIF10, t3.CREST10 AA00J10S01CREST10, t3.CTEXTO10 AA00J10S01CTEXTO10 FROM AA00J20S01 t1 , AA00J07S01 t2 , AA00J10S01 t3 , AA00J07S01 t4  WHERE t1.COD20 = ?   AND t1.CDEP20= t2.CDEP07(+) AND t1.CSALA20= t3.CSALA10(+) AND t1.CDEPR20= t4.CDEP07(+)";
		Aa00j20s01DaoImpl.logger.info("SQL " + query);

		Aa00j20s01DaoImpl.logger.info("PARAM1 " + aa00j20s01.getCod20());
		List<Aa00j20s01> aa00j20s01List = this.jdbcTemplate.query(query,
				this.rwMap, aa00j20s01.getCod20());
		return (Aa00j20s01) DataAccessUtils.uniqueResult(aa00j20s01List);
	}

	/**
	 * Removes a single row in the Aa00j20s01 table.
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01
	 * @return
	 */
	public void remove(Aa00j20s01 aa00j20s01) {
		Aa00j20s01DaoImpl.logger.info("Método remove");
		String query = "DELETE FROM AA00J20S01 WHERE COD20=?";
		this.jdbcTemplate.update(query, aa00j20s01.getCod20());
	}

	/**
	 * Finds a list of rows in the Aa00j20s01 table.
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa00j20s01>
	 */
	@Transactional(readOnly = true)
	public List<Aa00j20s01> findAll(Aa00j20s01 aa00j20s01,
			JQGridRequestDto jqGridRequestDto, String codDepto,
			String codUsuario) {
		Aa00j20s01DaoImpl.logger.info("Método findAll");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.COD20 COD20,t1.SIT20 SIT20,t1.BLOQ20 BLOQ20,t1.SWFHOR20 SWFHOR20,t1.SWCONF20 SWCONF20,t1.SWMAILE20 SWMAILE20, t1.SWMAILER20 SWMAILER20,t1.SWAUTC20 SWAUTC20,t1.ASUN20 ASUN20,t1.DHCOM20 DHCOM20,t1.DHFIN20 DHFIN20,t1.ORGAN20 ORGAN20,t1.RESER20 RESER20,t1.ANOMD20 ANOMD20,t1.TLFNOR20 TLFNOR20,t1.OBS20 OBS20,t1.DNI20 DNI20,t1.IP20 IP20,t1.USUB20 USUB20,t1.TLFNO20 TLFNO20,t2.CDEP07 AA00J07S01CDEP07,t2.DESCC07 AA00J07S01DESCC07,t2.DESCE07 AA00J07S01DESCE07,t2.SIT07 AA00J07S01SIT07,t2.BLOQ07 AA00J07S01BLOQ07,t2.USUB07 AA00J07S01USUB07,t2.COD_XLNET_07 AA00J07S01COD_XLNET_07,t3.CSALA10 AA00J10S01CSALA10,t3.NOMBRE10 AA00J10S01NOMBRE10,t3.SIT10 AA00J10S01SIT10,t3.BLOQ10 AA00J10S01BLOQ10,t3.SWDISP10 AA00J10S01SWDISP10,t3.DESC10 AA00J10S01DESC10,t3.TLFNO10 AA00J10S01TLFNO10,t3.USUB10 AA00J10S01USUB10,t3.PLANTA10 AA00J10S01PLANTA10,t3.DCAPC10 AA00J10S01DCAPC10,t3.DCAPE10 AA00J10S01DCAPE10,t3.NCAP10 AA00J10S01NCAP10,t4.CDEP07 AA00J07S01CDEP07_r,t4.DESCC07 AA00J07S01DESCC07_r,t4.DESCE07 AA00J07S01DESCE07_r,t4.SIT07 AA00J07S01SIT07_r,t4.BLOQ07 AA00J07S01BLOQ07_r,t4.USUB07 AA00J07S01USUB07_r, t4.COD_XLNET_07 AA00J07S01COD_XLNET_07_r,t3.CDEP10 AA00J10S01CDEP10,t3.CEDIF10 AA00J10S01CEDIF10,t3.CREST10 AA00J10S01CREST10,t3.CTEXTO10 AA00J10S01CTEXTO10 ");
		query.append("FROM AA00J20S01 t1 ,AA00J07S01 t2 ,AA00J10S01 t3 ,AA00J07S01 t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa00j20s01);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CDEP20= t2.CDEP07(+) AND t1.CSALA20= t3.CSALA10(+) AND t1.CDEPR20= t4.CDEP07(+) ");
		where.append(mapaWhere.get("query"));

		/* WHERE DE XLNETS */
		if (!codDepto.isEmpty()) {
			where.append(" AND t3.CDEP10='").append(codDepto).append("'");
		} else {
			where.append(" AND t3.CDEP10 IS NULL");
		}
		if (!codUsuario.isEmpty()) {
			// where.append(" AND (t1.ORGAN20='").append(codUsuario)
			// .append("' OR t1.RESER20='").append(codUsuario)
			// .append("' OR t1.ANOMD20='").append(codUsuario)
			// .append("')");
			where.append(" AND (t1.DNI20='").append(codUsuario)
					.append("' OR t1.ORGAN20='").append(codUsuario)
					.append("')");
		}
		/**/

		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		Aa00j20s01DaoImpl.logger.info("SQL " + query);

		Aa00j20s01DaoImpl.logger.info("PARAMs " + params);
		return (List<Aa00j20s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Aa00j20s01 table using like.
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa00j20s01>
	 */
	@Transactional(readOnly = true)
	public List<Aa00j20s01> findAllLike(Aa00j20s01 aa00j20s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith,
			String codDepto, String codUsuario, Locale locale) {
		Aa00j20s01DaoImpl.logger.info("Método findAllLike");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.COD20 COD20,t1.SIT20 SIT20,t1.BLOQ20 BLOQ20,t1.SWFHOR20 SWFHOR20,t1.SWCONF20 SWCONF20,t1.SWMAILE20 SWMAILE20, t1.SWMAILER20 SWMAILER20,t1.SWAUTC20 SWAUTC20,t1.ASUN20 ASUN20,t1.DHCOM20 DHCOM20,t1.DHFIN20 DHFIN20,t1.ORGAN20 ORGAN20,t1.RESER20 RESER20,t1.ANOMD20 ANOMD20,t1.TLFNOR20 TLFNOR20,t1.OBS20 OBS20,t1.DNI20 DNI20,t1.IP20 IP20,t1.USUB20 USUB20,t1.TLFNO20 TLFNO20,t2.CDEP07 AA00J07S01CDEP07,t2.DESCC07 AA00J07S01DESCC07,t2.DESCE07 AA00J07S01DESCE07,t2.SIT07 AA00J07S01SIT07,t2.BLOQ07 AA00J07S01BLOQ07,t2.USUB07 AA00J07S01USUB07,t2.COD_XLNET_07 AA00J07S01COD_XLNET_07,t3.CSALA10 AA00J10S01CSALA10,t3.NOMBRE10 AA00J10S01NOMBRE10,t3.SIT10 AA00J10S01SIT10,t3.BLOQ10 AA00J10S01BLOQ10,t3.SWDISP10 AA00J10S01SWDISP10,t3.DESC10 AA00J10S01DESC10,t3.TLFNO10 AA00J10S01TLFNO10,t3.USUB10 AA00J10S01USUB10,t3.PLANTA10 AA00J10S01PLANTA10,t3.DCAPC10 AA00J10S01DCAPC10,t3.DCAPE10 AA00J10S01DCAPE10,t3.NCAP10 AA00J10S01NCAP10,t4.CDEP07 AA00J07S01CDEP07_r,t4.DESCC07 AA00J07S01DESCC07_r,t4.DESCE07 AA00J07S01DESCE07_r,t4.SIT07 AA00J07S01SIT07_r,t4.BLOQ07 AA00J07S01BLOQ07_r,t4.USUB07 AA00J07S01USUB07_r, t4.COD_XLNET_07 AA00J07S01COD_XLNET_07_r,t3.CDEP10 AA00J10S01CDEP10,t3.CEDIF10 AA00J10S01CEDIF10,t3.CREST10 AA00J10S01CREST10,t3.CTEXTO10 AA00J10S01CTEXTO10 ");
		query.append("FROM AA00J20S01 t1 ,AA00J07S01 t2 ,AA00J10S01 t3 ,AA00J07S01 t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa00j20s01, startsWith);

		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CDEP20= t2.CDEP07(+) AND t1.CSALA20= t3.CSALA10(+) AND t1.CDEPR20= t4.CDEP07(+) ");
		String q = mapaWhere.get("query").toString();
		if (locale.getLanguage().contains("eu"))
			where.append(q
					.replaceAll(":f", aa00jConstantes.FORMATOFECHAEUSKERA));
		else
			where.append(q.replaceAll(":f",
					aa00jConstantes.FORMATOFECHACASTELLANO));

		/* WHERE DE XLNETS */
		if (!codDepto.isEmpty()) {
			where.append(" AND t3.CDEP10='").append(codDepto).append("'");
		} else if (aa00j20s01.getAa00j07s01ByCdep20() != null) {
			where.append(" AND t3.CDEP10='")
					.append(aa00j20s01.getAa00j07s01ByCdep20().getCdep07())
					.append("'");
		} else {
			if (aa00j20s01.getDepartamental() == null)
				where.append(" AND t3.CDEP10 IS NULL");
			else
				where.append(" AND t3.CDEP10 IS NOT NULL");
		}
		if (!codUsuario.isEmpty()) {
			// where.append(" AND (t1.ORGAN20='").append(codUsuario)
			// .append("' OR t1.RESER20='").append(codUsuario)
			// .append("' OR t1.ANOMD20='").append(codUsuario)
			// .append("')");
			where.append(" AND (t1.DNI20='").append(codUsuario)
					.append("' OR t1.ORGAN20='").append(codUsuario)
					.append("')");
		}
		/**/

		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		// Chapuza para arreglar el jaleo que monta uda:
		// En la clase del modelo las columnas se llaman aa00j10s01.nombre10,
		// por
		// ejemplo, pero en la sql que crea se llama t1.nombre10
		// por lo que al ordenar la tabla no lo hace bien
		// ya que en la tabla hay que poner el nombre que tiene en el modelo.
		// lo hago así para tocar lo mínimo posible el resto de la aplicación

		String sql = query.toString();

		sql = StringUtils.replaceGlobal(sql, "aa00j20s01.", "t1.");
		sql = StringUtils.replaceGlobal(sql, "aa00j07s01ByCdepr20.", "t2.");
		sql = StringUtils.replaceGlobal(sql, "aa00j10s01.", "t3.");
		sql = StringUtils.replaceGlobal(sql, "diaMostrar", "DHCOM20");

		Aa00j20s01DaoImpl.logger.info("SQL " + sql);

		Aa00j20s01DaoImpl.logger.info("PARAMs " + params);
		return (List<Aa00j20s01>) this.jdbcTemplate.query(sql, this.rwMap,
				params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Aa00j20s01 table.
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Aa00j20s01 aa00j20s01, String codDepto,
			String codUsuario) {
		Aa00j20s01DaoImpl.logger.info("Método findAllCount");
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA00J20S01 t1 , AA00J07S01 t2 , AA00J10S01 t3 , AA00J07S01 t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa00j20s01);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CDEP20= t2.CDEP07(+) AND t1.CSALA20= t3.CSALA10(+) AND t1.CDEPR20= t4.CDEP07(+) ");
		where.append(mapaWhere.get("query"));

		/* WHERE DE XLNETS */
		if (!codDepto.isEmpty()) {
			where.append(" AND t3.CDEP10='").append(codDepto).append("'");
		} else {
			where.append(" AND t3.CDEP10 IS NULL");
		}
		if (!codUsuario.isEmpty()) {
			// where.append(" AND (t1.ORGAN20='").append(codUsuario)
			// .append("' OR t1.RESER20='").append(codUsuario)
			// .append("' OR t1.ANOMD20='").append(codUsuario)
			// .append("')");
			where.append(" AND (t1.DNI20='").append(codUsuario)
					.append("' OR t1.ORGAN20='").append(codUsuario)
					.append("')");
		}
		/**/

		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j20s01DaoImpl.logger.info("SQL " + query);

		Aa00j20s01DaoImpl.logger.info("PARAMs " + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Aa00j20s01 table using like.
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Aa00j20s01 aa00j20s01, Boolean startsWith,
			String codDepto, String codUsuario, Locale locale) {
		Aa00j20s01DaoImpl.logger.info("Método findAllLikeCount");
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA00J20S01 t1 ,AA00J07S01 t2 ,AA00J10S01 t3 ,AA00J07S01 t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa00j20s01, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CDEP20= t2.CDEP07(+) AND t1.CSALA20= t3.CSALA10(+) AND t1.CDEPR20= t4.CDEP07(+) ");
		// where.append(mapaWhere.get("query"));
		String q = mapaWhere.get("query").toString();
		if (locale.getLanguage().contains("eu"))
			where.append(q
					.replaceAll(":f", aa00jConstantes.FORMATOFECHAEUSKERA));
		else
			where.append(q.replaceAll(":f",
					aa00jConstantes.FORMATOFECHACASTELLANO));
		/* WHERE DE XLNETS */
		/* WHERE DE XLNETS */
		if (!codDepto.isEmpty()) {
			where.append(" AND t3.CDEP10='").append(codDepto).append("'");
		} else if (aa00j20s01.getAa00j07s01ByCdep20() != null) {
			where.append(" AND t3.CDEP10='")
					.append(aa00j20s01.getAa00j07s01ByCdep20().getCdep07())
					.append("'");
		} else {
			if (aa00j20s01.getDepartamental() == null)
				where.append(" AND t3.CDEP10 IS NULL");
			else
				where.append(" AND t3.CDEP10 IS NOT NULL");
		}
		if (!codUsuario.isEmpty()) {
			// where.append(" AND (t1.ORGAN20='").append(codUsuario)
			// .append("' OR t1.RESER20='").append(codUsuario)
			// .append("' OR t1.ANOMD20='").append(codUsuario)
			// .append("')");
			where.append(" AND (t1.DNI20='").append(codUsuario)
					.append("' OR t1.ORGAN20='").append(codUsuario)
					.append("')");
		}
		/**/

		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j20s01DaoImpl.logger.info("SQL " + query);

		Aa00j20s01DaoImpl.logger.info("PARAMs " + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Aa00j20s01 selected for rup_table
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j20s01>>
	 */
	@Override
	public List<TableRowDto<Aa00j20s01>> reorderSelection(
			Aa00j20s01 aa00j20s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith, String codDepto, String codUsuario) {
		Aa00j20s01DaoImpl.logger.info("Método reorderSelection");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.COD20 COD20,t1.SIT20 SIT20,t1.BLOQ20 BLOQ20,t1.SWFHOR20 SWFHOR20,t1.SWCONF20 SWCONF20,t1.SWMAILE20 SWMAILE20, t1.SWMAILER20 SWMAILER20,t1.SWAUTC20 SWAUTC20,t1.ASUN20 ASUN20,t1.DHCOM20 DHCOM20,t1.DHFIN20 DHFIN20,t1.ORGAN20 ORGAN20,t1.RESER20 RESER20,t1.ANOMD20 ANOMD20,t1.TLFNOR20 TLFNOR20,t1.OBS20 OBS20,t1.DNI20 DNI20,t1.IP20 IP20,t1.USUB20 USUB20,t1.TLFNO20 TLFNO20,t2.CDEP07 AA00J07S01CDEP07,t2.DESCC07 AA00J07S01DESCC07,t2.DESCE07 AA00J07S01DESCE07,t2.SIT07 AA00J07S01SIT07,t2.BLOQ07 AA00J07S01BLOQ07,t2.USUB07 AA00J07S01USUB07,t2.COD_XLNET_07 AA00J07S01COD_XLNET_07,t3.CSALA10 AA00J10S01CSALA10,t3.NOMBRE10 AA00J10S01NOMBRE10,t3.SIT10 AA00J10S01SIT10,t3.BLOQ10 AA00J10S01BLOQ10,t3.SWDISP10 AA00J10S01SWDISP10,t3.DESC10 AA00J10S01DESC10,t3.TLFNO10 AA00J10S01TLFNO10,t3.USUB10 AA00J10S01USUB10,t3.PLANTA10 AA00J10S01PLANTA10,t3.DCAPC10 AA00J10S01DCAPC10,t3.DCAPE10 AA00J10S01DCAPE10,t3.NCAP10 AA00J10S01NCAP10,t4.CDEP07 AA00J07S01CDEP07_r,t4.DESCC07 AA00J07S01DESCC07_r,t4.DESCE07 AA00J07S01DESCE07_r,t4.SIT07 AA00J07S01SIT07_r,t4.BLOQ07 AA00J07S01BLOQ07_r,t4.USUB07 AA00J07S01USUB07_r, t4.COD_XLNET_07 AA00J07S01COD_XLNET_07_r,t3.CDEP10 AA00J10S01CDEP10,t3.CEDIF10 AA00J10S01CEDIF10,t3.CREST10 AA00J10S01CREST10,t3.CTEXTO10 AA00J10S01CTEXTO10 ");
		// FROM
		query.append("FROM AA00J20S01 t1 ,AA00J07S01 t2 ,AA00J10S01 t3 ,AA00J07S01 t4 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa00j20s01, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CDEP20= t2.CDEP07(+) AND t1.CSALA20= t3.CSALA10(+) AND t1.CDEPR20= t4.CDEP07(+) ");
		where.append(mapaWhere.get("query"));

		/* WHERE DE XLNETS */
		if (!codDepto.isEmpty()) {
			where.append(" AND t3.CDEP10='").append(codDepto).append("'");
		} else {
			where.append(" AND t3.CDEP10 IS NULL");
		}
		if (!codUsuario.isEmpty()) {
			// where.append(" AND (t1.ORGAN20='").append(codUsuario)
			// .append("' OR t1.RESER20='").append(codUsuario)
			// .append("' OR t1.ANOMD20='").append(codUsuario)
			// .append("')");
			where.append(" AND (t1.DNI20='").append(codUsuario)
					.append("' OR t1.ORGAN20='").append(codUsuario)
					.append("')");
		}
		/**/

		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, Aa00j20s01.class, filterParamList,
				"COD20");
		Aa00j20s01DaoImpl.logger.info("SQL " + sbReorderSelectionSQL);

		Aa00j20s01DaoImpl.logger.info("PARAMs " + filterParamList);
		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa00j20s01>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * @param filterParams
	 *            Aa00j20s01
	 * @param searchParams
	 *            Aa00j20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j20s01>>
	 */
	@Override
	public List<TableRowDto<Aa00j20s01>> search(Aa00j20s01 filterParams,
			Aa00j20s01 searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith, String codDepto, String codUsuario) {
		Aa00j20s01DaoImpl.logger.info("Método search");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.COD20 COD20,t1.SIT20 SIT20,t1.BLOQ20 BLOQ20,t1.SWFHOR20 SWFHOR20,t1.SWCONF20 SWCONF20,t1.SWMAILE20 SWMAILE20, t1.SWMAILER20 SWMAILER20,t1.SWAUTC20 SWAUTC20,t1.ASUN20 ASUN20,t1.DHCOM20 DHCOM20,t1.DHFIN20 DHFIN20,t1.ORGAN20 ORGAN20,t1.RESER20 RESER20,t1.ANOMD20 ANOMD20,t1.TLFNOR20 TLFNOR20,t1.OBS20 OBS20,t1.DNI20 DNI20,t1.IP20 IP20,t1.USUB20 USUB20,t1.TLFNO20 TLFNO20,t2.CDEP07 AA00J07S01CDEP07,t2.DESCC07 AA00J07S01DESCC07,t2.DESCE07 AA00J07S01DESCE07,t2.SIT07 AA00J07S01SIT07,t2.BLOQ07 AA00J07S01BLOQ07,t2.USUB07 AA00J07S01USUB07,t2.COD_XLNET_07 AA00J07S01COD_XLNET_07,t3.CSALA10 AA00J10S01CSALA10,t3.NOMBRE10 AA00J10S01NOMBRE10,t3.SIT10 AA00J10S01SIT10,t3.BLOQ10 AA00J10S01BLOQ10,t3.SWDISP10 AA00J10S01SWDISP10,t3.DESC10 AA00J10S01DESC10,t3.TLFNO10 AA00J10S01TLFNO10,t3.USUB10 AA00J10S01USUB10,t3.PLANTA10 AA00J10S01PLANTA10,t3.DCAPC10 AA00J10S01DCAPC10,t3.DCAPE10 AA00J10S01DCAPE10,t3.NCAP10 AA00J10S01NCAP10,t4.CDEP07 AA00J07S01CDEP07_r,t4.DESCC07 AA00J07S01DESCC07_r,t4.DESCE07 AA00J07S01DESCE07_r,t4.SIT07 AA00J07S01SIT07_r,t4.BLOQ07 AA00J07S01BLOQ07_r,t4.USUB07 AA00J07S01USUB07_r, t4.COD_XLNET_07 AA00J07S01COD_XLNET_07_r,t3.CDEP10 AA00J10S01CDEP10,t3.CEDIF10 AA00J10S01CEDIF10,t3.CREST10 AA00J10S01CREST10,t3.CTEXTO10 AA00J10S01CTEXTO10 ");
		// FROM
		query.append("FROM AA00J20S01 t1 ,AA00J07S01 t2 ,AA00J10S01 t3 ,AA00J07S01 t4 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");
		from_alias.add(" t3 ");
		from_alias.add(" t4 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CDEP20= t2.CDEP07(+) AND t1.CSALA20= t3.CSALA10(+) AND t1.CDEPR20= t4.CDEP07(+) ");
		where.append(mapaWhereFilter.get("query"));

		/* WHERE DE XLNETS */
		if (!codDepto.isEmpty()) {
			where.append(" AND t3.CDEP10='").append(codDepto).append("'");
		} else {
			where.append(" AND t3.CDEP10 IS NULL");
		}
		if (!codUsuario.isEmpty()) {
			// where.append(" AND (t1.ORGAN20='").append(codUsuario)
			// .append("' OR t1.RESER20='").append(codUsuario)
			// .append("' OR t1.ANOMD20='").append(codUsuario)
			// .append("')");
			where.append(" AND (t1.DNI20='").append(codUsuario)
					.append("' OR t1.ORGAN20='").append(codUsuario)
					.append("')");
		}
		/**/

		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, Aa00j20s01.class, filterParamList,
				searchSQL, searchParamList, from_alias, "COD20");
		Aa00j20s01DaoImpl.logger.info("SQL " + sbReorderSelectionSQL);

		Aa00j20s01DaoImpl.logger.info("PARAMs " + filterParamList);
		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa00j20s01>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 * 
	 * @param filteraa00j20s01
	 *            Aa00j20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Aa00j20s01 filteraa00j20s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		Aa00j20s01DaoImpl.logger.info("Método removeMultiple");
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.COD20 COD20,t1.SIT20 SIT20,t1.BLOQ20 BLOQ20,t1.SWFHOR20 SWFHOR20,t1.SWCONF20 SWCONF20,t1.SWMAILE20 SWMAILE20, t1.SWMAILER20 SWMAILER20,t1.SWAUTC20 SWAUTC20,t1.ASUN20 ASUN20,t1.DHCOM20 DHCOM20,t1.DHFIN20 DHFIN20,t1.ORGAN20 ORGAN20,t1.RESER20 RESER20,t1.ANOMD20 ANOMD20,t1.TLFNOR20 TLFNOR20,t1.OBS20 OBS20,t1.DNI20 DNI20,t1.IP20 IP20,t1.USUB20 USUB20,t1.TLFNO20 TLFNO20,t2.CDEP07 AA00J07S01CDEP07,t2.DESCC07 AA00J07S01DESCC07,t2.DESCE07 AA00J07S01DESCE07,t2.SIT07 AA00J07S01SIT07,t2.BLOQ07 AA00J07S01BLOQ07,t2.USUB07 AA00J07S01USUB07,t2.COD_XLNET_07 AA00J07S01COD_XLNET_07,t3.CSALA10 AA00J10S01CSALA10,t3.NOMBRE10 AA00J10S01NOMBRE10,t3.SIT10 AA00J10S01SIT10,t3.BLOQ10 AA00J10S01BLOQ10,t3.SWDISP10 AA00J10S01SWDISP10,t3.DESC10 AA00J10S01DESC10,t3.TLFNO10 AA00J10S01TLFNO10,t3.USUB10 AA00J10S01USUB10,t3.PLANTA10 AA00J10S01PLANTA10,t3.DCAPC10 AA00J10S01DCAPC10,t3.DCAPE10 AA00J10S01DCAPE10,t3.NCAP10 AA00J10S01NCAP10,t4.CDEP07 AA00J07S01CDEP07_r,t4.DESCC07 AA00J07S01DESCC07_r,t4.DESCE07 AA00J07S01DESCE07_r,t4.SIT07 AA00J07S01SIT07_r,t4.BLOQ07 AA00J07S01BLOQ07_r,t4.USUB07 AA00J07S01USUB07_r, t4.COD_XLNET_07 AA00J07S01COD_XLNET_07_r,t3.CDEP10 AA00J10S01CDEP10,t3.CEDIF10 AA00J10S01CEDIF10,t3.CREST10 AA00J10S01CREST10,t3.CTEXTO10 AA00J10S01CTEXTO10 ");
		// FROM
		query.append("FROM AA00J20S01 t1 ,AA00J07S01 t2 ,AA00J10S01 t3 ,AA00J07S01 t4 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filteraa00j20s01,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto, Aa00j20s01.class,
						query, params, "COD20");
		Aa00j20s01DaoImpl.logger.info("SQL " + sbRemoveMultipleSQL);

		Aa00j20s01DaoImpl.logger.info("PARAMs " + params);
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical Aa00j20s01 table.
	 * 
	 * @param filterAa00j20s01
	 *            Aa00j20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Aa00j20s01>>
	 */
	@Override
	public List<JerarquiaDto<Aa00j20s01>> findAllLikeJerarquia(
			Aa00j20s01 filterAa00j20s01, JQGridRequestDto jqGridRequestDto) {
		Aa00j20s01DaoImpl.logger.info("Método findAllLikeJerarquia");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.COD20 COD20,t1.SIT20 SIT20,t1.BLOQ20 BLOQ20,t1.SWFHOR20 SWFHOR20,t1.SWCONF20 SWCONF20,t1.SWMAILE20 SWMAILE20, t1.SWMAILER20 SWMAILER20,t1.SWAUTC20 SWAUTC20,t1.ASUN20 ASUN20,t1.DHCOM20 DHCOM20,t1.DHFIN20 DHFIN20,t1.ORGAN20 ORGAN20,t1.RESER20 RESER20,t1.ANOMD20 ANOMD20,t1.TLFNOR20 TLFNOR20,t1.OBS20 OBS20,t1.DNI20 DNI20,t1.IP20 IP20,t1.USUB20 USUB20,t1.TLFNO20 TLFNO20,t2.CDEP07 AA00J07S01CDEP07,t2.DESCC07 AA00J07S01DESCC07,t2.DESCE07 AA00J07S01DESCE07,t2.SIT07 AA00J07S01SIT07,t2.BLOQ07 AA00J07S01BLOQ07,t2.USUB07 AA00J07S01USUB07,t2.COD_XLNET_07 AA00J07S01COD_XLNET_07,t3.CSALA10 AA00J10S01CSALA10,t3.NOMBRE10 AA00J10S01NOMBRE10,t3.SIT10 AA00J10S01SIT10,t3.BLOQ10 AA00J10S01BLOQ10,t3.SWDISP10 AA00J10S01SWDISP10,t3.DESC10 AA00J10S01DESC10,t3.TLFNO10 AA00J10S01TLFNO10,t3.USUB10 AA00J10S01USUB10,t3.PLANTA10 AA00J10S01PLANTA10,t3.DCAPC10 AA00J10S01DCAPC10,t3.DCAPE10 AA00J10S01DCAPE10,t3.NCAP10 AA00J10S01NCAP10,t4.CDEP07 AA00J07S01CDEP07_r,t4.DESCC07 AA00J07S01DESCC07_r,t4.DESCE07 AA00J07S01DESCE07_r,t4.SIT07 AA00J07S01SIT07_r,t4.BLOQ07 AA00J07S01BLOQ07_r,t4.USUB07 AA00J07S01USUB07_r, t4.COD_XLNET_07 AA00J07S01COD_XLNET_07_r,t3.CDEP10 AA00J10S01CDEP10,t3.CEDIF10 AA00J10S01CEDIF10,t3.CREST10 AA00J10S01CREST10,t3.CTEXTO10 AA00J10S01CTEXTO10 ");
		// FROM
		// StringBuilder from = new
		// StringBuilder("FROM AA00J20S01 t1 ,AA00J07S01 t2 ,AA00J10S01 t3 ,AA00J07S01 t4 ");
		List<String> from = new ArrayList<String>();
		from.add("AA00J20S01");
		from.add("AA00J07S01");
		from.add("AA00J10S01");
		from.add("AA00J07S01");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");
		from_alias.add(" t3 ");
		from_alias.add(" t4 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa00j20s01, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
				mapaWhere, "COD20", "ID_PADRE", "NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j20s01DaoImpl.logger.info("SQL " + query);

		Aa00j20s01DaoImpl.logger.info("PARAMs " + params);
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAa00j20s01
	 *            Aa00j20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Aa00j20s01 filterAa00j20s01,
			JQGridRequestDto jqGridRequestDto) {
		Aa00j20s01DaoImpl.logger.info("Método findAllLikeCountJerarquia");
		// FROM
		// StringBuilder from = new
		// StringBuilder("FROM AA00J20S01 t1 ,AA00J07S01 t2 ,AA00J10S01 t3 ,AA00J07S01 t4 ");
		List<String> from = new ArrayList<String>();
		from.add("AA00J20S01");
		from.add("AA00J07S01");
		from.add("AA00J10S01");
		from.add("AA00J07S01");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");
		from_alias.add(" t3 ");
		from_alias.add(" t4 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa00j20s01, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(
				jqGridRequestDto, mapaWhere, "COD20", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j20s01DaoImpl.logger.info("SQL " + query);

		Aa00j20s01DaoImpl.logger.info("PARAMs " + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAa00j20s01
	 *            Aa00j20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Aa00j20s01>>
	 */
	@Override
	public List<TableRowDto<Aa00j20s01>> findAllChild(
			Aa00j20s01 filterAa00j20s01, JQGridRequestDto jqGridRequestDto) {
		Aa00j20s01DaoImpl.logger.info("Método findAllChild");
		// FROM
		// StringBuilder from = new
		// StringBuilder("FROM AA00J20S01 t1 ,AA00J07S01 t2 ,AA00J10S01 t3 ,AA00J07S01 t4 ");
		List<String> from = new ArrayList<String>();
		from.add("AA00J20S01");
		from.add("AA00J07S01");
		from.add("AA00J10S01");
		from.add("AA00J07S01");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");
		from_alias.add(" t3 ");
		from_alias.add(" t4 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa00j20s01, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(
				jqGridRequestDto, mapaWhere, "COD20", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j20s01DaoImpl.logger.info("SQL " + query);

		Aa00j20s01DaoImpl.logger.info("PARAMs " + params);
		return this.jdbcTemplate
				.query(query.toString(),
						new RowNumResultSetExtractor<Aa00j20s01>(this.rwMapPK,
								"COD20"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa00j20s01 entity
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Aa00j20s01 aa00j20s01) {

		StringBuilder where = new StringBuilder(
				Aa00j20s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa00j20s01 != null && aa00j20s01.getCod20() != null) {
			where.append(" AND t1.COD20 = ?");
			params.add(aa00j20s01.getCod20());
		}
		if (aa00j20s01 != null && aa00j20s01.getAa00j07s01ByCdep20() != null
				&& aa00j20s01.getAa00j07s01ByCdep20().getCdep07() != null) {
			where.append(" AND t2.CDEP07 = ?");
			params.add(aa00j20s01.getAa00j07s01ByCdep20().getCdep07());
		}
		if (aa00j20s01 != null && aa00j20s01.getAa00j07s01ByCdep20() != null
				&& aa00j20s01.getAa00j07s01ByCdep20().getDescc07() != null) {
			where.append(" AND t2.DESCC07 = ?");
			params.add(aa00j20s01.getAa00j07s01ByCdep20().getDescc07());
		}
		if (aa00j20s01 != null && aa00j20s01.getAa00j07s01ByCdep20() != null
				&& aa00j20s01.getAa00j07s01ByCdep20().getDesce07() != null) {
			where.append(" AND t2.DESCE07 = ?");
			params.add(aa00j20s01.getAa00j07s01ByCdep20().getDesce07());
		}
		if (aa00j20s01 != null && aa00j20s01.getAa00j07s01ByCdep20() != null
				&& aa00j20s01.getAa00j07s01ByCdep20().getSit07() != null) {
			where.append(" AND t2.SIT07 = ?");
			params.add(aa00j20s01.getAa00j07s01ByCdep20().getSit07());
		}
		if (aa00j20s01 != null && aa00j20s01.getAa00j07s01ByCdep20() != null
				&& aa00j20s01.getAa00j07s01ByCdep20().getBloq07() != null) {
			where.append(" AND t2.BLOQ07 = ?");
			params.add(aa00j20s01.getAa00j07s01ByCdep20().getBloq07());
		}
		if (aa00j20s01 != null && aa00j20s01.getAa00j07s01ByCdep20() != null
				&& aa00j20s01.getAa00j07s01ByCdep20().getUsub07() != null) {
			where.append(" AND t2.USUB07 = ?");
			params.add(aa00j20s01.getAa00j07s01ByCdep20().getUsub07());
		}
		if (aa00j20s01 != null && aa00j20s01.getAa00j07s01ByCdep20() != null
				&& aa00j20s01.getAa00j07s01ByCdep20().getCodxlnet07() != null) {
			where.append(" AND t2.COD_XLNET_07 = ?");
			params.add(aa00j20s01.getAa00j07s01ByCdep20().getCodxlnet07());
		}
		if (aa00j20s01 != null && aa00j20s01.getAa00j10s01() != null
				&& aa00j20s01.getAa00j10s01().getCsala10() != null) {
			where.append(" AND t3.CSALA10 = ?");
			params.add(aa00j20s01.getAa00j10s01().getCsala10());
		}
		if (aa00j20s01 != null
				&& aa00j20s01.getAa00j10s01() != null
				&& aa00j20s01.getAa00j10s01().getAa00j07s01() != null
				&& aa00j20s01.getAa00j10s01().getAa00j07s01().getCdep07() != null) {
			where.append(" AND t3.CDEP10 = ?");
			params.add(aa00j20s01.getAa00j10s01().getAa00j07s01().getCdep07());
		}
		if (aa00j20s01 != null
				&& aa00j20s01.getAa00j10s01() != null
				&& aa00j20s01.getAa00j10s01().getAa00j03s01() != null
				&& aa00j20s01.getAa00j10s01().getAa00j03s01().getCedif03() != null) {
			where.append(" AND t3.CEDIF10 = ?");
			params.add(aa00j20s01.getAa00j10s01().getAa00j03s01().getCedif03());
		}
		if (aa00j20s01 != null
				&& aa00j20s01.getAa00j10s01() != null
				&& aa00j20s01.getAa00j10s01().getAa00j06s01() != null
				&& aa00j20s01.getAa00j10s01().getAa00j06s01().getCrest06() != null) {
			where.append(" AND t3.CREST10 = ?");
			params.add(aa00j20s01.getAa00j10s01().getAa00j06s01().getCrest06());
		}
		if (aa00j20s01 != null
				&& aa00j20s01.getAa00j10s01() != null
				&& aa00j20s01.getAa00j10s01().getAa00j04s01() != null
				&& aa00j20s01.getAa00j10s01().getAa00j04s01().getCtexto04() != null) {
			where.append(" AND t3.CTEXTO10 = ?");
			params.add(aa00j20s01.getAa00j10s01().getAa00j04s01().getCtexto04());
		}
		if (aa00j20s01 != null && aa00j20s01.getAa00j10s01() != null
				&& aa00j20s01.getAa00j10s01().getNombre10() != null) {
			where.append(" AND t3.NOMBRE10 = ?");
			params.add(aa00j20s01.getAa00j10s01().getNombre10());
		}
		if (aa00j20s01 != null && aa00j20s01.getAa00j10s01() != null
				&& aa00j20s01.getAa00j10s01().getSit10() != null) {
			where.append(" AND t3.SIT10 = ?");
			params.add(aa00j20s01.getAa00j10s01().getSit10());
		}
		if (aa00j20s01 != null && aa00j20s01.getAa00j10s01() != null
				&& aa00j20s01.getAa00j10s01().getBloq10() != null) {
			where.append(" AND t3.BLOQ10 = ?");
			params.add(aa00j20s01.getAa00j10s01().getBloq10());
		}
		if (aa00j20s01 != null && aa00j20s01.getAa00j10s01() != null
				&& aa00j20s01.getAa00j10s01().getSwdisp10() != null) {
			where.append(" AND t3.SWDISP10 = ?");
			params.add(aa00j20s01.getAa00j10s01().getSwdisp10());
		}
		if (aa00j20s01 != null && aa00j20s01.getAa00j10s01() != null
				&& aa00j20s01.getAa00j10s01().getDesc10() != null) {
			where.append(" AND t3.DESC10 = ?");
			params.add(aa00j20s01.getAa00j10s01().getDesc10());
		}
		if (aa00j20s01 != null && aa00j20s01.getAa00j10s01() != null
				&& aa00j20s01.getAa00j10s01().getTlfno10() != null) {
			where.append(" AND t3.TLFNO10 = ?");
			params.add(aa00j20s01.getAa00j10s01().getTlfno10());
		}
		if (aa00j20s01 != null && aa00j20s01.getAa00j10s01() != null
				&& aa00j20s01.getAa00j10s01().getUsub10() != null) {
			where.append(" AND t3.USUB10 = ?");
			params.add(aa00j20s01.getAa00j10s01().getUsub10());
		}
		if (aa00j20s01 != null && aa00j20s01.getAa00j10s01() != null
				&& aa00j20s01.getAa00j10s01().getPlanta10() != null) {
			where.append(" AND t3.PLANTA10 = ?");
			params.add(aa00j20s01.getAa00j10s01().getPlanta10());
		}
		if (aa00j20s01 != null && aa00j20s01.getAa00j10s01() != null
				&& aa00j20s01.getAa00j10s01().getDcapc10() != null) {
			where.append(" AND t3.DCAPC10 = ?");
			params.add(aa00j20s01.getAa00j10s01().getDcapc10());
		}
		if (aa00j20s01 != null && aa00j20s01.getAa00j10s01() != null
				&& aa00j20s01.getAa00j10s01().getDcape10() != null) {
			where.append(" AND t3.DCAPE10 = ?");
			params.add(aa00j20s01.getAa00j10s01().getDcape10());
		}
		if (aa00j20s01 != null && aa00j20s01.getAa00j10s01() != null
				&& aa00j20s01.getAa00j10s01().getNcap10() != null) {
			where.append(" AND t3.NCAP10 = ?");
			params.add(aa00j20s01.getAa00j10s01().getNcap10());
		}
		/*
		 * if (aa00j20s01 != null && aa00j20s01.getAa00j10s01() != null &&
		 * aa00j20s01.getAa00j10s01().getAa00j11s01() != null &&
		 * aa00j20s01.getAa00j10s01().getAa00j11s01().getCsala11() != null) {
		 * where.append(" AND t3.CSALA11 = ?");
		 * params.add(aa00j20s01.getAa00j10s01().getAa00j11s01().getCsala11());
		 * }
		 */
		if (aa00j20s01 != null && aa00j20s01.getAa00j07s01ByCdepr20() != null
				&& aa00j20s01.getAa00j07s01ByCdepr20().getCdep07() != null) {
			where.append(" AND t4.CDEP07 = ?");
			params.add(aa00j20s01.getAa00j07s01ByCdepr20().getCdep07());
		}
		if (aa00j20s01 != null && aa00j20s01.getAa00j07s01ByCdepr20() != null
				&& aa00j20s01.getAa00j07s01ByCdepr20().getDescc07() != null) {
			where.append(" AND t4.DESCC07 = ?");
			params.add(aa00j20s01.getAa00j07s01ByCdepr20().getDescc07());
		}
		if (aa00j20s01 != null && aa00j20s01.getAa00j07s01ByCdepr20() != null
				&& aa00j20s01.getAa00j07s01ByCdepr20().getDesce07() != null) {
			where.append(" AND t4.DESCE07 = ?");
			params.add(aa00j20s01.getAa00j07s01ByCdepr20().getDesce07());
		}
		if (aa00j20s01 != null && aa00j20s01.getAa00j07s01ByCdepr20() != null
				&& aa00j20s01.getAa00j07s01ByCdepr20().getSit07() != null) {
			where.append(" AND t4.SIT07 = ?");
			params.add(aa00j20s01.getAa00j07s01ByCdepr20().getSit07());
		}
		if (aa00j20s01 != null && aa00j20s01.getAa00j07s01ByCdepr20() != null
				&& aa00j20s01.getAa00j07s01ByCdepr20().getBloq07() != null) {
			where.append(" AND t4.BLOQ07 = ?");
			params.add(aa00j20s01.getAa00j07s01ByCdepr20().getBloq07());
		}
		if (aa00j20s01 != null && aa00j20s01.getAa00j07s01ByCdepr20() != null
				&& aa00j20s01.getAa00j07s01ByCdepr20().getUsub07() != null) {
			where.append(" AND t4.USUB07 = ?");
			params.add(aa00j20s01.getAa00j07s01ByCdepr20().getUsub07());
		}
		if (aa00j20s01 != null && aa00j20s01.getAa00j07s01ByCdepr20() != null
				&& aa00j20s01.getAa00j07s01ByCdepr20().getCodxlnet07() != null) {
			where.append(" AND t4.COD_XLNET_07 = ?");
			params.add(aa00j20s01.getAa00j07s01ByCdepr20().getCodxlnet07());
		}
		if (aa00j20s01 != null && aa00j20s01.getSit20() != null) {
			where.append(" AND t1.SIT20 = ?");
			params.add(aa00j20s01.getSit20());
		}
		if (aa00j20s01 != null && aa00j20s01.getBloq20() != null) {
			where.append(" AND t1.BLOQ20 = ?");
			params.add(aa00j20s01.getBloq20());
		}
		if (aa00j20s01 != null && aa00j20s01.getSwfhor20() != null) {
			where.append(" AND t1.SWFHOR20 = ?");
			params.add(aa00j20s01.getSwfhor20());
		}
		if (aa00j20s01 != null && aa00j20s01.getSwconf20() != null) {
			where.append(" AND t1.SWCONF20 = ?");
			params.add(aa00j20s01.getSwconf20());
		}
		if (aa00j20s01 != null && aa00j20s01.getSwmaile20() != null) {
			where.append(" AND t1.SWMAILE20 = ?");
			params.add(aa00j20s01.getSwmaile20());
		}
		if (aa00j20s01 != null && aa00j20s01.getSwmailer20() != null) {
			where.append(" AND t1.SWMAILER20 = ?");
			params.add(aa00j20s01.getSwmailer20());
		}
		if (aa00j20s01 != null && aa00j20s01.getSwautc20() != null) {
			where.append(" AND t1.SWAUTC20 = ?");
			params.add(aa00j20s01.getSwautc20());
		}
		if (aa00j20s01 != null && aa00j20s01.getAsun20() != null) {
			where.append(" AND t1.ASUN20 = ?");
			params.add(aa00j20s01.getAsun20());
		}
		if (aa00j20s01 != null && aa00j20s01.getDhcom20() != null) {
			where.append(" AND TO_DATE(t1.DHCOM20) = ?");
			params.add(aa00j20s01.getDhcom20());
		}
		if (aa00j20s01 != null && aa00j20s01.getDhfin20() != null) {
			where.append(" AND TO_DATE(t1.DHFIN20) = ?");
			params.add(aa00j20s01.getDhfin20());
		}
		if (aa00j20s01 != null && aa00j20s01.getOrgan20() != null) {
			where.append(" AND t1.ORGAN20 = ?");
			params.add(aa00j20s01.getOrgan20());
		}
		if (aa00j20s01 != null && aa00j20s01.getReser20() != null) {
			where.append(" AND t1.RESER20 = ?");
			params.add(aa00j20s01.getReser20());
		}
		if (aa00j20s01 != null && aa00j20s01.getAnomd20() != null) {
			where.append(" AND t1.ANOMD20 = ?");
			params.add(aa00j20s01.getAnomd20());
		}
		if (aa00j20s01 != null && aa00j20s01.getTlfnor20() != null) {
			where.append(" AND t1.TLFNOR20 = ?");
			params.add(aa00j20s01.getTlfnor20());
		}
		if (aa00j20s01 != null && aa00j20s01.getObs20() != null) {
			where.append(" AND t1.OBS20 = ?");
			params.add(aa00j20s01.getObs20());
		}
		if (aa00j20s01 != null && aa00j20s01.getDni20() != null) {
			where.append(" AND t1.DNI20 = ?");
			params.add(aa00j20s01.getDni20());
		}
		if (aa00j20s01 != null && aa00j20s01.getIp20() != null) {
			where.append(" AND t1.IP20 = ?");
			params.add(aa00j20s01.getIp20());
		}
		if (aa00j20s01 != null && aa00j20s01.getUsub20() != null) {
			where.append(" AND t1.USUB20 = ?");
			params.add(aa00j20s01.getUsub20());
		}
		if (aa00j20s01 != null && aa00j20s01.getTlfno20() != null) {
			where.append(" AND t1.TLFNO20 = ?");
			params.add(aa00j20s01.getTlfno20());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa00j20s01 entity
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Aa00j20s01 aa00j20s01,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				Aa00j20s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa00j20s01 != null && aa00j20s01.getCod20() != null) {
			where.append(" AND t1.COD20 = ?");
			params.add(aa00j20s01.getCod20());
		}
		/*
		 * if (aa00j20s01 != null && aa00j20s01.getAa00j07s01ByCdep20() != null
		 * && aa00j20s01.getAa00j07s01ByCdep20().getCdep07() != null) {
		 * where.append(" AND t2.CDEP07 = ?");
		 * params.add(aa00j20s01.getAa00j07s01ByCdep20().getCdep07()); } if
		 * (aa00j20s01 != null && aa00j20s01.getAa00j07s01ByCdep20() != null &&
		 * aa00j20s01.getAa00j07s01ByCdep20().getDescc07() != null) {
		 * where.append(" AND UPPER(t2.DESCC07) like ? ESCAPE  '\\'"); if
		 * (startsWith) {
		 * params.add(aa00j20s01.getAa00j07s01ByCdep20().getDescc07()
		 * .toUpperCase() + "%"); } else { params.add("%" +
		 * aa00j20s01.getAa00j07s01ByCdep20().getDescc07() .toUpperCase() +
		 * "%"); } where.append(" AND t2.DESCC07 IS NOT NULL"); } if (aa00j20s01
		 * != null && aa00j20s01.getAa00j07s01ByCdep20() != null &&
		 * aa00j20s01.getAa00j07s01ByCdep20().getDesce07() != null) {
		 * where.append(" AND UPPER(t2.DESCE07) like ? ESCAPE  '\\'"); if
		 * (startsWith) {
		 * params.add(aa00j20s01.getAa00j07s01ByCdep20().getDesce07()
		 * .toUpperCase() + "%"); } else { params.add("%" +
		 * aa00j20s01.getAa00j07s01ByCdep20().getDesce07() .toUpperCase() +
		 * "%"); } where.append(" AND t2.DESCE07 IS NOT NULL"); } if (aa00j20s01
		 * != null && aa00j20s01.getAa00j07s01ByCdep20() != null &&
		 * aa00j20s01.getAa00j07s01ByCdep20().getSit07() != null) {
		 * where.append(" AND UPPER(t2.SIT07) like ? ESCAPE  '\\'"); if
		 * (startsWith) {
		 * params.add(aa00j20s01.getAa00j07s01ByCdep20().getSit07()
		 * .toUpperCase() + "%"); } else { params.add("%" +
		 * aa00j20s01.getAa00j07s01ByCdep20().getSit07() .toUpperCase() + "%");
		 * } where.append(" AND t2.SIT07 IS NOT NULL"); } if (aa00j20s01 != null
		 * && aa00j20s01.getAa00j07s01ByCdep20() != null &&
		 * aa00j20s01.getAa00j07s01ByCdep20().getBloq07() != null) {
		 * where.append(" AND t2.BLOQ07 = ?");
		 * params.add(aa00j20s01.getAa00j07s01ByCdep20().getBloq07()); } if
		 * (aa00j20s01 != null && aa00j20s01.getAa00j07s01ByCdep20() != null &&
		 * aa00j20s01.getAa00j07s01ByCdep20().getUsub07() != null) {
		 * where.append(" AND UPPER(t2.USUB07) like ? ESCAPE  '\\'"); if
		 * (startsWith) {
		 * params.add(aa00j20s01.getAa00j07s01ByCdep20().getUsub07()
		 * .toUpperCase() + "%"); } else { params.add("%" +
		 * aa00j20s01.getAa00j07s01ByCdep20().getUsub07() .toUpperCase() + "%");
		 * } where.append(" AND t2.USUB07 IS NOT NULL"); } if (aa00j20s01 !=
		 * null && aa00j20s01.getAa00j07s01ByCdep20() != null &&
		 * aa00j20s01.getAa00j07s01ByCdep20().getCodxlnet07() != null) {
		 * where.append(" AND UPPER(t2.COD_XLNET_07) like ? ESCAPE  '\\'"); if
		 * (startsWith) {
		 * params.add(aa00j20s01.getAa00j07s01ByCdep20().getCodxlnet07()
		 * .toUpperCase() + "%"); } else { params.add("%" +
		 * aa00j20s01.getAa00j07s01ByCdep20().getCodxlnet07() .toUpperCase() +
		 * "%"); } where.append(" AND t2.COD_XLNET_07 IS NOT NULL"); }
		 */
		if (aa00j20s01 != null && aa00j20s01.getAa00j10s01() != null
				&& aa00j20s01.getAa00j10s01().getCsala10() != null) {
			where.append(" AND t3.CSALA10 = ?");
			params.add(aa00j20s01.getAa00j10s01().getCsala10());
		}
		if (aa00j20s01 != null
				&& aa00j20s01.getAa00j10s01() != null
				&& aa00j20s01.getAa00j10s01().getAa00j07s01() != null
				&& aa00j20s01.getAa00j10s01().getAa00j07s01().getCdep07() != null) {
			where.append(" AND t3.CDEP10 = ?");
			params.add(aa00j20s01.getAa00j10s01().getAa00j07s01().getCdep07());
		}
		if (aa00j20s01 != null
				&& aa00j20s01.getAa00j10s01() != null
				&& aa00j20s01.getAa00j10s01().getAa00j03s01() != null
				&& aa00j20s01.getAa00j10s01().getAa00j03s01().getCedif03() != null) {
			where.append(" AND t3.CEDIF10 = ?");
			params.add(aa00j20s01.getAa00j10s01().getAa00j03s01().getCedif03());
		}
		if (aa00j20s01 != null
				&& aa00j20s01.getAa00j10s01() != null
				&& aa00j20s01.getAa00j10s01().getAa00j06s01() != null
				&& aa00j20s01.getAa00j10s01().getAa00j06s01().getCrest06() != null) {
			where.append(" AND t3.CREST10 = ?");
			params.add(aa00j20s01.getAa00j10s01().getAa00j06s01().getCrest06());
		}
		if (aa00j20s01 != null
				&& aa00j20s01.getAa00j10s01() != null
				&& aa00j20s01.getAa00j10s01().getAa00j04s01() != null
				&& aa00j20s01.getAa00j10s01().getAa00j04s01().getCtexto04() != null) {
			where.append(" AND t3.CTEXTO10 = ?");
			params.add(aa00j20s01.getAa00j10s01().getAa00j04s01().getCtexto04());
		}
		if (aa00j20s01 != null && aa00j20s01.getAa00j10s01() != null
				&& aa00j20s01.getAa00j10s01().getNombre10() != null) {
			where.append(" AND UPPER(t3.NOMBRE10) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j20s01.getAa00j10s01().getNombre10()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j20s01.getAa00j10s01().getNombre10()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.NOMBRE10 IS NOT NULL");
		}
		if (aa00j20s01 != null && aa00j20s01.getAa00j10s01() != null
				&& aa00j20s01.getAa00j10s01().getSit10() != null) {
			where.append(" AND UPPER(t3.SIT10) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j20s01.getAa00j10s01().getSit10().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j20s01.getAa00j10s01().getSit10().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.SIT10 IS NOT NULL");
		}
		if (aa00j20s01 != null && aa00j20s01.getAa00j10s01() != null
				&& aa00j20s01.getAa00j10s01().getBloq10() != null) {
			where.append(" AND t3.BLOQ10 = ?");
			params.add(aa00j20s01.getAa00j10s01().getBloq10());
		}
		if (aa00j20s01 != null && aa00j20s01.getAa00j10s01() != null
				&& aa00j20s01.getAa00j10s01().getSwdisp10() != null) {
			where.append(" AND t3.SWDISP10 = ?");
			params.add(aa00j20s01.getAa00j10s01().getSwdisp10());
		}
		if (aa00j20s01 != null && aa00j20s01.getAa00j10s01() != null
				&& aa00j20s01.getAa00j10s01().getDesc10() != null) {
			where.append(" AND UPPER(t3.DESC10) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j20s01.getAa00j10s01().getDesc10().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j20s01.getAa00j10s01().getDesc10().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.DESC10 IS NOT NULL");
		}
		if (aa00j20s01 != null && aa00j20s01.getAa00j10s01() != null
				&& aa00j20s01.getAa00j10s01().getTlfno10() != null) {
			where.append(" AND UPPER(t3.TLFNO10) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j20s01.getAa00j10s01().getTlfno10()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j20s01.getAa00j10s01().getTlfno10().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.TLFNO10 IS NOT NULL");
		}
		if (aa00j20s01 != null && aa00j20s01.getAa00j10s01() != null
				&& aa00j20s01.getAa00j10s01().getUsub10() != null) {
			where.append(" AND UPPER(t3.USUB10) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j20s01.getAa00j10s01().getUsub10().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j20s01.getAa00j10s01().getUsub10().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.USUB10 IS NOT NULL");
		}
		if (aa00j20s01 != null && aa00j20s01.getAa00j10s01() != null
				&& aa00j20s01.getAa00j10s01().getPlanta10() != null) {
			where.append(" AND UPPER(t3.PLANTA10) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j20s01.getAa00j10s01().getPlanta10()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j20s01.getAa00j10s01().getPlanta10()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.PLANTA10 IS NOT NULL");
		}
		if (aa00j20s01 != null && aa00j20s01.getAa00j10s01() != null
				&& aa00j20s01.getAa00j10s01().getDcapc10() != null) {
			where.append(" AND UPPER(t3.DCAPC10) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j20s01.getAa00j10s01().getDcapc10()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j20s01.getAa00j10s01().getDcapc10().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.DCAPC10 IS NOT NULL");
		}
		if (aa00j20s01 != null && aa00j20s01.getAa00j10s01() != null
				&& aa00j20s01.getAa00j10s01().getDcape10() != null) {
			where.append(" AND UPPER(t3.DCAPE10) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j20s01.getAa00j10s01().getDcape10()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j20s01.getAa00j10s01().getDcape10().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.DCAPE10 IS NOT NULL");
		}
		if (aa00j20s01 != null && aa00j20s01.getAa00j10s01() != null
				&& aa00j20s01.getAa00j10s01().getNcap10() != null) {
			where.append(" AND t3.NCAP10 = ?");
			params.add(aa00j20s01.getAa00j10s01().getNcap10());
		}
		/*
		 * if (aa00j20s01 != null && aa00j20s01.getAa00j10s01() != null &&
		 * aa00j20s01.getAa00j10s01().getAa00j11s01() != null &&
		 * aa00j20s01.getAa00j10s01().getAa00j11s01().getCsala11() != null) {
		 * where.append(" AND t3.CSALA11 = ?");
		 * params.add(aa00j20s01.getAa00j10s01().getAa00j11s01().getCsala11());
		 * }
		 */
		if (aa00j20s01 != null && aa00j20s01.getAa00j07s01ByCdepr20() != null
				&& aa00j20s01.getAa00j07s01ByCdepr20().getCdep07() != null) {
			where.append(" AND t4.CDEP07 = ?");
			params.add(aa00j20s01.getAa00j07s01ByCdepr20().getCdep07());
		}
		if (aa00j20s01 != null && aa00j20s01.getAa00j07s01ByCdepr20() != null
				&& aa00j20s01.getAa00j07s01ByCdepr20().getDescc07() != null) {
			where.append(" AND UPPER(t4.DESCC07) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j20s01.getAa00j07s01ByCdepr20().getDescc07()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j20s01.getAa00j07s01ByCdepr20().getDescc07()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.DESCC07 IS NOT NULL");
		}
		if (aa00j20s01 != null && aa00j20s01.getAa00j07s01ByCdepr20() != null
				&& aa00j20s01.getAa00j07s01ByCdepr20().getDesce07() != null) {
			where.append(" AND UPPER(t4.DESCE07) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j20s01.getAa00j07s01ByCdepr20().getDesce07()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j20s01.getAa00j07s01ByCdepr20().getDesce07()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.DESCE07 IS NOT NULL");
		}
		if (aa00j20s01 != null && aa00j20s01.getAa00j07s01ByCdepr20() != null
				&& aa00j20s01.getAa00j07s01ByCdepr20().getSit07() != null) {
			where.append(" AND UPPER(t4.SIT07) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j20s01.getAa00j07s01ByCdepr20().getSit07()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j20s01.getAa00j07s01ByCdepr20().getSit07()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.SIT07 IS NOT NULL");
		}
		if (aa00j20s01 != null && aa00j20s01.getAa00j07s01ByCdepr20() != null
				&& aa00j20s01.getAa00j07s01ByCdepr20().getBloq07() != null) {
			where.append(" AND t4.BLOQ07 = ?");
			params.add(aa00j20s01.getAa00j07s01ByCdepr20().getBloq07());
		}
		if (aa00j20s01 != null && aa00j20s01.getAa00j07s01ByCdepr20() != null
				&& aa00j20s01.getAa00j07s01ByCdepr20().getUsub07() != null) {
			where.append(" AND UPPER(t4.USUB07) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j20s01.getAa00j07s01ByCdepr20().getUsub07()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j20s01.getAa00j07s01ByCdepr20().getUsub07()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.USUB07 IS NOT NULL");
		}
		if (aa00j20s01 != null && aa00j20s01.getAa00j07s01ByCdepr20() != null
				&& aa00j20s01.getAa00j07s01ByCdepr20().getCodxlnet07() != null) {
			where.append(" AND UPPER(t4.COD_XLNET_07) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j20s01.getAa00j07s01ByCdepr20().getCodxlnet07()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j20s01.getAa00j07s01ByCdepr20().getCodxlnet07()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.COD_XLNET_07 IS NOT NULL");
		}
		if (aa00j20s01 != null && aa00j20s01.getSit20() != null) {
			where.append(" AND UPPER(t1.SIT20) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j20s01.getSit20().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j20s01.getSit20().toUpperCase() + "%");
			}
			where.append(" AND t1.SIT20 IS NOT NULL");
		}
		if (aa00j20s01 != null && aa00j20s01.getBloq20() != null) {
			where.append(" AND t1.BLOQ20 = ?");
			params.add(aa00j20s01.getBloq20());
		}
		if (aa00j20s01 != null && aa00j20s01.getSwfhor20() != null) {
			where.append(" AND t1.SWFHOR20 = ?");
			params.add(aa00j20s01.getSwfhor20());
		}
		if (aa00j20s01 != null && aa00j20s01.getSwconf20() != null) {
			where.append(" AND t1.SWCONF20 = ?");
			params.add(aa00j20s01.getSwconf20());
		}
		if (aa00j20s01 != null && aa00j20s01.getSwmaile20() != null) {
			where.append(" AND t1.SWMAILE20 = ?");
			params.add(aa00j20s01.getSwmaile20());
		}
		if (aa00j20s01 != null && aa00j20s01.getSwmailer20() != null) {
			where.append(" AND t1.SWMAILER20 = ?");
			params.add(aa00j20s01.getSwmailer20());
		}
		if (aa00j20s01 != null && aa00j20s01.getSwautc20() != null) {
			where.append(" AND t1.SWAUTC20 = ?");
			params.add(aa00j20s01.getSwautc20());
		}
		if (aa00j20s01 != null && aa00j20s01.getAsun20() != null) {
			where.append(" AND UPPER(t1.ASUN20) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j20s01.getAsun20().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j20s01.getAsun20().toUpperCase() + "%");
			}
			where.append(" AND t1.ASUN20 IS NOT NULL");
		}
		if (aa00j20s01 != null && aa00j20s01.getDhcom20() != null) {
			where.append(" AND TO_DATE(t1.DHCOM20) = ?");
			params.add(aa00j20s01.getDhcom20());
		}
		if (aa00j20s01 != null && aa00j20s01.getDhfin20() != null) {
			where.append(" AND TO_DATE(t1.DHFIN20) = ?");
			params.add(aa00j20s01.getDhfin20());
		}
		if (aa00j20s01 != null && aa00j20s01.getOrgan20() != null) {
			where.append(" AND UPPER(t1.ORGAN20) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j20s01.getOrgan20().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j20s01.getOrgan20().toUpperCase() + "%");
			}
			where.append(" AND t1.ORGAN20 IS NOT NULL");
		}
		if (aa00j20s01 != null && aa00j20s01.getReser20() != null) {
			where.append(" AND UPPER(t1.RESER20) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j20s01.getReser20().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j20s01.getReser20().toUpperCase() + "%");
			}
			where.append(" AND t1.RESER20 IS NOT NULL");
		}
		if (aa00j20s01 != null && aa00j20s01.getAnomd20() != null) {
			where.append(" AND UPPER(t1.ANOMD20) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j20s01.getAnomd20().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j20s01.getAnomd20().toUpperCase() + "%");
			}
			where.append(" AND t1.ANOMD20 IS NOT NULL");
		}
		if (aa00j20s01 != null && aa00j20s01.getTlfnor20() != null) {
			where.append(" AND UPPER(t1.TLFNOR20) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j20s01.getTlfnor20().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j20s01.getTlfnor20().toUpperCase() + "%");
			}
			where.append(" AND t1.TLFNOR20 IS NOT NULL");
		}
		if (aa00j20s01 != null && aa00j20s01.getObs20() != null) {
			where.append(" AND UPPER(t1.OBS20) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j20s01.getObs20().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j20s01.getObs20().toUpperCase() + "%");
			}
			where.append(" AND t1.OBS20 IS NOT NULL");
		}
		if (aa00j20s01 != null && aa00j20s01.getDni20() != null) {
			where.append(" AND UPPER(t1.DNI20) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j20s01.getDni20().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j20s01.getDni20().toUpperCase() + "%");
			}
			where.append(" AND t1.DNI20 IS NOT NULL");
		}
		if (aa00j20s01 != null && aa00j20s01.getIp20() != null) {
			where.append(" AND UPPER(t1.IP20) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j20s01.getIp20().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j20s01.getIp20().toUpperCase() + "%");
			}
			where.append(" AND t1.IP20 IS NOT NULL");
		}
		if (aa00j20s01 != null && aa00j20s01.getUsub20() != null) {
			where.append(" AND UPPER(t1.USUB20) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j20s01.getUsub20().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j20s01.getUsub20().toUpperCase() + "%");
			}
			where.append(" AND t1.USUB20 IS NOT NULL");
		}
		if (aa00j20s01 != null && aa00j20s01.getTlfno20() != null) {
			where.append(" AND UPPER(t1.TLFNO20) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j20s01.getTlfno20().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j20s01.getTlfno20().toUpperCase() + "%");
			}
			where.append(" AND t1.TLFNO20 IS NOT NULL");
		}
		// Iker días y horas
		if (aa00j20s01 != null && aa00j20s01.getDias() != null) {
			where.append(" AND ( 1=2 ");
			String diaswhere = " OR TRUNC(DHCOM20)=to_date(?,':f')";
			String[] dias = aa00j20s01.getDias().split(",");
			for (String dia : dias) {
				where.append(diaswhere);
				params.add(dia);
			}
			where.append(" )");
		} else {
			where.append(" AND ( TRUNC(DHCOM20)>=TRUNC(SYSDATE))");
		}

		if (aa00j20s01 != null && aa00j20s01.getHoraIni() != null) {
			where.append(" AND to_char(DHCOM20,'HH24:MM')>= ? ");
			params.add(aa00j20s01.getHoraIni());
		}

		if (aa00j20s01 != null && aa00j20s01.getHoraFin() != null) {
			where.append(" AND to_char(DHFIN20,'HH24:MM')<= ? ");
			params.add(aa00j20s01.getHoraFin());
		}
		//

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Inserts a single row in the Aa00j21s01 table.
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01
	 * @return Aa00j20s01
	 */
	public Aa00j20s01 addAa00j21s01(Aa00j20s01 aa00j20s01) {
		Aa00j20s01DaoImpl.logger.info("Método addAa00j21s01");
		String query = "INSERT INTO AA00J21S01 " + "( CRES21,CMEDF21) "
				+ " values (?, ?)";

		List<Aa00j12s01> auxiliarAa00j12s01 = aa00j20s01.getAa00j12s01s();
		Iterator<Aa00j12s01> it = auxiliarAa00j12s01.iterator();
		while (it.hasNext()) {
			Aa00j12s01 aa00j12s01 = (Aa00j12s01) it.next();
			Aa00j20s01DaoImpl.logger.info("SQL " + query);

			Aa00j20s01DaoImpl.logger.info("PARAM1 " + aa00j20s01.getCod20());
			Aa00j20s01DaoImpl.logger.info("PARAM2 " + aa00j12s01.getCmedf12());
			this.jdbcTemplate.update(query, aa00j20s01.getCod20(),
					aa00j12s01.getCmedf12());
		}
		return aa00j20s01;
	}

	/**
	 * Deletes a single row in the Aa00j21s01 table.
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01
	 * @return
	 */
	public void removeAa00j21s01(Aa00j20s01 aa00j20s01) {
		Aa00j20s01DaoImpl.logger.info("Método removeAa00j21s01");
		String query = "DELETE  FROM AA00J21S01 "
				+ " WHERE CRES21=? AND CMEDF21=?";
		List<Aa00j12s01> auxiliarAa00j12s01 = aa00j20s01.getAa00j12s01s();
		Iterator<Aa00j12s01> it = auxiliarAa00j12s01.iterator();
		while (it.hasNext()) {
			Aa00j12s01 aa00j12s01 = (Aa00j12s01) it.next();
			Aa00j20s01DaoImpl.logger.info("SQL " + query);
			Aa00j20s01DaoImpl.logger.info("PARAM1 " + aa00j20s01.getCod20());
			Aa00j20s01DaoImpl.logger.info("PARAM2 " + aa00j12s01.getCmedf12());
			this.jdbcTemplate.update(query, aa00j20s01.getCod20(),
					aa00j12s01.getCmedf12());
		}
	}

	/**
	 * Find a single row in the findAa00j21s01 Many To Many relationship.
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01
	 * @param aa00j12s01
	 *            Aa00j12s01
	 * @param pagination
	 *            Pagination
	 * @return Aa00j20s01
	 */
	@Transactional(readOnly = true)
	public Aa00j20s01 findAa00j21s01(Aa00j20s01 aa00j20s01,
			Aa00j12s01 aa00j12s01, Pagination pagination) {
		Aa00j20s01DaoImpl.logger.info("Método findAa00j21s01");
		StringBuilder where = new StringBuilder(
				Aa00j20s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		where.append("where t1.CMEDF21 = t2.CMEDF12 AND t1.CRES21=?");

		params.add(aa00j20s01.getCod20());

		if (aa00j12s01.getCmedf12() != null) {
			where.append(" AND t2.CMEDF12 = ?");
			params.add(aa00j12s01.getCmedf12());
		}
		if (aa00j12s01.getAa00j10s01() != null) {
			where.append(" AND t2.CSALA12 = ?");
			params.add(aa00j12s01.getAa00j10s01());
		}
		if (aa00j12s01.getNom12() != null) {
			where.append(" AND t2.NOM12 = ?");
			params.add(aa00j12s01.getNom12());
		}
		if (aa00j12s01.getSwdisp12() != null) {
			where.append(" AND t2.SWDISP12 = ?");
			params.add(aa00j12s01.getSwdisp12());
		}
		if (aa00j12s01.getSit12() != null) {
			where.append(" AND t2.SIT12 = ?");
			params.add(aa00j12s01.getSit12());
		}

		StringBuilder query = new StringBuilder(
				"SELECT t2.Cmedf12 CMEDF12, t2.NOM12 NOM12, t2.SWDISP12 SWDISP12, t2.SIT12 SIT12 FROM Aa00j21S01 t1,AA00J12S01 t2  ");
		query.append(where);

		StringBuilder order = new StringBuilder(
				Aa00j20s01DaoImpl.STRING_BUILDER_INIT);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" order by " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuilder(PaginationManager.getPaginationQuery(
					pagination, query));
		}
		Aa00j20s01DaoImpl.logger.info("SQL " + query);
		Aa00j20s01DaoImpl.logger.info("PARAMS " + params);

		List<Aa00j12s01> listaHijo = this.jdbcTemplate.query(query.toString(),
				new RowMapper<Aa00j12s01>() {
					public Aa00j12s01 mapRow(ResultSet resultSet, int rowNum)
							throws SQLException {
						return new Aa00j12s01(resultSet.getLong("CMEDF12"),
								resultSet.getString("NOM12"), resultSet
										.getInt("SWDISP12"), resultSet
										.getString("SIT12"), null, null);
					}
				}, params.toArray());
		aa00j20s01.setAa00j12s01s(listaHijo);
		return aa00j20s01;
	}

	/**
	 * Counts rows in the Aa00j21s01 table.
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01
	 * @param aa00j12s01
	 *            Aa00j12s01
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAa00j21s01Count(Aa00j20s01 aa00j20s01, Aa00j12s01 aa00j12s01) {
		Aa00j20s01DaoImpl.logger.info("Método findAa00j21s01Count");
		StringBuilder where = new StringBuilder(
				Aa00j20s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();
		where.append("where t1.CMEDF21 = t2.CMEDF12 AND t1.CRES21=?");

		params.add(aa00j20s01.getCod20());

		if (aa00j12s01.getCmedf12() != null) {
			where.append(" AND t2.CMEDF12 = ?");
			params.add(aa00j12s01.getCmedf12());
		}
		if (aa00j12s01.getAa00j10s01() != null) {
			where.append(" AND t2.CSALA12 = ?");
			params.add(aa00j12s01.getAa00j10s01());
		}
		if (aa00j12s01.getNom12() != null) {
			where.append(" AND t2.NOM12 = ?");
			params.add(aa00j12s01.getNom12());
		}
		if (aa00j12s01.getSwdisp12() != null) {
			where.append(" AND t2.SWDISP12 = ?");
			params.add(aa00j12s01.getSwdisp12());
		}
		if (aa00j12s01.getSit12() != null) {
			where.append(" AND t2.SIT12 = ?");
			params.add(aa00j12s01.getSit12());
		}

		StringBuilder query = new StringBuilder(
				"SELECT count(1) FROM Aa00j21S01 t1,AA00J12S01 t2  ");
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	public boolean existeDepartamento(Long cdep20) {
		Aa00j20s01DaoImpl.logger.info("Método existeDepartamento");
		String query = "SELECT COUNT(1) FROM AA00J20S01 WHERE UPPER(CDEP20) = ?";
		Aa00j20s01DaoImpl.logger.info("SQL " + query);
		Aa00j20s01DaoImpl.logger.info("PARAM1 " + cdep20);

		return this.jdbcTemplate.queryForInt(query, cdep20) > 0;
	}

	public boolean existeSala(Long csala20) {
		Aa00j20s01DaoImpl.logger.info("Método existeSala");
		String query = "SELECT COUNT(1) FROM AA00J20S01 WHERE UPPER(CSALA20) = ?";
		Aa00j20s01DaoImpl.logger.info("SQL " + query);
		Aa00j20s01DaoImpl.logger.info("PARAM1 " + csala20);
		return this.jdbcTemplate.queryForInt(query, csala20) > 0;
	}

	public boolean existeSalaDisponible(Long csala20, Date fechaHoraIni,
			Date fechaHoraFin, Long codReservaExcluir) {
		Aa00j20s01DaoImpl.logger.info("Método existeSalaDisponible");
		/*
		 * StringBuilder query = new StringBuilder(
		 * Aa00j20s01DaoImpl.STRING_BUILDER_INIT); query.append(
		 * "SELECT COUNT(1) FROM AA00J20S01 WHERE SIT20=? AND CSALA20 = ?");
		 * query.append(
		 * " AND ((TO_DATE(TO_CHAR(DHCOM20, :f), :f) >= TO_DATE(TO_CHAR(?, :f), :f) AND TO_DATE(TO_CHAR(DHCOM20, :f), :f) < TO_DATE(TO_CHAR(?, :f), :f)) "
		 * ); query.append(
		 * " 		 OR (TO_DATE(TO_CHAR(DHFIN20, :f), :f) >= TO_DATE(TO_CHAR(?, :f), :f) AND TO_DATE(TO_CHAR(DHFIN20, :f), :f) < TO_DATE(TO_CHAR(?, :f), :f))) "
		 * );
		 * 
		 * String strQuery = query.toString(); strQuery = strQuery.replace(":f",
		 * aa00jConstantes.FORMATOFECHAHORA_BD);
		 * 
		 * List<Object> params = new ArrayList<Object>();
		 * params.add(aa00jConstantes.SITUACION_ALTA); params.add(csala20);
		 * params.add(fechaHoraIni); params.add(fechaHoraFin);
		 * params.add(fechaHoraIni); params.add(fechaHoraFin);
		 * 
		 * return this.jdbcTemplate.queryForInt(strQuery, params.toArray()) ==
		 * 0;
		 */
		StringBuilder query = new StringBuilder(
				Aa00j20s01DaoImpl.STRING_BUILDER_INIT);
		query.append("SELECT COUNT(1) FROM AA00J20S01 WHERE SIT20=? AND CSALA20 = ?");
		query.append(" AND TO_DATE(TO_CHAR(DHCOM20, :f), :f) < TO_DATE(TO_CHAR(?, :f), :f) ");
		query.append(" AND TO_DATE(TO_CHAR(DHFIN20, :f), :f) > TO_DATE(TO_CHAR(?, :f), :f) ");
		if (codReservaExcluir != null) {
			query.append(" AND COD20 <> ? ");
		}

		String strQuery = query.toString();
		strQuery = strQuery.replace(":f", aa00jConstantes.FORMATOFECHAHORA_BD);

		List<Object> params = new ArrayList<Object>();
		params.add(aa00jConstantes.SITUACION_ALTA);
		params.add(csala20);
		params.add(fechaHoraFin);
		params.add(fechaHoraIni);
		if (codReservaExcluir != null) {
			params.add(codReservaExcluir);
		}
		Aa00j20s01DaoImpl.logger.info("SQL " + strQuery);
		Aa00j20s01DaoImpl.logger.info("PARAMs " + params);
		return this.jdbcTemplate.queryForInt(strQuery, params.toArray()) == 0;
	}

	/**
	 * Devuelve el numero reservas para una sala sin confirmar y en alta para el
	 * usuario (si el usuario es tecnico, se devuelven todas)
	 * 
	 * @param dias
	 * @param sala
	 * @param departamento
	 * @param edificio
	 * @return
	 */
	public Long obtenerOcupacionesSinConfirmarNum(ArrayList<Date> dias,
			Integer sala, Integer departamento, Integer edificio) {
		Aa00j20s01DaoImpl.logger
				.info("Método obtenerOcupacionesSinConfirmarNum");
		List<Object> params = new ArrayList<Object>();
		StringBuffer sql = new StringBuffer();
		sql.append(" select count(*) ");
		sql.append(" from aa00j10S01 inner join aa00j20S01 on csala20=csala10 inner join aa00j03S01 on cedif10=cedif03 where SWCONF20=0 and SIT20='A'  ");
		aa00jPersonaSesion ps = new aa00jSeguridad().getUsuario();
		if (!ps.isEsAdminDepto() && !ps.isEsTecnico() && !ps.isEsAdmin()) {
			String usuario = ps.getPersonaXLNET().getCodigo();
			// sql.append("	AND (reser20=? or ANOMD20=?)");
			sql.append("	AND (organ20=? or DNI20=?)");
			params.add(usuario);
			params.add(usuario);
		}
		if (sala != null && sala != -1) {// se busca por codigo de sala
			sql.append(" and csala10 = ?");
			params.add(sala.intValue());
		} else {
			if (edificio != -1 || departamento != -1) {
				if (edificio != null && edificio != -1) {
					sql.append(" AND CDEP10 is null");// Está en modo no
														// departamentales,
														// mostrar
														// solo
														// las que tienen
														// codsala
					if (edificio != -1) {
						sql.append(" and csitio03 = ?");
						params.add(edificio.intValue());
					}
				}
				if (departamento != null && departamento != -1) {
					sql.append(" AND CDEP10= ?");// Está en modo departamentales
					params.add(departamento.intValue());
				} else {
					sql.append(" AND CDEP10 IS  NULL");// está en modo no
														// departamentales

				}
			} else {// solamente tiene día--> para usuarios no administradores
					// buscar los de su departamento o los que no tienen
					// departamento
				if (!ps.isEsAdminDepto() && !ps.isEsTecnico()
						&& !ps.isEsAdmin()) {
					sql.append(" AND (CDEP10=? OR CDEP10 IS NULL)");
					params.add(Long.parseLong(ps.getDepartamentoInterno()));

				}

			}

		}
		boolean primero = true;
		if (dias.size() > 0) {
			sql.append(" and (");

			for (Date dia : dias) {
				if (!primero) {
					sql.append(" OR ");
				}
				sql.append("  ? =TRUNC(dhcom20)");

				primero = false;

				params.add(new java.sql.Timestamp(dia.getTime()));
			}
			sql.append(" ) ");
		}

		Aa00j20s01DaoImpl.logger.info("SQL " + sql);
		Aa00j20s01DaoImpl.logger.info("PARAMs " + params);
		return this.jdbcTemplate.queryForLong(sql.toString(), params.toArray());

	}

	/**
	 * Devuelve una lista de reservas para una sala sin confirmar y en alta para
	 * el usuario (si el usuario es tecnico, se devuelven todas)
	 * 
	 * @param dias
	 * @param sala
	 * @param departamento
	 * @param edificio
	 * @return
	 */
	public ArrayList<Aa00j20s01> obtenerOcupacionesSinConfirmar(
			ArrayList<Date> dias, Integer sala, Integer departamento,
			Integer edificio, JQGridRequestDto jqGridRequestDto) {
		Aa00j20s01DaoImpl.logger.info("Método obtenerOcupacionesSinConfirmar");
		List<Object> params = new ArrayList<Object>();
		StringBuilder sql = new StringBuilder();
		sql.append(" select cod20,csala10 as Aa00j10s01CSALA10, Nombre10 as Aa00j10s01NOMBRE10 ,asun20,dhcom20,DHFIN20,anomd20, ");
		sql.append("   to_char(dhcom20,'HH24:mi') as horaIni,");
		sql.append("  to_char(DHFIN20,'HH24:mi') as horaFin,email20,emailr20");
		sql.append(" from aa00j10S01 inner join aa00j20S01 on csala20=csala10 inner join aa00j03S01 on cedif10=cedif03 where SWCONF20=0 and SIT20='A'  ");
		aa00jPersonaSesion ps = new aa00jSeguridad().getUsuario();
		if (!ps.isEsAdminDepto() && !ps.isEsTecnico() && !ps.isEsAdmin()) {
			String usuario = ps.getPersonaXLNET().getCodigo();
			// sql.append("	AND (reser20=? or ANOMD20=?)");
			sql.append("	AND (organ20=? or DNI20=?)");
			params.add(usuario);
			params.add(usuario);
		}
		if (sala != null && sala != -1) {// se busca por codigo de sala
			sql.append(" and csala10 = ?");
			params.add(sala.intValue());
		} else {
			if (edificio != -1 || departamento != -1) {
				if (edificio != null && edificio != -1) {
					sql.append(" AND CDEP10 is null");// Está en modo no
														// departamentales,
														// mostrar
														// solo
														// las que tienen
														// codsala
					if (edificio != -1) {
						sql.append(" and csitio03 = ?");
						params.add(edificio.intValue());
					}
				}
				if (departamento != null && departamento != -1) {
					sql.append(" AND CDEP10= ?");// Está en modo departamentales
					params.add(departamento.intValue());
				} else {
					sql.append(" AND CDEP10 IS  NULL");// está en modo no
														// departamentales

				}
			} else {// solamente tiene día--> para usuarios no administradores
					// buscar los de su departamento o los que no tienen
					// departamento
				if (!ps.isEsAdminDepto() && !ps.isEsTecnico()
						&& !ps.isEsAdmin()) {
					sql.append(" AND (CDEP10=? OR CDEP10 IS NULL)");
					params.add(Long.parseLong(ps.getDepartamentoInterno()));

				}

			}

		}
		boolean primero = true;
		if (dias.size() > 0) {
			sql.append(" and (");

			for (Date dia : dias) {
				if (!primero) {
					sql.append(" OR ");
				}
				sql.append("  ? =TRUNC(dhcom20)");

				primero = false;

				params.add(new java.sql.Timestamp(dia.getTime()));
			}
			sql.append(" ) ");
		}

		if (jqGridRequestDto != null) {
			sql = JQGridManager.getPaginationQuery(jqGridRequestDto, sql);
		}
		Aa00j20s01DaoImpl.logger.info("SQL " + sql);
		Aa00j20s01DaoImpl.logger.info("PARAMs " + params);
		return (ArrayList<Aa00j20s01>) this.jdbcTemplate.query(sql.toString(),
				this.rwMap2, params.toArray());

	}

	/**
	 * Devuelve una lista de reservas para una sala sin confirmar y en alta para
	 * 
	 * 
	 * @param dias
	 * 
	 * @return
	 */
	public ArrayList<Aa00j20s01> obtenerOcupacionesSinConfirmar() {
		Aa00j20s01DaoImpl.logger.info("obtenerOcupacionesSinConfirmar ");

		StringBuilder sql = new StringBuilder();
		sql.append(" select cod20,csala10 as Aa00j10s01CSALA10, Nombre10 as Aa00j10s01NOMBRE10 ,asun20,dhcom20,DHFIN20,anomd20, ");
		sql.append("   to_char(dhcom20,'HH24:mi') as horaIni,");
		sql.append("  to_char(DHFIN20,'HH24:mi') as horaFin,email20,emailr20");
		sql.append(" from aa00j10S01 inner join aa00j20S01 on csala20=csala10 inner join aa00j03S01 on cedif10=cedif03 where SWCONF20=0 and SIT20='A'   ");
		sql.append(" and trunc(dhcom20)>=TRUNC(SYSDATE) and trunc(dhcom20)<=Trunc(Sysdate +15)");

		Aa00j20s01DaoImpl.logger.info("sql " + sql.toString());

		return (ArrayList<Aa00j20s01>) this.jdbcTemplate.query(sql.toString(),
				this.rwMap2);

	}

	public List<Aa00j20s01> obtenerOcupacionesFechas(Long csala20,
			Date fechaHoraIni, Date fechaHoraFin, Long codReservaExcluir) {
		Aa00j20s01DaoImpl.logger.info("Método obtenerOcupacionesFechas");
		/*
		 * StringBuilder query = new StringBuilder(
		 * "SELECT  t1.COD20 COD20,t1.SIT20 SIT20,t1.BLOQ20 BLOQ20,t1.SWFHOR20 SWFHOR20,t1.SWCONF20 SWCONF20,t1.SWMAILE20 SWMAILE20,t1.SWAUTC20 SWAUTC20,t1.ASUN20 ASUN20,t1.DHCOM20 DHCOM20,t1.DHFIN20 DHFIN20,t1.ORGAN20 ORGAN20,t1.RESER20 RESER20,t1.ANOMD20 ANOMD20,t1.TLFNOR20 TLFNOR20,t1.OBS20 OBS20,t1.DNI20 DNI20,t1.IP20 IP20,t1.USUB20 USUB20,t1.TLFNO20 TLFNO20,null AA00J07S01CDEP07,null AA00J07S01DESCC07,null AA00J07S01DESCE07,null AA00J07S01SIT07,null AA00J07S01BLOQ07,null AA00J07S01USUB07,null AA00J07S01COD_XLNET_07,null AA00J10S01CSALA10,null AA00J10S01NOMBRE10,null AA00J10S01SIT10,null AA00J10S01BLOQ10,null AA00J10S01SWDISP10,null AA00J10S01DESC10,null AA00J10S01TLFNO10,null AA00J10S01USUB10,null AA00J10S01PLANTA10,null AA00J10S01DCAPC10,null AA00J10S01DCAPE10,null AA00J10S01NCAP10,null AA00J07S01CDEP07_r,null AA00J07S01DESCC07_r,null AA00J07S01DESCE07_r,null AA00J07S01SIT07_r,null AA00J07S01BLOQ07_r,null AA00J07S01USUB07_r,null AA00J07S01COD_XLNET_07_r,null AA00J10S01CDEP10,null AA00J10S01CEDIF10,null AA00J10S01CREST10,null AA00J10S01CTEXTO10 "
		 * ); query.append("FROM AA00J20S01 t1 ");
		 * query.append(" WHERE SIT20=? AND CSALA20 = ? "); query.append(
		 * " AND ((TO_DATE(TO_CHAR(DHCOM20, :f), :f) >= TO_DATE(TO_CHAR(?, :f), :f) AND TO_DATE(TO_CHAR(DHCOM20, :f), :f) < TO_DATE(TO_CHAR(?, :f), :f)) "
		 * ); query.append(
		 * " 		 OR (TO_DATE(TO_CHAR(DHFIN20, :f), :f) >= TO_DATE(TO_CHAR(?, :f), :f) AND TO_DATE(TO_CHAR(DHFIN20, :f), :f) < TO_DATE(TO_CHAR(?, :f), :f))) "
		 * ); query.append(" ORDER BY DHCOM20,DHFIN20 ");
		 * 
		 * String strQuery = query.toString(); strQuery = strQuery.replace(":f",
		 * aa00jConstantes.FORMATOFECHAHORA_BD);
		 * 
		 * List<Object> params = new ArrayList<Object>();
		 * params.add(aa00jConstantes.SITUACION_ALTA); params.add(csala20);
		 * params.add(fechaHoraIni); params.add(fechaHoraFin);
		 * params.add(fechaHoraIni); params.add(fechaHoraFin);
		 * 
		 * return (List<Aa00j20s01>) this.jdbcTemplate.query(strQuery,
		 * this.rwMap, params.toArray());
		 */

		StringBuilder query = new StringBuilder(
				"SELECT  t1.COD20 COD20,t1.SIT20 SIT20,t1.BLOQ20 BLOQ20,t1.SWFHOR20 SWFHOR20,t1.SWCONF20 SWCONF20,t1.SWMAILE20 SWMAILE20,t1.SWMAILEr20 SWMAILEr20,t1.SWAUTC20 SWAUTC20,t1.ASUN20 ASUN20,t1.DHCOM20 DHCOM20,t1.DHFIN20 DHFIN20,t1.ORGAN20 ORGAN20,t1.RESER20 RESER20,t1.ANOMD20 ANOMD20,t1.TLFNOR20 TLFNOR20,t1.OBS20 OBS20,t1.DNI20 DNI20,t1.IP20 IP20,t1.USUB20 USUB20,t1.TLFNO20 TLFNO20,null AA00J07S01CDEP07,null AA00J07S01DESCC07,null AA00J07S01DESCE07,null AA00J07S01SIT07,null AA00J07S01BLOQ07,null AA00J07S01USUB07,null AA00J07S01COD_XLNET_07,null AA00J10S01CSALA10,null AA00J10S01NOMBRE10,null AA00J10S01SIT10,null AA00J10S01BLOQ10,null AA00J10S01SWDISP10,null AA00J10S01DESC10,null AA00J10S01TLFNO10,null AA00J10S01USUB10,null AA00J10S01PLANTA10,null AA00J10S01DCAPC10,null AA00J10S01DCAPE10,null AA00J10S01NCAP10,null AA00J07S01CDEP07_r,null AA00J07S01DESCC07_r,null AA00J07S01DESCE07_r,null AA00J07S01SIT07_r,null AA00J07S01BLOQ07_r,null AA00J07S01USUB07_r,null AA00J07S01COD_XLNET_07_r,null AA00J10S01CDEP10,null AA00J10S01CEDIF10,null AA00J10S01CREST10,null AA00J10S01CTEXTO10 ");
		query.append("FROM AA00J20S01 t1 ");
		query.append(" WHERE SIT20=? AND CSALA20 = ? ");
		query.append(" AND TO_DATE(TO_CHAR(DHCOM20, :f), :f) < TO_DATE(TO_CHAR(?, :f), :f) ");
		query.append(" AND TO_DATE(TO_CHAR(DHFIN20, :f), :f) > TO_DATE(TO_CHAR(?, :f), :f) ");
		if (codReservaExcluir != null) {
			query.append(" AND COD20 <> ? ");
		}
		query.append(" ORDER BY DHCOM20,DHFIN20 ");

		String strQuery = query.toString();
		strQuery = strQuery.replace(":f", aa00jConstantes.FORMATOFECHAHORA_BD);

		List<Object> params = new ArrayList<Object>();
		params.add(aa00jConstantes.SITUACION_ALTA);
		params.add(csala20);
		params.add(fechaHoraFin);
		params.add(fechaHoraIni);
		if (codReservaExcluir != null) {
			params.add(codReservaExcluir);
		}
		Aa00j20s01DaoImpl.logger.info("SQL " + strQuery);
		Aa00j20s01DaoImpl.logger.info("PARAMs " + params);
		return (List<Aa00j20s01>) this.jdbcTemplate.query(strQuery, this.rwMap,
				params.toArray());
	}

	/**
	 * Devuelve la lista de ocupaciones en las fechas de entrada para la sala de
	 * entrada
	 * 
	 * @param csala20
	 * @param departamento
	 * @param edificio
	 * @param fechas
	 * 
	 * @return
	 */
	public List<Aa00j20s01> obtenerOcupacionesSalaFechas(Long csala20,
			Long departamento, Long edificio, ArrayList<Date> fechas) {
		Aa00j20s01DaoImpl.logger.info("Método obtenerOcupacionesSalaFechas");
		List<Object> params = new ArrayList<Object>();
		params.add(aa00jConstantes.SITUACION_ALTA);

		StringBuilder query = new StringBuilder(
				"SELECT  t1.COD20 COD20,t1.SIT20 SIT20,t1.BLOQ20 BLOQ20,t1.SWFHOR20 SWFHOR20,t1.SWCONF20 SWCONF20,t1.SWMAILE20 SWMAILE20,t1.SWMAILER20 SWMAILER20,t1.SWAUTC20 SWAUTC20,t1.ASUN20 ASUN20,t1.DHCOM20 DHCOM20,t1.DHFIN20 DHFIN20,t1.ORGAN20 ORGAN20,t1.RESER20 RESER20,t1.ANOMD20 ANOMD20,t1.TLFNOR20 TLFNOR20,t1.OBS20 OBS20,t1.DNI20 DNI20,t1.IP20 IP20,t1.USUB20 USUB20,t1.TLFNO20 TLFNO20,null AA00J07S01CDEP07,null AA00J07S01DESCC07,null AA00J07S01DESCE07,null AA00J07S01SIT07,null AA00J07S01BLOQ07,null AA00J07S01USUB07,null AA00J07S01COD_XLNET_07,t2.csala10 AA00J10S01CSALA10,t2.nombre10 AA00J10S01NOMBRE10,t2.sit10 AA00J10S01SIT10,null AA00J10S01BLOQ10,null AA00J10S01SWDISP10,null AA00J10S01DESC10,null AA00J10S01TLFNO10,null AA00J10S01USUB10,null AA00J10S01PLANTA10,null AA00J10S01DCAPC10,null AA00J10S01DCAPE10,null AA00J10S01NCAP10,null AA00J07S01CDEP07_r,null AA00J07S01DESCC07_r,null AA00J07S01DESCE07_r,null AA00J07S01SIT07_r,null AA00J07S01BLOQ07_r,null AA00J07S01USUB07_r,null AA00J07S01COD_XLNET_07_r,null AA00J10S01CDEP10,null AA00J10S01CEDIF10,null AA00J10S01CREST10,null AA00J10S01CTEXTO10 ");
		query.append("FROM AA00J20S01 t1 right join  AA00J10S01 t2 on csala20=csala10");
		query.append(" WHERE SIT20=?");
		if (csala20 != -1) {
			query.append(" AND  CSALA20 = ? ");
			params.add(csala20);

		}
		if (departamento != -1) {
			query.append(" AND  CDEP10 = ? ");
			params.add(departamento);

		}
		if (edificio != -1) {
			query.append(" AND  cedif10 = ? ");
			params.add(edificio);

		}
		if (fechas.size() > 0)
			query.append(" AND ( ");
		boolean init = true;
		for (Date cur : fechas) {
			if (!init)
				query.append(" OR ");
			query.append("  trunc(DHCOM20)= ?");
			init = false;
			params.add(new java.sql.Timestamp(cur.getTime()));
		}
		if (fechas.size() > 0)
			query.append(" ) ");
		query.append(" ORDER BY nombre10,DHCOM20,DHFIN20 ");

		String strQuery = query.toString();
		// strQuery = strQuery.replace(":f",
		// aa00jConstantes.FORMATOFECHAHORA_BD);
		Aa00j20s01DaoImpl.logger.info("SQL " + strQuery);
		Aa00j20s01DaoImpl.logger.info("PARAMs " + params);
		return (List<Aa00j20s01>) this.jdbcTemplate.query(strQuery, this.rwMap,
				params.toArray());
	}

	public boolean actualizarMailsEnviados(Long cod20, int mailsEnviados,
			int mailsEnviadoR) {
		Aa00j20s01DaoImpl.logger.info("Método actualizarMailsEnviados");
		String query = "UPDATE AA00J20S01 SET SWMAILE20=?,SWMAILER20=? WHERE COD20=?";
		Aa00j20s01DaoImpl.logger.info("SQL " + query);
		Aa00j20s01DaoImpl.logger.info("PARAM1 " + mailsEnviados);
		Aa00j20s01DaoImpl.logger.info("PARAM2 " + mailsEnviadoR);
		Aa00j20s01DaoImpl.logger.info("PARAM3 " + cod20);
		return this.jdbcTemplate.update(query, mailsEnviados, mailsEnviadoR,
				cod20) > 0;
	}

	public boolean anular(Long cod20, String usuario) {
		Aa00j20s01DaoImpl.logger.info("Método anular");
		String query = "UPDATE AA00J20S01 SET SIT20=?, USUANUL20=? WHERE COD20=? AND SIT20=?";
		Aa00j20s01DaoImpl.logger.info("SQL " + query);
		Aa00j20s01DaoImpl.logger.info("PARAM1 "
				+ aa00jConstantes.SITUACION_BAJA);
		Aa00j20s01DaoImpl.logger.info("PARAM2 " + usuario);
		Aa00j20s01DaoImpl.logger.info("PARAM3 " + cod20);
		Aa00j20s01DaoImpl.logger.info("PARAM4 "
				+ aa00jConstantes.SITUACION_ALTA);
		return this.jdbcTemplate.update(query, aa00jConstantes.SITUACION_BAJA,
				usuario, cod20, aa00jConstantes.SITUACION_ALTA) > 0;
	}

	public boolean borrar(Long cod20) {
		Aa00j20s01DaoImpl.logger.info("Método borrar");
		String query = "DELETE FROM AA00J20S01 WHERE COD20=?";
		Aa00j20s01DaoImpl.logger.info("SQL " + query);

		Aa00j20s01DaoImpl.logger.info("PARAM1 " + cod20);

		return this.jdbcTemplate.update(query, cod20) > 0;
	}

	public boolean confirmar(Long cod20, String usuario) {
		Aa00j20s01DaoImpl.logger.info("Método confirmar");
		String query = "UPDATE AA00J20S01 SET SWCONF20=?, USUCONF20=? WHERE COD20=? AND SIT20=? AND NVL(SWCONF20,0)=?";
		Aa00j20s01DaoImpl.logger.info("SQL " + query);
		Aa00j20s01DaoImpl.logger.info("PARAM1 " + usuario);
		Aa00j20s01DaoImpl.logger.info("PARAM2 " + cod20);
		Aa00j20s01DaoImpl.logger.info("PARAM3 "
				+ aa00jConstantes.SITUACION_ALTA);
		return this.jdbcTemplate.update(query, 1, usuario, cod20,
				aa00jConstantes.SITUACION_ALTA, 0) > 0;
	}

	public boolean confirmarSiQuinceDiasOMenos(Long cod20, String usuario) {
		Aa00j20s01DaoImpl.logger.info("Método confirmar");
		String query = "UPDATE AA00J20S01 SET SWCONF20=?, USUCONF20=? WHERE COD20=? AND SIT20=? AND NVL(SWCONF20,0)=? AND TRUNC(DHCOM20) <= TRUNC(SYSDATE + 15)";
		Aa00j20s01DaoImpl.logger.info("SQL " + query);
		Aa00j20s01DaoImpl.logger.info("PARAM1 " + usuario);
		Aa00j20s01DaoImpl.logger.info("PARAM2 " + cod20);
		Aa00j20s01DaoImpl.logger.info("PARAM3 "
				+ aa00jConstantes.SITUACION_ALTA);
		return this.jdbcTemplate.update(query, 1, usuario, cod20,
				aa00jConstantes.SITUACION_ALTA, 0) > 0;
	}

	public boolean actualizarDatos(Long cod20, String obs20, String asun20,
			Date dhcom20, Date dhfin20, Integer swfhor20, Integer swconf20,
			Integer swautc20, String tlfno20) {
		Aa00j20s01DaoImpl.logger.info("Método actualizarDatos");
		String query = "UPDATE AA00J20S01 SET OBS20=?, ASUN20=?, DHCOM20=?, DHFIN20=?, SWFHOR20=?, SWCONF20=?, SWAUTC20=?, TLFNO20=? WHERE COD20=?";

		List<Object> params = new ArrayList<Object>();
		params.add(obs20);
		params.add(asun20);
		params.add(new java.sql.Timestamp(dhcom20.getTime()));
		params.add(new java.sql.Timestamp(dhfin20.getTime()));
		params.add(swfhor20);
		params.add(swconf20);
		params.add(swautc20);
		params.add(tlfno20);
		params.add(cod20);
		Aa00j20s01DaoImpl.logger.info("SQL " + query);
		Aa00j20s01DaoImpl.logger.info("PARAMS " + params);

		return this.jdbcTemplate.update(query, params.toArray()) > 0;
	}

	public void removeAa00j21s01Reserva(Long cres21) {
		Aa00j20s01DaoImpl.logger.info("Método removeAa00j21s01Reserva");
		String query = "DELETE FROM AA00J21S01 WHERE CRES21=?";
		Aa00j20s01DaoImpl.logger.info("SQL " + query);
		Aa00j20s01DaoImpl.logger.info("PARAMS " + cres21);
		this.jdbcTemplate.update(query, cres21);
	}

	/**
	 * Devuelve el numero reservas para una sala sin confirmar y en alta para el
	 * usuario (si el usuario es tecnico, se devuelven todas)
	 * 
	 * @param dias
	 * @param sala
	 * @param departamento
	 * @param edificio
	 * @return
	 */
	public Long obtenerAnuladasNum(ArrayList<Date> dias, Integer sala,
			Integer departamento, Integer edificio) {
		Aa00j20s01DaoImpl.logger.info("Método obtenerAnuladasNum");
		List<Object> params = new ArrayList<Object>();
		StringBuffer sql = new StringBuffer();
		sql.append(" select count(*) ");
		sql.append(" from aa00j10S01 inner join aa00j20S01 on csala20=csala10 inner join aa00j03S01 on cedif10=cedif03 where SIT20='B'  ");
		aa00jPersonaSesion ps = new aa00jSeguridad().getUsuario();
		if (!ps.isEsAdminDepto() && !ps.isEsTecnico() && !ps.isEsAdmin()) {
			String usuario = ps.getPersonaXLNET().getCodigo();
			// sql.append("	AND (reser20=? or ANOMD20=?)");
			sql.append("	AND (organ20=? or DNI20=?)");
			params.add(usuario);
			params.add(usuario);
		}
		if (sala != null && sala != -1) {// se busca por codigo de sala
			sql.append(" and csala10 = ?");
			params.add(sala.intValue());
		} else {
			if (edificio != -1 || departamento != -1) {
				if (edificio != null && edificio != -1) {
					sql.append(" AND CDEP10 is null");// Está en modo no
														// departamentales,
														// mostrar
														// solo
														// las que tienen
														// codsala
					if (edificio != -1) {
						sql.append(" and csitio03 = ?");
						params.add(edificio.intValue());
					}
				}
				if (departamento != null && departamento != -1) {
					sql.append(" AND CDEP10= ?");// Está en modo departamentales
					params.add(departamento.intValue());
				} else {
					sql.append(" AND CDEP10 IS  NULL");// está en modo no
														// departamentales

				}
			} else {// solamente tiene día--> para usuarios no administradores
					// buscar los de su departamento o los que no tienen
					// departamento
				if (!ps.isEsAdminDepto() && !ps.isEsTecnico()
						&& !ps.isEsAdmin()) {
					sql.append(" AND (CDEP10=? OR CDEP10 IS NULL)");
					params.add(Long.parseLong(ps.getDepartamentoInterno()));

				}

			}

		}
		boolean primero = true;
		if (dias.size() > 0) {
			sql.append(" and (");

			for (Date dia : dias) {
				if (!primero) {
					sql.append(" OR ");
				}
				sql.append("  ? =TRUNC(dhcom20)");

				primero = false;

				params.add(new java.sql.Timestamp(dia.getTime()));
			}
			sql.append(" ) ");
		} else {
			sql.append(" and  to_char(SYSDATE,'yyyy')=to_char(dhcom20,'yyyy')");
		}

		Aa00j20s01DaoImpl.logger.info("SQL " + sql);
		Aa00j20s01DaoImpl.logger.info("PARAMS " + params);
		return this.jdbcTemplate.queryForLong(sql.toString(), params.toArray());

	}

	/**
	 * Devuelve una lista de reservas para una sala sin confirmar y en alta para
	 * el usuario (si el usuario es tecnico, se devuelven todas)
	 * 
	 * @param dias
	 * @param sala
	 * @param departamento
	 * @param edificio
	 * @return
	 */
	public ArrayList<Aa00j20s01> obtenerAnuladas(ArrayList<Date> dias,
			Integer sala, Integer departamento, Integer edificio,
			JQGridRequestDto jqGridRequestDto) {
		Aa00j20s01DaoImpl.logger.info("Método obtenerAnuladas");
		List<Object> params = new ArrayList<Object>();
		StringBuilder sql = new StringBuilder();
		sql.append(" select cod20,csala10 as Aa00j10s01CSALA10, Nombre10 as Aa00j10s01NOMBRE10 ,asun20,dhcom20,DHFIN20,anomd20, ");
		sql.append("   to_char(dhcom20,'HH24:mi') as horaIni,");
		sql.append("  to_char(DHFIN20,'HH24:mi') as horaFin,email20,emailr20");
		sql.append(" from aa00j10S01 inner join aa00j20S01 on csala20=csala10 inner join aa00j03S01 on cedif10=cedif03 where SIT20='B'  ");
		aa00jPersonaSesion ps = new aa00jSeguridad().getUsuario();
		if (!ps.isEsAdminDepto() && !ps.isEsTecnico() && !ps.isEsAdmin()) {
			String usuario = ps.getPersonaXLNET().getCodigo();
			// sql.append("	AND (reser20=? or ANOMD20=?)");
			sql.append("	AND (organ20=? or DNI20=?)");
			params.add(usuario);
			params.add(usuario);
		}
		if (sala != null && sala != -1) {// se busca por codigo de sala
			sql.append(" and csala10 = ?");
			params.add(sala.intValue());
		} else {
			if (edificio != -1 || departamento != -1) {
				if (edificio != null && edificio != -1) {
					sql.append(" AND CDEP10 is null");// Está en modo no
														// departamentales,
														// mostrar
														// solo
														// las que tienen
														// codsala
					if (edificio != -1) {
						sql.append(" and csitio03 = ?");
						params.add(edificio.intValue());
					}
				}
				if (departamento != null && departamento != -1) {
					sql.append(" AND CDEP10= ?");// Está en modo departamentales
					params.add(departamento.intValue());
				} else {
					sql.append(" AND CDEP10 IS  NULL");// está en modo no
														// departamentales

				}
			} else {// solamente tiene día--> para usuarios no administradores
					// buscar los de su departamento o los que no tienen
					// departamento
				if (!ps.isEsAdminDepto() && !ps.isEsTecnico()
						&& !ps.isEsAdmin()) {
					sql.append(" AND (CDEP10=? OR CDEP10 IS NULL)");
					params.add(Long.parseLong(ps.getDepartamentoInterno()));

				}

			}

		}
		boolean primero = true;
		if (dias.size() > 0) {
			sql.append(" and (");

			for (Date dia : dias) {
				if (!primero) {
					sql.append(" OR ");
				}
				sql.append("  ? =TRUNC(dhcom20)");

				primero = false;

				params.add(new java.sql.Timestamp(dia.getTime()));
			}
			sql.append(" ) ");
		} else {
			sql.append(" and  to_char(SYSDATE,'yyyy')=to_char(dhcom20,'yyyy')");
		}
		if (jqGridRequestDto != null) {
			sql = JQGridManager.getPaginationQuery(jqGridRequestDto, sql);
		}
		Aa00j20s01DaoImpl.logger.info("SQL " + sql);
		Aa00j20s01DaoImpl.logger.info("PARAMS " + params);
		return (ArrayList<Aa00j20s01>) this.jdbcTemplate.query(sql.toString(),
				this.rwMap2, params.toArray());

	}

	/**
	 * Marca el campo mensaje como enviado en la reserva
	 * 
	 * @param cod20
	 * @return
	 */
	public boolean marcarEnviado(Long cod20) {
		Aa00j20s01DaoImpl.logger.info("Método marcarEnviado");
		Aa00j20s01DaoImpl.logger.info("Marcando como enviado " + cod20);
		String query = "UPDATE AA00J20S01 SET SWMAILE20=1,SWMAILER20=1 WHERE COD20=?";
		Aa00j20s01DaoImpl.logger.info("sql " + query);
		List<Object> params = new ArrayList<Object>();

		params.add(cod20);
		Aa00j20s01DaoImpl.logger.info("SQL " + query);
		Aa00j20s01DaoImpl.logger.info("PARAMS " + params);
		return this.jdbcTemplate.update(query, params.toArray()) > 0;
	}

	/**
	 * Devuelve una lista de reservas para una sala que hay que anular(sin
	 * confirmar con fecha anterior o igual a hoy
	 * 
	 * 
	 * 
	 * 
	 * @return
	 */
	public ArrayList<Aa00j20s01> obtenerOcupacionesAanular() {
		Aa00j20s01DaoImpl.logger.info("Método obtenerOcupacionesAanular");
		Aa00j20s01DaoImpl.logger.info("obtenerOcupacionesAanular ");

		StringBuilder sql = new StringBuilder();
		sql.append(" select cod20,csala10 as Aa00j10s01CSALA10, Nombre10 as Aa00j10s01NOMBRE10 ,asun20,dhcom20,DHFIN20,anomd20, ");
		sql.append("   to_char(dhcom20,'HH24:mi') as horaIni,");
		sql.append("  to_char(DHFIN20,'HH24:mi') as horaFin,email20,emailr20");
		sql.append(" from aa00j10S01 inner join aa00j20S01 on csala20=csala10 inner join aa00j03S01 on cedif10=cedif03 where  SWCONF20 =0	AND SIT20='A'	AND TRUNC(dhcom20)<=TRUNC(SYSDATE) ");
		Aa00j20s01DaoImpl.logger.info("sql " + sql.toString());

		return (ArrayList<Aa00j20s01>) this.jdbcTemplate.query(sql.toString(),
				this.rwMap2);

	}

	/**
	 * Dar de baja reservas sin confirmar con fecha menor o igual a la actual
	 * que no estén confirmadas y estén de alta
	 * 
	 * @return
	 */
	public int darDeBajaAntiguas() {
		Aa00j20s01DaoImpl.logger.info("Método darDeBajaAntiguas");
		Aa00j20s01DaoImpl.logger.info("Dar de baja antiguas ");
		String query = "update  aa00j20S01 	set SIT20='B'	, USUANUL20='Sistema' WHERE SWCONF20     =0	AND SIT20          ='A'		AND TRUNC(dhcom20)<=TRUNC(SYSDATE)";
		Aa00j20s01DaoImpl.logger.info("sql " + query);
		int count = this.jdbcTemplate.update(query);
		Aa00j20s01DaoImpl.logger
				.info("Registros dados de baja automáticamente " + count);
		return count;
	}

	/**
	 * Devuelve una lista de reservas que tengan alguno de los estados de mail
	 * sin enviar
	 * 
	 * @return
	 */

	public ArrayList<Aa00j20s01> obtenerReservasSinEnviar() {

		StringBuilder query = new StringBuilder(
				"SELECT  t1.COD20 COD20,t1.SIT20 SIT20,t1.BLOQ20 BLOQ20,t1.SWFHOR20 SWFHOR20,t1.SWCONF20 SWCONF20,t1.SWMAILE20 SWMAILE20,t1.SWMAILER20 SWMAILER20,t1.EMAIL20 EMAIL20,t1.EMAILR20 EMAILR20,t1.SWAUTC20 SWAUTC20,t1.ASUN20 ASUN20,t1.DHCOM20 DHCOM20,t1.DHFIN20 DHFIN20,t1.ORGAN20 ORGAN20,t1.RESER20 RESER20,t1.ANOMD20 ANOMD20,t1.TLFNOR20 TLFNOR20,t1.OBS20 OBS20,t1.DNI20 DNI20,t1.IP20 IP20,t1.USUB20 USUB20,t1.TLFNO20 TLFNO20,null AA00J07S01CDEP07,null AA00J07S01DESCC07,null AA00J07S01DESCE07,null AA00J07S01SIT07,null AA00J07S01BLOQ07,null AA00J07S01USUB07,null AA00J07S01COD_XLNET_07,t2.CSALA10 AA00J10S01CSALA10,t2.NOMBRE10 AA00J10S01NOMBRE10,null AA00J10S01SIT10,null AA00J10S01BLOQ10,null AA00J10S01SWDISP10,null AA00J10S01DESC10,null AA00J10S01TLFNO10,null AA00J10S01USUB10,null AA00J10S01PLANTA10,null AA00J10S01DCAPC10,null AA00J10S01DCAPE10,null AA00J10S01NCAP10,null AA00J07S01CDEP07_r,null AA00J07S01DESCC07_r,null AA00J07S01DESCE07_r,null AA00J07S01SIT07_r,null AA00J07S01BLOQ07_r,null AA00J07S01USUB07_r,null AA00J07S01COD_XLNET_07_r,null AA00J10S01CDEP10,null AA00J10S01CEDIF10,null AA00J10S01CREST10,null AA00J10S01CTEXTO10 ");
		query.append("FROM AA00J20S01 t1  inner join AA00J10S01 t2 on t1.csala20=t2.csala10  ");
		query.append("  where trunc(DHCOM20)>trunc(SYSDATE)   and SIT20='A'   and (swmaile20=0 or swmailer20=0) ");
		Aa00j20s01DaoImpl.logger.info("Sql reservas sin mail enviado "
				+ query.toString());
		return (ArrayList<Aa00j20s01>) this.jdbcTemplate.query(
				query.toString(), this.rwMap);
	}

}