package com.ejie.aa00j.dao;

import com.ejie.aa00j.model.Aa00j12s01;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.dto.TableRowDto;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import com.ejie.aa00j.model.Aa00j20s01;

/**
 * Aa00j20s01Dao generated by UDA, 16-oct-2013 13:02:12.
 * 
 * @author UDA
 */

public interface Aa00j20s01Dao {

	/**
	 * Inserts a single row in the Aa00j20s01 table.
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01
	 * @return Aa00j20s01
	 */
	Aa00j20s01 add(Aa00j20s01 aa00j20s01);

	/**
	 * Updates a single row in the Aa00j20s01 table.
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01
	 * @return Aa00j20s01
	 */
	Aa00j20s01 update(Aa00j20s01 aa00j20s01);

	/**
	 * Finds a single row in the Aa00j20s01 table.
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01
	 * @return Aa00j20s01
	 */
	Aa00j20s01 find(Aa00j20s01 aa00j20s01);

	/**
	 * Removes a single row in the Aa00j20s01 table.
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01
	 */
	void remove(Aa00j20s01 aa00j20s01);

	/**
	 * Finds a List of rows in the Aa00j20s01 table.
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List
	 */
	List<Aa00j20s01> findAll(Aa00j20s01 aa00j20s01,
			JQGridRequestDto jqGridRequestDto, String codDepto,
			String codUsuario);

	/**
	 * Finds rows in the Aa00j20s01 table using like.
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Aa00j20s01> findAllLike(Aa00j20s01 aa00j20s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith,
			String codDepto, String codUsuario, Locale locale);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter in the Aa00j20s01 table.
	 * 
	 * @param filterAa00j20s01
	 *            Aa00j20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(Aa00j20s01 filterAa00j20s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Counts rows in the Aa00j20s01 table using like.
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Aa00j20s01 aa00j20s01, Boolean startsWith,
			String codDepto, String codUsuario, Locale local);

	/**
	 * Counts rows in the Aa00j20s01 table.
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01
	 * @return Long
	 */
	Long findAllCount(Aa00j20s01 aa00j20s01, String codDepto, String codUsuario);

	/**
	 * Reorder selection.
	 * 
	 * @param filterAa00j20s01
	 *            Aa00j20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j20s01>>
	 */
	List<TableRowDto<Aa00j20s01>> reorderSelection(Aa00j20s01 filterAa00j20s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith,
			String codDepto, String codUsuario);

	/**
	 * Searches in the Usuario table.
	 * 
	 * @param filterAa00j20s01
	 *            Aa00j20s01
	 * @param searchAa00j20s01
	 *            Aa00j20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j20s01>>
	 */
	List<TableRowDto<Aa00j20s01>> search(Aa00j20s01 filterAa00j20s01,
			Aa00j20s01 searchAa00j20s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith, String codDepto, String codUsuario);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Filter in the hierarchical Aa00j20s01 table.
	 * 
	 * @param filterAa00j20s01
	 *            Aa00j20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Aa00j20s01>>
	 */
	List<JerarquiaDto<Aa00j20s01>> findAllLikeJerarquia(
			Aa00j20s01 filterAa00j20s01, JQGridRequestDto jqGridRequestDto);

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAa00j20s01
	 *            Aa00j20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	Long findAllLikeCountJerarquia(Aa00j20s01 filterAa00j20s01,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAa00j20s01
	 *            Aa00j20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Aa00j20s01>>
	 */
	List<TableRowDto<Aa00j20s01>> findAllChild(Aa00j20s01 filterAa00j20s01,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Inserts a single row in the Aa00j21s01 table.
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01
	 * @return Aa00j20s01
	 */
	Aa00j20s01 addAa00j21s01(Aa00j20s01 aa00j20s01);

	/**
	 * Deletes a single row in the Aa00j21s01 table.
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01
	 * @return
	 */
	void removeAa00j21s01(Aa00j20s01 aa00j20s01);

	/**
	 * Find a single row in the findAa00j21s01 Many To Many relationship.
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01
	 * @param aa00j12s01
	 *            Aa00j12s01
	 * @param pagination
	 *            Pagination
	 * @return Aa00j20s01
	 */
	Aa00j20s01 findAa00j21s01(Aa00j20s01 aa00j20s01, Aa00j12s01 aa00j12s01,
			Pagination pagination);

	/**
	 * Counts rows rows in the Aa00j21s01 table.
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01
	 * @param aa00j12s01
	 *            Aa00j12s01
	 * @return Long
	 */
	Long findAa00j21s01Count(Aa00j20s01 aa00j20s01, Aa00j12s01 aa00j12s01);

	boolean existeDepartamento(Long cdep20);

	boolean existeSala(Long csala20);

	boolean existeSalaDisponible(Long csala20, Date fechaHoraIni,
			Date fechaHoraFin, Long codReservaExcluir);

	public List<Aa00j20s01> obtenerOcupacionesFechas(Long csala20,
			Date fechaHoraIni, Date fechaHoraFin, Long codReservaExcluir);

	boolean actualizarMailsEnviados(Long cod20, int mailsEnviados,
			int mailsEnviadoR);

	boolean anular(Long cod20, String usuario);

	boolean borrar(Long cod20);

	boolean confirmar(Long cod20, String usuario);

	boolean confirmarSiQuinceDiasOMenos(Long cod20, String usuario);

	boolean actualizarDatos(Long cod20, String obs20, String asun20,
			Date dhcom20, Date dhfin20, Integer swfhor20, Integer swconf20,
			Integer swautc20, String tlfno20);

	void removeAa00j21s01Reserva(Long cres21);

	/**
	 * Devuelve la lista de ocupaciones en las fechas de entrada para la sala de
	 * entrada
	 * 
	 * @param csala20
	 * @param departamento
	 * @param edificio
	 * @param fechas
	 * 
	 * @return
	 */
	public List<Aa00j20s01> obtenerOcupacionesSalaFechas(Long csala20,
			Long departamento, Long edificio, ArrayList<Date> fechas);

	/**
	 * Devuelve una lista de reservas para una sala sin confirmar y en alta para
	 * el usuario (si el usuario es tecnico, se devuelven todas)
	 * 
	 * @param dias
	 * @param sala
	 * @param departamento
	 * @param edificio
	 * @return
	 */
	public ArrayList<Aa00j20s01> obtenerOcupacionesSinConfirmar(
			ArrayList<Date> dias, Integer sala, Integer departamento,
			Integer edificio, JQGridRequestDto jqGridRequestDto);

	/**
	 * Devuelve el numero reservas para una sala sin confirmar y en alta para el
	 * usuario (si el usuario es tecnico, se devuelven todas)
	 * 
	 * @param dias
	 * @param sala
	 * @param departamento
	 * @param edificio
	 * @return
	 */
	public Long obtenerOcupacionesSinConfirmarNum(ArrayList<Date> dias,
			Integer sala, Integer departamento, Integer edificio);

	/**
	 * Devuelve una lista de reservas anuladas para el usuario (si el usuario es
	 * tecnico, se devuelven todas)
	 * 
	 * @param dias
	 * @param sala
	 * @param departamento
	 * @param edificio
	 * @return
	 */
	public ArrayList<Aa00j20s01> obtenerAnuladas(ArrayList<Date> dias,
			Integer sala, Integer departamento, Integer edificio,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Devuelve el numero reservas anuladas para para el usuario (si el usuario
	 * es tecnico, se devuelven todas)
	 * 
	 * @param dias
	 * @param sala
	 * @param departamento
	 * @param edificio
	 * @return
	 */
	public Long obtenerAnuladasNum(ArrayList<Date> dias, Integer sala,
			Integer departamento, Integer edificio);

	/**
	 * Devuelve una lista de reservas para una sala sin confirmar y en alta para
	 * 
	 * 
	 * @param dias
	 * 
	 * @return
	 */
	public ArrayList<Aa00j20s01> obtenerOcupacionesSinConfirmar();

	/**
	 * Marca el campo mensaje como enviado en la reserva
	 * 
	 * @param cod20
	 * @return
	 */
	public boolean marcarEnviado(Long cod20);

	/**
	 * Dar de baja reservas sin confirmar con fecha menor o igual a la actual
	 * que no estén confirmadas y estén de alta
	 * 
	 * @return
	 */
	public int darDeBajaAntiguas();

	/**
	 * Devuelve una lista de reservas para una sala que hay que anular(sin
	 * confirmar con fecha anterior o igual a hoy
	 * 
	 * 
	 * 
	 * 
	 * @return
	 */
	public ArrayList<Aa00j20s01> obtenerOcupacionesAanular();

	/**
	 * Devuelve una lista de reservas que tengan alguno de los estados de mail
	 * sin enviar
	 * 
	 * @return
	 */

	public ArrayList<Aa00j20s01> obtenerReservasSinEnviar();
}