package com.ejie.aa00j.dao;

import java.sql.PreparedStatement;
import java.sql.SQLException;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class Aa00j17s01DaoImpl implements Aa00j17s01Dao {
	private JdbcTemplate jdbcTemplate;
	private static final Logger logger = LoggerFactory
			.getLogger(Aa00j17s01DaoImpl.class);

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Borra todos los elementos del listado
	 * 
	 * @param listado
	 * @return
	 */
	public int deleteAll(int listado) {
		Aa00j17s01DaoImpl.logger.info("Método deleteAll");
		String query = "DELETE FROM AA00J17S01 WHERE TIPO17=?";
		Aa00j17s01DaoImpl.logger.info("SQL " + query);
		Aa00j17s01DaoImpl.logger.info("PARAM1" + listado);
		return this.jdbcTemplate.update(query, listado);
	}

	/**
	 * Añade las salas con los ids al listado
	 * 
	 * @param listado
	 * @param ids
	 * @return
	 */

	public int[] addElements(final int listado, final int[] ids) {
		Aa00j17s01DaoImpl.logger.info("Método addElements");
		String sql = "INSERT INTO AA00J17S01 (TIPO17,CSALA17,ORDEN17) VALUES(?,?,?)";
		Aa00j17s01DaoImpl.logger.info("SQL " + sql);
		Aa00j17s01DaoImpl.logger.info("params " + listado);
		Aa00j17s01DaoImpl.logger.info(ids.toString());
		return this.jdbcTemplate.batchUpdate(sql,
				new BatchPreparedStatementSetter() {
					public void setValues(PreparedStatement ps, int i)
							throws SQLException {

						ps.setInt(1, listado);
						ps.setInt(2, ids[i]);
						ps.setInt(3, i);
					}

					public int getBatchSize() {
						return ids.length;
					}
				});

	}
}
