package com.ejie.aa00j.dao;

import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa00j.model.Aa00j16s00;

/**
 * Aa00j16s00DaoImpl generated by UDA, 04-jun-2014 11:18:46.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class Aa00j16s00DaoImpl implements Aa00j16s00Dao {
	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Aa00j16s00> rwMap = new RowMapper<Aa00j16s00>() {
		public Aa00j16s00 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa00j16s00(resultSet.getBigDecimal("ID16"),
					resultSet.getString("NOMC16"),
					resultSet.getString("NOME16"),
					resultSet.getString("TITC16"),
					resultSet.getString("TITE16"),
					resultSet.getBigDecimal("TIPO16"),
					resultSet.getString("SIT16"),
					resultSet.getString("USUB16"), resultSet.getInt("BLOQ16"));
		}
	};

	private RowMapper<Aa00j16s00> rwMapPK = new RowMapper<Aa00j16s00>() {
		public Aa00j16s00 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa00j16s00(resultSet.getBigDecimal("ID16"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Aa00j16s00>> rwMapJerarquia = new RowMapper<JerarquiaDto<Aa00j16s00>>() {
		public JerarquiaDto<Aa00j16s00> mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Aa00j16s00 aa00j16s00 = new Aa00j16s00(
					resultSet.getBigDecimal("ID16"),
					resultSet.getString("NOMC16"),
					resultSet.getString("NOME16"),
					resultSet.getString("TITC16"),
					resultSet.getString("TITE16"),
					resultSet.getBigDecimal("TIPO16"),
					resultSet.getString("SIT16"),
					resultSet.getString("USUB16"), resultSet.getInt("BLOQ16"));

			JerarquiaDto<Aa00j16s00> jerarquia = new JerarquiaDto<Aa00j16s00>();
			jerarquia.setModel(aa00j16s00);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet
					.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet
					.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Aa00j16s00 table.
	 * 
	 * @param aa00j16s00
	 *            Aa00j16s00
	 * @return Aa00j16s00
	 */
	public Aa00j16s00 add(Aa00j16s00 aa00j16s00) {
		final String queryUltimoId = "(SELECT NVL(MAX(ID16), 0) + 1 FROM AA00J16S01)";
		String query = "INSERT INTO AA00J16S01 (ID16, NOMC16, NOME16,TITC16, TITE16, TIPO16, SIT16, USUB16, BLOQ16) VALUES ("
				+ queryUltimoId + ",?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, aa00j16s00.getNomc16(),
				aa00j16s00.getNome16(), aa00j16s00.getTitc16(),
				aa00j16s00.getTite16(), aa00j16s00.getTipo16(),
				aa00j16s00.getSit16(), aa00j16s00.getUsub16(), 0);
		return aa00j16s00;
	}

	/**
	 * Updates a single row in the Aa00j16s00 table.
	 * 
	 * @param aa00j16s00
	 *            Aa00j16s00
	 * @return Aa00j16s00
	 */
	public Aa00j16s00 update(Aa00j16s00 aa00j16s00) {
		String query = "UPDATE AA00J16S01 SET NOMC16=?, NOME16=?, TITC16=?, TITE16=?,TIPO16=?, SIT16=? WHERE ID16=?";
		this.jdbcTemplate.update(query, aa00j16s00.getNomc16(),
				aa00j16s00.getNome16(), aa00j16s00.getTitc16(),
				aa00j16s00.getTite16(), aa00j16s00.getTipo16(),
				aa00j16s00.getSit16(), aa00j16s00.getId16());
		return aa00j16s00;
	}

	/**
	 * Finds a single row in the Aa00j16s00 table.
	 * 
	 * @param aa00j16s00
	 *            Aa00j16s00
	 * @return Aa00j16s00
	 */
	@Transactional(readOnly = true)
	public Aa00j16s00 find(Aa00j16s00 aa00j16s00) {
		String query = "SELECT t1.ID16 ID16, t1.NOMC16 NOMC16, t1.NOME16 NOME16, t1.TITC16 TITC16, t1.TITE16 TITE16, t1.TIPO16 TIPO16, t1.SIT16 SIT16, t1.USUB16 USUB16, t1.BLOQ16 BLOQ16 FROM AA00J16S01 t1  WHERE t1.ID16 = ?  ";

		List<Aa00j16s00> aa00j16s00List = this.jdbcTemplate.query(query,
				this.rwMap, aa00j16s00.getId16());
		return (Aa00j16s00) DataAccessUtils.uniqueResult(aa00j16s00List);
	}

	/**
	 * Removes a single row in the Aa00j16s00 table.
	 * 
	 * @param aa00j16s00
	 *            Aa00j16s00
	 * @return
	 */
	public void remove(Aa00j16s00 aa00j16s00) {
		String query = "DELETE FROM AA00J16S01 WHERE ID16=?";
		this.jdbcTemplate.update(query, aa00j16s00.getId16());
	}

	/**
	 * Finds a list of rows in the Aa00j16s00 table.
	 * 
	 * @param aa00j16s00
	 *            Aa00j16s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa00j16s00>
	 */
	@Transactional(readOnly = true)
	public List<Aa00j16s00> findAll(Aa00j16s00 aa00j16s00,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID16 ID16,t1.NOMC16 NOMC16,t1.NOME16 NOME16, t1.TITC16 TITC16, t1.TITE16 TITE16,t1.TIPO16 TIPO16,t1.SIT16 SIT16,t1.USUB16 USUB16,t1.BLOQ16 BLOQ16 ");
		query.append("FROM AA00J16S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa00j16s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Aa00j16s00>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Aa00j16s00 table using like.
	 * 
	 * @param aa00j16s00
	 *            Aa00j16s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa00j16s00>
	 */
	@Transactional(readOnly = true)
	public List<Aa00j16s00> findAllLike(Aa00j16s00 aa00j16s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID16 ID16,t1.NOMC16 NOMC16,t1.NOME16 NOME16, t1.TITC16 TITC16, t1.TITE16 TITE16,t1.TIPO16 TIPO16,t1.SIT16 SIT16,t1.USUB16 USUB16,t1.BLOQ16 BLOQ16 ");
		query.append("FROM AA00J16S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa00j16s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Aa00j16s00>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Aa00j16s00 table.
	 * 
	 * @param aa00j16s00
	 *            Aa00j16s00
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Aa00j16s00 aa00j16s00) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA00J16S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa00j16s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Aa00j16s00 table using like.
	 * 
	 * @param aa00j16s00
	 *            Aa00j16s00
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Aa00j16s00 aa00j16s00, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA00J16S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa00j16s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Aa00j16s00 selected for rup_table
	 * 
	 * @param aa00j16s00
	 *            Aa00j16s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j16s00>>
	 */
	@Override
	public List<TableRowDto<Aa00j16s00>> reorderSelection(
			Aa00j16s00 aa00j16s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID16 ID16,t1.NOMC16 NOMC16,t1.NOME16 NOME16, t1.TITC16 TITC16, t1.TITE16 TITE16,t1.TIPO16 TIPO16,t1.SIT16 SIT16,t1.USUB16 USUB16,t1.BLOQ16 BLOQ16 ");
		// FROM
		query.append("FROM AA00J16S01 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa00j16s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, Aa00j16s00.class, filterParamList,
				"ID16");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa00j16s00>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * @param filterParams
	 *            Aa00j16s00
	 * @param searchParams
	 *            Aa00j16s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j16s00>>
	 */
	@Override
	public List<TableRowDto<Aa00j16s00>> search(Aa00j16s00 filterParams,
			Aa00j16s00 searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID16 ID16,t1.NOMC16 NOMC16,t1.NOME16 NOME16, t1.TITC16 TITC16, t1.TITE16 TITE16,t1.TIPO16 TIPO16,t1.SIT16 SIT16,t1.USUB16 USUB16,t1.BLOQ16 BLOQ16 ");
		// FROM
		query.append("FROM AA00J16S01 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, Aa00j16s00.class, filterParamList,
				searchSQL, searchParamList, from_alias, "ID16");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa00j16s00>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 * 
	 * @param filteraa00j16s00
	 *            Aa00j16s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Aa00j16s00 filteraa00j16s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID16 ID16,t1.NOMC16 NOMC16,t1.NOME16 NOME16, t1.TITC16 TITC16, t1.TITE16 TITE16,t1.TIPO16 TIPO16,t1.SIT16 SIT16,t1.USUB16 USUB16,t1.BLOQ16 BLOQ16 ");
		// FROM
		query.append("FROM AA00J16S01 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filteraa00j16s00,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto, Aa00j16s00.class,
						query, params, "ID16");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical Aa00j16s00 table.
	 * 
	 * @param filterAa00j16s00
	 *            Aa00j16s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Aa00j16s00>>
	 */
	@Override
	public List<JerarquiaDto<Aa00j16s00>> findAllLikeJerarquia(
			Aa00j16s00 filterAa00j16s00, JQGridRequestDto jqGridRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID16 ID16,t1.NOMC16 NOMC16,t1.NOME16 NOME16,t1.TIPO16 TIPO16,t1.SIT16 SIT16,t1.USUB16 USUB16,t1.BLOQ16 BLOQ16 ");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA00J16S01 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA00J16S01");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa00j16s00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
				mapaWhere, "ID16", "ID_PADRE", "NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAa00j16s00
	 *            Aa00j16s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Aa00j16s00 filterAa00j16s00,
			JQGridRequestDto jqGridRequestDto) {
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA00J16S01 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA00J16S01");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa00j16s00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(
				jqGridRequestDto, mapaWhere, "ID16", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAa00j16s00
	 *            Aa00j16s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Aa00j16s00>>
	 */
	@Override
	public List<TableRowDto<Aa00j16s00>> findAllChild(
			Aa00j16s00 filterAa00j16s00, JQGridRequestDto jqGridRequestDto) {

		// FROM
		// StringBuilder from = new StringBuilder("FROM AA00J16S01 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA00J16S01");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa00j16s00, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(
				jqGridRequestDto, mapaWhere, "ID16", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.query(query.toString(),
				new RowNumResultSetExtractor<Aa00j16s00>(this.rwMapPK, "ID16"),
				params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa00j16s00 entity
	 * 
	 * @param aa00j16s00
	 *            Aa00j16s00 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Aa00j16s00 aa00j16s00) {

		StringBuilder where = new StringBuilder(
				Aa00j16s00DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa00j16s00 != null && aa00j16s00.getId16() != null) {
			where.append(" AND t1.ID16 = ?");
			params.add(aa00j16s00.getId16());
		}
		if (aa00j16s00 != null && aa00j16s00.getNomc16() != null) {
			where.append(" AND t1.NOMC16 = ?");
			params.add(aa00j16s00.getNomc16());
		}
		if (aa00j16s00 != null && aa00j16s00.getNome16() != null) {
			where.append(" AND t1.NOME16 = ?");
			params.add(aa00j16s00.getNome16());
		}
		if (aa00j16s00 != null && aa00j16s00.getTitc16() != null) {
			where.append(" AND t1.TITC16 = ?");
			params.add(aa00j16s00.getTitc16());
		}
		if (aa00j16s00 != null && aa00j16s00.getTite16() != null) {
			where.append(" AND t1.TITE16 = ?");
			params.add(aa00j16s00.getTite16());
		}
		if (aa00j16s00 != null && aa00j16s00.getTipo16() != null) {
			where.append(" AND t1.TIPO16 = ?");
			params.add(aa00j16s00.getTipo16());
		}
		if (aa00j16s00 != null && aa00j16s00.getSit16() != null) {
			where.append(" AND t1.SIT16 = ?");
			params.add(aa00j16s00.getSit16());
		}
		if (aa00j16s00 != null && aa00j16s00.getUsub16() != null) {
			where.append(" AND t1.USUB16 = ?");
			params.add(aa00j16s00.getUsub16());
		}
		if (aa00j16s00 != null && aa00j16s00.getBloq16() != null) {
			where.append(" AND t1.BLOQ16 = ?");
			params.add(aa00j16s00.getBloq16());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa00j16s00 entity
	 * 
	 * @param aa00j16s00
	 *            Aa00j16s00 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Aa00j16s00 aa00j16s00,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				Aa00j16s00DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa00j16s00 != null && aa00j16s00.getId16() != null) {
			where.append(" AND t1.ID16 = ?");
			params.add(aa00j16s00.getId16());
		}
		if (aa00j16s00 != null && aa00j16s00.getNomc16() != null) {
			where.append(" AND UPPER(t1.NOMC16) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j16s00.getNomc16().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j16s00.getNomc16().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMC16 IS NOT NULL");
		}
		if (aa00j16s00 != null && aa00j16s00.getNome16() != null) {
			where.append(" AND UPPER(t1.NOME16) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j16s00.getNome16().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j16s00.getNome16().toUpperCase() + "%");
			}
			where.append(" AND t1.NOME16 IS NOT NULL");
		}

		if (aa00j16s00 != null && aa00j16s00.getTitc16() != null) {
			where.append(" AND UPPER(t1.TITC16) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j16s00.getTitc16().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j16s00.getTitc16().toUpperCase() + "%");
			}
			where.append(" AND t1.TITC16 IS NOT NULL");
		}
		if (aa00j16s00 != null && aa00j16s00.getTite16() != null) {
			where.append(" AND UPPER(t1.TITE16) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j16s00.getTite16().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j16s00.getTite16().toUpperCase() + "%");
			}
			where.append(" AND t1.TITE16 IS NOT NULL");
		}
		if (aa00j16s00 != null && aa00j16s00.getTipo16() != null) {
			where.append(" AND t1.TIPO16 = ?");
			params.add(aa00j16s00.getTipo16());
		}
		if (aa00j16s00 != null && aa00j16s00.getSit16() != null) {
			where.append(" AND UPPER(t1.SIT16) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j16s00.getSit16().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j16s00.getSit16().toUpperCase() + "%");
			}
			where.append(" AND t1.SIT16 IS NOT NULL");
		}
		if (aa00j16s00 != null && aa00j16s00.getUsub16() != null) {
			where.append(" AND UPPER(t1.USUB16) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j16s00.getUsub16().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j16s00.getUsub16().toUpperCase() + "%");
			}
			where.append(" AND t1.USUB16 IS NOT NULL");
		}
		if (aa00j16s00 != null && aa00j16s00.getBloq16() != null) {
			where.append(" AND t1.BLOQ16 = ?");
			params.add(aa00j16s00.getBloq16());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
