package com.ejie.aa00j.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa00j.model.Aa00j15s01;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa00j15s01DaoImpl generated by UDA, 20-mar-2014 15:54:59.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class Aa00j15s01DaoImpl implements Aa00j15s01Dao {
	private JdbcTemplate jdbcTemplate;
	private static final Logger logger = LoggerFactory
			.getLogger(Aa00j15s01DaoImpl.class);
	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Aa00j15s01> rwMap = new RowMapper<Aa00j15s01>() {
		public Aa00j15s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa00j15s01(resultSet.getLong("CEDIF15"),
					resultSet.getLong("FECHA15"),
					resultSet.getString("HINIT15"),
					resultSet.getString("HFIN15"));
		}
	};

	private RowMapper<Aa00j15s01> rwMapPK = new RowMapper<Aa00j15s01>() {
		public Aa00j15s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa00j15s01(resultSet.getLong("CEDIF15"),
					resultSet.getLong("FECHA15"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Aa00j15s01>> rwMapJerarquia = new RowMapper<JerarquiaDto<Aa00j15s01>>() {
		public JerarquiaDto<Aa00j15s01> mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Aa00j15s01 aa00j15s01 = new Aa00j15s01(
					resultSet.getLong("CEDIF15"), resultSet.getLong("FECHA15"),
					resultSet.getString("HINIT15"),
					resultSet.getString("HFIN15"));

			JerarquiaDto<Aa00j15s01> jerarquia = new JerarquiaDto<Aa00j15s01>();
			jerarquia.setModel(aa00j15s01);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet
					.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet
					.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Aa00j15s01 table.
	 * 
	 * @param aa00j15s01
	 *            Aa00j15s01
	 * @return Aa00j15s01
	 */
	public Aa00j15s01 add(Aa00j15s01 aa00j15s01) {
		Aa00j15s01DaoImpl.logger.info("Método add");
		String query = "INSERT INTO AA00J15S01 (CEDIF15, FECHA15, HINIT15, HFIN15) VALUES (?,?,?,?)";
		Aa00j15s01DaoImpl.logger.info("SQL " + query);
		Aa00j15s01DaoImpl.logger.info("PARAM1 " + aa00j15s01.getCedif15());
		Aa00j15s01DaoImpl.logger.info("PARAM2 " + aa00j15s01.getFecha15());
		Aa00j15s01DaoImpl.logger.info("PARAM3 " + aa00j15s01.getHinit15());
		Aa00j15s01DaoImpl.logger.info("PARAM4 " + aa00j15s01.getHfin15());
		this.jdbcTemplate.update(query, aa00j15s01.getCedif15(),
				aa00j15s01.getFecha15(), aa00j15s01.getHinit15(),
				aa00j15s01.getHfin15());
		return aa00j15s01;
	}

	/**
	 * Updates a single row in the Aa00j15s01 table.
	 * 
	 * @param aa00j15s01
	 *            Aa00j15s01
	 * @return Aa00j15s01
	 */
	public Aa00j15s01 update(Aa00j15s01 aa00j15s01) {
		Aa00j15s01DaoImpl.logger.info("Método update");
		String query = "UPDATE AA00J15S01 SET HINIT15=?, HFIN15=? WHERE CEDIF15=? AND FECHA15=?";
		Aa00j15s01DaoImpl.logger.info("SQL " + query);
		Aa00j15s01DaoImpl.logger.info("PARAM1 " + aa00j15s01.getHinit15());
		Aa00j15s01DaoImpl.logger.info("PARAM2 " + aa00j15s01.getHfin15());
		Aa00j15s01DaoImpl.logger.info("PARAM3 " + aa00j15s01.getCedif15());
		Aa00j15s01DaoImpl.logger.info("PARAM4 " + aa00j15s01.getFecha15());
		this.jdbcTemplate.update(query, aa00j15s01.getHinit15(),
				aa00j15s01.getHfin15(), aa00j15s01.getCedif15(),
				aa00j15s01.getFecha15());
		return aa00j15s01;
	}

	/**
	 * Finds a single row in the Aa00j15s01 table.
	 * 
	 * @param aa00j15s01
	 *            Aa00j15s01
	 * @return Aa00j15s01
	 */
	@Transactional(readOnly = true)
	public Aa00j15s01 find(Aa00j15s01 aa00j15s01) {
		Aa00j15s01DaoImpl.logger.info("Método find");
		String query = "SELECT t1.CEDIF15 CEDIF15, t1.FECHA15 FECHA15, t1.HINIT15 HINIT15, t1.HFIN15 HFIN15 FROM AA00J15S01 t1  WHERE t1.CEDIF15 = ?   AND t1.FECHA15 = ?  ";
		Aa00j15s01DaoImpl.logger.info("SQL " + query);
		Aa00j15s01DaoImpl.logger.info("PARAM1 " + aa00j15s01.getFecha15());
		List<Aa00j15s01> aa00j15s01List = this.jdbcTemplate.query(query,
				this.rwMap, aa00j15s01.getCedif15(), aa00j15s01.getFecha15());
		return (Aa00j15s01) DataAccessUtils.uniqueResult(aa00j15s01List);
	}

	/**
	 * Removes a single row in the Aa00j15s01 table.
	 * 
	 * @param aa00j15s01
	 *            Aa00j15s01
	 * @return
	 */
	public void remove(Aa00j15s01 aa00j15s01) {
		Aa00j15s01DaoImpl.logger.info("Método remove");
		String query = "DELETE FROM AA00J15S01 WHERE CEDIF15=? AND FECHA15=?";
		Aa00j15s01DaoImpl.logger.info("SQL " + query);
		Aa00j15s01DaoImpl.logger.info("PARAM1 " + aa00j15s01.getCedif15());
		Aa00j15s01DaoImpl.logger.info("PARAM2 " + aa00j15s01.getFecha15());
		this.jdbcTemplate.update(query, aa00j15s01.getCedif15(),
				aa00j15s01.getFecha15());
	}

	/**
	 * Finds a list of rows in the Aa00j15s01 table.
	 * 
	 * @param aa00j15s01
	 *            Aa00j15s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa00j15s01>
	 */
	@Transactional(readOnly = true)
	public List<Aa00j15s01> findAll(Aa00j15s01 aa00j15s01,
			JQGridRequestDto jqGridRequestDto) {
		Aa00j15s01DaoImpl.logger.info("Método findAll");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CEDIF15 CEDIF15,t1.FECHA15 FECHA15,t1.HINIT15 HINIT15,t1.HFIN15 HFIN15 ");
		query.append("FROM AA00J15S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa00j15s01);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		Aa00j15s01DaoImpl.logger.info("SQL " + query);
		Aa00j15s01DaoImpl.logger.info("PARAMS " + params);

		return (List<Aa00j15s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Aa00j15s01 table using like.
	 * 
	 * @param aa00j15s01
	 *            Aa00j15s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa00j15s01>
	 */
	@Transactional(readOnly = true)
	public List<Aa00j15s01> findAllLike(Long edificio, int anio,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		Aa00j15s01DaoImpl.logger.info("Método findAllLike");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CEDIF15 CEDIF15,t1.FECHA15 FECHA15,t1.HINIT15 HINIT15,t1.HFIN15 HFIN15 ");
		query.append("FROM AA00J15S01 t1 ");

		// Where clause & Params
		// Map<String, ?> mapaWhere = this.getWhereLikeMap(aa00j15s01,
		// startsWith);
		query.append(" WHERE t1.CEDIF15=? and t1.FECHA15>? and t1.FECHA15<?");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		Aa00j15s01DaoImpl.logger.info("SQL " + query);
		Aa00j15s01DaoImpl.logger.info("PARAM1 " + edificio);
		Aa00j15s01DaoImpl.logger.info("PARAM2 " + anio * 10000);
		Aa00j15s01DaoImpl.logger.info("PARAM3 " + (anio + 1) * 10000);
		return (List<Aa00j15s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, edificio, anio * 10000, (anio + 1) * 10000);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Aa00j15s01 table.
	 * 
	 * @param aa00j15s01
	 *            Aa00j15s01
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Aa00j15s01 aa00j15s01) {
		Aa00j15s01DaoImpl.logger.info("Método findAllCount");
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA00J15S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa00j15s01);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j15s01DaoImpl.logger.info("SQL " + query);
		Aa00j15s01DaoImpl.logger.info("PARAMS " + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Aa00j15s01 table using like.
	 * 
	 * @param aa00j15s01
	 *            Aa00j15s01
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Long edificio, int anio, Boolean startsWith) {
		Aa00j15s01DaoImpl.logger.info("Método findAllLikeCount");
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA00J15S01 t1 ");

		query.append(" WHERE t1.CEDIF15=? and t1.FECHA15>? and t1.FECHA15<?");
		Aa00j15s01DaoImpl.logger.info("SQL " + query);
		Aa00j15s01DaoImpl.logger.info("PARAM1 " + edificio);
		Aa00j15s01DaoImpl.logger.info("PARAM2 " + anio * 10000);
		Aa00j15s01DaoImpl.logger.info("PARAM3 " + (anio + 1) * 10000);
		return this.jdbcTemplate.queryForLong(query.toString(), edificio,
				anio * 10000, (anio + 1) * 10000);
	}

	/**
	 * Reorder the data list of Aa00j15s01 selected for rup_table
	 * 
	 * @param aa00j15s01
	 *            Aa00j15s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j15s01>>
	 */
	@Override
	public List<TableRowDto<Aa00j15s01>> reorderSelection(
			Aa00j15s01 aa00j15s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		Aa00j15s01DaoImpl.logger.info("Método reorderSelection");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CEDIF15 CEDIF15,t1.FECHA15 FECHA15,t1.HINIT15 HINIT15,t1.HFIN15 HFIN15 ");
		// FROM
		query.append("FROM AA00J15S01 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa00j15s01, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, Aa00j15s01.class, filterParamList,
				"CEDIF15,FECHA15");
		Aa00j15s01DaoImpl.logger.info("SQL " + sbReorderSelectionSQL);
		Aa00j15s01DaoImpl.logger.info("PARAMS " + filterParamList);

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa00j15s01>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * @param filterParams
	 *            Aa00j15s01
	 * @param searchParams
	 *            Aa00j15s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j15s01>>
	 */
	@Override
	public List<TableRowDto<Aa00j15s01>> search(Aa00j15s01 filterParams,
			Aa00j15s01 searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		Aa00j15s01DaoImpl.logger.info("Método search");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CEDIF15 CEDIF15,t1.FECHA15 FECHA15,t1.HINIT15 HINIT15,t1.HFIN15 HFIN15 ");
		// FROM
		query.append("FROM AA00J15S01 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, Aa00j15s01.class, filterParamList,
				searchSQL, searchParamList, from_alias, "CEDIF15,FECHA15");
		Aa00j15s01DaoImpl.logger.info("SQL " + sbReorderSelectionSQL);
		Aa00j15s01DaoImpl.logger.info("PARAMS " + filterParamList);
		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa00j15s01>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 * 
	 * @param filteraa00j15s01
	 *            Aa00j15s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Aa00j15s01 filteraa00j15s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		Aa00j15s01DaoImpl.logger.info("Método removeMultiple");
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.CEDIF15 CEDIF15,t1.FECHA15 FECHA15,t1.HINIT15 HINIT15,t1.HFIN15 HFIN15 ");
		// FROM
		query.append("FROM AA00J15S01 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filteraa00j15s01,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto, Aa00j15s01.class,
						query, params, "CEDIF15,FECHA15");
		Aa00j15s01DaoImpl.logger.info("SQL " + sbRemoveMultipleSQL);
		Aa00j15s01DaoImpl.logger.info("PARAMS " + params);
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical Aa00j15s01 table.
	 * 
	 * @param filterAa00j15s01
	 *            Aa00j15s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Aa00j15s01>>
	 */
	@Override
	public List<JerarquiaDto<Aa00j15s01>> findAllLikeJerarquia(
			Aa00j15s01 filterAa00j15s01, JQGridRequestDto jqGridRequestDto) {
		Aa00j15s01DaoImpl.logger.info("Método findAllLikeJerarquia");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CEDIF15 CEDIF15,t1.FECHA15 FECHA15,t1.HINIT15 HINIT15,t1.HFIN15 HFIN15 ");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA00J15S01 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA00J15S01");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa00j15s01, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
				mapaWhere, "CEDIF15,FECHA15", "ID_PADRE", "NOMBRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j15s01DaoImpl.logger.info("SQL " + query);
		Aa00j15s01DaoImpl.logger.info("PARAMS " + params);
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAa00j15s01
	 *            Aa00j15s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Aa00j15s01 filterAa00j15s01,
			JQGridRequestDto jqGridRequestDto) {
		Aa00j15s01DaoImpl.logger.info("Método findAllLikeCountJerarquia");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA00J15S01 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA00J15S01");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa00j15s01, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(
				jqGridRequestDto, mapaWhere, "CEDIF15,FECHA15", "ID_PADRE",
				from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j15s01DaoImpl.logger.info("SQL " + query);
		Aa00j15s01DaoImpl.logger.info("PARAMS " + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAa00j15s01
	 *            Aa00j15s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Aa00j15s01>>
	 */
	@Override
	public List<TableRowDto<Aa00j15s01>> findAllChild(
			Aa00j15s01 filterAa00j15s01, JQGridRequestDto jqGridRequestDto) {
		Aa00j15s01DaoImpl.logger.info("Método findAllChild");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA00J15S01 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA00J15S01");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa00j15s01, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(
				jqGridRequestDto, mapaWhere, "CEDIF15,FECHA15", "ID_PADRE",
				from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j15s01DaoImpl.logger.info("SQL " + query);
		Aa00j15s01DaoImpl.logger.info("PARAMS " + params);
		return this.jdbcTemplate.query(query.toString(),
				new RowNumResultSetExtractor<Aa00j15s01>(this.rwMapPK,
						"CEDIF15,FECHA15"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa00j15s01 entity
	 * 
	 * @param aa00j15s01
	 *            Aa00j15s01 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Aa00j15s01 aa00j15s01) {

		StringBuilder where = new StringBuilder(
				Aa00j15s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa00j15s01 != null && aa00j15s01.getCedif15() != null) {
			where.append(" AND t1.CEDIF15 = ?");
			params.add(aa00j15s01.getCedif15());
		}
		if (aa00j15s01 != null && aa00j15s01.getFecha15() != null) {
			where.append(" AND t1.FECHA15 = ?");
			params.add(aa00j15s01.getFecha15());
		}
		if (aa00j15s01 != null && aa00j15s01.getHinit15() != null) {
			where.append(" AND t1.HINIT15 = ?");
			params.add(aa00j15s01.getHinit15());
		}
		if (aa00j15s01 != null && aa00j15s01.getHfin15() != null) {
			where.append(" AND t1.HFIN15 = ?");
			params.add(aa00j15s01.getHfin15());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa00j15s01 entity
	 * 
	 * @param aa00j15s01
	 *            Aa00j15s01 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Aa00j15s01 aa00j15s01,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				Aa00j15s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa00j15s01 != null && aa00j15s01.getCedif15() != null) {
			where.append(" AND t1.CEDIF15 = ?");
			params.add(aa00j15s01.getCedif15());
		}
		if (aa00j15s01 != null && aa00j15s01.getFecha15() != null) {
			where.append(" AND t1.FECHA15 = ?");
			params.add(aa00j15s01.getFecha15());
		}
		if (aa00j15s01 != null && aa00j15s01.getHinit15() != null) {
			where.append(" AND UPPER(t1.HINIT15) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j15s01.getHinit15().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j15s01.getHinit15().toUpperCase() + "%");
			}
			where.append(" AND t1.HINIT15 IS NOT NULL");
		}
		if (aa00j15s01 != null && aa00j15s01.getHfin15() != null) {
			where.append(" AND UPPER(t1.HFIN15) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j15s01.getHfin15().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j15s01.getHfin15().toUpperCase() + "%");
			}
			where.append(" AND t1.HFIN15 IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Crea el calendario básico para el edificio y el año
	 * 
	 * @param edificio
	 * @param anio
	 * @return
	 */
	public int crear(Long edificio, int anio) {
		Aa00j15s01DaoImpl.logger.info("Método crear");
		Aa00j15s01DaoImpl.logger
				.info("Creando calendario básico para el edificio " + edificio
						+ " y el año " + anio);
		StringBuilder sql = new StringBuilder();
		sql.append("insert into aa00j15S01(cedif15,fecha15,hinit15,hfin15)");
		sql.append(" select ? as cedif15, ");
		sql.append("    to_number(to_char(mydate,'yyyyMMdd')) as fecha15,");
		sql.append("    case when (1+ TRUNC (mydate)  - TRUNC (mydate, 'IW'))>5 then null");
		sql.append("         when (1+ TRUNC (mydate)  - TRUNC (mydate, 'IW'))<6 then '08:00'");
		sql.append("    end as hinit15,");
		sql.append("    case when (1+ TRUNC (mydate)  - TRUNC (mydate, 'IW'))>5 then null");
		sql.append("         when (1+ TRUNC (mydate)  - TRUNC (mydate, 'IW'))<5 and (to_char(mydate,'MM')<'06' or  to_char(mydate,'MM')>'09') then '19:00'");
		sql.append("         when (1+ TRUNC (mydate)  - TRUNC (mydate, 'IW'))<5 and (to_char(mydate,'MM')>='06' and  to_char(mydate,'MM')<'10') then '14:30'");
		sql.append("         when (1+ TRUNC (mydate)  - TRUNC (mydate, 'IW'))=5 and (to_char(mydate,'MM')<'06' or  to_char(mydate,'MM')>'09')  then '15:00'");
		sql.append("         when (1+ TRUNC (mydate)  - TRUNC (mydate, 'IW'))=5 and (to_char(mydate,'MM')>='06' and  to_char(mydate,'MM')<'10') then '14:30'");
		sql.append("    end as hfin15");
		sql.append("    from(");
		sql.append(" select (level-1)+to_date(?,'dd-MM-yyyy') mydate from dual");
		sql.append(" connect by level <=to_date(?,'dd-MM-yyyy')-to_date(?,'dd-MM-yyyy') +1)");
		String diainit = "01-01-" + anio;
		String diafin = "31-12-" + anio;

		Aa00j15s01DaoImpl.logger.info("SQL " + sql);
		Aa00j15s01DaoImpl.logger.info("PARAM1 " + edificio);
		Aa00j15s01DaoImpl.logger.info("PARAM2 " + diainit);
		Aa00j15s01DaoImpl.logger.info("PARAM3 " + diafin);
		Aa00j15s01DaoImpl.logger.info("PARAM4 " + diainit);
		return this.jdbcTemplate.update(sql.toString(), edificio, diainit,
				diafin, diainit);
	}

	/**
	 * Borra los datos del del calendario para el edificio el año en concreto
	 * 
	 * @param edificio
	 * @param anio
	 * @return
	 */
	public int borrar(Long edificio, int anio) {
		Aa00j15s01DaoImpl.logger.info("Método borrar");
		Aa00j15s01DaoImpl.logger.info("Borrando calendario para el edificio "
				+ edificio + " y el año " + anio);
		StringBuilder sql = new StringBuilder();
		sql.append("delete from aa00j15S01   where cedif15=? and fecha15>?*10000 and fecha15 < ?*10000");
		Aa00j15s01DaoImpl.logger.info("SQL " + sql.toString());
		Aa00j15s01DaoImpl.logger.info("PARAM1 " + edificio);
		Aa00j15s01DaoImpl.logger.info("PARAM2 " + anio);
		Aa00j15s01DaoImpl.logger.info("PARAM3 " + anio + 1);
		return this.jdbcTemplate.update(sql.toString(), edificio, anio,
				anio + 1);
	}

	/**
	 * Actualiza los datos de hora de inicio para el calendario de edificio el
	 * año anio por la horainicio los festivos siguen siendo festivos.
	 * 
	 * @param edificio
	 * @param anio
	 * @param horainicio
	 * @return
	 */
	public int actualizarHoraInicio(Long edificio, int anio, String horainicio) {
		Aa00j15s01DaoImpl.logger.info("Método actualizarHoraInicio");
		Aa00j15s01DaoImpl.logger
				.info("Actualizar la hora de inicio para el edificio "
						+ edificio + " y el año " + anio);
		StringBuilder sql = new StringBuilder();
		sql.append("Update aa00j15S01 set hinit15=? where cedif15=? and fecha15>?*10000 and fecha15 < ?*10000 and hinit15 is not null");
		Aa00j15s01DaoImpl.logger.info("SQL " + sql.toString());
		Aa00j15s01DaoImpl.logger.info("PARAM1 " + horainicio);
		Aa00j15s01DaoImpl.logger.info("PARAM2 " + edificio);
		Aa00j15s01DaoImpl.logger.info("PARAM3 " + anio);
		Aa00j15s01DaoImpl.logger.info("PARAM4 " + anio + 1);
		return this.jdbcTemplate.update(sql.toString(), horainicio, edificio,
				anio, anio + 1);
	}

	/**
	 * Actualiza los datos de hora final para el calendario de edificio el año
	 * anio por la horafin, menos los viernes. los festivos siguen siendo
	 * festivos.
	 * 
	 * @param edificio
	 * @param anio
	 * @param horafin
	 * @return
	 */
	public int actualizarHoraFin(Long edificio, int anio, String horafin) {
		Aa00j15s01DaoImpl.logger.info("Método actualizarHoraFin");
		Aa00j15s01DaoImpl.logger
				.info("Actualizar la hora de final para el edificio "
						+ edificio + " y el año " + anio);
		StringBuilder sql = new StringBuilder();
		// TRUNC (mydate) - TRUNC (mydate, 'IW')
		sql.append("Update aa00j15S01 set hfin15=? where cedif15=? and fecha15>?*10000 and fecha15 < ?*10000 and hinit15 is not null and (1+ TRUNC(to_date(fecha15,'yyyyMMdd'))-TRUNC(to_date(fecha15,'yyyyMMdd'),'IW')) !=5 ");
		Aa00j15s01DaoImpl.logger.info("SQL " + sql.toString());
		Aa00j15s01DaoImpl.logger.info("PARAM1 " + horafin);
		Aa00j15s01DaoImpl.logger.info("PARAM2 " + edificio);
		Aa00j15s01DaoImpl.logger.info("PARAM3 " + anio);
		Aa00j15s01DaoImpl.logger.info("PARAM4 " + anio + 1);
		return this.jdbcTemplate.update(sql.toString(), horafin, edificio,
				anio, anio + 1);
	}

	/**
	 * Actualiza los datos de hora final para el calendario de edificio el año
	 * anio por la horafin para los viernes. los festivos siguen siendo
	 * festivos.
	 * 
	 * @param edificio
	 * @param anio
	 * @param horafin
	 * @return
	 */
	public int actualizarHoraFinViernes(Long edificio, int anio, String horafin) {
		Aa00j15s01DaoImpl.logger.info("Método actualizarHoraFinViernes");
		Aa00j15s01DaoImpl.logger
				.info("Actualizar la hora de final de los viernes  para el edificio "
						+ edificio + " y el año " + anio);
		StringBuilder sql = new StringBuilder();
		sql.append("Update aa00j15S01 set hfin15=? where cedif15=? and fecha15>?*10000 and fecha15 < ?*10000 and hinit15 is not null and (1+ TRUNC(to_date(fecha15,'yyyyMMdd'))-TRUNC(to_date(fecha15,'yyyyMMdd'),'IW')) =5 ");
		Aa00j15s01DaoImpl.logger.info("SQL " + sql.toString());
		Aa00j15s01DaoImpl.logger.info("PARAM1 " + horafin);
		Aa00j15s01DaoImpl.logger.info("PARAM2 " + edificio);
		Aa00j15s01DaoImpl.logger.info("PARAM3 " + anio);
		Aa00j15s01DaoImpl.logger.info("PARAM4 " + anio + 1);
		return this.jdbcTemplate.update(sql.toString(), horafin, edificio,
				anio, anio + 1);
	}

	/**
	 * Crea la jornada intensiva, para ello borra las fechas existentes primero,
	 * luego hace una insert
	 * 
	 * @param edificio
	 * @param hinit
	 * @param hfin
	 * @param sfecha1
	 * @param sfecha2
	 * @param local
	 * @return
	 */
	public int crearIntensiva(Long edificio, String hinit, String hfin,
			String sfecha1, String sfecha2, Locale local) {
		Aa00j15s01DaoImpl.logger.info("Método crearIntensiva");
		StringBuffer f = new StringBuffer();
		int fechainitnum, fechafinnum;
		if (local.getLanguage().contains("eu")) {

			String[] fechas = sfecha1.split("/");
			f = new StringBuffer();
			f.append(fechas[0]);
			if (fechas[1].length() == 1)
				f.append("0");
			f.append(fechas[1]);
			if (fechas[2].length() == 1)
				f.append("0");
			f.append(fechas[2]);
			fechainitnum = Integer.parseInt(f.toString());
			fechas = sfecha2.split("/");
			f = new StringBuffer();
			f.append(fechas[0]);
			if (fechas[1].length() == 1)
				f.append("0");
			f.append(fechas[1]);
			if (fechas[2].length() == 1)
				f.append("0");
			f.append(fechas[2]);
			fechafinnum = Integer.parseInt(f.toString());

		} else {

			String[] fechas = sfecha1.split("/");
			f = new StringBuffer();
			f.append(fechas[2]);
			if (fechas[1].length() == 1)
				f.append("0");
			f.append(fechas[1]);
			if (fechas[0].length() == 1)
				f.append("0");
			f.append(fechas[0]);
			fechainitnum = Integer.parseInt(f.toString());
			fechas = sfecha2.split("/");
			f = new StringBuffer();
			f.append(fechas[2]);
			if (fechas[1].length() == 1)
				f.append("0");
			f.append(fechas[1]);
			if (fechas[0].length() == 1)
				f.append("0");
			f.append(fechas[0]);
			fechafinnum = Integer.parseInt(f.toString());
		}

		Aa00j15s01DaoImpl.logger
				.info("Borrando los datos existentes en el periodo para el edificio"
						+ edificio);
		StringBuilder sql = new StringBuilder();
		sql.append("delete from aa00j15S01 where cedif15=? and fecha15>=? and fecha15<=? ");
		Aa00j15s01DaoImpl.logger.info("SQL " + sql.toString());
		Aa00j15s01DaoImpl.logger.info("PARAM1 " + edificio);
		Aa00j15s01DaoImpl.logger.info("PARAM2 " + fechainitnum);
		Aa00j15s01DaoImpl.logger.info("PARAM3 " + fechafinnum);
		this.jdbcTemplate.update(sql.toString(), edificio, fechainitnum,
				fechafinnum);
		Aa00j15s01DaoImpl.logger
				.info("Creando jornada intensiva para el edificio " + edificio);
		sql = new StringBuilder();
		sql.append("insert into aa00j15S01(cedif15,fecha15,hinit15,hfin15)");
		sql.append(" select ? as cedif15, ");
		sql.append("    to_number(to_char(mydate,'yyyyMMdd')) as fecha15,");
		sql.append("    case when (1+ TRUNC (mydate)  - TRUNC (mydate, 'IW'))>5 then null");
		sql.append("         when (1+ TRUNC (mydate)  - TRUNC (mydate, 'IW'))<6 then ?");
		sql.append("    end as hinit15,");
		sql.append("    case when (1+ TRUNC (mydate)  - TRUNC (mydate, 'IW'))>5 then null");
		sql.append("         when (1+ TRUNC (mydate)  - TRUNC (mydate, 'IW'))<6 then ?");
		;
		sql.append("    end as hfin15");
		sql.append("    from(");
		sql.append(" select (level-1)+to_date(?,'yyyyMMdd') mydate from dual");
		sql.append(" connect by level <= to_date(?,'yyyyMMdd')  - to_date(?,'yyyyMMdd') +1)");
		List<Object> params = new ArrayList<Object>();
		params.add(edificio);
		params.add(hinit);
		params.add(hfin);
		params.add("" + fechainitnum);
		params.add("" + fechafinnum);
		params.add("" + fechainitnum);
		Aa00j15s01DaoImpl.logger.info("SQL " + sql.toString());
		Aa00j15s01DaoImpl.logger.info("PARAMS " + params);
		return this.jdbcTemplate.update(sql.toString(), params.toArray());
	}

	/**
	 * Finds a single row in the Aa00j15s01 table.
	 * 
	 * @param edificio
	 * @param dia
	 * @return Aa00j15s01
	 */
	@Transactional(readOnly = true)
	public Aa00j15s01 find(int edificio, int dia) {
		Aa00j15s01DaoImpl.logger.info("Método find");
		String query = "SELECT t1.CEDIF15 CEDIF15, t1.FECHA15 FECHA15, t1.HINIT15 HINIT15, t1.HFIN15 HFIN15 FROM AA00J15S01 t1  WHERE t1.CEDIF15 = ?   AND t1.FECHA15 = ?  ";
		Aa00j15s01DaoImpl.logger.info("SQL " + query.toString());
		Aa00j15s01DaoImpl.logger.info("PARAM1 " + edificio);
		Aa00j15s01DaoImpl.logger.info("PARAM2 " + dia);
		List<Aa00j15s01> aa00j15s01List = this.jdbcTemplate.query(query,
				this.rwMap, edificio, dia);
		return (Aa00j15s01) DataAccessUtils.uniqueResult(aa00j15s01List);
	}
}
