package com.ejie.aa00j.dao;

import java.util.List;
import java.util.Locale;

import com.ejie.aa00j.model.Aa00j15s01;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa00j15s01Dao generated by UDA, 20-mar-2014 15:54:59.
 * 
 * @author UDA
 */

public interface Aa00j15s01Dao {

	/**
	 * Inserts a single row in the Aa00j15s01 table.
	 * 
	 * @param aa00j15s01
	 *            Aa00j15s01
	 * @return Aa00j15s01
	 */
	Aa00j15s01 add(Aa00j15s01 aa00j15s01);

	/**
	 * Updates a single row in the Aa00j15s01 table.
	 * 
	 * @param aa00j15s01
	 *            Aa00j15s01
	 * @return Aa00j15s01
	 */
	Aa00j15s01 update(Aa00j15s01 aa00j15s01);

	/**
	 * Finds a single row in the Aa00j15s01 table.
	 * 
	 * @param aa00j15s01
	 *            Aa00j15s01
	 * @return Aa00j15s01
	 */
	Aa00j15s01 find(Aa00j15s01 aa00j15s01);

	/**
	 * Removes a single row in the Aa00j15s01 table.
	 * 
	 * @param aa00j15s01
	 *            Aa00j15s01
	 */
	void remove(Aa00j15s01 aa00j15s01);

	/**
	 * Finds a List of rows in the Aa00j15s01 table.
	 * 
	 * @param aa00j15s01
	 *            Aa00j15s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List
	 */
	List<Aa00j15s01> findAll(Aa00j15s01 aa00j15s01,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Finds rows in the Aa00j15s01 table using like.
	 * 
	 * @param aa00j15s01
	 *            Aa00j15s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Aa00j15s01> findAllLike(Long edificio, int anio,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter in the Aa00j15s01 table.
	 * 
	 * @param filterAa00j15s01
	 *            Aa00j15s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(Aa00j15s01 filterAa00j15s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Counts rows in the Aa00j15s01 table using like.
	 * 
	 * @param aa00j15s01
	 *            Aa00j15s01
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Long edificio, int anio, Boolean startsWith);

	/**
	 * Counts rows in the Aa00j15s01 table.
	 * 
	 * @param aa00j15s01
	 *            Aa00j15s01
	 * @return Long
	 */
	Long findAllCount(Aa00j15s01 aa00j15s01);

	/**
	 * Reorder selection.
	 * 
	 * @param filterAa00j15s01
	 *            Aa00j15s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j15s01>>
	 */
	List<TableRowDto<Aa00j15s01>> reorderSelection(Aa00j15s01 filterAa00j15s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Searches in the Usuario table.
	 * 
	 * @param filterAa00j15s01
	 *            Aa00j15s01
	 * @param searchAa00j15s01
	 *            Aa00j15s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j15s01>>
	 */
	List<TableRowDto<Aa00j15s01>> search(Aa00j15s01 filterAa00j15s01,
			Aa00j15s01 searchAa00j15s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Filter in the hierarchical Aa00j15s01 table.
	 * 
	 * @param filterAa00j15s01
	 *            Aa00j15s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Aa00j15s01>>
	 */
	List<JerarquiaDto<Aa00j15s01>> findAllLikeJerarquia(
			Aa00j15s01 filterAa00j15s01, JQGridRequestDto jqGridRequestDto);

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAa00j15s01
	 *            Aa00j15s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	Long findAllLikeCountJerarquia(Aa00j15s01 filterAa00j15s01,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAa00j15s01
	 *            Aa00j15s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Aa00j15s01>>
	 */
	List<TableRowDto<Aa00j15s01>> findAllChild(Aa00j15s01 filterAa00j15s01,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Crea el calendario básico para el edificio y el año
	 * 
	 * @param edificio
	 * @param anio
	 * @return
	 */
	public int crear(Long edificio, int anio);

	/**
	 * Borra los datos del del calendario para el edificio el año en concreto
	 * 
	 * @param edificio
	 * @param anio
	 * @return
	 */
	public int borrar(Long edificio, int anio);

	/**
	 * Actualiza los datos de hora de inicio para el calendario de edificio el
	 * año anio por la horainicio los festivos siguen siendo festivos.
	 * 
	 * @param edificio
	 * @param anio
	 * @param horainicio
	 * @return
	 */
	public int actualizarHoraInicio(Long edificio, int anio, String horainicio);

	/**
	 * Actualiza los datos de hora final para el calendario de edificio el año
	 * anio por la horafin, menos los viernes. los festivos siguen siendo
	 * festivos.
	 * 
	 * @param edificio
	 * @param anio
	 * @param horafin
	 * @return
	 */
	public int actualizarHoraFin(Long edificio, int anio, String horafin);

	/**
	 * Actualiza los datos de hora final para el calendario de edificio el año
	 * anio por la horafin para los viernes. los festivos siguen siendo
	 * festivos.
	 * 
	 * @param edificio
	 * @param anio
	 * @param horafin
	 * @return
	 */
	public int actualizarHoraFinViernes(Long edificio, int anio, String horafin);

	/**
	 * Crea la jornada intensiva, para ello borra las fechas existentes primero,
	 * luego hace una insert
	 * 
	 * @param edificio
	 * @param hinit
	 * @param hfin
	 * @param sfecha1
	 * @param sfecha2
	 * @param local
	 * @return
	 */
	public int crearIntensiva(Long edificio, String hinit, String hfin,
			String sfecha1, String sfecha2, Locale local);

	/**
	 * Finds a single row in the Aa00j15s01 table.
	 * 
	 * @param edificio
	 * @param dia
	 * @return Aa00j15s01
	 */
	public Aa00j15s01 find(int edificio, int dia);
}
