package com.ejie.aa00j.dao;

import com.ejie.aa00j.model.Aa00j03s01;
import com.ejie.aa00j.model.Aa00j06s01;
import com.ejie.aa00j.model.Aa00j07s01;
import com.ejie.aa00j.model.Aa00j13s01;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa00j.model.Aa00j14s01;

/**
 * Aa00j14s01DaoImpl generated by UDA, 16-oct-2013 13:02:12.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class Aa00j14s01DaoImpl implements Aa00j14s01Dao {
	private JdbcTemplate jdbcTemplate;
	private static final Logger logger = LoggerFactory
			.getLogger(Aa00j14s01DaoImpl.class);
	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Aa00j14s01> rwMap = new RowMapper<Aa00j14s01>() {
		public Aa00j14s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa00j14s01(resultSet.getLong("COD14"),
					resultSet.getString("SIT14"),
					resultSet.getString("CARC14"),
					resultSet.getString("CARE14"), new Aa00j13s01(
							resultSet.getLong("Aa00j13s01CREC13"),
							resultSet.getString("Aa00j13s01SIT13"),
							resultSet.getInt("Aa00j13s01BLOQ13"),
							resultSet.getString("Aa00j13s01NOMC13"),
							resultSet.getString("Aa00j13s01DESCC13"),
							resultSet.getString("Aa00j13s01NOME13"),
							resultSet.getString("Aa00j13s01DESCE13"),
							resultSet.getInt("Aa00j13s01SWDISP13"),
							resultSet.getString("Aa00j13s01USUB13"),
							new Aa00j03s01(resultSet
									.getLong("Aa00j13s01CEDIF13"), null, null,
									null, null, null, null, null, null, null),
							new Aa00j06s01(resultSet
									.getLong("Aa00j13s01CREST13"), null, null,
									null, null, null, null, null, null, null),
							new Aa00j07s01(resultSet
									.getLong("Aa00j13s01CDEP13"), null, null,
									null, null, null, null)));
		}
	};

	private RowMapper<Aa00j14s01> rwMapPK = new RowMapper<Aa00j14s01>() {
		public Aa00j14s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa00j14s01(resultSet.getLong("COD14"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Aa00j14s01>> rwMapJerarquia = new RowMapper<JerarquiaDto<Aa00j14s01>>() {
		public JerarquiaDto<Aa00j14s01> mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Aa00j14s01 aa00j14s01 = new Aa00j14s01(resultSet.getLong("COD14"),
					resultSet.getString("SIT14"),
					resultSet.getString("CARC14"),
					resultSet.getString("CARE14"), new Aa00j13s01(
							resultSet.getLong("Aa00j13s01CREC13"),
							resultSet.getString("Aa00j13s01SIT13"),
							resultSet.getInt("Aa00j13s01BLOQ13"),
							resultSet.getString("Aa00j13s01NOMC13"),
							resultSet.getString("Aa00j13s01DESCC13"),
							resultSet.getString("Aa00j13s01NOME13"),
							resultSet.getString("Aa00j13s01DESCE13"),
							resultSet.getInt("Aa00j13s01SWDISP13"),
							resultSet.getString("Aa00j13s01USUB13"),
							new Aa00j03s01(resultSet
									.getLong("Aa00j13s01CEDIF13"), null, null,
									null, null, null, null, null, null, null),
							new Aa00j06s01(resultSet
									.getLong("Aa00j13s01CREST13"), null, null,
									null, null, null, null, null, null, null),
							new Aa00j07s01(resultSet
									.getLong("Aa00j13s01CDEP13"), null, null,
									null, null, null, null)));

			JerarquiaDto<Aa00j14s01> jerarquia = new JerarquiaDto<Aa00j14s01>();
			jerarquia.setModel(aa00j14s01);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet
					.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet
					.getString("FILTER")));
			return jerarquia;
		}
	};

	private RowMapper<Aa00j14s01> rwMapCombo = new RowMapper<Aa00j14s01>() {
		public Aa00j14s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa00j14s01(resultSet.getLong("COD14"),
					resultSet.getString("SIT14"),
					resultSet.getString("CARC14"),
					resultSet.getString("CARE14"), new Aa00j13s01(
							resultSet.getLong("CREC14")));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Aa00j14s01 table.
	 * 
	 * @param aa00j14s01
	 *            Aa00j14s01
	 * @return Aa00j14s01
	 */
	public Aa00j14s01 add(final Aa00j14s01 aa00j14s01) {
		Aa00j14s01DaoImpl.logger.info("Método add");
		final String queryUltimoId = "(SELECT NVL(MAX(TO_NUMBER(COD14)), 0) + 1 FROM AA00J14S01)";
		final String query = "INSERT INTO AA00J14S01 (COD14, CREC14, SIT14, CARC14, CARE14) VALUES ("
				+ queryUltimoId + ",?,?,?,?)";

		final Object getAa00j13s01Crec13Aux;
		if (aa00j14s01.getAa00j13s01() != null
				&& aa00j14s01.getAa00j13s01().getCrec13() != null) {
			getAa00j13s01Crec13Aux = aa00j14s01.getAa00j13s01().getCrec13();
		} else {
			getAa00j13s01Crec13Aux = null;
		}

		KeyHolder keyHolder = new GeneratedKeyHolder();
		Aa00j14s01DaoImpl.logger.info("SQL " + query);
		Aa00j14s01DaoImpl.logger.info("PARAM1 " + getAa00j13s01Crec13Aux);
		Aa00j14s01DaoImpl.logger.info("PARAM2 " + aa00j14s01.getSit14());
		Aa00j14s01DaoImpl.logger
				.info("PARAM3 " + aa00j14s01.getCarc14().trim());
		Aa00j14s01DaoImpl.logger
				.info("PARAM4 " + aa00j14s01.getCare14().trim());
		jdbcTemplate.update(new PreparedStatementCreator() {
			public PreparedStatement createPreparedStatement(
					Connection connection) throws SQLException {
				PreparedStatement ps = connection.prepareStatement(query,
						new String[] { "COD14" });
				ps.setObject(1, getAa00j13s01Crec13Aux);
				ps.setObject(2, aa00j14s01.getSit14());
				ps.setObject(3, aa00j14s01.getCarc14().trim());
				ps.setObject(4, aa00j14s01.getCare14().trim());
				return ps;
			}
		}, keyHolder);

		aa00j14s01.setCod14(keyHolder.getKey().longValue());

		return aa00j14s01;
	}

	/**
	 * Updates a single row in the Aa00j14s01 table.
	 * 
	 * @param aa00j14s01
	 *            Aa00j14s01
	 * @return Aa00j14s01
	 */
	public Aa00j14s01 update(Aa00j14s01 aa00j14s01) {
		Aa00j14s01DaoImpl.logger.info("Método update");
		String query = "UPDATE AA00J14S01 SET CREC14=?, SIT14=?, CARC14=?, CARE14=? WHERE COD14=?";
		Object getAa00j13s01Crec13Aux = null;
		if (aa00j14s01.getAa00j13s01() != null
				&& aa00j14s01.getAa00j13s01().getCrec13() != null) {
			getAa00j13s01Crec13Aux = aa00j14s01.getAa00j13s01().getCrec13();
		}
		Aa00j14s01DaoImpl.logger.info("SQL " + query);
		Aa00j14s01DaoImpl.logger.info("PARAM1 " + getAa00j13s01Crec13Aux);
		Aa00j14s01DaoImpl.logger.info("PARAM2 " + aa00j14s01.getSit14());
		Aa00j14s01DaoImpl.logger
				.info("PARAM3 " + aa00j14s01.getCarc14().trim());
		Aa00j14s01DaoImpl.logger
				.info("PARAM4 " + aa00j14s01.getCare14().trim());
		Aa00j14s01DaoImpl.logger.info("PARAM5 " + aa00j14s01.getCod14());
		this.jdbcTemplate.update(query, getAa00j13s01Crec13Aux,
				aa00j14s01.getSit14(), aa00j14s01.getCarc14(),
				aa00j14s01.getCare14(), aa00j14s01.getCod14());
		return aa00j14s01;
	}

	/**
	 * Finds a single row in the Aa00j14s01 table.
	 * 
	 * @param aa00j14s01
	 *            Aa00j14s01
	 * @return Aa00j14s01
	 */
	@Transactional(readOnly = true)
	public Aa00j14s01 find(Aa00j14s01 aa00j14s01) {
		Aa00j14s01DaoImpl.logger.info("Método find");
		String query = "SELECT t1.COD14 COD14, t1.SIT14 SIT14, t1.CARC14 CARC14, t1.CARE14 CARE14, t2.CREC13 AA00J13S01CREC13, t2.SIT13 AA00J13S01SIT13, t2.BLOQ13 AA00J13S01BLOQ13, t2.NOMC13 AA00J13S01NOMC13, t2.DESCC13 AA00J13S01DESCC13, t2.NOME13 AA00J13S01NOME13, t2.DESCE13 AA00J13S01DESCE13, t2.SWDISP13 AA00J13S01SWDISP13, t2.CDEP13 AA00J13S01CDEP13, t2.USUB13 AA00J13S01USUB13, t2.CEDIF13 AA00J13S01CEDIF13, t2.CREST13 AA00J13S01CREST13 FROM AA00J14S01 t1 , AA00J13S01 t2  WHERE t1.COD14 = ?   AND t1.CREC14= t2.CREC13(+)";
		Aa00j14s01DaoImpl.logger.info("SQL " + query);
		Aa00j14s01DaoImpl.logger.info("PARAM1" + aa00j14s01.getCod14());
		List<Aa00j14s01> aa00j14s01List = this.jdbcTemplate.query(query,
				this.rwMap, aa00j14s01.getCod14());
		return (Aa00j14s01) DataAccessUtils.uniqueResult(aa00j14s01List);
	}

	/**
	 * Removes a single row in the Aa00j14s01 table.
	 * 
	 * @param aa00j14s01
	 *            Aa00j14s01
	 * @return
	 */
	public void remove(Aa00j14s01 aa00j14s01) {
		Aa00j14s01DaoImpl.logger.info("Método remove");
		String query = "DELETE FROM AA00J14S01 WHERE COD14=?";
		Aa00j14s01DaoImpl.logger.info("SQL " + query);
		Aa00j14s01DaoImpl.logger.info("PARAM1" + aa00j14s01.getCod14());
		this.jdbcTemplate.update(query, aa00j14s01.getCod14());
	}

	/**
	 * Finds a list of rows in the Aa00j14s01 table.
	 * 
	 * @param aa00j14s01
	 *            Aa00j14s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa00j14s01>
	 */
	@Transactional(readOnly = true)
	public List<Aa00j14s01> findAll(Aa00j14s01 aa00j14s01,
			JQGridRequestDto jqGridRequestDto) {
		Aa00j14s01DaoImpl.logger.info("Método findAll");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.COD14 COD14,t1.SIT14 SIT14,t1.CARC14 CARC14,t1.CARE14 CARE14,t2.CREC13 AA00J13S01CREC13,t2.SIT13 AA00J13S01SIT13,t2.BLOQ13 AA00J13S01BLOQ13,t2.NOMC13 AA00J13S01NOMC13,t2.DESCC13 AA00J13S01DESCC13,t2.NOME13 AA00J13S01NOME13,t2.DESCE13 AA00J13S01DESCE13,t2.SWDISP13 AA00J13S01SWDISP13,t2.CDEP13 AA00J13S01CDEP13,t2.USUB13 AA00J13S01USUB13,t2.CEDIF13 AA00J13S01CEDIF13,t2.CREST13 AA00J13S01CREST13 ");
		query.append("FROM AA00J14S01 t1 ,AA00J13S01 t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa00j14s01);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CREC14= t2.CREC13(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		Aa00j14s01DaoImpl.logger.info("SQL " + query);
		Aa00j14s01DaoImpl.logger.info("PARAMS" + params);
		return (List<Aa00j14s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Aa00j14s01 table using like.
	 * 
	 * @param aa00j14s01
	 *            Aa00j14s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa00j14s01>
	 */
	@Transactional(readOnly = true)
	public List<Aa00j14s01> findAllLike(Aa00j14s01 aa00j14s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		Aa00j14s01DaoImpl.logger.info("Método findAllLike");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.COD14 COD14,t1.SIT14 SIT14,t1.CARC14 CARC14,t1.CARE14 CARE14,t2.CREC13 AA00J13S01CREC13,t2.SIT13 AA00J13S01SIT13,t2.BLOQ13 AA00J13S01BLOQ13,t2.NOMC13 AA00J13S01NOMC13,t2.DESCC13 AA00J13S01DESCC13,t2.NOME13 AA00J13S01NOME13,t2.DESCE13 AA00J13S01DESCE13,t2.SWDISP13 AA00J13S01SWDISP13,t2.CDEP13 AA00J13S01CDEP13,t2.USUB13 AA00J13S01USUB13,t2.CEDIF13 AA00J13S01CEDIF13,t2.CREST13 AA00J13S01CREST13 ");
		query.append("FROM AA00J14S01 t1 ,AA00J13S01 t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa00j14s01, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CREC14= t2.CREC13(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		Aa00j14s01DaoImpl.logger.info("SQL " + query);
		Aa00j14s01DaoImpl.logger.info("PARAMS" + params);
		return (List<Aa00j14s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Aa00j14s01 table.
	 * 
	 * @param aa00j14s01
	 *            Aa00j14s01
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Aa00j14s01 aa00j14s01) {
		Aa00j14s01DaoImpl.logger.info("Método findAllCount");
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA00J14S01 t1 , AA00J13S01 t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa00j14s01);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CREC14= t2.CREC13(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j14s01DaoImpl.logger.info("SQL " + query);
		Aa00j14s01DaoImpl.logger.info("PARAMS" + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Aa00j14s01 table using like.
	 * 
	 * @param aa00j14s01
	 *            Aa00j14s01
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Aa00j14s01 aa00j14s01, Boolean startsWith) {
		Aa00j14s01DaoImpl.logger.info("Método findAllLikeCount");
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA00J14S01 t1 ,AA00J13S01 t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa00j14s01, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CREC14= t2.CREC13(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j14s01DaoImpl.logger.info("SQL " + query);
		Aa00j14s01DaoImpl.logger.info("PARAMS" + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Aa00j14s01 selected for rup_table
	 * 
	 * @param aa00j14s01
	 *            Aa00j14s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j14s01>>
	 */
	@Override
	public List<TableRowDto<Aa00j14s01>> reorderSelection(
			Aa00j14s01 aa00j14s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		Aa00j14s01DaoImpl.logger.info("Método reorderSelection");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.COD14 COD14,t1.SIT14 SIT14,t1.CARC14 CARC14,t1.CARE14 CARE14,t2.CREC13 AA00J13S01CREC13,t2.SIT13 AA00J13S01SIT13,t2.BLOQ13 AA00J13S01BLOQ13,t2.NOMC13 AA00J13S01NOMC13,t2.DESCC13 AA00J13S01DESCC13,t2.NOME13 AA00J13S01NOME13,t2.DESCE13 AA00J13S01DESCE13,t2.SWDISP13 AA00J13S01SWDISP13,t2.CDEP13 AA00J13S01CDEP13,t2.USUB13 AA00J13S01USUB13,t2.CEDIF13 AA00J13S01CEDIF13,t2.CREST13 AA00J13S01CREST13 ");
		// FROM
		query.append("FROM AA00J14S01 t1 ,AA00J13S01 t2 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa00j14s01, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CREC14= t2.CREC13(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, Aa00j14s01.class, filterParamList,
				"COD14");
		Aa00j14s01DaoImpl.logger.info("SQL " + sbReorderSelectionSQL);
		Aa00j14s01DaoImpl.logger.info("PARAMS" + filterParamList);
		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa00j14s01>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * @param filterParams
	 *            Aa00j14s01
	 * @param searchParams
	 *            Aa00j14s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j14s01>>
	 */
	@Override
	public List<TableRowDto<Aa00j14s01>> search(Aa00j14s01 filterParams,
			Aa00j14s01 searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		Aa00j14s01DaoImpl.logger.info("Método search");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.COD14 COD14,t1.SIT14 SIT14,t1.CARC14 CARC14,t1.CARE14 CARE14,t2.CREC13 AA00J13S01CREC13,t2.SIT13 AA00J13S01SIT13,t2.BLOQ13 AA00J13S01BLOQ13,t2.NOMC13 AA00J13S01NOMC13,t2.DESCC13 AA00J13S01DESCC13,t2.NOME13 AA00J13S01NOME13,t2.DESCE13 AA00J13S01DESCE13,t2.SWDISP13 AA00J13S01SWDISP13,t2.CDEP13 AA00J13S01CDEP13,t2.USUB13 AA00J13S01USUB13,t2.CEDIF13 AA00J13S01CEDIF13,t2.CREST13 AA00J13S01CREST13 ");
		// FROM
		query.append("FROM AA00J14S01 t1 ,AA00J13S01 t2 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CREC14= t2.CREC13(+) ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, Aa00j14s01.class, filterParamList,
				searchSQL, searchParamList, from_alias, "COD14");
		Aa00j14s01DaoImpl.logger.info("SQL " + sbReorderSelectionSQL);
		Aa00j14s01DaoImpl.logger.info("PARAMS" + filterParamList);
		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa00j14s01>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 * 
	 * @param filteraa00j14s01
	 *            Aa00j14s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Aa00j14s01 filteraa00j14s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		Aa00j14s01DaoImpl.logger.info("Método removeMultiple");
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.COD14 COD14,t1.SIT14 SIT14,t1.CARC14 CARC14,t1.CARE14 CARE14,t2.CREC13 AA00J13S01CREC13,t2.SIT13 AA00J13S01SIT13,t2.BLOQ13 AA00J13S01BLOQ13,t2.NOMC13 AA00J13S01NOMC13,t2.DESCC13 AA00J13S01DESCC13,t2.NOME13 AA00J13S01NOME13,t2.DESCE13 AA00J13S01DESCE13,t2.SWDISP13 AA00J13S01SWDISP13,t2.CDEP13 AA00J13S01CDEP13,t2.USUB13 AA00J13S01USUB13,t2.CEDIF13 AA00J13S01CEDIF13,t2.CREST13 AA00J13S01CREST13 ");
		// FROM
		query.append("FROM AA00J14S01 t1 ,AA00J13S01 t2 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filteraa00j14s01,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto, Aa00j14s01.class,
						query, params, "COD14");
		Aa00j14s01DaoImpl.logger.info("SQL " + sbRemoveMultipleSQL);
		Aa00j14s01DaoImpl.logger.info("PARAMS" + params);
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical Aa00j14s01 table.
	 * 
	 * @param filterAa00j14s01
	 *            Aa00j14s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Aa00j14s01>>
	 */
	@Override
	public List<JerarquiaDto<Aa00j14s01>> findAllLikeJerarquia(
			Aa00j14s01 filterAa00j14s01, JQGridRequestDto jqGridRequestDto) {
		Aa00j14s01DaoImpl.logger.info("Método findAllLikeJerarquia");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.COD14 COD14,t1.SIT14 SIT14,t1.CARC14 CARC14,t1.CARE14 CARE14,t2.CREC13 AA00J13S01CREC13,t2.SIT13 AA00J13S01SIT13,t2.BLOQ13 AA00J13S01BLOQ13,t2.NOMC13 AA00J13S01NOMC13,t2.DESCC13 AA00J13S01DESCC13,t2.NOME13 AA00J13S01NOME13,t2.DESCE13 AA00J13S01DESCE13,t2.SWDISP13 AA00J13S01SWDISP13,t2.CDEP13 AA00J13S01CDEP13,t2.USUB13 AA00J13S01USUB13,t2.CEDIF13 AA00J13S01CEDIF13,t2.CREST13 AA00J13S01CREST13 ");
		// FROM
		// StringBuilder from = new
		// StringBuilder("FROM AA00J14S01 t1 ,AA00J13S01 t2 ");
		List<String> from = new ArrayList<String>();
		from.add("AA00J14S01");
		from.add("AA00J13S01");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa00j14s01, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
				mapaWhere, "COD14", "ID_PADRE", "NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j14s01DaoImpl.logger.info("SQL " + query);
		Aa00j14s01DaoImpl.logger.info("PARAMS" + params);
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAa00j14s01
	 *            Aa00j14s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Aa00j14s01 filterAa00j14s01,
			JQGridRequestDto jqGridRequestDto) {
		Aa00j14s01DaoImpl.logger.info("Método findAllLikeCountJerarquia");
		// FROM
		// StringBuilder from = new
		// StringBuilder("FROM AA00J14S01 t1 ,AA00J13S01 t2 ");
		List<String> from = new ArrayList<String>();
		from.add("AA00J14S01");
		from.add("AA00J13S01");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa00j14s01, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(
				jqGridRequestDto, mapaWhere, "COD14", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j14s01DaoImpl.logger.info("SQL " + query);
		Aa00j14s01DaoImpl.logger.info("PARAMS" + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAa00j14s01
	 *            Aa00j14s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Aa00j14s01>>
	 */
	@Override
	public List<TableRowDto<Aa00j14s01>> findAllChild(
			Aa00j14s01 filterAa00j14s01, JQGridRequestDto jqGridRequestDto) {
		Aa00j14s01DaoImpl.logger.info("Método findAllChild");
		// FROM
		// StringBuilder from = new
		// StringBuilder("FROM AA00J14S01 t1 ,AA00J13S01 t2 ");
		List<String> from = new ArrayList<String>();
		from.add("AA00J14S01");
		from.add("AA00J13S01");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa00j14s01, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(
				jqGridRequestDto, mapaWhere, "COD14", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j14s01DaoImpl.logger.info("SQL " + query);
		Aa00j14s01DaoImpl.logger.info("PARAMS" + params);
		return this.jdbcTemplate
				.query(query.toString(),
						new RowNumResultSetExtractor<Aa00j14s01>(this.rwMapPK,
								"COD14"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa00j14s01 entity
	 * 
	 * @param aa00j14s01
	 *            Aa00j14s01 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Aa00j14s01 aa00j14s01) {

		StringBuilder where = new StringBuilder(
				Aa00j14s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa00j14s01 != null && aa00j14s01.getCod14() != null) {
			where.append(" AND t1.COD14 = ?");
			params.add(aa00j14s01.getCod14());
		}
		if (aa00j14s01 != null && aa00j14s01.getAa00j13s01() != null
				&& aa00j14s01.getAa00j13s01().getCrec13() != null) {
			where.append(" AND t2.CREC13 = ?");
			params.add(aa00j14s01.getAa00j13s01().getCrec13());
		}
		if (aa00j14s01 != null
				&& aa00j14s01.getAa00j13s01() != null
				&& aa00j14s01.getAa00j13s01().getAa00j03s01() != null
				&& aa00j14s01.getAa00j13s01().getAa00j03s01().getCedif03() != null) {
			where.append(" AND t2.CEDIF13 = ?");
			params.add(aa00j14s01.getAa00j13s01().getAa00j03s01().getCedif03());
		}
		if (aa00j14s01 != null
				&& aa00j14s01.getAa00j13s01() != null
				&& aa00j14s01.getAa00j13s01().getAa00j06s01() != null
				&& aa00j14s01.getAa00j13s01().getAa00j06s01().getCrest06() != null) {
			where.append(" AND t2.CREST13 = ?");
			params.add(aa00j14s01.getAa00j13s01().getAa00j06s01().getCrest06());
		}
		if (aa00j14s01 != null && aa00j14s01.getAa00j13s01() != null
				&& aa00j14s01.getAa00j13s01().getSit13() != null) {
			where.append(" AND t2.SIT13 = ?");
			params.add(aa00j14s01.getAa00j13s01().getSit13());
		}
		if (aa00j14s01 != null && aa00j14s01.getAa00j13s01() != null
				&& aa00j14s01.getAa00j13s01().getBloq13() != null) {
			where.append(" AND t2.BLOQ13 = ?");
			params.add(aa00j14s01.getAa00j13s01().getBloq13());
		}
		if (aa00j14s01 != null && aa00j14s01.getAa00j13s01() != null
				&& aa00j14s01.getAa00j13s01().getNomc13() != null) {
			where.append(" AND t2.NOMC13 = ?");
			params.add(aa00j14s01.getAa00j13s01().getNomc13());
		}
		if (aa00j14s01 != null && aa00j14s01.getAa00j13s01() != null
				&& aa00j14s01.getAa00j13s01().getDescc13() != null) {
			where.append(" AND t2.DESCC13 = ?");
			params.add(aa00j14s01.getAa00j13s01().getDescc13());
		}
		if (aa00j14s01 != null && aa00j14s01.getAa00j13s01() != null
				&& aa00j14s01.getAa00j13s01().getNome13() != null) {
			where.append(" AND t2.NOME13 = ?");
			params.add(aa00j14s01.getAa00j13s01().getNome13());
		}
		if (aa00j14s01 != null && aa00j14s01.getAa00j13s01() != null
				&& aa00j14s01.getAa00j13s01().getDesce13() != null) {
			where.append(" AND t2.DESCE13 = ?");
			params.add(aa00j14s01.getAa00j13s01().getDesce13());
		}
		if (aa00j14s01 != null && aa00j14s01.getAa00j13s01() != null
				&& aa00j14s01.getAa00j13s01().getSwdisp13() != null) {
			where.append(" AND t2.SWDISP13 = ?");
			params.add(aa00j14s01.getAa00j13s01().getSwdisp13());
		}
		if (aa00j14s01 != null
				&& aa00j14s01.getAa00j13s01() != null
				&& aa00j14s01.getAa00j13s01().getAa00j07s01() != null
				&& aa00j14s01.getAa00j13s01().getAa00j07s01().getCdep07() != null) {
			where.append(" AND t2.CDEP13 = ?");
			params.add(aa00j14s01.getAa00j13s01().getAa00j07s01().getCdep07());
		}
		if (aa00j14s01 != null && aa00j14s01.getAa00j13s01() != null
				&& aa00j14s01.getAa00j13s01().getUsub13() != null) {
			where.append(" AND t2.USUB13 = ?");
			params.add(aa00j14s01.getAa00j13s01().getUsub13());
		}
		if (aa00j14s01 != null && aa00j14s01.getSit14() != null) {
			where.append(" AND t1.SIT14 = ?");
			params.add(aa00j14s01.getSit14());
		}
		if (aa00j14s01 != null && aa00j14s01.getCarc14() != null) {
			where.append(" AND t1.CARC14 = ?");
			params.add(aa00j14s01.getCarc14());
		}
		if (aa00j14s01 != null && aa00j14s01.getCare14() != null) {
			where.append(" AND t1.CARE14 = ?");
			params.add(aa00j14s01.getCare14());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa00j14s01 entity
	 * 
	 * @param aa00j14s01
	 *            Aa00j14s01 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Aa00j14s01 aa00j14s01,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				Aa00j14s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa00j14s01 != null && aa00j14s01.getCod14() != null) {
			where.append(" AND t1.COD14 = ?");
			params.add(aa00j14s01.getCod14());
		}
		if (aa00j14s01 != null && aa00j14s01.getAa00j13s01() != null
				&& aa00j14s01.getAa00j13s01().getCrec13() != null) {
			where.append(" AND t2.CREC13 = ?");
			params.add(aa00j14s01.getAa00j13s01().getCrec13());
		}
		if (aa00j14s01 != null
				&& aa00j14s01.getAa00j13s01() != null
				&& aa00j14s01.getAa00j13s01().getAa00j03s01() != null
				&& aa00j14s01.getAa00j13s01().getAa00j03s01().getCedif03() != null) {
			where.append(" AND t2.CEDIF13 = ?");
			params.add(aa00j14s01.getAa00j13s01().getAa00j03s01().getCedif03());
		}
		if (aa00j14s01 != null
				&& aa00j14s01.getAa00j13s01() != null
				&& aa00j14s01.getAa00j13s01().getAa00j06s01() != null
				&& aa00j14s01.getAa00j13s01().getAa00j06s01().getCrest06() != null) {
			where.append(" AND t2.CREST13 = ?");
			params.add(aa00j14s01.getAa00j13s01().getAa00j06s01().getCrest06());
		}
		if (aa00j14s01 != null && aa00j14s01.getAa00j13s01() != null
				&& aa00j14s01.getAa00j13s01().getSit13() != null) {
			where.append(" AND UPPER(t2.SIT13) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j14s01.getAa00j13s01().getSit13().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j14s01.getAa00j13s01().getSit13().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.SIT13 IS NOT NULL");
		}
		if (aa00j14s01 != null && aa00j14s01.getAa00j13s01() != null
				&& aa00j14s01.getAa00j13s01().getBloq13() != null) {
			where.append(" AND t2.BLOQ13 = ?");
			params.add(aa00j14s01.getAa00j13s01().getBloq13());
		}
		if (aa00j14s01 != null && aa00j14s01.getAa00j13s01() != null
				&& aa00j14s01.getAa00j13s01().getNomc13() != null) {
			where.append(" AND UPPER(t2.NOMC13) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j14s01.getAa00j13s01().getNomc13().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j14s01.getAa00j13s01().getNomc13().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.NOMC13 IS NOT NULL");
		}
		if (aa00j14s01 != null && aa00j14s01.getAa00j13s01() != null
				&& aa00j14s01.getAa00j13s01().getDescc13() != null) {
			where.append(" AND UPPER(t2.DESCC13) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j14s01.getAa00j13s01().getDescc13()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j14s01.getAa00j13s01().getDescc13().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.DESCC13 IS NOT NULL");
		}
		if (aa00j14s01 != null && aa00j14s01.getAa00j13s01() != null
				&& aa00j14s01.getAa00j13s01().getNome13() != null) {
			where.append(" AND UPPER(t2.NOME13) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j14s01.getAa00j13s01().getNome13().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j14s01.getAa00j13s01().getNome13().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.NOME13 IS NOT NULL");
		}
		if (aa00j14s01 != null && aa00j14s01.getAa00j13s01() != null
				&& aa00j14s01.getAa00j13s01().getDesce13() != null) {
			where.append(" AND UPPER(t2.DESCE13) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j14s01.getAa00j13s01().getDesce13()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j14s01.getAa00j13s01().getDesce13().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.DESCE13 IS NOT NULL");
		}
		if (aa00j14s01 != null && aa00j14s01.getAa00j13s01() != null
				&& aa00j14s01.getAa00j13s01().getSwdisp13() != null) {
			where.append(" AND t2.SWDISP13 = ?");
			params.add(aa00j14s01.getAa00j13s01().getSwdisp13());
		}
		if (aa00j14s01 != null
				&& aa00j14s01.getAa00j13s01() != null
				&& aa00j14s01.getAa00j13s01().getAa00j07s01() != null
				&& aa00j14s01.getAa00j13s01().getAa00j07s01().getCdep07() != null) {
			where.append(" AND t2.CDEP13 = ?");
			params.add(aa00j14s01.getAa00j13s01().getAa00j07s01().getCdep07());
		}
		if (aa00j14s01 != null && aa00j14s01.getAa00j13s01() != null
				&& aa00j14s01.getAa00j13s01().getUsub13() != null) {
			where.append(" AND UPPER(t2.USUB13) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j14s01.getAa00j13s01().getUsub13().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j14s01.getAa00j13s01().getUsub13().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.USUB13 IS NOT NULL");
		}
		if (aa00j14s01 != null && aa00j14s01.getSit14() != null) {
			where.append(" AND UPPER(t1.SIT14) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j14s01.getSit14().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j14s01.getSit14().toUpperCase() + "%");
			}
			where.append(" AND t1.SIT14 IS NOT NULL");
		}
		if (aa00j14s01 != null && aa00j14s01.getCarc14() != null) {
			where.append(" AND UPPER(t1.CARC14) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j14s01.getCarc14().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j14s01.getCarc14().toUpperCase() + "%");
			}
			where.append(" AND t1.CARC14 IS NOT NULL");
		}
		if (aa00j14s01 != null && aa00j14s01.getCare14() != null) {
			where.append(" AND UPPER(t1.CARE14) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j14s01.getCare14().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j14s01.getCare14().toUpperCase() + "%");
			}
			where.append(" AND t1.CARE14 IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	public void addMultiple(List<Aa00j14s01> aa00j14s01) {
		for (Aa00j14s01 o : aa00j14s01) {
			this.add(o);
		}
	}

	public void removeRecurso(Long crec14) {
		Aa00j14s01DaoImpl.logger.info("Método removeRecurso");
		String query = "DELETE FROM AA00J14S01 WHERE CREC14=?";
		Aa00j14s01DaoImpl.logger.info("SQL " + query);
		Aa00j14s01DaoImpl.logger.info("PARAM1" + crec14);
		this.jdbcTemplate.update(query, crec14);
	}

	public List<Aa00j14s01> obtenerCaracteristicasRecurso(Long crec14) {
		Aa00j14s01DaoImpl.logger.info("Método obtenerCaracteristicasRecurso");
		StringBuilder query = new StringBuilder(
				"SELECT t1.COD14 COD14,t1.SIT14 SIT14,t1.CREC14 CREC14,t1.CARC14 CARC14,t1.CARE14 CARE14 ");
		query.append("FROM AA00J14S01 t1 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.CREC14=? ");
		query.append(where);

		List<Object> params = new ArrayList<Object>();
		params.add(crec14);
		Aa00j14s01DaoImpl.logger.info("SQL " + query);
		Aa00j14s01DaoImpl.logger.info("PARAMS" + params);
		return (List<Aa00j14s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMapCombo, params.toArray());
	}
}