package com.ejie.aa00j.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import weblogic.utils.StringUtils;

import com.ejie.aa00j.classes.aa00jConstantes;
import com.ejie.aa00j.model.Aa00j02s01;
import com.ejie.aa00j.model.Aa00j03s01;
import com.ejie.aa00j.model.Aa00j06s01;
import com.ejie.aa00j.model.Aa00j07s01;
import com.ejie.aa00j.model.Aa00j13s01;
import com.ejie.aa00j.model.Option;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa00j13s01DaoImpl generated by UDA, 16-oct-2013 13:02:12.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class Aa00j13s01DaoImpl implements Aa00j13s01Dao {
	private JdbcTemplate jdbcTemplate;
	private static final Logger logger = LoggerFactory
			.getLogger(Aa00j13s01DaoImpl.class);
	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Aa00j13s01> rwMap = new RowMapper<Aa00j13s01>() {
		public Aa00j13s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa00j13s01(resultSet.getLong("CREC13"),
					resultSet.getString("SIT13"), resultSet.getInt("BLOQ13"),
					resultSet.getString("NOMC13"),
					resultSet.getString("DESCC13"),
					resultSet.getString("NOME13"),
					resultSet.getString("DESCE13"),
					resultSet.getInt("SWDISP13"),
					resultSet.getString("USUB13"), new Aa00j03s01(
							resultSet.getLong("Aa00j03s01CEDIF03"),
							resultSet.getString("Aa00j03s01NOMBRE03"),
							resultSet.getString("Aa00j03s01SIT03"),
							resultSet.getInt("Aa00j03s01BLOQ03"),
							resultSet.getString("Aa00j03s01TLFNO03"),
							resultSet.getString("Aa00j03s01USUB03"),
							new Aa00j02s01(resultSet
									.getLong("Aa00j03s01CSITIO03"), null, null,
									null, null, null)), new Aa00j06s01(
							resultSet.getLong("Aa00j06s01CREST06"),
							resultSet.getString("Aa00j06s01DESCC06"),
							resultSet.getString("Aa00j06s01DESCE06"),
							resultSet.getString("Aa00j06s01SIT06"),
							resultSet.getInt("Aa00j06s01BLOQ06"),
							resultSet.getString("Aa00j06s01MENC06"),
							resultSet.getString("Aa00j06s01MENE06"),
							resultSet.getString("Aa00j06s01USUB06")),
					new Aa00j07s01(resultSet.getLong("Aa00j07s01CDEP07"),
							resultSet.getString("Aa00j07s01DESCC07"), resultSet
									.getString("Aa00j07s01DESCE07"), resultSet
									.getString("Aa00j07s01SIT07"), resultSet
									.getInt("Aa00j07s01BLOQ07"), resultSet
									.getString("Aa00j07s01USUB07"), resultSet
									.getString("Aa00j07s01COD_XLNET_07")));
		}
	};

	private RowMapper<Aa00j13s01> rwMapPK = new RowMapper<Aa00j13s01>() {
		public Aa00j13s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa00j13s01(resultSet.getLong("CREC13"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Aa00j13s01>> rwMapJerarquia = new RowMapper<JerarquiaDto<Aa00j13s01>>() {
		public JerarquiaDto<Aa00j13s01> mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Aa00j13s01 aa00j13s01 = new Aa00j13s01(resultSet.getLong("CREC13"),
					resultSet.getString("SIT13"), resultSet.getInt("BLOQ13"),
					resultSet.getString("NOMC13"),
					resultSet.getString("DESCC13"),
					resultSet.getString("NOME13"),
					resultSet.getString("DESCE13"),
					resultSet.getInt("SWDISP13"),
					resultSet.getString("USUB13"), new Aa00j03s01(
							resultSet.getLong("Aa00j03s01CEDIF03"),
							resultSet.getString("Aa00j03s01NOMBRE03"),
							resultSet.getString("Aa00j03s01SIT03"),
							resultSet.getInt("Aa00j03s01BLOQ03"),
							resultSet.getString("Aa00j03s01TLFNO03"),
							resultSet.getString("Aa00j03s01USUB03"),
							new Aa00j02s01(resultSet
									.getLong("Aa00j03s01CSITIO03"), null, null,
									null, null, null)), new Aa00j06s01(
							resultSet.getLong("Aa00j06s01CREST06"),
							resultSet.getString("Aa00j06s01DESCC06"),
							resultSet.getString("Aa00j06s01DESCE06"),
							resultSet.getString("Aa00j06s01SIT06"),
							resultSet.getInt("Aa00j06s01BLOQ06"),
							resultSet.getString("Aa00j06s01MENC06"),
							resultSet.getString("Aa00j06s01MENE06"),
							resultSet.getString("Aa00j06s01USUB06")),
					new Aa00j07s01(resultSet.getLong("Aa00j07s01CDEP07"),
							resultSet.getString("Aa00j07s01DESCC07"), resultSet
									.getString("Aa00j07s01DESCE07"), resultSet
									.getString("Aa00j07s01SIT07"), resultSet
									.getInt("Aa00j07s01BLOQ07"), resultSet
									.getString("Aa00j07s01USUB07"), resultSet
									.getString("Aa00j07s01COD_XLNET_07")));

			JerarquiaDto<Aa00j13s01> jerarquia = new JerarquiaDto<Aa00j13s01>();
			jerarquia.setModel(aa00j13s01);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet
					.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet
					.getString("FILTER")));
			return jerarquia;
		}
	};

	private RowMapper<Aa00j13s01> rwMapCombo = new RowMapper<Aa00j13s01>() {
		public Aa00j13s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa00j13s01(resultSet.getLong("CREC13"), "", 0,
					resultSet.getString("NOMC13"), "",
					resultSet.getString("NOME13"), "", 0, "", null, null, null);
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Aa00j13s01 table.
	 * 
	 * @param aa00j13s01
	 *            Aa00j13s01
	 * @return Aa00j13s01
	 */
	public Aa00j13s01 add(final Aa00j13s01 aa00j13s01) {
		if (aa00j13s01.getSit13() == null
				|| aa00j13s01.getSit13().length() == 0)
			aa00j13s01.setSit13(aa00jConstantes.SITUACION_ALTA);
		Aa00j13s01DaoImpl.logger.info("Método add");
		final String queryUltimoId = "(SELECT NVL(MAX(TO_NUMBER(CREC13)), 0) + 1 FROM AA00J13S01)";
		final String query = "INSERT INTO AA00J13S01 (CREC13, CEDIF13, CREST13, SIT13, BLOQ13, NOMC13, DESCC13, NOME13, DESCE13, SWDISP13, CDEP13, USUB13) VALUES ("
				+ queryUltimoId + ",?,?,?,?,?,?,?,?,?,?,?)";
		final Object getAa00j03s01Cedif03Aux;
		if (aa00j13s01.getAa00j03s01() != null
				&& aa00j13s01.getAa00j03s01().getCedif03() != null) {
			getAa00j03s01Cedif03Aux = aa00j13s01.getAa00j03s01().getCedif03();
		} else {
			getAa00j03s01Cedif03Aux = null;
		}
		final Object getAa00j06s01Crest06Aux;
		if (aa00j13s01.getAa00j06s01() != null
				&& aa00j13s01.getAa00j06s01().getCrest06() != null) {
			getAa00j06s01Crest06Aux = aa00j13s01.getAa00j06s01().getCrest06();
		} else {
			getAa00j06s01Crest06Aux = null;
		}
		final Object getAa00j07s01Cdep07Aux;
		if (aa00j13s01.getAa00j07s01() != null
				&& aa00j13s01.getAa00j07s01().getCdep07() != null) {
			getAa00j07s01Cdep07Aux = aa00j13s01.getAa00j07s01().getCdep07();
		} else {
			getAa00j07s01Cdep07Aux = null;
		}

		KeyHolder keyHolder = new GeneratedKeyHolder();
		Aa00j13s01DaoImpl.logger.info("SQL " + query);
		Aa00j13s01DaoImpl.logger.info("PARAM1 " + getAa00j03s01Cedif03Aux);
		Aa00j13s01DaoImpl.logger.info("PARAM2 " + getAa00j06s01Crest06Aux);
		Aa00j13s01DaoImpl.logger.info("PARAM3 " + aa00j13s01.getSit13());
		Aa00j13s01DaoImpl.logger.info("PARAM4  " + 0);
		Aa00j13s01DaoImpl.logger.info("PARAM5  " + aa00j13s01.getNomc13());
		Aa00j13s01DaoImpl.logger.info("PARAM6  " + aa00j13s01.getDescc13());
		Aa00j13s01DaoImpl.logger.info("PARAM7  " + aa00j13s01.getNome13());
		Aa00j13s01DaoImpl.logger.info("PARAM8  " + aa00j13s01.getDesce13());
		Aa00j13s01DaoImpl.logger.info("PARAM9  " + aa00j13s01.getSwdisp13());
		Aa00j13s01DaoImpl.logger.info("PARAM10  " + getAa00j07s01Cdep07Aux);
		Aa00j13s01DaoImpl.logger.info("PARAM11 " + null);

		jdbcTemplate.update(new PreparedStatementCreator() {
			public PreparedStatement createPreparedStatement(
					Connection connection) throws SQLException {
				PreparedStatement ps = connection.prepareStatement(query,
						new String[] { "CREC13" });
				ps.setObject(1, getAa00j03s01Cedif03Aux);
				ps.setObject(2, getAa00j06s01Crest06Aux);
				ps.setObject(3, aa00j13s01.getSit13());
				ps.setObject(4, 0);
				ps.setObject(5, aa00j13s01.getNomc13());
				ps.setObject(6, aa00j13s01.getDescc13());
				ps.setObject(7, aa00j13s01.getNome13());
				ps.setObject(8, aa00j13s01.getDesce13());
				ps.setObject(9, aa00j13s01.getSwdisp13());
				ps.setObject(10, getAa00j07s01Cdep07Aux);
				ps.setObject(11, null);
				return ps;
			}
		}, keyHolder);

		aa00j13s01.setCrec13(keyHolder.getKey().longValue());

		return aa00j13s01;
	}

	/**
	 * Updates a single row in the Aa00j13s01 table.
	 * 
	 * @param aa00j13s01
	 *            Aa00j13s01
	 * @return Aa00j13s01
	 */
	public Aa00j13s01 update(Aa00j13s01 aa00j13s01) {
		if (aa00j13s01.getSit13() == null
				|| aa00j13s01.getSit13().length() == 0)
			aa00j13s01.setSit13(aa00jConstantes.SITUACION_ALTA);
		Aa00j13s01DaoImpl.logger.info("Método update");
		String query = "UPDATE AA00J13S01 SET CEDIF13=?, CREST13=?, SIT13=?, BLOQ13=?, NOMC13=?, DESCC13=?, NOME13=?, DESCE13=?, SWDISP13=?, CDEP13=?, USUB13=? WHERE CREC13=?";
		Object getAa00j03s01Cedif03Aux = null;
		if (aa00j13s01.getAa00j03s01() != null
				&& aa00j13s01.getAa00j03s01().getCedif03() != null) {
			getAa00j03s01Cedif03Aux = aa00j13s01.getAa00j03s01().getCedif03();
		}
		Object getAa00j06s01Crest06Aux = null;
		if (aa00j13s01.getAa00j06s01() != null
				&& aa00j13s01.getAa00j06s01().getCrest06() != null) {
			getAa00j06s01Crest06Aux = aa00j13s01.getAa00j06s01().getCrest06();
		}
		Object getAa00j07s01Cdep07Aux = null;
		if (aa00j13s01.getAa00j07s01() != null
				&& aa00j13s01.getAa00j07s01().getCdep07() != null) {
			getAa00j07s01Cdep07Aux = aa00j13s01.getAa00j07s01().getCdep07();
		}

		Aa00j13s01DaoImpl.logger.info("SQL " + query);
		Aa00j13s01DaoImpl.logger.info("PARAM1 " + getAa00j03s01Cedif03Aux);
		Aa00j13s01DaoImpl.logger.info("PARAM2 " + getAa00j06s01Crest06Aux);
		Aa00j13s01DaoImpl.logger.info("PARAM3 " + aa00j13s01.getSit13());
		Aa00j13s01DaoImpl.logger.info("PARAM4  " + aa00j13s01.getBloq13());
		Aa00j13s01DaoImpl.logger.info("PARAM5  " + aa00j13s01.getNomc13());
		Aa00j13s01DaoImpl.logger.info("PARAM6  " + aa00j13s01.getDescc13());
		Aa00j13s01DaoImpl.logger.info("PARAM7  " + aa00j13s01.getNome13());
		Aa00j13s01DaoImpl.logger.info("PARAM8  " + aa00j13s01.getDesce13());
		Aa00j13s01DaoImpl.logger.info("PARAM9  " + aa00j13s01.getSwdisp13());
		Aa00j13s01DaoImpl.logger.info("PARAM10  " + getAa00j07s01Cdep07Aux);
		Aa00j13s01DaoImpl.logger.info("PARAM11 " + aa00j13s01.getUsub13());
		Aa00j13s01DaoImpl.logger.info("PARAM12 " + aa00j13s01.getCrec13());
		this.jdbcTemplate.update(query, getAa00j03s01Cedif03Aux,
				getAa00j06s01Crest06Aux, aa00j13s01.getSit13(),
				aa00j13s01.getBloq13(), aa00j13s01.getNomc13(),
				aa00j13s01.getDescc13(), aa00j13s01.getNome13(),
				aa00j13s01.getDesce13(), aa00j13s01.getSwdisp13(),
				getAa00j07s01Cdep07Aux, aa00j13s01.getUsub13(),
				aa00j13s01.getCrec13());
		return aa00j13s01;
	}

	/**
	 * Finds a single row in the Aa00j13s01 table.
	 * 
	 * @param aa00j13s01
	 *            Aa00j13s01
	 * @return Aa00j13s01
	 */
	@Transactional(readOnly = true)
	public Aa00j13s01 find(Aa00j13s01 aa00j13s01) {
		Aa00j13s01DaoImpl.logger.info("Método find");
		String query = "SELECT t1.CREC13 CREC13, t1.SIT13 SIT13, t1.BLOQ13 BLOQ13, t1.NOMC13 NOMC13, "
				+ "t1.DESCC13 DESCC13, t1.NOME13 NOME13, t1.DESCE13 DESCE13, t1.SWDISP13 SWDISP13, "
				+ "t1.USUB13 USUB13, t2.CEDIF03 AA00J03S01CEDIF03, "
				+ "t2.NOMBRE03 AA00J03S01NOMBRE03, t2.SIT03 AA00J03S01SIT03, t2.BLOQ03 AA00J03S01BLOQ03, "
				+ "t2.TLFNO03 AA00J03S01TLFNO03, t2.USUB03 AA00J03S01USUB03, "
				+ "t3.CREST06 AA00J06S01CREST06, "
				+ "t3.DESCC06 AA00J06S01DESCC06, t3.DESCE06 AA00J06S01DESCE06, t3.SIT06 AA00J06S01SIT06, "
				+ "t3.BLOQ06 AA00J06S01BLOQ06, t3.MENC06 AA00J06S01MENC06, t3.MENE06 AA00J06S01MENE06, "
				+ "t3.USUB06 AA00J06S01USUB06, t2.CSITIO03 AA00J03S01CSITIO03, "
				+ "t4.CDEP07 AA00J07S01CDEP07, "
				+ "t4.DESCC07 AA00J07S01DESCC07, t4.DESCE07 AA00J07S01DESCE07, t4.SIT07 AA00J07S01SIT07, "
				+ "t4.BLOQ07 AA00J07S01BLOQ07, t4.USUB07 AA00J07S01USUB07, t4.COD_XLNET_07 AA00J07S01COD_XLNET_07 "
				+ "FROM AA00J13S01 t1 , AA00J03S01 t2 , AA00J06S01 t3 , AA00J07S01 t4  "
				+ "WHERE t1.CREC13 = ? "
				+ "AND t1.CEDIF13= t2.CEDIF03(+) "
				+ "AND t1.CREST13= t3.CREST06(+)"
				+ "AND t1.CDEP13= t4.CDEP07(+)";
		Aa00j13s01DaoImpl.logger.info("SQL " + query);
		Aa00j13s01DaoImpl.logger.info("PARAM1 " + aa00j13s01.getCrec13());
		List<Aa00j13s01> aa00j13s01List = this.jdbcTemplate.query(query,
				this.rwMap, aa00j13s01.getCrec13());
		return (Aa00j13s01) DataAccessUtils.uniqueResult(aa00j13s01List);
	}

	/**
	 * Removes a single row in the Aa00j13s01 table.
	 * 
	 * @param aa00j13s01
	 *            Aa00j13s01
	 * @return
	 */
	public void remove(Aa00j13s01 aa00j13s01) {
		Aa00j13s01DaoImpl.logger.info("Método remove");
		String query = "DELETE FROM AA00J13S01 WHERE CREC13=?";
		Aa00j13s01DaoImpl.logger.info("SQL " + query);
		Aa00j13s01DaoImpl.logger.info("PARAM1 " + aa00j13s01.getCrec13());
		this.jdbcTemplate.update(query, aa00j13s01.getCrec13());
	}

	/**
	 * Finds a list of rows in the Aa00j13s01 table.
	 * 
	 * @param aa00j13s01
	 *            Aa00j13s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa00j13s01>
	 */
	@Transactional(readOnly = true)
	public List<Aa00j13s01> findAll(Aa00j13s01 aa00j13s01,
			JQGridRequestDto jqGridRequestDto) {
		Aa00j13s01DaoImpl.logger.info("Método findAll");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CREC13 CREC13,t1.SIT13 SIT13,t1.BLOQ13 BLOQ13,t1.NOMC13 NOMC13,t1.DESCC13 DESCC13,"
						+ "t1.NOME13 NOME13,t1.DESCE13 DESCE13,t1.SWDISP13 SWDISP13,t1.USUB13 USUB13,"
						+ "t2.CEDIF03 AA00J03S01CEDIF03,t2.NOMBRE03 AA00J03S01NOMBRE03,t2.SIT03 AA00J03S01SIT03,"
						+ "t2.BLOQ03 AA00J03S01BLOQ03,t2.TLFNO03 AA00J03S01TLFNO03,t2.USUB03 AA00J03S01USUB03,"
						+ "t3.CREST06 AA00J06S01CREST06,t3.DESCC06 AA00J06S01DESCC06,t3.DESCE06 AA00J06S01DESCE06,"
						+ "t3.SIT06 AA00J06S01SIT06,t3.BLOQ06 AA00J06S01BLOQ06,t3.MENC06 AA00J06S01MENC06,"
						+ "t3.MENE06 AA00J06S01MENE06,t3.USUB06 AA00J06S01USUB06,t2.CSITIO03 AA00J03S01CSITIO03, "
						+ "t4.CDEP07 AA00J07S01CDEP07, "
						+ "t4.DESCC07 AA00J07S01DESCC07, t4.DESCE07 AA00J07S01DESCE07, t4.SIT07 AA00J07S01SIT07, "
						+ "t4.BLOQ07 AA00J07S01BLOQ07, t4.USUB07 AA00J07S01USUB07, t4.COD_XLNET_07 AA00J07S01COD_XLNET_07 ");
		query.append("FROM AA00J13S01 t1 ,AA00J03S01 t2 ,AA00J06S01 t3 ,AA00J07S01 t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa00j13s01);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CEDIF13= t2.CEDIF03(+) AND t1.CREST13= t3.CREST06(+) AND t1.CDEP13= t4.CDEP07(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		Aa00j13s01DaoImpl.logger.info("SQL " + query);
		Aa00j13s01DaoImpl.logger.info("PARAMS " + params);
		return (List<Aa00j13s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Aa00j13s01 table using like.
	 * 
	 * @param aa00j13s01
	 *            Aa00j13s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa00j13s01>
	 */
	@Transactional(readOnly = true)
	public List<Aa00j13s01> findAllLike(Aa00j13s01 aa00j13s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		Aa00j13s01DaoImpl.logger.info("Método findAllLike");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CREC13 CREC13,t1.SIT13 SIT13,t1.BLOQ13 BLOQ13,t1.NOMC13 NOMC13,t1.DESCC13 DESCC13,"
						+ "t1.NOME13 NOME13,t1.DESCE13 DESCE13,t1.SWDISP13 SWDISP13,t1.USUB13 USUB13,"
						+ "t2.CEDIF03 AA00J03S01CEDIF03,t2.NOMBRE03 AA00J03S01NOMBRE03,t2.SIT03 AA00J03S01SIT03,"
						+ "t2.BLOQ03 AA00J03S01BLOQ03,t2.TLFNO03 AA00J03S01TLFNO03,t2.USUB03 AA00J03S01USUB03,"
						+ "t3.CREST06 AA00J06S01CREST06,t3.DESCC06 AA00J06S01DESCC06,t3.DESCE06 AA00J06S01DESCE06,"
						+ "t3.SIT06 AA00J06S01SIT06,t3.BLOQ06 AA00J06S01BLOQ06,t3.MENC06 AA00J06S01MENC06,"
						+ "t3.MENE06 AA00J06S01MENE06,t3.USUB06 AA00J06S01USUB06,t2.CSITIO03 AA00J03S01CSITIO03, "
						+ "t4.CDEP07 AA00J07S01CDEP07, "
						+ "t4.DESCC07 AA00J07S01DESCC07, t4.DESCE07 AA00J07S01DESCE07, t4.SIT07 AA00J07S01SIT07, "
						+ "t4.BLOQ07 AA00J07S01BLOQ07, t4.USUB07 AA00J07S01USUB07, t4.COD_XLNET_07 AA00J07S01COD_XLNET_07 ");
		query.append("FROM AA00J13S01 t1 ,AA00J03S01 t2 ,AA00J06S01 t3 ,AA00J07S01 t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa00j13s01, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CEDIF13= t2.CEDIF03(+) AND t1.CREST13= t3.CREST06(+) AND t1.CDEP13= t4.CDEP07(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		// Chapuza para arreglar el jaleo que monta uda:
		// En la clase del modelo las columnas se llaman aa00j10s01.nombre10,
		// por
		// ejemplo, pero en la sql que crea se llama t1.nombre10
		// por lo que al ordenar la tabla no lo hace bien
		// ya que en la tabla hay que poner el nombre que tiene en el modelo
		// lo hago así para tocar lo mínimo posible el resto de la aplicación

		String sql = query.toString();

		sql = StringUtils.replaceGlobal(sql, "aa00j13s01.", "t1.");
		sql = StringUtils.replaceGlobal(sql, "aa00j03s01.", "t2.");
		sql = StringUtils.replaceGlobal(sql, "aa00j06s01.", "t3.");
		sql = StringUtils.replaceGlobal(sql, "aa00j07s01.", "t4.");
		Aa00j13s01DaoImpl.logger.info("SQL " + sql);
		Aa00j13s01DaoImpl.logger.info("PARAMS " + params);
		return (List<Aa00j13s01>) this.jdbcTemplate.query(sql, this.rwMap,
				params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Aa00j13s01 table.
	 * 
	 * @param aa00j13s01
	 *            Aa00j13s01
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Aa00j13s01 aa00j13s01) {
		Aa00j13s01DaoImpl.logger.info("Método findAllCount");
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA00J13S01 t1 , AA00J03S01 t2 , AA00J06S01 t3 , AA00J07S01 t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa00j13s01);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CEDIF13= t2.CEDIF03(+) AND t1.CREST13= t3.CREST06(+) AND t1.CDEP13= t4.CDEP07(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j13s01DaoImpl.logger.info("SQL " + query);
		Aa00j13s01DaoImpl.logger.info("PARAMS " + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Aa00j13s01 table using like.
	 * 
	 * @param aa00j13s01
	 *            Aa00j13s01
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Aa00j13s01 aa00j13s01, Boolean startsWith) {
		Aa00j13s01DaoImpl.logger.info("Método findAllLikeCount");
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA00J13S01 t1 ,AA00J03S01 t2 ,AA00J06S01 t3 , AA00J07S01 t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa00j13s01, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CEDIF13= t2.CEDIF03(+) AND t1.CREST13= t3.CREST06(+) AND t1.CDEP13= t4.CDEP07(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j13s01DaoImpl.logger.info("SQL " + query);
		Aa00j13s01DaoImpl.logger.info("PARAMS " + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Aa00j13s01 selected for rup_table
	 * 
	 * @param aa00j13s01
	 *            Aa00j13s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j13s01>>
	 */
	@Override
	public List<TableRowDto<Aa00j13s01>> reorderSelection(
			Aa00j13s01 aa00j13s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		Aa00j13s01DaoImpl.logger.info("Método reorderSelection");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CREC13 CREC13,t1.SIT13 SIT13,t1.BLOQ13 BLOQ13,t1.NOMC13 NOMC13,t1.DESCC13 DESCC13,"
						+ "t1.NOME13 NOME13,t1.DESCE13 DESCE13,t1.SWDISP13 SWDISP13,t1.USUB13 USUB13,"
						+ "t2.CEDIF03 AA00J03S01CEDIF03,t2.NOMBRE03 AA00J03S01NOMBRE03,t2.SIT03 AA00J03S01SIT03,"
						+ "t2.BLOQ03 AA00J03S01BLOQ03,t2.TLFNO03 AA00J03S01TLFNO03,t2.USUB03 AA00J03S01USUB03,"
						+ "t3.CREST06 AA00J06S01CREST06,t3.DESCC06 AA00J06S01DESCC06,t3.DESCE06 AA00J06S01DESCE06,"
						+ "t3.SIT06 AA00J06S01SIT06,t3.BLOQ06 AA00J06S01BLOQ06,t3.MENC06 AA00J06S01MENC06,"
						+ "t3.MENE06 AA00J06S01MENE06,t3.USUB06 AA00J06S01USUB06,t2.CSITIO03 AA00J03S01CSITIO03, "
						+ "t4.CDEP07 AA00J07S01CDEP07, "
						+ "t4.DESCC07 AA00J07S01DESCC07, t4.DESCE07 AA00J07S01DESCE07, t4.SIT07 AA00J07S01SIT07, "
						+ "t4.BLOQ07 AA00J07S01BLOQ07, t4.USUB07 AA00J07S01USUB07, t4.COD_XLNET_07 AA00J07S01COD_XLNET_07 ");
		// FROM
		query.append("FROM AA00J13S01 t1 ,AA00J03S01 t2 ,AA00J06S01 t3 , AA00J07S01 t4 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa00j13s01, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CEDIF13= t2.CEDIF03(+) AND t1.CREST13= t3.CREST06(+) AND t1.CDEP13= t4.CDEP07(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, Aa00j13s01.class, filterParamList,
				"CREC13");
		Aa00j13s01DaoImpl.logger.info("SQL " + sbReorderSelectionSQL);
		Aa00j13s01DaoImpl.logger.info("PARAMS " + filterParamList);
		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa00j13s01>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * @param filterParams
	 *            Aa00j13s01
	 * @param searchParams
	 *            Aa00j13s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j13s01>>
	 */
	@Override
	public List<TableRowDto<Aa00j13s01>> search(Aa00j13s01 filterParams,
			Aa00j13s01 searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		Aa00j13s01DaoImpl.logger.info("Método search");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CREC13 CREC13,t1.SIT13 SIT13,t1.BLOQ13 BLOQ13,t1.NOMC13 NOMC13,t1.DESCC13 DESCC13,"
						+ "t1.NOME13 NOME13,t1.DESCE13 DESCE13,t1.SWDISP13 SWDISP13,t1.USUB13 USUB13,"
						+ "t2.CEDIF03 AA00J03S01CEDIF03,t2.NOMBRE03 AA00J03S01NOMBRE03,t2.SIT03 AA00J03S01SIT03,"
						+ "t2.BLOQ03 AA00J03S01BLOQ03,t2.TLFNO03 AA00J03S01TLFNO03,t2.USUB03 AA00J03S01USUB03,"
						+ "t3.CREST06 AA00J06S01CREST06,t3.DESCC06 AA00J06S01DESCC06,t3.DESCE06 AA00J06S01DESCE06,"
						+ "t3.SIT06 AA00J06S01SIT06,t3.BLOQ06 AA00J06S01BLOQ06,t3.MENC06 AA00J06S01MENC06,"
						+ "t3.MENE06 AA00J06S01MENE06,t3.USUB06 AA00J06S01USUB06,t2.CSITIO03 AA00J03S01CSITIO03, "
						+ "t4.CDEP07 AA00J07S01CDEP07, "
						+ "t4.DESCC07 AA00J07S01DESCC07, t4.DESCE07 AA00J07S01DESCE07, t4.SIT07 AA00J07S01SIT07, "
						+ "t4.BLOQ07 AA00J07S01BLOQ07, t4.USUB07 AA00J07S01USUB07, t4.COD_XLNET_07 AA00J07S01COD_XLNET_07 ");
		// FROM
		query.append("FROM AA00J13S01 t1 ,AA00J03S01 t2 ,AA00J06S01 t3 , AA00J07S01 t4 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");
		from_alias.add(" t3 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CEDIF13= t2.CEDIF03(+) AND t1.CREST13= t3.CREST06(+) AND t1.CDEP13= t4.CDEP07(+) ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, Aa00j13s01.class, filterParamList,
				searchSQL, searchParamList, from_alias, "CREC13");
		Aa00j13s01DaoImpl.logger.info("SQL " + sbReorderSelectionSQL);
		Aa00j13s01DaoImpl.logger.info("PARAMS " + filterParamList);
		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa00j13s01>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 * 
	 * @param filteraa00j13s01
	 *            Aa00j13s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Aa00j13s01 filteraa00j13s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		Aa00j13s01DaoImpl.logger.info("Método removeMultiple");
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.CREC13 CREC13,t1.SIT13 SIT13,t1.BLOQ13 BLOQ13,t1.NOMC13 NOMC13,t1.DESCC13 DESCC13,"
						+ "t1.NOME13 NOME13,t1.DESCE13 DESCE13,t1.SWDISP13 SWDISP13,t1.USUB13 USUB13,"
						+ "t2.CEDIF03 AA00J03S01CEDIF03,t2.NOMBRE03 AA00J03S01NOMBRE03,t2.SIT03 AA00J03S01SIT03,"
						+ "t2.BLOQ03 AA00J03S01BLOQ03,t2.TLFNO03 AA00J03S01TLFNO03,t2.USUB03 AA00J03S01USUB03,"
						+ "t3.CREST06 AA00J06S01CREST06,t3.DESCC06 AA00J06S01DESCC06,t3.DESCE06 AA00J06S01DESCE06,"
						+ "t3.SIT06 AA00J06S01SIT06,t3.BLOQ06 AA00J06S01BLOQ06,t3.MENC06 AA00J06S01MENC06,"
						+ "t3.MENE06 AA00J06S01MENE06,t3.USUB06 AA00J06S01USUB06,t2.CSITIO03 AA00J03S01CSITIO03, "
						+ "t4.CDEP07 AA00J07S01CDEP07, "
						+ "t4.DESCC07 AA00J07S01DESCC07, t4.DESCE07 AA00J07S01DESCE07, t4.SIT07 AA00J07S01SIT07, "
						+ "t4.BLOQ07 AA00J07S01BLOQ07, t4.USUB07 AA00J07S01USUB07, t4.COD_XLNET_07 AA00J07S01COD_XLNET_07 ");
		// FROM
		query.append("FROM AA00J13S01 t1 ,AA00J03S01 t2 ,AA00J06S01 t3 ,AA00J07S01 t4 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filteraa00j13s01,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto, Aa00j13s01.class,
						query, params, "CREC13");
		Aa00j13s01DaoImpl.logger.info("SQL " + sbRemoveMultipleSQL);
		Aa00j13s01DaoImpl.logger.info("PARAMS " + params);
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical Aa00j13s01 table.
	 * 
	 * @param filterAa00j13s01
	 *            Aa00j13s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Aa00j13s01>>
	 */
	@Override
	public List<JerarquiaDto<Aa00j13s01>> findAllLikeJerarquia(
			Aa00j13s01 filterAa00j13s01, JQGridRequestDto jqGridRequestDto) {
		Aa00j13s01DaoImpl.logger.info("Método findAllLikeJerarquia");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CREC13 CREC13,t1.SIT13 SIT13,t1.BLOQ13 BLOQ13,t1.NOMC13 NOMC13,t1.DESCC13 DESCC13,"
						+ "t1.NOME13 NOME13,t1.DESCE13 DESCE13,t1.SWDISP13 SWDISP13,t1.USUB13 USUB13,"
						+ "t2.CEDIF03 AA00J03S01CEDIF03,t2.NOMBRE03 AA00J03S01NOMBRE03,t2.SIT03 AA00J03S01SIT03,"
						+ "t2.BLOQ03 AA00J03S01BLOQ03,t2.TLFNO03 AA00J03S01TLFNO03,t2.USUB03 AA00J03S01USUB03,"
						+ "t3.CREST06 AA00J06S01CREST06,t3.DESCC06 AA00J06S01DESCC06,t3.DESCE06 AA00J06S01DESCE06,"
						+ "t3.SIT06 AA00J06S01SIT06,t3.BLOQ06 AA00J06S01BLOQ06,t3.MENC06 AA00J06S01MENC06,"
						+ "t3.MENE06 AA00J06S01MENE06,t3.USUB06 AA00J06S01USUB06,t2.CSITIO03 AA00J03S01CSITIO03, "
						+ "t4.CDEP07 AA00J07S01CDEP07, "
						+ "t4.DESCC07 AA00J07S01DESCC07, t4.DESCE07 AA00J07S01DESCE07, t4.SIT07 AA00J07S01SIT07, "
						+ "t4.BLOQ07 AA00J07S01BLOQ07, t4.USUB07 AA00J07S01USUB07, t4.COD_XLNET_07 AA00J07S01COD_XLNET_07 ");
		// FROM
		// StringBuilder from = new
		// StringBuilder("FROM AA00J13S01 t1 ,AA00J03S01 t2 ,AA00J06S01 t3 ");
		List<String> from = new ArrayList<String>();
		from.add("AA00J13S01");
		from.add("AA00J03S01");
		from.add("AA00J06S01");
		from.add("AA00J07S01");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");
		from_alias.add(" t3 ");
		from_alias.add(" t4 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa00j13s01, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
				mapaWhere, "CREC13", "ID_PADRE", "NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j13s01DaoImpl.logger.info("SQL " + query);
		Aa00j13s01DaoImpl.logger.info("PARAMS " + params);
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAa00j13s01
	 *            Aa00j13s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Aa00j13s01 filterAa00j13s01,
			JQGridRequestDto jqGridRequestDto) {
		Aa00j13s01DaoImpl.logger.info("Método findAllLikeCountJerarquia");
		// FROM
		// StringBuilder from = new
		// StringBuilder("FROM AA00J13S01 t1 ,AA00J03S01 t2 ,AA00J06S01 t3 ");
		List<String> from = new ArrayList<String>();
		from.add("AA00J13S01");
		from.add("AA00J03S01");
		from.add("AA00J06S01");
		from.add("AA00J07S01");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");
		from_alias.add(" t3 ");
		from_alias.add(" t4 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa00j13s01, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(
				jqGridRequestDto, mapaWhere, "CREC13", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j13s01DaoImpl.logger.info("SQL " + query);
		Aa00j13s01DaoImpl.logger.info("PARAMS " + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAa00j13s01
	 *            Aa00j13s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Aa00j13s01>>
	 */
	@Override
	public List<TableRowDto<Aa00j13s01>> findAllChild(
			Aa00j13s01 filterAa00j13s01, JQGridRequestDto jqGridRequestDto) {
		Aa00j13s01DaoImpl.logger.info("Método findAllChild");
		// FROM
		// StringBuilder from = new
		// StringBuilder("FROM AA00J13S01 t1 ,AA00J03S01 t2 ,AA00J06S01 t3 ");
		List<String> from = new ArrayList<String>();
		from.add("AA00J13S01");
		from.add("AA00J03S01");
		from.add("AA00J06S01");
		from.add("AA00J07S01");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");
		from_alias.add(" t3 ");
		from_alias.add(" t4 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa00j13s01, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(
				jqGridRequestDto, mapaWhere, "CREC13", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j13s01DaoImpl.logger.info("SQL " + query);
		Aa00j13s01DaoImpl.logger.info("PARAMS " + params);
		return this.jdbcTemplate
				.query(query.toString(),
						new RowNumResultSetExtractor<Aa00j13s01>(this.rwMapPK,
								"CREC13"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa00j13s01 entity
	 * 
	 * @param aa00j13s01
	 *            Aa00j13s01 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Aa00j13s01 aa00j13s01) {

		StringBuilder where = new StringBuilder(
				Aa00j13s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa00j13s01 != null && aa00j13s01.getCrec13() != null) {
			where.append(" AND t1.CREC13 = ?");
			params.add(aa00j13s01.getCrec13());
		}
		if (aa00j13s01 != null && aa00j13s01.getAa00j03s01() != null
				&& aa00j13s01.getAa00j03s01().getCedif03() != null) {
			where.append(" AND t2.CEDIF03 = ?");
			params.add(aa00j13s01.getAa00j03s01().getCedif03());
		}
		if (aa00j13s01 != null
				&& aa00j13s01.getAa00j03s01() != null
				&& aa00j13s01.getAa00j03s01().getAa00j02s01() != null
				&& aa00j13s01.getAa00j03s01().getAa00j02s01().getCsitio02() != null) {
			where.append(" AND t2.CSITIO03 = ?");
			params.add(aa00j13s01.getAa00j03s01().getAa00j02s01().getCsitio02());
		}
		if (aa00j13s01 != null && aa00j13s01.getAa00j03s01() != null
				&& aa00j13s01.getAa00j03s01().getNombre03() != null) {
			where.append(" AND t2.NOMBRE03 = ?");
			params.add(aa00j13s01.getAa00j03s01().getNombre03());
		}
		if (aa00j13s01 != null && aa00j13s01.getAa00j03s01() != null
				&& aa00j13s01.getAa00j03s01().getSit03() != null) {
			where.append(" AND t2.SIT03 = ?");
			params.add(aa00j13s01.getAa00j03s01().getSit03());
		}
		if (aa00j13s01 != null && aa00j13s01.getAa00j03s01() != null
				&& aa00j13s01.getAa00j03s01().getBloq03() != null) {
			where.append(" AND t2.BLOQ03 = ?");
			params.add(aa00j13s01.getAa00j03s01().getBloq03());
		}
		if (aa00j13s01 != null && aa00j13s01.getAa00j03s01() != null
				&& aa00j13s01.getAa00j03s01().getTlfno03() != null) {
			where.append(" AND t2.TLFNO03 = ?");
			params.add(aa00j13s01.getAa00j03s01().getTlfno03());
		}
		if (aa00j13s01 != null && aa00j13s01.getAa00j03s01() != null
				&& aa00j13s01.getAa00j03s01().getUsub03() != null) {
			where.append(" AND t2.USUB03 = ?");
			params.add(aa00j13s01.getAa00j03s01().getUsub03());
		}
		if (aa00j13s01 != null && aa00j13s01.getAa00j06s01() != null
				&& aa00j13s01.getAa00j06s01().getCrest06() != null) {
			where.append(" AND t3.CREST06 = ?");
			params.add(aa00j13s01.getAa00j06s01().getCrest06());
		}
		if (aa00j13s01 != null && aa00j13s01.getAa00j06s01() != null
				&& aa00j13s01.getAa00j06s01().getDescc06() != null) {
			where.append(" AND t3.DESCC06 = ?");
			params.add(aa00j13s01.getAa00j06s01().getDescc06());
		}
		if (aa00j13s01 != null && aa00j13s01.getAa00j06s01() != null
				&& aa00j13s01.getAa00j06s01().getDesce06() != null) {
			where.append(" AND t3.DESCE06 = ?");
			params.add(aa00j13s01.getAa00j06s01().getDesce06());
		}
		if (aa00j13s01 != null && aa00j13s01.getAa00j06s01() != null
				&& aa00j13s01.getAa00j06s01().getSit06() != null) {
			where.append(" AND t3.SIT06 = ?");
			params.add(aa00j13s01.getAa00j06s01().getSit06());
		}
		if (aa00j13s01 != null && aa00j13s01.getAa00j06s01() != null
				&& aa00j13s01.getAa00j06s01().getBloq06() != null) {
			where.append(" AND t3.BLOQ06 = ?");
			params.add(aa00j13s01.getAa00j06s01().getBloq06());
		}
		if (aa00j13s01 != null && aa00j13s01.getAa00j06s01() != null
				&& aa00j13s01.getAa00j06s01().getMenc06() != null) {
			where.append(" AND t3.MENC06 = ?");
			params.add(aa00j13s01.getAa00j06s01().getMenc06());
		}
		if (aa00j13s01 != null && aa00j13s01.getAa00j06s01() != null
				&& aa00j13s01.getAa00j06s01().getMene06() != null) {
			where.append(" AND t3.MENE06 = ?");
			params.add(aa00j13s01.getAa00j06s01().getMene06());
		}
		if (aa00j13s01 != null && aa00j13s01.getAa00j06s01() != null
				&& aa00j13s01.getAa00j06s01().getUsub06() != null) {
			where.append(" AND t3.USUB06 = ?");
			params.add(aa00j13s01.getAa00j06s01().getUsub06());
		}
		if (aa00j13s01 != null && aa00j13s01.getSit13() != null) {
			where.append(" AND t1.SIT13 = ?");
			params.add(aa00j13s01.getSit13());
		}
		if (aa00j13s01 != null && aa00j13s01.getBloq13() != null) {
			where.append(" AND t1.BLOQ13 = ?");
			params.add(aa00j13s01.getBloq13());
		}
		if (aa00j13s01 != null && aa00j13s01.getNomc13() != null) {
			where.append(" AND t1.NOMC13 = ?");
			params.add(aa00j13s01.getNomc13());
		}
		if (aa00j13s01 != null && aa00j13s01.getDescc13() != null) {
			where.append(" AND t1.DESCC13 = ?");
			params.add(aa00j13s01.getDescc13());
		}
		if (aa00j13s01 != null && aa00j13s01.getNome13() != null) {
			where.append(" AND t1.NOME13 = ?");
			params.add(aa00j13s01.getNome13());
		}
		if (aa00j13s01 != null && aa00j13s01.getDesce13() != null) {
			where.append(" AND t1.DESCE13 = ?");
			params.add(aa00j13s01.getDesce13());
		}
		if (aa00j13s01 != null && aa00j13s01.getSwdisp13() != null) {
			where.append(" AND t1.SWDISP13 = ?");
			params.add(aa00j13s01.getSwdisp13());
		}
		if (aa00j13s01 != null && aa00j13s01.getAa00j07s01() != null
				&& aa00j13s01.getAa00j07s01().getCdep07() != null) {
			where.append(" AND t4.CDEP07 = ?");
			params.add(aa00j13s01.getAa00j07s01().getCdep07());
		}
		if (aa00j13s01 != null && aa00j13s01.getUsub13() != null) {
			where.append(" AND t1.USUB13 = ?");
			params.add(aa00j13s01.getUsub13());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa00j13s01 entity
	 * 
	 * @param aa00j13s01
	 *            Aa00j13s01 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Aa00j13s01 aa00j13s01,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				Aa00j13s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa00j13s01 != null && aa00j13s01.getCrec13() != null) {
			where.append(" AND t1.CREC13 = ?");
			params.add(aa00j13s01.getCrec13());
		}
		if (aa00j13s01 != null && aa00j13s01.getAa00j03s01() != null
				&& aa00j13s01.getAa00j03s01().getCedif03() != null) {
			where.append(" AND t2.CEDIF03 = ?");
			params.add(aa00j13s01.getAa00j03s01().getCedif03());
		}
		if (aa00j13s01 != null
				&& aa00j13s01.getAa00j03s01() != null
				&& aa00j13s01.getAa00j03s01().getAa00j02s01() != null
				&& aa00j13s01.getAa00j03s01().getAa00j02s01().getCsitio02() != null) {
			where.append(" AND t2.CSITIO03 = ?");
			params.add(aa00j13s01.getAa00j03s01().getAa00j02s01().getCsitio02());
		}
		if (aa00j13s01 != null && aa00j13s01.getAa00j03s01() != null
				&& aa00j13s01.getAa00j03s01().getNombre03() != null) {
			where.append(" AND UPPER(t2.NOMBRE03) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j13s01.getAa00j03s01().getNombre03()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j13s01.getAa00j03s01().getNombre03()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NOMBRE03 IS NOT NULL");
		}
		if (aa00j13s01 != null && aa00j13s01.getAa00j03s01() != null
				&& aa00j13s01.getAa00j03s01().getSit03() != null) {
			where.append(" AND UPPER(t2.SIT03) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j13s01.getAa00j03s01().getSit03().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j13s01.getAa00j03s01().getSit03().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.SIT03 IS NOT NULL");
		}
		if (aa00j13s01 != null && aa00j13s01.getAa00j03s01() != null
				&& aa00j13s01.getAa00j03s01().getBloq03() != null) {
			where.append(" AND t2.BLOQ03 = ?");
			params.add(aa00j13s01.getAa00j03s01().getBloq03());
		}
		if (aa00j13s01 != null && aa00j13s01.getAa00j03s01() != null
				&& aa00j13s01.getAa00j03s01().getTlfno03() != null) {
			where.append(" AND UPPER(t2.TLFNO03) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j13s01.getAa00j03s01().getTlfno03()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j13s01.getAa00j03s01().getTlfno03().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.TLFNO03 IS NOT NULL");
		}
		if (aa00j13s01 != null && aa00j13s01.getAa00j03s01() != null
				&& aa00j13s01.getAa00j03s01().getUsub03() != null) {
			where.append(" AND UPPER(t2.USUB03) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j13s01.getAa00j03s01().getUsub03().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j13s01.getAa00j03s01().getUsub03().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.USUB03 IS NOT NULL");
		}
		if (aa00j13s01 != null && aa00j13s01.getAa00j06s01() != null
				&& aa00j13s01.getAa00j06s01().getCrest06() != null) {
			where.append(" AND t3.CREST06 = ?");
			params.add(aa00j13s01.getAa00j06s01().getCrest06());
		}
		if (aa00j13s01 != null && aa00j13s01.getAa00j06s01() != null
				&& aa00j13s01.getAa00j06s01().getDescc06() != null) {
			where.append(" AND UPPER(t3.DESCC06) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j13s01.getAa00j06s01().getDescc06()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j13s01.getAa00j06s01().getDescc06().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.DESCC06 IS NOT NULL");
		}
		if (aa00j13s01 != null && aa00j13s01.getAa00j06s01() != null
				&& aa00j13s01.getAa00j06s01().getDesce06() != null) {
			where.append(" AND UPPER(t3.DESCE06) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j13s01.getAa00j06s01().getDesce06()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j13s01.getAa00j06s01().getDesce06().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.DESCE06 IS NOT NULL");
		}
		if (aa00j13s01 != null && aa00j13s01.getAa00j06s01() != null
				&& aa00j13s01.getAa00j06s01().getSit06() != null) {
			where.append(" AND UPPER(t3.SIT06) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j13s01.getAa00j06s01().getSit06().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j13s01.getAa00j06s01().getSit06().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.SIT06 IS NOT NULL");
		}
		if (aa00j13s01 != null && aa00j13s01.getAa00j06s01() != null
				&& aa00j13s01.getAa00j06s01().getBloq06() != null) {
			where.append(" AND t3.BLOQ06 = ?");
			params.add(aa00j13s01.getAa00j06s01().getBloq06());
		}
		if (aa00j13s01 != null && aa00j13s01.getAa00j06s01() != null
				&& aa00j13s01.getAa00j06s01().getMenc06() != null) {
			where.append(" AND UPPER(t3.MENC06) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j13s01.getAa00j06s01().getMenc06().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j13s01.getAa00j06s01().getMenc06().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.MENC06 IS NOT NULL");
		}
		if (aa00j13s01 != null && aa00j13s01.getAa00j06s01() != null
				&& aa00j13s01.getAa00j06s01().getMene06() != null) {
			where.append(" AND UPPER(t3.MENE06) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j13s01.getAa00j06s01().getMene06().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j13s01.getAa00j06s01().getMene06().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.MENE06 IS NOT NULL");
		}
		if (aa00j13s01 != null && aa00j13s01.getAa00j06s01() != null
				&& aa00j13s01.getAa00j06s01().getUsub06() != null) {
			where.append(" AND UPPER(t3.USUB06) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j13s01.getAa00j06s01().getUsub06().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j13s01.getAa00j06s01().getUsub06().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.USUB06 IS NOT NULL");
		}
		if (aa00j13s01 != null && aa00j13s01.getSit13() != null) {
			where.append(" AND UPPER(t1.SIT13) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j13s01.getSit13().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j13s01.getSit13().toUpperCase() + "%");
			}
			where.append(" AND t1.SIT13 IS NOT NULL");
		}
		if (aa00j13s01 != null && aa00j13s01.getBloq13() != null) {
			where.append(" AND t1.BLOQ13 = ?");
			params.add(aa00j13s01.getBloq13());
		}
		if (aa00j13s01 != null && aa00j13s01.getNomc13() != null
				&& aa00j13s01.getNomc13().length() > 0) {
			where.append(" AND UPPER(t1.NOMC13) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j13s01.getNomc13().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j13s01.getNomc13().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMC13 IS NOT NULL");
		}
		if (aa00j13s01 != null && aa00j13s01.getDescc13() != null) {
			where.append(" AND UPPER(t1.DESCC13) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j13s01.getDescc13().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j13s01.getDescc13().toUpperCase() + "%");
			}
			where.append(" AND t1.DESCC13 IS NOT NULL");
		}
		if (aa00j13s01 != null && aa00j13s01.getNome13() != null
				&& aa00j13s01.getNome13().length() > 0) {
			where.append(" AND UPPER(t1.NOME13) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j13s01.getNome13().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j13s01.getNome13().toUpperCase() + "%");
			}
			where.append(" AND t1.NOME13 IS NOT NULL");
		}
		if (aa00j13s01 != null && aa00j13s01.getDesce13() != null) {
			where.append(" AND UPPER(t1.DESCE13) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j13s01.getDesce13().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j13s01.getDesce13().toUpperCase() + "%");
			}
			where.append(" AND t1.DESCE13 IS NOT NULL");
		}
		if (aa00j13s01 != null && aa00j13s01.getSwdisp13() != null) {
			where.append(" AND t1.SWDISP13 = ?");
			params.add(aa00j13s01.getSwdisp13());
		}
		if (aa00j13s01 != null && aa00j13s01.getAa00j07s01() != null
				&& aa00j13s01.getAa00j07s01().getCdep07() != null) {
			where.append(" AND t4.CDEP07 = ?");
			params.add(aa00j13s01.getAa00j07s01().getCdep07());
		}
		if (aa00j13s01 != null && aa00j13s01.getUsub13() != null) {
			where.append(" AND UPPER(t1.USUB13) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j13s01.getUsub13().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j13s01.getUsub13().toUpperCase() + "%");
			}
			where.append(" AND t1.USUB13 IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	public boolean existeEdificio(Long cedif13) {
		Aa00j13s01DaoImpl.logger.info("Método existeEdificio");
		String query = "SELECT COUNT(1) FROM AA00J13S01 WHERE UPPER(CEDIF13) = ?";
		Aa00j13s01DaoImpl.logger.info("SQL " + query);
		Aa00j13s01DaoImpl.logger.info("PARAM1 " + cedif13);
		return this.jdbcTemplate.queryForInt(query, cedif13) > 0;
	}

	public boolean existe(String nombreEs, Long codigoNoIncluir) {
		Aa00j13s01DaoImpl.logger.info("Método existe");
		if (codigoNoIncluir != null && codigoNoIncluir > 0) {
			String query = "SELECT COUNT(1) FROM AA00J13S01 WHERE UPPER(NOMC13) = UPPER(?) AND CREC13 <> ?";
			Aa00j13s01DaoImpl.logger.info("SQL " + query);
			Aa00j13s01DaoImpl.logger.info("PARAM1 " + nombreEs);
			Aa00j13s01DaoImpl.logger.info("PARAM2 " + codigoNoIncluir);
			return this.jdbcTemplate.queryForInt(query, nombreEs,
					codigoNoIncluir) > 0;
		} else {
			String query = "SELECT COUNT(1) FROM AA00J13S01 WHERE UPPER(NOMC13) = UPPER(?)";
			Aa00j13s01DaoImpl.logger.info("SQL " + query);
			Aa00j13s01DaoImpl.logger.info("PARAM1 " + nombreEs);

			return this.jdbcTemplate.queryForInt(query, nombreEs) > 0;
		}
	}

	public boolean existeDepartamento(Long cdep13) {
		Aa00j13s01DaoImpl.logger.info("Método existeDepartamento");
		String query = "SELECT COUNT(1) FROM AA00J13S01 WHERE UPPER(CDEP13) = ?";
		Aa00j13s01DaoImpl.logger.info("SQL " + query);
		Aa00j13s01DaoImpl.logger.info("PARAM1 " + cdep13);

		return this.jdbcTemplate.queryForInt(query, cdep13) > 0;
	}

	public boolean existeRestriccion(Long crest13) {
		Aa00j13s01DaoImpl.logger.info("Método existeRestriccion");
		String query = "SELECT COUNT(1) FROM AA00J13S01 WHERE UPPER(CREST13) = ?";
		Aa00j13s01DaoImpl.logger.info("SQL " + query);
		Aa00j13s01DaoImpl.logger.info("PARAM1 " + crest13);
		return this.jdbcTemplate.queryForInt(query, crest13) > 0;
	}

	public List<Aa00j13s01> obtenerCombo(Long codEdificio) {
		Aa00j13s01DaoImpl.logger.info("Método obtenerCombo");
		StringBuilder query = new StringBuilder(
				"SELECT t1.CREC13 CREC13,t1.NOMC13 NOMC13,t1.NOME13 NOME13 ");
		query.append("FROM AA00J13S01 t1 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.SIT13=? ");

		List<Object> params = new ArrayList<Object>();
		params.add(aa00jConstantes.SITUACION_ALTA);

		if (codEdificio != null) {
			where.append(" AND t1.CEDIF13=?");
			params.add(codEdificio);
		}

		query.append(where);
		Aa00j13s01DaoImpl.logger.info("SQL " + query);
		Aa00j13s01DaoImpl.logger.info("PARAMs " + params);
		return (List<Aa00j13s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMapCombo, params.toArray());
	}

	public List<Aa00j13s01> obtenerRecursosEdificio(Long cedif03) {
		Aa00j13s01DaoImpl.logger.info("Método obtenerRecursosEdificio");
		StringBuilder query = new StringBuilder(
				"SELECT t1.CREC13 CREC13,t1.NOMC13 NOMC13,t1.NOME13 NOME13 ");
		query.append("FROM AA00J13S01 t1 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.CEDIF13=? ");
		query.append(where);

		List<Object> params = new ArrayList<Object>();
		params.add(cedif03);
		Aa00j13s01DaoImpl.logger.info("SQL " + query);
		Aa00j13s01DaoImpl.logger.info("PARAMs " + params);
		return (List<Aa00j13s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMapCombo, params.toArray());
	}

	public List<Aa00j13s01> obtenerRecursosEdificioReserva(Long codReserva) {
		Aa00j13s01DaoImpl.logger.info("Método obtenerRecursosEdificioReserva");
		StringBuilder query = new StringBuilder(
				"SELECT t1.CREC13 CREC13,t1.NOMC13 NOMC13,t1.NOME13 NOME13 ");
		query.append("FROM AA00J13S01 t1 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CREC13 IN (SELECT CREC30 FROM AA00J30S01 WHERE COD30=?) ");
		query.append(where);

		List<Object> params = new ArrayList<Object>();
		params.add(codReserva);
		Aa00j13s01DaoImpl.logger.info("SQL " + query);
		Aa00j13s01DaoImpl.logger.info("PARAMs " + params);
		return (List<Aa00j13s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMapCombo, params.toArray());
	}

	public List<Aa00j13s01> obtenerRecursosEdificioReservaSala(
			Long codReservaSala) {
		Aa00j13s01DaoImpl.logger
				.info("Método obtenerRecursosEdificioReservaSala");
		StringBuilder query = new StringBuilder(
				"SELECT t1.CREC13 CREC13,t1.NOMC13 NOMC13,t1.NOME13 NOME13 ");
		query.append("FROM AA00J13S01 t1 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CREC13 IN (SELECT CREC30 FROM AA00J30S01 WHERE CODRSALA30=?) ");
		query.append(where);

		List<Object> params = new ArrayList<Object>();
		params.add(codReservaSala);
		Aa00j13s01DaoImpl.logger.info("SQL " + query);
		Aa00j13s01DaoImpl.logger.info("PARAMs " + params);
		return (List<Aa00j13s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMapCombo, params.toArray());
	}

	public List<Aa00j13s01> obtenerVarios(String codigos) {
		Aa00j13s01DaoImpl.logger.info("Método obtenerVarios");
		StringBuilder query = new StringBuilder(
				"SELECT t1.CREC13 CREC13,t1.NOMC13 NOMC13,t1.NOME13 NOME13 ");
		query.append("FROM AA00J13S01 t1 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.CREC13 IN ("
				+ codigos + ") ");
		query.append(where);
		Aa00j13s01DaoImpl.logger.info("SQL " + query);

		return (List<Aa00j13s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMapCombo);
	}

	private RowMapper<Option> optionMap = new RowMapper<Option>() {
		public Option mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Option(resultSet.getString("VALUE"),
					resultSet.getString("TEXT"));
		}
	};

	/**
	 * Devuelve una lista de recursos por código de sitio
	 */
	@Override
	public List<Option> recursosPorSitio(int sitio) {
		Aa00j13s01DaoImpl.logger.info("Método recursosPorSitio");
		StringBuilder sql = new StringBuilder();
		sql.append(" SELECT 'R'||CREC13 AS VALUE,");// se le añade una R al
													// código para diferenciar
													// de las salas
		sql.append("   NOMC13       ||' - ' ||");
		sql.append("   NOMBRE03    ||' ('||");
		sql.append("   NOMBRE02   ||') '  AS TEXT");
		sql.append(" FROM AA00J03S01");
		sql.append(" INNER JOIN AA00J13S01");
		sql.append(" ON AA00J03S01.CEDIF03 = AA00J13S01.CEDIF13");
		sql.append(" INNER JOIN AA00J02S01");
		sql.append(" ON AA00J03S01.CSITIO03   = AA00J02S01.CSITIO02");
		sql.append(" WHERE AA00J13S01.SWDISP13=1");
		sql.append(" AND AA00J03S01.CSITIO03  =? ");
		sql.append(" ORDER BY AA00J13S01.CEDIF13,");
		sql.append("   AA00J13S01.NOMC13");
		List<Object> params = new ArrayList<Object>();
		params.add(sitio);
		Aa00j13s01DaoImpl.logger.info("SQL " + sql);
		Aa00j13s01DaoImpl.logger.info("PARAMs " + params);
		return this.jdbcTemplate.query(sql.toString(), this.optionMap,
				params.toArray());
	}

}