package com.ejie.aa00j.dao;

import com.ejie.aa00j.model.Aa00j03s01;
import com.ejie.aa00j.model.Aa00j04s01;
import com.ejie.aa00j.model.Aa00j06s01;
import com.ejie.aa00j.model.Aa00j07s01;
import com.ejie.aa00j.model.Aa00j10s01;
import com.ejie.aa00j.model.Aa00j11s01;
import com.ejie.aa00j.model.Aa00j20s01;
import com.ejie.aa00j.model.Option;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.dto.PaginationManager;
import com.ejie.x38.dto.TableRowDto;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa00j.model.Aa00j12s01;

/**
 * Aa00j12s01DaoImpl generated by UDA, 16-oct-2013 13:02:12.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class Aa00j12s01DaoImpl implements Aa00j12s01Dao {
	private JdbcTemplate jdbcTemplate;
	private static final Logger logger = LoggerFactory
			.getLogger(Aa00j12s01DaoImpl.class);
	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Aa00j12s01> rwMap = new RowMapper<Aa00j12s01>() {
		public Aa00j12s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa00j12s01(resultSet.getLong("CMEDF12"),
					resultSet.getString("NOM12"), resultSet.getInt("SWDISP12"),
					resultSet.getString("SIT12"), new Aa00j10s01(
							resultSet.getLong("Aa00j10s01CSALA10"),
							resultSet.getString("Aa00j10s01NOMBRE10"),
							resultSet.getString("Aa00j10s01SIT10"),
							resultSet.getInt("Aa00j10s01BLOQ10"),
							resultSet.getInt("Aa00j10s01SWDISP10"),
							resultSet.getString("Aa00j10s01DESC10"),
							resultSet.getString("Aa00j10s01TLFNO10"),
							resultSet.getString("Aa00j10s01USUB10"),
							resultSet.getString("Aa00j10s01PLANTA10"),
							resultSet.getString("Aa00j10s01DCAPC10"),
							resultSet.getString("Aa00j10s01DCAPE10"),
							resultSet.getLong("Aa00j10s01NCAP10"),
							new Aa00j07s01(resultSet
									.getLong("Aa00j10s01CDEP10"), null, null,
									null, null, null, null, null, null, null,
									null, null), new Aa00j03s01(
									resultSet.getLong("Aa00j10s01CEDIF10"),
									null, null, null, null, null, null, null,
									null, null), new Aa00j06s01(
									resultSet.getLong("Aa00j10s01CREST10"),
									null, null, null, null, null, null, null,
									null, null), new Aa00j04s01(
									resultSet.getLong("Aa00j10s01CTEXTO10"),
									null, null, null, null, null, null, null),
							new Aa00j11s01(resultSet
									.getLong("Aa00j10s01CSALA11"), null, null)));
		}
	};

	private RowMapper<Aa00j12s01> rwMapPK = new RowMapper<Aa00j12s01>() {
		public Aa00j12s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa00j12s01(resultSet.getLong("CMEDF12"));
		}
	};
	private RowMapper<Option> optionMap = new RowMapper<Option>() {
		public Option mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Option(resultSet.getString("VALUE"),
					resultSet.getString("TEXT"));
		}
	};
	/**
	 * Rowmapper para Jerarquía
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Aa00j12s01>> rwMapJerarquia = new RowMapper<JerarquiaDto<Aa00j12s01>>() {
		public JerarquiaDto<Aa00j12s01> mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Aa00j12s01 aa00j12s01 = new Aa00j12s01(
					resultSet.getLong("CMEDF12"), resultSet.getString("NOM12"),
					resultSet.getInt("SWDISP12"), resultSet.getString("SIT12"),
					new Aa00j10s01(resultSet.getLong("Aa00j10s01CSALA10"),
							resultSet.getString("Aa00j10s01NOMBRE10"),
							resultSet.getString("Aa00j10s01SIT10"),
							resultSet.getInt("Aa00j10s01BLOQ10"),
							resultSet.getInt("Aa00j10s01SWDISP10"),
							resultSet.getString("Aa00j10s01DESC10"),
							resultSet.getString("Aa00j10s01TLFNO10"),
							resultSet.getString("Aa00j10s01USUB10"),
							resultSet.getString("Aa00j10s01PLANTA10"),
							resultSet.getString("Aa00j10s01DCAPC10"),
							resultSet.getString("Aa00j10s01DCAPE10"),
							resultSet.getLong("Aa00j10s01NCAP10"),
							new Aa00j07s01(resultSet
									.getLong("Aa00j10s01CDEP10"), null, null,
									null, null, null, null, null, null, null,
									null, null), new Aa00j03s01(
									resultSet.getLong("Aa00j10s01CEDIF10"),
									null, null, null, null, null, null, null,
									null, null), new Aa00j06s01(
									resultSet.getLong("Aa00j10s01CREST10"),
									null, null, null, null, null, null, null,
									null, null), new Aa00j04s01(
									resultSet.getLong("Aa00j10s01CTEXTO10"),
									null, null, null, null, null, null, null),
							new Aa00j11s01(resultSet
									.getLong("Aa00j10s01CSALA11"), null, null)));

			JerarquiaDto<Aa00j12s01> jerarquia = new JerarquiaDto<Aa00j12s01>();
			jerarquia.setModel(aa00j12s01);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet
					.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet
					.getString("FILTER")));
			return jerarquia;
		}
	};

	private RowMapper<Aa00j12s01> rwMapCombo = new RowMapper<Aa00j12s01>() {
		public Aa00j12s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa00j12s01(resultSet.getLong("CMEDF12"),
					resultSet.getString("NOM12"), resultSet.getInt("SWDISP12"),
					resultSet.getString("SIT12"), new Aa00j10s01(
							resultSet.getLong("CSALA12")));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Aa00j12s01 table.
	 * 
	 * @param aa00j12s01
	 *            Aa00j12s01
	 * @return Aa00j12s01
	 */
	public Aa00j12s01 add(final Aa00j12s01 aa00j12s01) {
		Aa00j12s01DaoImpl.logger.info("Método add");
		final String queryUltimoId = "(SELECT NVL(MAX(TO_NUMBER(CMEDF12)), 0) + 1 FROM AA00J12S01)";
		final String query = "INSERT INTO AA00J12S01 (CMEDF12, CSALA12, NOM12, SWDISP12, SIT12) VALUES ("
				+ queryUltimoId + ",?,?,?,?)";

		final Object getAa00j10s01Csala10Aux;
		if (aa00j12s01.getAa00j10s01() != null
				&& aa00j12s01.getAa00j10s01().getCsala10() != null) {
			getAa00j10s01Csala10Aux = aa00j12s01.getAa00j10s01().getCsala10();
		} else {
			getAa00j10s01Csala10Aux = null;
		}

		KeyHolder keyHolder = new GeneratedKeyHolder();
		Aa00j12s01DaoImpl.logger.info("SQL " + query);
		Aa00j12s01DaoImpl.logger.info("PARAM1 " + getAa00j10s01Csala10Aux);
		Aa00j12s01DaoImpl.logger.info("PARAM2 " + aa00j12s01.getNom12().trim());
		Aa00j12s01DaoImpl.logger.info("PARAM3 " + aa00j12s01.getSwdisp12());
		Aa00j12s01DaoImpl.logger.info("PARAM4 " + aa00j12s01.getSit12());
		jdbcTemplate.update(new PreparedStatementCreator() {
			public PreparedStatement createPreparedStatement(
					Connection connection) throws SQLException {
				PreparedStatement ps = connection.prepareStatement(query,
						new String[] { "CMEDF12" });
				ps.setObject(1, getAa00j10s01Csala10Aux);
				ps.setObject(2, aa00j12s01.getNom12().trim());
				ps.setObject(3, aa00j12s01.getSwdisp12());
				ps.setObject(4, aa00j12s01.getSit12());
				return ps;
			}
		}, keyHolder);

		aa00j12s01.setCmedf12(keyHolder.getKey().longValue());

		return aa00j12s01;
	}

	/**
	 * Updates a single row in the Aa00j12s01 table.
	 * 
	 * @param aa00j12s01
	 *            Aa00j12s01
	 * @return Aa00j12s01
	 */
	public Aa00j12s01 update(Aa00j12s01 aa00j12s01) {
		Aa00j12s01DaoImpl.logger.info("Método update");
		String query = "UPDATE AA00J12S01 SET CSALA12=?, NOM12=?, SWDISP12=?, SIT12=? WHERE CMEDF12=?";
		Object getAa00j10s01Csala10Aux = null;
		if (aa00j12s01.getAa00j10s01() != null
				&& aa00j12s01.getAa00j10s01().getCsala10() != null) {
			getAa00j10s01Csala10Aux = aa00j12s01.getAa00j10s01().getCsala10();
		}
		Aa00j12s01DaoImpl.logger.info("SQL " + query);
		Aa00j12s01DaoImpl.logger.info("PARAM1 " + getAa00j10s01Csala10Aux);
		Aa00j12s01DaoImpl.logger.info("PARAM2 " + aa00j12s01.getNom12().trim());
		Aa00j12s01DaoImpl.logger.info("PARAM3 " + aa00j12s01.getSwdisp12());
		Aa00j12s01DaoImpl.logger.info("PARAM4 " + aa00j12s01.getSit12());
		Aa00j12s01DaoImpl.logger.info("PARAM5 " + aa00j12s01.getCmedf12());
		this.jdbcTemplate.update(query, getAa00j10s01Csala10Aux,
				aa00j12s01.getNom12(), aa00j12s01.getSwdisp12(),
				aa00j12s01.getSit12(), aa00j12s01.getCmedf12());
		return aa00j12s01;
	}

	/**
	 * Finds a single row in the Aa00j12s01 table.
	 * 
	 * @param aa00j12s01
	 *            Aa00j12s01
	 * @return Aa00j12s01
	 */
	@Transactional(readOnly = true)
	public Aa00j12s01 find(Aa00j12s01 aa00j12s01) {
		Aa00j12s01DaoImpl.logger.info("Método find");
		String query = "SELECT t1.CMEDF12 CMEDF12, t1.NOM12 NOM12, t1.SWDISP12 SWDISP12, t1.SIT12 SIT12, t2.CSALA10 AA00J10S01CSALA10, t2.NOMBRE10 AA00J10S01NOMBRE10, t2.SIT10 AA00J10S01SIT10, t2.BLOQ10 AA00J10S01BLOQ10, t2.SWDISP10 AA00J10S01SWDISP10, t2.DESC10 AA00J10S01DESC10, t2.TLFNO10 AA00J10S01TLFNO10, t2.USUB10 AA00J10S01USUB10, t2.PLANTA10 AA00J10S01PLANTA10, t2.DCAPC10 AA00J10S01DCAPC10, t2.DCAPE10 AA00J10S01DCAPE10, t2.NCAP10 AA00J10S01NCAP10, t2.CDEP10 AA00J10S01CDEP10, t2.CEDIF10 AA00J10S01CEDIF10, t2.CREST10 AA00J10S01CREST10, t2.CTEXTO10 AA00J10S01CTEXTO10, t2.CSALA11 AA00J10S01CSALA11 FROM AA00J12S01 t1 , AA00J10S01 t2  WHERE t1.CMEDF12 = ?   AND t1.CSALA12= t2.CSALA10(+)";
		Aa00j12s01DaoImpl.logger.info("SQL " + query);
		Aa00j12s01DaoImpl.logger.info("PARAM1 " + aa00j12s01.getCmedf12());
		List<Aa00j12s01> aa00j12s01List = this.jdbcTemplate.query(query,
				this.rwMap, aa00j12s01.getCmedf12());
		return (Aa00j12s01) DataAccessUtils.uniqueResult(aa00j12s01List);
	}

	/**
	 * Removes a single row in the Aa00j12s01 table.
	 * 
	 * @param aa00j12s01
	 *            Aa00j12s01
	 * @return
	 */
	public void remove(Aa00j12s01 aa00j12s01) {
		Aa00j12s01DaoImpl.logger.info("Método remove");
		String query = "DELETE FROM AA00J12S01 WHERE CMEDF12=?";
		Aa00j12s01DaoImpl.logger.info("SQL " + query);
		Aa00j12s01DaoImpl.logger.info("PARAM1 " + aa00j12s01.getCmedf12());
		this.jdbcTemplate.update(query, aa00j12s01.getCmedf12());
	}

	/**
	 * Finds a list of rows in the Aa00j12s01 table.
	 * 
	 * @param aa00j12s01
	 *            Aa00j12s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa00j12s01>
	 */
	@Transactional(readOnly = true)
	public List<Aa00j12s01> findAll(Aa00j12s01 aa00j12s01,
			JQGridRequestDto jqGridRequestDto) {
		Aa00j12s01DaoImpl.logger.info("Método findAll");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CMEDF12 CMEDF12,t1.NOM12 NOM12,t1.SWDISP12 SWDISP12,t1.SIT12 SIT12,t2.CSALA10 AA00J10S01CSALA10,t2.NOMBRE10 AA00J10S01NOMBRE10,t2.SIT10 AA00J10S01SIT10,t2.BLOQ10 AA00J10S01BLOQ10,t2.SWDISP10 AA00J10S01SWDISP10,t2.DESC10 AA00J10S01DESC10,t2.TLFNO10 AA00J10S01TLFNO10,t2.USUB10 AA00J10S01USUB10,t2.PLANTA10 AA00J10S01PLANTA10,t2.DCAPC10 AA00J10S01DCAPC10,t2.DCAPE10 AA00J10S01DCAPE10,t2.NCAP10 AA00J10S01NCAP10,t2.CDEP10 AA00J10S01CDEP10,t2.CEDIF10 AA00J10S01CEDIF10,t2.CREST10 AA00J10S01CREST10,t2.CTEXTO10 AA00J10S01CTEXTO10,t2.CSALA11 AA00J10S01CSALA11 ");
		query.append("FROM AA00J12S01 t1 ,AA00J10S01 t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa00j12s01);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CSALA12= t2.CSALA10(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		Aa00j12s01DaoImpl.logger.info("SQL " + query);
		Aa00j12s01DaoImpl.logger.info("PARAMs " + params);
		return (List<Aa00j12s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Aa00j12s01 table using like.
	 * 
	 * @param aa00j12s01
	 *            Aa00j12s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa00j12s01>
	 */
	@Transactional(readOnly = true)
	public List<Aa00j12s01> findAllLike(Aa00j12s01 aa00j12s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		Aa00j12s01DaoImpl.logger.info("Método findAllLike");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CMEDF12 CMEDF12,t1.NOM12 NOM12,t1.SWDISP12 SWDISP12,t1.SIT12 SIT12,t2.CSALA10 AA00J10S01CSALA10,t2.NOMBRE10 AA00J10S01NOMBRE10,t2.SIT10 AA00J10S01SIT10,t2.BLOQ10 AA00J10S01BLOQ10,t2.SWDISP10 AA00J10S01SWDISP10,t2.DESC10 AA00J10S01DESC10,t2.TLFNO10 AA00J10S01TLFNO10,t2.USUB10 AA00J10S01USUB10,t2.PLANTA10 AA00J10S01PLANTA10,t2.DCAPC10 AA00J10S01DCAPC10,t2.DCAPE10 AA00J10S01DCAPE10,t2.NCAP10 AA00J10S01NCAP10,t2.CDEP10 AA00J10S01CDEP10,t2.CEDIF10 AA00J10S01CEDIF10,t2.CREST10 AA00J10S01CREST10,t2.CTEXTO10 AA00J10S01CTEXTO10,t2.CSALA11 AA00J10S01CSALA11 ");
		query.append("FROM AA00J12S01 t1 ,AA00J10S01 t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa00j12s01, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CSALA12= t2.CSALA10(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		Aa00j12s01DaoImpl.logger.info("SQL " + query);
		Aa00j12s01DaoImpl.logger.info("PARAMs " + params);
		return (List<Aa00j12s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Aa00j12s01 table.
	 * 
	 * @param aa00j12s01
	 *            Aa00j12s01
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Aa00j12s01 aa00j12s01) {
		Aa00j12s01DaoImpl.logger.info("Método findAllCount");
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA00J12S01 t1 , AA00J10S01 t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa00j12s01);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CSALA12= t2.CSALA10(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j12s01DaoImpl.logger.info("SQL " + query);
		Aa00j12s01DaoImpl.logger.info("PARAMs " + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Aa00j12s01 table using like.
	 * 
	 * @param aa00j12s01
	 *            Aa00j12s01
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Aa00j12s01 aa00j12s01, Boolean startsWith) {
		Aa00j12s01DaoImpl.logger.info("Método findAllLikeCount");
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA00J12S01 t1 ,AA00J10S01 t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa00j12s01, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CSALA12= t2.CSALA10(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j12s01DaoImpl.logger.info("SQL " + query);
		Aa00j12s01DaoImpl.logger.info("PARAMs " + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Aa00j12s01 selected for rup_table
	 * 
	 * @param aa00j12s01
	 *            Aa00j12s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j12s01>>
	 */
	@Override
	public List<TableRowDto<Aa00j12s01>> reorderSelection(
			Aa00j12s01 aa00j12s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		Aa00j12s01DaoImpl.logger.info("Método reorderSelection");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CMEDF12 CMEDF12,t1.NOM12 NOM12,t1.SWDISP12 SWDISP12,t1.SIT12 SIT12,t2.CSALA10 AA00J10S01CSALA10,t2.NOMBRE10 AA00J10S01NOMBRE10,t2.SIT10 AA00J10S01SIT10,t2.BLOQ10 AA00J10S01BLOQ10,t2.SWDISP10 AA00J10S01SWDISP10,t2.DESC10 AA00J10S01DESC10,t2.TLFNO10 AA00J10S01TLFNO10,t2.USUB10 AA00J10S01USUB10,t2.PLANTA10 AA00J10S01PLANTA10,t2.DCAPC10 AA00J10S01DCAPC10,t2.DCAPE10 AA00J10S01DCAPE10,t2.NCAP10 AA00J10S01NCAP10,t2.CDEP10 AA00J10S01CDEP10,t2.CEDIF10 AA00J10S01CEDIF10,t2.CREST10 AA00J10S01CREST10,t2.CTEXTO10 AA00J10S01CTEXTO10,t2.CSALA11 AA00J10S01CSALA11 ");
		// FROM
		query.append("FROM AA00J12S01 t1 ,AA00J10S01 t2 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa00j12s01, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CSALA12= t2.CSALA10(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, Aa00j12s01.class, filterParamList,
				"CMEDF12");
		Aa00j12s01DaoImpl.logger.info("SQL " + sbReorderSelectionSQL);
		Aa00j12s01DaoImpl.logger.info("PARAMs " + filterParamList);
		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa00j12s01>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * @param filterParams
	 *            Aa00j12s01
	 * @param searchParams
	 *            Aa00j12s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j12s01>>
	 */
	@Override
	public List<TableRowDto<Aa00j12s01>> search(Aa00j12s01 filterParams,
			Aa00j12s01 searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		Aa00j12s01DaoImpl.logger.info("Método search");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CMEDF12 CMEDF12,t1.NOM12 NOM12,t1.SWDISP12 SWDISP12,t1.SIT12 SIT12,t2.CSALA10 AA00J10S01CSALA10,t2.NOMBRE10 AA00J10S01NOMBRE10,t2.SIT10 AA00J10S01SIT10,t2.BLOQ10 AA00J10S01BLOQ10,t2.SWDISP10 AA00J10S01SWDISP10,t2.DESC10 AA00J10S01DESC10,t2.TLFNO10 AA00J10S01TLFNO10,t2.USUB10 AA00J10S01USUB10,t2.PLANTA10 AA00J10S01PLANTA10,t2.DCAPC10 AA00J10S01DCAPC10,t2.DCAPE10 AA00J10S01DCAPE10,t2.NCAP10 AA00J10S01NCAP10,t2.CDEP10 AA00J10S01CDEP10,t2.CEDIF10 AA00J10S01CEDIF10,t2.CREST10 AA00J10S01CREST10,t2.CTEXTO10 AA00J10S01CTEXTO10,t2.CSALA11 AA00J10S01CSALA11 ");
		// FROM
		query.append("FROM AA00J12S01 t1 ,AA00J10S01 t2 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CSALA12= t2.CSALA10(+) ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, Aa00j12s01.class, filterParamList,
				searchSQL, searchParamList, from_alias, "CMEDF12");
		Aa00j12s01DaoImpl.logger.info("SQL " + sbReorderSelectionSQL);
		Aa00j12s01DaoImpl.logger.info("PARAMs " + filterParamList);
		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa00j12s01>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 * 
	 * @param filteraa00j12s01
	 *            Aa00j12s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Aa00j12s01 filteraa00j12s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		Aa00j12s01DaoImpl.logger.info("Método removeMultiple");
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.CMEDF12 CMEDF12,t1.NOM12 NOM12,t1.SWDISP12 SWDISP12,t1.SIT12 SIT12,t2.CSALA10 AA00J10S01CSALA10,t2.NOMBRE10 AA00J10S01NOMBRE10,t2.SIT10 AA00J10S01SIT10,t2.BLOQ10 AA00J10S01BLOQ10,t2.SWDISP10 AA00J10S01SWDISP10,t2.DESC10 AA00J10S01DESC10,t2.TLFNO10 AA00J10S01TLFNO10,t2.USUB10 AA00J10S01USUB10,t2.PLANTA10 AA00J10S01PLANTA10,t2.DCAPC10 AA00J10S01DCAPC10,t2.DCAPE10 AA00J10S01DCAPE10,t2.NCAP10 AA00J10S01NCAP10,t2.CDEP10 AA00J10S01CDEP10,t2.CEDIF10 AA00J10S01CEDIF10,t2.CREST10 AA00J10S01CREST10,t2.CTEXTO10 AA00J10S01CTEXTO10,t2.CSALA11 AA00J10S01CSALA11 ");
		// FROM
		query.append("FROM AA00J12S01 t1 ,AA00J10S01 t2 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filteraa00j12s01,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto, Aa00j12s01.class,
						query, params, "CMEDF12");
		Aa00j12s01DaoImpl.logger.info("SQL " + sbRemoveMultipleSQL);
		Aa00j12s01DaoImpl.logger.info("PARAMs " + params);
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical Aa00j12s01 table.
	 * 
	 * @param filterAa00j12s01
	 *            Aa00j12s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Aa00j12s01>>
	 */
	@Override
	public List<JerarquiaDto<Aa00j12s01>> findAllLikeJerarquia(
			Aa00j12s01 filterAa00j12s01, JQGridRequestDto jqGridRequestDto) {
		Aa00j12s01DaoImpl.logger.info("Método findAllLikeJerarquia");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CMEDF12 CMEDF12,t1.NOM12 NOM12,t1.SWDISP12 SWDISP12,t1.SIT12 SIT12,t2.CSALA10 AA00J10S01CSALA10,t2.NOMBRE10 AA00J10S01NOMBRE10,t2.SIT10 AA00J10S01SIT10,t2.BLOQ10 AA00J10S01BLOQ10,t2.SWDISP10 AA00J10S01SWDISP10,t2.DESC10 AA00J10S01DESC10,t2.TLFNO10 AA00J10S01TLFNO10,t2.USUB10 AA00J10S01USUB10,t2.PLANTA10 AA00J10S01PLANTA10,t2.DCAPC10 AA00J10S01DCAPC10,t2.DCAPE10 AA00J10S01DCAPE10,t2.NCAP10 AA00J10S01NCAP10,t2.CDEP10 AA00J10S01CDEP10,t2.CEDIF10 AA00J10S01CEDIF10,t2.CREST10 AA00J10S01CREST10,t2.CTEXTO10 AA00J10S01CTEXTO10,t2.CSALA11 AA00J10S01CSALA11 ");
		// FROM
		// StringBuilder from = new
		// StringBuilder("FROM AA00J12S01 t1 ,AA00J10S01 t2 ");
		List<String> from = new ArrayList<String>();
		from.add("AA00J12S01");
		from.add("AA00J10S01");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa00j12s01, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
				mapaWhere, "CMEDF12", "ID_PADRE", "NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j12s01DaoImpl.logger.info("SQL " + query);
		Aa00j12s01DaoImpl.logger.info("PARAMs " + params);
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAa00j12s01
	 *            Aa00j12s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Aa00j12s01 filterAa00j12s01,
			JQGridRequestDto jqGridRequestDto) {
		Aa00j12s01DaoImpl.logger.info("Método findAllLikeCountJerarquia");
		// FROM
		// StringBuilder from = new
		// StringBuilder("FROM AA00J12S01 t1 ,AA00J10S01 t2 ");
		List<String> from = new ArrayList<String>();
		from.add("AA00J12S01");
		from.add("AA00J10S01");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa00j12s01, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(
				jqGridRequestDto, mapaWhere, "CMEDF12", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j12s01DaoImpl.logger.info("SQL " + query);
		Aa00j12s01DaoImpl.logger.info("PARAMs " + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAa00j12s01
	 *            Aa00j12s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Aa00j12s01>>
	 */
	@Override
	public List<TableRowDto<Aa00j12s01>> findAllChild(
			Aa00j12s01 filterAa00j12s01, JQGridRequestDto jqGridRequestDto) {
		Aa00j12s01DaoImpl.logger.info("Método findAllChild");
		// FROM
		// StringBuilder from = new
		// StringBuilder("FROM AA00J12S01 t1 ,AA00J10S01 t2 ");
		List<String> from = new ArrayList<String>();
		from.add("AA00J12S01");
		from.add("AA00J10S01");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa00j12s01, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(
				jqGridRequestDto, mapaWhere, "CMEDF12", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j12s01DaoImpl.logger.info("SQL " + query);
		Aa00j12s01DaoImpl.logger.info("PARAMs " + params);
		return this.jdbcTemplate.query(query.toString(),
				new RowNumResultSetExtractor<Aa00j12s01>(this.rwMapPK,
						"CMEDF12"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa00j12s01 entity
	 * 
	 * @param aa00j12s01
	 *            Aa00j12s01 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Aa00j12s01 aa00j12s01) {

		StringBuilder where = new StringBuilder(
				Aa00j12s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa00j12s01 != null && aa00j12s01.getCmedf12() != null) {
			where.append(" AND t1.CMEDF12 = ?");
			params.add(aa00j12s01.getCmedf12());
		}
		if (aa00j12s01 != null && aa00j12s01.getAa00j10s01() != null
				&& aa00j12s01.getAa00j10s01().getCsala10() != null) {
			where.append(" AND t2.CSALA10 = ?");
			params.add(aa00j12s01.getAa00j10s01().getCsala10());
		}
		if (aa00j12s01 != null
				&& aa00j12s01.getAa00j10s01() != null
				&& aa00j12s01.getAa00j10s01().getAa00j07s01() != null
				&& aa00j12s01.getAa00j10s01().getAa00j07s01().getCdep07() != null) {
			where.append(" AND t2.CDEP10 = ?");
			params.add(aa00j12s01.getAa00j10s01().getAa00j07s01().getCdep07());
		}
		if (aa00j12s01 != null
				&& aa00j12s01.getAa00j10s01() != null
				&& aa00j12s01.getAa00j10s01().getAa00j03s01() != null
				&& aa00j12s01.getAa00j10s01().getAa00j03s01().getCedif03() != null) {
			where.append(" AND t2.CEDIF10 = ?");
			params.add(aa00j12s01.getAa00j10s01().getAa00j03s01().getCedif03());
		}
		if (aa00j12s01 != null
				&& aa00j12s01.getAa00j10s01() != null
				&& aa00j12s01.getAa00j10s01().getAa00j06s01() != null
				&& aa00j12s01.getAa00j10s01().getAa00j06s01().getCrest06() != null) {
			where.append(" AND t2.CREST10 = ?");
			params.add(aa00j12s01.getAa00j10s01().getAa00j06s01().getCrest06());
		}
		if (aa00j12s01 != null
				&& aa00j12s01.getAa00j10s01() != null
				&& aa00j12s01.getAa00j10s01().getAa00j04s01() != null
				&& aa00j12s01.getAa00j10s01().getAa00j04s01().getCtexto04() != null) {
			where.append(" AND t2.CTEXTO10 = ?");
			params.add(aa00j12s01.getAa00j10s01().getAa00j04s01().getCtexto04());
		}
		if (aa00j12s01 != null && aa00j12s01.getAa00j10s01() != null
				&& aa00j12s01.getAa00j10s01().getNombre10() != null) {
			where.append(" AND t2.NOMBRE10 = ?");
			params.add(aa00j12s01.getAa00j10s01().getNombre10());
		}
		if (aa00j12s01 != null && aa00j12s01.getAa00j10s01() != null
				&& aa00j12s01.getAa00j10s01().getSit10() != null) {
			where.append(" AND t2.SIT10 = ?");
			params.add(aa00j12s01.getAa00j10s01().getSit10());
		}
		if (aa00j12s01 != null && aa00j12s01.getAa00j10s01() != null
				&& aa00j12s01.getAa00j10s01().getBloq10() != null) {
			where.append(" AND t2.BLOQ10 = ?");
			params.add(aa00j12s01.getAa00j10s01().getBloq10());
		}
		if (aa00j12s01 != null && aa00j12s01.getAa00j10s01() != null
				&& aa00j12s01.getAa00j10s01().getSwdisp10() != null) {
			where.append(" AND t2.SWDISP10 = ?");
			params.add(aa00j12s01.getAa00j10s01().getSwdisp10());
		}
		if (aa00j12s01 != null && aa00j12s01.getAa00j10s01() != null
				&& aa00j12s01.getAa00j10s01().getDesc10() != null) {
			where.append(" AND t2.DESC10 = ?");
			params.add(aa00j12s01.getAa00j10s01().getDesc10());
		}
		if (aa00j12s01 != null && aa00j12s01.getAa00j10s01() != null
				&& aa00j12s01.getAa00j10s01().getTlfno10() != null) {
			where.append(" AND t2.TLFNO10 = ?");
			params.add(aa00j12s01.getAa00j10s01().getTlfno10());
		}
		if (aa00j12s01 != null && aa00j12s01.getAa00j10s01() != null
				&& aa00j12s01.getAa00j10s01().getUsub10() != null) {
			where.append(" AND t2.USUB10 = ?");
			params.add(aa00j12s01.getAa00j10s01().getUsub10());
		}
		if (aa00j12s01 != null && aa00j12s01.getAa00j10s01() != null
				&& aa00j12s01.getAa00j10s01().getPlanta10() != null) {
			where.append(" AND t2.PLANTA10 = ?");
			params.add(aa00j12s01.getAa00j10s01().getPlanta10());
		}
		if (aa00j12s01 != null && aa00j12s01.getAa00j10s01() != null
				&& aa00j12s01.getAa00j10s01().getDcapc10() != null) {
			where.append(" AND t2.DCAPC10 = ?");
			params.add(aa00j12s01.getAa00j10s01().getDcapc10());
		}
		if (aa00j12s01 != null && aa00j12s01.getAa00j10s01() != null
				&& aa00j12s01.getAa00j10s01().getDcape10() != null) {
			where.append(" AND t2.DCAPE10 = ?");
			params.add(aa00j12s01.getAa00j10s01().getDcape10());
		}
		if (aa00j12s01 != null && aa00j12s01.getAa00j10s01() != null
				&& aa00j12s01.getAa00j10s01().getNcap10() != null) {
			where.append(" AND t2.NCAP10 = ?");
			params.add(aa00j12s01.getAa00j10s01().getNcap10());
		}
		if (aa00j12s01 != null
				&& aa00j12s01.getAa00j10s01() != null
				&& aa00j12s01.getAa00j10s01().getAa00j11s01() != null
				&& aa00j12s01.getAa00j10s01().getAa00j11s01().getCsala11() != null) {
			where.append(" AND t2.CSALA11 = ?");
			params.add(aa00j12s01.getAa00j10s01().getAa00j11s01().getCsala11());
		}
		if (aa00j12s01 != null && aa00j12s01.getNom12() != null) {
			where.append(" AND t1.NOM12 = ?");
			params.add(aa00j12s01.getNom12());
		}
		if (aa00j12s01 != null && aa00j12s01.getSwdisp12() != null) {
			where.append(" AND t1.SWDISP12 = ?");
			params.add(aa00j12s01.getSwdisp12());
		}
		if (aa00j12s01 != null && aa00j12s01.getSit12() != null) {
			where.append(" AND t1.SIT12 = ?");
			params.add(aa00j12s01.getSit12());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa00j12s01 entity
	 * 
	 * @param aa00j12s01
	 *            Aa00j12s01 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Aa00j12s01 aa00j12s01,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				Aa00j12s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa00j12s01 != null && aa00j12s01.getCmedf12() != null) {
			where.append(" AND t1.CMEDF12 = ?");
			params.add(aa00j12s01.getCmedf12());
		}
		if (aa00j12s01 != null && aa00j12s01.getAa00j10s01() != null
				&& aa00j12s01.getAa00j10s01().getCsala10() != null) {
			where.append(" AND t2.CSALA10 = ?");
			params.add(aa00j12s01.getAa00j10s01().getCsala10());
		}
		if (aa00j12s01 != null
				&& aa00j12s01.getAa00j10s01() != null
				&& aa00j12s01.getAa00j10s01().getAa00j07s01() != null
				&& aa00j12s01.getAa00j10s01().getAa00j07s01().getCdep07() != null) {
			where.append(" AND t2.CDEP10 = ?");
			params.add(aa00j12s01.getAa00j10s01().getAa00j07s01().getCdep07());
		}
		if (aa00j12s01 != null
				&& aa00j12s01.getAa00j10s01() != null
				&& aa00j12s01.getAa00j10s01().getAa00j03s01() != null
				&& aa00j12s01.getAa00j10s01().getAa00j03s01().getCedif03() != null) {
			where.append(" AND t2.CEDIF10 = ?");
			params.add(aa00j12s01.getAa00j10s01().getAa00j03s01().getCedif03());
		}
		if (aa00j12s01 != null
				&& aa00j12s01.getAa00j10s01() != null
				&& aa00j12s01.getAa00j10s01().getAa00j06s01() != null
				&& aa00j12s01.getAa00j10s01().getAa00j06s01().getCrest06() != null) {
			where.append(" AND t2.CREST10 = ?");
			params.add(aa00j12s01.getAa00j10s01().getAa00j06s01().getCrest06());
		}
		if (aa00j12s01 != null
				&& aa00j12s01.getAa00j10s01() != null
				&& aa00j12s01.getAa00j10s01().getAa00j04s01() != null
				&& aa00j12s01.getAa00j10s01().getAa00j04s01().getCtexto04() != null) {
			where.append(" AND t2.CTEXTO10 = ?");
			params.add(aa00j12s01.getAa00j10s01().getAa00j04s01().getCtexto04());
		}
		if (aa00j12s01 != null && aa00j12s01.getAa00j10s01() != null
				&& aa00j12s01.getAa00j10s01().getNombre10() != null) {
			where.append(" AND UPPER(t2.NOMBRE10) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j12s01.getAa00j10s01().getNombre10()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j12s01.getAa00j10s01().getNombre10()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NOMBRE10 IS NOT NULL");
		}
		if (aa00j12s01 != null && aa00j12s01.getAa00j10s01() != null
				&& aa00j12s01.getAa00j10s01().getSit10() != null) {
			where.append(" AND UPPER(t2.SIT10) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j12s01.getAa00j10s01().getSit10().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j12s01.getAa00j10s01().getSit10().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.SIT10 IS NOT NULL");
		}
		if (aa00j12s01 != null && aa00j12s01.getAa00j10s01() != null
				&& aa00j12s01.getAa00j10s01().getBloq10() != null) {
			where.append(" AND t2.BLOQ10 = ?");
			params.add(aa00j12s01.getAa00j10s01().getBloq10());
		}
		if (aa00j12s01 != null && aa00j12s01.getAa00j10s01() != null
				&& aa00j12s01.getAa00j10s01().getSwdisp10() != null) {
			where.append(" AND t2.SWDISP10 = ?");
			params.add(aa00j12s01.getAa00j10s01().getSwdisp10());
		}
		if (aa00j12s01 != null && aa00j12s01.getAa00j10s01() != null
				&& aa00j12s01.getAa00j10s01().getDesc10() != null) {
			where.append(" AND UPPER(t2.DESC10) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j12s01.getAa00j10s01().getDesc10().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j12s01.getAa00j10s01().getDesc10().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.DESC10 IS NOT NULL");
		}
		if (aa00j12s01 != null && aa00j12s01.getAa00j10s01() != null
				&& aa00j12s01.getAa00j10s01().getTlfno10() != null) {
			where.append(" AND UPPER(t2.TLFNO10) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j12s01.getAa00j10s01().getTlfno10()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j12s01.getAa00j10s01().getTlfno10().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.TLFNO10 IS NOT NULL");
		}
		if (aa00j12s01 != null && aa00j12s01.getAa00j10s01() != null
				&& aa00j12s01.getAa00j10s01().getUsub10() != null) {
			where.append(" AND UPPER(t2.USUB10) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j12s01.getAa00j10s01().getUsub10().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j12s01.getAa00j10s01().getUsub10().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.USUB10 IS NOT NULL");
		}
		if (aa00j12s01 != null && aa00j12s01.getAa00j10s01() != null
				&& aa00j12s01.getAa00j10s01().getPlanta10() != null) {
			where.append(" AND UPPER(t2.PLANTA10) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j12s01.getAa00j10s01().getPlanta10()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j12s01.getAa00j10s01().getPlanta10()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.PLANTA10 IS NOT NULL");
		}
		if (aa00j12s01 != null && aa00j12s01.getAa00j10s01() != null
				&& aa00j12s01.getAa00j10s01().getDcapc10() != null) {
			where.append(" AND UPPER(t2.DCAPC10) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j12s01.getAa00j10s01().getDcapc10()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j12s01.getAa00j10s01().getDcapc10().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.DCAPC10 IS NOT NULL");
		}
		if (aa00j12s01 != null && aa00j12s01.getAa00j10s01() != null
				&& aa00j12s01.getAa00j10s01().getDcape10() != null) {
			where.append(" AND UPPER(t2.DCAPE10) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j12s01.getAa00j10s01().getDcape10()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j12s01.getAa00j10s01().getDcape10().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.DCAPE10 IS NOT NULL");
		}
		if (aa00j12s01 != null && aa00j12s01.getAa00j10s01() != null
				&& aa00j12s01.getAa00j10s01().getNcap10() != null) {
			where.append(" AND t2.NCAP10 = ?");
			params.add(aa00j12s01.getAa00j10s01().getNcap10());
		}
		if (aa00j12s01 != null
				&& aa00j12s01.getAa00j10s01() != null
				&& aa00j12s01.getAa00j10s01().getAa00j11s01() != null
				&& aa00j12s01.getAa00j10s01().getAa00j11s01().getCsala11() != null) {
			where.append(" AND t2.CSALA11 = ?");
			params.add(aa00j12s01.getAa00j10s01().getAa00j11s01().getCsala11());
		}
		if (aa00j12s01 != null && aa00j12s01.getNom12() != null) {
			where.append(" AND UPPER(t1.NOM12) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j12s01.getNom12().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j12s01.getNom12().toUpperCase() + "%");
			}
			where.append(" AND t1.NOM12 IS NOT NULL");
		}
		if (aa00j12s01 != null && aa00j12s01.getSwdisp12() != null) {
			where.append(" AND t1.SWDISP12 = ?");
			params.add(aa00j12s01.getSwdisp12());
		}
		if (aa00j12s01 != null && aa00j12s01.getSit12() != null) {
			where.append(" AND UPPER(t1.SIT12) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j12s01.getSit12().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j12s01.getSit12().toUpperCase() + "%");
			}
			where.append(" AND t1.SIT12 IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Inserts a single row in the Aa00j21s01 table.
	 * 
	 * @param aa00j12s01
	 *            Aa00j12s01
	 * @return Aa00j12s01
	 */
	public Aa00j12s01 addAa00j21s01(Aa00j12s01 aa00j12s01) {
		Aa00j12s01DaoImpl.logger.info("Método addAa00j21s01");
		String query = "INSERT INTO AA00J21T00 " + "( CMEDF21,CRES21) "
				+ " values (?, ?)";

		List<Aa00j20s01> auxiliarAa00j20s01 = aa00j12s01.getAa00j20s01s();
		Iterator<Aa00j20s01> it = auxiliarAa00j20s01.iterator();
		while (it.hasNext()) {
			Aa00j20s01 aa00j20s01 = (Aa00j20s01) it.next();
			Aa00j12s01DaoImpl.logger.info("SQL " + query);
			Aa00j12s01DaoImpl.logger.info("PARAMs " + aa00j20s01.getCod20());
			this.jdbcTemplate.update(query, aa00j12s01.getCmedf12(),
					aa00j20s01.getCod20());
		}
		return aa00j12s01;
	}

	/**
	 * Deletes a single row in the Aa00j21s01 table.
	 * 
	 * @param aa00j12s01
	 *            Aa00j12s01
	 * @return
	 */
	public void removeAa00j21s01(Aa00j12s01 aa00j12s01) {
		Aa00j12s01DaoImpl.logger.info("Método removeAa00j21s01");
		String query = "DELETE  FROM AA00J21T00 "
				+ " WHERE CMEDF21=? AND CRES21=?";
		List<Aa00j20s01> auxiliarAa00j20s01 = aa00j12s01.getAa00j20s01s();
		Iterator<Aa00j20s01> it = auxiliarAa00j20s01.iterator();
		while (it.hasNext()) {
			Aa00j20s01 aa00j20s01 = (Aa00j20s01) it.next();
			Aa00j12s01DaoImpl.logger.info("SQL " + query);
			Aa00j12s01DaoImpl.logger.info("PARAM1 " + aa00j12s01.getCmedf12());
			Aa00j12s01DaoImpl.logger.info("PARAM2 " + aa00j20s01.getCod20());
			this.jdbcTemplate.update(query, aa00j12s01.getCmedf12(),
					aa00j20s01.getCod20());
		}
	}

	/**
	 * Find a single row in the findAa00j21s01 Many To Many relationship.
	 * 
	 * @param aa00j12s01
	 *            Aa00j12s01
	 * @param aa00j20s01
	 *            Aa00j20s01
	 * @param pagination
	 *            Pagination
	 * @return Aa00j12s01
	 */
	@Transactional(readOnly = true)
	public Aa00j12s01 findAa00j21s01(Aa00j12s01 aa00j12s01,
			Aa00j20s01 aa00j20s01, Pagination pagination) {
		Aa00j12s01DaoImpl.logger.info("Método findAa00j21s01");
		StringBuilder where = new StringBuilder(
				Aa00j12s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		where.append("where t1.CRES21 = t2.COD20 AND t1.CMEDF21=?");

		params.add(aa00j12s01.getCmedf12());

		if (aa00j20s01.getCod20() != null) {
			where.append(" AND t2.COD20 = ?");
			params.add(aa00j20s01.getCod20());
		}
		if (aa00j20s01.getAa00j07s01ByCdep20() != null) {
			where.append(" AND t2.CDEP20 = ?");
			params.add(aa00j20s01.getAa00j07s01ByCdep20());
		}
		if (aa00j20s01.getAa00j10s01() != null) {
			where.append(" AND t2.CSALA20 = ?");
			params.add(aa00j20s01.getAa00j10s01());
		}
		if (aa00j20s01.getAa00j07s01ByCdepr20() != null) {
			where.append(" AND t2.CDEPR20 = ?");
			params.add(aa00j20s01.getAa00j07s01ByCdepr20());
		}
		if (aa00j20s01.getSit20() != null) {
			where.append(" AND t2.SIT20 = ?");
			params.add(aa00j20s01.getSit20());
		}
		if (aa00j20s01.getBloq20() != null) {
			where.append(" AND t2.BLOQ20 = ?");
			params.add(aa00j20s01.getBloq20());
		}
		if (aa00j20s01.getSwfhor20() != null) {
			where.append(" AND t2.SWFHOR20 = ?");
			params.add(aa00j20s01.getSwfhor20());
		}
		if (aa00j20s01.getSwconf20() != null) {
			where.append(" AND t2.SWCONF20 = ?");
			params.add(aa00j20s01.getSwconf20());
		}
		if (aa00j20s01.getSwmaile20() != null) {
			where.append(" AND t2.SWMAILE20 = ?");
			params.add(aa00j20s01.getSwmaile20());
		}
		if (aa00j20s01.getSwautc20() != null) {
			where.append(" AND t2.SWAUTC20 = ?");
			params.add(aa00j20s01.getSwautc20());
		}
		if (aa00j20s01.getAsun20() != null) {
			where.append(" AND t2.ASUN20 = ?");
			params.add(aa00j20s01.getAsun20());
		}
		if (aa00j20s01.getDhcom20() != null) {
			where.append(" AND TO_DATE(t2.DHCOM20) = ?");
			params.add(aa00j20s01.getDhcom20());
		}
		if (aa00j20s01.getDhfin20() != null) {
			where.append(" AND TO_DATE(t2.DHFIN20) = ?");
			params.add(aa00j20s01.getDhfin20());
		}
		if (aa00j20s01.getOrgan20() != null) {
			where.append(" AND t2.ORGAN20 = ?");
			params.add(aa00j20s01.getOrgan20());
		}
		if (aa00j20s01.getReser20() != null) {
			where.append(" AND t2.RESER20 = ?");
			params.add(aa00j20s01.getReser20());
		}
		if (aa00j20s01.getAnomd20() != null) {
			where.append(" AND t2.ANOMD20 = ?");
			params.add(aa00j20s01.getAnomd20());
		}
		if (aa00j20s01.getTlfnor20() != null) {
			where.append(" AND t2.TLFNOR20 = ?");
			params.add(aa00j20s01.getTlfnor20());
		}
		if (aa00j20s01.getObs20() != null) {
			where.append(" AND t2.OBS20 = ?");
			params.add(aa00j20s01.getObs20());
		}
		if (aa00j20s01.getDni20() != null) {
			where.append(" AND t2.DNI20 = ?");
			params.add(aa00j20s01.getDni20());
		}
		if (aa00j20s01.getIp20() != null) {
			where.append(" AND t2.IP20 = ?");
			params.add(aa00j20s01.getIp20());
		}
		if (aa00j20s01.getUsub20() != null) {
			where.append(" AND t2.USUB20 = ?");
			params.add(aa00j20s01.getUsub20());
		}
		if (aa00j20s01.getTlfno20() != null) {
			where.append(" AND t2.TLFNO20 = ?");
			params.add(aa00j20s01.getTlfno20());
		}

		StringBuilder query = new StringBuilder(
				"SELECT t2.Cod20 COD20, t2.SIT20 SIT20, t2.BLOQ20 BLOQ20, t2.SWFHOR20 SWFHOR20, t2.SWCONF20 SWCONF20, t2.SWMAILE20 SWMAILE20, t2.SWAUTC20 SWAUTC20, t2.ASUN20 ASUN20, t2.DHCOM20 DHCOM20, t2.DHFIN20 DHFIN20, t2.ORGAN20 ORGAN20, t2.RESER20 RESER20, t2.ANOMD20 ANOMD20, t2.TLFNOR20 TLFNOR20, t2.OBS20 OBS20, t2.DNI20 DNI20, t2.IP20 IP20, t2.USUB20 USUB20, t2.TLFNO20 TLFNO20 FROM Aa00j21t00 t1,AA00J20T00 t2  ");
		query.append(where);

		StringBuilder order = new StringBuilder(
				Aa00j12s01DaoImpl.STRING_BUILDER_INIT);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" order by " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuilder(PaginationManager.getPaginationQuery(
					pagination, query));
		}
		Aa00j12s01DaoImpl.logger.info("SQL " + query);
		Aa00j12s01DaoImpl.logger.info("PARAMS " + params);
		List<Aa00j20s01> listaHijo = this.jdbcTemplate.query(query.toString(),
				new RowMapper<Aa00j20s01>() {
					public Aa00j20s01 mapRow(ResultSet resultSet, int rowNum)
							throws SQLException {
						return new Aa00j20s01(resultSet.getLong("COD20"),
								resultSet.getString("SIT20"), resultSet
										.getInt("BLOQ20"), resultSet
										.getInt("SWFHOR20"), resultSet
										.getInt("SWCONF20"), resultSet
										.getInt("SWMAILE20"), resultSet
										.getInt("SWAUTC20"), resultSet
										.getString("ASUN20"), resultSet
										.getTimestamp("DHCOM20"), resultSet
										.getTimestamp("DHFIN20"), resultSet
										.getString("ORGAN20"), resultSet
										.getString("RESER20"), resultSet
										.getString("ANOMD20"), resultSet
										.getString("TLFNOR20"), resultSet
										.getString("OBS20"), resultSet
										.getString("DNI20"), resultSet
										.getString("IP20"), resultSet
										.getString("USUB20"), resultSet
										.getString("TLFNO20"), null, null,
								null, null);
					}
				}, params.toArray());
		aa00j12s01.setAa00j20s01s(listaHijo);
		return aa00j12s01;
	}

	/**
	 * Counts rows in the Aa00j21s01 table.
	 * 
	 * @param aa00j12s01
	 *            Aa00j12s01
	 * @param aa00j20s01
	 *            Aa00j20s01
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAa00j21s01Count(Aa00j12s01 aa00j12s01, Aa00j20s01 aa00j20s01) {
		Aa00j12s01DaoImpl.logger.info("Método findAa00j21s01Count");
		StringBuilder where = new StringBuilder(
				Aa00j12s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();
		where.append("where t1.CRES21 = t2.COD20 AND t1.CMEDF21=?");

		params.add(aa00j12s01.getCmedf12());

		if (aa00j20s01.getCod20() != null) {
			where.append(" AND t2.COD20 = ?");
			params.add(aa00j20s01.getCod20());
		}
		if (aa00j20s01.getAa00j07s01ByCdep20() != null) {
			where.append(" AND t2.CDEP20 = ?");
			params.add(aa00j20s01.getAa00j07s01ByCdep20());
		}
		if (aa00j20s01.getAa00j10s01() != null) {
			where.append(" AND t2.CSALA20 = ?");
			params.add(aa00j20s01.getAa00j10s01());
		}
		if (aa00j20s01.getAa00j07s01ByCdepr20() != null) {
			where.append(" AND t2.CDEPR20 = ?");
			params.add(aa00j20s01.getAa00j07s01ByCdepr20());
		}
		if (aa00j20s01.getSit20() != null) {
			where.append(" AND t2.SIT20 = ?");
			params.add(aa00j20s01.getSit20());
		}
		if (aa00j20s01.getBloq20() != null) {
			where.append(" AND t2.BLOQ20 = ?");
			params.add(aa00j20s01.getBloq20());
		}
		if (aa00j20s01.getSwfhor20() != null) {
			where.append(" AND t2.SWFHOR20 = ?");
			params.add(aa00j20s01.getSwfhor20());
		}
		if (aa00j20s01.getSwconf20() != null) {
			where.append(" AND t2.SWCONF20 = ?");
			params.add(aa00j20s01.getSwconf20());
		}
		if (aa00j20s01.getSwmaile20() != null) {
			where.append(" AND t2.SWMAILE20 = ?");
			params.add(aa00j20s01.getSwmaile20());
		}
		if (aa00j20s01.getSwautc20() != null) {
			where.append(" AND t2.SWAUTC20 = ?");
			params.add(aa00j20s01.getSwautc20());
		}
		if (aa00j20s01.getAsun20() != null) {
			where.append(" AND t2.ASUN20 = ?");
			params.add(aa00j20s01.getAsun20());
		}
		if (aa00j20s01.getDhcom20() != null) {
			where.append(" AND TO_DATE(t2.DHCOM20) = ?");
			params.add(aa00j20s01.getDhcom20());
		}
		if (aa00j20s01.getDhfin20() != null) {
			where.append(" AND TO_DATE(t2.DHFIN20) = ?");
			params.add(aa00j20s01.getDhfin20());
		}
		if (aa00j20s01.getOrgan20() != null) {
			where.append(" AND t2.ORGAN20 = ?");
			params.add(aa00j20s01.getOrgan20());
		}
		if (aa00j20s01.getReser20() != null) {
			where.append(" AND t2.RESER20 = ?");
			params.add(aa00j20s01.getReser20());
		}
		if (aa00j20s01.getAnomd20() != null) {
			where.append(" AND t2.ANOMD20 = ?");
			params.add(aa00j20s01.getAnomd20());
		}
		if (aa00j20s01.getTlfnor20() != null) {
			where.append(" AND t2.TLFNOR20 = ?");
			params.add(aa00j20s01.getTlfnor20());
		}
		if (aa00j20s01.getObs20() != null) {
			where.append(" AND t2.OBS20 = ?");
			params.add(aa00j20s01.getObs20());
		}
		if (aa00j20s01.getDni20() != null) {
			where.append(" AND t2.DNI20 = ?");
			params.add(aa00j20s01.getDni20());
		}
		if (aa00j20s01.getIp20() != null) {
			where.append(" AND t2.IP20 = ?");
			params.add(aa00j20s01.getIp20());
		}
		if (aa00j20s01.getUsub20() != null) {
			where.append(" AND t2.USUB20 = ?");
			params.add(aa00j20s01.getUsub20());
		}
		if (aa00j20s01.getTlfno20() != null) {
			where.append(" AND t2.TLFNO20 = ?");
			params.add(aa00j20s01.getTlfno20());
		}

		StringBuilder query = new StringBuilder(
				"SELECT count(1) FROM Aa00j21t00 t1,AA00J20T00 t2  ");
		query.append(where);
		Aa00j12s01DaoImpl.logger.info("SQL " + query);
		Aa00j12s01DaoImpl.logger.info("PARAMS " + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	public void addMultiple(List<Aa00j12s01> aa00j12s01) {
		for (Aa00j12s01 o : aa00j12s01) {
			this.add(o);
		}
	}

	public void removeSala(Long csala12) {
		Aa00j12s01DaoImpl.logger.info("Método removeSala");
		String query = "DELETE FROM AA00J12S01 WHERE CSALA12=?";
		Aa00j12s01DaoImpl.logger.info("SQL " + query);
		Aa00j12s01DaoImpl.logger.info("PARAMS " + csala12);
		this.jdbcTemplate.update(query, csala12);
	}

	public List<Aa00j12s01> obtenerMediosFijosSala(Long csala12) {
		Aa00j12s01DaoImpl.logger.info("Método obtenerMediosFijosSala");
		StringBuilder query = new StringBuilder(
				"SELECT t1.CMEDF12 CMEDF12,t1.CSALA12 CSALA12,t1.NOM12 NOM12,t1.SWDISP12 SWDISP12,t1.SIT12 SIT12 ");
		query.append("FROM AA00J12S01 t1 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.CSALA12=? ");
		query.append(where);

		List<Object> params = new ArrayList<Object>();
		params.add(csala12);
		Aa00j12s01DaoImpl.logger.info("SQL " + query);
		Aa00j12s01DaoImpl.logger.info("PARAMS " + params);
		return (List<Aa00j12s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMapCombo, params.toArray());
	}

	public boolean existe(String nombre, Long csala12) {
		Aa00j12s01DaoImpl.logger.info("Método existe");
		String query = "SELECT COUNT(1) FROM AA00J12S01 WHERE UPPER(NOM12) = UPPER(?) AND CSALA12=? ";
		Aa00j12s01DaoImpl.logger.info("SQL " + query);
		Aa00j12s01DaoImpl.logger.info("PARAM1 " + nombre);
		Aa00j12s01DaoImpl.logger.info("PARAM2 " + csala12);
		return this.jdbcTemplate.queryForInt(query, nombre, csala12) > 0;
	}

	public boolean existeEnReserva(String nombre, Long csala12) {
		Aa00j12s01DaoImpl.logger.info("Método existeEnReserva");
		String query = "SELECT COUNT(1) FROM AA00J21S01, AA00J12S01 WHERE UPPER(NOM12) = UPPER(?) AND CSALA12=? AND CMEDF21=CMEDF12";
		Aa00j12s01DaoImpl.logger.info("SQL " + query);
		Aa00j12s01DaoImpl.logger.info("PARAM1 " + nombre);
		Aa00j12s01DaoImpl.logger.info("PARAM2 " + csala12);
		return this.jdbcTemplate.queryForInt(query, nombre, csala12) > 0;
	}

	public boolean borrar(String nombresBorrar, String nombresNoBorrar,
			Long csala12) {
		Aa00j12s01DaoImpl.logger.info("Método borrar");
		String query = "DELETE FROM AA00J12S01 WHERE 1=1 AND CSALA12=? ";
		List<Object> params = new ArrayList<Object>();
		params.add(csala12);

		if (nombresBorrar != null && nombresBorrar.length() > 0) {
			query = query.concat("AND UPPER(NOM12) IN (UPPER(?)) ");
			params.add(nombresBorrar);
		}

		if (nombresNoBorrar != null && nombresNoBorrar.length() > 0) {
			query = query.concat("AND UPPER(NOM12) NOT IN (UPPER(?)) ");
			params.add(nombresNoBorrar);
		}
		Aa00j12s01DaoImpl.logger.info("SQL " + query);
		Aa00j12s01DaoImpl.logger.info("PARAMS " + params);

		return this.jdbcTemplate.update(query, params.toArray()) > 0;
	}

	public List<Aa00j12s01> obtenerMediosFijosSalaReserva(Long cres21) {
		Aa00j12s01DaoImpl.logger.info("Método obtenerMediosFijosSalaReserva");
		StringBuilder query = new StringBuilder(
				"SELECT t1.CMEDF12 CMEDF12,t1.CSALA12 CSALA12,t1.NOM12 NOM12,t1.SWDISP12 SWDISP12,t1.SIT12 SIT12 ");
		query.append("FROM AA00J12S01 t1 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CMEDF12 IN (SELECT CMEDF21 FROM AA00J21S01 WHERE CRES21=?) ");
		query.append(where);

		List<Object> params = new ArrayList<Object>();
		params.add(cres21);
		Aa00j12s01DaoImpl.logger.info("SQL " + query);
		Aa00j12s01DaoImpl.logger.info("PARAMS " + params);
		return (List<Aa00j12s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMapCombo, params.toArray());
	}

	public List<Aa00j12s01> obtenerVarios(String codigos) {
		Aa00j12s01DaoImpl.logger.info("Método obtenerVarios");
		StringBuilder query = new StringBuilder(
				"SELECT t1.CMEDF12 CMEDF12,t1.CSALA12 CSALA12,t1.NOM12 NOM12,t1.SWDISP12 SWDISP12,t1.SIT12 SIT12 ");
		query.append("FROM AA00J12S01 t1 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CMEDF12 IN (" + codigos + ") ");
		query.append(where);
		Aa00j12s01DaoImpl.logger.info("SQL " + query);

		return (List<Aa00j12s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMapCombo);
	}

	/**
	 * Devuelve una lista de medios fijos
	 * 
	 * @return
	 */
	@Override
	public List<Option> getListForOption() {
		Aa00j12s01DaoImpl.logger.info("Método getListForOption");
		StringBuffer query = new StringBuffer("");
		query.append("SELECT DISTINCT nom12 as text, nom12 as value ");
		query.append("	FROM AA00J12T00  ");
		query.append(" WHERE swdisp12=1			ORDER BY nom12");
		Aa00j12s01DaoImpl.logger.info("SQL " + query);

		return this.jdbcTemplate.query(query.toString(), this.optionMap);
	}

}