package com.ejie.aa00j.dao;

import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.lob.DefaultLobHandler;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa00j.model.Aa00j11s01;

/**
 * Aa00j11s01DaoImpl generated by UDA, 16-oct-2013 13:02:12.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class Aa00j11s01DaoImpl implements Aa00j11s01Dao {
	private JdbcTemplate jdbcTemplate;
	private DefaultLobHandler defaultLobHandler;
	private static final Logger logger = LoggerFactory
			.getLogger(Aa00j11s01DaoImpl.class);
	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Aa00j11s01> rwMap = new RowMapper<Aa00j11s01>() {
		public Aa00j11s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa00j11s01(resultSet.getLong("CSALA11"),
					resultSet.getBytes("FOTO11"), resultSet.getBytes("CROQ11"));
		}
	};

	private RowMapper<Aa00j11s01> rwMapPK = new RowMapper<Aa00j11s01>() {
		public Aa00j11s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa00j11s01(resultSet.getLong("CSALA11"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Aa00j11s01>> rwMapJerarquia = new RowMapper<JerarquiaDto<Aa00j11s01>>() {
		public JerarquiaDto<Aa00j11s01> mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Aa00j11s01 aa00j11s01 = new Aa00j11s01(
					resultSet.getLong("CSALA11"),
					defaultLobHandler.getBlobAsBytes(resultSet, "FOTO11"),
					defaultLobHandler.getBlobAsBytes(resultSet, "CROQ11"));

			JerarquiaDto<Aa00j11s01> jerarquia = new JerarquiaDto<Aa00j11s01>();
			jerarquia.setModel(aa00j11s01);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet
					.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet
					.getString("FILTER")));
			return jerarquia;
		}
	};

	private RowMapper<byte[]> fotoRowMapper = new RowMapper<byte[]>() {
		public byte[] mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return (defaultLobHandler.getBlobAsBytes(resultSet, "FOTO11"));
		}
	};

	private RowMapper<byte[]> croquisRowMapper = new RowMapper<byte[]>() {
		public byte[] mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return (defaultLobHandler.getBlobAsBytes(resultSet, "CROQ11"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);

		// TODO: Sacar esto de aqui
		this.defaultLobHandler = new DefaultLobHandler();
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Aa00j11s01 table.
	 * 
	 * @param aa00j11s01
	 *            Aa00j11s01
	 * @return Aa00j11s01
	 */
	public Aa00j11s01 add(Aa00j11s01 aa00j11s01) {
		Aa00j11s01DaoImpl.logger.info("Método add");
		String query = "INSERT INTO AA00J11S01 (CSALA11, FOTO11, CROQ11) VALUES (?,?,?)";
		Aa00j11s01DaoImpl.logger.info("SQL " + query);
		Aa00j11s01DaoImpl.logger.info("PARAM1 " + aa00j11s01.getCsala11());
		Aa00j11s01DaoImpl.logger.info("PARAM2 " + aa00j11s01.getFoto11());
		Aa00j11s01DaoImpl.logger.info("PARAM3 " + aa00j11s01.getCroq11());
		this.jdbcTemplate.update(query, aa00j11s01.getCsala11(),
				aa00j11s01.getFoto11(), aa00j11s01.getCroq11());
		return aa00j11s01;
	}

	/**
	 * Updates a single row in the Aa00j11s01 table.
	 * 
	 * @param aa00j11s01
	 *            Aa00j11s01
	 * @return Aa00j11s01
	 */
	public Aa00j11s01 update(Aa00j11s01 aa00j11s01) {
		Aa00j11s01DaoImpl.logger.info("Método update");
		String query = "UPDATE AA00J11S01 SET FOTO11=?, CROQ11=? WHERE CSALA11=?";
		Aa00j11s01DaoImpl.logger.info("SQL " + query);
		Aa00j11s01DaoImpl.logger.info("PARAM1 " + aa00j11s01.getFoto11());
		Aa00j11s01DaoImpl.logger.info("PARAM2 " + aa00j11s01.getCroq11());
		Aa00j11s01DaoImpl.logger.info("PARAM3 " + aa00j11s01.getCsala11());
		this.jdbcTemplate.update(query, aa00j11s01.getFoto11(),
				aa00j11s01.getCroq11(), aa00j11s01.getCsala11());
		return aa00j11s01;
	}

	/**
	 * Finds a single row in the Aa00j11s01 table.
	 * 
	 * @param aa00j11s01
	 *            Aa00j11s01
	 * @return Aa00j11s01
	 */
	@Transactional(readOnly = true)
	public Aa00j11s01 find(Aa00j11s01 aa00j11s01) {
		Aa00j11s01DaoImpl.logger.info("Método find");
		String query = "SELECT t1.CSALA11 CSALA11, t1.FOTO11 FOTO11, t1.CROQ11 CROQ11 FROM AA00J11S01 t1  WHERE t1.CSALA11 = ?  ";
		Aa00j11s01DaoImpl.logger.info("SQL " + query);
		Aa00j11s01DaoImpl.logger.info("PARAM1 " + aa00j11s01.getCsala11());
		List<Aa00j11s01> aa00j11s01List = this.jdbcTemplate.query(query,
				this.rwMap, aa00j11s01.getCsala11());
		return (Aa00j11s01) DataAccessUtils.uniqueResult(aa00j11s01List);
	}

	/**
	 * Removes a single row in the Aa00j11s01 table.
	 * 
	 * @param aa00j11s01
	 *            Aa00j11s01
	 * @return
	 */
	public void remove(Aa00j11s01 aa00j11s01) {
		Aa00j11s01DaoImpl.logger.info("Método remove");
		String query = "DELETE FROM AA00J11S01 WHERE CSALA11=?";
		Aa00j11s01DaoImpl.logger.info("SQL " + query);
		Aa00j11s01DaoImpl.logger.info("PARAM1 " + aa00j11s01.getCsala11());
		this.jdbcTemplate.update(query, aa00j11s01.getCsala11());
	}

	/**
	 * Finds a list of rows in the Aa00j11s01 table.
	 * 
	 * @param aa00j11s01
	 *            Aa00j11s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa00j11s01>
	 */
	@Transactional(readOnly = true)
	public List<Aa00j11s01> findAll(Aa00j11s01 aa00j11s01,
			JQGridRequestDto jqGridRequestDto) {
		Aa00j11s01DaoImpl.logger.info("Método findAll");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CSALA11 CSALA11,t1.FOTO11 FOTO11,t1.CROQ11 CROQ11 ");
		query.append("FROM AA00J11S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa00j11s01);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		Aa00j11s01DaoImpl.logger.info("SQL " + query);
		Aa00j11s01DaoImpl.logger.info("PARAMS " + params);
		return (List<Aa00j11s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Aa00j11s01 table using like.
	 * 
	 * @param aa00j11s01
	 *            Aa00j11s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa00j11s01>
	 */
	@Transactional(readOnly = true)
	public List<Aa00j11s01> findAllLike(Aa00j11s01 aa00j11s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		Aa00j11s01DaoImpl.logger.info("Método findAllLike");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CSALA11 CSALA11,t1.FOTO11 FOTO11,t1.CROQ11 CROQ11 ");
		query.append("FROM AA00J11S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa00j11s01, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		Aa00j11s01DaoImpl.logger.info("SQL " + query);
		Aa00j11s01DaoImpl.logger.info("PARAMS " + params);
		return (List<Aa00j11s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Aa00j11s01 table.
	 * 
	 * @param aa00j11s01
	 *            Aa00j11s01
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Aa00j11s01 aa00j11s01) {
		Aa00j11s01DaoImpl.logger.info("Método findAllCount");
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA00J11S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa00j11s01);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j11s01DaoImpl.logger.info("SQL " + query);
		Aa00j11s01DaoImpl.logger.info("PARAMS " + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Aa00j11s01 table using like.
	 * 
	 * @param aa00j11s01
	 *            Aa00j11s01
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Aa00j11s01 aa00j11s01, Boolean startsWith) {
		Aa00j11s01DaoImpl.logger.info("Método findAllLikeCount");
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA00J11S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa00j11s01, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j11s01DaoImpl.logger.info("SQL " + query);
		Aa00j11s01DaoImpl.logger.info("PARAMS " + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Aa00j11s01 selected for rup_table
	 * 
	 * @param aa00j11s01
	 *            Aa00j11s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j11s01>>
	 */
	@Override
	public List<TableRowDto<Aa00j11s01>> reorderSelection(
			Aa00j11s01 aa00j11s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		Aa00j11s01DaoImpl.logger.info("Método reorderSelection");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CSALA11 CSALA11,t1.FOTO11 FOTO11,t1.CROQ11 CROQ11 ");
		// FROM
		query.append("FROM AA00J11S01 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa00j11s01, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, Aa00j11s01.class, filterParamList,
				"CSALA11");
		Aa00j11s01DaoImpl.logger.info("SQL " + sbReorderSelectionSQL);
		Aa00j11s01DaoImpl.logger.info("PARAMS " + filterParamList);
		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa00j11s01>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * @param filterParams
	 *            Aa00j11s01
	 * @param searchParams
	 *            Aa00j11s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j11s01>>
	 */
	@Override
	public List<TableRowDto<Aa00j11s01>> search(Aa00j11s01 filterParams,
			Aa00j11s01 searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		Aa00j11s01DaoImpl.logger.info("Método search");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CSALA11 CSALA11,t1.FOTO11 FOTO11,t1.CROQ11 CROQ11 ");
		// FROM
		query.append("FROM AA00J11S01 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, Aa00j11s01.class, filterParamList,
				searchSQL, searchParamList, from_alias, "CSALA11");
		Aa00j11s01DaoImpl.logger.info("SQL " + sbReorderSelectionSQL);
		Aa00j11s01DaoImpl.logger.info("PARAMS " + filterParamList);
		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa00j11s01>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 * 
	 * @param filteraa00j11s01
	 *            Aa00j11s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Aa00j11s01 filteraa00j11s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		Aa00j11s01DaoImpl.logger.info("Método removeMultiple");
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.CSALA11 CSALA11,t1.FOTO11 FOTO11,t1.CROQ11 CROQ11 ");
		// FROM
		query.append("FROM AA00J11S01 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filteraa00j11s01,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto, Aa00j11s01.class,
						query, params, "CSALA11");
		Aa00j11s01DaoImpl.logger.info("SQL " + sbRemoveMultipleSQL);
		Aa00j11s01DaoImpl.logger.info("PARAMS " + params);
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical Aa00j11s01 table.
	 * 
	 * @param filterAa00j11s01
	 *            Aa00j11s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Aa00j11s01>>
	 */
	@Override
	public List<JerarquiaDto<Aa00j11s01>> findAllLikeJerarquia(
			Aa00j11s01 filterAa00j11s01, JQGridRequestDto jqGridRequestDto) {
		Aa00j11s01DaoImpl.logger.info("Método findAllLikeJerarquia");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CSALA11 CSALA11,t1.FOTO11 FOTO11,t1.CROQ11 CROQ11 ");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA00J11S01 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA00J11S01");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa00j11s01, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
				mapaWhere, "CSALA11", "ID_PADRE", "NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j11s01DaoImpl.logger.info("SQL " + query);
		Aa00j11s01DaoImpl.logger.info("PARAMS " + params);
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAa00j11s01
	 *            Aa00j11s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Aa00j11s01 filterAa00j11s01,
			JQGridRequestDto jqGridRequestDto) {
		Aa00j11s01DaoImpl.logger.info("Método findAllLikeCountJerarquia");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA00J11S01 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA00J11S01");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa00j11s01, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(
				jqGridRequestDto, mapaWhere, "CSALA11", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j11s01DaoImpl.logger.info("SQL " + query);
		Aa00j11s01DaoImpl.logger.info("PARAMS " + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAa00j11s01
	 *            Aa00j11s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Aa00j11s01>>
	 */
	@Override
	public List<TableRowDto<Aa00j11s01>> findAllChild(
			Aa00j11s01 filterAa00j11s01, JQGridRequestDto jqGridRequestDto) {
		Aa00j11s01DaoImpl.logger.info("Método findAllChild");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA00J11S01 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA00J11S01");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa00j11s01, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(
				jqGridRequestDto, mapaWhere, "CSALA11", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j11s01DaoImpl.logger.info("SQL " + query);
		Aa00j11s01DaoImpl.logger.info("PARAMS " + params);
		return this.jdbcTemplate.query(query.toString(),
				new RowNumResultSetExtractor<Aa00j11s01>(this.rwMapPK,
						"CSALA11"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa00j11s01 entity
	 * 
	 * @param aa00j11s01
	 *            Aa00j11s01 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Aa00j11s01 aa00j11s01) {

		StringBuilder where = new StringBuilder(
				Aa00j11s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa00j11s01 != null && aa00j11s01.getCsala11() != null) {
			where.append(" AND t1.CSALA11 = ?");
			params.add(aa00j11s01.getCsala11());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa00j11s01 entity
	 * 
	 * @param aa00j11s01
	 *            Aa00j11s01 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Aa00j11s01 aa00j11s01,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				Aa00j11s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa00j11s01 != null && aa00j11s01.getCsala11() != null) {
			where.append(" AND t1.CSALA11 = ?");
			params.add(aa00j11s01.getCsala11());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	public void removeSala(Long csala11) {
		Aa00j11s01DaoImpl.logger.info("Método removeSala");
		String query = "DELETE FROM AA00J11S01 WHERE CSALA11=?";
		Aa00j11s01DaoImpl.logger.info("SQL " + query);
		Aa00j11s01DaoImpl.logger.info("PARAM1 " + csala11);
		this.jdbcTemplate.update(query, csala11);
	}

	public void removeFoto(Long csala11) {
		Aa00j11s01DaoImpl.logger.info("Método removeFoto");
		String query = "UPDATE AA00J11S01 SET FOTO11=null WHERE CSALA11=?";
		Aa00j11s01DaoImpl.logger.info("SQL " + query);
		Aa00j11s01DaoImpl.logger.info("PARAM1 " + csala11);
		this.jdbcTemplate.update(query, csala11);
	}

	public void removeCroquis(Long csala11) {
		Aa00j11s01DaoImpl.logger.info("Método removeCroquis");
		String query = "UPDATE AA00J11S01 SET CROQ11=null WHERE CSALA11=?";
		Aa00j11s01DaoImpl.logger.info("SQL " + query);
		Aa00j11s01DaoImpl.logger.info("PARAM1 " + csala11);
		this.jdbcTemplate.update(query, csala11);
	}

	@Transactional(readOnly = true)
	public byte[] obtenerFoto(Long csala11) {
		Aa00j11s01DaoImpl.logger.info("Método obtenerFoto");
		String query = "SELECT t1.FOTO11 FOTO11 FROM AA00J11S01 t1 WHERE t1.CSALA11=?";
		Aa00j11s01DaoImpl.logger.info("SQL " + query);
		Aa00j11s01DaoImpl.logger.info("PARAM1 " + csala11);
		List<byte[]> listaResultado = this.jdbcTemplate.query(query,
				this.fotoRowMapper, csala11);
		if (listaResultado != null && listaResultado.size() > 0) {
			return listaResultado.get(0);
		} else {
			return null;
		}
	}

	@Transactional(readOnly = true)
	public byte[] obtenerCroquis(Long csala11) {
		Aa00j11s01DaoImpl.logger.info("Método obtenerCroquis");
		String query = "SELECT t1.CROQ11 CROQ11 FROM AA00J11S01 t1 WHERE t1.CSALA11=?";
		Aa00j11s01DaoImpl.logger.info("SQL " + query);
		Aa00j11s01DaoImpl.logger.info("PARAM1 " + csala11);
		List<byte[]> listaResultado = this.jdbcTemplate.query(query,
				this.croquisRowMapper, csala11);
		if (listaResultado != null && listaResultado.size() > 0) {
			return listaResultado.get(0);
		} else {
			return null;
		}
	}

	/**
	 * Devuelve si existe la foto
	 * 
	 * @param aa00j11s01
	 * @return
	 */
	public boolean tieneFoto(Aa00j11s01 aa00j11s01) {
		Aa00j11s01DaoImpl.logger.info("Método tieneFoto");
		int cop = this.jdbcTemplate
				.queryForInt("select count (*) from AA00J11S01 where CSALA11="
						+ aa00j11s01.getCsala11());
		Aa00j11s01DaoImpl.logger
				.info("SQL select count (*) from AA00J11S01 where CSALA11");
		Aa00j11s01DaoImpl.logger.info("PARAM1 " + aa00j11s01.getCsala11());
		return cop > 0;
	}

	public boolean updateFoto(Aa00j11s01 aa00j11s01) {
		Aa00j11s01DaoImpl.logger.info("Método updateFoto");
		String query = "UPDATE AA00J11S01 SET FOTO11=? WHERE CSALA11=?";
		Aa00j11s01DaoImpl.logger.info("SQL " + query);
		Aa00j11s01DaoImpl.logger.info("PARAM1 " + aa00j11s01.getFoto11());
		Aa00j11s01DaoImpl.logger.info("PARAM2 " + aa00j11s01.getCsala11());
		int ret = this.jdbcTemplate.update(query, aa00j11s01.getFoto11(),
				aa00j11s01.getCsala11());
		return ret > 0;
	}

	public boolean updateCroquis(Aa00j11s01 aa00j11s01) {
		Aa00j11s01DaoImpl.logger.info("Método updateCroquis");
		String query = "UPDATE AA00J11S01 SET CROQ11=? WHERE CSALA11=?";
		Aa00j11s01DaoImpl.logger.info("SQL " + query);
		Aa00j11s01DaoImpl.logger.info("PARAM1 " + aa00j11s01.getCroq11());
		Aa00j11s01DaoImpl.logger.info("PARAM2 " + aa00j11s01.getCsala11());
		int ret = this.jdbcTemplate.update(query, aa00j11s01.getCroq11(),
				aa00j11s01.getCsala11());
		return ret > 0;
	}
}