package com.ejie.aa00j.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.jdbc.support.lob.DefaultLobHandler;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import weblogic.utils.StringUtils;

import com.ejie.aa00j.classes.aa00jConstantes;
import com.ejie.aa00j.classes.aa00jPersonaSesion;
import com.ejie.aa00j.classes.aa00jSeguridad;
import com.ejie.aa00j.model.Aa00j02s01;
import com.ejie.aa00j.model.Aa00j03s01;
import com.ejie.aa00j.model.Aa00j04s01;
import com.ejie.aa00j.model.Aa00j06s01;
import com.ejie.aa00j.model.Aa00j07s01;
import com.ejie.aa00j.model.Aa00j10s01;
import com.ejie.aa00j.model.Aa00j11s01;
import com.ejie.aa00j.model.Option;
import com.ejie.aa00j.model.forms.FormConsultaAsistida;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa00j10s01DaoImpl generated by UDA, 16-oct-2013 13:02:12.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class Aa00j10s01DaoImpl implements Aa00j10s01Dao {
	private JdbcTemplate jdbcTemplate;
	private DefaultLobHandler defaultLobHandler;
	private static final Logger logger = LoggerFactory
			.getLogger(Aa00j10s01DaoImpl.class);
	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Aa00j10s01> rwMap = new RowMapper<Aa00j10s01>() {
		public Aa00j10s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa00j10s01(resultSet.getLong("CSALA10"),
					resultSet.getString("NOMBRE10"),
					resultSet.getString("SIT10"), resultSet.getInt("BLOQ10"),
					resultSet.getInt("SWDISP10"),
					resultSet.getString("DESC10"),
					resultSet.getString("TLFNO10"),
					resultSet.getString("USUB10"),
					resultSet.getString("PLANTA10"),
					resultSet.getString("DCAPC10"),
					resultSet.getString("DCAPE10"),
					resultSet.getLong("NCAP10"), new Aa00j07s01(
							resultSet.getLong("Aa00j07s01CDEP07"),
							resultSet.getString("Aa00j07s01DESCC07"),
							resultSet.getString("Aa00j07s01DESCE07"),
							resultSet.getString("Aa00j07s01SIT07"),
							resultSet.getInt("Aa00j07s01BLOQ07"),
							resultSet.getString("Aa00j07s01USUB07"),
							resultSet.getString("Aa00j07s01COD_XLNET_07")),
					new Aa00j03s01(resultSet.getLong("Aa00j03s01CEDIF03"),
							resultSet.getString("Aa00j03s01NOMBRE03"),
							resultSet.getString("Aa00j03s01SIT03"), resultSet
									.getInt("Aa00j03s01BLOQ03"), resultSet
									.getString("Aa00j03s01TLFNO03"), resultSet
									.getString("Aa00j03s01USUB03"),
							new Aa00j02s01(resultSet
									.getLong("Aa00j03s01CSITIO03"), null, null,
									null, null, null)), new Aa00j06s01(
							resultSet.getLong("Aa00j06s01CREST06"),
							resultSet.getString("Aa00j06s01DESCC06"),
							resultSet.getString("Aa00j06s01DESCE06"),
							resultSet.getString("Aa00j06s01SIT06"),
							resultSet.getInt("Aa00j06s01BLOQ06"),
							resultSet.getString("Aa00j06s01MENC06"),
							resultSet.getString("Aa00j06s01MENE06"),
							resultSet.getString("Aa00j06s01USUB06")),
					new Aa00j04s01(resultSet.getLong("Aa00j04s01CTEXTO04"),
							resultSet.getString("Aa00j04s01TTEXTO04"),
							resultSet.getString("Aa00j04s01TRESC04"), resultSet
									.getString("Aa00j04s01TRESE04"), resultSet
									.getString("Aa00j04s01SIT04"), resultSet
									.getInt("Aa00j04s01BLOQ04"), resultSet
									.getString("Aa00j04s01USUB04")),
					// new Aa00j11s01(resultSet.getLong("Aa00j11s01CSALA11"),
					// defaultLobHandler.getBlobAsBytes(resultSet,
					// "Aa00j11s01FOTO11"), defaultLobHandler
					// .getBlobAsBytes(resultSet,
					// "Aa00j11s01CROQ11")));
					/*
					 * Comentado por Iker para que impida la carga de los campos
					 * BLOB de imágenes. También he modificado la select
					 */
					new Aa00j11s01());
		}
	};

	private RowMapper<Aa00j10s01> rwMapPK = new RowMapper<Aa00j10s01>() {
		public Aa00j10s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa00j10s01(resultSet.getLong("CSALA10"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Aa00j10s01>> rwMapJerarquia = new RowMapper<JerarquiaDto<Aa00j10s01>>() {
		public JerarquiaDto<Aa00j10s01> mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Aa00j10s01 aa00j10s01 = new Aa00j10s01(
					resultSet.getLong("CSALA10"),
					resultSet.getString("NOMBRE10"),
					resultSet.getString("SIT10"), resultSet.getInt("BLOQ10"),
					resultSet.getInt("SWDISP10"),
					resultSet.getString("DESC10"),
					resultSet.getString("TLFNO10"),
					resultSet.getString("USUB10"),
					resultSet.getString("PLANTA10"),
					resultSet.getString("DCAPC10"),
					resultSet.getString("DCAPE10"),
					resultSet.getLong("NCAP10"), new Aa00j07s01(
							resultSet.getLong("Aa00j07s01CDEP07"),
							resultSet.getString("Aa00j07s01DESCC07"),
							resultSet.getString("Aa00j07s01DESCE07"),
							resultSet.getString("Aa00j07s01SIT07"),
							resultSet.getInt("Aa00j07s01BLOQ07"),
							resultSet.getString("Aa00j07s01USUB07"),
							resultSet.getString("Aa00j07s01COD_XLNET_07")),
					new Aa00j03s01(resultSet.getLong("Aa00j03s01CEDIF03"),
							resultSet.getString("Aa00j03s01NOMBRE03"),
							resultSet.getString("Aa00j03s01SIT03"), resultSet
									.getInt("Aa00j03s01BLOQ03"), resultSet
									.getString("Aa00j03s01TLFNO03"), resultSet
									.getString("Aa00j03s01USUB03"),
							new Aa00j02s01(resultSet
									.getLong("Aa00j03s01CSITIO03"), null, null,
									null, null, null)), new Aa00j06s01(
							resultSet.getLong("Aa00j06s01CREST06"),
							resultSet.getString("Aa00j06s01DESCC06"),
							resultSet.getString("Aa00j06s01DESCE06"),
							resultSet.getString("Aa00j06s01SIT06"),
							resultSet.getInt("Aa00j06s01BLOQ06"),
							resultSet.getString("Aa00j06s01MENC06"),
							resultSet.getString("Aa00j06s01MENE06"),
							resultSet.getString("Aa00j06s01USUB06")),
					new Aa00j04s01(resultSet.getLong("Aa00j04s01CTEXTO04"),
							resultSet.getString("Aa00j04s01TTEXTO04"),
							resultSet.getString("Aa00j04s01TRESC04"), resultSet
									.getString("Aa00j04s01TRESE04"), resultSet
									.getString("Aa00j04s01SIT04"), resultSet
									.getInt("Aa00j04s01BLOQ04"), resultSet
									.getString("Aa00j04s01USUB04")),
					new Aa00j11s01(resultSet.getLong("Aa00j11s01CSALA11"),
							defaultLobHandler.getBlobAsBytes(resultSet,
									"Aa00j11s01FOTO11"), defaultLobHandler
									.getBlobAsBytes(resultSet,
											"Aa00j11s01CROQ11")));

			JerarquiaDto<Aa00j10s01> jerarquia = new JerarquiaDto<Aa00j10s01>();
			jerarquia.setModel(aa00j10s01);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet
					.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet
					.getString("FILTER")));
			return jerarquia;
		}
	};

	private RowMapper<Aa00j10s01> rwMapCombo = new RowMapper<Aa00j10s01>() {
		public Aa00j10s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa00j10s01(resultSet.getLong("CSALA10"),
					resultSet.getString("NOMBRE10"), "", 0, 0, "", "", "", "",
					"", "", (long) 0, null, null, null, null, null);
		}
	};
	private RowMapper<Aa00j10s01> rwMapConsultaActiva = new RowMapper<Aa00j10s01>() {
		public Aa00j10s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Aa00j10s01 salida = new Aa00j10s01();
			salida.setNombre10(resultSet.getString("NOMBRE10"));
			salida.setCsala10(resultSet.getLong("csala10"));
			salida.setNcap10(resultSet.getLong("ncap10"));
			Aa00j06s01 restriccion = new Aa00j06s01();
			restriccion.setCrest06(resultSet.getLong("CREST06"));
			restriccion.setDescc06(resultSet.getString("DESCC06"));
			restriccion.setDesce06(resultSet.getString("DESCE06"));
			salida.setAa00j06s01(restriccion);
			return salida;

		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);

		// TODO: Sacar esto de aqui
		this.defaultLobHandler = new DefaultLobHandler();
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Aa00j10s01 table.
	 * 
	 * @param aa00j10s01
	 *            Aa00j10s01
	 * @return Aa00j10s01
	 */
	public Aa00j10s01 add(final Aa00j10s01 aa00j10s01) {
		if (aa00j10s01.getSit10() == null
				|| aa00j10s01.getSit10().length() == 0)
			aa00j10s01.setSit10(aa00jConstantes.SITUACION_ALTA);
		Aa00j10s01DaoImpl.logger.info("Método add");
		final String queryUltimoId = "(SELECT NVL(MAX(TO_NUMBER(CSALA10)), 0) + 1 FROM AA00J10S01)";
		final String query = "INSERT INTO AA00J10S01 (CSALA10, CDEP10, CEDIF10, CREST10, CTEXTO10, NOMBRE10, SIT10, BLOQ10, SWDISP10, DESC10, TLFNO10, USUB10, PLANTA10, DCAPC10, DCAPE10, NCAP10) VALUES ("
				+ queryUltimoId + ",?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		final Object getAa00j07s01Cdep07Aux;
		if (aa00j10s01.getAa00j07s01() != null
				&& aa00j10s01.getAa00j07s01().getCdep07() != null) {
			getAa00j07s01Cdep07Aux = aa00j10s01.getAa00j07s01().getCdep07();
		} else {
			getAa00j07s01Cdep07Aux = null;
		}
		final Object getAa00j03s01Cedif03Aux;
		if (aa00j10s01.getAa00j03s01() != null
				&& aa00j10s01.getAa00j03s01().getCedif03() != null) {
			getAa00j03s01Cedif03Aux = aa00j10s01.getAa00j03s01().getCedif03();
		} else {
			getAa00j03s01Cedif03Aux = null;
		}
		final Object getAa00j06s01Crest06Aux;
		if (aa00j10s01.getAa00j06s01() != null
				&& aa00j10s01.getAa00j06s01().getCrest06() != null) {
			getAa00j06s01Crest06Aux = aa00j10s01.getAa00j06s01().getCrest06();
		} else {
			getAa00j06s01Crest06Aux = null;
		}
		final Object getAa00j04s01Ctexto04Aux;
		if (aa00j10s01.getAa00j04s01() != null
				&& aa00j10s01.getAa00j04s01().getCtexto04() != null) {
			getAa00j04s01Ctexto04Aux = aa00j10s01.getAa00j04s01().getCtexto04();
		} else {
			getAa00j04s01Ctexto04Aux = null;
		}

		KeyHolder keyHolder = new GeneratedKeyHolder();
		Aa00j10s01DaoImpl.logger.info("SQL " + query);
		Aa00j10s01DaoImpl.logger.info("PARAM1 " + getAa00j07s01Cdep07Aux);
		Aa00j10s01DaoImpl.logger.info("PARAM2 " + getAa00j03s01Cedif03Aux);
		Aa00j10s01DaoImpl.logger.info("PARAM3 " + getAa00j06s01Crest06Aux);
		Aa00j10s01DaoImpl.logger.info("PARAM4 " + getAa00j04s01Ctexto04Aux);
		Aa00j10s01DaoImpl.logger.info("PARAM5 " + aa00j10s01.getNombre10());
		Aa00j10s01DaoImpl.logger.info("PARAM6 " + aa00j10s01.getSit10());
		Aa00j10s01DaoImpl.logger.info("PARAM7 " + 0);
		Aa00j10s01DaoImpl.logger.info("PARAM8 " + aa00j10s01.getSwdisp10());
		Aa00j10s01DaoImpl.logger.info("PARAM9 " + aa00j10s01.getDesc10());
		Aa00j10s01DaoImpl.logger.info("PARAM10 " + aa00j10s01.getTlfno10());
		Aa00j10s01DaoImpl.logger.info("PARAM11 " + null);
		Aa00j10s01DaoImpl.logger.info("PARAM12 " + aa00j10s01.getPlanta10());
		Aa00j10s01DaoImpl.logger.info("PARAM13 " + aa00j10s01.getDcapc10());
		Aa00j10s01DaoImpl.logger.info("PARAM14 " + aa00j10s01.getDcape10());
		Aa00j10s01DaoImpl.logger.info("PARAM15 " + aa00j10s01.getNcap10());

		jdbcTemplate.update(new PreparedStatementCreator() {
			public PreparedStatement createPreparedStatement(
					Connection connection) throws SQLException {
				PreparedStatement ps = connection.prepareStatement(query,
						new String[] { "CSALA10" });
				ps.setObject(1, getAa00j07s01Cdep07Aux);
				ps.setObject(2, getAa00j03s01Cedif03Aux);
				ps.setObject(3, getAa00j06s01Crest06Aux);
				ps.setObject(4, getAa00j04s01Ctexto04Aux);
				ps.setString(5, aa00j10s01.getNombre10());
				ps.setString(6, aa00j10s01.getSit10());
				ps.setObject(7, 0);
				ps.setObject(8, aa00j10s01.getSwdisp10());
				ps.setString(9, aa00j10s01.getDesc10());
				ps.setString(10, aa00j10s01.getTlfno10());
				ps.setString(11, null);
				ps.setString(12, aa00j10s01.getPlanta10());
				ps.setString(13, aa00j10s01.getDcapc10());
				ps.setString(14, aa00j10s01.getDcape10());
				ps.setObject(15, aa00j10s01.getNcap10());
				return ps;
			}
		}, keyHolder);

		aa00j10s01.setCsala10(keyHolder.getKey().longValue());

		return aa00j10s01;
	}

	/**
	 * Updates a single row in the Aa00j10s01 table.
	 * 
	 * @param aa00j10s01
	 *            Aa00j10s01
	 * @return Aa00j10s01
	 */
	public Aa00j10s01 update(Aa00j10s01 aa00j10s01) {
		if (aa00j10s01.getSit10() == null
				|| aa00j10s01.getSit10().length() == 0)
			aa00j10s01.setSit10(aa00jConstantes.SITUACION_ALTA);
		Aa00j10s01DaoImpl.logger.info("Método update");
		String query = "UPDATE AA00J10S01 SET CDEP10=?, CEDIF10=?, CREST10=?, CTEXTO10=?, NOMBRE10=?, SIT10=?, BLOQ10=?, SWDISP10=?, DESC10=?, TLFNO10=?, USUB10=?, PLANTA10=?, DCAPC10=?, DCAPE10=?, NCAP10=? WHERE CSALA10=?";
		Object getAa00j07s01Cdep07Aux = null;
		if (aa00j10s01.getAa00j07s01() != null
				&& aa00j10s01.getAa00j07s01().getCdep07() != null) {
			getAa00j07s01Cdep07Aux = aa00j10s01.getAa00j07s01().getCdep07();
		}
		Object getAa00j03s01Cedif03Aux = null;
		if (aa00j10s01.getAa00j03s01() != null
				&& aa00j10s01.getAa00j03s01().getCedif03() != null) {
			getAa00j03s01Cedif03Aux = aa00j10s01.getAa00j03s01().getCedif03();
		}
		Object getAa00j06s01Crest06Aux = null;
		if (aa00j10s01.getAa00j06s01() != null
				&& aa00j10s01.getAa00j06s01().getCrest06() != null) {
			getAa00j06s01Crest06Aux = aa00j10s01.getAa00j06s01().getCrest06();
		}
		Object getAa00j04s01Ctexto04Aux = null;
		if (aa00j10s01.getAa00j04s01() != null
				&& aa00j10s01.getAa00j04s01().getCtexto04() != null) {
			getAa00j04s01Ctexto04Aux = aa00j10s01.getAa00j04s01().getCtexto04();
		}
		Aa00j10s01DaoImpl.logger.info("SQL " + query);
		Aa00j10s01DaoImpl.logger.info("PARAM1 " + getAa00j07s01Cdep07Aux);
		Aa00j10s01DaoImpl.logger.info("PARAM2 " + getAa00j03s01Cedif03Aux);
		Aa00j10s01DaoImpl.logger.info("PARAM3 " + getAa00j06s01Crest06Aux);
		Aa00j10s01DaoImpl.logger.info("PARAM4 " + getAa00j04s01Ctexto04Aux);
		Aa00j10s01DaoImpl.logger.info("PARAM5 " + aa00j10s01.getNombre10());
		Aa00j10s01DaoImpl.logger.info("PARAM6 " + aa00j10s01.getSit10());
		Aa00j10s01DaoImpl.logger.info("PARAM7 " + aa00j10s01.getBloq10());
		Aa00j10s01DaoImpl.logger.info("PARAM8 " + aa00j10s01.getSwdisp10());
		Aa00j10s01DaoImpl.logger.info("PARAM9 " + aa00j10s01.getDesc10());
		Aa00j10s01DaoImpl.logger.info("PARAM10 " + aa00j10s01.getTlfno10());
		Aa00j10s01DaoImpl.logger.info("PARAM11 " + aa00j10s01.getUsub10());
		Aa00j10s01DaoImpl.logger.info("PARAM12 " + aa00j10s01.getPlanta10());
		Aa00j10s01DaoImpl.logger.info("PARAM13 " + aa00j10s01.getDcapc10());
		Aa00j10s01DaoImpl.logger.info("PARAM14 " + aa00j10s01.getDcape10());
		Aa00j10s01DaoImpl.logger.info("PARAM15 " + aa00j10s01.getNcap10());
		Aa00j10s01DaoImpl.logger.info("PARAM16 " + aa00j10s01.getCsala10());
		this.jdbcTemplate.update(query, getAa00j07s01Cdep07Aux,
				getAa00j03s01Cedif03Aux, getAa00j06s01Crest06Aux,
				getAa00j04s01Ctexto04Aux, aa00j10s01.getNombre10(),
				aa00j10s01.getSit10(), aa00j10s01.getBloq10(),
				aa00j10s01.getSwdisp10(), aa00j10s01.getDesc10(),
				aa00j10s01.getTlfno10(), aa00j10s01.getUsub10(),
				aa00j10s01.getPlanta10(), aa00j10s01.getDcapc10(),
				aa00j10s01.getDcape10(), aa00j10s01.getNcap10(),
				aa00j10s01.getCsala10());
		return aa00j10s01;
	}

	/**
	 * Finds a single row in the Aa00j10s01 table.
	 * 
	 * @param aa00j10s01
	 *            Aa00j10s01
	 * @return Aa00j10s01
	 */
	@Transactional(readOnly = true)
	public Aa00j10s01 find(Aa00j10s01 aa00j10s01) {
		Aa00j10s01DaoImpl.logger.info("Método find");
		String query = "SELECT t1.CSALA10 CSALA10, t1.NOMBRE10 NOMBRE10, t1.SIT10 SIT10, t1.BLOQ10 BLOQ10, t1.SWDISP10 SWDISP10, t1.DESC10 DESC10, t1.TLFNO10 TLFNO10, t1.USUB10 USUB10, t1.PLANTA10 PLANTA10, t1.DCAPC10 DCAPC10, t1.DCAPE10 DCAPE10, t1.NCAP10 NCAP10, t2.CDEP07 AA00J07S01CDEP07, t2.DESCC07 AA00J07S01DESCC07, t2.DESCE07 AA00J07S01DESCE07, t2.SIT07 AA00J07S01SIT07, t2.BLOQ07 AA00J07S01BLOQ07, t2.USUB07 AA00J07S01USUB07, t2.COD_XLNET_07 AA00J07S01COD_XLNET_07, t3.CEDIF03 AA00J03S01CEDIF03, t3.NOMBRE03 AA00J03S01NOMBRE03, t3.SIT03 AA00J03S01SIT03, t3.BLOQ03 AA00J03S01BLOQ03, t3.TLFNO03 AA00J03S01TLFNO03, t3.USUB03 AA00J03S01USUB03, t4.CREST06 AA00J06S01CREST06, t4.DESCC06 AA00J06S01DESCC06, t4.DESCE06 AA00J06S01DESCE06, t4.SIT06 AA00J06S01SIT06, t4.BLOQ06 AA00J06S01BLOQ06, t4.MENC06 AA00J06S01MENC06, t4.MENE06 AA00J06S01MENE06, t4.USUB06 AA00J06S01USUB06, t5.CTEXTO04 AA00J04S01CTEXTO04, t5.TTEXTO04 AA00J04S01TTEXTO04, t5.TRESC04 AA00J04S01TRESC04, t5.TRESE04 AA00J04S01TRESE04, t5.SIT04 AA00J04S01SIT04, t5.BLOQ04 AA00J04S01BLOQ04, t5.USUB04 AA00J04S01USUB04, t6.CSALA11 AA00J11S01CSALA11, t6.FOTO11 AA00J11S01FOTO11, t6.CROQ11 AA00J11S01CROQ11, t3.CSITIO03 AA00J03S01CSITIO03 FROM AA00J10S01 t1 , AA00J07S01 t2 , AA00J03S01 t3 , AA00J06S01 t4 , AA00J04S01 t5 , AA00J11S01 t6  WHERE t1.CSALA10 = ?   AND t1.CDEP10= t2.CDEP07(+) AND t1.CEDIF10= t3.CEDIF03(+) AND t1.CREST10= t4.CREST06(+) AND t1.CTEXTO10= t5.CTEXTO04(+) AND t1.CSALA10= t6.CSALA11(+)";
		StringBuilder sql = new StringBuilder();
		sql.append(" SELECT t1.CSALA10 CSALA10,");
		sql.append("   t1.NOMBRE10 NOMBRE10,");
		sql.append("   t1.SIT10 SIT10,");
		sql.append("   t1.BLOQ10 BLOQ10,");
		sql.append("   t1.SWDISP10 SWDISP10,");
		sql.append("   t1.DESC10 DESC10,");
		sql.append("   t1.TLFNO10 TLFNO10,");
		sql.append("   t1.USUB10 USUB10,");
		sql.append("   t1.PLANTA10 PLANTA10,");
		sql.append("   t1.DCAPC10 DCAPC10,");
		sql.append("   t1.DCAPE10 DCAPE10,");
		sql.append("   t1.NCAP10 NCAP10,");
		sql.append("   t2.CDEP07 AA00J07S01CDEP07,");
		sql.append("   t2.DESCC07 AA00J07S01DESCC07,");
		sql.append("   t2.DESCE07 AA00J07S01DESCE07,");
		sql.append("   t2.SIT07 AA00J07S01SIT07,");
		sql.append("   t2.BLOQ07 AA00J07S01BLOQ07,");
		sql.append("   t2.USUB07 AA00J07S01USUB07,");
		sql.append("   t2.COD_XLNET_07 AA00J07S01COD_XLNET_07,");
		sql.append("   t3.CEDIF03 AA00J03S01CEDIF03,");
		sql.append("   t3.NOMBRE03||'('||t6.nombre02||')' AA00J03S01NOMBRE03,");
		sql.append("   t3.SIT03 AA00J03S01SIT03,");
		sql.append("   t3.BLOQ03 AA00J03S01BLOQ03,");
		sql.append("   t3.TLFNO03 AA00J03S01TLFNO03,");
		sql.append("   t3.USUB03 AA00J03S01USUB03,");
		sql.append("   t4.CREST06 AA00J06S01CREST06,");
		sql.append("   t4.DESCC06 AA00J06S01DESCC06,");
		sql.append("   t4.DESCE06 AA00J06S01DESCE06,");
		sql.append("   t4.SIT06 AA00J06S01SIT06,");
		sql.append("   t4.BLOQ06 AA00J06S01BLOQ06,");
		sql.append("   t4.MENC06 AA00J06S01MENC06,");
		sql.append("   t4.MENE06 AA00J06S01MENE06,");
		sql.append("   t4.USUB06 AA00J06S01USUB06,");
		sql.append("   t5.CTEXTO04 AA00J04S01CTEXTO04,");
		sql.append("   t5.TTEXTO04 AA00J04S01TTEXTO04,");
		sql.append("   t5.TRESC04 AA00J04S01TRESC04,");
		sql.append("   t5.TRESE04 AA00J04S01TRESE04,");
		sql.append("   t5.SIT04 AA00J04S01SIT04,");
		sql.append("   t5.BLOQ04 AA00J04S01BLOQ04,");
		sql.append("   t5.USUB04 AA00J04S01USUB04,");
		sql.append("   t3.CSITIO03 AA00J03S01CSITIO03");
		sql.append(" FROM AA00J10S01 t1 ,");
		sql.append("   AA00J07S01 t2 ,");
		sql.append("   AA00J03S01 t3 ,");
		sql.append("   AA00J06S01 t4 ,");
		sql.append("   AA00J04S01 t5, AA00J02S01 t6 ");
		sql.append(" WHERE t1.CSALA10 = ?");
		sql.append(" AND t1.CDEP10    = t2.CDEP07(+)");
		sql.append(" AND t1.CEDIF10   = t3.CEDIF03(+)");
		sql.append(" AND t1.CREST10   = t4.CREST06(+)");
		sql.append(" AND t1.CTEXTO10  = t5.CTEXTO04(+)");
		sql.append(" AND t3.CSITIO03  = t6.CSITIO02(+)");
		query = sql.toString();
		Aa00j10s01DaoImpl.logger.info("SQL " + query);
		Aa00j10s01DaoImpl.logger.info("PARAM1 " + aa00j10s01.getCsala10());
		List<Aa00j10s01> aa00j10s01List = this.jdbcTemplate.query(query,
				this.rwMap, aa00j10s01.getCsala10());

		Aa00j10s01 data = (Aa00j10s01) DataAccessUtils
				.uniqueResult(aa00j10s01List);
		// mirar que el edificio no está en los edificios de la persona
		aa00jPersonaSesion ps = new aa00jSeguridad().getUsuario();
		Integer[] edificios = ps.getEdificiosResponsable();
		Arrays.sort(edificios);
		int idx = Arrays.binarySearch(edificios, data.getAa00j03s01()
				.getCedif03().intValue());
		if (idx >= 0)// el usuario es responsable del edifico de la sala, borrar
						// aviso
			data.setAa00j06s01(null);
		return data;
	}

	/**
	 * Removes a single row in the Aa00j10s01 table.
	 * 
	 * @param aa00j10s01
	 *            Aa00j10s01
	 * @return
	 */
	public void remove(Aa00j10s01 aa00j10s01) {
		Aa00j10s01DaoImpl.logger.info("Método remove");
		String query = "DELETE FROM AA00J10S01 WHERE CSALA10=?";
		Aa00j10s01DaoImpl.logger.info("SQL " + query);
		Aa00j10s01DaoImpl.logger.info("PARAM1 " + aa00j10s01.getCsala10());
		this.jdbcTemplate.update(query, aa00j10s01.getCsala10());
	}

	/**
	 * Finds a list of rows in the Aa00j10s01 table.
	 * 
	 * @param aa00j10s01
	 *            Aa00j10s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa00j10s01>
	 */
	@Transactional(readOnly = true)
	public List<Aa00j10s01> findAll(Aa00j10s01 aa00j10s01,
			JQGridRequestDto jqGridRequestDto) {
		Aa00j10s01DaoImpl.logger.info("Método findAll");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CSALA10 CSALA10,t1.NOMBRE10 NOMBRE10,t1.SIT10 SIT10,t1.BLOQ10 BLOQ10,t1.SWDISP10 SWDISP10,t1.DESC10 DESC10,t1.TLFNO10 TLFNO10,t1.USUB10 USUB10,t1.PLANTA10 PLANTA10,t1.DCAPC10 DCAPC10,t1.DCAPE10 DCAPE10,t1.NCAP10 NCAP10,t2.CDEP07 AA00J07S01CDEP07,t2.DESCC07 AA00J07S01DESCC07,t2.DESCE07 AA00J07S01DESCE07,t2.SIT07 AA00J07S01SIT07,t2.BLOQ07 AA00J07S01BLOQ07,t2.USUB07 AA00J07S01USUB07,t2.COD_XLNET_07 AA00J07S01COD_XLNET_07,t3.CEDIF03 AA00J03S01CEDIF03,t3.NOMBRE03 AA00J03S01NOMBRE03,t3.SIT03 AA00J03S01SIT03,t3.BLOQ03 AA00J03S01BLOQ03,t3.TLFNO03 AA00J03S01TLFNO03,t3.USUB03 AA00J03S01USUB03,t4.CREST06 AA00J06S01CREST06,t4.DESCC06 AA00J06S01DESCC06,t4.DESCE06 AA00J06S01DESCE06,t4.SIT06 AA00J06S01SIT06,t4.BLOQ06 AA00J06S01BLOQ06,t4.MENC06 AA00J06S01MENC06,t4.MENE06 AA00J06S01MENE06,t4.USUB06 AA00J06S01USUB06,t5.CTEXTO04 AA00J04S01CTEXTO04,t5.TTEXTO04 AA00J04S01TTEXTO04,t5.TRESC04 AA00J04S01TRESC04,t5.TRESE04 AA00J04S01TRESE04,t5.SIT04 AA00J04S01SIT04,t5.BLOQ04 AA00J04S01BLOQ04,t5.USUB04 AA00J04S01USUB04,t6.CSALA11 AA00J11S01CSALA11,t6.FOTO11 AA00J11S01FOTO11,t6.CROQ11 AA00J11S01CROQ11,t3.CSITIO03 AA00J03S01CSITIO03 ");
		query.append("FROM AA00J10S01 t1 ,AA00J07S01 t2 ,AA00J03S01 t3 ,AA00J06S01 t4 ,AA00J04S01 t5 ,AA00J11S01 t6 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa00j10s01);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CDEP10= t2.CDEP07(+) AND t1.CEDIF10= t3.CEDIF03(+) AND t1.CREST10= t4.CREST06(+) AND t1.CTEXTO10= t5.CTEXTO04(+) AND t1.CSALA10= t6.CSALA11(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		Aa00j10s01DaoImpl.logger.info("SQL " + query.toString());
		Aa00j10s01DaoImpl.logger.info("PARAMs " + params);
		return (List<Aa00j10s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Aa00j10s01 table using like.
	 * 
	 * @param aa00j10s01
	 *            Aa00j10s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa00j10s01>
	 */
	@Transactional(readOnly = true)
	public List<Aa00j10s01> findAllLike(Aa00j10s01 aa00j10s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		Aa00j10s01DaoImpl.logger.info("Método findAllLike");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CSALA10 CSALA10,t1.NOMBRE10 NOMBRE10,t1.SIT10 SIT10,t1.BLOQ10 BLOQ10,t1.SWDISP10 SWDISP10,t1.DESC10 DESC10,t1.TLFNO10 TLFNO10,t1.USUB10 USUB10,t1.PLANTA10 PLANTA10,t1.DCAPC10 DCAPC10,t1.DCAPE10 DCAPE10,t1.NCAP10 NCAP10,t2.CDEP07 AA00J07S01CDEP07,t2.DESCC07 AA00J07S01DESCC07,t2.DESCE07 AA00J07S01DESCE07,t2.SIT07 AA00J07S01SIT07,t2.BLOQ07 AA00J07S01BLOQ07,t2.USUB07 AA00J07S01USUB07,t2.COD_XLNET_07 AA00J07S01COD_XLNET_07,t3.CEDIF03 AA00J03S01CEDIF03,t3.NOMBRE03 AA00J03S01NOMBRE03,t3.SIT03 AA00J03S01SIT03,t3.BLOQ03 AA00J03S01BLOQ03,t3.TLFNO03 AA00J03S01TLFNO03,t3.USUB03 AA00J03S01USUB03,t4.CREST06 AA00J06S01CREST06,t4.DESCC06 AA00J06S01DESCC06,t4.DESCE06 AA00J06S01DESCE06,t4.SIT06 AA00J06S01SIT06,t4.BLOQ06 AA00J06S01BLOQ06,t4.MENC06 AA00J06S01MENC06,t4.MENE06 AA00J06S01MENE06,t4.USUB06 AA00J06S01USUB06,t5.CTEXTO04 AA00J04S01CTEXTO04,t5.TTEXTO04 AA00J04S01TTEXTO04,t5.TRESC04 AA00J04S01TRESC04,t5.TRESE04 AA00J04S01TRESE04,t5.SIT04 AA00J04S01SIT04,t5.BLOQ04 AA00J04S01BLOQ04,t5.USUB04 AA00J04S01USUB04,t6.CSALA11 AA00J11S01CSALA11,t6.FOTO11 AA00J11S01FOTO11,t6.CROQ11 AA00J11S01CROQ11,t3.CSITIO03 AA00J03S01CSITIO03 ");
		query.append("FROM AA00J10S01 t1 ,AA00J07S01 t2 ,AA00J03S01 t3 ,AA00J06S01 t4 ,AA00J04S01 t5 ,AA00J11S01 t6 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa00j10s01, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CDEP10= t2.CDEP07(+) AND t1.CEDIF10= t3.CEDIF03(+) AND t1.CREST10= t4.CREST06(+) AND t1.CTEXTO10= t5.CTEXTO04(+) AND t1.CSALA10= t6.CSALA11(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		// Chapuza para arreglar el jaleo que monta uda:
		// En la clase del modelo las columnas se llaman aa00k10s01.nombre10 por
		// ejemplo, pero en la sql que crea t1.nombre10
		// por lo que al ordenar la tablano lo hace bien
		// ya que en la tabla hay que poner el nombre que tiene en el modelo
		// lo hago así para tocar lo mínimo posible el resto de la aplicación
		String sql = query.toString();

		sql = StringUtils.replaceGlobal(sql, "aa00j10s01.", "t1.");
		sql = StringUtils.replaceGlobal(sql, "aa00j07s01.", "t2.");
		sql = StringUtils.replaceGlobal(sql, "aa00j03s01.", "t3.");
		sql = StringUtils.replaceGlobal(sql, "aa00j06s01.", "t4.");
		sql = StringUtils.replaceGlobal(sql, "aa00j04s01.", "t5.");
		sql = StringUtils.replaceGlobal(sql, "aa00j11s01.", "t6.");
		Aa00j10s01DaoImpl.logger.info("SQL " + sql);
		Aa00j10s01DaoImpl.logger.info("PARAMs " + params);
		return (List<Aa00j10s01>) this.jdbcTemplate.query(sql, this.rwMap,
				params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Aa00j10s01 table.
	 * 
	 * @param aa00j10s01
	 *            Aa00j10s01
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Aa00j10s01 aa00j10s01) {
		Aa00j10s01DaoImpl.logger.info("Método findAllCount");
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA00J10S01 t1 , AA00J07S01 t2 , AA00J03S01 t3 , AA00J06S01 t4 , AA00J04S01 t5 , AA00J11S01 t6 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa00j10s01);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CDEP10= t2.CDEP07(+) AND t1.CEDIF10= t3.CEDIF03(+) AND t1.CREST10= t4.CREST06(+) AND t1.CTEXTO10= t5.CTEXTO04(+) AND t1.CSALA10= t6.CSALA11(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j10s01DaoImpl.logger.info("SQL " + query.toString());
		Aa00j10s01DaoImpl.logger.info("PARAMs " + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Aa00j10s01 table using like.
	 * 
	 * @param aa00j10s01
	 *            Aa00j10s01
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Aa00j10s01 aa00j10s01, Boolean startsWith) {
		Aa00j10s01DaoImpl.logger.info("Método findAllLikeCount");
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA00J10S01 t1 ,AA00J07S01 t2 ,AA00J03S01 t3 ,AA00J06S01 t4 ,AA00J04S01 t5 ,AA00J11S01 t6 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa00j10s01, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CDEP10= t2.CDEP07(+) AND t1.CEDIF10= t3.CEDIF03(+) AND t1.CREST10= t4.CREST06(+) AND t1.CTEXTO10= t5.CTEXTO04(+) AND t1.CSALA10= t6.CSALA11(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j10s01DaoImpl.logger.info("SQL " + query.toString());
		Aa00j10s01DaoImpl.logger.info("PARAMs " + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Aa00j10s01 selected for rup_table
	 * 
	 * @param aa00j10s01
	 *            Aa00j10s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j10s01>>
	 */
	@Override
	public List<TableRowDto<Aa00j10s01>> reorderSelection(
			Aa00j10s01 aa00j10s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		Aa00j10s01DaoImpl.logger.info("Método reorderSelection");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CSALA10 CSALA10,t1.NOMBRE10 NOMBRE10,t1.SIT10 SIT10,t1.BLOQ10 BLOQ10,t1.SWDISP10 SWDISP10,t1.DESC10 DESC10,t1.TLFNO10 TLFNO10,t1.USUB10 USUB10,t1.PLANTA10 PLANTA10,t1.DCAPC10 DCAPC10,t1.DCAPE10 DCAPE10,t1.NCAP10 NCAP10,t2.CDEP07 AA00J07S01CDEP07,t2.DESCC07 AA00J07S01DESCC07,t2.DESCE07 AA00J07S01DESCE07,t2.SIT07 AA00J07S01SIT07,t2.BLOQ07 AA00J07S01BLOQ07,t2.USUB07 AA00J07S01USUB07,t2.COD_XLNET_07 AA00J07S01COD_XLNET_07,t3.CEDIF03 AA00J03S01CEDIF03,t3.NOMBRE03 AA00J03S01NOMBRE03,t3.SIT03 AA00J03S01SIT03,t3.BLOQ03 AA00J03S01BLOQ03,t3.TLFNO03 AA00J03S01TLFNO03,t3.USUB03 AA00J03S01USUB03,t4.CREST06 AA00J06S01CREST06,t4.DESCC06 AA00J06S01DESCC06,t4.DESCE06 AA00J06S01DESCE06,t4.SIT06 AA00J06S01SIT06,t4.BLOQ06 AA00J06S01BLOQ06,t4.MENC06 AA00J06S01MENC06,t4.MENE06 AA00J06S01MENE06,t4.USUB06 AA00J06S01USUB06,t5.CTEXTO04 AA00J04S01CTEXTO04,t5.TTEXTO04 AA00J04S01TTEXTO04,t5.TRESC04 AA00J04S01TRESC04,t5.TRESE04 AA00J04S01TRESE04,t5.SIT04 AA00J04S01SIT04,t5.BLOQ04 AA00J04S01BLOQ04,t5.USUB04 AA00J04S01USUB04,t6.CSALA11 AA00J11S01CSALA11,t6.FOTO11 AA00J11S01FOTO11,t6.CROQ11 AA00J11S01CROQ11,t3.CSITIO03 AA00J03S01CSITIO03 ");
		// FROM
		query.append("FROM AA00J10S01 t1 ,AA00J07S01 t2 ,AA00J03S01 t3 ,AA00J06S01 t4 ,AA00J04S01 t5 ,AA00J11S01 t6 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa00j10s01, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CDEP10= t2.CDEP07(+) AND t1.CEDIF10= t3.CEDIF03(+) AND t1.CREST10= t4.CREST06(+) AND t1.CTEXTO10= t5.CTEXTO04(+) AND t1.CSALA10= t6.CSALA11(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, Aa00j10s01.class, filterParamList,
				"CSALA10");
		Aa00j10s01DaoImpl.logger
				.info("SQL " + sbReorderSelectionSQL.toString());
		Aa00j10s01DaoImpl.logger.info("PARAMs " + filterParamList);
		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa00j10s01>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * @param filterParams
	 *            Aa00j10s01
	 * @param searchParams
	 *            Aa00j10s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j10s01>>
	 */
	@Override
	public List<TableRowDto<Aa00j10s01>> search(Aa00j10s01 filterParams,
			Aa00j10s01 searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		Aa00j10s01DaoImpl.logger.info("Método search");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CSALA10 CSALA10,t1.NOMBRE10 NOMBRE10,t1.SIT10 SIT10,t1.BLOQ10 BLOQ10,t1.SWDISP10 SWDISP10,t1.DESC10 DESC10,t1.TLFNO10 TLFNO10,t1.USUB10 USUB10,t1.PLANTA10 PLANTA10,t1.DCAPC10 DCAPC10,t1.DCAPE10 DCAPE10,t1.NCAP10 NCAP10,t2.CDEP07 AA00J07S01CDEP07,t2.DESCC07 AA00J07S01DESCC07,t2.DESCE07 AA00J07S01DESCE07,t2.SIT07 AA00J07S01SIT07,t2.BLOQ07 AA00J07S01BLOQ07,t2.USUB07 AA00J07S01USUB07,t2.COD_XLNET_07 AA00J07S01COD_XLNET_07,t3.CEDIF03 AA00J03S01CEDIF03,t3.NOMBRE03 AA00J03S01NOMBRE03,t3.SIT03 AA00J03S01SIT03,t3.BLOQ03 AA00J03S01BLOQ03,t3.TLFNO03 AA00J03S01TLFNO03,t3.USUB03 AA00J03S01USUB03,t4.CREST06 AA00J06S01CREST06,t4.DESCC06 AA00J06S01DESCC06,t4.DESCE06 AA00J06S01DESCE06,t4.SIT06 AA00J06S01SIT06,t4.BLOQ06 AA00J06S01BLOQ06,t4.MENC06 AA00J06S01MENC06,t4.MENE06 AA00J06S01MENE06,t4.USUB06 AA00J06S01USUB06,t5.CTEXTO04 AA00J04S01CTEXTO04,t5.TTEXTO04 AA00J04S01TTEXTO04,t5.TRESC04 AA00J04S01TRESC04,t5.TRESE04 AA00J04S01TRESE04,t5.SIT04 AA00J04S01SIT04,t5.BLOQ04 AA00J04S01BLOQ04,t5.USUB04 AA00J04S01USUB04,t6.CSALA11 AA00J11S01CSALA11,t6.FOTO11 AA00J11S01FOTO11,t6.CROQ11 AA00J11S01CROQ11,t3.CSITIO03 AA00J03S01CSITIO03 ");
		// FROM
		query.append("FROM AA00J10S01 t1 ,AA00J07S01 t2 ,AA00J03S01 t3 ,AA00J06S01 t4 ,AA00J04S01 t5 ,AA00J11S01 t6 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");
		from_alias.add(" t3 ");
		from_alias.add(" t4 ");
		from_alias.add(" t5 ");
		from_alias.add(" t6 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CDEP10= t2.CDEP07(+) AND t1.CEDIF10= t3.CEDIF03(+) AND t1.CREST10= t4.CREST06(+) AND t1.CTEXTO10= t5.CTEXTO04(+) AND t1.CSALA10= t6.CSALA11(+) ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, Aa00j10s01.class, filterParamList,
				searchSQL, searchParamList, from_alias, "CSALA10");

		Aa00j10s01DaoImpl.logger
				.info("SQL " + sbReorderSelectionSQL.toString());
		Aa00j10s01DaoImpl.logger.info("PARAMs " + filterParamList);
		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa00j10s01>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 * 
	 * @param filteraa00j10s01
	 *            Aa00j10s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Aa00j10s01 filteraa00j10s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		Aa00j10s01DaoImpl.logger.info("Método removeMultiple");
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.CSALA10 CSALA10,t1.NOMBRE10 NOMBRE10,t1.SIT10 SIT10,t1.BLOQ10 BLOQ10,t1.SWDISP10 SWDISP10,t1.DESC10 DESC10,t1.TLFNO10 TLFNO10,t1.USUB10 USUB10,t1.PLANTA10 PLANTA10,t1.DCAPC10 DCAPC10,t1.DCAPE10 DCAPE10,t1.NCAP10 NCAP10,t2.CDEP07 AA00J07S01CDEP07,t2.DESCC07 AA00J07S01DESCC07,t2.DESCE07 AA00J07S01DESCE07,t2.SIT07 AA00J07S01SIT07,t2.BLOQ07 AA00J07S01BLOQ07,t2.USUB07 AA00J07S01USUB07,t2.COD_XLNET_07 AA00J07S01COD_XLNET_07,t3.CEDIF03 AA00J03S01CEDIF03,t3.NOMBRE03 AA00J03S01NOMBRE03,t3.SIT03 AA00J03S01SIT03,t3.BLOQ03 AA00J03S01BLOQ03,t3.TLFNO03 AA00J03S01TLFNO03,t3.USUB03 AA00J03S01USUB03,t4.CREST06 AA00J06S01CREST06,t4.DESCC06 AA00J06S01DESCC06,t4.DESCE06 AA00J06S01DESCE06,t4.SIT06 AA00J06S01SIT06,t4.BLOQ06 AA00J06S01BLOQ06,t4.MENC06 AA00J06S01MENC06,t4.MENE06 AA00J06S01MENE06,t4.USUB06 AA00J06S01USUB06,t5.CTEXTO04 AA00J04S01CTEXTO04,t5.TTEXTO04 AA00J04S01TTEXTO04,t5.TRESC04 AA00J04S01TRESC04,t5.TRESE04 AA00J04S01TRESE04,t5.SIT04 AA00J04S01SIT04,t5.BLOQ04 AA00J04S01BLOQ04,t5.USUB04 AA00J04S01USUB04,t6.CSALA11 AA00J11S01CSALA11,t6.FOTO11 AA00J11S01FOTO11,t6.CROQ11 AA00J11S01CROQ11,t3.CSITIO03 AA00J03S01CSITIO03 ");
		// FROM
		query.append("FROM AA00J10S01 t1 ,AA00J07S01 t2 ,AA00J03S01 t3 ,AA00J06S01 t4 ,AA00J04S01 t5 ,AA00J11S01 t6 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filteraa00j10s01,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto, Aa00j10s01.class,
						query, params, "CSALA10");

		Aa00j10s01DaoImpl.logger.info("SQL " + sbRemoveMultipleSQL.toString());
		Aa00j10s01DaoImpl.logger.info("PARAMs " + params);
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical Aa00j10s01 table.
	 * 
	 * @param filterAa00j10s01
	 *            Aa00j10s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Aa00j10s01>>
	 */
	@Override
	public List<JerarquiaDto<Aa00j10s01>> findAllLikeJerarquia(
			Aa00j10s01 filterAa00j10s01, JQGridRequestDto jqGridRequestDto) {
		Aa00j10s01DaoImpl.logger.info("Método findAllLikeJerarquia");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CSALA10 CSALA10,t1.NOMBRE10 NOMBRE10,t1.SIT10 SIT10,t1.BLOQ10 BLOQ10,t1.SWDISP10 SWDISP10,t1.DESC10 DESC10,t1.TLFNO10 TLFNO10,t1.USUB10 USUB10,t1.PLANTA10 PLANTA10,t1.DCAPC10 DCAPC10,t1.DCAPE10 DCAPE10,t1.NCAP10 NCAP10,t2.CDEP07 AA00J07S01CDEP07,t2.DESCC07 AA00J07S01DESCC07,t2.DESCE07 AA00J07S01DESCE07,t2.SIT07 AA00J07S01SIT07,t2.BLOQ07 AA00J07S01BLOQ07,t2.USUB07 AA00J07S01USUB07,t2.COD_XLNET_07 AA00J07S01COD_XLNET_07,t3.CEDIF03 AA00J03S01CEDIF03,t3.NOMBRE03 AA00J03S01NOMBRE03,t3.SIT03 AA00J03S01SIT03,t3.BLOQ03 AA00J03S01BLOQ03,t3.TLFNO03 AA00J03S01TLFNO03,t3.USUB03 AA00J03S01USUB03,t4.CREST06 AA00J06S01CREST06,t4.DESCC06 AA00J06S01DESCC06,t4.DESCE06 AA00J06S01DESCE06,t4.SIT06 AA00J06S01SIT06,t4.BLOQ06 AA00J06S01BLOQ06,t4.MENC06 AA00J06S01MENC06,t4.MENE06 AA00J06S01MENE06,t4.USUB06 AA00J06S01USUB06,t5.CTEXTO04 AA00J04S01CTEXTO04,t5.TTEXTO04 AA00J04S01TTEXTO04,t5.TRESC04 AA00J04S01TRESC04,t5.TRESE04 AA00J04S01TRESE04,t5.SIT04 AA00J04S01SIT04,t5.BLOQ04 AA00J04S01BLOQ04,t5.USUB04 AA00J04S01USUB04,t6.CSALA11 AA00J11S01CSALA11,t6.FOTO11 AA00J11S01FOTO11,t6.CROQ11 AA00J11S01CROQ11,t3.CSITIO03 AA00J03S01CSITIO03 ");
		// FROM
		// StringBuilder from = new
		// StringBuilder("FROM AA00J10S01 t1 ,AA00J07S01 t2 ,AA00J03S01 t3 ,AA00J06S01 t4 ,AA00J04S01 t5 ,AA00J11S01 t6 ");
		List<String> from = new ArrayList<String>();
		from.add("AA00J10S01");
		from.add("AA00J07S01");
		from.add("AA00J03S01");
		from.add("AA00J06S01");
		from.add("AA00J04S01");
		from.add("AA00J11S01");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");
		from_alias.add(" t3 ");
		from_alias.add(" t4 ");
		from_alias.add(" t5 ");
		from_alias.add(" t6 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa00j10s01, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
				mapaWhere, "CSALA10", "ID_PADRE", "NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j10s01DaoImpl.logger.info("SQL " + query.toString());
		Aa00j10s01DaoImpl.logger.info("PARAMs " + params);
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAa00j10s01
	 *            Aa00j10s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Aa00j10s01 filterAa00j10s01,
			JQGridRequestDto jqGridRequestDto) {
		Aa00j10s01DaoImpl.logger.info("Método findAllLikeCountJerarquia");
		// FROM
		// StringBuilder from = new
		// StringBuilder("FROM AA00J10S01 t1 ,AA00J07S01 t2 ,AA00J03S01 t3 ,AA00J06S01 t4 ,AA00J04S01 t5 ,AA00J11S01 t6 ");
		List<String> from = new ArrayList<String>();
		from.add("AA00J10S01");
		from.add("AA00J07S01");
		from.add("AA00J03S01");
		from.add("AA00J06S01");
		from.add("AA00J04S01");
		from.add("AA00J11S01");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");
		from_alias.add(" t3 ");
		from_alias.add(" t4 ");
		from_alias.add(" t5 ");
		from_alias.add(" t6 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa00j10s01, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(
				jqGridRequestDto, mapaWhere, "CSALA10", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j10s01DaoImpl.logger.info("SQL " + query.toString());
		Aa00j10s01DaoImpl.logger.info("PARAMs " + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAa00j10s01
	 *            Aa00j10s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Aa00j10s01>>
	 */
	@Override
	public List<TableRowDto<Aa00j10s01>> findAllChild(
			Aa00j10s01 filterAa00j10s01, JQGridRequestDto jqGridRequestDto) {
		Aa00j10s01DaoImpl.logger.info("Método findAllChild");
		// FROM
		// StringBuilder from = new
		// StringBuilder("FROM AA00J10S01 t1 ,AA00J07S01 t2 ,AA00J03S01 t3 ,AA00J06S01 t4 ,AA00J04S01 t5 ,AA00J11S01 t6 ");
		List<String> from = new ArrayList<String>();
		from.add("AA00J10S01");
		from.add("AA00J07S01");
		from.add("AA00J03S01");
		from.add("AA00J06S01");
		from.add("AA00J04S01");
		from.add("AA00J11S01");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");
		from_alias.add(" t3 ");
		from_alias.add(" t4 ");
		from_alias.add(" t5 ");
		from_alias.add(" t6 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa00j10s01, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(
				jqGridRequestDto, mapaWhere, "CSALA10", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j10s01DaoImpl.logger.info("SQL " + query.toString());
		Aa00j10s01DaoImpl.logger.info("PARAMs " + params);
		return this.jdbcTemplate.query(query.toString(),
				new RowNumResultSetExtractor<Aa00j10s01>(this.rwMapPK,
						"CSALA10"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa00j10s01 entity
	 * 
	 * @param aa00j10s01
	 *            Aa00j10s01 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Aa00j10s01 aa00j10s01) {

		StringBuilder where = new StringBuilder(
				Aa00j10s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa00j10s01 != null && aa00j10s01.getCsala10() != null) {
			where.append(" AND t1.CSALA10 = ?");
			params.add(aa00j10s01.getCsala10());
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j07s01() != null
				&& aa00j10s01.getAa00j07s01().getCdep07() != null) {
			where.append(" AND t2.CDEP07 = ?");
			params.add(aa00j10s01.getAa00j07s01().getCdep07());
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j07s01() != null
				&& aa00j10s01.getAa00j07s01().getDescc07() != null) {
			where.append(" AND t2.DESCC07 = ?");
			params.add(aa00j10s01.getAa00j07s01().getDescc07());
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j07s01() != null
				&& aa00j10s01.getAa00j07s01().getDesce07() != null) {
			where.append(" AND t2.DESCE07 = ?");
			params.add(aa00j10s01.getAa00j07s01().getDesce07());
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j07s01() != null
				&& aa00j10s01.getAa00j07s01().getSit07() != null) {
			where.append(" AND t2.SIT07 = ?");
			params.add(aa00j10s01.getAa00j07s01().getSit07());
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j07s01() != null
				&& aa00j10s01.getAa00j07s01().getBloq07() != null) {
			where.append(" AND t2.BLOQ07 = ?");
			params.add(aa00j10s01.getAa00j07s01().getBloq07());
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j07s01() != null
				&& aa00j10s01.getAa00j07s01().getUsub07() != null) {
			where.append(" AND t2.USUB07 = ?");
			params.add(aa00j10s01.getAa00j07s01().getUsub07());
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j07s01() != null
				&& aa00j10s01.getAa00j07s01().getCodxlnet07() != null) {
			where.append(" AND t2.COD_XLNET_07 = ?");
			params.add(aa00j10s01.getAa00j07s01().getCodxlnet07());
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j03s01() != null
				&& aa00j10s01.getAa00j03s01().getCedif03() != null) {
			where.append(" AND t3.CEDIF03 = ?");
			params.add(aa00j10s01.getAa00j03s01().getCedif03());
		}
		if (aa00j10s01 != null
				&& aa00j10s01.getAa00j03s01() != null
				&& aa00j10s01.getAa00j03s01().getAa00j02s01() != null
				&& aa00j10s01.getAa00j03s01().getAa00j02s01().getCsitio02() != null) {
			where.append(" AND t3.CSITIO03 = ?");
			params.add(aa00j10s01.getAa00j03s01().getAa00j02s01().getCsitio02());
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j03s01() != null
				&& aa00j10s01.getAa00j03s01().getNombre03() != null) {
			where.append(" AND t3.NOMBRE03 = ?");
			params.add(aa00j10s01.getAa00j03s01().getNombre03());
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j03s01() != null
				&& aa00j10s01.getAa00j03s01().getSit03() != null) {
			where.append(" AND t3.SIT03 = ?");
			params.add(aa00j10s01.getAa00j03s01().getSit03());
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j03s01() != null
				&& aa00j10s01.getAa00j03s01().getBloq03() != null) {
			where.append(" AND t3.BLOQ03 = ?");
			params.add(aa00j10s01.getAa00j03s01().getBloq03());
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j03s01() != null
				&& aa00j10s01.getAa00j03s01().getTlfno03() != null) {
			where.append(" AND t3.TLFNO03 = ?");
			params.add(aa00j10s01.getAa00j03s01().getTlfno03());
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j03s01() != null
				&& aa00j10s01.getAa00j03s01().getUsub03() != null) {
			where.append(" AND t3.USUB03 = ?");
			params.add(aa00j10s01.getAa00j03s01().getUsub03());
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j06s01() != null
				&& aa00j10s01.getAa00j06s01().getCrest06() != null) {
			where.append(" AND t4.CREST06 = ?");
			params.add(aa00j10s01.getAa00j06s01().getCrest06());
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j06s01() != null
				&& aa00j10s01.getAa00j06s01().getDescc06() != null) {
			where.append(" AND t4.DESCC06 = ?");
			params.add(aa00j10s01.getAa00j06s01().getDescc06());
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j06s01() != null
				&& aa00j10s01.getAa00j06s01().getDesce06() != null) {
			where.append(" AND t4.DESCE06 = ?");
			params.add(aa00j10s01.getAa00j06s01().getDesce06());
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j06s01() != null
				&& aa00j10s01.getAa00j06s01().getSit06() != null) {
			where.append(" AND t4.SIT06 = ?");
			params.add(aa00j10s01.getAa00j06s01().getSit06());
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j06s01() != null
				&& aa00j10s01.getAa00j06s01().getBloq06() != null) {
			where.append(" AND t4.BLOQ06 = ?");
			params.add(aa00j10s01.getAa00j06s01().getBloq06());
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j06s01() != null
				&& aa00j10s01.getAa00j06s01().getMenc06() != null) {
			where.append(" AND t4.MENC06 = ?");
			params.add(aa00j10s01.getAa00j06s01().getMenc06());
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j06s01() != null
				&& aa00j10s01.getAa00j06s01().getMene06() != null) {
			where.append(" AND t4.MENE06 = ?");
			params.add(aa00j10s01.getAa00j06s01().getMene06());
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j06s01() != null
				&& aa00j10s01.getAa00j06s01().getUsub06() != null) {
			where.append(" AND t4.USUB06 = ?");
			params.add(aa00j10s01.getAa00j06s01().getUsub06());
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j04s01() != null
				&& aa00j10s01.getAa00j04s01().getCtexto04() != null) {
			where.append(" AND t5.CTEXTO04 = ?");
			params.add(aa00j10s01.getAa00j04s01().getCtexto04());
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j04s01() != null
				&& aa00j10s01.getAa00j04s01().getTtexto04() != null) {
			where.append(" AND t5.TTEXTO04 = ?");
			params.add(aa00j10s01.getAa00j04s01().getTtexto04());
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j04s01() != null
				&& aa00j10s01.getAa00j04s01().getTresc04() != null) {
			where.append(" AND t5.TRESC04 = ?");
			params.add(aa00j10s01.getAa00j04s01().getTresc04());
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j04s01() != null
				&& aa00j10s01.getAa00j04s01().getTrese04() != null) {
			where.append(" AND t5.TRESE04 = ?");
			params.add(aa00j10s01.getAa00j04s01().getTrese04());
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j04s01() != null
				&& aa00j10s01.getAa00j04s01().getSit04() != null) {
			where.append(" AND t5.SIT04 = ?");
			params.add(aa00j10s01.getAa00j04s01().getSit04());
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j04s01() != null
				&& aa00j10s01.getAa00j04s01().getBloq04() != null) {
			where.append(" AND t5.BLOQ04 = ?");
			params.add(aa00j10s01.getAa00j04s01().getBloq04());
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j04s01() != null
				&& aa00j10s01.getAa00j04s01().getUsub04() != null) {
			where.append(" AND t5.USUB04 = ?");
			params.add(aa00j10s01.getAa00j04s01().getUsub04());
		}
		if (aa00j10s01 != null && aa00j10s01.getNombre10() != null) {
			where.append(" AND t1.NOMBRE10 = ?");
			params.add(aa00j10s01.getNombre10());
		}
		if (aa00j10s01 != null && aa00j10s01.getSit10() != null) {
			where.append(" AND t1.SIT10 = ?");
			params.add(aa00j10s01.getSit10());
		}
		if (aa00j10s01 != null && aa00j10s01.getBloq10() != null) {
			where.append(" AND t1.BLOQ10 = ?");
			params.add(aa00j10s01.getBloq10());
		}
		if (aa00j10s01 != null && aa00j10s01.getSwdisp10() != null) {
			where.append(" AND t1.SWDISP10 = ?");
			params.add(aa00j10s01.getSwdisp10());
		}
		if (aa00j10s01 != null && aa00j10s01.getDesc10() != null) {
			where.append(" AND t1.DESC10 = ?");
			params.add(aa00j10s01.getDesc10());
		}
		if (aa00j10s01 != null && aa00j10s01.getTlfno10() != null) {
			where.append(" AND t1.TLFNO10 = ?");
			params.add(aa00j10s01.getTlfno10());
		}
		if (aa00j10s01 != null && aa00j10s01.getUsub10() != null) {
			where.append(" AND t1.USUB10 = ?");
			params.add(aa00j10s01.getUsub10());
		}
		if (aa00j10s01 != null && aa00j10s01.getPlanta10() != null) {
			where.append(" AND t1.PLANTA10 = ?");
			params.add(aa00j10s01.getPlanta10());
		}
		if (aa00j10s01 != null && aa00j10s01.getDcapc10() != null) {
			where.append(" AND t1.DCAPC10 = ?");
			params.add(aa00j10s01.getDcapc10());
		}
		if (aa00j10s01 != null && aa00j10s01.getDcape10() != null) {
			where.append(" AND t1.DCAPE10 = ?");
			params.add(aa00j10s01.getDcape10());
		}
		if (aa00j10s01 != null && aa00j10s01.getNcap10() != null) {
			where.append(" AND t1.NCAP10 = ?");
			params.add(aa00j10s01.getNcap10());
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j11s01() != null
				&& aa00j10s01.getAa00j11s01().getCsala11() != null) {
			where.append(" AND t6.CSALA11 = ?");
			params.add(aa00j10s01.getAa00j11s01().getCsala11());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa00j10s01 entity
	 * 
	 * @param aa00j10s01
	 *            Aa00j10s01 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Aa00j10s01 aa00j10s01,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				Aa00j10s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa00j10s01 != null && aa00j10s01.getCsala10() != null) {
			where.append(" AND t1.CSALA10 = ?");
			params.add(aa00j10s01.getCsala10());
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j07s01() != null
				&& aa00j10s01.getAa00j07s01().getCdep07() != null) {
			where.append(" AND t2.CDEP07 = ?");
			params.add(aa00j10s01.getAa00j07s01().getCdep07());
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j07s01() != null
				&& aa00j10s01.getAa00j07s01().getDescc07() != null) {
			where.append(" AND UPPER(t2.DESCC07) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j10s01.getAa00j07s01().getDescc07()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j10s01.getAa00j07s01().getDescc07().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.DESCC07 IS NOT NULL");
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j07s01() != null
				&& aa00j10s01.getAa00j07s01().getDesce07() != null) {
			where.append(" AND UPPER(t2.DESCE07) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j10s01.getAa00j07s01().getDesce07()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j10s01.getAa00j07s01().getDesce07().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.DESCE07 IS NOT NULL");
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j07s01() != null
				&& aa00j10s01.getAa00j07s01().getSit07() != null) {
			where.append(" AND UPPER(t2.SIT07) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j10s01.getAa00j07s01().getSit07().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j10s01.getAa00j07s01().getSit07().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.SIT07 IS NOT NULL");
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j07s01() != null
				&& aa00j10s01.getAa00j07s01().getBloq07() != null) {
			where.append(" AND t2.BLOQ07 = ?");
			params.add(aa00j10s01.getAa00j07s01().getBloq07());
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j07s01() != null
				&& aa00j10s01.getAa00j07s01().getUsub07() != null) {
			where.append(" AND UPPER(t2.USUB07) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j10s01.getAa00j07s01().getUsub07().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j10s01.getAa00j07s01().getUsub07().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.USUB07 IS NOT NULL");
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j07s01() != null
				&& aa00j10s01.getAa00j07s01().getCodxlnet07() != null) {
			where.append(" AND UPPER(t2.COD_XLNET_07) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j10s01.getAa00j07s01().getCodxlnet07()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j10s01.getAa00j07s01().getCodxlnet07()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.COD_XLNET_07 IS NOT NULL");
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j03s01() != null
				&& aa00j10s01.getAa00j03s01().getCedif03() != null) {
			where.append(" AND t3.CEDIF03 = ?");
			params.add(aa00j10s01.getAa00j03s01().getCedif03());
		} else {
			aa00jPersonaSesion ps = new aa00jSeguridad().getUsuario();
			if (ps.isEsAdmin() && !ps.getEdificioResponsable().equals("-1")) {
				// Tiene edificios hay que obligar a que cedif03 esté en los
				// edificios del usuario

				where.append(" AND ");
				where.append(" cedif03 in(");
				StringBuffer str = new StringBuffer();
				boolean first = true;
				for (int i : ps.getEdificiosResponsable()) {
					if (!first) {

						str.append(",");
					}
					first = false;
					str.append(i);
				}
				where.append(str);
				where.append(" )");
			}

		}
		if (aa00j10s01 != null
				&& aa00j10s01.getAa00j03s01() != null
				&& aa00j10s01.getAa00j03s01().getAa00j02s01() != null
				&& aa00j10s01.getAa00j03s01().getAa00j02s01().getCsitio02() != null) {
			where.append(" AND t3.CSITIO03 = ?");
			params.add(aa00j10s01.getAa00j03s01().getAa00j02s01().getCsitio02());
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j03s01() != null
				&& aa00j10s01.getAa00j03s01().getNombre03() != null) {
			where.append(" AND UPPER(t3.NOMBRE03) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j10s01.getAa00j03s01().getNombre03()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j10s01.getAa00j03s01().getNombre03()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.NOMBRE03 IS NOT NULL");
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j03s01() != null
				&& aa00j10s01.getAa00j03s01().getSit03() != null) {
			where.append(" AND UPPER(t3.SIT03) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j10s01.getAa00j03s01().getSit03().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j10s01.getAa00j03s01().getSit03().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.SIT03 IS NOT NULL");
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j03s01() != null
				&& aa00j10s01.getAa00j03s01().getBloq03() != null) {
			where.append(" AND t3.BLOQ03 = ?");
			params.add(aa00j10s01.getAa00j03s01().getBloq03());
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j03s01() != null
				&& aa00j10s01.getAa00j03s01().getTlfno03() != null) {
			where.append(" AND UPPER(t3.TLFNO03) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j10s01.getAa00j03s01().getTlfno03()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j10s01.getAa00j03s01().getTlfno03().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.TLFNO03 IS NOT NULL");
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j03s01() != null
				&& aa00j10s01.getAa00j03s01().getUsub03() != null) {
			where.append(" AND UPPER(t3.USUB03) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j10s01.getAa00j03s01().getUsub03().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j10s01.getAa00j03s01().getUsub03().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.USUB03 IS NOT NULL");
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j06s01() != null
				&& aa00j10s01.getAa00j06s01().getCrest06() != null) {
			where.append(" AND t4.CREST06 = ?");
			params.add(aa00j10s01.getAa00j06s01().getCrest06());
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j06s01() != null
				&& aa00j10s01.getAa00j06s01().getDescc06() != null) {
			where.append(" AND UPPER(t4.DESCC06) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j10s01.getAa00j06s01().getDescc06()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j10s01.getAa00j06s01().getDescc06().toUpperCase()
						+ "%");
			}
			where.append(" AND t4.DESCC06 IS NOT NULL");
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j06s01() != null
				&& aa00j10s01.getAa00j06s01().getDesce06() != null) {
			where.append(" AND UPPER(t4.DESCE06) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j10s01.getAa00j06s01().getDesce06()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j10s01.getAa00j06s01().getDesce06().toUpperCase()
						+ "%");
			}
			where.append(" AND t4.DESCE06 IS NOT NULL");
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j06s01() != null
				&& aa00j10s01.getAa00j06s01().getSit06() != null) {
			where.append(" AND UPPER(t4.SIT06) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j10s01.getAa00j06s01().getSit06().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j10s01.getAa00j06s01().getSit06().toUpperCase()
						+ "%");
			}
			where.append(" AND t4.SIT06 IS NOT NULL");
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j06s01() != null
				&& aa00j10s01.getAa00j06s01().getBloq06() != null) {
			where.append(" AND t4.BLOQ06 = ?");
			params.add(aa00j10s01.getAa00j06s01().getBloq06());
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j06s01() != null
				&& aa00j10s01.getAa00j06s01().getMenc06() != null) {
			where.append(" AND UPPER(t4.MENC06) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j10s01.getAa00j06s01().getMenc06().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j10s01.getAa00j06s01().getMenc06().toUpperCase()
						+ "%");
			}
			where.append(" AND t4.MENC06 IS NOT NULL");
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j06s01() != null
				&& aa00j10s01.getAa00j06s01().getMene06() != null) {
			where.append(" AND UPPER(t4.MENE06) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j10s01.getAa00j06s01().getMene06().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j10s01.getAa00j06s01().getMene06().toUpperCase()
						+ "%");
			}
			where.append(" AND t4.MENE06 IS NOT NULL");
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j06s01() != null
				&& aa00j10s01.getAa00j06s01().getUsub06() != null) {
			where.append(" AND UPPER(t4.USUB06) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j10s01.getAa00j06s01().getUsub06().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j10s01.getAa00j06s01().getUsub06().toUpperCase()
						+ "%");
			}
			where.append(" AND t4.USUB06 IS NOT NULL");
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j04s01() != null
				&& aa00j10s01.getAa00j04s01().getCtexto04() != null) {
			where.append(" AND t5.CTEXTO04 = ?");
			params.add(aa00j10s01.getAa00j04s01().getCtexto04());
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j04s01() != null
				&& aa00j10s01.getAa00j04s01().getTtexto04() != null) {
			where.append(" AND UPPER(t5.TTEXTO04) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j10s01.getAa00j04s01().getTtexto04()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j10s01.getAa00j04s01().getTtexto04()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.TTEXTO04 IS NOT NULL");
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j04s01() != null
				&& aa00j10s01.getAa00j04s01().getTresc04() != null) {
			where.append(" AND UPPER(t5.TRESC04) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j10s01.getAa00j04s01().getTresc04()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j10s01.getAa00j04s01().getTresc04().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.TRESC04 IS NOT NULL");
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j04s01() != null
				&& aa00j10s01.getAa00j04s01().getTrese04() != null) {
			where.append(" AND UPPER(t5.TRESE04) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j10s01.getAa00j04s01().getTrese04()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j10s01.getAa00j04s01().getTrese04().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.TRESE04 IS NOT NULL");
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j04s01() != null
				&& aa00j10s01.getAa00j04s01().getSit04() != null) {
			where.append(" AND UPPER(t5.SIT04) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j10s01.getAa00j04s01().getSit04().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j10s01.getAa00j04s01().getSit04().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.SIT04 IS NOT NULL");
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j04s01() != null
				&& aa00j10s01.getAa00j04s01().getBloq04() != null) {
			where.append(" AND t5.BLOQ04 = ?");
			params.add(aa00j10s01.getAa00j04s01().getBloq04());
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j04s01() != null
				&& aa00j10s01.getAa00j04s01().getUsub04() != null) {
			where.append(" AND UPPER(t5.USUB04) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j10s01.getAa00j04s01().getUsub04().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j10s01.getAa00j04s01().getUsub04().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.USUB04 IS NOT NULL");
		}
		if (aa00j10s01 != null && aa00j10s01.getNombre10() != null) {
			where.append(" AND UPPER(t1.NOMBRE10) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j10s01.getNombre10().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j10s01.getNombre10().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE10 IS NOT NULL");
		}
		if (aa00j10s01 != null && aa00j10s01.getSit10() != null) {
			where.append(" AND UPPER(t1.SIT10) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j10s01.getSit10().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j10s01.getSit10().toUpperCase() + "%");
			}
			where.append(" AND t1.SIT10 IS NOT NULL");
		}
		if (aa00j10s01 != null && aa00j10s01.getBloq10() != null) {
			where.append(" AND t1.BLOQ10 = ?");
			params.add(aa00j10s01.getBloq10());
		}
		if (aa00j10s01 != null && aa00j10s01.getSwdisp10() != null) {
			where.append(" AND t1.SWDISP10 = ?");
			params.add(aa00j10s01.getSwdisp10());
		}
		if (aa00j10s01 != null && aa00j10s01.getDesc10() != null) {
			where.append(" AND UPPER(t1.DESC10) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j10s01.getDesc10().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j10s01.getDesc10().toUpperCase() + "%");
			}
			where.append(" AND t1.DESC10 IS NOT NULL");
		}
		if (aa00j10s01 != null && aa00j10s01.getTlfno10() != null) {
			where.append(" AND UPPER(t1.TLFNO10) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j10s01.getTlfno10().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j10s01.getTlfno10().toUpperCase() + "%");
			}
			where.append(" AND t1.TLFNO10 IS NOT NULL");
		}
		if (aa00j10s01 != null && aa00j10s01.getUsub10() != null) {
			where.append(" AND UPPER(t1.USUB10) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j10s01.getUsub10().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j10s01.getUsub10().toUpperCase() + "%");
			}
			where.append(" AND t1.USUB10 IS NOT NULL");
		}
		if (aa00j10s01 != null && aa00j10s01.getPlanta10() != null) {
			where.append(" AND UPPER(t1.PLANTA10) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j10s01.getPlanta10().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j10s01.getPlanta10().toUpperCase() + "%");
			}
			where.append(" AND t1.PLANTA10 IS NOT NULL");
		}
		if (aa00j10s01 != null && aa00j10s01.getDcapc10() != null) {
			where.append(" AND UPPER(t1.DCAPC10) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j10s01.getDcapc10().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j10s01.getDcapc10().toUpperCase() + "%");
			}
			where.append(" AND t1.DCAPC10 IS NOT NULL");
		}
		if (aa00j10s01 != null && aa00j10s01.getDcape10() != null) {
			where.append(" AND UPPER(t1.DCAPE10) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j10s01.getDcape10().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j10s01.getDcape10().toUpperCase() + "%");
			}
			where.append(" AND t1.DCAPE10 IS NOT NULL");
		}
		if (aa00j10s01 != null && aa00j10s01.getNcap10() != null) {
			where.append(" AND t1.NCAP10 = ?");
			params.add(aa00j10s01.getNcap10());
		}
		if (aa00j10s01 != null && aa00j10s01.getAa00j11s01() != null
				&& aa00j10s01.getAa00j11s01().getCsala11() != null) {
			where.append(" AND t6.CSALA11 = ?");
			params.add(aa00j10s01.getAa00j11s01().getCsala11());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	public boolean existe(String nombre, Long codigoNoIncluir) {
		Aa00j10s01DaoImpl.logger.info("Método existe");
		if (codigoNoIncluir != null && codigoNoIncluir > 0) {
			String query = "SELECT COUNT(1) FROM AA00J10S01 WHERE UPPER(NOMBRE10) = UPPER(?) AND CSALA10 <> ?";
			return this.jdbcTemplate
					.queryForInt(query, nombre, codigoNoIncluir) > 0;
		} else {
			String query = "SELECT COUNT(1) FROM AA00J10S01 WHERE UPPER(NOMBRE10) = UPPER(?)";
			return this.jdbcTemplate.queryForInt(query, nombre) > 0;
		}
	}

	public boolean existeEdificio(Long cedif10) {
		Aa00j10s01DaoImpl.logger.info("Método existeEdificio");
		String query = "SELECT COUNT(1) FROM AA00J10S01 WHERE UPPER(CEDIF10) = ?";
		Aa00j10s01DaoImpl.logger.info("SQL " + query);
		Aa00j10s01DaoImpl.logger.info("PARAM1 " + cedif10);
		return this.jdbcTemplate.queryForInt(query, cedif10) > 0;
	}

	public boolean existeDepartamento(Long cdep10) {
		Aa00j10s01DaoImpl.logger.info("Método existeDepartamento");
		String query = "SELECT COUNT(1) FROM AA00J10S01 WHERE UPPER(CDEP10) = ?";
		Aa00j10s01DaoImpl.logger.info("SQL " + query);
		Aa00j10s01DaoImpl.logger.info("PARAM1 " + cdep10);
		return this.jdbcTemplate.queryForInt(query, cdep10) > 0;
	}

	public boolean existeTextoReserva(Long ctexto10) {
		Aa00j10s01DaoImpl.logger.info("Método existeTextoReserva");
		String query = "SELECT COUNT(1) FROM AA00J10S01 WHERE UPPER(CTEXTO10) = ?";
		Aa00j10s01DaoImpl.logger.info("SQL " + query);
		Aa00j10s01DaoImpl.logger.info("PARAM1 " + ctexto10);
		return this.jdbcTemplate.queryForInt(query, ctexto10) > 0;
	}

	public boolean existeRestriccion(Long crest10) {
		Aa00j10s01DaoImpl.logger.info("Método existeRestriccion");
		String query = "SELECT COUNT(1) FROM AA00J10S01 WHERE UPPER(CREST10) = ?";
		Aa00j10s01DaoImpl.logger.info("SQL " + query);
		Aa00j10s01DaoImpl.logger.info("PARAM1 " + crest10);
		return this.jdbcTemplate.queryForInt(query, crest10) > 0;
	}

	public List<Aa00j10s01> obtenerCombo(Long codDepartamento, Long codEdificio) {
		Aa00j10s01DaoImpl.logger.info("Método obtenerCombo");
		StringBuilder query = new StringBuilder(
				"SELECT t1.CSALA10 CSALA10,t1.NOMBRE10 NOMBRE10 ");
		query.append("FROM AA00J10S01 t1 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.SIT10=? ");

		List<Object> params = new ArrayList<Object>();
		params.add(aa00jConstantes.SITUACION_ALTA);
		// Iker-->Control del departamento por XLNETS
		aa00jPersonaSesion ps = new aa00jSeguridad().getUsuario();
		if (ps.isEsAdminDepto() || ps.isEsTecnico() || ps.isEsAdmin()) {
			if (codDepartamento != null) {
				where.append(" AND t1.CDEP10=?");
				params.add(codDepartamento);
			} else {
				where.append(" AND t1.CDEP10 IS NULL");
			}
		} else {
			if (codDepartamento != null && ps.getDepartamentoInterno() != null) {
				where.append(" AND t1.CDEP10=?");
				params.add(Long.parseLong(ps.getDepartamentoInterno()));
			} else {
				where.append(" AND t1.CDEP10 IS NULL  ");// (t1.CDEP10=? OR
															// t1.CDEP10 IS NULL
															// )");
			}
			// params.add(Long.parseLong(ps.getDepartamentoInterno()));
		}

		if (codEdificio != null) {
			where.append(" AND t1.CEDIF10=?");
			params.add(codEdificio);
		}

		query.append(where);
		Aa00j10s01DaoImpl.logger.info("SQL " + query.toString());
		Aa00j10s01DaoImpl.logger.info("PARAMs " + params);
		return (List<Aa00j10s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMapCombo, params.toArray());
	}

	public List<Aa00j10s01> obtenerComboTodas() {
		Aa00j10s01DaoImpl.logger.info("Método obtenerComboTodas");
		StringBuilder query = new StringBuilder(
				"SELECT t1.CSALA10 CSALA10,t1.NOMBRE10 NOMBRE10 ");
		query.append("FROM AA00J10S01 t1 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.SIT10=? ");

		List<Object> params = new ArrayList<Object>();
		params.add(aa00jConstantes.SITUACION_ALTA);

		query.append(where);
		Aa00j10s01DaoImpl.logger.info("SQL " + query.toString());
		Aa00j10s01DaoImpl.logger.info("PARAMs " + params);
		return (List<Aa00j10s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMapCombo, params.toArray());
	}

	/**
	 * Comprueba si hay salas con los medios de entrada
	 * 
	 * @param medios
	 * @return
	 */
	public long numeroSalasConMedios(ArrayList<String> medios) {
		Aa00j10s01DaoImpl.logger.info("Método numeroSalasConMedios");
		StringBuilder sqlcomprobar = createSqlMediosFijos(medios);
		Aa00j10s01DaoImpl.logger.info("SQL " + sqlcomprobar.toString());

		return this.jdbcTemplate.queryForLong(sqlcomprobar.toString());
	}

	/**
	 * La consulta asistida en formato grid
	 * 
	 * @param jqGridRequestDto
	 * @return
	 */
	public ArrayList<Aa00j10s01> consultaAsistida(FormConsultaAsistida form,
			JQGridRequestDto jqGridRequestDto, Locale locale) {
		Aa00j10s01DaoImpl.logger.info("Método consultaAsistida");
		StringBuilder sql = crearSqlConsultaAsistida(form.getUbicacion());
		if (form.getMediosFijos() != null && form.getMediosFijos().size() > 0) {
			sql.append(crearSubqueryMedios(form.getMediosFijos()));

		}
		// Iker-->Control del departamento por XLNETS
		aa00jPersonaSesion ps = new aa00jSeguridad().getUsuario();
		if (!ps.isEsAdminDepto() && !ps.isEsTecnico() && !ps.isEsAdmin()) {
			/*
			 * Añade la where departamental, en este caso solo salas no
			 * departamentales, igual que en el asp
			 */
			sql.append(crearWhereDepartamental(null));
		}

		List<Object> params = estaplecerParametrosConsulatAsistida(form);
		if (jqGridRequestDto != null) {
			sql = JQGridManager.getPaginationQuery(jqGridRequestDto, sql);
		}
		String strQuery = sql.toString();

		if (locale.getLanguage().contains("eu"))
			strQuery = strQuery.replace(":f",
					aa00jConstantes.FORMATOFECHAEUSKERA);
		else
			strQuery = strQuery.replace(":f",
					aa00jConstantes.FORMATOFECHACASTELLANO);
		Aa00j10s01DaoImpl.logger.info("SQL " + strQuery);
		Aa00j10s01DaoImpl.logger.info("PARAMs " + params);
		return (ArrayList<Aa00j10s01>) this.jdbcTemplate.query(strQuery,
				this.rwMapConsultaActiva, params.toArray());
	}

	/**
	 * La consulta asistida , devuelve el numero de registros para el grid
	 * (cosas de uda)
	 * 
	 * @param jqGridRequestDto
	 * @return
	 */
	public long consultaAsistidaNum(FormConsultaAsistida form, Locale locale) {
		Aa00j10s01DaoImpl.logger.info("Método consultaAsistidaNum");
		StringBuilder sql = new StringBuilder();
		sql.append("select count (*) as num from (");
		sql.append(crearSqlConsultaAsistida(form.getUbicacion()));
		if (form.getMediosFijos() != null) {
			sql.append(crearSubqueryMedios(form.getMediosFijos()));

		}

		// Iker-->Control del departamento por XLNETS
		aa00jPersonaSesion ps = new aa00jSeguridad().getUsuario();
		if (!ps.isEsAdminDepto() && !ps.isEsTecnico() && !ps.isEsAdmin()) {
			/*
			 * Añade la where departamental, en este caso solo salas no
			 * departamentales, igual que en el asp
			 */
			sql.append(crearWhereDepartamental(null));
		}

		sql.append(" )");
		List<Object> params = estaplecerParametrosConsulatAsistida(form);

		String strQuery = sql.toString();
		if (locale.getLanguage().contains("eu"))
			strQuery = strQuery.replace(":f",
					aa00jConstantes.FORMATOFECHAEUSKERA);
		else
			strQuery = strQuery.replace(":f",
					aa00jConstantes.FORMATOFECHACASTELLANO);
		Aa00j10s01DaoImpl.logger.info("SQL " + strQuery);
		Aa00j10s01DaoImpl.logger.info("PARAMs " + params);
		return this.jdbcTemplate.queryForLong(strQuery, params.toArray());
	}

	/**
	 * Establece los parametros para la consulta asistida
	 * 
	 * @param form
	 * @return
	 */
	private List<Object> estaplecerParametrosConsulatAsistida(
			FormConsultaAsistida form) {
		Aa00j10s01DaoImpl.logger
				.info("Método estaplecerParametrosConsulatAsistida");
		List<Object> params = new ArrayList<Object>();
		if (form.getSueltos() == aa00jConstantes.DIASSUELTOS) {
			params.add(form.getFecha());// dia inicio
			params.add(form.getFecha());// dia inicio
			params.add(form.getFecha());// dia fin
		} else {
			params.add(form.getDiadesde());// dia inicio
			params.add(form.getDiadesde());// dia inicio
			params.add(form.getDiahasta());// dia fin
		}
		params.add(form.getHoraIni());// hora inicio
		params.add(form.getHoraIni());// hora inicio
		params.add(form.getHoraIni());// hora inicio
		params.add(form.getHoraFin());// hora inicio
		params.add(form.getCapacidad());// capacidad
		if (form.getUbicacion() != null)
			params.add(form.getUbicacion());// capacidad
		return params;

	}

	/**
	 * Crea la sql de la consulta asistida
	 * 
	 * @return
	 */
	private StringBuilder crearSqlConsultaAsistida(String ubicacion) {
		Aa00j10s01DaoImpl.logger.info("Método crearSqlConsultaAsistida");
		StringBuilder sql = new StringBuilder("");
		sql.append(" select distinct (csala10), nombre10,ncap10,nombre03,crest06,descc06,desce06");
		sql.append(" from aa00j10S01 left join aa00j03S01 ");
		sql.append(" on aa00j03S01.cedif03=cedif10");
		sql.append(" left join aa00j06S01 on crest10=crest06");
		sql.append(" where ");
		sql.append(" SIT10                 ='");
		sql.append(aa00jConstantes.SITUACION_ALTA);
		sql.append("'");
		sql.append(" AND csala10 not in(");
		sql.append(" SELECT distinct(CSALA20)");
		sql.append(" FROM aa00j20S01");
		sql.append(" WHERE ( (aa00j20S01.SIT20                 ='");
		sql.append(aa00jConstantes.SITUACION_ALTA);
		sql.append("')");
		sql.append(" AND ( TRUNC(DHCOM20)                      = to_date(?,':f')");
		sql.append(" OR ((TRUNC(DHCOM20)                        < to_date(?,':f'))");
		sql.append(" AND (TRUNC(DHFIN20)                       >= to_date(?,':f')) ))");
		sql.append(" AND ( ( (TO_CHAR( DHCOM20, 'HH24:MI:SS' ) <= ?)");
		sql.append(" AND (TO_CHAR( DHFIN20, 'HH24:MI:SS' )      > ?) )");
		sql.append(" OR ( (TO_CHAR( DHCOM20, 'HH24:MI:SS' )    >= ?)");
		sql.append(" AND (TO_CHAR( DHCOM20, 'HH24:MI:SS' )      < ?) ) ))");
		sql.append(" )");
		sql.append(" and ncap10>=?");
		if (ubicacion != null)
			sql.append(" and cedif03 =?");

		return sql;
	}

	private StringBuilder crearWhereDepartamental(String departamento) {
		StringBuilder sql = new StringBuilder();
		sql.append(" AND (");
		sql.append(" cdep10 is null ");
		if (departamento != null && departamento.length() > 0)
			sql.append(" and cdep10 =? ");
		sql.append(" ) ");
		return sql;
	}

	/**
	 * Devuelve una sql que busca si existen alguna sala
	 * 
	 * @param nombresMedios
	 * @return
	 */

	private StringBuilder createSqlMediosFijos(ArrayList<String> nombresMedios) {

		StringBuilder sql = new StringBuilder("");
		sql.append("SELECT count(distinct csala10) as num ");
		sql.append(" FROM  aa00j10S01 ");
		// he simplificado la sql del asp (para lo del asp descomentar las 2
		// siguientes lineas
		// sql.append(" INNER JOIN AA00J06S01 ON CREST10=CREST06");
		// sql.append(" inner join AA00J12S01 ON aa00j10S01.CSALA10 = AA00J12S01.CSALA12");
		sql.append(" WHERE");
		sql.append(" SWDISP10=1");
		sql.append(crearSubqueryMedios(nombresMedios));

		return sql;
	}

	/*
	 * Otra versión para lo de abajo (lenta?) select// * from ( SELECT
	 * u.csala10,u.nombre10, (SELECT (RTRIM(XMLAGG(xmlelement(X,'#'||
	 * AA00J12S01.nom12||'#')order by
	 * AA00J12S01.nom12).extract('//text()'),',')) FROM AA00J12S01 inner JOIN
	 * aa00j10S01 ON aa00j10S01.CSALA10 = AA00J12S01.CSALA12 WHERE SWDISP12=1
	 * and csala10=u.csala10) as aparatos FROM aa00j10S01 u ) where
	 * 
	 * aparatos like '%#Pantalla#%' and aparatos like '%#Proyector#%' ;
	 */
	/**
	 * Crea subquery para medios
	 */
	private StringBuilder crearSubqueryMedios(ArrayList<String> nombresMedios) {
		StringBuilder sql = new StringBuilder();
		for (String s : nombresMedios) {
			sql.append(" AND ");
			sql.append(" csala10 in ");
			sql.append(" (select distinct csala12 from");
			sql.append("    aa00j12S01 ");
			sql.append("   where  AA00J12S01.nom12=");
			sql.append("'");
			sql.append(s);
			sql.append("'");
			sql.append("  and SWDISP12=1)");

		}

		return sql;
	}

	private RowMapper<Option> optionMap = new RowMapper<Option>() {
		public Option mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Option(resultSet.getString("VALUE"),
					resultSet.getString("TEXT"));
		}
	};

	/**
	 * Devuelve una lista de salas por código de sitio
	 */
	@Override
	public List<Option> salasPorSitio(int sitio) {
		Aa00j10s01DaoImpl.logger.info("Método salasPorSitio");
		StringBuilder sql = new StringBuilder();
		sql.append(" SELECT CSALA10 AS value, ");
		sql.append(" NOMBRE10 as text");
		sql.append(" FROM AA00J10S01 ");

		sql.append(" WHERE CEDIF10=? and cdep10 is null");
		sql.append(" ORDER BY NOMBRE10");

		List<Object> params = new ArrayList<Object>();
		params.add(sitio);
		Aa00j10s01DaoImpl.logger.info("SQL " + sql.toString());
		Aa00j10s01DaoImpl.logger.info("PARAMs " + params);
		return this.jdbcTemplate.query(sql.toString(), this.optionMap,
				params.toArray());
	}

	/**
	 * Devuelve una lista de salas por código de departamento
	 */
	@Override
	public List<Option> salasPorDepartamento(int departamento) {
		Aa00j10s01DaoImpl.logger.info("Método salasPorDepartamento");
		StringBuilder sql = new StringBuilder();
		sql.append(" SELECT CSALA10 AS value, ");
		sql.append(" NOMBRE10");
		sql.append(" ||' - '");
		sql.append(" || NOMBRE03");
		sql.append(" ||' ('");
		sql.append(" || NOMBRE02 ");
		sql.append(" ||') ' AS text");
		sql.append(" FROM AA00J03S01 ");
		sql.append(" INNER JOIN AA00J10S01 ");
		sql.append(" ON CEDIF10 = CEDIF03 ");
		sql.append(" INNER JOIN AA00J02S01 ");
		sql.append(" ON CSITIO03 = CSITIO02");
		sql.append(" WHERE CDEP10=?");
		sql.append(" ORDER BY CSITIO02,");
		sql.append(" CEDIF10,");
		sql.append(" NOMBRE10 ");
		List<Object> params = new ArrayList<Object>();
		params.add(departamento);
		Aa00j10s01DaoImpl.logger.info("SQL " + sql.toString());
		Aa00j10s01DaoImpl.logger.info("PARAMs " + params);
		return this.jdbcTemplate.query(sql.toString(), this.optionMap,
				params.toArray());
	}

	/**
	 * Devuelve una lista de las salas del listado
	 * 
	 * @param listado
	 * @return
	 */
	public List<Aa00j10s01> obtenerSalasListado(int listado) {
		Aa00j10s01DaoImpl.logger.info("Método obtener salas listado");
		StringBuilder query = new StringBuilder("");
		query.append("select  CSALA10, NOMBRE10||'('||NOMBRE03||'-'||NOMBRE02||')' as NOMBRE10  from aa00j10s01");
		query.append("	 INNER JOIN AA00J03S01");
		query.append(" ON CEDIF10 = CEDIF03 ");
		query.append("	 INNER JOIN AA00J02S01 ");
		query.append(" ON CSITIO03 = CSITIO02");
		query.append(" inner join AA00J17S01 on csala10=csala17 where tipo17=? order by orden17 asc");
		// Where clause & Params

		List<Object> params = new ArrayList<Object>();
		params.add(listado);

		Aa00j10s01DaoImpl.logger.info("SQL " + query.toString());
		Aa00j10s01DaoImpl.logger.info("PARAMs " + params);
		return (List<Aa00j10s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMapCombo, params.toArray());
	}

	/**
	 * Devuelve una lista que no están en un listado
	 * 
	 * @param listado
	 * @return
	 */
	public List<Aa00j10s01> obtenerSalasNoListado(int listado) {
		Aa00j10s01DaoImpl.logger.info("Método obtener salas listado");
		StringBuilder query = new StringBuilder("");
		query.append("select distinct  CSALA10, NOMBRE10||'('||NOMBRE03||'-'||NOMBRE02||')' as NOMBRE10  from aa00j10s01");
		query.append(" INNER JOIN AA00J03S01");
		query.append(" ON CEDIF10 = CEDIF03 ");
		query.append(" INNER JOIN AA00J02S01 ");
		query.append(" ON CSITIO03 = CSITIO02");
		query.append(" left join AA00J17S01 on csala10=csala17 where tipo17!=? or tipo17 is null order by nombre10 asc");
		// Where clause & Params

		List<Object> params = new ArrayList<Object>();
		params.add(listado);

		Aa00j10s01DaoImpl.logger.info("SQL " + query.toString());
		Aa00j10s01DaoImpl.logger.info("PARAMs " + params);
		return (List<Aa00j10s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMapCombo, params.toArray());
	}
}