package com.ejie.aa00j.dao;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import com.ejie.aa00j.model.Aa00j10s01;
import com.ejie.aa00j.model.Option;
import com.ejie.aa00j.model.forms.FormConsultaAsistida;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa00j10s01Dao generated by UDA, 16-oct-2013 13:02:12.
 * 
 * @author UDA
 */

public interface Aa00j10s01Dao {

	/**
	 * Inserts a single row in the Aa00j10s01 table.
	 * 
	 * @param aa00j10s01
	 *            Aa00j10s01
	 * @return Aa00j10s01
	 */
	Aa00j10s01 add(Aa00j10s01 aa00j10s01);

	/**
	 * Updates a single row in the Aa00j10s01 table.
	 * 
	 * @param aa00j10s01
	 *            Aa00j10s01
	 * @return Aa00j10s01
	 */
	Aa00j10s01 update(Aa00j10s01 aa00j10s01);

	/**
	 * Finds a single row in the Aa00j10s01 table.
	 * 
	 * @param aa00j10s01
	 *            Aa00j10s01
	 * @return Aa00j10s01
	 */
	Aa00j10s01 find(Aa00j10s01 aa00j10s01);

	/**
	 * Removes a single row in the Aa00j10s01 table.
	 * 
	 * @param aa00j10s01
	 *            Aa00j10s01
	 */
	void remove(Aa00j10s01 aa00j10s01);

	/**
	 * Finds a List of rows in the Aa00j10s01 table.
	 * 
	 * @param aa00j10s01
	 *            Aa00j10s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List
	 */
	List<Aa00j10s01> findAll(Aa00j10s01 aa00j10s01,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Finds rows in the Aa00j10s01 table using like.
	 * 
	 * @param aa00j10s01
	 *            Aa00j10s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Aa00j10s01> findAllLike(Aa00j10s01 aa00j10s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter in the Aa00j10s01 table.
	 * 
	 * @param filterAa00j10s01
	 *            Aa00j10s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(Aa00j10s01 filterAa00j10s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Counts rows in the Aa00j10s01 table using like.
	 * 
	 * @param aa00j10s01
	 *            Aa00j10s01
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Aa00j10s01 aa00j10s01, Boolean startsWith);

	/**
	 * Counts rows in the Aa00j10s01 table.
	 * 
	 * @param aa00j10s01
	 *            Aa00j10s01
	 * @return Long
	 */
	Long findAllCount(Aa00j10s01 aa00j10s01);

	/**
	 * Reorder selection.
	 * 
	 * @param filterAa00j10s01
	 *            Aa00j10s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j10s01>>
	 */
	List<TableRowDto<Aa00j10s01>> reorderSelection(Aa00j10s01 filterAa00j10s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Searches in the Usuario table.
	 * 
	 * @param filterAa00j10s01
	 *            Aa00j10s01
	 * @param searchAa00j10s01
	 *            Aa00j10s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j10s01>>
	 */
	List<TableRowDto<Aa00j10s01>> search(Aa00j10s01 filterAa00j10s01,
			Aa00j10s01 searchAa00j10s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Filter in the hierarchical Aa00j10s01 table.
	 * 
	 * @param filterAa00j10s01
	 *            Aa00j10s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Aa00j10s01>>
	 */
	List<JerarquiaDto<Aa00j10s01>> findAllLikeJerarquia(
			Aa00j10s01 filterAa00j10s01, JQGridRequestDto jqGridRequestDto);

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAa00j10s01
	 *            Aa00j10s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	Long findAllLikeCountJerarquia(Aa00j10s01 filterAa00j10s01,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAa00j10s01
	 *            Aa00j10s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Aa00j10s01>>
	 */
	List<TableRowDto<Aa00j10s01>> findAllChild(Aa00j10s01 filterAa00j10s01,
			JQGridRequestDto jqGridRequestDto);

	boolean existe(String nombre, Long codigoNoIncluir);

	boolean existeEdificio(Long cedif10);

	boolean existeTextoReserva(Long ctexto10);

	boolean existeRestriccion(Long crest10);

	boolean existeDepartamento(Long cdep10);

	List<Aa00j10s01> obtenerCombo(Long codDepartamento, Long codEdificio);

	List<Aa00j10s01> obtenerComboTodas();

	public ArrayList<Aa00j10s01> consultaAsistida(FormConsultaAsistida form,
			JQGridRequestDto jqGridRequestDto, Locale local);

	public long consultaAsistidaNum(FormConsultaAsistida form, Locale local);

	public long numeroSalasConMedios(ArrayList<String> medios);

	List<Option> salasPorSitio(int sitio);

	List<Option> salasPorDepartamento(int departamento);

	/**
	 * Devuelve una lista de las salas del listado
	 * 
	 * @param listado
	 * @return
	 */
	public List<Aa00j10s01> obtenerSalasListado(int listado);

	/**
	 * Devuelve una lista que no están en un listado
	 * 
	 * @param listado
	 * @return
	 */
	public List<Aa00j10s01> obtenerSalasNoListado(int listado);
}