package com.ejie.aa00j.dao;

import java.util.ArrayList;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class Aa00j09s01DaoImpl implements Aa00j09s01Dao {
	private JdbcTemplate jdbcTemplate;
	private static final Logger logger = LoggerFactory
			.getLogger(Aa00j09s01DaoImpl.class);

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Devuelve los identificadores de los edificios asignados al usuario
	 * 
	 * @return
	 */
	@Transactional(readOnly = true)
	public Integer[] edificiosDeUsuario(String codigo) {
		Integer[] salida = null;

		Aa00j09s01DaoImpl.logger.info("Método edificiosDeUsuario");
		StringBuffer query = new StringBuffer("");
		query.append("select cedif09 from aa00j09t00 WHERE cresp09=?");

		Aa00j09s01DaoImpl.logger.info("SQL =" + query.toString());
		SqlRowSet srs = this.jdbcTemplate.queryForRowSet(query.toString(),
				codigo);
		ArrayList<Integer> lista = new ArrayList<Integer>();
		while (srs.next()) {
			lista.add(srs.getInt("cedif09"));
		}

		salida = (Integer[]) lista.toArray(new Integer[lista.size()]);
		return salida;
	}
}
