package com.ejie.aa00j.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa00j.classes.aa00jConstantes;
import com.ejie.aa00j.classes.aa00jPersonaSesion;
import com.ejie.aa00j.classes.aa00jSeguridad;
import com.ejie.aa00j.model.Aa00j07s01;
import com.ejie.aa00j.model.Option;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa00j07s01DaoImpl generated by UDA, 16-oct-2013 13:02:12.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class Aa00j07s01DaoImpl implements Aa00j07s01Dao {
	private JdbcTemplate jdbcTemplate;
	private static final Logger logger = LoggerFactory
			.getLogger(Aa00j07s01DaoImpl.class);
	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Aa00j07s01> rwMap = new RowMapper<Aa00j07s01>() {
		public Aa00j07s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa00j07s01(resultSet.getLong("CDEP07"),
					resultSet.getString("DESCC07"),
					resultSet.getString("DESCE07"),
					resultSet.getString("SIT07"), resultSet.getInt("BLOQ07"),
					resultSet.getString("USUB07"),
					resultSet.getString("COD_XLNET_07"));
		}
	};

	private RowMapper<Aa00j07s01> rwMapPK = new RowMapper<Aa00j07s01>() {
		public Aa00j07s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa00j07s01(resultSet.getLong("CDEP07"));
		}
	};

	private RowMapper<Aa00j07s01> rwMapCombo = new RowMapper<Aa00j07s01>() {
		public Aa00j07s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa00j07s01(resultSet.getLong("CDEP07"),
					resultSet.getString("DESCC07"),
					resultSet.getString("DESCE07"), "", 0, "", "");
		}
	};
	private RowMapper<Option> optionMap = new RowMapper<Option>() {
		public Option mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Option(resultSet.getString("VALUE"),
					resultSet.getString("TEXT"));
		}
	};
	/**
	 * Rowmapper para Jerarquía
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Aa00j07s01>> rwMapJerarquia = new RowMapper<JerarquiaDto<Aa00j07s01>>() {
		public JerarquiaDto<Aa00j07s01> mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Aa00j07s01 aa00j07s01 = new Aa00j07s01(resultSet.getLong("CDEP07"),
					resultSet.getString("DESCC07"),
					resultSet.getString("DESCE07"),
					resultSet.getString("SIT07"), resultSet.getInt("BLOQ07"),
					resultSet.getString("USUB07"),
					resultSet.getString("COD_XLNET_07"));

			JerarquiaDto<Aa00j07s01> jerarquia = new JerarquiaDto<Aa00j07s01>();
			jerarquia.setModel(aa00j07s01);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet
					.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet
					.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Aa00j07s01 table.
	 * 
	 * @param aa00j07s01
	 *            Aa00j07s01
	 * @return Aa00j07s01
	 */
	public Aa00j07s01 add(final Aa00j07s01 aa00j07s01) {
		if (aa00j07s01.getSit07() == null
				|| aa00j07s01.getSit07().length() == 0)
			aa00j07s01.setSit07(aa00jConstantes.SITUACION_ALTA);
		Aa00j07s01DaoImpl.logger.info("Método add");
		final String queryUltimoId = "(SELECT NVL(MAX(TO_NUMBER(CDEP07)), 0) + 1 FROM AA00J07S01)";
		final String query = "INSERT INTO AA00J07S01 (CDEP07, DESCC07, DESCE07, SIT07, BLOQ07, USUB07, COD_XLNET_07) VALUES ("
				+ queryUltimoId + ",?,?,?,?,?,?)";

		KeyHolder keyHolder = new GeneratedKeyHolder();
		Aa00j07s01DaoImpl.logger.info("SQL =" + query);
		Aa00j07s01DaoImpl.logger.info("PARM1= "
				+ aa00j07s01.getDescc07().trim());
		Aa00j07s01DaoImpl.logger.info("PARM2= "
				+ aa00j07s01.getDesce07().trim());
		Aa00j07s01DaoImpl.logger.info("PARM3= " + aa00j07s01.getSit07());
		Aa00j07s01DaoImpl.logger.info("PARM4= " + 0);
		Aa00j07s01DaoImpl.logger.info("PARM5= " + null);
		Aa00j07s01DaoImpl.logger.info("PARM6= " + aa00j07s01.getCodxlnet07());

		jdbcTemplate.update(new PreparedStatementCreator() {
			public PreparedStatement createPreparedStatement(
					Connection connection) throws SQLException {
				PreparedStatement ps = connection.prepareStatement(query,
						new String[] { "CDEP07" });
				ps.setObject(1, aa00j07s01.getDescc07().trim());
				ps.setObject(2, aa00j07s01.getDesce07().trim());
				ps.setObject(3, aa00j07s01.getSit07());
				ps.setObject(4, 0);
				ps.setObject(5, null);
				ps.setObject(6, aa00j07s01.getCodxlnet07());
				return ps;
			}
		}, keyHolder);

		aa00j07s01.setCdep07(keyHolder.getKey().longValue());

		return aa00j07s01;
	}

	/**
	 * Updates a single row in the Aa00j07s01 table.
	 * 
	 * @param aa00j07s01
	 *            Aa00j07s01
	 * @return Aa00j07s01
	 */
	public Aa00j07s01 update(Aa00j07s01 aa00j07s01) {
		if (aa00j07s01.getSit07() == null
				|| aa00j07s01.getSit07().length() == 0)
			aa00j07s01.setSit07(aa00jConstantes.SITUACION_ALTA);
		Aa00j07s01DaoImpl.logger.info("Método update");
		String query = "UPDATE AA00J07S01 SET DESCC07=?, DESCE07=?, SIT07=?, BLOQ07=?, USUB07=?, COD_XLNET_07=? WHERE CDEP07=?";

		Aa00j07s01DaoImpl.logger.info("SQL =" + query);
		Aa00j07s01DaoImpl.logger.info("PARM1= "
				+ aa00j07s01.getDescc07().trim());
		Aa00j07s01DaoImpl.logger.info("PARM2= "
				+ aa00j07s01.getDesce07().trim());
		Aa00j07s01DaoImpl.logger.info("PARM3= " + aa00j07s01.getSit07());
		Aa00j07s01DaoImpl.logger.info("PARM4= " + aa00j07s01.getBloq07());
		Aa00j07s01DaoImpl.logger.info("PARM5= " + aa00j07s01.getUsub07());
		Aa00j07s01DaoImpl.logger.info("PARM6= " + aa00j07s01.getCodxlnet07());
		Aa00j07s01DaoImpl.logger.info("PARM7= " + aa00j07s01.getCdep07());
		this.jdbcTemplate.update(query, aa00j07s01.getDescc07(),
				aa00j07s01.getDesce07(), aa00j07s01.getSit07(),
				aa00j07s01.getBloq07(), aa00j07s01.getUsub07(),
				aa00j07s01.getCodxlnet07(), aa00j07s01.getCdep07());
		return aa00j07s01;
	}

	/**
	 * Finds a single row in the Aa00j07s01 table.
	 * 
	 * @param aa00j07s01
	 *            Aa00j07s01
	 * @return Aa00j07s01
	 */
	@Transactional(readOnly = true)
	public Aa00j07s01 find(Aa00j07s01 aa00j07s01) {
		Aa00j07s01DaoImpl.logger.info("Método find");
		String query = "SELECT t1.CDEP07 CDEP07, t1.DESCC07 DESCC07, NVL2(t1.DESCE07,t1.DESCE07,t1.DESCC07) DESCE07, t1.SIT07 SIT07, t1.BLOQ07 BLOQ07, t1.USUB07 USUB07, t1.COD_XLNET_07 COD_XLNET_07 FROM AA00J07S01 t1  WHERE t1.CDEP07 = ?  ";
		Aa00j07s01DaoImpl.logger.info("SQL =" + query);
		Aa00j07s01DaoImpl.logger.info("PARM1= " + aa00j07s01.getCdep07());

		List<Aa00j07s01> aa00j07s01List = this.jdbcTemplate.query(query,
				this.rwMap, aa00j07s01.getCdep07());
		return (Aa00j07s01) DataAccessUtils.uniqueResult(aa00j07s01List);
	}

	/**
	 * Removes a single row in the Aa00j07s01 table.
	 * 
	 * @param aa00j07s01
	 *            Aa00j07s01
	 * @return
	 */
	public void remove(Aa00j07s01 aa00j07s01) {
		Aa00j07s01DaoImpl.logger.info("Método remove");
		String query = "DELETE FROM AA00J07S01 WHERE CDEP07=?";
		Aa00j07s01DaoImpl.logger.info("SQL =" + query);
		Aa00j07s01DaoImpl.logger.info("PARM1= " + aa00j07s01.getCdep07());
		this.jdbcTemplate.update(query, aa00j07s01.getCdep07());
	}

	/**
	 * Finds a list of rows in the Aa00j07s01 table.
	 * 
	 * @param aa00j07s01
	 *            Aa00j07s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa00j07s01>
	 */
	@Transactional(readOnly = true)
	public List<Aa00j07s01> findAll(Aa00j07s01 aa00j07s01,
			JQGridRequestDto jqGridRequestDto) {
		Aa00j07s01DaoImpl.logger.info("Método findAll");

		StringBuilder query = new StringBuilder(
				"SELECT  t1.CDEP07 CDEP07,t1.DESCC07 DESCC07,NVL2(t1.DESCE07,t1.DESCE07,t1.DESCC07) DESCE07,t1.SIT07 SIT07,t1.BLOQ07 BLOQ07,t1.USUB07 USUB07,t1.COD_XLNET_07 COD_XLNET_07 ");
		query.append("FROM AA00J07S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa00j07s01);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		Aa00j07s01DaoImpl.logger.info("SQL =" + query);
		Aa00j07s01DaoImpl.logger.info("PARMs= " + params);
		return (List<Aa00j07s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Aa00j07s01 table using like.
	 * 
	 * @param aa00j07s01
	 *            Aa00j07s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa00j07s01>
	 */
	@Transactional(readOnly = true)
	public List<Aa00j07s01> findAllLike(Aa00j07s01 aa00j07s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		Aa00j07s01DaoImpl.logger.info("Método findAllLike");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CDEP07 CDEP07,t1.DESCC07 DESCC07,t1.DESCE07 DESCE07,t1.SIT07 SIT07,t1.BLOQ07 BLOQ07,t1.USUB07 USUB07,t1.COD_XLNET_07 COD_XLNET_07 ");
		query.append("FROM AA00J07S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa00j07s01, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		Aa00j07s01DaoImpl.logger.info("SQL =" + query);
		Aa00j07s01DaoImpl.logger.info("PARMs= " + params);
		return (List<Aa00j07s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Aa00j07s01 table.
	 * 
	 * @param aa00j07s01
	 *            Aa00j07s01
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Aa00j07s01 aa00j07s01) {
		Aa00j07s01DaoImpl.logger.info("Método findAllCount");
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA00J07S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa00j07s01);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		Aa00j07s01DaoImpl.logger.info("SQL =" + query);
		Aa00j07s01DaoImpl.logger.info("PARMs= " + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Aa00j07s01 table using like.
	 * 
	 * @param aa00j07s01
	 *            Aa00j07s01
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Aa00j07s01 aa00j07s01, Boolean startsWith) {
		Aa00j07s01DaoImpl.logger.info("Método findAllLikeCount");
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA00J07S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa00j07s01, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		Aa00j07s01DaoImpl.logger.info("SQL =" + query);
		Aa00j07s01DaoImpl.logger.info("PARMs= " + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Aa00j07s01 selected for rup_table
	 * 
	 * @param aa00j07s01
	 *            Aa00j07s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j07s01>>
	 */
	@Override
	public List<TableRowDto<Aa00j07s01>> reorderSelection(
			Aa00j07s01 aa00j07s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		Aa00j07s01DaoImpl.logger.info("Método reorderSelection");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CDEP07 CDEP07,t1.DESCC07 DESCC07,NVL2(t1.DESCE07,t1.DESCE07,t1.DESCC07) DESCE07,t1.SIT07 SIT07,t1.BLOQ07 BLOQ07,t1.USUB07 USUB07,t1.COD_XLNET_07 COD_XLNET_07 ");
		// FROM
		query.append("FROM AA00J07S01 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa00j07s01, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, Aa00j07s01.class, filterParamList,
				"CDEP07");
		Aa00j07s01DaoImpl.logger.info("SQL =" + sbReorderSelectionSQL);
		Aa00j07s01DaoImpl.logger.info("PARMs= " + filterParamList);
		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa00j07s01>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * @param filterParams
	 *            Aa00j07s01
	 * @param searchParams
	 *            Aa00j07s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j07s01>>
	 */
	@Override
	public List<TableRowDto<Aa00j07s01>> search(Aa00j07s01 filterParams,
			Aa00j07s01 searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		Aa00j07s01DaoImpl.logger.info("Método search");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CDEP07 CDEP07,t1.DESCC07 DESCC07,NVL2(t1.DESCE07,t1.DESCE07,t1.DESCC07) DESCE07,t1.SIT07 SIT07,t1.BLOQ07 BLOQ07,t1.USUB07 USUB07,t1.COD_XLNET_07 COD_XLNET_07 ");
		// FROM
		query.append("FROM AA00J07S01 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, Aa00j07s01.class, filterParamList,
				searchSQL, searchParamList, from_alias, "CDEP07");
		Aa00j07s01DaoImpl.logger.info("SQL =" + sbReorderSelectionSQL);
		Aa00j07s01DaoImpl.logger.info("PARMs= " + filterParamList);
		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa00j07s01>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 * 
	 * @param filteraa00j07s01
	 *            Aa00j07s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Aa00j07s01 filteraa00j07s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		Aa00j07s01DaoImpl.logger.info("Método removeMultiple");
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.CDEP07 CDEP07,t1.DESCC07 DESCC07,NVL2(t1.DESCE07,t1.DESCE07,t1.DESCC07) DESCE07,t1.SIT07 SIT07,t1.BLOQ07 BLOQ07,t1.USUB07 USUB07,t1.COD_XLNET_07 COD_XLNET_07 ");
		// FROM
		query.append("FROM AA00J07S01 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filteraa00j07s01,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto, Aa00j07s01.class,
						query, params, "CDEP07");
		Aa00j07s01DaoImpl.logger.info("SQL =" + query);
		Aa00j07s01DaoImpl.logger.info("PARMs= " + params);
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical Aa00j07s01 table.
	 * 
	 * @param filterAa00j07s01
	 *            Aa00j07s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Aa00j07s01>>
	 */
	@Override
	public List<JerarquiaDto<Aa00j07s01>> findAllLikeJerarquia(
			Aa00j07s01 filterAa00j07s01, JQGridRequestDto jqGridRequestDto) {
		Aa00j07s01DaoImpl.logger.info("Método findAllLikeJerarquia");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CDEP07 CDEP07,t1.DESCC07 DESCC07,NVL2(t1.DESCE07,t1.DESCE07,t1.DESCC07) DESCE07,t1.SIT07 SIT07,t1.BLOQ07 BLOQ07,t1.USUB07 USUB07,t1.COD_XLNET_07 COD_XLNET_07 ");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA00J07S01 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA00J07S01");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa00j07s01, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
				mapaWhere, "CDEP07", "ID_PADRE", "NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}
		Aa00j07s01DaoImpl.logger.info("SQL=" + query.toString());
		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j07s01DaoImpl.logger.info("SQL =" + query);
		Aa00j07s01DaoImpl.logger.info("PARMs= " + params);
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAa00j07s01
	 *            Aa00j07s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Aa00j07s01 filterAa00j07s01,
			JQGridRequestDto jqGridRequestDto) {
		Aa00j07s01DaoImpl.logger.info("Método findAllLikeCountJerarquia");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA00J07S01 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA00J07S01");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa00j07s01, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(
				jqGridRequestDto, mapaWhere, "CDEP07", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		Aa00j07s01DaoImpl.logger.info("SQL =" + query);
		Aa00j07s01DaoImpl.logger.info("PARMs= " + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAa00j07s01
	 *            Aa00j07s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Aa00j07s01>>
	 */
	@Override
	public List<TableRowDto<Aa00j07s01>> findAllChild(
			Aa00j07s01 filterAa00j07s01, JQGridRequestDto jqGridRequestDto) {
		Aa00j07s01DaoImpl.logger.info("Método findAllChild");

		// FROM
		// StringBuilder from = new StringBuilder("FROM AA00J07S01 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA00J07S01");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa00j07s01, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(
				jqGridRequestDto, mapaWhere, "CDEP07", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j07s01DaoImpl.logger.info("SQL =" + query);
		Aa00j07s01DaoImpl.logger.info("PARMs= " + params);
		return this.jdbcTemplate
				.query(query.toString(),
						new RowNumResultSetExtractor<Aa00j07s01>(this.rwMapPK,
								"CDEP07"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa00j07s01 entity
	 * 
	 * @param aa00j07s01
	 *            Aa00j07s01 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Aa00j07s01 aa00j07s01) {

		StringBuilder where = new StringBuilder(
				Aa00j07s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa00j07s01 != null && aa00j07s01.getCdep07() != null) {
			where.append(" AND t1.CDEP07 = ?");
			params.add(aa00j07s01.getCdep07());
		}
		if (aa00j07s01 != null && aa00j07s01.getDescc07() != null) {
			where.append(" AND t1.DESCC07 = ?");
			params.add(aa00j07s01.getDescc07());
		}
		if (aa00j07s01 != null && aa00j07s01.getDesce07() != null) {
			where.append(" AND t1.DESCE07 = ?");
			params.add(aa00j07s01.getDesce07());
		}
		if (aa00j07s01 != null && aa00j07s01.getSit07() != null) {
			where.append(" AND t1.SIT07 = ?");
			params.add(aa00j07s01.getSit07());
		}
		if (aa00j07s01 != null && aa00j07s01.getBloq07() != null) {
			where.append(" AND t1.BLOQ07 = ?");
			params.add(aa00j07s01.getBloq07());
		}
		if (aa00j07s01 != null && aa00j07s01.getUsub07() != null) {
			where.append(" AND t1.USUB07 = ?");
			params.add(aa00j07s01.getUsub07());
		}
		if (aa00j07s01 != null && aa00j07s01.getCodxlnet07() != null) {
			where.append(" AND t1.COD_XLNET_07 = ?");
			params.add(aa00j07s01.getCodxlnet07());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa00j07s01 entity
	 * 
	 * @param aa00j07s01
	 *            Aa00j07s01 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Aa00j07s01 aa00j07s01,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				Aa00j07s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa00j07s01 != null && aa00j07s01.getCdep07() != null) {
			where.append(" AND t1.CDEP07 = ?");
			params.add(aa00j07s01.getCdep07());
		}
		if (aa00j07s01 != null && aa00j07s01.getDescc07() != null
				&& aa00j07s01.getDescc07().length() > 0) {
			where.append(" AND UPPER(t1.DESCC07) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j07s01.getDescc07().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j07s01.getDescc07().toUpperCase() + "%");
			}
			where.append(" AND t1.DESCC07 IS NOT NULL");
		}
		if (aa00j07s01 != null && aa00j07s01.getDesce07() != null
				&& aa00j07s01.getDesce07().length() > 0) {
			where.append(" AND UPPER(t1.DESCE07) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j07s01.getDesce07().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j07s01.getDesce07().toUpperCase() + "%");
			}
			where.append(" AND t1.DESCE07 IS NOT NULL");
		}
		if (aa00j07s01 != null && aa00j07s01.getSit07() != null) {
			where.append(" AND UPPER(t1.SIT07) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j07s01.getSit07().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j07s01.getSit07().toUpperCase() + "%");
			}
			where.append(" AND t1.SIT07 IS NOT NULL");
		}
		if (aa00j07s01 != null && aa00j07s01.getBloq07() != null) {
			where.append(" AND t1.BLOQ07 = ?");
			params.add(aa00j07s01.getBloq07());
		}
		if (aa00j07s01 != null && aa00j07s01.getUsub07() != null) {
			where.append(" AND UPPER(t1.USUB07) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j07s01.getUsub07().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j07s01.getUsub07().toUpperCase() + "%");
			}
			where.append(" AND t1.USUB07 IS NOT NULL");
		}
		if (aa00j07s01 != null && aa00j07s01.getCodxlnet07() != null) {
			where.append(" AND UPPER(t1.COD_XLNET_07) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j07s01.getCodxlnet07().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j07s01.getCodxlnet07().toUpperCase() + "%");
			}
			where.append(" AND t1.COD_XLNET_07 IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	public List<Aa00j07s01> obtenerCombo() {
		Aa00j07s01DaoImpl.logger.info("Método obtenerCombo");
		StringBuilder query = new StringBuilder(
				"SELECT t1.CDEP07 CDEP07,t1.DESCC07 DESCC07,NVL2(t1.DESCE07,t1.DESCE07,t1.DESCC07) DESCE07 ");
		query.append("FROM AA00J07S01 t1 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.SIT07=? ");
		query.append(where);

		List<Object> params = new ArrayList<Object>();
		params.add(aa00jConstantes.SITUACION_ALTA);
		Aa00j07s01DaoImpl.logger.info("SQL =" + query);
		Aa00j07s01DaoImpl.logger.info("PARMs= " + params);
		return (List<Aa00j07s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMapCombo, params.toArray());
	}

	/**
	 * Controla el usuario, si no es administrador ni tecnico solamente se el
	 * devuelve el suyo
	 * 
	 * @return
	 */
	public List<Aa00j07s01> obtenerComboControlado() {
		Aa00j07s01DaoImpl.logger.info("Método obtenerComboControlado");
		StringBuilder query = new StringBuilder(
				"SELECT t1.CDEP07 CDEP07,t1.DESCC07 DESCC07,NVL2(t1.DESCE07,t1.DESCE07,t1.DESCC07) DESCE07 ");
		query.append("FROM AA00J07S01 t1 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.SIT07=? ");
		List<Object> params = new ArrayList<Object>();
		params.add(aa00jConstantes.SITUACION_ALTA);
		// Iker-->Control del departamento por XLNETS
		// Si es tecnico o administrador se muestra todo
		aa00jPersonaSesion ps = new aa00jSeguridad().getUsuario();
		if (!ps.isEsTecnico() && !ps.isEsAdmin()) {
			// Solamente se muestra el departamento del usuario
			where.append(" AND t1.CDEP07=?");
			params.add(ps.getDepartamentoInterno());

		}
		where.append(" AND t1.CDEP07 in (select distinct(cdep10) from aa00j10s01 where cdep10 is not null)");
		query.append(where);
		Aa00j07s01DaoImpl.logger.info("SQL=" + query.toString());
		return (List<Aa00j07s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMapCombo, params.toArray());
	}

	public boolean existe(String descc07, Long codigoNoIncluir) {
		Aa00j07s01DaoImpl.logger.info("Método existe");
		if (codigoNoIncluir != null && codigoNoIncluir > 0) {
			String query = "SELECT COUNT(1) FROM AA00J07S01 WHERE UPPER(DESCC07) = UPPER(?) AND CDEP07 <> ?";
			return this.jdbcTemplate.queryForInt(query, descc07,
					codigoNoIncluir) > 0;
		} else {
			String query = "SELECT COUNT(1) FROM AA00J07S01 WHERE UPPER(DESCC07) = UPPER(?)";
			return this.jdbcTemplate.queryForInt(query, descc07) > 0;
		}
	}

	public List<Aa00j07s01> obtenerXlnet(String cod_xlnet_07) {
		Aa00j07s01DaoImpl.logger.info("Método obtenerXlnet");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CDEP07 CDEP07,t1.DESCC07 DESCC07,NVL2(t1.DESCE07,t1.DESCE07,t1.DESCC07) DESCE07,t1.SIT07 SIT07,t1.BLOQ07 BLOQ07,t1.USUB07 USUB07,t1.COD_XLNET_07 COD_XLNET_07 ");
		query.append("FROM AA00J07S01 t1 ");
		query.append("WHERE COD_XLNET_07=? ");

		List<Object> params = new ArrayList<Object>();
		params.add(cod_xlnet_07);
		Aa00j07s01DaoImpl.logger.info("SQL =" + query);
		Aa00j07s01DaoImpl.logger.info("PARMs= " + params);
		return (List<Aa00j07s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	public String obtenerCodigoXlnet(Long cdep07) {
		Aa00j07s01DaoImpl.logger.info("Método obtenerCodigoXlnet");
		StringBuilder query = new StringBuilder();
		query.append("SELECT COD_XLNET_07 FROM AA00J07S01 WHERE CDEP07=?");

		List<String> ret = this.jdbcTemplate.queryForList(query.toString(),
				String.class, cdep07);
		if (ret.isEmpty()) {
			return null;
		} else {
			return ret.get(0);
		}
	}

	public Long obtenerCodigoPorXlnet(String codDeptoXlnet) {
		Aa00j07s01DaoImpl.logger.info("Método obtenerCodigoPorXlnet");
		StringBuilder query = new StringBuilder();
		query.append("SELECT CDEP07 FROM AA00J07S01 WHERE COD_XLNET_07=?");

		Long ret = this.jdbcTemplate.queryForLong(query.toString(),
				codDeptoXlnet);
		if (ret == null) {
			return (long) -1;
		} else {
			return ret;
		}
	}

	/**
	 * Devuelve los edificios en los que hay salas que tienen que aparecer en un
	 * listado especial de edificios
	 * 
	 * @return
	 */
	public List<Option> obtenerComboListado() {
		Aa00j07s01DaoImpl.logger.info("Método obtenerComboListado");
		StringBuilder query = new StringBuilder();
		if (LocaleContextHolder.getLocale().getLanguage().contains("eu")) {
			query.append("SELECT 'D'||CDEP07 as value, NVL2(DESCE07,DESCE07,DESCC07) ||' saileko aretoak' as text ");
		} else {
			query.append("SELECT 'D'||CDEP07 as value, 'Salas del departamento '||DESCC07 as text ");
		}
		query.append(" FROM aa00j07S01");
		query.append(" WHERE CDEP07 IN");
		query.append(" (SELECT DISTINCT CDEP10 FROM aa00j10S01 WHERE infdep10=1 and  CDEP10 is not null)");
		query.append("  AND SIT07=? ");
		List<Object> params = new ArrayList<Object>();
		params.add(aa00jConstantes.SITUACION_ALTA);
		Aa00j07s01DaoImpl.logger.info("SQL =" + query);
		Aa00j07s01DaoImpl.logger.info("PARMs= " + params);
		return (List<Option>) this.jdbcTemplate.query(query.toString(),
				this.optionMap, params.toArray());
	}
}