package com.ejie.aa00j.dao;

import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa00j.classes.aa00jConstantes;
import com.ejie.aa00j.model.Aa00j06s01;

/**
 * Aa00j06s01DaoImpl generated by UDA, 16-oct-2013 13:02:12.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class Aa00j06s01DaoImpl implements Aa00j06s01Dao {
	private JdbcTemplate jdbcTemplate;
	private static final Logger logger = LoggerFactory
			.getLogger(Aa00j06s01DaoImpl.class);
	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Aa00j06s01> rwMap = new RowMapper<Aa00j06s01>() {
		public Aa00j06s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa00j06s01(resultSet.getLong("CREST06"),
					resultSet.getString("DESCC06"),
					resultSet.getString("DESCE06"),
					resultSet.getString("SIT06"), resultSet.getInt("BLOQ06"),
					resultSet.getString("MENC06"),
					resultSet.getString("MENE06"),
					resultSet.getString("USUB06"));
		}
	};

	private RowMapper<Aa00j06s01> rwMapPK = new RowMapper<Aa00j06s01>() {
		public Aa00j06s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa00j06s01(resultSet.getLong("CREST06"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Aa00j06s01>> rwMapJerarquia = new RowMapper<JerarquiaDto<Aa00j06s01>>() {
		public JerarquiaDto<Aa00j06s01> mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Aa00j06s01 aa00j06s01 = new Aa00j06s01(
					resultSet.getLong("CREST06"),
					resultSet.getString("DESCC06"),
					resultSet.getString("DESCE06"),
					resultSet.getString("SIT06"), resultSet.getInt("BLOQ06"),
					resultSet.getString("MENC06"),
					resultSet.getString("MENE06"),
					resultSet.getString("USUB06"));

			JerarquiaDto<Aa00j06s01> jerarquia = new JerarquiaDto<Aa00j06s01>();
			jerarquia.setModel(aa00j06s01);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet
					.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet
					.getString("FILTER")));
			return jerarquia;
		}
	};

	private RowMapper<Aa00j06s01> rwMapCombo = new RowMapper<Aa00j06s01>() {
		public Aa00j06s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa00j06s01(resultSet.getLong("CREST06"),
					resultSet.getString("DESCC06"),
					resultSet.getString("DESCE06"), "", 0, "", "", "");
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Aa00j06s01 table.
	 * 
	 * @param aa00j06s01
	 *            Aa00j06s01
	 * @return Aa00j06s01
	 */
	public Aa00j06s01 add(final Aa00j06s01 aa00j06s01) {
		Aa00j06s01DaoImpl.logger.info("Método add");
		final String queryUltimoId = "(SELECT NVL(MAX(TO_NUMBER(CREST06)), 0) + 1 FROM AA00J06S01)";
		final String query = "INSERT INTO AA00J06S01 (CREST06, DESCC06, DESCE06, SIT06, BLOQ06, MENC06, MENE06, USUB06) VALUES ("
				+ queryUltimoId + ",?,?,?,?,?,?,?)";
		Aa00j06s01DaoImpl.logger.info("SQL =" + query);
		Aa00j06s01DaoImpl.logger.info("PARM1 ="
				+ aa00j06s01.getDescc06().trim());
		Aa00j06s01DaoImpl.logger.info("PARM2 ="
				+ aa00j06s01.getDesce06().trim());
		Aa00j06s01DaoImpl.logger.info("PARM3 =" + aa00j06s01.getSit06());
		Aa00j06s01DaoImpl.logger.info("PARM4 =" + 0);
		Aa00j06s01DaoImpl.logger.info("PARM5 =" + aa00j06s01.getMenc06());
		Aa00j06s01DaoImpl.logger.info("PARM6 =" + aa00j06s01.getMene06());
		Aa00j06s01DaoImpl.logger.info("PARM7 = null");
		KeyHolder keyHolder = new GeneratedKeyHolder();
		jdbcTemplate.update(new PreparedStatementCreator() {
			public PreparedStatement createPreparedStatement(
					Connection connection) throws SQLException {
				PreparedStatement ps = connection.prepareStatement(query,
						new String[] { "CREST06" });
				ps.setObject(1, aa00j06s01.getDescc06().trim());
				ps.setObject(2, aa00j06s01.getDesce06().trim());
				ps.setObject(3, aa00j06s01.getSit06());
				ps.setObject(4, 0);
				ps.setObject(5, aa00j06s01.getMenc06());
				ps.setObject(6, aa00j06s01.getMene06());
				ps.setObject(7, null);
				return ps;
			}
		}, keyHolder);

		aa00j06s01.setCrest06(keyHolder.getKey().longValue());

		return aa00j06s01;
	}

	/**
	 * Updates a single row in the Aa00j06s01 table.
	 * 
	 * @param aa00j06s01
	 *            Aa00j06s01
	 * @return Aa00j06s01
	 */
	public Aa00j06s01 update(Aa00j06s01 aa00j06s01) {
		Aa00j06s01DaoImpl.logger.info("Método add");
		String query = "UPDATE AA00J06S01 SET DESCC06=?, DESCE06=?, SIT06=?, BLOQ06=?, MENC06=?, MENE06=?, USUB06=? WHERE CREST06=?";
		Aa00j06s01DaoImpl.logger.info("SQL =" + query);
		Aa00j06s01DaoImpl.logger.info("PARM1 ="
				+ aa00j06s01.getDescc06().trim());
		Aa00j06s01DaoImpl.logger.info("PARM2 ="
				+ aa00j06s01.getDesce06().trim());
		Aa00j06s01DaoImpl.logger.info("PARM3 =" + aa00j06s01.getSit06());
		Aa00j06s01DaoImpl.logger.info("PARM4 =" + aa00j06s01.getBloq06());
		Aa00j06s01DaoImpl.logger.info("PARM5 =" + aa00j06s01.getMenc06());
		Aa00j06s01DaoImpl.logger.info("PARM6 =" + aa00j06s01.getUsub06());
		Aa00j06s01DaoImpl.logger.info("PARM7 = " + aa00j06s01.getCrest06());
		this.jdbcTemplate.update(query, aa00j06s01.getDescc06(),
				aa00j06s01.getDesce06(), aa00j06s01.getSit06(),
				aa00j06s01.getBloq06(), aa00j06s01.getMenc06(),
				aa00j06s01.getMene06(), aa00j06s01.getUsub06(),
				aa00j06s01.getCrest06());
		return aa00j06s01;
	}

	/**
	 * Finds a single row in the Aa00j06s01 table.
	 * 
	 * @param aa00j06s01
	 *            Aa00j06s01
	 * @return Aa00j06s01
	 */
	@Transactional(readOnly = true)
	public Aa00j06s01 find(Aa00j06s01 aa00j06s01) {
		Aa00j06s01DaoImpl.logger.info("Método find");
		String query = "SELECT t1.CREST06 CREST06, t1.DESCC06 DESCC06, t1.DESCE06 DESCE06, t1.SIT06 SIT06, t1.BLOQ06 BLOQ06, t1.MENC06 MENC06, t1.MENE06 MENE06, t1.USUB06 USUB06 FROM AA00J06S01 t1  WHERE t1.CREST06 = ?  ";
		Aa00j06s01DaoImpl.logger.info("SQL =" + query);

		Aa00j06s01DaoImpl.logger.info("PARM1= " + aa00j06s01.getCrest06());
		List<Aa00j06s01> aa00j06s01List = this.jdbcTemplate.query(query,
				this.rwMap, aa00j06s01.getCrest06());
		return (Aa00j06s01) DataAccessUtils.uniqueResult(aa00j06s01List);
	}

	/**
	 * Removes a single row in the Aa00j06s01 table.
	 * 
	 * @param aa00j06s01
	 *            Aa00j06s01
	 * @return
	 */
	public void remove(Aa00j06s01 aa00j06s01) {
		Aa00j06s01DaoImpl.logger.info("Método remove");
		String query = "DELETE FROM AA00J06S01 WHERE CREST06=?";
		Aa00j06s01DaoImpl.logger.info("SQL =" + query);

		Aa00j06s01DaoImpl.logger.info("PARM1= " + aa00j06s01.getCrest06());
		this.jdbcTemplate.update(query, aa00j06s01.getCrest06());
	}

	/**
	 * Finds a list of rows in the Aa00j06s01 table.
	 * 
	 * @param aa00j06s01
	 *            Aa00j06s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa00j06s01>
	 */
	@Transactional(readOnly = true)
	public List<Aa00j06s01> findAll(Aa00j06s01 aa00j06s01,
			JQGridRequestDto jqGridRequestDto) {
		Aa00j06s01DaoImpl.logger.info("Método findAll");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CREST06 CREST06,t1.DESCC06 DESCC06,t1.DESCE06 DESCE06,t1.SIT06 SIT06,t1.BLOQ06 BLOQ06,t1.MENC06 MENC06,t1.MENE06 MENE06,t1.USUB06 USUB06 ");
		query.append("FROM AA00J06S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa00j06s01);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		Aa00j06s01DaoImpl.logger.info("SQL =" + query);
		Aa00j06s01DaoImpl.logger.info("PARMS= " + params);
		return (List<Aa00j06s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Aa00j06s01 table using like.
	 * 
	 * @param aa00j06s01
	 *            Aa00j06s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa00j06s01>
	 */
	@Transactional(readOnly = true)
	public List<Aa00j06s01> findAllLike(Aa00j06s01 aa00j06s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		Aa00j06s01DaoImpl.logger.info("Método findAllLike");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CREST06 CREST06,t1.DESCC06 DESCC06,t1.DESCE06 DESCE06,t1.SIT06 SIT06,t1.BLOQ06 BLOQ06,t1.MENC06 MENC06,t1.MENE06 MENE06,t1.USUB06 USUB06 ");
		query.append("FROM AA00J06S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa00j06s01, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		Aa00j06s01DaoImpl.logger.info("SQL =" + query);
		Aa00j06s01DaoImpl.logger.info("PARMS= " + params);
		return (List<Aa00j06s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Aa00j06s01 table.
	 * 
	 * @param aa00j06s01
	 *            Aa00j06s01
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Aa00j06s01 aa00j06s01) {
		Aa00j06s01DaoImpl.logger.info("Método findAllCount");
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA00J06S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa00j06s01);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j06s01DaoImpl.logger.info("SQL =" + query);
		Aa00j06s01DaoImpl.logger.info("PARMS= " + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Aa00j06s01 table using like.
	 * 
	 * @param aa00j06s01
	 *            Aa00j06s01
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Aa00j06s01 aa00j06s01, Boolean startsWith) {
		Aa00j06s01DaoImpl.logger.info("Método findAllLikeCount");
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA00J06S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa00j06s01, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j06s01DaoImpl.logger.info("SQL =" + query);
		Aa00j06s01DaoImpl.logger.info("PARMS= " + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Aa00j06s01 selected for rup_table
	 * 
	 * @param aa00j06s01
	 *            Aa00j06s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j06s01>>
	 */
	@Override
	public List<TableRowDto<Aa00j06s01>> reorderSelection(
			Aa00j06s01 aa00j06s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		Aa00j06s01DaoImpl.logger.info("Método reorderSelection");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CREST06 CREST06,t1.DESCC06 DESCC06,t1.DESCE06 DESCE06,t1.SIT06 SIT06,t1.BLOQ06 BLOQ06,t1.MENC06 MENC06,t1.MENE06 MENE06,t1.USUB06 USUB06 ");
		// FROM
		query.append("FROM AA00J06S01 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa00j06s01, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, Aa00j06s01.class, filterParamList,
				"CREST06");
		Aa00j06s01DaoImpl.logger.info("SQL =" + sbReorderSelectionSQL);
		Aa00j06s01DaoImpl.logger.info("PARMS= " + filterParamList);
		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa00j06s01>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * @param filterParams
	 *            Aa00j06s01
	 * @param searchParams
	 *            Aa00j06s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j06s01>>
	 */
	@Override
	public List<TableRowDto<Aa00j06s01>> search(Aa00j06s01 filterParams,
			Aa00j06s01 searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		Aa00j06s01DaoImpl.logger.info("Método search");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CREST06 CREST06,t1.DESCC06 DESCC06,t1.DESCE06 DESCE06,t1.SIT06 SIT06,t1.BLOQ06 BLOQ06,t1.MENC06 MENC06,t1.MENE06 MENE06,t1.USUB06 USUB06 ");
		// FROM
		query.append("FROM AA00J06S01 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, Aa00j06s01.class, filterParamList,
				searchSQL, searchParamList, from_alias, "CREST06");
		Aa00j06s01DaoImpl.logger.info("SQL =" + sbReorderSelectionSQL);
		Aa00j06s01DaoImpl.logger.info("PARMS= " + filterParamList);
		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa00j06s01>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 * 
	 * @param filteraa00j06s01
	 *            Aa00j06s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Aa00j06s01 filteraa00j06s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		Aa00j06s01DaoImpl.logger.info("Método removeMultiple");
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.CREST06 CREST06,t1.DESCC06 DESCC06,t1.DESCE06 DESCE06,t1.SIT06 SIT06,t1.BLOQ06 BLOQ06,t1.MENC06 MENC06,t1.MENE06 MENE06,t1.USUB06 USUB06 ");
		// FROM
		query.append("FROM AA00J06S01 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filteraa00j06s01,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto, Aa00j06s01.class,
						query, params, "CREST06");
		Aa00j06s01DaoImpl.logger.info("SQL =" + sbRemoveMultipleSQL);
		Aa00j06s01DaoImpl.logger.info("PARMS= " + params);
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical Aa00j06s01 table.
	 * 
	 * @param filterAa00j06s01
	 *            Aa00j06s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Aa00j06s01>>
	 */
	@Override
	public List<JerarquiaDto<Aa00j06s01>> findAllLikeJerarquia(
			Aa00j06s01 filterAa00j06s01, JQGridRequestDto jqGridRequestDto) {
		Aa00j06s01DaoImpl.logger.info("Método findAllLikeJerarquia");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CREST06 CREST06,t1.DESCC06 DESCC06,t1.DESCE06 DESCE06,t1.SIT06 SIT06,t1.BLOQ06 BLOQ06,t1.MENC06 MENC06,t1.MENE06 MENE06,t1.USUB06 USUB06 ");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA00J06S01 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA00J06S01");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa00j06s01, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
				mapaWhere, "CREST06", "ID_PADRE", "NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j06s01DaoImpl.logger.info("SQL =" + query);
		Aa00j06s01DaoImpl.logger.info("PARMS= " + params);
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAa00j06s01
	 *            Aa00j06s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Aa00j06s01 filterAa00j06s01,
			JQGridRequestDto jqGridRequestDto) {
		Aa00j06s01DaoImpl.logger.info("Método findAllLikeCountJerarquia");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA00J06S01 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA00J06S01");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa00j06s01, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(
				jqGridRequestDto, mapaWhere, "CREST06", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j06s01DaoImpl.logger.info("SQL =" + query);
		Aa00j06s01DaoImpl.logger.info("PARMS= " + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAa00j06s01
	 *            Aa00j06s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Aa00j06s01>>
	 */
	@Override
	public List<TableRowDto<Aa00j06s01>> findAllChild(
			Aa00j06s01 filterAa00j06s01, JQGridRequestDto jqGridRequestDto) {
		Aa00j06s01DaoImpl.logger.info("Método findAllChild");

		// FROM
		// StringBuilder from = new StringBuilder("FROM AA00J06S01 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA00J06S01");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa00j06s01, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(
				jqGridRequestDto, mapaWhere, "CREST06", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j06s01DaoImpl.logger.info("SQL =" + query);
		Aa00j06s01DaoImpl.logger.info("PARMS= " + params);
		return this.jdbcTemplate.query(query.toString(),
				new RowNumResultSetExtractor<Aa00j06s01>(this.rwMapPK,
						"CREST06"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa00j06s01 entity
	 * 
	 * @param aa00j06s01
	 *            Aa00j06s01 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Aa00j06s01 aa00j06s01) {

		StringBuilder where = new StringBuilder(
				Aa00j06s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa00j06s01 != null && aa00j06s01.getCrest06() != null) {
			where.append(" AND t1.CREST06 = ?");
			params.add(aa00j06s01.getCrest06());
		}
		if (aa00j06s01 != null && aa00j06s01.getDescc06() != null) {
			where.append(" AND t1.DESCC06 = ?");
			params.add(aa00j06s01.getDescc06());
		}
		if (aa00j06s01 != null && aa00j06s01.getDesce06() != null) {
			where.append(" AND t1.DESCE06 = ?");
			params.add(aa00j06s01.getDesce06());
		}
		if (aa00j06s01 != null && aa00j06s01.getSit06() != null) {
			where.append(" AND t1.SIT06 = ?");
			params.add(aa00j06s01.getSit06());
		}
		if (aa00j06s01 != null && aa00j06s01.getBloq06() != null) {
			where.append(" AND t1.BLOQ06 = ?");
			params.add(aa00j06s01.getBloq06());
		}
		if (aa00j06s01 != null && aa00j06s01.getMenc06() != null) {
			where.append(" AND t1.MENC06 = ?");
			params.add(aa00j06s01.getMenc06());
		}
		if (aa00j06s01 != null && aa00j06s01.getMene06() != null) {
			where.append(" AND t1.MENE06 = ?");
			params.add(aa00j06s01.getMene06());
		}
		if (aa00j06s01 != null && aa00j06s01.getUsub06() != null) {
			where.append(" AND t1.USUB06 = ?");
			params.add(aa00j06s01.getUsub06());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa00j06s01 entity
	 * 
	 * @param aa00j06s01
	 *            Aa00j06s01 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Aa00j06s01 aa00j06s01,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				Aa00j06s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa00j06s01 != null && aa00j06s01.getCrest06() != null) {
			where.append(" AND t1.CREST06 = ?");
			params.add(aa00j06s01.getCrest06());
		}
		if (aa00j06s01 != null && aa00j06s01.getDescc06() != null) {
			where.append(" AND UPPER(t1.DESCC06) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j06s01.getDescc06().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j06s01.getDescc06().toUpperCase() + "%");
			}
			where.append(" AND t1.DESCC06 IS NOT NULL");
		}
		if (aa00j06s01 != null && aa00j06s01.getDesce06() != null) {
			where.append(" AND UPPER(t1.DESCE06) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j06s01.getDesce06().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j06s01.getDesce06().toUpperCase() + "%");
			}
			where.append(" AND t1.DESCE06 IS NOT NULL");
		}
		if (aa00j06s01 != null && aa00j06s01.getSit06() != null) {
			where.append(" AND UPPER(t1.SIT06) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j06s01.getSit06().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j06s01.getSit06().toUpperCase() + "%");
			}
			where.append(" AND t1.SIT06 IS NOT NULL");
		}
		if (aa00j06s01 != null && aa00j06s01.getBloq06() != null) {
			where.append(" AND t1.BLOQ06 = ?");
			params.add(aa00j06s01.getBloq06());
		}
		if (aa00j06s01 != null && aa00j06s01.getMenc06() != null) {
			where.append(" AND UPPER(t1.MENC06) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j06s01.getMenc06().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j06s01.getMenc06().toUpperCase() + "%");
			}
			where.append(" AND t1.MENC06 IS NOT NULL");
		}
		if (aa00j06s01 != null && aa00j06s01.getMene06() != null) {
			where.append(" AND UPPER(t1.MENE06) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j06s01.getMene06().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j06s01.getMene06().toUpperCase() + "%");
			}
			where.append(" AND t1.MENE06 IS NOT NULL");
		}
		if (aa00j06s01 != null && aa00j06s01.getUsub06() != null) {
			where.append(" AND UPPER(t1.USUB06) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j06s01.getUsub06().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j06s01.getUsub06().toUpperCase() + "%");
			}
			where.append(" AND t1.USUB06 IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	public Aa00j06s01 anyadir(String descripcionEs, String descripcionEu,
			String mensajeEs, String mensajeEu) {
		Aa00j06s01DaoImpl.logger.info("Método anyadir");
		Aa00j06s01 aa00j06s01 = new Aa00j06s01(null, descripcionEs,
				descripcionEu, aa00jConstantes.SITUACION_ALTA, 0, mensajeEs,
				mensajeEu, null);
		return this.add(aa00j06s01);
	}

	public List<Aa00j06s01> obtenerCombo() {
		Aa00j06s01DaoImpl.logger.info("Método obtenerCombo");
		StringBuilder query = new StringBuilder(
				"SELECT t1.CREST06 CREST06,t1.DESCC06 DESCC06,t1.DESCE06 DESCE06 ");
		query.append("FROM AA00J06S01 t1 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.SIT06=? ");
		query.append(where);

		List<Object> params = new ArrayList<Object>();
		params.add(aa00jConstantes.SITUACION_ALTA);
		Aa00j06s01DaoImpl.logger.info("SQL =" + query);
		Aa00j06s01DaoImpl.logger.info("PARMS= " + params);
		return (List<Aa00j06s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMapCombo, params.toArray());
	}

	public boolean existe(String descripcionEs, Long codigoNoIncluir) {
		Aa00j06s01DaoImpl.logger.info("Método existe");
		if (codigoNoIncluir != null && codigoNoIncluir > 0) {
			String query = "SELECT COUNT(1) FROM AA00J06S01 WHERE UPPER(DESCC06) = UPPER(?) AND CREST06 <> ?";
			Aa00j06s01DaoImpl.logger.info("SQL =" + query);
			Aa00j06s01DaoImpl.logger.info("PARM1= " + descripcionEs);
			Aa00j06s01DaoImpl.logger.info("PARM2= " + codigoNoIncluir);
			return this.jdbcTemplate.queryForInt(query, descripcionEs,
					codigoNoIncluir) > 0;
		} else {
			String query = "SELECT COUNT(1) FROM AA00J06S01 WHERE UPPER(DESCC06) = UPPER(?)";
			Aa00j06s01DaoImpl.logger.info("SQL =" + query);
			Aa00j06s01DaoImpl.logger.info("PARMS= " + descripcionEs);
			return this.jdbcTemplate.queryForInt(query, descripcionEs) > 0;
		}
	}
}