package com.ejie.aa00j.dao;

import com.ejie.aa00j.classes.aa00jConstantes;
import com.ejie.aa00j.model.Aa00j03s01;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.dto.PaginationManager;
import com.ejie.x38.dto.TableRowDto;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa00j.model.Aa00j05s01;

/**
 * Aa00j05s01DaoImpl generated by UDA, 16-oct-2013 13:02:12.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class Aa00j05s01DaoImpl implements Aa00j05s01Dao {
	private JdbcTemplate jdbcTemplate;
	private static final Logger logger = LoggerFactory
			.getLogger(Aa00j05s01DaoImpl.class);
	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Aa00j05s01> rwMap = new RowMapper<Aa00j05s01>() {
		public Aa00j05s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa00j05s01(resultSet.getString("CRESP05"),
					resultSet.getString("NOM05"), resultSet.getString("SIT05"),
					resultSet.getInt("BLOQ05"), resultSet.getString("USUB05"));
		}
	};

	private RowMapper<Aa00j05s01> rwMapPK = new RowMapper<Aa00j05s01>() {
		public Aa00j05s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa00j05s01(resultSet.getString("CRESP05"));
		}
	};

	private RowMapper<Aa00j05s01> rwMapCombo = new RowMapper<Aa00j05s01>() {
		public Aa00j05s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa00j05s01(resultSet.getString("CRESP05"),
					resultSet.getString("NOM05"), "", 0, "");
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Aa00j05s01>> rwMapJerarquia = new RowMapper<JerarquiaDto<Aa00j05s01>>() {
		public JerarquiaDto<Aa00j05s01> mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Aa00j05s01 aa00j05s01 = new Aa00j05s01(
					resultSet.getString("CRESP05"),
					resultSet.getString("NOM05"), resultSet.getString("SIT05"),
					resultSet.getInt("BLOQ05"), resultSet.getString("USUB05"));

			JerarquiaDto<Aa00j05s01> jerarquia = new JerarquiaDto<Aa00j05s01>();
			jerarquia.setModel(aa00j05s01);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet
					.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet
					.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Aa00j05s01 table.
	 * 
	 * @param aa00j05s01
	 *            Aa00j05s01
	 * @return Aa00j05s01
	 */
	public Aa00j05s01 add(final Aa00j05s01 aa00j05s01) {
		if (aa00j05s01.getSit05() == null
				|| aa00j05s01.getSit05().length() == 0)
			aa00j05s01.setSit05(aa00jConstantes.SITUACION_ALTA);
		Aa00j05s01DaoImpl.logger.info("Método add");
		final String query = "INSERT INTO AA00J05S01 (CRESP05, NOM05, SIT05, BLOQ05, USUB05) VALUES ("
				+ "?,?,?,?,?)";
		Aa00j05s01DaoImpl.logger.info("SQL " + query);
		Aa00j05s01DaoImpl.logger.info("PARAM1 ="
				+ aa00j05s01.getCresp05().trim().toUpperCase());
		Aa00j05s01DaoImpl.logger
				.info("PARAM2 =" + aa00j05s01.getNom05().trim());
		Aa00j05s01DaoImpl.logger.info("PARAM3 =" + aa00j05s01.getSit05());
		Aa00j05s01DaoImpl.logger.info("PARAM4 =" + 0);
		Aa00j05s01DaoImpl.logger.info("PARAM5 =null");
		KeyHolder keyHolder = new GeneratedKeyHolder();
		jdbcTemplate.update(new PreparedStatementCreator() {
			public PreparedStatement createPreparedStatement(
					Connection connection) throws SQLException {
				PreparedStatement ps = connection.prepareStatement(query,
						new String[] { "CRESP05" });
				ps.setObject(1, aa00j05s01.getCresp05().trim().toUpperCase());
				ps.setObject(2, aa00j05s01.getNom05().trim());
				ps.setObject(3, aa00j05s01.getSit05());
				ps.setObject(4, 0);
				ps.setObject(5, null);
				return ps;
			}
		}, keyHolder);

		aa00j05s01.setCresp05(keyHolder.getKeys().get("CRESP05") + "");

		return aa00j05s01;
	}

	/**
	 * Updates a single row in the Aa00j05s01 table.
	 * 
	 * @param aa00j05s01
	 *            Aa00j05s01
	 * @return Aa00j05s01
	 */
	public Aa00j05s01 update(Aa00j05s01 aa00j05s01) {
		if (aa00j05s01.getSit05() == null
				|| aa00j05s01.getSit05().length() == 0)
			aa00j05s01.setSit05(aa00jConstantes.SITUACION_ALTA);
		Aa00j05s01DaoImpl.logger.info("Método update");
		String query = "UPDATE AA00J05S01 SET NOM05=?, SIT05=?, BLOQ05=?, USUB05=? WHERE CRESP05=?";
		Aa00j05s01DaoImpl.logger.info("SQL " + query);
		Aa00j05s01DaoImpl.logger.info("PARAM1 =" + aa00j05s01.getNom05());
		Aa00j05s01DaoImpl.logger.info("PARAM2 =" + aa00j05s01.getSit05());
		Aa00j05s01DaoImpl.logger.info("PARAM3 =" + aa00j05s01.getBloq05());
		Aa00j05s01DaoImpl.logger.info("PARAM4 =" + aa00j05s01.getUsub05());
		Aa00j05s01DaoImpl.logger.info("PARAM5 =" + aa00j05s01.getCresp05());
		this.jdbcTemplate.update(query, aa00j05s01.getNom05(),
				aa00j05s01.getSit05(), aa00j05s01.getBloq05(),
				aa00j05s01.getUsub05(), aa00j05s01.getCresp05());
		return aa00j05s01;
	}

	/**
	 * Finds a single row in the Aa00j05s01 table.
	 * 
	 * @param aa00j05s01
	 *            Aa00j05s01
	 * @return Aa00j05s01
	 */
	@Transactional(readOnly = true)
	public Aa00j05s01 find(Aa00j05s01 aa00j05s01) {
		Aa00j05s01DaoImpl.logger.info("Método find");
		String query = "SELECT t1.CRESP05 CRESP05, t1.NOM05 NOM05, t1.SIT05 SIT05, t1.BLOQ05 BLOQ05, t1.USUB05 USUB05 FROM AA00J05S01 t1  WHERE t1.CRESP05 = ?  ";
		Aa00j05s01DaoImpl.logger.info("SQL " + query);
		Aa00j05s01DaoImpl.logger.info("PARAM1 =" + aa00j05s01.getCresp05());
		List<Aa00j05s01> aa00j05s01List = this.jdbcTemplate.query(query,
				this.rwMap, aa00j05s01.getCresp05());
		return (Aa00j05s01) DataAccessUtils.uniqueResult(aa00j05s01List);
	}

	/**
	 * Removes a single row in the Aa00j05s01 table.
	 * 
	 * @param aa00j05s01
	 *            Aa00j05s01
	 * @return
	 */
	public void remove(Aa00j05s01 aa00j05s01) {
		Aa00j05s01DaoImpl.logger.info("Método remove");
		String query = "DELETE FROM AA00J05S01 WHERE CRESP05=?";
		Aa00j05s01DaoImpl.logger.info("SQL " + query);
		Aa00j05s01DaoImpl.logger.info("PARAM1 =" + aa00j05s01.getCresp05());
		this.jdbcTemplate.update(query, aa00j05s01.getCresp05());
	}

	/**
	 * Finds a list of rows in the Aa00j05s01 table.
	 * 
	 * @param aa00j05s01
	 *            Aa00j05s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa00j05s01>
	 */
	@Transactional(readOnly = true)
	public List<Aa00j05s01> findAll(Aa00j05s01 aa00j05s01,
			JQGridRequestDto jqGridRequestDto) {
		Aa00j05s01DaoImpl.logger.info("Método findAll");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CRESP05 CRESP05,t1.NOM05 NOM05,t1.SIT05 SIT05,t1.BLOQ05 BLOQ05,t1.USUB05 USUB05 ");
		query.append("FROM AA00J05S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa00j05s01);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		Aa00j05s01DaoImpl.logger.info("SQL " + query);
		Aa00j05s01DaoImpl.logger.info("PARAMS =" + params);

		return (List<Aa00j05s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Aa00j05s01 table using like.
	 * 
	 * @param aa00j05s01
	 *            Aa00j05s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa00j05s01>
	 */
	@Transactional(readOnly = true)
	public List<Aa00j05s01> findAllLike(Aa00j05s01 aa00j05s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		Aa00j05s01DaoImpl.logger.info("Método findAllLike");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CRESP05 CRESP05,t1.NOM05 NOM05,t1.SIT05 SIT05,t1.BLOQ05 BLOQ05,t1.USUB05 USUB05 ");
		query.append("FROM AA00J05S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa00j05s01, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		Aa00j05s01DaoImpl.logger.info("SQL " + query);
		Aa00j05s01DaoImpl.logger.info("PARAMS =" + params);
		return (List<Aa00j05s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Aa00j05s01 table.
	 * 
	 * @param aa00j05s01
	 *            Aa00j05s01
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Aa00j05s01 aa00j05s01) {
		Aa00j05s01DaoImpl.logger.info("Método findAllCount");
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA00J05S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa00j05s01);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j05s01DaoImpl.logger.info("SQL " + query);
		Aa00j05s01DaoImpl.logger.info("PARAMS =" + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Aa00j05s01 table using like.
	 * 
	 * @param aa00j05s01
	 *            Aa00j05s01
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Aa00j05s01 aa00j05s01, Boolean startsWith) {
		Aa00j05s01DaoImpl.logger.info("Método findAllLikeCount");
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA00J05S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa00j05s01, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j05s01DaoImpl.logger.info("SQL " + query);
		Aa00j05s01DaoImpl.logger.info("PARAMS =" + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Aa00j05s01 selected for rup_table
	 * 
	 * @param aa00j05s01
	 *            Aa00j05s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j05s01>>
	 */
	@Override
	public List<TableRowDto<Aa00j05s01>> reorderSelection(
			Aa00j05s01 aa00j05s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		Aa00j05s01DaoImpl.logger.info("Método reorderSelection");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CRESP05 CRESP05,t1.NOM05 NOM05,t1.SIT05 SIT05,t1.BLOQ05 BLOQ05,t1.USUB05 USUB05 ");
		// FROM
		query.append("FROM AA00J05S01 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa00j05s01, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, Aa00j05s01.class, filterParamList,
				"CRESP05");
		Aa00j05s01DaoImpl.logger.info("SQL " + sbReorderSelectionSQL);
		Aa00j05s01DaoImpl.logger.info("PARAMS =" + filterParamList);
		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa00j05s01>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * @param filterParams
	 *            Aa00j05s01
	 * @param searchParams
	 *            Aa00j05s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j05s01>>
	 */
	@Override
	public List<TableRowDto<Aa00j05s01>> search(Aa00j05s01 filterParams,
			Aa00j05s01 searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		Aa00j05s01DaoImpl.logger.info("Método search");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CRESP05 CRESP05,t1.NOM05 NOM05,t1.SIT05 SIT05,t1.BLOQ05 BLOQ05,t1.USUB05 USUB05 ");
		// FROM
		query.append("FROM AA00J05S01 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, Aa00j05s01.class, filterParamList,
				searchSQL, searchParamList, from_alias, "CRESP05");
		Aa00j05s01DaoImpl.logger.info("SQL " + sbReorderSelectionSQL);
		Aa00j05s01DaoImpl.logger.info("PARAMS =" + filterParamList);
		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa00j05s01>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 * 
	 * @param filteraa00j05s01
	 *            Aa00j05s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Aa00j05s01 filteraa00j05s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		Aa00j05s01DaoImpl.logger.info("Método removeMultiple");
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.CRESP05 CRESP05,t1.NOM05 NOM05,t1.SIT05 SIT05,t1.BLOQ05 BLOQ05,t1.USUB05 USUB05 ");
		// FROM
		query.append("FROM AA00J05S01 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filteraa00j05s01,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto, Aa00j05s01.class,
						query, params, "CRESP05");
		Aa00j05s01DaoImpl.logger.info("SQL " + sbRemoveMultipleSQL);
		Aa00j05s01DaoImpl.logger.info("PARAMS =" + params);
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical Aa00j05s01 table.
	 * 
	 * @param filterAa00j05s01
	 *            Aa00j05s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Aa00j05s01>>
	 */
	@Override
	public List<JerarquiaDto<Aa00j05s01>> findAllLikeJerarquia(
			Aa00j05s01 filterAa00j05s01, JQGridRequestDto jqGridRequestDto) {
		Aa00j05s01DaoImpl.logger.info("Método findAllLikeJerarquia");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CRESP05 CRESP05,t1.NOM05 NOM05,t1.SIT05 SIT05,t1.BLOQ05 BLOQ05,t1.USUB05 USUB05 ");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA00J05S01 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA00J05S01");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa00j05s01, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
				mapaWhere, "CRESP05", "ID_PADRE", "NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j05s01DaoImpl.logger.info("SQL " + query);
		Aa00j05s01DaoImpl.logger.info("PARAMS =" + params);
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAa00j05s01
	 *            Aa00j05s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Aa00j05s01 filterAa00j05s01,
			JQGridRequestDto jqGridRequestDto) {
		Aa00j05s01DaoImpl.logger.info("Método findAllLikeCountJerarquia");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA00J05S01 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA00J05S01");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa00j05s01, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(
				jqGridRequestDto, mapaWhere, "CRESP05", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j05s01DaoImpl.logger.info("SQL " + query);
		Aa00j05s01DaoImpl.logger.info("PARAMS =" + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAa00j05s01
	 *            Aa00j05s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Aa00j05s01>>
	 */
	@Override
	public List<TableRowDto<Aa00j05s01>> findAllChild(
			Aa00j05s01 filterAa00j05s01, JQGridRequestDto jqGridRequestDto) {
		Aa00j05s01DaoImpl.logger.info("Método findAllChild");

		// FROM
		// StringBuilder from = new StringBuilder("FROM AA00J05S01 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA00J05S01");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa00j05s01, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(
				jqGridRequestDto, mapaWhere, "CRESP05", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j05s01DaoImpl.logger.info("SQL " + query);
		Aa00j05s01DaoImpl.logger.info("PARAMS =" + params);
		return this.jdbcTemplate.query(query.toString(),
				new RowNumResultSetExtractor<Aa00j05s01>(this.rwMapPK,
						"CRESP05"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa00j05s01 entity
	 * 
	 * @param aa00j05s01
	 *            Aa00j05s01 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Aa00j05s01 aa00j05s01) {

		StringBuilder where = new StringBuilder(
				Aa00j05s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa00j05s01 != null && aa00j05s01.getCresp05() != null) {
			where.append(" AND t1.CRESP05 = ?");
			params.add(aa00j05s01.getCresp05());
		}
		if (aa00j05s01 != null && aa00j05s01.getNom05() != null) {
			where.append(" AND t1.NOM05 = ?");
			params.add(aa00j05s01.getNom05());
		}
		if (aa00j05s01 != null && aa00j05s01.getSit05() != null) {
			where.append(" AND t1.SIT05 = ?");
			params.add(aa00j05s01.getSit05());
		}
		if (aa00j05s01 != null && aa00j05s01.getBloq05() != null) {
			where.append(" AND t1.BLOQ05 = ?");
			params.add(aa00j05s01.getBloq05());
		}
		if (aa00j05s01 != null && aa00j05s01.getUsub05() != null) {
			where.append(" AND t1.USUB05 = ?");
			params.add(aa00j05s01.getUsub05());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa00j05s01 entity
	 * 
	 * @param aa00j05s01
	 *            Aa00j05s01 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Aa00j05s01 aa00j05s01,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				Aa00j05s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa00j05s01 != null && aa00j05s01.getCresp05() != null) {
			where.append(" AND UPPER(t1.CRESP05) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j05s01.getCresp05().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j05s01.getCresp05().toUpperCase() + "%");
			}
			where.append(" AND t1.CRESP05 IS NOT NULL");
		}
		if (aa00j05s01 != null && aa00j05s01.getNom05() != null) {
			where.append(" AND UPPER(t1.NOM05) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j05s01.getNom05().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j05s01.getNom05().toUpperCase() + "%");
			}
			where.append(" AND t1.NOM05 IS NOT NULL");
		}
		if (aa00j05s01 != null && aa00j05s01.getSit05() != null) {
			where.append(" AND UPPER(t1.SIT05) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j05s01.getSit05().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j05s01.getSit05().toUpperCase() + "%");
			}
			where.append(" AND t1.SIT05 IS NOT NULL");
		}
		if (aa00j05s01 != null && aa00j05s01.getBloq05() != null) {
			where.append(" AND t1.BLOQ05 = ?");
			params.add(aa00j05s01.getBloq05());
		}
		if (aa00j05s01 != null && aa00j05s01.getUsub05() != null) {
			where.append(" AND UPPER(t1.USUB05) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j05s01.getUsub05().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j05s01.getUsub05().toUpperCase() + "%");
			}
			where.append(" AND t1.USUB05 IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Inserts a single row in the Aa00j09s01 table.
	 * 
	 * @param aa00j05s01
	 *            Aa00j05s01
	 * @return Aa00j05s01
	 */
	public Aa00j05s01 addAa00j09s01(Aa00j05s01 aa00j05s01) {
		String query = "INSERT INTO AA00J09S01 " + "( CRESP09,CEDIF09) "
				+ " values (?, ?)";

		List<Aa00j03s01> auxiliarAa00j03s01 = aa00j05s01.getAa00j03s01s();
		Iterator<Aa00j03s01> it = auxiliarAa00j03s01.iterator();
		while (it.hasNext()) {
			Aa00j03s01 aa00j03s01 = (Aa00j03s01) it.next();
			this.jdbcTemplate.update(query, aa00j05s01.getCresp05(),
					aa00j03s01.getCedif03());
		}
		return aa00j05s01;
	}

	/**
	 * Deletes a single row in the Aa00j09s01 table.
	 * 
	 * @param aa00j05s01
	 *            Aa00j05s01
	 * @return
	 */
	public void removeAa00j09s01(Aa00j05s01 aa00j05s01) {
		String query = "DELETE  FROM AA00J09S01 "
				+ " WHERE CRESP09=? AND CEDIF09=?";
		List<Aa00j03s01> auxiliarAa00j03s01 = aa00j05s01.getAa00j03s01s();
		Iterator<Aa00j03s01> it = auxiliarAa00j03s01.iterator();
		while (it.hasNext()) {
			Aa00j03s01 aa00j03s01 = (Aa00j03s01) it.next();
			Aa00j05s01DaoImpl.logger.info("SQL " + query);
			Aa00j05s01DaoImpl.logger.info("PARAM1 =" + aa00j05s01.getCresp05());
			Aa00j05s01DaoImpl.logger.info("PARAM2 =" + aa00j03s01.getCedif03());
			this.jdbcTemplate.update(query, aa00j05s01.getCresp05(),
					aa00j03s01.getCedif03());
		}
	}

	public void removeAa00j09s01(int cedif09) {
		String query = "DELETE  FROM AA00J09S01 " + " WHERE CEDIF09=?";
		Aa00j05s01DaoImpl.logger.info("SQL " + query);

		Aa00j05s01DaoImpl.logger.info("PARAM2 =" + cedif09);
		this.jdbcTemplate.update(query, cedif09);
	}

	/**
	 * Find a single row in the findAa00j09s01 Many To Many relationship.
	 * 
	 * @param aa00j05s01
	 *            Aa00j05s01
	 * @param aa00j03s01
	 *            Aa00j03s01
	 * @param pagination
	 *            Pagination
	 * @return Aa00j05s01
	 */
	@Transactional(readOnly = true)
	public Aa00j05s01 findAa00j09s01(Aa00j05s01 aa00j05s01,
			Aa00j03s01 aa00j03s01, Pagination pagination) {
		Aa00j05s01DaoImpl.logger.info("Método findAa00j09s01");
		StringBuilder where = new StringBuilder(
				Aa00j05s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		where.append("where t1.CEDIF09 = t2.CEDIF03 AND t1.CRESP09=?");

		params.add(aa00j05s01.getCresp05());

		if (aa00j03s01.getCedif03() != null) {
			where.append(" AND t2.CEDIF03 = ?");
			params.add(aa00j03s01.getCedif03());
		}
		if (aa00j03s01.getAa00j02s01() != null) {
			where.append(" AND t2.CSITIO03 = ?");
			params.add(aa00j03s01.getAa00j02s01());
		}
		if (aa00j03s01.getNombre03() != null) {
			where.append(" AND t2.NOMBRE03 = ?");
			params.add(aa00j03s01.getNombre03());
		}
		if (aa00j03s01.getSit03() != null) {
			where.append(" AND t2.SIT03 = ?");
			params.add(aa00j03s01.getSit03());
		}
		if (aa00j03s01.getBloq03() != null) {
			where.append(" AND t2.BLOQ03 = ?");
			params.add(aa00j03s01.getBloq03());
		}
		if (aa00j03s01.getTlfno03() != null) {
			where.append(" AND t2.TLFNO03 = ?");
			params.add(aa00j03s01.getTlfno03());
		}
		if (aa00j03s01.getUsub03() != null) {
			where.append(" AND t2.USUB03 = ?");
			params.add(aa00j03s01.getUsub03());
		}

		StringBuilder query = new StringBuilder(
				"SELECT t2.Cedif03 CEDIF03, t2.NOMBRE03 NOMBRE03, t2.SIT03 SIT03, t2.BLOQ03 BLOQ03, t2.TLFNO03 TLFNO03, t2.USUB03 USUB03 FROM Aa00j09S01 t1,AA00J03S01 t2  ");
		query.append(where);

		StringBuilder order = new StringBuilder(
				Aa00j05s01DaoImpl.STRING_BUILDER_INIT);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" order by " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuilder(PaginationManager.getPaginationQuery(
					pagination, query));
		}
		Aa00j05s01DaoImpl.logger.info("SQL " + query);

		Aa00j05s01DaoImpl.logger.info("PARAMs =" + params);
		List<Aa00j03s01> listaHijo = this.jdbcTemplate.query(query.toString(),
				new RowMapper<Aa00j03s01>() {
					public Aa00j03s01 mapRow(ResultSet resultSet, int rowNum)
							throws SQLException {
						return new Aa00j03s01(resultSet.getLong("CEDIF03"),
								resultSet.getString("NOMBRE03"), resultSet
										.getString("SIT03"), resultSet
										.getInt("BLOQ03"), resultSet
										.getString("TLFNO03"), resultSet
										.getString("USUB03"), null, null, null,
								null);
					}
				}, params.toArray());
		aa00j05s01.setAa00j03s01s(listaHijo);
		return aa00j05s01;
	}

	/**
	 * Counts rows in the Aa00j09s01 table.
	 * 
	 * @param aa00j05s01
	 *            Aa00j05s01
	 * @param aa00j03s01
	 *            Aa00j03s01
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAa00j09s01Count(Aa00j05s01 aa00j05s01, Aa00j03s01 aa00j03s01) {
		Aa00j05s01DaoImpl.logger.info("Método findAa00j09s01Count");
		StringBuilder where = new StringBuilder(
				Aa00j05s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();
		where.append("where t1.CEDIF09 = t2.CEDIF03 AND t1.CRESP09=?");

		params.add(aa00j05s01.getCresp05());

		if (aa00j03s01.getCedif03() != null) {
			where.append(" AND t2.CEDIF03 = ?");
			params.add(aa00j03s01.getCedif03());
		}
		if (aa00j03s01.getAa00j02s01() != null) {
			where.append(" AND t2.CSITIO03 = ?");
			params.add(aa00j03s01.getAa00j02s01());
		}
		if (aa00j03s01.getNombre03() != null) {
			where.append(" AND t2.NOMBRE03 = ?");
			params.add(aa00j03s01.getNombre03());
		}
		if (aa00j03s01.getSit03() != null) {
			where.append(" AND t2.SIT03 = ?");
			params.add(aa00j03s01.getSit03());
		}
		if (aa00j03s01.getBloq03() != null) {
			where.append(" AND t2.BLOQ03 = ?");
			params.add(aa00j03s01.getBloq03());
		}
		if (aa00j03s01.getTlfno03() != null) {
			where.append(" AND t2.TLFNO03 = ?");
			params.add(aa00j03s01.getTlfno03());
		}
		if (aa00j03s01.getUsub03() != null) {
			where.append(" AND t2.USUB03 = ?");
			params.add(aa00j03s01.getUsub03());
		}

		StringBuilder query = new StringBuilder(
				"SELECT count(1) FROM Aa00j09S01 t1,AA00J03S01 t2  ");
		query.append(where);
		Aa00j05s01DaoImpl.logger.info("SQL " + query);

		Aa00j05s01DaoImpl.logger.info("PARAMs =" + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	public List<Aa00j05s01> obtenerCombo() {
		Aa00j05s01DaoImpl.logger.info("Método obtenerCombo");
		StringBuilder query = new StringBuilder(
				"SELECT t1.CRESP05 CRESP05,t1.NOM05 NOM05 ");
		query.append("FROM AA00J05S01 t1 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.SIT05=? ");
		query.append(where);

		List<Object> params = new ArrayList<Object>();
		params.add(aa00jConstantes.SITUACION_ALTA);
		Aa00j05s01DaoImpl.logger.info("SQL " + query);

		Aa00j05s01DaoImpl.logger.info("PARAMs =" + params);
		return (List<Aa00j05s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMapCombo, params.toArray());
	}

	public Aa00j05s01 anyadir(String codigo, String nombre) {
		Aa00j05s01DaoImpl.logger.info("Método anyadir");
		Aa00j05s01 aa00j05s01 = new Aa00j05s01(codigo, nombre,
				aa00jConstantes.SITUACION_ALTA, 0, null, null);
		return this.add(aa00j05s01);
	}

	public boolean existeCodigo(String codigo, String codigoNoIncluir) {
		Aa00j05s01DaoImpl.logger.info("Método existeCodigo");
		if (codigoNoIncluir != null && codigoNoIncluir.length() > 0) {
			String query = "SELECT COUNT(1) FROM AA00J05S01 WHERE UPPER(CRESP05) = UPPER(?) AND CRESP05 <> ?";
			Aa00j05s01DaoImpl.logger.info("SQL " + query);

			Aa00j05s01DaoImpl.logger.info("PARAM1 =" + codigo);
			Aa00j05s01DaoImpl.logger.info("PARAM2 =" + codigoNoIncluir);
			return this.jdbcTemplate
					.queryForInt(query, codigo, codigoNoIncluir) > 0;
		} else {
			String query = "SELECT COUNT(1) FROM AA00J05S01 WHERE UPPER(CRESP05) = UPPER(?)";
			Aa00j05s01DaoImpl.logger.info("SQL " + query);

			Aa00j05s01DaoImpl.logger.info("PARAM1 =" + codigo);

			return this.jdbcTemplate.queryForInt(query, codigo) > 0;
		}
	}

	public boolean existe(String nombre, String codigoNoIncluir) {
		Aa00j05s01DaoImpl.logger.info("Método existe");
		if (codigoNoIncluir != null && codigoNoIncluir.length() > 0) {
			String query = "SELECT COUNT(1) FROM AA00J05S01 WHERE UPPER(NOM05) = UPPER(?) AND CRESP05 <> ?";
			Aa00j05s01DaoImpl.logger.info("SQL " + query);

			Aa00j05s01DaoImpl.logger.info("PARAM1 =" + nombre);
			Aa00j05s01DaoImpl.logger.info("PARAM2 =" + codigoNoIncluir);
			return this.jdbcTemplate
					.queryForInt(query, nombre, codigoNoIncluir) > 0;
		} else {
			String query = "SELECT COUNT(1) FROM AA00J05S01 WHERE UPPER(NOM05) = UPPER(?)";
			Aa00j05s01DaoImpl.logger.info("SQL " + query);

			Aa00j05s01DaoImpl.logger.info("PARAM1 =" + nombre);

			return this.jdbcTemplate.queryForInt(query, nombre) > 0;
		}
	}

	public List<Aa00j05s01> obtenerResponsablesEdificio(Long cedif03) {
		Aa00j05s01DaoImpl.logger.info("Método obtenerResponsablesEdificio");
		StringBuilder query = new StringBuilder(
				"SELECT t1.CRESP05 CRESP05,t1.NOM05 NOM05 ");
		query.append("FROM AA00J05S01 t1, AA00J09S01 t2 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CRESP05=t2.CRESP09 AND t2.CEDIF09=? ");
		query.append(where);

		List<Object> params = new ArrayList<Object>();
		params.add(cedif03);
		Aa00j05s01DaoImpl.logger.info("SQL " + query);
		Aa00j05s01DaoImpl.logger.info("PARAMs =" + params);

		return (List<Aa00j05s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMapCombo, params.toArray());
	}

	public List<Aa00j05s01> obtenerResponsablesEdificioLibres(Long cedif03) {
		Aa00j05s01DaoImpl.logger
				.info("Método obtenerResponsablesEdificioLibres");
		StringBuilder query = new StringBuilder(
				"SELECT t1.CRESP05 CRESP05,t1.NOM05 NOM05 ");
		query.append("FROM AA00J05S01 t1 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.SIT05=? AND t1.CRESP05 NOT IN (SELECT t2.CRESP09 FROM AA00J09S01 t2 WHERE t2.CEDIF09=?)  ");
		query.append(where);

		List<Object> params = new ArrayList<Object>();
		params.add(aa00jConstantes.SITUACION_ALTA);
		params.add(cedif03);
		Aa00j05s01DaoImpl.logger.info("SQL " + query);
		Aa00j05s01DaoImpl.logger.info("PARAMs =" + params);
		return (List<Aa00j05s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMapCombo, params.toArray());
	}
}