package com.ejie.aa00j.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa00j.classes.aa00jConstantes;
import com.ejie.aa00j.model.Aa00j04s01;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa00j04s01DaoImpl generated by UDA, 16-oct-2013 13:02:12.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class Aa00j04s01DaoImpl implements Aa00j04s01Dao {
	private JdbcTemplate jdbcTemplate;
	private static final Logger logger = LoggerFactory
			.getLogger(Aa00j04s01DaoImpl.class);
	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Aa00j04s01> rwMap = new RowMapper<Aa00j04s01>() {
		public Aa00j04s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa00j04s01(resultSet.getLong("CTEXTO04"),
					resultSet.getString("TTEXTO04"),
					resultSet.getString("TRESC04"),
					resultSet.getString("TRESE04"),
					resultSet.getString("SIT04"), resultSet.getInt("BLOQ04"),
					resultSet.getString("USUB04"));
		}
	};

	private RowMapper<Aa00j04s01> rwMapPK = new RowMapper<Aa00j04s01>() {
		public Aa00j04s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa00j04s01(resultSet.getLong("CTEXTO04"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Aa00j04s01>> rwMapJerarquia = new RowMapper<JerarquiaDto<Aa00j04s01>>() {
		public JerarquiaDto<Aa00j04s01> mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Aa00j04s01 aa00j04s01 = new Aa00j04s01(
					resultSet.getLong("CTEXTO04"),
					resultSet.getString("TTEXTO04"),
					resultSet.getString("TRESC04"),
					resultSet.getString("TRESE04"),
					resultSet.getString("SIT04"), resultSet.getInt("BLOQ04"),
					resultSet.getString("USUB04"));

			JerarquiaDto<Aa00j04s01> jerarquia = new JerarquiaDto<Aa00j04s01>();
			jerarquia.setModel(aa00j04s01);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet
					.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet
					.getString("FILTER")));
			return jerarquia;
		}
	};

	private RowMapper<Aa00j04s01> rwMapCombo = new RowMapper<Aa00j04s01>() {
		public Aa00j04s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa00j04s01(resultSet.getLong("CTEXTO04"),
					resultSet.getString("TTEXTO04"), "", "", "", 0, "", null);
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Aa00j04s01 table.
	 * 
	 * @param aa00j04s01
	 *            Aa00j04s01
	 * @return Aa00j04s01
	 */
	public Aa00j04s01 add(final Aa00j04s01 aa00j04s01) {
		if (aa00j04s01.getSit04() == null
				|| aa00j04s01.getSit04().length() == 0)
			aa00j04s01.setSit04(aa00jConstantes.SITUACION_ALTA);
		Aa00j04s01DaoImpl.logger.info("Método add");
		final String queryUltimoId = "(SELECT NVL(MAX(TO_NUMBER(CTEXTO04)), 0) + 1 FROM AA00J04S01)";
		final String query = "INSERT INTO AA00J04S01 (CTEXTO04, TTEXTO04, TRESC04, TRESE04, SIT04, BLOQ04, USUB04) VALUES ("
				+ queryUltimoId + ",?,?,?,?,?,?)";

		KeyHolder keyHolder = new GeneratedKeyHolder();
		Aa00j04s01DaoImpl.logger.info("SQL =" + query);
		Aa00j04s01DaoImpl.logger.info("PARAMS1 ="
				+ aa00j04s01.getTtexto04().trim());
		Aa00j04s01DaoImpl.logger.info("PARAMS2 ="
				+ aa00j04s01.getTresc04().trim());
		Aa00j04s01DaoImpl.logger.info("PARAMS3 ="
				+ aa00j04s01.getTrese04().trim());
		Aa00j04s01DaoImpl.logger.info("PARAMS4 =" + aa00j04s01.getSit04());
		Aa00j04s01DaoImpl.logger.info("PARAMS5 =" + 0);
		Aa00j04s01DaoImpl.logger.info("PARAMS6=" + null);
		jdbcTemplate.update(new PreparedStatementCreator() {
			public PreparedStatement createPreparedStatement(
					Connection connection) throws SQLException {
				PreparedStatement ps = connection.prepareStatement(query,
						new String[] { "CTEXTO04" });
				ps.setObject(1, aa00j04s01.getTtexto04().trim());
				ps.setObject(2, aa00j04s01.getTresc04().trim());
				ps.setObject(3, aa00j04s01.getTrese04().trim());
				ps.setObject(4, aa00j04s01.getSit04());
				ps.setObject(5, 0);
				ps.setObject(6, null);
				return ps;
			}
		}, keyHolder);

		aa00j04s01.setCtexto04(keyHolder.getKey().longValue());

		return aa00j04s01;
	}

	/**
	 * Updates a single row in the Aa00j04s01 table.
	 * 
	 * @param aa00j04s01
	 *            Aa00j04s01
	 * @return Aa00j04s01
	 */
	public Aa00j04s01 update(Aa00j04s01 aa00j04s01) {
		Aa00j04s01DaoImpl.logger.info("Método update");
		String query = "UPDATE AA00J04S01 SET TTEXTO04=?, TRESC04=?, TRESE04=?, SIT04=?, BLOQ04=?, USUB04=? WHERE CTEXTO04=?";
		Aa00j04s01DaoImpl.logger.info("SQL =" + query);
		Aa00j04s01DaoImpl.logger.info("PARAMS1 ="
				+ aa00j04s01.getTtexto04().trim());
		Aa00j04s01DaoImpl.logger.info("PARAMS2 ="
				+ aa00j04s01.getTresc04().trim());
		Aa00j04s01DaoImpl.logger.info("PARAMS3 ="
				+ aa00j04s01.getTrese04().trim());
		Aa00j04s01DaoImpl.logger.info("PARAMS4 =" + aa00j04s01.getSit04());
		Aa00j04s01DaoImpl.logger.info("PARAMS5 =" + aa00j04s01.getBloq04());
		Aa00j04s01DaoImpl.logger.info("PARAMS6 =" + aa00j04s01.getUsub04());
		Aa00j04s01DaoImpl.logger.info("PARAMS7 =" + aa00j04s01.getCtexto04());
		this.jdbcTemplate.update(query, aa00j04s01.getTtexto04(),
				aa00j04s01.getTresc04(), aa00j04s01.getTrese04(),
				aa00j04s01.getSit04(), aa00j04s01.getBloq04(),
				aa00j04s01.getUsub04(), aa00j04s01.getCtexto04());
		return aa00j04s01;
	}

	/**
	 * Finds a single row in the Aa00j04s01 table.
	 * 
	 * @param aa00j04s01
	 *            Aa00j04s01
	 * @return Aa00j04s01
	 */
	@Transactional(readOnly = true)
	public Aa00j04s01 find(Aa00j04s01 aa00j04s01) {
		Aa00j04s01DaoImpl.logger.info("Método find");
		String query = "SELECT t1.CTEXTO04 CTEXTO04, t1.TTEXTO04 TTEXTO04, NVL2(t1.TRESC04,t1.TRESC04,t1.TRESE04) TRESC04, NVL2(t1.TRESE04,t1.TRESE04,t1.TRESC04) TRESE04, t1.SIT04 SIT04, t1.BLOQ04 BLOQ04, t1.USUB04 USUB04 FROM AA00J04S01 t1  WHERE t1.CTEXTO04 = ?  ";
		Aa00j04s01DaoImpl.logger.info("SQL =" + query);
		Aa00j04s01DaoImpl.logger.info("PARAMS1 =" + aa00j04s01.getCtexto04());

		List<Aa00j04s01> aa00j04s01List = this.jdbcTemplate.query(query,
				this.rwMap, aa00j04s01.getCtexto04());
		return (Aa00j04s01) DataAccessUtils.uniqueResult(aa00j04s01List);
	}

	/**
	 * Removes a single row in the Aa00j04s01 table.
	 * 
	 * @param aa00j04s01
	 *            Aa00j04s01
	 * @return
	 */
	public void remove(Aa00j04s01 aa00j04s01) {
		Aa00j04s01DaoImpl.logger.info("Método remove");
		String query = "DELETE FROM AA00J04S01 WHERE CTEXTO04=?";
		Aa00j04s01DaoImpl.logger.info("SQL =" + query);
		Aa00j04s01DaoImpl.logger.info("PARAMS1 =" + aa00j04s01.getCtexto04());
		this.jdbcTemplate.update(query, aa00j04s01.getCtexto04());
	}

	/**
	 * Finds a list of rows in the Aa00j04s01 table.
	 * 
	 * @param aa00j04s01
	 *            Aa00j04s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa00j04s01>
	 */
	@Transactional(readOnly = true)
	public List<Aa00j04s01> findAll(Aa00j04s01 aa00j04s01,
			JQGridRequestDto jqGridRequestDto) {
		Aa00j04s01DaoImpl.logger.info("Método findAll");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CTEXTO04 CTEXTO04,t1.TTEXTO04 TTEXTO04,NVL2(t1.TRESC04,t1.TRESC04,t1.TRESE04)  TRESC04, NVL2(t1.TRESE04,t1.TRESE04,t1.TRESC04) TRESE04,t1.SIT04 SIT04,t1.BLOQ04 BLOQ04,t1.USUB04 USUB04 ");
		query.append("FROM AA00J04S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa00j04s01);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		Aa00j04s01DaoImpl.logger.info("SQL =" + query);
		Aa00j04s01DaoImpl.logger.info("PARAMS =" + params);
		return (List<Aa00j04s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Aa00j04s01 table using like.
	 * 
	 * @param aa00j04s01
	 *            Aa00j04s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa00j04s01>
	 */
	@Transactional(readOnly = true)
	public List<Aa00j04s01> findAllLike(Aa00j04s01 aa00j04s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		Aa00j04s01DaoImpl.logger.info("Método findAllLike");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CTEXTO04 CTEXTO04,t1.TTEXTO04 TTEXTO04,NVL2(t1.TRESC04,t1.TRESC04,t1.TRESE04)  TRESC04, NVL2(t1.TRESE04,t1.TRESE04,t1.TRESC04) TRESE04,t1.SIT04 SIT04,t1.BLOQ04 BLOQ04,t1.USUB04 USUB04 ");
		query.append("FROM AA00J04S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa00j04s01, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		Aa00j04s01DaoImpl.logger.info("SQL =" + query);
		Aa00j04s01DaoImpl.logger.info("PARAMS =" + params);
		return (List<Aa00j04s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Aa00j04s01 table.
	 * 
	 * @param aa00j04s01
	 *            Aa00j04s01
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Aa00j04s01 aa00j04s01) {
		Aa00j04s01DaoImpl.logger.info("Método findAllCount");
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA00J04S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa00j04s01);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j04s01DaoImpl.logger.info("SQL =" + query);
		Aa00j04s01DaoImpl.logger.info("PARAMS =" + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Aa00j04s01 table using like.
	 * 
	 * @param aa00j04s01
	 *            Aa00j04s01
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Aa00j04s01 aa00j04s01, Boolean startsWith) {
		Aa00j04s01DaoImpl.logger.info("Método findAllLikeCount");
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA00J04S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa00j04s01, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j04s01DaoImpl.logger.info("SQL =" + query);
		Aa00j04s01DaoImpl.logger.info("PARAMS =" + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Aa00j04s01 selected for rup_table
	 * 
	 * @param aa00j04s01
	 *            Aa00j04s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j04s01>>
	 */
	@Override
	public List<TableRowDto<Aa00j04s01>> reorderSelection(
			Aa00j04s01 aa00j04s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		Aa00j04s01DaoImpl.logger.info("Método reorderSelection");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CTEXTO04 CTEXTO04,t1.TTEXTO04 TTEXTO04,NVL2(t1.TRESC04,t1.TRESC04,t1.TRESE04)  TRESC04, NVL2(t1.TRESE04,t1.TRESE04,t1.TRESC04) TRESE04,t1.SIT04 SIT04,t1.BLOQ04 BLOQ04,t1.USUB04 USUB04 ");
		// FROM
		query.append("FROM AA00J04S01 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa00j04s01, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, Aa00j04s01.class, filterParamList,
				"CTEXTO04");
		Aa00j04s01DaoImpl.logger.info("SQL =" + sbReorderSelectionSQL);
		Aa00j04s01DaoImpl.logger.info("PARAMS =" + filterParamList);
		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa00j04s01>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * @param filterParams
	 *            Aa00j04s01
	 * @param searchParams
	 *            Aa00j04s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j04s01>>
	 */
	@Override
	public List<TableRowDto<Aa00j04s01>> search(Aa00j04s01 filterParams,
			Aa00j04s01 searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		Aa00j04s01DaoImpl.logger.info("Método search");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CTEXTO04 CTEXTO04,t1.TTEXTO04 TTEXTO04,NVL2(t1.TRESC04,t1.TRESC04,t1.TRESE04)  TRESC04, NVL2(t1.TRESE04,t1.TRESE04,t1.TRESC04) TRESE04,t1.SIT04 SIT04,t1.BLOQ04 BLOQ04,t1.USUB04 USUB04 ");
		// FROM
		query.append("FROM AA00J04S01 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, Aa00j04s01.class, filterParamList,
				searchSQL, searchParamList, from_alias, "CTEXTO04");
		Aa00j04s01DaoImpl.logger.info("SQL =" + sbReorderSelectionSQL);
		Aa00j04s01DaoImpl.logger.info("PARAMS =" + filterParamList);
		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa00j04s01>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 * 
	 * @param filteraa00j04s01
	 *            Aa00j04s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Aa00j04s01 filteraa00j04s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		Aa00j04s01DaoImpl.logger.info("Método removeMultiple");
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.CTEXTO04 CTEXTO04,t1.TTEXTO04 TTEXTO04,NVL2(t1.TRESC04,t1.TRESC04,t1.TRESE04)  TRESC04, NVL2(t1.TRESE04,t1.TRESE04,t1.TRESC04) TRESE04,t1.SIT04 SIT04,t1.BLOQ04 BLOQ04,t1.USUB04 USUB04 ");
		// FROM
		query.append("FROM AA00J04S01 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filteraa00j04s01,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto, Aa00j04s01.class,
						query, params, "CTEXTO04");
		Aa00j04s01DaoImpl.logger.info("SQL =" + sbRemoveMultipleSQL);
		Aa00j04s01DaoImpl.logger.info("PARAMS =" + params);
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical Aa00j04s01 table.
	 * 
	 * @param filterAa00j04s01
	 *            Aa00j04s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Aa00j04s01>>
	 */
	@Override
	public List<JerarquiaDto<Aa00j04s01>> findAllLikeJerarquia(
			Aa00j04s01 filterAa00j04s01, JQGridRequestDto jqGridRequestDto) {
		Aa00j04s01DaoImpl.logger.info("Método findAllLikeJerarquia");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CTEXTO04 CTEXTO04,t1.TTEXTO04 TTEXTO04,NVL2(t1.TRESC04,t1.TRESC04,t1.TRESE04)  TRESC04, NVL2(t1.TRESE04,t1.TRESE04,t1.TRESC04) TRESE04,t1.SIT04 SIT04,t1.BLOQ04 BLOQ04,t1.USUB04 USUB04 ");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA00J04S01 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA00J04S01");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa00j04s01, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
				mapaWhere, "CTEXTO04", "ID_PADRE", "NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j04s01DaoImpl.logger.info("SQL =" + query);
		Aa00j04s01DaoImpl.logger.info("PARAMS =" + params);
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAa00j04s01
	 *            Aa00j04s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Aa00j04s01 filterAa00j04s01,
			JQGridRequestDto jqGridRequestDto) {
		Aa00j04s01DaoImpl.logger.info("Método findAllLikeCountJerarquia");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA00J04S01 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA00J04S01");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa00j04s01, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(
				jqGridRequestDto, mapaWhere, "CTEXTO04", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j04s01DaoImpl.logger.info("SQL =" + query);
		Aa00j04s01DaoImpl.logger.info("PARAMS =" + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAa00j04s01
	 *            Aa00j04s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Aa00j04s01>>
	 */
	@Override
	public List<TableRowDto<Aa00j04s01>> findAllChild(
			Aa00j04s01 filterAa00j04s01, JQGridRequestDto jqGridRequestDto) {
		Aa00j04s01DaoImpl.logger.info("Método findAllChild");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA00J04S01 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA00J04S01");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa00j04s01, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(
				jqGridRequestDto, mapaWhere, "CTEXTO04", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j04s01DaoImpl.logger.info("SQL =" + query);
		Aa00j04s01DaoImpl.logger.info("PARAMS =" + params);
		return this.jdbcTemplate.query(query.toString(),
				new RowNumResultSetExtractor<Aa00j04s01>(this.rwMapPK,
						"CTEXTO04"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa00j04s01 entity
	 * 
	 * @param aa00j04s01
	 *            Aa00j04s01 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Aa00j04s01 aa00j04s01) {

		StringBuilder where = new StringBuilder(
				Aa00j04s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa00j04s01 != null && aa00j04s01.getCtexto04() != null) {
			where.append(" AND t1.CTEXTO04 = ?");
			params.add(aa00j04s01.getCtexto04());
		}
		if (aa00j04s01 != null && aa00j04s01.getTtexto04() != null) {
			where.append(" AND t1.TTEXTO04 = ?");
			params.add(aa00j04s01.getTtexto04());
		}
		if (aa00j04s01 != null && aa00j04s01.getTresc04() != null) {
			where.append(" AND t1.TRESC04 = ?");
			params.add(aa00j04s01.getTresc04());
		}
		if (aa00j04s01 != null && aa00j04s01.getTrese04() != null) {
			where.append(" AND t1.TRESE04 = ?");
			params.add(aa00j04s01.getTrese04());
		}
		if (aa00j04s01 != null && aa00j04s01.getSit04() != null) {
			where.append(" AND t1.SIT04 = ?");
			params.add(aa00j04s01.getSit04());
		}
		if (aa00j04s01 != null && aa00j04s01.getBloq04() != null) {
			where.append(" AND t1.BLOQ04 = ?");
			params.add(aa00j04s01.getBloq04());
		}
		if (aa00j04s01 != null && aa00j04s01.getUsub04() != null) {
			where.append(" AND t1.USUB04 = ?");
			params.add(aa00j04s01.getUsub04());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa00j04s01 entity
	 * 
	 * @param aa00j04s01
	 *            Aa00j04s01 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Aa00j04s01 aa00j04s01,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				Aa00j04s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa00j04s01 != null && aa00j04s01.getCtexto04() != null) {
			where.append(" AND t1.CTEXTO04 = ?");
			params.add(aa00j04s01.getCtexto04());
		}
		if (aa00j04s01 != null && aa00j04s01.getTtexto04() != null) {
			where.append(" AND UPPER(t1.TTEXTO04) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j04s01.getTtexto04().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j04s01.getTtexto04().toUpperCase() + "%");
			}
			where.append(" AND t1.TTEXTO04 IS NOT NULL");
		}
		if (aa00j04s01 != null && aa00j04s01.getTresc04() != null
				&& aa00j04s01.getTresc04().length() > 0) {
			where.append(" AND UPPER(t1.TRESC04) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j04s01.getTresc04().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j04s01.getTresc04().toUpperCase() + "%");
			}
			where.append(" AND t1.TRESC04 IS NOT NULL");
		}
		if (aa00j04s01 != null && aa00j04s01.getTrese04() != null
				&& aa00j04s01.getTrese04().length() > 0) {
			where.append(" AND UPPER(t1.TRESE04) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j04s01.getTrese04().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j04s01.getTrese04().toUpperCase() + "%");
			}
			where.append(" AND t1.TRESE04 IS NOT NULL");
		}
		if (aa00j04s01 != null && aa00j04s01.getSit04() != null) {
			where.append(" AND UPPER(t1.SIT04) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j04s01.getSit04().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j04s01.getSit04().toUpperCase() + "%");
			}
			where.append(" AND t1.SIT04 IS NOT NULL");
		}
		if (aa00j04s01 != null && aa00j04s01.getBloq04() != null) {
			where.append(" AND t1.BLOQ04 = ?");
			params.add(aa00j04s01.getBloq04());
		}
		if (aa00j04s01 != null && aa00j04s01.getUsub04() != null) {
			where.append(" AND UPPER(t1.USUB04) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j04s01.getUsub04().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j04s01.getUsub04().toUpperCase() + "%");
			}
			where.append(" AND t1.USUB04 IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	public Aa00j04s01 anyadir(String titulo, String textoEs, String textoEu) {
		Aa00j04s01DaoImpl.logger.info("Método anyadir");
		Aa00j04s01 aa00j04s01 = new Aa00j04s01(null, titulo, textoEs, textoEu,
				aa00jConstantes.SITUACION_ALTA, 0, null, null);
		return this.add(aa00j04s01);
	}

	public List<Aa00j04s01> obtenerCombo() {
		Aa00j04s01DaoImpl.logger.info("Método obtenerCombo");
		StringBuilder query = new StringBuilder(
				"SELECT t1.CTEXTO04 CTEXTO04,t1.TTEXTO04 TTEXTO04 ");
		query.append("FROM AA00J04S01 t1 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CTEXTO04>0 AND t1.SIT04=? ");
		query.append(where);

		List<Object> params = new ArrayList<Object>();
		params.add(aa00jConstantes.SITUACION_ALTA);
		Aa00j04s01DaoImpl.logger.info("SQL =" + query);
		Aa00j04s01DaoImpl.logger.info("PARAMS =" + params);
		return (List<Aa00j04s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMapCombo, params.toArray());
	}

	public boolean existe(String titulo, Long codigoNoIncluir) {
		Aa00j04s01DaoImpl.logger.info("Método existe");
		if (codigoNoIncluir != null
				&& (codigoNoIncluir > 0 || codigoNoIncluir == -1)) {
			String query = "SELECT COUNT(1) FROM AA00J04S01 WHERE UPPER(TTEXTO04) = UPPER(?) AND CTEXTO04 <> ?";
			Aa00j04s01DaoImpl.logger.info("SQL =" + query);
			Aa00j04s01DaoImpl.logger.info("PARAM1 =" + titulo);
			Aa00j04s01DaoImpl.logger.info("PARAM2 =" + codigoNoIncluir);
			return this.jdbcTemplate
					.queryForInt(query, titulo, codigoNoIncluir) > 0;
		} else {
			String query = "SELECT COUNT(1) FROM AA00J04S01 WHERE UPPER(TTEXTO04) = UPPER(?)";
			Aa00j04s01DaoImpl.logger.info("SQL =" + query);
			Aa00j04s01DaoImpl.logger.info("PARAM1 =" + titulo);
			return this.jdbcTemplate.queryForInt(query, titulo) > 0;
		}
	}
}