package com.ejie.aa00j.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import weblogic.utils.StringUtils;

import com.ejie.aa00j.classes.aa00jConstantes;
import com.ejie.aa00j.classes.aa00jPersonaSesion;
import com.ejie.aa00j.classes.aa00jSeguridad;
import com.ejie.aa00j.model.Aa00j02s01;
import com.ejie.aa00j.model.Aa00j03s01;
import com.ejie.aa00j.model.Aa00j05s01;
import com.ejie.aa00j.model.Option;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.dto.PaginationManager;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa00j03s01DaoImpl generated by UDA, 16-oct-2013 13:02:12.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class Aa00j03s01DaoImpl implements Aa00j03s01Dao {
	private JdbcTemplate jdbcTemplate;
	private static final Logger logger = LoggerFactory
			.getLogger(Aa00j03s01DaoImpl.class);
	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Aa00j03s01> rwMap = new RowMapper<Aa00j03s01>() {
		public Aa00j03s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa00j03s01(resultSet.getLong("CEDIF03"),
					resultSet.getString("NOMBRE03"),
					resultSet.getString("SIT03"), resultSet.getInt("BLOQ03"),
					resultSet.getString("TLFNO03"),
					resultSet.getString("USUB03"), new Aa00j02s01(
							resultSet.getLong("Aa00j02s01CSITIO02"),
							resultSet.getString("Aa00j02s01NOMBRE02"),
							resultSet.getString("Aa00j02s01SIT02"),
							resultSet.getInt("Aa00j02s01BLOQ02"),
							resultSet.getString("Aa00j02s01USUB02")));
		}
	};

	private RowMapper<Aa00j03s01> rwMapPK = new RowMapper<Aa00j03s01>() {
		public Aa00j03s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa00j03s01(resultSet.getLong("CEDIF03"));
		}
	};
	private RowMapper<Option> optionMap = new RowMapper<Option>() {
		public Option mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Option(resultSet.getString("VALUE"),
					resultSet.getString("TEXT"));
		}
	};
	/**
	 * Rowmapper para Jerarquía
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Aa00j03s01>> rwMapJerarquia = new RowMapper<JerarquiaDto<Aa00j03s01>>() {
		public JerarquiaDto<Aa00j03s01> mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Aa00j03s01 aa00j03s01 = new Aa00j03s01(
					resultSet.getLong("CEDIF03"),
					resultSet.getString("NOMBRE03"),
					resultSet.getString("SIT03"), resultSet.getInt("BLOQ03"),
					resultSet.getString("TLFNO03"),
					resultSet.getString("USUB03"), new Aa00j02s01(
							resultSet.getLong("Aa00j02s01CSITIO02"),
							resultSet.getString("Aa00j02s01NOMBRE02"),
							resultSet.getString("Aa00j02s01SIT02"),
							resultSet.getInt("Aa00j02s01BLOQ02"),
							resultSet.getString("Aa00j02s01USUB02")));

			JerarquiaDto<Aa00j03s01> jerarquia = new JerarquiaDto<Aa00j03s01>();
			jerarquia.setModel(aa00j03s01);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet
					.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet
					.getString("FILTER")));
			return jerarquia;
		}
	};

	private RowMapper<Aa00j03s01> rwMapCombo = new RowMapper<Aa00j03s01>() {
		public Aa00j03s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa00j03s01(resultSet.getLong("CEDIF03"),
					resultSet.getString("NOMBRE03"), "", 0, "", "", null);
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Aa00j03s01 table.
	 * 
	 * @param aa00j03s01
	 *            Aa00j03s01
	 * @return Aa00j03s01
	 */
	public Aa00j03s01 add(final Aa00j03s01 aa00j03s01) {
		if (aa00j03s01.getSit03() == null
				|| aa00j03s01.getSit03().length() == 0)
			aa00j03s01.setSit03(aa00jConstantes.SITUACION_ALTA);
		Aa00j03s01DaoImpl.logger.info("Método add");
		final String queryUltimoId = "(SELECT NVL(MAX(TO_NUMBER(CEDIF03)), 0) + 1 FROM AA00J03S01)";
		final String query = "INSERT INTO AA00J03S01 (CEDIF03, CSITIO03, NOMBRE03, SIT03, BLOQ03, TLFNO03, USUB03) VALUES ("
				+ queryUltimoId + ",?,?,?,?,?,?)";
		final Object getAa00j02s01Csitio02Aux;
		if (aa00j03s01.getAa00j02s01() != null
				&& aa00j03s01.getAa00j02s01().getCsitio02() != null) {
			getAa00j02s01Csitio02Aux = aa00j03s01.getAa00j02s01().getCsitio02();
		} else {
			getAa00j02s01Csitio02Aux = null;
		}

		KeyHolder keyHolder = new GeneratedKeyHolder();
		Aa00j03s01DaoImpl.logger.info("SQL =" + query);
		Aa00j03s01DaoImpl.logger.info("PARAMS1 =" + getAa00j02s01Csitio02Aux);
		Aa00j03s01DaoImpl.logger.info("PARAMS2 ="
				+ aa00j03s01.getNombre03().trim());
		Aa00j03s01DaoImpl.logger.info("PARAMS3 =" + aa00j03s01.getSit03());
		Aa00j03s01DaoImpl.logger.info("PARAMS4 =" + 0);
		Aa00j03s01DaoImpl.logger.info("PARAMS5 =" + aa00j03s01.getTlfno03());
		Aa00j03s01DaoImpl.logger.info("PARAMS6 =" + null);
		jdbcTemplate.update(new PreparedStatementCreator() {
			public PreparedStatement createPreparedStatement(
					Connection connection) throws SQLException {
				PreparedStatement ps = connection.prepareStatement(query,
						new String[] { "CEDIF03" });
				ps.setLong(1, (Long) getAa00j02s01Csitio02Aux);
				ps.setString(2, aa00j03s01.getNombre03().trim());
				ps.setString(3, aa00j03s01.getSit03());
				ps.setInt(4, 0);
				ps.setString(5, aa00j03s01.getTlfno03());
				ps.setString(6, null);
				return ps;
			}
		}, keyHolder);

		aa00j03s01.setCedif03(keyHolder.getKey().longValue());

		return aa00j03s01;
	}

	/**
	 * Updates a single row in the Aa00j03s01 table.
	 * 
	 * @param aa00j03s01
	 *            Aa00j03s01
	 * @return Aa00j03s01
	 */
	public Aa00j03s01 update(Aa00j03s01 aa00j03s01) {
		if (aa00j03s01.getSit03() == null
				|| aa00j03s01.getSit03().length() == 0)
			aa00j03s01.setSit03(aa00jConstantes.SITUACION_ALTA);
		Aa00j03s01DaoImpl.logger.info("Método update");
		String query = "UPDATE AA00J03S01 SET CSITIO03=?, NOMBRE03=?, SIT03=?, BLOQ03=?, TLFNO03=?, USUB03=? WHERE CEDIF03=?";
		Object getAa00j02s01Csitio02Aux = null;
		if (aa00j03s01.getAa00j02s01() != null
				&& aa00j03s01.getAa00j02s01().getCsitio02() != null) {
			getAa00j02s01Csitio02Aux = aa00j03s01.getAa00j02s01().getCsitio02();
		}
		Aa00j03s01DaoImpl.logger.info("SQL =" + query);
		Aa00j03s01DaoImpl.logger.info("PARAMS1 =" + getAa00j02s01Csitio02Aux);
		Aa00j03s01DaoImpl.logger.info("PARAMS2 ="
				+ aa00j03s01.getNombre03().trim());
		Aa00j03s01DaoImpl.logger.info("PARAMS3 =" + aa00j03s01.getSit03());
		Aa00j03s01DaoImpl.logger.info("PARAMS4 =" + aa00j03s01.getBloq03());
		Aa00j03s01DaoImpl.logger.info("PARAMS5 =" + aa00j03s01.getTlfno03());
		Aa00j03s01DaoImpl.logger.info("PARAMS6 =" + aa00j03s01.getUsub03());
		Aa00j03s01DaoImpl.logger.info("PARAMS7 =" + aa00j03s01.getCedif03());

		this.jdbcTemplate.update(query, getAa00j02s01Csitio02Aux, aa00j03s01
				.getNombre03().trim(), aa00j03s01.getSit03(), aa00j03s01
				.getBloq03(), aa00j03s01.getTlfno03(), aa00j03s01.getUsub03(),
				aa00j03s01.getCedif03());
		return aa00j03s01;
	}

	/**
	 * Finds a single row in the Aa00j03s01 table.
	 * 
	 * @param aa00j03s01
	 *            Aa00j03s01
	 * @return Aa00j03s01
	 */
	@Transactional(readOnly = true)
	public Aa00j03s01 find(Aa00j03s01 aa00j03s01) {
		Aa00j03s01DaoImpl.logger.info("Método find");
		String query = "SELECT t1.CEDIF03 CEDIF03, t1.NOMBRE03 NOMBRE03, t1.SIT03 SIT03, t1.BLOQ03 BLOQ03, t1.TLFNO03 TLFNO03, t1.USUB03 USUB03, t2.CSITIO02 AA00J02S01CSITIO02, t2.NOMBRE02 AA00J02S01NOMBRE02, t2.SIT02 AA00J02S01SIT02, t2.BLOQ02 AA00J02S01BLOQ02, t2.USUB02 AA00J02S01USUB02 FROM AA00J03S01 t1 , AA00J02S01 t2  WHERE t1.CEDIF03 = ?   AND t1.CSITIO03= t2.CSITIO02(+)";

		Aa00j03s01DaoImpl.logger.info("SQL =" + query);
		Aa00j03s01DaoImpl.logger.info("PARAMS1 =" + aa00j03s01.getCedif03());
		List<Aa00j03s01> aa00j03s01List = this.jdbcTemplate.query(query,
				this.rwMap, aa00j03s01.getCedif03());
		return (Aa00j03s01) DataAccessUtils.uniqueResult(aa00j03s01List);
	}

	/**
	 * Removes a single row in the Aa00j03s01 table.
	 * 
	 * @param aa00j03s01
	 *            Aa00j03s01
	 * @return
	 */
	public void remove(Aa00j03s01 aa00j03s01) {
		Aa00j03s01DaoImpl.logger.info("Método remove");
		String query = "DELETE FROM AA00J03S01 WHERE CEDIF03=?";
		Aa00j03s01DaoImpl.logger.info("SQL =" + query);
		Aa00j03s01DaoImpl.logger.info("PARAMS1 =" + aa00j03s01.getCedif03());
		this.jdbcTemplate.update(query, aa00j03s01.getCedif03());
	}

	/**
	 * Finds a list of rows in the Aa00j03s01 table.
	 * 
	 * @param aa00j03s01
	 *            Aa00j03s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa00j03s01>
	 */
	@Transactional(readOnly = true)
	public List<Aa00j03s01> findAll(Aa00j03s01 aa00j03s01,
			JQGridRequestDto jqGridRequestDto) {
		Aa00j03s01DaoImpl.logger.info("Método findAll");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CEDIF03 CEDIF03,t1.NOMBRE03 NOMBRE03,t1.SIT03 SIT03,t1.BLOQ03 BLOQ03,t1.TLFNO03 TLFNO03,t1.USUB03 USUB03,t2.CSITIO02 AA00J02S01CSITIO02,t2.NOMBRE02 AA00J02S01NOMBRE02,t2.SIT02 AA00J02S01SIT02,t2.BLOQ02 AA00J02S01BLOQ02,t2.USUB02 AA00J02S01USUB02 ");
		query.append("FROM AA00J03S01 t1 ,AA00J02S01 t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa00j03s01);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CSITIO03= t2.CSITIO02(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		Aa00j03s01DaoImpl.logger.info("SQL =" + query.toString());
		Aa00j03s01DaoImpl.logger.info("PARAMS =" + params);
		return (List<Aa00j03s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Aa00j03s01 table using like.
	 * 
	 * @param aa00j03s01
	 *            Aa00j03s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa00j03s01>
	 */
	@Transactional(readOnly = true)
	public List<Aa00j03s01> findAllLike(Aa00j03s01 aa00j03s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		Aa00j03s01DaoImpl.logger.info("Método findAllLike");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CEDIF03 CEDIF03,t1.NOMBRE03 NOMBRE03,t1.SIT03 SIT03,t1.BLOQ03 BLOQ03,t1.TLFNO03 TLFNO03,t1.USUB03 USUB03,t2.CSITIO02 AA00J02S01CSITIO02,t2.NOMBRE02 AA00J02S01NOMBRE02,t2.SIT02 AA00J02S01SIT02,t2.BLOQ02 AA00J02S01BLOQ02,t2.USUB02 AA00J02S01USUB02 ");
		query.append("FROM AA00J03S01 t1 ,AA00J02S01 t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa00j03s01, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CSITIO03= t2.CSITIO02(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		// Chapuza para arreglar el jaleo que monta uda:
		// En la clase del modelo las columnas se llaman aa00j10s01.nombre10,
		// por
		// ejemplo, pero en la sql que crea se llama t1.nombre10
		// por lo que al ordenar la tabla no lo hace bien
		// ya que en la tabla hay que poner el nombre que tiene en el modelo
		// lo hago así para tocar lo mínimo posible el resto de la aplicación

		String sql = query.toString();

		sql = StringUtils.replaceGlobal(sql, "aa00j03s01.", "t1.");
		sql = StringUtils.replaceGlobal(sql, "aa00j02s01.", "t2.");

		Aa00j03s01DaoImpl.logger.info("SQL =" + sql);
		Aa00j03s01DaoImpl.logger.info("PARAMS =" + params);
		return (List<Aa00j03s01>) this.jdbcTemplate.query(sql, this.rwMap,
				params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Aa00j03s01 table.
	 * 
	 * @param aa00j03s01
	 *            Aa00j03s01
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Aa00j03s01 aa00j03s01) {
		Aa00j03s01DaoImpl.logger.info("Método findAllCount");
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA00J03S01 t1 , AA00J02S01 t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa00j03s01);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CSITIO03= t2.CSITIO02(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j03s01DaoImpl.logger.info("SQL =" + query.toString());
		Aa00j03s01DaoImpl.logger.info("PARAMS =" + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Aa00j03s01 table using like.
	 * 
	 * @param aa00j03s01
	 *            Aa00j03s01
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Aa00j03s01 aa00j03s01, Boolean startsWith) {
		Aa00j03s01DaoImpl.logger.info("Método findAllLikeCount");
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA00J03S01 t1 ,AA00J02S01 t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa00j03s01, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CSITIO03= t2.CSITIO02(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j03s01DaoImpl.logger.info("SQL =" + query.toString());
		Aa00j03s01DaoImpl.logger.info("PARAMS =" + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Aa00j03s01 selected for rup_table
	 * 
	 * @param aa00j03s01
	 *            Aa00j03s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j03s01>>
	 */
	@Override
	public List<TableRowDto<Aa00j03s01>> reorderSelection(
			Aa00j03s01 aa00j03s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		Aa00j03s01DaoImpl.logger.info("Método reorderSelection");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CEDIF03 CEDIF03,t1.NOMBRE03 NOMBRE03,t1.SIT03 SIT03,t1.BLOQ03 BLOQ03,t1.TLFNO03 TLFNO03,t1.USUB03 USUB03,t2.CSITIO02 AA00J02S01CSITIO02,t2.NOMBRE02 AA00J02S01NOMBRE02,t2.SIT02 AA00J02S01SIT02,t2.BLOQ02 AA00J02S01BLOQ02,t2.USUB02 AA00J02S01USUB02 ");
		// FROM
		query.append("FROM AA00J03S01 t1 ,AA00J02S01 t2 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa00j03s01, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CSITIO03= t2.CSITIO02(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, Aa00j03s01.class, filterParamList,
				"CEDIF03");
		Aa00j03s01DaoImpl.logger.info("SQL ="
				+ sbReorderSelectionSQL.toString());
		Aa00j03s01DaoImpl.logger.info("PARAMS1 =" + filterParamList);
		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa00j03s01>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * @param filterParams
	 *            Aa00j03s01
	 * @param searchParams
	 *            Aa00j03s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j03s01>>
	 */
	@Override
	public List<TableRowDto<Aa00j03s01>> search(Aa00j03s01 filterParams,
			Aa00j03s01 searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		Aa00j03s01DaoImpl.logger.info("Método search");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CEDIF03 CEDIF03,t1.NOMBRE03 NOMBRE03,t1.SIT03 SIT03,t1.BLOQ03 BLOQ03,t1.TLFNO03 TLFNO03,t1.USUB03 USUB03,t2.CSITIO02 AA00J02S01CSITIO02,t2.NOMBRE02 AA00J02S01NOMBRE02,t2.SIT02 AA00J02S01SIT02,t2.BLOQ02 AA00J02S01BLOQ02,t2.USUB02 AA00J02S01USUB02 ");
		// FROM
		query.append("FROM AA00J03S01 t1 ,AA00J02S01 t2 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CSITIO03= t2.CSITIO02(+) ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, Aa00j03s01.class, filterParamList,
				searchSQL, searchParamList, from_alias, "CEDIF03");
		Aa00j03s01DaoImpl.logger.info("SQL ="
				+ sbReorderSelectionSQL.toString());
		Aa00j03s01DaoImpl.logger.info("PARAMS1 =" + filterParamList);
		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa00j03s01>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 * 
	 * @param filteraa00j03s01
	 *            Aa00j03s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Aa00j03s01 filteraa00j03s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		Aa00j03s01DaoImpl.logger.info("Método removeMultiple");
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.CEDIF03 CEDIF03,t1.NOMBRE03 NOMBRE03,t1.SIT03 SIT03,t1.BLOQ03 BLOQ03,t1.TLFNO03 TLFNO03,t1.USUB03 USUB03,t2.CSITIO02 AA00J02S01CSITIO02,t2.NOMBRE02 AA00J02S01NOMBRE02,t2.SIT02 AA00J02S01SIT02,t2.BLOQ02 AA00J02S01BLOQ02,t2.USUB02 AA00J02S01USUB02 ");
		// FROM
		query.append("FROM AA00J03S01 t1 ,AA00J02S01 t2 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filteraa00j03s01,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto, Aa00j03s01.class,
						query, params, "CEDIF03");
		Aa00j03s01DaoImpl.logger.info("SQL =" + sbRemoveMultipleSQL.toString());
		Aa00j03s01DaoImpl.logger.info("PARAMS =" + params);
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical Aa00j03s01 table.
	 * 
	 * @param filterAa00j03s01
	 *            Aa00j03s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Aa00j03s01>>
	 */
	@Override
	public List<JerarquiaDto<Aa00j03s01>> findAllLikeJerarquia(
			Aa00j03s01 filterAa00j03s01, JQGridRequestDto jqGridRequestDto) {
		Aa00j03s01DaoImpl.logger.info("Método findAllLikeJerarquia");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CEDIF03 CEDIF03,t1.NOMBRE03 NOMBRE03,t1.SIT03 SIT03,t1.BLOQ03 BLOQ03,t1.TLFNO03 TLFNO03,t1.USUB03 USUB03,t2.CSITIO02 AA00J02S01CSITIO02,t2.NOMBRE02 AA00J02S01NOMBRE02,t2.SIT02 AA00J02S01SIT02,t2.BLOQ02 AA00J02S01BLOQ02,t2.USUB02 AA00J02S01USUB02 ");
		// FROM
		// StringBuilder from = new
		// StringBuilder("FROM AA00J03S01 t1 ,AA00J02S01 t2 ");
		List<String> from = new ArrayList<String>();
		from.add("AA00J03S01");
		from.add("AA00J02S01");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa00j03s01, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
				mapaWhere, "CEDIF03", "ID_PADRE", "NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j03s01DaoImpl.logger.info("SQL =" + query.toString());
		Aa00j03s01DaoImpl.logger.info("PARAMS =" + params);
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAa00j03s01
	 *            Aa00j03s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Aa00j03s01 filterAa00j03s01,
			JQGridRequestDto jqGridRequestDto) {
		Aa00j03s01DaoImpl.logger.info("Método findAllLikeCountJerarquia");
		// FROM
		// StringBuilder from = new
		// StringBuilder("FROM AA00J03S01 t1 ,AA00J02S01 t2 ");
		List<String> from = new ArrayList<String>();
		from.add("AA00J03S01");
		from.add("AA00J02S01");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa00j03s01, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(
				jqGridRequestDto, mapaWhere, "CEDIF03", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j03s01DaoImpl.logger.info("SQL =" + query.toString());
		Aa00j03s01DaoImpl.logger.info("PARAMS =" + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAa00j03s01
	 *            Aa00j03s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Aa00j03s01>>
	 */
	@Override
	public List<TableRowDto<Aa00j03s01>> findAllChild(
			Aa00j03s01 filterAa00j03s01, JQGridRequestDto jqGridRequestDto) {
		Aa00j03s01DaoImpl.logger.info("Método findAllChild");

		// FROM
		// StringBuilder from = new
		// StringBuilder("FROM AA00J03S01 t1 ,AA00J02S01 t2 ");
		List<String> from = new ArrayList<String>();
		from.add("AA00J03S01");
		from.add("AA00J02S01");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa00j03s01, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(
				jqGridRequestDto, mapaWhere, "CEDIF03", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j03s01DaoImpl.logger.info("SQL =" + query.toString());
		Aa00j03s01DaoImpl.logger.info("PARAMS =" + params);
		return this.jdbcTemplate.query(query.toString(),
				new RowNumResultSetExtractor<Aa00j03s01>(this.rwMapPK,
						"CEDIF03"), params.toArray());
	}

	/**
	 * Devuelve una lista de edificios con sus situaciones
	 * 
	 * @return
	 */
	@Override
	public List<Option> getListForOption(boolean conSalas,
			boolean controlarRespEdif) {
		Aa00j03s01DaoImpl.logger.info("Método getListForOption");
		StringBuffer query = new StringBuffer("");
		query.append(" SELECT cedif03 AS VALUE, NOMBRE03||'(' ||Nombre02||')' AS TEXT");
		query.append("	FROM AA00J03S01 INNER JOIN AA00J02S01 ");
		query.append(" ON AA00J03S01.Csitio03 = AA00J02S01.csitIo02");
		if (conSalas)
			query.append(" WHERE cedif03 in(select cedif10 from aa00j10S01  where cdep10 is null)");
		Aa00j03s01DaoImpl.logger.info("SQL =" + query.toString());
		aa00jPersonaSesion ps = new aa00jSeguridad().getUsuario();
		if (controlarRespEdif && ps.isEsAdmin()
				&& !ps.getEdificioResponsable().equals("-1")) {
			// Tiene edificios hay que obligar a que cedif03 esté en los
			// edificios del usuario
			if (!conSalas)
				query.append(" WHERE ");
			else
				query.append(" AND ");
			query.append(" cedif03 in(");
			StringBuffer str = new StringBuffer();
			boolean first = true;
			for (int i : ps.getEdificiosResponsable()) {
				if (!first) {

					str.append(",");
				}
				first = false;
				str.append(i);
			}
			query.append(str);
			query.append(" )");

		}

		return this.jdbcTemplate.query(query.toString(), this.optionMap);

	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa00j03s01 entity
	 * 
	 * @param aa00j03s01
	 *            Aa00j03s01 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Aa00j03s01 aa00j03s01) {

		StringBuilder where = new StringBuilder(
				Aa00j03s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa00j03s01 != null && aa00j03s01.getCedif03() != null) {
			where.append(" AND t1.CEDIF03 = ?");
			params.add(aa00j03s01.getCedif03());
		}
		if (aa00j03s01 != null && aa00j03s01.getAa00j02s01() != null
				&& aa00j03s01.getAa00j02s01().getCsitio02() != null) {
			where.append(" AND t2.CSITIO02 = ?");
			params.add(aa00j03s01.getAa00j02s01().getCsitio02());
		}
		if (aa00j03s01 != null && aa00j03s01.getAa00j02s01() != null
				&& aa00j03s01.getAa00j02s01().getNombre02() != null) {
			where.append(" AND t2.NOMBRE02 = ?");
			params.add(aa00j03s01.getAa00j02s01().getNombre02());
		}
		if (aa00j03s01 != null && aa00j03s01.getAa00j02s01() != null
				&& aa00j03s01.getAa00j02s01().getSit02() != null) {
			where.append(" AND t2.SIT02 = ?");
			params.add(aa00j03s01.getAa00j02s01().getSit02());
		}
		if (aa00j03s01 != null && aa00j03s01.getAa00j02s01() != null
				&& aa00j03s01.getAa00j02s01().getBloq02() != null) {
			where.append(" AND t2.BLOQ02 = ?");
			params.add(aa00j03s01.getAa00j02s01().getBloq02());
		}
		if (aa00j03s01 != null && aa00j03s01.getAa00j02s01() != null
				&& aa00j03s01.getAa00j02s01().getUsub02() != null) {
			where.append(" AND t2.USUB02 = ?");
			params.add(aa00j03s01.getAa00j02s01().getUsub02());
		}
		if (aa00j03s01 != null && aa00j03s01.getNombre03() != null) {
			where.append(" AND t1.NOMBRE03 = ?");
			params.add(aa00j03s01.getNombre03());
		}
		if (aa00j03s01 != null && aa00j03s01.getSit03() != null) {
			where.append(" AND t1.SIT03 = ?");
			params.add(aa00j03s01.getSit03());
		}
		if (aa00j03s01 != null && aa00j03s01.getBloq03() != null) {
			where.append(" AND t1.BLOQ03 = ?");
			params.add(aa00j03s01.getBloq03());
		}
		if (aa00j03s01 != null && aa00j03s01.getTlfno03() != null) {
			where.append(" AND t1.TLFNO03 = ?");
			params.add(aa00j03s01.getTlfno03());
		}
		if (aa00j03s01 != null && aa00j03s01.getUsub03() != null) {
			where.append(" AND t1.USUB03 = ?");
			params.add(aa00j03s01.getUsub03());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa00j03s01 entity
	 * 
	 * @param aa00j03s01
	 *            Aa00j03s01 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Aa00j03s01 aa00j03s01,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				Aa00j03s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa00j03s01 != null && aa00j03s01.getCedif03() != null) {
			where.append(" AND t1.CEDIF03 = ?");
			params.add(aa00j03s01.getCedif03());
		} else {
			aa00jPersonaSesion ps = new aa00jSeguridad().getUsuario();
			if (ps.isEsAdmin() && !ps.getEdificioResponsable().equals("-1")) {
				// Tiene edificios hay que obligar a que cedif03 esté en los
				// edificios del usuario

				where.append(" AND ");
				where.append(" t1.CEDIF03 in(");
				StringBuffer str = new StringBuffer();
				boolean first = true;
				for (int i : ps.getEdificiosResponsable()) {
					if (!first) {

						str.append(",");
					}
					first = false;
					str.append(i);
				}
				where.append(str);
				where.append(" )");
			}

		}
		if (aa00j03s01 != null && aa00j03s01.getAa00j02s01() != null
				&& aa00j03s01.getAa00j02s01().getCsitio02() != null) {
			where.append(" AND t2.CSITIO02 = ?");
			params.add(aa00j03s01.getAa00j02s01().getCsitio02());
		}
		if (aa00j03s01 != null && aa00j03s01.getAa00j02s01() != null
				&& aa00j03s01.getAa00j02s01().getNombre02() != null) {
			where.append(" AND UPPER(t2.NOMBRE02) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j03s01.getAa00j02s01().getNombre02()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j03s01.getAa00j02s01().getNombre02()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NOMBRE02 IS NOT NULL");
		}
		if (aa00j03s01 != null && aa00j03s01.getAa00j02s01() != null
				&& aa00j03s01.getAa00j02s01().getSit02() != null) {
			where.append(" AND UPPER(t2.SIT02) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j03s01.getAa00j02s01().getSit02().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j03s01.getAa00j02s01().getSit02().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.SIT02 IS NOT NULL");
		}
		if (aa00j03s01 != null && aa00j03s01.getAa00j02s01() != null
				&& aa00j03s01.getAa00j02s01().getBloq02() != null) {
			where.append(" AND t2.BLOQ02 = ?");
			params.add(aa00j03s01.getAa00j02s01().getBloq02());
		}
		if (aa00j03s01 != null && aa00j03s01.getAa00j02s01() != null
				&& aa00j03s01.getAa00j02s01().getUsub02() != null) {
			where.append(" AND UPPER(t2.USUB02) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j03s01.getAa00j02s01().getUsub02().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ aa00j03s01.getAa00j02s01().getUsub02().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.USUB02 IS NOT NULL");
		}
		if (aa00j03s01 != null && aa00j03s01.getNombre03() != null) {
			where.append(" AND UPPER(t1.NOMBRE03) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j03s01.getNombre03().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j03s01.getNombre03().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE03 IS NOT NULL");
		}
		if (aa00j03s01 != null && aa00j03s01.getSit03() != null) {
			where.append(" AND UPPER(t1.SIT03) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j03s01.getSit03().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j03s01.getSit03().toUpperCase() + "%");
			}
			where.append(" AND t1.SIT03 IS NOT NULL");
		}
		if (aa00j03s01 != null && aa00j03s01.getBloq03() != null) {
			where.append(" AND t1.BLOQ03 = ?");
			params.add(aa00j03s01.getBloq03());
		}
		if (aa00j03s01 != null && aa00j03s01.getTlfno03() != null) {
			where.append(" AND UPPER(t1.TLFNO03) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j03s01.getTlfno03().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j03s01.getTlfno03().toUpperCase() + "%");
			}
			where.append(" AND t1.TLFNO03 IS NOT NULL");
		}
		if (aa00j03s01 != null && aa00j03s01.getUsub03() != null) {
			where.append(" AND UPPER(t1.USUB03) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j03s01.getUsub03().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j03s01.getUsub03().toUpperCase() + "%");
			}
			where.append(" AND t1.USUB03 IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Inserts a single row in the Aa00j09s01 table.
	 * 
	 * @param aa00j03s01
	 *            Aa00j03s01
	 * @return Aa00j03s01
	 */
	public Aa00j03s01 addAa00j09s01(Aa00j03s01 aa00j03s01) {
		Aa00j03s01DaoImpl.logger.info("Método addAa00j09s01");
		String query = "INSERT INTO AA00J09S01 " + "( CEDIF09,CRESP09) "
				+ " values (?, ?)";

		List<Aa00j05s01> auxiliarAa00j05s01 = aa00j03s01.getAa00j05s01s();
		Iterator<Aa00j05s01> it = auxiliarAa00j05s01.iterator();
		while (it.hasNext()) {
			Aa00j05s01 aa00j05s01 = (Aa00j05s01) it.next();
			Aa00j03s01DaoImpl.logger.info("SQL =" + query);
			Aa00j03s01DaoImpl.logger
					.info("PARAMS1 =" + aa00j03s01.getCedif03());
			Aa00j03s01DaoImpl.logger
					.info("PARAMS2 =" + aa00j05s01.getCresp05());
			this.jdbcTemplate.update(query, aa00j03s01.getCedif03(),
					aa00j05s01.getCresp05());
		}
		return aa00j03s01;
	}

	/**
	 * Deletes a single row in the Aa00j09s01 table.
	 * 
	 * @param aa00j03s01
	 *            Aa00j03s01
	 * @return
	 */
	public void removeAa00j09s01(Aa00j03s01 aa00j03s01) {
		Aa00j03s01DaoImpl.logger.info("Método removeAa00j09s01");
		String query = "DELETE  FROM AA00J09S01 "
				+ " WHERE CEDIF09=? AND CRESP09=?";
		List<Aa00j05s01> auxiliarAa00j05s01 = aa00j03s01.getAa00j05s01s();
		Iterator<Aa00j05s01> it = auxiliarAa00j05s01.iterator();
		while (it.hasNext()) {
			Aa00j05s01 aa00j05s01 = (Aa00j05s01) it.next();
			Aa00j03s01DaoImpl.logger.info("SQL =" + query);
			Aa00j03s01DaoImpl.logger
					.info("PARAMS1 =" + aa00j03s01.getCedif03());
			Aa00j03s01DaoImpl.logger
					.info("PARAMS2 =" + aa00j05s01.getCresp05());
			this.jdbcTemplate.update(query, aa00j03s01.getCedif03(),
					aa00j05s01.getCresp05());
		}
	}

	public void removeAa00j09s01(Long cedif) {
		Aa00j03s01DaoImpl.logger.info("Método removeAa00j09s01");
		String query = "DELETE  FROM AA00J09S01 " + " WHERE CEDIF09=? ";
		Aa00j03s01DaoImpl.logger.info("SQL =" + query);
		Aa00j03s01DaoImpl.logger.info("PARAMS1 =" + cedif);

		this.jdbcTemplate.update(query, cedif);
	}

	/**
	 * Find a single row in the findAa00j09s01 Many To Many relationship.
	 * 
	 * @param aa00j03s01
	 *            Aa00j03s01
	 * @param aa00j05s01
	 *            Aa00j05s01
	 * @param pagination
	 *            Pagination
	 * @return Aa00j03s01
	 */
	@Transactional(readOnly = true)
	public Aa00j03s01 findAa00j09s01(Aa00j03s01 aa00j03s01,
			Aa00j05s01 aa00j05s01, Pagination pagination) {
		Aa00j03s01DaoImpl.logger.info("Método findAa00j09s01");
		StringBuilder where = new StringBuilder(
				Aa00j03s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		where.append("where t1.CRESP09 = t2.CRESP05 AND t1.CEDIF09=?");

		params.add(aa00j03s01.getCedif03());

		if (aa00j05s01.getCresp05() != null) {
			where.append(" AND t2.CRESP05 = ?");
			params.add(aa00j05s01.getCresp05());
		}
		if (aa00j05s01.getNom05() != null) {
			where.append(" AND t2.NOM05 = ?");
			params.add(aa00j05s01.getNom05());
		}
		if (aa00j05s01.getSit05() != null) {
			where.append(" AND t2.SIT05 = ?");
			params.add(aa00j05s01.getSit05());
		}
		if (aa00j05s01.getBloq05() != null) {
			where.append(" AND t2.BLOQ05 = ?");
			params.add(aa00j05s01.getBloq05());
		}
		if (aa00j05s01.getUsub05() != null) {
			where.append(" AND t2.USUB05 = ?");
			params.add(aa00j05s01.getUsub05());
		}

		StringBuilder query = new StringBuilder(
				"SELECT t2.Cresp05 CRESP05, t2.NOM05 NOM05, t2.SIT05 SIT05, t2.BLOQ05 BLOQ05, t2.USUB05 USUB05 FROM Aa00j09S01 t1,AA00J05S01 t2  ");
		query.append(where);

		StringBuilder order = new StringBuilder(
				Aa00j03s01DaoImpl.STRING_BUILDER_INIT);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" order by " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuilder(PaginationManager.getPaginationQuery(
					pagination, query));
		}
		Aa00j03s01DaoImpl.logger.info("SQL =" + query);

		List<Aa00j05s01> listaHijo = this.jdbcTemplate.query(query.toString(),
				new RowMapper<Aa00j05s01>() {
					public Aa00j05s01 mapRow(ResultSet resultSet, int rowNum)
							throws SQLException {
						return new Aa00j05s01(resultSet.getString("CRESP05"),
								resultSet.getString("NOM05"), resultSet
										.getString("SIT05"), resultSet
										.getInt("BLOQ05"), resultSet
										.getString("USUB05"), null);
					}
				}, params.toArray());
		aa00j03s01.setAa00j05s01s(listaHijo);
		return aa00j03s01;
	}

	/**
	 * Counts rows in the Aa00j09s01 table.
	 * 
	 * @param aa00j03s01
	 *            Aa00j03s01
	 * @param aa00j05s01
	 *            Aa00j05s01
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAa00j09s01Count(Aa00j03s01 aa00j03s01, Aa00j05s01 aa00j05s01) {
		Aa00j03s01DaoImpl.logger.info("Método findAa00j09s01Count");
		StringBuilder where = new StringBuilder(
				Aa00j03s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();
		where.append("where t1.CRESP09 = t2.CRESP05 AND t1.CEDIF09=?");

		params.add(aa00j03s01.getCedif03());

		if (aa00j05s01.getCresp05() != null) {
			where.append(" AND t2.CRESP05 = ?");
			params.add(aa00j05s01.getCresp05());
		}
		if (aa00j05s01.getNom05() != null) {
			where.append(" AND t2.NOM05 = ?");
			params.add(aa00j05s01.getNom05());
		}
		if (aa00j05s01.getSit05() != null) {
			where.append(" AND t2.SIT05 = ?");
			params.add(aa00j05s01.getSit05());
		}
		if (aa00j05s01.getBloq05() != null) {
			where.append(" AND t2.BLOQ05 = ?");
			params.add(aa00j05s01.getBloq05());
		}
		if (aa00j05s01.getUsub05() != null) {
			where.append(" AND t2.USUB05 = ?");
			params.add(aa00j05s01.getUsub05());
		}

		StringBuilder query = new StringBuilder(
				"SELECT count(1) FROM Aa00j09S01 t1,AA00J05S01 t2  ");
		query.append(where);
		Aa00j03s01DaoImpl.logger.info("SQL =" + query);
		Aa00j03s01DaoImpl.logger.info("PARAMS =" + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	public boolean existe(String nombre, Long codigoNoIncluir) {
		Aa00j03s01DaoImpl.logger.info("Método existe");
		if (codigoNoIncluir != null && codigoNoIncluir > 0) {
			String query = "SELECT COUNT(1) FROM AA00J03S01 WHERE UPPER(NOMBRE03) = UPPER(?) AND CEDIF03 <> ?";
			Aa00j03s01DaoImpl.logger.info("SQL =" + query);
			Aa00j03s01DaoImpl.logger.info("PARAMS1 =" + nombre);
			Aa00j03s01DaoImpl.logger.info("PARAMS2 =" + codigoNoIncluir);
			return this.jdbcTemplate
					.queryForInt(query, nombre, codigoNoIncluir) > 0;
		} else {
			String query = "SELECT COUNT(1) FROM AA00J03S01 WHERE UPPER(NOMBRE03) = UPPER(?)";
			Aa00j03s01DaoImpl.logger.info("SQL =" + query);
			Aa00j03s01DaoImpl.logger.info("PARAMS1 =" + nombre);

			return this.jdbcTemplate.queryForInt(query, nombre) > 0;
		}
	}

	public boolean existeSitio(Long csitio03) {
		Aa00j03s01DaoImpl.logger.info("Método existeSitio");
		String query = "SELECT COUNT(1) FROM AA00J03S01 WHERE CSITIO03 = ?";
		Aa00j03s01DaoImpl.logger.info("SQL =" + query);
		Aa00j03s01DaoImpl.logger.info("PARAMS1 =" + csitio03);

		return this.jdbcTemplate.queryForInt(query, csitio03) > 0;
	}

	public boolean existeResponsable(String cresp09) {
		Aa00j03s01DaoImpl.logger.info("Método existeResponsable");
		String query = "SELECT COUNT(1) FROM AA00J09S01 WHERE UPPER(CRESP09) = UPPER(?)";
		Aa00j03s01DaoImpl.logger.info("SQL =" + query);
		Aa00j03s01DaoImpl.logger.info("PARAMS1 =" + cresp09);

		return this.jdbcTemplate.queryForInt(query, cresp09) > 0;
	}

	public List<Aa00j03s01> obtenerCombo() {
		Aa00j03s01DaoImpl.logger.info("Método obtenerCombo");
		StringBuilder query = new StringBuilder(
				"SELECT t1.CEDIF03 CEDIF03,t1.NOMBRE03 NOMBRE03 ");
		query.append("FROM AA00J03S01 t1 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.SIT03=? ");
		query.append(where);

		List<Object> params = new ArrayList<Object>();
		params.add(aa00jConstantes.SITUACION_ALTA);
		Aa00j03s01DaoImpl.logger.info("SQL =" + query);
		Aa00j03s01DaoImpl.logger.info("PARAMS =" + params);
		return (List<Aa00j03s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMapCombo, params.toArray());
	}

	/**
	 * Devuelve los edificios en los que hay salas que tienen que aparecer en un
	 * listado especial de edificios
	 * 
	 * @return
	 */
	public List<Option> obtenerComboListado() {
		Aa00j03s01DaoImpl.logger.info("Método obtenerComboListado");
		StringBuilder query = new StringBuilder();
		if (LocaleContextHolder.getLocale().getLanguage().contains("eu"))
			query.append("SELECT 'E'|| CEDIF03 as value, NOMBRE03|| ' eraikineko aretoak' as text");
		else
			query.append("SELECT 'E'|| CEDIF03 as value, 'Salas del edificio '||NOMBRE03 as text");
		query.append(" FROM aa00j03S01");
		query.append(" WHERE cedif03 IN");
		query.append(" (SELECT DISTINCT cedif10 FROM aa00j10S01 WHERE infedif10=1)");
		query.append("  AND SIT03=? ");
		List<Object> params = new ArrayList<Object>();
		params.add(aa00jConstantes.SITUACION_ALTA);
		Aa00j03s01DaoImpl.logger.info("SQL =" + query.toString());
		Aa00j03s01DaoImpl.logger.info("PARAMS =" + params);
		return (List<Option>) this.jdbcTemplate.query(query.toString(),
				this.optionMap, params.toArray());
	}

	public Long obtenerEdificioResponsable(String cresp09) {
		Aa00j03s01DaoImpl.logger.info("Método obtenerEdificioResponsable");
		String query = "SELECT CEDIF09 FROM AA00J09S01 WHERE CRESP09 = UPPER(?)";
		Aa00j03s01DaoImpl.logger.info("SQL =" + query);
		Aa00j03s01DaoImpl.logger.info("PARAMS =" + cresp09);
		return this.jdbcTemplate.queryForLong(query, cresp09);
	}

}