package com.ejie.aa00j.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa00j.classes.aa00jConstantes;
import com.ejie.aa00j.model.Aa00j02s01;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa00j02s01DaoImpl generated by UDA, 16-oct-2013 13:02:12.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class Aa00j02s01DaoImpl implements Aa00j02s01Dao {
	private JdbcTemplate jdbcTemplate;
	private static final Logger logger = LoggerFactory
			.getLogger(Aa00j02s01DaoImpl.class);
	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Aa00j02s01> rwMap = new RowMapper<Aa00j02s01>() {
		public Aa00j02s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa00j02s01(resultSet.getLong("CSITIO02"),
					resultSet.getString("NOMBRE02"),
					resultSet.getString("SIT02"), resultSet.getInt("BLOQ02"),
					resultSet.getString("USUB02"));
		}
	};

	private RowMapper<Aa00j02s01> rwMapPK = new RowMapper<Aa00j02s01>() {
		public Aa00j02s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa00j02s01(resultSet.getLong("CSITIO02"));
		}
	};

	private RowMapper<Aa00j02s01> rwMapCombo = new RowMapper<Aa00j02s01>() {
		public Aa00j02s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa00j02s01(resultSet.getLong("CSITIO02"),
					resultSet.getString("NOMBRE02"), "", 0, "");
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Aa00j02s01>> rwMapJerarquia = new RowMapper<JerarquiaDto<Aa00j02s01>>() {
		public JerarquiaDto<Aa00j02s01> mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Aa00j02s01 aa00j02s01 = new Aa00j02s01(
					resultSet.getLong("CSITIO02"),
					resultSet.getString("NOMBRE02"),
					resultSet.getString("SIT02"), resultSet.getInt("BLOQ02"),
					resultSet.getString("USUB02"));

			JerarquiaDto<Aa00j02s01> jerarquia = new JerarquiaDto<Aa00j02s01>();
			jerarquia.setModel(aa00j02s01);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet
					.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet
					.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Aa00j02s01 table.
	 * 
	 * @param aa00j02s01
	 *            Aa00j02s01
	 * @return Aa00j02s01
	 */
	public Aa00j02s01 add(final Aa00j02s01 aa00j02s01) {
		if (aa00j02s01.getSit02() == null
				|| aa00j02s01.getSit02().length() == 0)
			aa00j02s01.setSit02(aa00jConstantes.SITUACION_ALTA);
		Aa00j02s01DaoImpl.logger.info("Método add");
		final String queryUltimoId = "(SELECT NVL(MAX(TO_NUMBER(CSITIO02)), 0) + 1 FROM AA00J02S01)";
		final String query = "INSERT INTO AA00J02S01 (CSITIO02, NOMBRE02, SIT02, BLOQ02, USUB02) VALUES ("
				+ queryUltimoId + ",?,?,?,?)";
		Aa00j02s01DaoImpl.logger.info("SQL = " + query);
		Aa00j02s01DaoImpl.logger.info("PARAM1="
				+ aa00j02s01.getNombre02().trim());
		Aa00j02s01DaoImpl.logger.info("PARAM2=" + aa00j02s01.getSit02());
		Aa00j02s01DaoImpl.logger.info("PARAM3=" + 0);
		Aa00j02s01DaoImpl.logger.info("PARAM4=null");
		KeyHolder keyHolder = new GeneratedKeyHolder();

		jdbcTemplate.update(new PreparedStatementCreator() {
			public PreparedStatement createPreparedStatement(
					Connection connection) throws SQLException {
				PreparedStatement ps = connection.prepareStatement(query,
						new String[] { "CSITIO02" });
				ps.setObject(1, aa00j02s01.getNombre02().trim());
				ps.setObject(2, aa00j02s01.getSit02());
				ps.setObject(3, 0);
				ps.setObject(4, null);
				return ps;
			}
		}, keyHolder);

		aa00j02s01.setCsitio02(keyHolder.getKey().longValue());
		Aa00j02s01DaoImpl.logger.info("SQL" + query);
		return aa00j02s01;
	}

	/**
	 * Updates a single row in the Aa00j02s01 table.
	 * 
	 * @param aa00j02s01
	 *            Aa00j02s01
	 * @return Aa00j02s01
	 */
	public Aa00j02s01 update(Aa00j02s01 aa00j02s01) {
		if (aa00j02s01.getSit02() == null
				|| aa00j02s01.getSit02().length() == 0)
			aa00j02s01.setSit02(aa00jConstantes.SITUACION_ALTA);
		Aa00j02s01DaoImpl.logger.info("Método update");
		String query = "UPDATE AA00J02S01 SET NOMBRE02=?, SIT02=?, BLOQ02=?, USUB02=? WHERE CSITIO02=?";
		Aa00j02s01DaoImpl.logger.info("UPDATE");
		Aa00j02s01DaoImpl.logger.info("SQL = " + query);
		Aa00j02s01DaoImpl.logger.info("PARAM1="
				+ aa00j02s01.getNombre02().trim());
		Aa00j02s01DaoImpl.logger.info("PARAM2=" + aa00j02s01.getSit02());
		Aa00j02s01DaoImpl.logger.info("PARAM3=" + aa00j02s01.getBloq02());
		Aa00j02s01DaoImpl.logger.info("PARAM4=" + aa00j02s01.getUsub02());
		Aa00j02s01DaoImpl.logger.info("PARAM4=" + aa00j02s01.getCsitio02());
		this.jdbcTemplate.update(query, aa00j02s01.getNombre02().trim(),
				aa00j02s01.getSit02(), aa00j02s01.getBloq02(),
				aa00j02s01.getUsub02(), aa00j02s01.getCsitio02());

		return aa00j02s01;
	}

	/**
	 * Finds a single row in the Aa00j02s01 table.
	 * 
	 * @param aa00j02s01
	 *            Aa00j02s01
	 * @return Aa00j02s01
	 */
	@Transactional(readOnly = true)
	public Aa00j02s01 find(Aa00j02s01 aa00j02s01) {
		Aa00j02s01DaoImpl.logger.info("Método find");
		String query = "SELECT t1.CSITIO02 CSITIO02, t1.NOMBRE02 NOMBRE02, t1.SIT02 SIT02, t1.BLOQ02 BLOQ02, t1.USUB02 USUB02 FROM AA00J02S01 t1  WHERE t1.CSITIO02 = ?  ";

		List<Aa00j02s01> aa00j02s01List = this.jdbcTemplate.query(query,
				this.rwMap, aa00j02s01.getCsitio02());
		Aa00j02s01DaoImpl.logger.info("find");
		Aa00j02s01DaoImpl.logger.info("SQL = " + query);
		Aa00j02s01DaoImpl.logger.info("PARAM1=" + aa00j02s01.getCsitio02());

		return (Aa00j02s01) DataAccessUtils.uniqueResult(aa00j02s01List);
	}

	/**
	 * Removes a single row in the Aa00j02s01 table.
	 * 
	 * @param aa00j02s01
	 *            Aa00j02s01
	 * @return
	 */
	public void remove(Aa00j02s01 aa00j02s01) {
		String query = "DELETE FROM AA00J02S01 WHERE CSITIO02=?";

		Aa00j02s01DaoImpl.logger.info("DELETE");
		Aa00j02s01DaoImpl.logger.info("SQL = " + query);
		Aa00j02s01DaoImpl.logger.info("PARAM1=" + aa00j02s01.getCsitio02());
		this.jdbcTemplate.update(query, aa00j02s01.getCsitio02());
	}

	/**
	 * Finds a list of rows in the Aa00j02s01 table.
	 * 
	 * @param aa00j02s01
	 *            Aa00j02s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa00j02s01>
	 */
	@Transactional(readOnly = true)
	public List<Aa00j02s01> findAll(Aa00j02s01 aa00j02s01,
			JQGridRequestDto jqGridRequestDto) {
		Aa00j02s01DaoImpl.logger.info("Método findAll");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CSITIO02 CSITIO02,t1.NOMBRE02 NOMBRE02,t1.SIT02 SIT02,t1.BLOQ02 BLOQ02,t1.USUB02 USUB02 ");
		query.append("FROM AA00J02S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa00j02s01);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		Aa00j02s01DaoImpl.logger.info("findAll");
		Aa00j02s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa00j02s01DaoImpl.logger.info("PARAMS" + params);

		return (List<Aa00j02s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Aa00j02s01 table using like.
	 * 
	 * @param aa00j02s01
	 *            Aa00j02s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa00j02s01>
	 */
	@Transactional(readOnly = true)
	public List<Aa00j02s01> findAllLike(Aa00j02s01 aa00j02s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		Aa00j02s01DaoImpl.logger.info("Método findAllLike");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CSITIO02 CSITIO02,t1.NOMBRE02 NOMBRE02,t1.SIT02 SIT02,t1.BLOQ02 BLOQ02,t1.USUB02 USUB02 ");
		query.append("FROM AA00J02S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa00j02s01, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		Aa00j02s01DaoImpl.logger.info("findalllike");
		Aa00j02s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa00j02s01DaoImpl.logger.info("PARAMS = " + params);

		return (List<Aa00j02s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Aa00j02s01 table.
	 * 
	 * @param aa00j02s01
	 *            Aa00j02s01
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Aa00j02s01 aa00j02s01) {
		Aa00j02s01DaoImpl.logger.info("Método findAllCount");
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA00J02S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa00j02s01);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j02s01DaoImpl.logger.info("findAllCount");
		Aa00j02s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa00j02s01DaoImpl.logger.info("PARAMS=" + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Aa00j02s01 table using like.
	 * 
	 * @param aa00j02s01
	 *            Aa00j02s01
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Aa00j02s01 aa00j02s01, Boolean startsWith) {
		Aa00j02s01DaoImpl.logger.info("Método findAllLikeCount");
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA00J02S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa00j02s01, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j02s01DaoImpl.logger.info("findAllLikeCount");
		Aa00j02s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa00j02s01DaoImpl.logger.info("PARAMs=" + params);

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Aa00j02s01 selected for rup_table
	 * 
	 * @param aa00j02s01
	 *            Aa00j02s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j02s01>>
	 */
	@Override
	public List<TableRowDto<Aa00j02s01>> reorderSelection(
			Aa00j02s01 aa00j02s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		Aa00j02s01DaoImpl.logger.info("Método reorderSelection");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CSITIO02 CSITIO02,t1.NOMBRE02 NOMBRE02,t1.SIT02 SIT02,t1.BLOQ02 BLOQ02,t1.USUB02 USUB02 ");
		// FROM
		query.append("FROM AA00J02S01 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa00j02s01, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, Aa00j02s01.class, filterParamList,
				"CSITIO02");
		Aa00j02s01DaoImpl.logger.info("findAllLikeCount");
		Aa00j02s01DaoImpl.logger.info("SQL = "
				+ sbReorderSelectionSQL.toString());
		Aa00j02s01DaoImpl.logger.info("PARAMs=" + filterParamList);
		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa00j02s01>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * @param filterParams
	 *            Aa00j02s01
	 * @param searchParams
	 *            Aa00j02s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j02s01>>
	 */
	@Override
	public List<TableRowDto<Aa00j02s01>> search(Aa00j02s01 filterParams,
			Aa00j02s01 searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		Aa00j02s01DaoImpl.logger.info("Método search");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CSITIO02 CSITIO02,t1.NOMBRE02 NOMBRE02,t1.SIT02 SIT02,t1.BLOQ02 BLOQ02,t1.USUB02 USUB02 ");
		// FROM
		query.append("FROM AA00J02S01 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, Aa00j02s01.class, filterParamList,
				searchSQL, searchParamList, from_alias, "CSITIO02");
		Aa00j02s01DaoImpl.logger.info("findAllLikeCount");
		Aa00j02s01DaoImpl.logger.info("SQL = "
				+ sbReorderSelectionSQL.toString());
		Aa00j02s01DaoImpl.logger.info("PARAMs=" + filterParamList);
		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa00j02s01>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 * 
	 * @param filteraa00j02s01
	 *            Aa00j02s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Aa00j02s01 filteraa00j02s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		Aa00j02s01DaoImpl.logger.info("Método removeMultiple");
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.CSITIO02 CSITIO02,t1.NOMBRE02 NOMBRE02,t1.SIT02 SIT02,t1.BLOQ02 BLOQ02,t1.USUB02 USUB02 ");
		// FROM
		query.append("FROM AA00J02S01 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filteraa00j02s01,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto, Aa00j02s01.class,
						query, params, "CSITIO02");
		Aa00j02s01DaoImpl.logger.info("removeMultiple");
		Aa00j02s01DaoImpl.logger
				.info("SQL = " + sbRemoveMultipleSQL.toString());
		Aa00j02s01DaoImpl.logger.info("PARAMs=" + params);
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical Aa00j02s01 table.
	 * 
	 * @param filterAa00j02s01
	 *            Aa00j02s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Aa00j02s01>>
	 */
	@Override
	public List<JerarquiaDto<Aa00j02s01>> findAllLikeJerarquia(
			Aa00j02s01 filterAa00j02s01, JQGridRequestDto jqGridRequestDto) {
		Aa00j02s01DaoImpl.logger.info("Método findAllLikeJerarquia");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CSITIO02 CSITIO02,t1.NOMBRE02 NOMBRE02,t1.SIT02 SIT02,t1.BLOQ02 BLOQ02,t1.USUB02 USUB02 ");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA00J02S01 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA00J02S01");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa00j02s01, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
				mapaWhere, "CSITIO02", "ID_PADRE", "NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}
		Aa00j02s01DaoImpl.logger.info("SQL" + query.toString());

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j02s01DaoImpl.logger.info("findAllLikeJerarquia");
		Aa00j02s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa00j02s01DaoImpl.logger.info("PARAMs=" + params);
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAa00j02s01
	 *            Aa00j02s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Aa00j02s01 filterAa00j02s01,
			JQGridRequestDto jqGridRequestDto) {
		Aa00j02s01DaoImpl.logger.info("Método findAllLikeCountJerarquia");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA00J02S01 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA00J02S01");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa00j02s01, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(
				jqGridRequestDto, mapaWhere, "CSITIO02", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j02s01DaoImpl.logger.info("findAllLikeCountJerarquia");
		Aa00j02s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa00j02s01DaoImpl.logger.info("PARAMs=" + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAa00j02s01
	 *            Aa00j02s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Aa00j02s01>>
	 */
	@Override
	public List<TableRowDto<Aa00j02s01>> findAllChild(
			Aa00j02s01 filterAa00j02s01, JQGridRequestDto jqGridRequestDto) {
		Aa00j02s01DaoImpl.logger.info("Método findAllChild");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA00J02S01 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA00J02S01");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa00j02s01, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)

		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(
				jqGridRequestDto, mapaWhere, "CSITIO02", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa00j02s01DaoImpl.logger.info("findAllChild");
		Aa00j02s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa00j02s01DaoImpl.logger.info("PARAMs=" + params);
		return this.jdbcTemplate.query(query.toString(),
				new RowNumResultSetExtractor<Aa00j02s01>(this.rwMapPK,
						"CSITIO02"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa00j02s01 entity
	 * 
	 * @param aa00j02s01
	 *            Aa00j02s01 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Aa00j02s01 aa00j02s01) {

		StringBuilder where = new StringBuilder(
				Aa00j02s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa00j02s01 != null && aa00j02s01.getCsitio02() != null) {
			where.append(" AND t1.CSITIO02 = ?");
			params.add(aa00j02s01.getCsitio02());
		}
		if (aa00j02s01 != null && aa00j02s01.getNombre02() != null) {
			where.append(" AND t1.NOMBRE02 = ?");
			params.add(aa00j02s01.getNombre02());
		}
		if (aa00j02s01 != null && aa00j02s01.getSit02() != null) {
			where.append(" AND t1.SIT02 = ?");
			params.add(aa00j02s01.getSit02());
		}
		if (aa00j02s01 != null && aa00j02s01.getBloq02() != null) {
			where.append(" AND t1.BLOQ02 = ?");
			params.add(aa00j02s01.getBloq02());
		}
		if (aa00j02s01 != null && aa00j02s01.getUsub02() != null) {
			where.append(" AND t1.USUB02 = ?");
			params.add(aa00j02s01.getUsub02());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa00j02s01 entity
	 * 
	 * @param aa00j02s01
	 *            Aa00j02s01 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Aa00j02s01 aa00j02s01,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				Aa00j02s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa00j02s01 != null && aa00j02s01.getCsitio02() != null) {
			where.append(" AND t1.CSITIO02 = ?");
			params.add(aa00j02s01.getCsitio02());
		}
		if (aa00j02s01 != null && aa00j02s01.getNombre02() != null) {
			where.append(" AND UPPER(t1.NOMBRE02) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j02s01.getNombre02().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j02s01.getNombre02().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE02 IS NOT NULL");
		}
		if (aa00j02s01 != null && aa00j02s01.getSit02() != null) {
			where.append(" AND UPPER(t1.SIT02) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j02s01.getSit02().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j02s01.getSit02().toUpperCase() + "%");
			}
			where.append(" AND t1.SIT02 IS NOT NULL");
		}
		if (aa00j02s01 != null && aa00j02s01.getBloq02() != null) {
			where.append(" AND t1.BLOQ02 = ?");
			params.add(aa00j02s01.getBloq02());
		}
		if (aa00j02s01 != null && aa00j02s01.getUsub02() != null) {
			where.append(" AND UPPER(t1.USUB02) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa00j02s01.getUsub02().toUpperCase() + "%");
			} else {
				params.add("%" + aa00j02s01.getUsub02().toUpperCase() + "%");
			}
			where.append(" AND t1.USUB02 IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	public List<Aa00j02s01> obtenerCombo() {
		Aa00j02s01DaoImpl.logger.info("Método obtenerCombo");
		StringBuilder query = new StringBuilder(
				"SELECT t1.CSITIO02 CSITIO02,t1.NOMBRE02 NOMBRE02 ");
		query.append("FROM AA00J02S01 t1 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.SIT02=? ");
		query.append(where);

		List<Object> params = new ArrayList<Object>();
		params.add(aa00jConstantes.SITUACION_ALTA);
		Aa00j02s01DaoImpl.logger.info("obtenerCombo");
		Aa00j02s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa00j02s01DaoImpl.logger.info("PARAMs=" + params);
		return (List<Aa00j02s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMapCombo, params.toArray());
	}

	public Aa00j02s01 anyadir(String nombre) {
		Aa00j02s01DaoImpl.logger.info("Método anyadir");
		Aa00j02s01 aa00j02s01 = new Aa00j02s01(null, nombre,
				aa00jConstantes.SITUACION_ALTA, 0, null, null);
		return this.add(aa00j02s01);
	}

	public boolean existe(String nombre, Long codigoNoIncluir) {
		Aa00j02s01DaoImpl.logger.info("Método existe");
		if (codigoNoIncluir != null && codigoNoIncluir > 0) {
			String query = "SELECT COUNT(1) FROM AA00J02S01 WHERE UPPER(NOMBRE02) = UPPER(?) AND CSITIO02 <> ?";

			Aa00j02s01DaoImpl.logger.info("existe");
			Aa00j02s01DaoImpl.logger.info("SQL = " + query);
			Aa00j02s01DaoImpl.logger.info("PARAM1=" + nombre);
			Aa00j02s01DaoImpl.logger.info("PARAM2=" + codigoNoIncluir);
			return this.jdbcTemplate
					.queryForInt(query, nombre, codigoNoIncluir) > 0;
		} else {
			String query = "SELECT COUNT(1) FROM AA00J02S01 WHERE UPPER(NOMBRE02) = UPPER(?)";
			Aa00j02s01DaoImpl.logger.info("existe");
			Aa00j02s01DaoImpl.logger.info("SQL = " + query);
			Aa00j02s01DaoImpl.logger.info("PARAM1=" + nombre);
			return this.jdbcTemplate.queryForInt(query, nombre) > 0;
		}
	}
}