/*
 * Decompiled with CFR 0.152.
 */
package w08.com.ejie.y31.service.impl;

import com.ejie.y31.exception.Y31JanoServiceAccesDeniedException;
import com.ejie.y31.exception.Y31JanoServiceDestinationPathException;
import com.ejie.y31.exception.Y31JanoServiceEventJmsException;
import com.ejie.y31.exception.Y31JanoServiceFileAlreadyExistException;
import com.ejie.y31.exception.Y31JanoServiceFileNameFormatException;
import com.ejie.y31.exception.Y31JanoServiceFileNotFoundException;
import com.ejie.y31.exception.Y31JanoServiceGenericException;
import com.ejie.y31.exception.Y31JanoServiceMongoDbGenericException;
import com.ejie.y31.exception.Y31JanoServiceOracleGenericException;
import com.ejie.y31.exception.Y31JanoServiceTraceJmsException;
import com.ejie.y31.exception.Y31RemoteExceptionAbstractFactory;
import com.ejie.y31.service.Y31JanoService;
import com.ejie.y31.vo.Y31AttachmentBean;
import com.ejie.y31.vo.Y31JanoServiceTrace;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Properties;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import net.sf.json.JsonConfig;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.MultipartPostMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import w08.com.ejie.y31.service.impl.Y31JanoMultipartInputStreamPartSrc;

public class Y31JanoServiceImpl
implements Y31JanoService {
    public static final String JANO_REST_END_POINT;
    public static final String JANO_REST_MOVE_OPERATION = "Y31JanoServiceMoveServlet";
    public static final String JANO_REST_COPY_OPERATION = "Y31JanoServiceCopyServlet";
    public static final String JANO_REST_GET_OPERATION = "Y31JanoServiceGetServlet";
    public static final String JANO_REST_DELETE_OPERATION = "Y31JanoServiceDeleteServlet";
    public static final String JANO_REST_INFO_OPERATION = "Y31JanoServiceInfoServlet";
    public static final String JANO_REST_PUT_OPERATION = "Y31JanoServicePutServlet";
    public static final String JANO_REST_LIST_OPERATION = "Y31JanoServiceListServlet";
    public static final String JANO_XLNETS_VALIDATOR_OPERATION = "Y31JanoServiceXlnetsDocumentValidatorServlet";
    public static final String JANO_OPERATION_SUFIX;
    private static final String UNICODE = "\u00c0\u00e0\u00c8\u00e8\u00cc\u00ec\u00d2\u00f2\u00d9\u00f9\u00c1\u00e1\u00c9\u00e9\u00cd\u00ed\u00d3\u00f3\u00da\u00fa\u00dd\u00fd\u00c2\u00e2\u00ca\u00ea\u00ce\u00ee\u00d4\u00f4\u00db\u00fb\u0176\u0177\u00c3\u00e3\u00d5\u00f5\u00d1\u00f1\u00c4\u00e4\u00cb\u00eb\u00cf\u00ef\u00d6\u00f6\u00dc\u00fc\u0178\u00ff\u00c5\u00e5\u00c7\u00e7\u0150\u0151\u0170\u0171";
    private static final String PLAIN_ASCII = "AaEeIiOoUuAaEeIiOoUuYyAaEeIiOoUuYyAaOoNnAaEeIiOoUuYyAaCcOoUu";
    private static Y31JanoService instance;

    private Y31JanoServiceImpl() {
        instance = this;
    }

    public static Y31JanoService getInstance() {
        if (instance == null) {
            new Y31JanoServiceImpl();
        }
        return instance;
    }

    public InputStream get(Document xlnetsToken, String path) throws Y31JanoServiceGenericException, Y31JanoServiceFileNotFoundException, Y31JanoServiceFileNameFormatException, Y31JanoServiceMongoDbGenericException, Y31JanoServiceMongoDbGenericException, Y31JanoServiceOracleGenericException, Y31JanoServiceAccesDeniedException {
        InputStream is;
        block15: {
            String url = JANO_REST_END_POINT + "/" + JANO_REST_GET_OPERATION + JANO_OPERATION_SUFIX;
            HttpClient client = new HttpClient();
            int statusCode = -1;
            is = null;
            path = Y31JanoServiceImpl.normalize(path);
            long t0 = System.currentTimeMillis();
            long t1 = System.currentTimeMillis();
            boolean success = true;
            String errorMessge = null;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(baos, true);
            PostMethod method = null;
            try {
                method = new PostMethod(url);
                method.addParameter("xlnets_token", Y31JanoServiceImpl.document2String(xlnetsToken));
                method.addParameter("hadoop_file_path", path);
                statusCode = client.executeMethod((HttpMethod)method);
                if (statusCode != 200) {
                    success = false;
                    errorMessge = "Error en la comunicaci\u00f3n remota con " + url + " " + method.getStatusLine();
                    try {
                        String ccc = null;
                        if (method.getResponseHeader("HTTP_ERROR_CODE_TRANSLATE") != null) {
                            ccc = method.getResponseHeader("HTTP_ERROR_CODE_TRANSLATE").getValue();
                        }
                        Y31RemoteExceptionAbstractFactory.buildException((int)statusCode, (String)method.getResponseBodyAsString(), (String)ccc);
                        break block15;
                    }
                    catch (Y31JanoServiceDestinationPathException e) {
                        throw new Y31JanoServiceGenericException((Throwable)e);
                    }
                    catch (Y31JanoServiceFileAlreadyExistException e) {
                        throw new Y31JanoServiceGenericException((Throwable)e);
                    }
                    catch (Y31JanoServiceTraceJmsException e) {
                        throw new Y31JanoServiceGenericException((Throwable)e);
                    }
                    catch (Y31JanoServiceEventJmsException e) {
                        throw new Y31JanoServiceGenericException((Throwable)e);
                    }
                }
                is = method.getResponseBodyAsStream();
            }
            catch (HttpException e) {
                e.printStackTrace(pw);
                success = false;
                throw new Y31JanoServiceGenericException((Throwable)e);
            }
            catch (IOException e) {
                e.printStackTrace(pw);
                success = false;
                throw new Y31JanoServiceGenericException((Throwable)e);
            }
            catch (Y31JanoServiceAccesDeniedException e) {
                e.printStackTrace(pw);
                success = false;
                throw new Y31JanoServiceAccesDeniedException((Throwable)e);
            }
            finally {
                t1 = System.currentTimeMillis();
                if (!success && errorMessge == null) {
                    errorMessge = ((Object)baos).toString();
                }
                Y31JanoServiceTrace item = new Y31JanoServiceTrace("get", null, null, "dni-nombre", null, path, t0, t1, null, new Boolean(success), errorMessge, t1 - t0, null, "remote");
            }
        }
        return is;
    }

    public Y31AttachmentBean put(Document xlnetsToken, InputStream file, String path, Long ttl) throws Y31JanoServiceGenericException, Y31JanoServiceFileNameFormatException, Y31JanoServiceFileNameFormatException, Y31JanoServiceMongoDbGenericException, Y31JanoServiceMongoDbGenericException, Y31JanoServiceEventJmsException, Y31JanoServiceAccesDeniedException {
        return this.put(xlnetsToken, file, path, false, ttl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Y31AttachmentBean put(Document xlnetsToken, InputStream file, String path, boolean preserveName, Long ttl) throws Y31JanoServiceGenericException, Y31JanoServiceFileNameFormatException, Y31JanoServiceFileNameFormatException, Y31JanoServiceMongoDbGenericException, Y31JanoServiceMongoDbGenericException, Y31JanoServiceEventJmsException, Y31JanoServiceAccesDeniedException {
        path = Y31JanoServiceImpl.normalize(path);
        String url = JANO_REST_END_POINT + "/" + JANO_REST_PUT_OPERATION + JANO_OPERATION_SUFIX;
        HttpClient client = new HttpClient();
        long t0 = System.currentTimeMillis();
        long t1 = System.currentTimeMillis();
        boolean success = true;
        String errorMessge = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos, true);
        Y31AttachmentBean a = new Y31AttachmentBean();
        Y31AttachmentBean bean = null;
        MultipartPostMethod method = null;
        int statusCode = -1;
        try {
            try {
                method = new MultipartPostMethod(url);
                method.addParameter("xlnets_token", Y31JanoServiceImpl.document2String(xlnetsToken));
                method.addParameter("hadoop_file_path", path);
                method.addParameter("y31_ttl", ttl + "");
                method.addParameter("hadoop_preserve_name", preserveName + "");
                Y31JanoMultipartInputStreamPartSrc p = new Y31JanoMultipartInputStreamPartSrc(file, Y31JanoServiceImpl.getFileNameFromCompletPath(path));
                method.addPart((Part)new FilePart("filepart1", (PartSource)p));
                statusCode = client.executeMethod((HttpMethod)method);
                if (statusCode != 200) {
                    success = false;
                    errorMessge = "Error en la comunicaci\u00f3n remota con " + url + " " + method.getStatusLine();
                    try {
                        String ccc = null;
                        if (method.getResponseHeader("HTTP_ERROR_CODE_TRANSLATE") != null) {
                            ccc = method.getResponseHeader("HTTP_ERROR_CODE_TRANSLATE").getValue();
                        }
                        Y31RemoteExceptionAbstractFactory.buildException((int)statusCode, (String)method.getResponseBodyAsString(), (String)ccc);
                    }
                    catch (Y31JanoServiceDestinationPathException e) {
                        throw new Y31JanoServiceGenericException((Throwable)e);
                    }
                    catch (Y31JanoServiceFileAlreadyExistException e) {
                        throw new Y31JanoServiceGenericException((Throwable)e);
                    }
                    catch (Y31JanoServiceTraceJmsException e) {
                        throw new Y31JanoServiceGenericException((Throwable)e);
                    }
                    catch (Y31JanoServiceFileNotFoundException e) {
                        throw new Y31JanoServiceGenericException((Throwable)e);
                    }
                }
                String responseBody = method.getResponseBodyAsString();
                JSONObject jsonObject = (JSONObject)JSONSerializer.toJSON((Object)responseBody);
                JsonConfig jsonConfig = new JsonConfig();
                jsonConfig.setRootClass(Y31AttachmentBean.class);
                bean = (Y31AttachmentBean)JSONSerializer.toJava((JSON)jsonObject, (JsonConfig)jsonConfig);
            }
            catch (HttpException e) {
                e.printStackTrace(pw);
                success = false;
                throw new Y31JanoServiceGenericException((Throwable)e);
            }
            catch (IOException e) {
                e.printStackTrace(pw);
                success = false;
                throw new Y31JanoServiceGenericException((Throwable)e);
            }
            catch (Y31JanoServiceAccesDeniedException e) {
                e.printStackTrace(pw);
                success = false;
                throw new Y31JanoServiceAccesDeniedException((Throwable)e);
            }
            Object var25_30 = null;
        }
        catch (Throwable throwable) {
            Object var25_31 = null;
            method.releaseConnection();
            t1 = System.currentTimeMillis();
            if (bean != null) {
                a = bean;
            }
            if (!success && errorMessge == null) {
                errorMessge = ((Object)baos).toString();
            }
            Y31JanoServiceTrace item = new Y31JanoServiceTrace("put", a.getSize(), a.getTtl(), "dni-nombre", null, path, t0, t1, null, new Boolean(success), errorMessge, t1 - t0, null, "remote");
            throw throwable;
        }
        method.releaseConnection();
        t1 = System.currentTimeMillis();
        if (bean != null) {
            a = bean;
        }
        if (!success && errorMessge == null) {
            errorMessge = ((Object)baos).toString();
        }
        Y31JanoServiceTrace item = new Y31JanoServiceTrace("put", a.getSize(), a.getTtl(), "dni-nombre", null, path, t0, t1, null, new Boolean(success), errorMessge, t1 - t0, null, "remote");
        return a;
    }

    public List list(Document xlnetsToken, String queryRegExp) throws Y31JanoServiceGenericException, Y31JanoServiceFileNotFoundException, Y31JanoServiceFileNameFormatException, Y31JanoServiceMongoDbGenericException, Y31JanoServiceAccesDeniedException {
        return this.list(xlnetsToken, queryRegExp, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List list(Document xlnetsToken, String queryRegExp, boolean withFolders) throws Y31JanoServiceGenericException, Y31JanoServiceFileNotFoundException, Y31JanoServiceFileNameFormatException, Y31JanoServiceMongoDbGenericException, Y31JanoServiceAccesDeniedException {
        List bean;
        String url = JANO_REST_END_POINT + "/" + JANO_REST_LIST_OPERATION + JANO_OPERATION_SUFIX;
        queryRegExp = Y31JanoServiceImpl.normalize(queryRegExp);
        HttpClient client = new HttpClient();
        PostMethod method = new PostMethod(url);
        int statusCode = -1;
        long t0 = System.currentTimeMillis();
        long t1 = System.currentTimeMillis();
        boolean success = true;
        String errorMessge = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos, true);
        try {
            try {
                method = new PostMethod(url);
                method.addParameter("xlnets_token", Y31JanoServiceImpl.document2String(xlnetsToken));
                method.addParameter("hadoop_dir_path", queryRegExp);
                if (withFolders) {
                    method.addParameter("with_folders", "true");
                } else {
                    method.addParameter("with_folders", "false");
                }
                statusCode = client.executeMethod((HttpMethod)method);
                if (statusCode != 200) {
                    success = false;
                    errorMessge = "Error en la comunicaci\u00f3n remota con " + url + " " + method.getStatusLine();
                    bean = null;
                    try {
                        String ccc = null;
                        if (method.getResponseHeader("HTTP_ERROR_CODE_TRANSLATE") != null) {
                            ccc = method.getResponseHeader("HTTP_ERROR_CODE_TRANSLATE").getValue();
                        }
                        Y31RemoteExceptionAbstractFactory.buildException((int)statusCode, (String)method.getResponseBodyAsString(), (String)ccc);
                    }
                    catch (Y31JanoServiceDestinationPathException e) {
                        throw new Y31JanoServiceGenericException((Throwable)e);
                    }
                    catch (Y31JanoServiceFileAlreadyExistException e) {
                        throw new Y31JanoServiceGenericException((Throwable)e);
                    }
                    catch (Y31JanoServiceTraceJmsException e) {
                        throw new Y31JanoServiceGenericException((Throwable)e);
                    }
                    catch (Y31JanoServiceEventJmsException e) {
                        throw new Y31JanoServiceGenericException((Throwable)e);
                    }
                }
                String responseBody = method.getResponseBodyAsString();
                JSONArray jsonArray = JSONArray.fromObject((Object)responseBody);
                bean = JSONArray.toList((JSONArray)jsonArray, (Class)Y31AttachmentBean.class);
            }
            catch (HttpException e) {
                success = false;
                e.printStackTrace(pw);
                throw new Y31JanoServiceGenericException((Throwable)e);
            }
            catch (IOException e) {
                success = false;
                e.printStackTrace(pw);
                throw new Y31JanoServiceGenericException((Throwable)e);
            }
            catch (Y31JanoServiceAccesDeniedException e) {
                e.printStackTrace(pw);
                success = false;
                throw new Y31JanoServiceAccesDeniedException((Throwable)e);
            }
            Object var20_25 = null;
        }
        catch (Throwable throwable) {
            Object var20_26 = null;
            method.releaseConnection();
            t1 = System.currentTimeMillis();
            if (!success && errorMessge == null) {
                errorMessge = ((Object)baos).toString();
            }
            Y31JanoServiceTrace item = new Y31JanoServiceTrace("list", null, null, null, null, queryRegExp, t0, t1, null, new Boolean(success), errorMessge, t1 - t0, null, "remote");
            throw throwable;
        }
        method.releaseConnection();
        t1 = System.currentTimeMillis();
        if (!success && errorMessge == null) {
            errorMessge = ((Object)baos).toString();
        }
        Y31JanoServiceTrace item = new Y31JanoServiceTrace("list", null, null, null, null, queryRegExp, t0, t1, null, new Boolean(success), errorMessge, t1 - t0, null, "remote");
        return bean;
    }

    public Y31AttachmentBean move(Document xlnetsToken, String pathFrom, String pathTo) throws Y31JanoServiceGenericException, Y31JanoServiceFileNameFormatException, Y31JanoServiceFileNotFoundException, Y31JanoServiceMongoDbGenericException, Y31JanoServiceAccesDeniedException, Y31JanoServiceEventJmsException {
        return this.move(xlnetsToken, pathFrom, pathTo, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Y31AttachmentBean move(Document xlnetsToken, String pathFrom, String pathTo, boolean preserveName) throws Y31JanoServiceGenericException, Y31JanoServiceFileNameFormatException, Y31JanoServiceFileNotFoundException, Y31JanoServiceMongoDbGenericException, Y31JanoServiceAccesDeniedException, Y31JanoServiceEventJmsException {
        String url = JANO_REST_END_POINT + "/" + JANO_REST_MOVE_OPERATION + JANO_OPERATION_SUFIX;
        pathFrom = Y31JanoServiceImpl.normalize(pathFrom);
        pathTo = Y31JanoServiceImpl.normalize(pathTo);
        HttpClient client = new HttpClient();
        PostMethod method = new PostMethod(url);
        int statusCode = -1;
        Y31AttachmentBean bean = null;
        long t0 = System.currentTimeMillis();
        long t1 = System.currentTimeMillis();
        boolean success = true;
        String errorMessge = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos, true);
        Y31AttachmentBean a = new Y31AttachmentBean();
        try {
            try {
                method = new PostMethod(url);
                method.addParameter("xlnets_token", Y31JanoServiceImpl.document2String(xlnetsToken));
                method.addParameter("hadoop_file_from", pathFrom);
                method.addParameter("hadoop_file_to", pathTo);
                method.addParameter("hadoop_preserve_name", preserveName + "");
                statusCode = client.executeMethod((HttpMethod)method);
                if (statusCode != 200) {
                    success = false;
                    errorMessge = "Error en la comunicaci\u00f3n remota con " + url + " " + method.getStatusLine();
                    try {
                        String ccc = null;
                        if (method.getResponseHeader("HTTP_ERROR_CODE_TRANSLATE") != null) {
                            ccc = method.getResponseHeader("HTTP_ERROR_CODE_TRANSLATE").getValue();
                        }
                        Y31RemoteExceptionAbstractFactory.buildException((int)statusCode, (String)method.getResponseBodyAsString(), (String)ccc);
                    }
                    catch (Y31JanoServiceDestinationPathException e) {
                        throw new Y31JanoServiceGenericException((Throwable)e);
                    }
                    catch (Y31JanoServiceFileAlreadyExistException e) {
                        throw new Y31JanoServiceGenericException((Throwable)e);
                    }
                    catch (Y31JanoServiceTraceJmsException e) {
                        throw new Y31JanoServiceGenericException((Throwable)e);
                    }
                    catch (Y31JanoServiceFileNotFoundException e) {
                        throw new Y31JanoServiceGenericException((Throwable)e);
                    }
                }
                String responseBody = method.getResponseBodyAsString();
                JSONObject jsonObject = (JSONObject)JSONSerializer.toJSON((Object)responseBody);
                JsonConfig jsonConfig = new JsonConfig();
                jsonConfig.setRootClass(Y31AttachmentBean.class);
                bean = (Y31AttachmentBean)JSONSerializer.toJava((JSON)jsonObject, (JsonConfig)jsonConfig);
            }
            catch (HttpException e) {
                success = false;
                e.printStackTrace(pw);
                throw new Y31JanoServiceGenericException((Throwable)e);
            }
            catch (IOException e) {
                success = false;
                e.printStackTrace(pw);
                throw new Y31JanoServiceGenericException((Throwable)e);
            }
            catch (Y31JanoServiceAccesDeniedException e) {
                e.printStackTrace(pw);
                success = false;
                throw new Y31JanoServiceAccesDeniedException((Throwable)e);
            }
            Object var23_28 = null;
        }
        catch (Throwable throwable) {
            Object var23_29 = null;
            method.releaseConnection();
            t1 = System.currentTimeMillis();
            if (!success && errorMessge == null) {
                errorMessge = ((Object)baos).toString();
            }
            if (bean != null) {
                a = bean;
            }
            Y31JanoServiceTrace item = new Y31JanoServiceTrace("move", a.getSize(), a.getTtl(), "dni-nombre", pathFrom, pathTo, t0, t1, null, new Boolean(success), errorMessge, t1 - t0, null, "remote");
            throw throwable;
        }
        method.releaseConnection();
        t1 = System.currentTimeMillis();
        if (!success && errorMessge == null) {
            errorMessge = ((Object)baos).toString();
        }
        if (bean != null) {
            a = bean;
        }
        Y31JanoServiceTrace item = new Y31JanoServiceTrace("move", a.getSize(), a.getTtl(), "dni-nombre", pathFrom, pathTo, t0, t1, null, new Boolean(success), errorMessge, t1 - t0, null, "remote");
        return a;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Y31AttachmentBean info(Document xlnetsToken, String path) throws Y31JanoServiceGenericException, Y31JanoServiceFileNameFormatException, Y31JanoServiceFileNotFoundException, Y31JanoServiceMongoDbGenericException, Y31JanoServiceAccesDeniedException {
        String url = JANO_REST_END_POINT + "/" + JANO_REST_INFO_OPERATION + JANO_OPERATION_SUFIX;
        path = Y31JanoServiceImpl.normalize(path);
        HttpClient client = new HttpClient();
        PostMethod method = new PostMethod(url);
        int statusCode = -1;
        Y31AttachmentBean bean = null;
        long t0 = System.currentTimeMillis();
        long t1 = System.currentTimeMillis();
        boolean success = true;
        String errorMessge = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos, true);
        Y31AttachmentBean a = new Y31AttachmentBean();
        try {
            try {
                method = new PostMethod(url);
                method.addParameter("xlnets_token", Y31JanoServiceImpl.document2String(xlnetsToken));
                method.addParameter("hadoop_file_path", path);
                statusCode = client.executeMethod((HttpMethod)method);
                if (statusCode != 200) {
                    success = false;
                    errorMessge = "Error en la comunicaci\u00f3n remota con " + url + " " + method.getStatusLine();
                    try {
                        String ccc = null;
                        if (method.getResponseHeader("HTTP_ERROR_CODE_TRANSLATE") != null) {
                            ccc = method.getResponseHeader("HTTP_ERROR_CODE_TRANSLATE").getValue();
                        }
                        Y31RemoteExceptionAbstractFactory.buildException((int)statusCode, (String)method.getResponseBodyAsString(), (String)ccc);
                    }
                    catch (Y31JanoServiceDestinationPathException e) {
                        throw new Y31JanoServiceGenericException((Throwable)e);
                    }
                    catch (Y31JanoServiceFileAlreadyExistException e) {
                        throw new Y31JanoServiceGenericException((Throwable)e);
                    }
                    catch (Y31JanoServiceTraceJmsException e) {
                        throw new Y31JanoServiceGenericException((Throwable)e);
                    }
                    catch (Y31JanoServiceFileNotFoundException e) {
                        throw new Y31JanoServiceGenericException((Throwable)e);
                    }
                    catch (Y31JanoServiceEventJmsException e) {
                        throw new Y31JanoServiceGenericException((Throwable)e);
                    }
                }
                String responseBody = method.getResponseBodyAsString();
                JSONObject jsonObject = (JSONObject)JSONSerializer.toJSON((Object)responseBody);
                JsonConfig jsonConfig = new JsonConfig();
                jsonConfig.setRootClass(Y31AttachmentBean.class);
                bean = (Y31AttachmentBean)JSONSerializer.toJava((JSON)jsonObject, (JsonConfig)jsonConfig);
            }
            catch (HttpException e) {
                success = false;
                e.printStackTrace(pw);
                throw new Y31JanoServiceGenericException((Throwable)e);
            }
            catch (IOException e) {
                success = false;
                e.printStackTrace(pw);
                throw new Y31JanoServiceGenericException((Throwable)e);
            }
            catch (Y31JanoServiceAccesDeniedException e) {
                e.printStackTrace(pw);
                success = false;
                throw new Y31JanoServiceAccesDeniedException((Throwable)e);
            }
            Object var21_27 = null;
        }
        catch (Throwable throwable) {
            Object var21_28 = null;
            method.releaseConnection();
            t1 = System.currentTimeMillis();
            if (!success && errorMessge == null) {
                errorMessge = ((Object)baos).toString();
            }
            if (bean != null) {
                a = bean;
            }
            Y31JanoServiceTrace item = new Y31JanoServiceTrace("info", a.getSize(), a.getTtl(), "dni-nombre", null, path, t0, t1, null, new Boolean(success), errorMessge, t1 - t0, null, "remote");
            throw throwable;
        }
        method.releaseConnection();
        t1 = System.currentTimeMillis();
        if (!success && errorMessge == null) {
            errorMessge = ((Object)baos).toString();
        }
        if (bean != null) {
            a = bean;
        }
        Y31JanoServiceTrace item = new Y31JanoServiceTrace("info", a.getSize(), a.getTtl(), "dni-nombre", null, path, t0, t1, null, new Boolean(success), errorMessge, t1 - t0, null, "remote");
        return a;
    }

    public Y31AttachmentBean copy(Document xlnetsToken, String pathFrom, String pathTo) throws Y31JanoServiceGenericException, Y31JanoServiceFileNotFoundException, Y31JanoServiceFileNameFormatException, Y31JanoServiceMongoDbGenericException, Y31JanoServiceAccesDeniedException, Y31JanoServiceEventJmsException {
        return this.copy(xlnetsToken, pathFrom, pathTo, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Y31AttachmentBean copy(Document xlnetsToken, String pathFrom, String pathTo, boolean preserveName) throws Y31JanoServiceGenericException, Y31JanoServiceFileNotFoundException, Y31JanoServiceFileNameFormatException, Y31JanoServiceMongoDbGenericException, Y31JanoServiceAccesDeniedException, Y31JanoServiceEventJmsException {
        String url = JANO_REST_END_POINT + "/" + JANO_REST_COPY_OPERATION + JANO_OPERATION_SUFIX;
        pathFrom = Y31JanoServiceImpl.normalize(pathFrom);
        pathTo = Y31JanoServiceImpl.normalize(pathTo);
        HttpClient client = new HttpClient();
        PostMethod method = new PostMethod(url);
        int statusCode = -1;
        Y31AttachmentBean bean = null;
        long t0 = System.currentTimeMillis();
        long t1 = System.currentTimeMillis();
        boolean success = true;
        String errorMessge = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos, true);
        Y31AttachmentBean a = new Y31AttachmentBean();
        try {
            try {
                method = new PostMethod(url);
                method.addParameter("xlnets_token", Y31JanoServiceImpl.document2String(xlnetsToken));
                method.addParameter("hadoop_file_from", pathFrom);
                method.addParameter("hadoop_file_to", pathTo);
                method.addParameter("hadoop_preserve_name", preserveName + "");
                statusCode = client.executeMethod((HttpMethod)method);
                if (statusCode != 200) {
                    success = false;
                    errorMessge = "Error en la comunicaci\u00f3n remota con " + url + " " + method.getStatusLine();
                    try {
                        String ccc = null;
                        if (method.getResponseHeader("HTTP_ERROR_CODE_TRANSLATE") != null) {
                            ccc = method.getResponseHeader("HTTP_ERROR_CODE_TRANSLATE").getValue();
                        }
                        Y31RemoteExceptionAbstractFactory.buildException((int)statusCode, (String)method.getResponseBodyAsString(), (String)ccc);
                    }
                    catch (Y31JanoServiceDestinationPathException e) {
                        throw new Y31JanoServiceGenericException((Throwable)e);
                    }
                    catch (Y31JanoServiceFileAlreadyExistException e) {
                        throw new Y31JanoServiceGenericException((Throwable)e);
                    }
                    catch (Y31JanoServiceTraceJmsException e) {
                        throw new Y31JanoServiceGenericException((Throwable)e);
                    }
                    catch (Y31JanoServiceFileNotFoundException e) {
                        throw new Y31JanoServiceGenericException((Throwable)e);
                    }
                }
                String responseBody = method.getResponseBodyAsString();
                JSONObject jsonObject = (JSONObject)JSONSerializer.toJSON((Object)responseBody);
                JsonConfig jsonConfig = new JsonConfig();
                jsonConfig.setRootClass(Y31AttachmentBean.class);
                bean = (Y31AttachmentBean)JSONSerializer.toJava((JSON)jsonObject, (JsonConfig)jsonConfig);
            }
            catch (HttpException e) {
                success = false;
                e.printStackTrace(pw);
                throw new Y31JanoServiceGenericException((Throwable)e);
            }
            catch (IOException e) {
                success = false;
                e.printStackTrace(pw);
                throw new Y31JanoServiceGenericException((Throwable)e);
            }
            catch (Y31JanoServiceAccesDeniedException e) {
                e.printStackTrace(pw);
                success = false;
                throw new Y31JanoServiceAccesDeniedException((Throwable)e);
            }
            Object var23_28 = null;
        }
        catch (Throwable throwable) {
            Object var23_29 = null;
            method.releaseConnection();
            t1 = System.currentTimeMillis();
            if (!success && errorMessge == null) {
                errorMessge = ((Object)baos).toString();
            }
            if (bean != null) {
                a = bean;
            }
            Y31JanoServiceTrace item = new Y31JanoServiceTrace("copy", a.getSize(), a.getTtl(), "dni-nombre", pathFrom, pathTo, t0, t1, null, new Boolean(success), errorMessge, t1 - t0, null, "remote");
            throw throwable;
        }
        method.releaseConnection();
        t1 = System.currentTimeMillis();
        if (!success && errorMessge == null) {
            errorMessge = ((Object)baos).toString();
        }
        if (bean != null) {
            a = bean;
        }
        Y31JanoServiceTrace item = new Y31JanoServiceTrace("copy", a.getSize(), a.getTtl(), "dni-nombre", pathFrom, pathTo, t0, t1, null, new Boolean(success), errorMessge, t1 - t0, null, "remote");
        return a;
    }

    private static String getFileNameFromCompletPath(String path) throws Y31JanoServiceFileNameFormatException {
        if (path.lastIndexOf("\\.") >= 0 && path.lastIndexOf(".") < path.length()) {
            throw new Y31JanoServiceFileNameFormatException("el nombre del fichero no se ajusta  al patron nombre.ext");
        }
        if (path.lastIndexOf("/") < 0) {
            return path;
        }
        String fileName = path.substring(path.lastIndexOf("/") + 1, path.length());
        return fileName;
    }

    private static String normalize(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            int pos = UNICODE.indexOf(c);
            if (pos > -1) {
                sb.append(PLAIN_ASCII.charAt(pos));
                continue;
            }
            sb.append(c);
        }
        return sb.toString().replaceAll(" ", "-");
    }

    private static String document2String(Document xlnets) throws Y31JanoServiceAccesDeniedException {
        OutputFormat format = new OutputFormat(xlnets);
        StringWriter stringOut = new StringWriter();
        XMLSerializer serial = new XMLSerializer((Writer)stringOut, format);
        try {
            serial.serialize(xlnets);
        }
        catch (IOException e) {
            throw new Y31JanoServiceAccesDeniedException((Throwable)e);
        }
        return stringOut.toString();
    }

    public static void main(String[] args) {
        String s = "The result : \u00c8,\u00c9,\u00ca,\u00cb,\u00db,\u00d9,\u00cf,\u00ce,\u00c0,\u00c2,\u00d4,\u00e8,\u00e9,\u00ea,\u00eb,\u00fb,\u00f9,\u00ef,\u00ee,\u00e0,\u00e2,\u00f4,\u00e7";
        Boolean f1 = new Boolean(true);
        Boolean f2 = new Boolean("false");
        if (f2.booleanValue()) {
            // empty if block
        }
        if (f1.booleanValue()) {
            // empty if block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delete(Document xlnetsToken, String path) throws Y31JanoServiceFileNameFormatException, Y31JanoServiceFileNotFoundException, Y31JanoServiceGenericException, Y31JanoServiceAccesDeniedException {
        String url = JANO_REST_END_POINT + "/" + JANO_REST_DELETE_OPERATION + JANO_OPERATION_SUFIX;
        String path2 = Y31JanoServiceImpl.normalize(path);
        HttpClient client = new HttpClient();
        PostMethod method = new PostMethod(url);
        int statusCode = -1;
        long t0 = System.currentTimeMillis();
        long t1 = System.currentTimeMillis();
        boolean success = true;
        String errorMessge = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos, true);
        try {
            try {
                method = new PostMethod(url);
                method.addParameter("xlnets_token", Y31JanoServiceImpl.document2String(xlnetsToken));
                method.addParameter("hadoop_file_path", path2);
                statusCode = client.executeMethod((HttpMethod)method);
                if (statusCode != 200) {
                    success = false;
                    errorMessge = "Error en la comunicaci\u00f3n remota con " + url + " " + method.getStatusLine();
                    try {
                        String ccc = null;
                        if (method.getResponseHeader("HTTP_ERROR_CODE_TRANSLATE") != null) {
                            ccc = method.getResponseHeader("HTTP_ERROR_CODE_TRANSLATE").getValue();
                        }
                        Y31RemoteExceptionAbstractFactory.buildException((int)statusCode, (String)method.getResponseBodyAsString(), (String)ccc);
                    }
                    catch (Y31JanoServiceDestinationPathException e) {
                        throw new Y31JanoServiceGenericException((Throwable)e);
                    }
                    catch (Y31JanoServiceFileAlreadyExistException e) {
                        throw new Y31JanoServiceGenericException((Throwable)e);
                    }
                    catch (Y31JanoServiceTraceJmsException e) {
                        throw new Y31JanoServiceGenericException((Throwable)e);
                    }
                    catch (Y31JanoServiceFileNotFoundException e) {
                        throw new Y31JanoServiceGenericException((Throwable)e);
                    }
                    catch (Y31JanoServiceMongoDbGenericException e) {
                        throw new Y31JanoServiceGenericException((Throwable)e);
                    }
                    catch (Y31JanoServiceEventJmsException e) {
                        throw new Y31JanoServiceGenericException((Throwable)e);
                    }
                }
                Object var18_24 = null;
            }
            catch (HttpException e) {
                success = false;
                e.printStackTrace(pw);
                throw new Y31JanoServiceGenericException((Throwable)e);
            }
            catch (IOException e) {
                success = false;
                e.printStackTrace(pw);
                throw new Y31JanoServiceGenericException((Throwable)e);
            }
            catch (Y31JanoServiceAccesDeniedException e) {
                e.printStackTrace(pw);
                success = false;
                throw new Y31JanoServiceAccesDeniedException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var18_25 = null;
            method.releaseConnection();
            t1 = System.currentTimeMillis();
            if (!success && errorMessge == null) {
                errorMessge = ((Object)baos).toString();
            }
            Y31JanoServiceTrace item = new Y31JanoServiceTrace("delete", null, null, "dni-nombre", path2, null, t0, t1, null, new Boolean(success), errorMessge, t1 - t0, null, "remote");
            throw throwable;
        }
        method.releaseConnection();
        t1 = System.currentTimeMillis();
        if (!success && errorMessge == null) {
            errorMessge = ((Object)baos).toString();
        }
        Y31JanoServiceTrace item = new Y31JanoServiceTrace("delete", null, null, "dni-nombre", path2, null, t0, t1, null, new Boolean(success), errorMessge, t1 - t0, null, "remote");
    }

    static {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = Y31JanoServiceImpl.class.getClassLoader();
        }
        InputStream inputStream = null;
        inputStream = cl.getResourceAsStream("w08/com/ejie/y31/service/impl/y31.properties");
        if (inputStream == null) {
            inputStream = cl.getResourceAsStream("y31/y31.properties");
        }
        if (inputStream == null) {
            try {
                throw new Y31JanoServiceGenericException("No se ha podido cargar un properties valido y31/y31.properties o w08/com/ejie/y31/service/impl/y31.properties");
            }
            catch (Y31JanoServiceGenericException e) {
                e.printStackTrace();
            }
        }
        Properties properties = new Properties();
        String propValue = "http://localhost:7001/y31ApiJSWAR";
        String propValue2 = "";
        try {
            properties.load(inputStream);
            propValue = properties.getProperty("Y31_JANO_REST_END_POINT");
            if (properties.getProperty("JANO_OPERATION_SUFIX") != null && properties.getProperty("JANO_OPERATION_SUFIX").length() > 0) {
                propValue2 = properties.getProperty("JANO_OPERATION_SUFIX");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JANO_REST_END_POINT = propValue;
        JANO_OPERATION_SUFIX = propValue2;
    }
}

