/*
 * Decompiled with CFR 0.152.
 */
package w11.com.ejie.y31.util.trace.manager;

import com.ejie.y31.exception.Y31JanoServiceMongoDbGenericException;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.Properties;

public class Y31JanoServiceMongoDBConnectionManager {
    private static Mongo con = null;
    private static String MONGO_DB = "y31";
    private static final String COLLECTION = "y31JanoServiceTraceCollection";
    private static String MONGO_SERVER = "ejld024";
    private static int MONGO_PORT = 7200;

    public static DBCollection getCollection() throws Y31JanoServiceMongoDbGenericException {
        return Y31JanoServiceMongoDBConnectionManager.getCollection(COLLECTION);
    }

    private static DBCollection getCollection(String name) throws Y31JanoServiceMongoDbGenericException {
        if (con == null) {
            try {
                con = new Mongo(MONGO_SERVER, MONGO_PORT);
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                throw new Y31JanoServiceMongoDbGenericException((Throwable)e);
            }
            catch (MongoException e) {
                e.printStackTrace();
                throw new Y31JanoServiceMongoDbGenericException((Throwable)e);
            }
        }
        DB db = con.getDB(MONGO_DB);
        return db.getCollection(name);
    }

    static {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = Y31JanoServiceMongoDBConnectionManager.class.getClassLoader();
        }
        InputStream inputStream = null;
        inputStream = cl.getResourceAsStream("w11/com/ejie/y31/service/impl/y31.properties");
        if (inputStream == null) {
            inputStream = cl.getResourceAsStream("y31/y31.properties");
        }
        Properties properties = new Properties();
        try {
            if (inputStream != null) {
                properties.load(inputStream);
                if (properties.getProperty("MONGO_SERVER") != null && properties.getProperty("MONGO_SERVER").length() > 0) {
                    MONGO_SERVER = properties.getProperty("MONGO_SERVER");
                }
                if (properties.getProperty("MONGO_PORT") != null && properties.getProperty("MONGO_PORT").length() > 0) {
                    MONGO_PORT = Integer.parseInt(properties.getProperty("MONGO_PORT").trim());
                }
                if (properties.getProperty("MONGO_DB") != null && properties.getProperty("MONGO_DB").length() > 0) {
                    MONGO_DB = properties.getProperty("MONGO_DB");
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

