/*
 * Decompiled with CFR 0.152.
 */
package w11.com.ejie.y31.service.test;

import com.ejie.y31.exception.Y31JanoServiceAccesDeniedException;
import com.ejie.y31.exception.Y31JanoServiceEventJmsException;
import com.ejie.y31.exception.Y31JanoServiceFileNameFormatException;
import com.ejie.y31.exception.Y31JanoServiceFileNotFoundException;
import com.ejie.y31.exception.Y31JanoServiceGenericException;
import com.ejie.y31.exception.Y31JanoServiceMongoDbGenericException;
import com.ejie.y31.exception.Y31JanoServiceOracleGenericException;
import com.ejie.y31.factory.Y31JanoServiceAbstractFactory;
import com.ejie.y31.service.Y31JanoService;
import com.ejie.y31.vo.Y31AttachmentBean;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class BasicTest {
    private static Y31JanoService service = null;
    private static String NAME = "jano-hadoop-API.png";
    private static Document xlnettoken = null;

    private static void init() throws Y31JanoServiceGenericException, IOException, SAXException, ParserConfigurationException {
        service = Y31JanoServiceAbstractFactory.getInstance();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        System.out.println("--------0----------------->");
        xlnettoken = db.parse(new URL("http://localhost:7001/y31ApiJSWAR/Y31JanoServiceXlnetsTokenCreatorServlet?login_app=T17I").openStream());
        System.out.println("--------1----------------->");
    }

    private static boolean put() throws Y31JanoServiceMongoDbGenericException, Y31JanoServiceEventJmsException, Y31JanoServiceAccesDeniedException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream("/temp/casa.png");
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
            return false;
        }
        try {
            Y31AttachmentBean ab = service.put(xlnettoken, (InputStream)fis, "/t17i/mi_casa/casa.png", false, new Long(86400L));
            NAME = ab.getFilePath();
            BasicTest.printAB(ab);
        }
        catch (Y31JanoServiceGenericException e) {
            e.printStackTrace();
            return false;
        }
        catch (Y31JanoServiceFileNameFormatException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private static void delete() throws Y31JanoServiceFileNameFormatException, Y31JanoServiceGenericException, Y31JanoServiceAccesDeniedException, Y31JanoServiceFileNotFoundException {
        service.delete(xlnettoken, NAME);
    }

    private static boolean get() throws Y31JanoServiceMongoDbGenericException, Y31JanoServiceOracleGenericException, Y31JanoServiceAccesDeniedException {
        InputStream is;
        FileOutputStream fos;
        try {
            fos = new FileOutputStream("/temp/prueba.png");
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
            return false;
        }
        try {
            is = service.get(xlnettoken, NAME);
        }
        catch (Y31JanoServiceGenericException e) {
            e.printStackTrace();
            return false;
        }
        catch (Y31JanoServiceFileNameFormatException e) {
            e.printStackTrace();
            return false;
        }
        catch (Y31JanoServiceFileNotFoundException e) {
            return false;
        }
        try {
            IOUtils.copy((InputStream)is, (OutputStream)fos);
            is.close();
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private static boolean copy() throws Y31JanoServiceMongoDbGenericException, Y31JanoServiceAccesDeniedException, Y31JanoServiceEventJmsException, Y31JanoServiceFileNotFoundException {
        try {
            Y31AttachmentBean ab = service.copy(xlnettoken, NAME, NAME.replaceAll("t17i", "t69i"));
            BasicTest.printAB(ab);
        }
        catch (Y31JanoServiceGenericException e) {
            e.printStackTrace();
            return false;
        }
        catch (Y31JanoServiceFileNameFormatException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private static boolean move() throws Y31JanoServiceMongoDbGenericException, Y31JanoServiceAccesDeniedException, Y31JanoServiceEventJmsException, Y31JanoServiceFileNotFoundException {
        try {
            Y31AttachmentBean ab = service.move(xlnettoken, NAME, NAME.replaceAll("t17i", "t69i"));
            BasicTest.printAB(ab);
        }
        catch (Y31JanoServiceGenericException e) {
            e.printStackTrace();
            return false;
        }
        catch (Y31JanoServiceFileNameFormatException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private static boolean info() throws Y31JanoServiceMongoDbGenericException, Y31JanoServiceAccesDeniedException, Y31JanoServiceFileNotFoundException {
        try {
            Y31AttachmentBean ab = service.info(xlnettoken, NAME);
            BasicTest.printAB(ab);
        }
        catch (Y31JanoServiceGenericException e) {
            e.printStackTrace();
            return false;
        }
        catch (Y31JanoServiceFileNameFormatException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private static boolean list() throws Y31JanoServiceAccesDeniedException {
        try {
            List ab = service.list(xlnettoken, "/t17i");
            BasicTest.printAB(ab);
        }
        catch (Y31JanoServiceGenericException e) {
            e.printStackTrace();
            return false;
        }
        catch (Y31JanoServiceFileNotFoundException e) {
            e.printStackTrace();
        }
        catch (Y31JanoServiceFileNameFormatException e) {
            e.printStackTrace();
        }
        catch (Y31JanoServiceMongoDbGenericException e) {
            e.printStackTrace();
        }
        return true;
    }

    private static void printAB(List<Y31AttachmentBean> ab) {
        for (Y31AttachmentBean y31AttachmentBean : ab) {
            BasicTest.printAB(y31AttachmentBean);
        }
    }

    private static void printAB(Y31AttachmentBean ab) {
        System.out.println("TTL------------------->" + ab.getTtl());
    }

    public static void main(String[] args) throws Y31JanoServiceGenericException, IOException, Y31JanoServiceMongoDbGenericException, Y31JanoServiceOracleGenericException, Y31JanoServiceEventJmsException, Y31JanoServiceAccesDeniedException, SAXException, ParserConfigurationException, Y31JanoServiceFileNameFormatException, Y31JanoServiceFileNotFoundException {
        BasicTest.init();
        for (int i = 0; i < 1; ++i) {
            if (!BasicTest.put()) {
                System.out.println("PUT INCORRECTO");
                return;
            }
            System.out.println("PUT CORRECTO");
            BasicTest.delete();
        }
    }
}

