/*
 * Decompiled with CFR 0.152.
 */
package w11.com.ejie.y31.service.impl;

import com.ejie.y31.exception.Y31JanoServiceAccesDeniedException;
import com.ejie.y31.exception.Y31JanoServiceEventJmsException;
import com.ejie.y31.exception.Y31JanoServiceFileNameFormatException;
import com.ejie.y31.exception.Y31JanoServiceFileNotFoundException;
import com.ejie.y31.exception.Y31JanoServiceGenericException;
import com.ejie.y31.exception.Y31JanoServiceMongoDbGenericException;
import com.ejie.y31.exception.Y31JanoServiceOracleGenericException;
import com.ejie.y31.exception.Y31JanoServiceTraceJmsException;
import com.ejie.y31.service.Y31JanoService;
import com.ejie.y31.service.Y31JanoServiceTool;
import com.ejie.y31.vo.Y31AttachmentBean;
import com.ejie.y31.vo.Y31AttachmentBeanExt;
import com.ejie.y31.vo.Y31JanoServiceTrace;
import com.ejie.y31.vo.Y31JanoServiceTraceAtom;
import com.ejie.y31.vo.Y31XlnetsInfoBean;
import flexjson.JSONDeserializer;
import flexjson.JSONSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.w3c.dom.Document;
import w11.com.ejie.y31.service.impl.Y31JanoServiceMimeTypeTool;
import w11.com.ejie.y31.service.impl.Y31JanoServiceSecurityTool;
import w11.com.ejie.y31.util.events.manager.Y31JanoServiceEventsJMSManger;
import w11.com.ejie.y31.util.events.manager.Y31JanoServiceTraceJMSMangerWL11;

public class Y31JanoServiceImpl
implements Y31JanoService {
    public static final String DEFAULT_HADOOP_HOST;
    public static final String JANO_REST_END_POINT;
    public static final String DEFAULT_HADOOP_REPLICATION = "2";
    public static final String DEFAULT_HADOOP_BLOCK_SIZE = "134217728";
    public static final String DEFAULT_DST_FOLDER_PREFIX = "/hadoop/test";
    public static final String DEFAULT_DFS_PERMISSIONS = "false";
    public static final String DEFAULT_HADOOP_TMP_DIR_PATH = "/tmp";
    public static final Boolean STRICT_SECURITY_CHECKER;
    public static final String JANO_XLNETS_VALIDATOR_OPERATION = "Y31JanoServiceXlnetsDocumentValidatorServlet";
    public static String JANO_OPERATION_SUFIX;
    public static final String FS_DEFAULT_NAME_PARAM_NAME = "fs.default.name";
    public static final String DFS_REPLICATION_PARAM_NAME = "dfs.replication";
    public static final String DFS_BLOCKSIZE_PARAM_NAME = "dfs.blocksize";
    public static final String DFS_PERMISSIONS_PARAM_NAME = "dfs.permissions";
    private static final int ATOM_TYPE_XLNETS = 0;
    private static final int ATOM_TYPE_VALIDATE_PATH = 1;
    private static final int ATOM_TYPE_FILE_EXISTS = 2;
    private static final int ATOM_TYPE_PIPE_STREAM = 3;
    private static final int ATOM_TYPE_CREATE_ATTACHMENT_BEAN = 4;
    private static final int ATOM_TYPE_SEND_JMS_EVENT = 5;
    private static final int ATOM_TYPE_STREAM_OPEN = 6;
    private static final int ATOM_TYPE_WRITE_STREAM = 7;
    private static final int ATOM_TYPE_RENAME_FILE = 8;
    private static final int ATOM_TYPE_COPY_FILE = 9;
    private static final int ATOM_TYPE_LIST_FOLDER = 10;
    private static final int ATOM_TYPE_LIST_FOLDER_CREATE_LIST = 11;
    private static final int ATOM_TYPE_DELETE = 12;
    private static final int ATOM_TYPE_CREATE_ATTACHMENT_BEAN_GET_FILE_NAME = 12;
    private static final int ATOM_TYPE_CREATE_ATTACHMENT_BEAN_GET_FILE_SIZE = 13;
    private static final int ATOM_TYPE_CREATE_ATTACHMENT_BEAN_GET_FILE_TTL = 14;
    private static final int ATOM_TYPE_CREATE_ATTACHMENT_BEAN_GET_CREATION_DATE = 15;
    private static final int ATOM_TYPE_CREATE_ATTACHMENT_BEAN_GET_MODIFICATION_DATE = 16;
    private static final int ATOM_TYPE_VALIDATE_WRITE_PATH = 15;
    private static final int ATOM_TYPE_CREATE_DIR = 17;
    private static Y31JanoService instance;
    private static FileSystem fs;
    private static Configuration conf;
    private static Properties properties;
    private static String initStatus;

    public Properties getY31Properties() {
        return properties;
    }

    public String checkHealth() {
        FileStatus[] a;
        String data = "";
        String data_user = "";
        String metadata = "";
        String metadata_user = "";
        String sec_web_file = "";
        String sec_permissions_file = "";
        try {
            for (FileStatus fileStatus : a = fs.listStatus(new Path("/data"))) {
                data = data + fileStatus.getPath().getName() + "<br/>";
            }
        }
        catch (Exception e) {
            data = e.getMessage();
        }
        try {
            for (FileStatus fileStatus : a = fs.listStatus(new Path("/data_user/user"))) {
                data_user = data_user + fileStatus.getPath().getName() + "<br/>";
            }
        }
        catch (Exception e) {
            data_user = e.getMessage();
        }
        try {
            for (FileStatus fileStatus : a = fs.listStatus(new Path("/metadata"))) {
                metadata = metadata + fileStatus.getPath().getName() + "<br/>";
            }
        }
        catch (Exception e) {
            metadata = e.getMessage();
        }
        try {
            for (FileStatus fileStatus : a = fs.listStatus(new Path("/metadata_user/user"))) {
                metadata_user = metadata_user + fileStatus.getPath().getName() + "<br/>";
            }
        }
        catch (Exception e) {
            metadata_user = e.getMessage();
        }
        try {
            for (FileStatus fileStatus : a = fs.listStatus(new Path("/security/webpermissions.properties"))) {
                sec_web_file = sec_web_file + fileStatus.getPath().getName() + "<br/>";
            }
        }
        catch (Exception e) {
            sec_web_file = e.getMessage();
        }
        try {
            for (FileStatus fileStatus : a = fs.listStatus(new Path("/security/permissions.properties"))) {
                sec_permissions_file = sec_permissions_file + fileStatus.getPath().getName() + "<br/>";
            }
        }
        catch (Exception e) {
            sec_permissions_file = e.getMessage();
        }
        String r = "<thead><tr><td>Test</td><td>Status</td></tr></thead>";
        r = r + "<tr><td>INIT (static)</td><td>" + initStatus + "</td></tr>";
        r = r + "<tr><td>APP-ZONE (/data)</td><td>" + data + "</td></tr>";
        r = r + "<tr><td>USER-ZONE (/data_user/user)</td><td>" + data_user + "</td></tr>";
        r = r + "<tr><td>METADATA-APP-ZONE (/metadata)</td><td>" + metadata + "</td></tr>";
        r = r + "<tr><td>METADATA-USER-ZONE (/metadata_user/user)</td><td>" + metadata_user + "</td></tr>";
        r = r + "<tr><td>SECURITY WEB FILE (/security/webpermissions.properties)</td><td>" + sec_web_file + "</td></tr>";
        r = r + "<tr><td>SECURITY PERMISSIONS FILE (/security/permissions.properties)</td><td>" + sec_permissions_file + "</td></tr>";
        return r;
    }

    private Y31JanoServiceImpl() {
        instance = this;
    }

    public static Y31JanoService getInstance() {
        if (instance == null) {
            new Y31JanoServiceImpl();
        }
        return instance;
    }

    public InputStream get(Document xlnetsToken, String path) throws Y31JanoServiceGenericException, Y31JanoServiceFileNotFoundException, Y31JanoServiceFileNameFormatException, Y31JanoServiceMongoDbGenericException, Y31JanoServiceOracleGenericException, Y31JanoServiceAccesDeniedException {
        FSDataInputStream fsdata;
        long t0 = System.currentTimeMillis();
        long t1 = System.currentTimeMillis();
        long tt0 = System.currentTimeMillis();
        long tt1 = System.currentTimeMillis();
        ArrayList<Y31JanoServiceTraceAtom> atoms = new ArrayList<Y31JanoServiceTraceAtom>();
        String path2 = Y31JanoServiceTool.normalize((String)path, (boolean)true);
        boolean success = true;
        String errorMessge = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos, true);
        String xlnetsInfo = "Error de seguridad";
        try {
            tt0 = System.currentTimeMillis();
            Y31XlnetsInfoBean tokenInfoBean = Y31JanoServiceSecurityTool.getXlnetsAuditInfo(xlnetsToken);
            tt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(tt0, tt1, 0, "tiempo en ejecutar getXlnetsAuditInfo()", 0));
            tt0 = System.currentTimeMillis();
            Y31JanoServiceSecurityTool.validateReadAccess(path2, tokenInfoBean);
            tt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(tt0, tt1, 1, "tiempo en ejecutar validateAccess()", 1));
            xlnetsInfo = tokenInfoBean.toTrace();
            tt0 = System.currentTimeMillis();
            if (!Y31JanoServiceImpl.exist(path2)) {
                throw new Y31JanoServiceFileNotFoundException("El fichero " + path2 + " no se encuentra en el filesystem remoto");
            }
            tt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(tt0, tt1, 2, "tiempo en ejecutar Y31JanoServiceImpl.exist()", 2));
            tt0 = System.currentTimeMillis();
            fsdata = fs.open(new Path(path2));
            tt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(tt0, tt1, 3, "tiempo en ejecutar fs.open()", 6));
        }
        catch (IOException e) {
            e.printStackTrace(pw);
            success = false;
            throw new Y31JanoServiceGenericException((Throwable)e);
        }
        catch (Y31JanoServiceAccesDeniedException e) {
            e.printStackTrace(pw);
            success = false;
            throw e;
        }
        catch (Y31JanoServiceFileNotFoundException e) {
            e.printStackTrace(pw);
            success = false;
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace(pw);
            success = false;
            throw new Y31JanoServiceGenericException((Throwable)e);
        }
        finally {
            t1 = System.currentTimeMillis();
            if (!success) {
                errorMessge = ((Object)baos).toString();
            }
            Y31JanoServiceTrace item = new Y31JanoServiceTrace("get", null, null, xlnetsInfo, null, path2, t0, t1, null, Boolean.valueOf(success), errorMessge, t1 - t0, null, "local");
            try {
                item.setAtoms(atoms);
                Y31JanoServiceTraceJMSMangerWL11.publish(item);
            }
            catch (Y31JanoServiceTraceJmsException e) {}
        }
        return fsdata;
    }

    public Y31AttachmentBean put(Document xlnetsToken, InputStream file, String path, Long ttl) throws Y31JanoServiceGenericException, Y31JanoServiceFileNameFormatException, Y31JanoServiceMongoDbGenericException, Y31JanoServiceEventJmsException, Y31JanoServiceAccesDeniedException {
        return this.put(xlnetsToken, file, path, false, ttl);
    }

    public Y31AttachmentBean put(Document xlnetsToken, InputStream file, String path, boolean preserveName, Long ttl) throws Y31JanoServiceGenericException, Y31JanoServiceFileNameFormatException, Y31JanoServiceMongoDbGenericException, Y31JanoServiceEventJmsException, Y31JanoServiceAccesDeniedException {
        long t0 = System.currentTimeMillis();
        long t1 = System.currentTimeMillis();
        long tt0 = System.currentTimeMillis();
        long tt1 = System.currentTimeMillis();
        ArrayList<Y31JanoServiceTraceAtom> atoms = new ArrayList<Y31JanoServiceTraceAtom>();
        String path2 = Y31JanoServiceTool.normalize((String)path, (boolean)preserveName);
        boolean success = true;
        String errorMessge = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos, true);
        Path fileNamePath = new Path(path2);
        FSDataOutputStream out = null;
        Y31AttachmentBean a = new Y31AttachmentBean();
        String xlnetsInfo = "Error de seguridad";
        try {
            tt0 = System.currentTimeMillis();
            xlnetsInfo = Y31JanoServiceSecurityTool.getXlnetsAuditInfo(xlnetsToken).toTrace();
            tt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(tt0, tt1, 0, "tiempo en ejecutar getXlnetsAuditInfo()", 0));
            tt0 = System.currentTimeMillis();
            Y31XlnetsInfoBean tokenInfoBean = Y31JanoServiceSecurityTool.getXlnetsAuditInfo(xlnetsToken);
            Y31JanoServiceSecurityTool.validateWriteAccess(path, tokenInfoBean, fs);
            tt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(tt0, tt1, 1, "tiempo en ejecutar validateWriteAccess()", 15));
            tt0 = System.currentTimeMillis();
            out = fs.create(fileNamePath);
            tt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(tt0, tt1, 1, "tiempo en ejecutar fs.create()", 7));
            tt0 = System.currentTimeMillis();
            ReadableByteChannel inputChannel = Channels.newChannel(file);
            WritableByteChannel outputChannel = Channels.newChannel((OutputStream)out);
            ByteBuffer buf = ByteBuffer.allocateDirect(65536);
            long len = 0L;
            Long size = 0L;
            while ((len = (long)inputChannel.read(buf)) != -1L) {
                size = size + len;
                buf.flip();
                outputChannel.write(buf);
                buf.clear();
            }
            outputChannel.close();
            inputChannel.close();
            tt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(tt0, tt1, 2, "tiempo en ejecutar IOUtils.copy()", 3));
            out.flush();
            out.close();
            file.close();
            tt0 = System.currentTimeMillis();
            long ttt0 = System.currentTimeMillis();
            long ttt1 = System.currentTimeMillis();
            ttt0 = System.currentTimeMillis();
            String a1 = Y31JanoServiceTool.getFileNameFromCompletPath((String)path2);
            ttt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(ttt0, ttt1, 3, "tiempo en ejecutar Y31JanoServiceImpl.getFileNameFromCompletPath()", 12));
            String a2 = path2;
            ttt0 = System.currentTimeMillis();
            String a3 = Y31JanoServiceMimeTypeTool.getMimeTypeFromCompletePath(path2);
            ttt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(ttt0, ttt1, 4, "tiempo en ejecutar Y31JanoServiceImpl.getMimeTypeFromCompletePath()", 12));
            a = new Y31AttachmentBean(a1, a2, a3, size, ttl, null, false, true, true, true, new Date(), new Date(), false);
            tt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(tt0, tt1, 5, "tiempo en ejecutar new Y31AttachmentBean()", 4));
            tt0 = System.currentTimeMillis();
            Y31JanoServiceEventsJMSManger.publish(Y31JanoServiceTool.getPathFromCompletPath((String)path2), Y31JanoServiceTool.getFileNameFromCompletPath((String)path2), xlnetsInfo, Y31JanoServiceEventsJMSManger.EventWhat.PUT);
            tt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(tt0, tt1, 6, "tiempo en ejecutar Y31JanoServiceEventsJMSManger.publish()", 5));
        }
        catch (Y31JanoServiceEventJmsException e) {
            success = false;
            e.printStackTrace(pw);
            throw e;
        }
        catch (IOException e) {
            success = false;
            e.printStackTrace(pw);
            throw new Y31JanoServiceGenericException((Throwable)e);
        }
        catch (Y31JanoServiceAccesDeniedException e) {
            e.printStackTrace(pw);
            success = false;
            throw e;
        }
        catch (Exception e) {
            success = false;
            e.printStackTrace(pw);
            throw new Y31JanoServiceGenericException((Throwable)e);
        }
        finally {
            t1 = System.currentTimeMillis();
            if (!success) {
                errorMessge = ((Object)baos).toString();
            }
            Y31JanoServiceTrace item = new Y31JanoServiceTrace("put", a.getSize(), a.getTtl(), xlnetsInfo, null, path2, t0, t1, null, Boolean.valueOf(success), errorMessge, t1 - t0, null, "local");
            try {
                item.setAtoms(atoms);
                Y31JanoServiceTraceJMSMangerWL11.publish(item);
            }
            catch (Y31JanoServiceTraceJmsException e) {}
        }
        try {
            Y31JanoServiceTrace item;
            this.putMetaData(xlnetsToken, a, item);
        }
        catch (Exception e) {
            // empty catch block
        }
        return a;
    }

    public Y31AttachmentBean move(Document xlnetsToken, String pathFrom, String pathTo) throws Y31JanoServiceGenericException, Y31JanoServiceFileNameFormatException, Y31JanoServiceMongoDbGenericException, Y31JanoServiceAccesDeniedException, Y31JanoServiceEventJmsException, Y31JanoServiceFileNotFoundException {
        return this.move(xlnetsToken, pathFrom, pathTo, false);
    }

    public Y31AttachmentBean move(Document xlnetsToken, String pathFrom, String pathTo, boolean preserveName) throws Y31JanoServiceGenericException, Y31JanoServiceFileNameFormatException, Y31JanoServiceMongoDbGenericException, Y31JanoServiceAccesDeniedException, Y31JanoServiceEventJmsException, Y31JanoServiceFileNotFoundException {
        long t0 = System.currentTimeMillis();
        long t1 = System.currentTimeMillis();
        long tt0 = System.currentTimeMillis();
        long tt1 = System.currentTimeMillis();
        ArrayList<Y31JanoServiceTraceAtom> atoms = new ArrayList<Y31JanoServiceTraceAtom>();
        String pathTo2 = Y31JanoServiceTool.normalize((String)pathTo, (boolean)preserveName);
        String pathFrom2 = Y31JanoServiceTool.normalize((String)pathFrom, (boolean)true);
        boolean success = true;
        String errorMessge = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos, true);
        Path fromPath = new Path(pathFrom2);
        Path toPath = new Path(pathTo2);
        Y31AttachmentBean a = new Y31AttachmentBean();
        String xlnetsInfo = "Error de seguridad";
        try {
            tt0 = System.currentTimeMillis();
            Y31XlnetsInfoBean tokenInfoBean = Y31JanoServiceSecurityTool.getXlnetsAuditInfo(xlnetsToken);
            tt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(tt0, tt1, 0, "tiempo en ejecutar getXlnetsAuditInfo()", 0));
            tt0 = System.currentTimeMillis();
            Y31JanoServiceSecurityTool.validateReadAccess(pathFrom2, tokenInfoBean);
            tt1 = System.currentTimeMillis();
            tt0 = System.currentTimeMillis();
            Y31JanoServiceSecurityTool.validateWriteAccess(pathTo, tokenInfoBean, fs);
            tt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(tt0, tt1, 1, "tiempo en ejecutar validateWriteAccess()", 15));
            atoms.add(new Y31JanoServiceTraceAtom(tt0, tt1, 1, "tiempo en ejecutar validateAccess()", 1));
            xlnetsInfo = tokenInfoBean.toTrace();
            if (!Y31JanoServiceImpl.exist(fromPath)) {
                success = false;
                errorMessge = "El fichero " + pathFrom2 + " no existe en el file system remoto";
                throw new Y31JanoServiceFileNotFoundException("El fichero " + pathFrom2 + " no existe en el file system remoto");
            }
            boolean success2 = true;
            if (!toPath.equals((Object)fromPath)) {
                if (Y31JanoServiceImpl.exist(toPath)) {
                    Y31JanoServiceImpl.deletePath(pathTo2);
                }
                if (!Y31JanoServiceImpl.exist(toPath.getParent())) {
                    Y31JanoServiceImpl.mkdir(toPath.getParent());
                }
                tt0 = System.currentTimeMillis();
                success2 = fs.rename(fromPath, toPath);
                tt1 = System.currentTimeMillis();
                atoms.add(new Y31JanoServiceTraceAtom(tt0, tt1, 2, "tiempo en ejecutar fs.rename()", 8));
            }
            if (!success2) {
                success = false;
                errorMessge = "Se ha producido un error en la acci\u00ef\u00bf\u00bdn y no se ha realizado (boolean success2 = fs.rename(fromPath, toPath)) " + pathFrom2 + "," + pathTo2;
                throw new Y31JanoServiceGenericException("Se ha producido un error en la acci\u00ef\u00bf\u00bdn y no se ha realizado");
            }
            tt0 = System.currentTimeMillis();
            long ttt0 = System.currentTimeMillis();
            long ttt1 = System.currentTimeMillis();
            ttt0 = System.currentTimeMillis();
            String a1 = Y31JanoServiceTool.getFileNameFromCompletPath((String)pathTo2);
            ttt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(ttt0, ttt1, 3, "tiempo en ejecutar Y31JanoServiceImpl.getFileNameFromCompletPath()", 12));
            String a2 = pathTo2;
            ttt0 = System.currentTimeMillis();
            String a3 = Y31JanoServiceMimeTypeTool.getMimeTypeFromCompletePath(pathTo2);
            ttt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(ttt0, ttt1, 4, "tiempo en ejecutar Y31JanoServiceImpl.getMimeTypeFromCompletePath()", 12));
            ttt0 = System.currentTimeMillis();
            Long a4 = Y31JanoServiceImpl.size(toPath);
            ttt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(ttt0, ttt1, 5, "tiempo en ejecutar Y31JanoServiceImpl.size()", 13));
            ttt0 = System.currentTimeMillis();
            Long a5 = Y31JanoServiceImpl.getTtlFromCompletePath(pathTo2);
            ttt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(ttt0, ttt1, 6, "tiempo en ejecutar Y31JanoServiceImpl.getTtlFromCompletePath()", 14));
            ttt0 = System.currentTimeMillis();
            Date a6 = Y31JanoServiceImpl.getCreationDateFromPath(pathTo2);
            ttt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(ttt0, ttt1, 7, "tiempo en ejecutar Y31JanoServiceImpl.getCreationDateFromPath()", 15));
            ttt0 = System.currentTimeMillis();
            Date a7 = Y31JanoServiceImpl.getModificationDateFromPath(pathTo2);
            ttt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(ttt0, ttt1, 8, "tiempo en ejecutar Y31JanoServiceImpl.getModificationDateFromPath()", 16));
            a = new Y31AttachmentBean(a1, a2, a3, a4, a5, null, false, true, true, true, a6, a7, false);
            tt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(tt0, tt1, 9, "tiempo en ejecutar new Y31AttachmentBean()", 4));
            ttt0 = System.currentTimeMillis();
            Y31JanoServiceEventsJMSManger.publish(Y31JanoServiceTool.getPathFromCompletPath((String)pathTo2), Y31JanoServiceTool.getFileNameFromCompletPath((String)pathTo2), xlnetsInfo, Y31JanoServiceEventsJMSManger.EventWhat.MOVE);
            tt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(tt0, tt1, 10, "tiempo en ejecutar Y31JanoServiceEventsJMSManger.publish()", 5));
        }
        catch (Y31JanoServiceFileNotFoundException e) {
            e.printStackTrace(pw);
            success = false;
            throw e;
        }
        catch (Y31JanoServiceEventJmsException e) {
            success = false;
            e.printStackTrace(pw);
            throw e;
        }
        catch (IOException e) {
            success = false;
            e.printStackTrace(pw);
            throw new Y31JanoServiceGenericException((Throwable)e);
        }
        catch (Y31JanoServiceAccesDeniedException e) {
            e.printStackTrace(pw);
            success = false;
            throw e;
        }
        catch (Exception e) {
            success = false;
            e.printStackTrace(pw);
            throw new Y31JanoServiceGenericException((Throwable)e);
        }
        finally {
            t1 = System.currentTimeMillis();
            if (!success && errorMessge == null) {
                errorMessge = ((Object)baos).toString();
            }
            Y31JanoServiceTrace item = new Y31JanoServiceTrace("move", a.getSize(), a.getTtl(), xlnetsInfo, pathFrom2, pathTo2, t0, t1, null, Boolean.valueOf(success), errorMessge, t1 - t0, null, "local");
            try {
                item.setAtoms(atoms);
                Y31JanoServiceTraceJMSMangerWL11.publish(item);
            }
            catch (Y31JanoServiceTraceJmsException e) {}
        }
        try {
            Y31JanoServiceTrace item;
            this.deleteMetaData(xlnetsToken, pathFrom2);
            this.putMetaData(xlnetsToken, a, item);
        }
        catch (Exception e) {
            // empty catch block
        }
        return a;
    }

    public Y31AttachmentBean copy(Document xlnetsToken, String pathFrom, String pathTo) throws Y31JanoServiceGenericException, Y31JanoServiceFileNameFormatException, Y31JanoServiceMongoDbGenericException, Y31JanoServiceAccesDeniedException, Y31JanoServiceEventJmsException, Y31JanoServiceFileNotFoundException {
        return this.copy(xlnetsToken, pathFrom, pathTo, false);
    }

    public Y31AttachmentBean copy(Document xlnetsToken, String pathFrom, String pathTo, boolean preserveName) throws Y31JanoServiceGenericException, Y31JanoServiceFileNameFormatException, Y31JanoServiceMongoDbGenericException, Y31JanoServiceAccesDeniedException, Y31JanoServiceEventJmsException, Y31JanoServiceFileNotFoundException {
        long t0 = System.currentTimeMillis();
        long t1 = System.currentTimeMillis();
        long tt0 = System.currentTimeMillis();
        long tt1 = System.currentTimeMillis();
        ArrayList<Y31JanoServiceTraceAtom> atoms = new ArrayList<Y31JanoServiceTraceAtom>();
        String xlnetsInfo = "Error de seguridad";
        String pathTo2 = Y31JanoServiceTool.normalize((String)pathTo, (boolean)preserveName);
        String pathFrom2 = Y31JanoServiceTool.normalize((String)pathFrom, (boolean)true);
        Path fromPath = new Path(pathFrom2);
        Path toPath = new Path(pathTo2);
        Y31AttachmentBean a = new Y31AttachmentBean();
        boolean success = true;
        String errorMessge = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos, true);
        try {
            tt0 = System.currentTimeMillis();
            Y31XlnetsInfoBean tokenInfoBean = Y31JanoServiceSecurityTool.getXlnetsAuditInfo(xlnetsToken);
            tt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(tt0, tt1, 0, "tiempo en ejecutar getXlnetsAuditInfo()", 0));
            tt0 = System.currentTimeMillis();
            Y31JanoServiceSecurityTool.validateReadAccess(pathFrom2, tokenInfoBean);
            tt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(tt0, tt1, 1, "tiempo en ejecutar validateAccess()", 1));
            tt0 = System.currentTimeMillis();
            Y31JanoServiceSecurityTool.validateWriteAccess(pathTo, tokenInfoBean, fs);
            tt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(tt0, tt1, 1, "tiempo en ejecutar validateWriteAccess()", 15));
            xlnetsInfo = tokenInfoBean.toTrace();
            if (!Y31JanoServiceImpl.exist(fromPath)) {
                success = false;
                errorMessge = "El fichero " + pathFrom2 + " no existe en el file system remoto";
                throw new Y31JanoServiceFileNotFoundException("El fichero " + pathFrom2 + " no existe en el file system remoto");
            }
            tt0 = System.currentTimeMillis();
            if (!Y31JanoServiceImpl.exist(toPath.getParent())) {
                Y31JanoServiceImpl.mkdir(toPath.getParent());
            }
            tt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(tt0, tt1, 2, "tiempo en crear las subcarpetas si no existen", 2));
            tt0 = System.currentTimeMillis();
            boolean success2 = FileUtil.copy((FileSystem)fs, (Path)fromPath, (FileSystem)fs, (Path)toPath, (boolean)false, (Configuration)conf);
            tt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(tt0, tt1, 3, "tiempo en ejecutar FileUtil.copy()", 9));
            if (!success2) {
                success = false;
                errorMessge = "Se ha producido un error en la acci\u00ef\u00bf\u00bdn y no se ha realizado (FileUtil.copy(fs, fromPath, fs, toPath, false, conf);) " + pathFrom2 + "," + pathTo2;
                throw new Y31JanoServiceGenericException("Se ha producido un error en la acci\u00ef\u00bf\u00bdn y no se ha realizado");
            }
            tt0 = System.currentTimeMillis();
            long ttt0 = System.currentTimeMillis();
            long ttt1 = System.currentTimeMillis();
            ttt0 = System.currentTimeMillis();
            String a1 = Y31JanoServiceTool.getFileNameFromCompletPath((String)pathTo2);
            ttt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(ttt0, ttt1, 4, "tiempo en ejecutar Y31JanoServiceImpl.getFileNameFromCompletPath()", 12));
            String a2 = pathTo2;
            ttt0 = System.currentTimeMillis();
            String a3 = Y31JanoServiceMimeTypeTool.getMimeTypeFromCompletePath(pathTo2);
            ttt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(ttt0, ttt1, 5, "tiempo en ejecutar Y31JanoServiceImpl.getMimeTypeFromCompletePath()", 12));
            ttt0 = System.currentTimeMillis();
            Long a4 = Y31JanoServiceImpl.size(toPath);
            ttt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(ttt0, ttt1, 6, "tiempo en ejecutar Y31JanoServiceImpl.size()", 13));
            ttt0 = System.currentTimeMillis();
            Long a5 = Y31JanoServiceImpl.getTtlFromCompletePath(pathFrom2);
            ttt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(ttt0, ttt1, 7, "tiempo en ejecutar Y31JanoServiceImpl.getTtlFromCompletePath()", 14));
            a = new Y31AttachmentBean(a1, a2, a3, a4, a5, null, false, true, true, true, new Date(), new Date(), false);
            tt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(tt0, tt1, 8, "tiempo en ejecutar new Y31AttachmentBean()", 4));
            ttt0 = System.currentTimeMillis();
            Y31JanoServiceEventsJMSManger.publish(Y31JanoServiceTool.getPathFromCompletPath((String)pathTo2), Y31JanoServiceTool.getFileNameFromCompletPath((String)pathTo2), xlnetsInfo, Y31JanoServiceEventsJMSManger.EventWhat.COPY);
            tt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(tt0, tt1, 9, "tiempo en ejecutar Y31JanoServiceEventsJMSManger.publish()", 5));
        }
        catch (IOException e) {
            e.printStackTrace(pw);
            success = false;
            throw new Y31JanoServiceGenericException((Throwable)e);
        }
        catch (Y31JanoServiceFileNotFoundException e) {
            e.printStackTrace(pw);
            success = false;
            throw e;
        }
        catch (Y31JanoServiceEventJmsException e) {
            success = false;
            e.printStackTrace(pw);
            throw e;
        }
        catch (Y31JanoServiceAccesDeniedException e) {
            e.printStackTrace(pw);
            success = false;
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace(pw);
            success = false;
            throw new Y31JanoServiceGenericException((Throwable)e);
        }
        finally {
            t1 = System.currentTimeMillis();
            if (!success && errorMessge == null) {
                errorMessge = ((Object)baos).toString();
            }
            Y31JanoServiceTrace item = new Y31JanoServiceTrace("copy", a.getSize(), a.getTtl(), xlnetsInfo, pathFrom2, pathTo2, t0, t1, null, Boolean.valueOf(success), errorMessge, t1 - t0, null, "local");
            try {
                item.setAtoms(atoms);
                Y31JanoServiceTraceJMSMangerWL11.publish(item);
            }
            catch (Y31JanoServiceTraceJmsException e) {}
        }
        try {
            Y31JanoServiceTrace item;
            this.putMetaData(xlnetsToken, a, item);
        }
        catch (Exception e) {
            // empty catch block
        }
        return a;
    }

    public Y31AttachmentBean info(Document xlnetsToken, String path) throws Y31JanoServiceGenericException, Y31JanoServiceFileNameFormatException, Y31JanoServiceMongoDbGenericException, Y31JanoServiceAccesDeniedException, Y31JanoServiceFileNotFoundException {
        long t0 = System.currentTimeMillis();
        long t1 = System.currentTimeMillis();
        long tt0 = System.currentTimeMillis();
        long tt1 = System.currentTimeMillis();
        ArrayList<Y31JanoServiceTraceAtom> atoms = new ArrayList<Y31JanoServiceTraceAtom>();
        String path2 = Y31JanoServiceTool.normalize((String)path, (boolean)true);
        boolean success = true;
        String errorMessge = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos, true);
        Y31AttachmentBean a = new Y31AttachmentBean();
        String xlnetsInfo = "Error de seguridad";
        try {
            Path fsPath = new Path(path2);
            boolean existe = fs.exists(fsPath);
            Y31XlnetsInfoBean tokenInfoBean = Y31JanoServiceSecurityTool.getXlnetsAuditInfo(xlnetsToken);
            if (!existe) {
                throw new Y31JanoServiceFileNotFoundException("El fichero '" + path + "' no se ha encontrado");
            }
            tt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(tt0, tt1, 0, "tiempo en ejecutar getXlnetsAuditInfo()", 0));
            tt0 = System.currentTimeMillis();
            Y31JanoServiceSecurityTool.validateReadAccess(path2, tokenInfoBean);
            tt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(tt0, tt1, 1, "tiempo en ejecutar validateAccess()", 1));
            xlnetsInfo = tokenInfoBean.toTrace();
            tt0 = System.currentTimeMillis();
            long ttt0 = System.currentTimeMillis();
            long ttt1 = System.currentTimeMillis();
            ttt0 = System.currentTimeMillis();
            String a1 = Y31JanoServiceTool.getFileNameFromCompletPath((String)path2);
            ttt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(ttt0, ttt1, 2, "tiempo en ejecutar Y31JanoServiceImpl.getFileNameFromCompletPath()", 12));
            String a2 = path2;
            ttt0 = System.currentTimeMillis();
            String a3 = Y31JanoServiceMimeTypeTool.getMimeTypeFromCompletePath(path2);
            ttt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(ttt0, ttt1, 3, "tiempo en ejecutar Y31JanoServiceImpl.getMimeTypeFromCompletePath()", 12));
            ttt0 = System.currentTimeMillis();
            Long a4 = Y31JanoServiceImpl.size(path2);
            ttt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(ttt0, ttt1, 4, "tiempo en ejecutar Y31JanoServiceImpl.size()", 13));
            ttt0 = System.currentTimeMillis();
            Long a5 = Y31JanoServiceImpl.getTtlFromCompletePath(path2);
            ttt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(ttt0, ttt1, 5, "tiempo en ejecutar Y31JanoServiceImpl.getTtlFromCompletePath()", 14));
            boolean a6 = Y31JanoServiceImpl.isDir(path2);
            ttt0 = System.currentTimeMillis();
            Date a7 = Y31JanoServiceImpl.getCreationDateFromPath(path2);
            ttt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(ttt0, ttt1, 6, "tiempo en ejecutar Y31JanoServiceImpl.getCreationDateFromPath()", 15));
            ttt0 = System.currentTimeMillis();
            Date a8 = Y31JanoServiceImpl.getModificationDateFromPath(path2);
            ttt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(ttt0, ttt1, 7, "tiempo en ejecutar Y31JanoServiceImpl.getModificationDateFromPath()", 16));
            a = new Y31AttachmentBean(a1, a2, a3, a4, a5, null, a6, true, true, true, a7, a8, this.hasSubDirs(fsPath));
            tt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(tt0, tt1, 6, "tiempo en ejecutar new Y31AttachmentBean()", 4));
        }
        catch (Y31JanoServiceFileNotFoundException e) {
            e.printStackTrace(pw);
            success = false;
            throw e;
        }
        catch (IOException e) {
            e.printStackTrace(pw);
            success = false;
            throw new Y31JanoServiceGenericException((Throwable)e);
        }
        catch (Y31JanoServiceAccesDeniedException e) {
            e.printStackTrace(pw);
            success = false;
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace(pw);
            success = false;
            throw new Y31JanoServiceGenericException((Throwable)e);
        }
        finally {
            t1 = System.currentTimeMillis();
            if (!success) {
                errorMessge = ((Object)baos).toString();
            }
            Y31JanoServiceTrace item = new Y31JanoServiceTrace("info", a.getSize(), a.getTtl(), xlnetsInfo, null, path2, t0, t1, null, Boolean.valueOf(success), errorMessge, t1 - t0, null, "local");
            try {
                item.setAtoms(atoms);
                Y31JanoServiceTraceJMSMangerWL11.publish(item);
            }
            catch (Y31JanoServiceTraceJmsException e) {}
        }
        return a;
    }

    public List<Y31AttachmentBean> list(Document xlnetsToken, String queryRegExp) throws Y31JanoServiceGenericException, Y31JanoServiceFileNotFoundException, Y31JanoServiceFileNameFormatException, Y31JanoServiceMongoDbGenericException, Y31JanoServiceAccesDeniedException {
        return this.list(xlnetsToken, queryRegExp, false);
    }

    public List<Y31AttachmentBean> list(Document xlnetsToken, String queryRegExp, boolean withFolders) throws Y31JanoServiceGenericException, Y31JanoServiceFileNotFoundException, Y31JanoServiceFileNameFormatException, Y31JanoServiceMongoDbGenericException, Y31JanoServiceAccesDeniedException {
        long t0 = System.currentTimeMillis();
        long t1 = System.currentTimeMillis();
        long tt0 = System.currentTimeMillis();
        long tt1 = System.currentTimeMillis();
        ArrayList<Y31JanoServiceTraceAtom> atoms = new ArrayList<Y31JanoServiceTraceAtom>();
        String xlnetsInfo = "Error de seguridad";
        String queryRegExp2 = Y31JanoServiceTool.normalize((String)queryRegExp, (boolean)true);
        boolean success = true;
        String errorMessge = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos, true);
        ArrayList<Y31AttachmentBean> res = new ArrayList<Y31AttachmentBean>();
        try {
            tt0 = System.currentTimeMillis();
            Y31XlnetsInfoBean tokenInfoBean = Y31JanoServiceSecurityTool.getXlnetsAuditInfo(xlnetsToken);
            tt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(tt0, tt1, 0, "tiempo en ejecutar getXlnetsAuditInfo()", 0));
            tt0 = System.currentTimeMillis();
            Y31JanoServiceSecurityTool.validateReadAccess(queryRegExp2, tokenInfoBean);
            tt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(tt0, tt1, 1, "tiempo en ejecutar validateAccess()", 1));
            xlnetsInfo = tokenInfoBean.toTrace();
            tt0 = System.currentTimeMillis();
            FileStatus[] ls = fs.listStatus(new Path(queryRegExp2));
            tt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(tt0, tt1, 2, "tiempo en ejecutar fs.listStatus()", 10));
            res = new ArrayList();
            tt0 = System.currentTimeMillis();
            if (ls != null && ls.length > 0) {
                for (FileStatus fileStatus : ls) {
                    String a1 = fileStatus.getPath().getName();
                    String a2 = fileStatus.getPath().toUri().getPath();
                    String a3 = Y31JanoServiceMimeTypeTool.getMimeTypeFromCompletePath(fileStatus.getPath().getName());
                    Long a4 = new Long(fileStatus.getLen());
                    Long a5 = new Long(-314L);
                    Date a6 = Y31JanoServiceImpl.getCreationDateFromPath(a2);
                    Date a7 = Y31JanoServiceImpl.getModificationDateFromPath(a2);
                    if (!fileStatus.isDir()) {
                        res.add(new Y31AttachmentBean(a1, a2, a3, a4, a5, null, false, true, true, true, a6, a7, false));
                        continue;
                    }
                    if (!withFolders) continue;
                    res.add(new Y31AttachmentBean(a1, a2, a3, a4, a5, null, true, true, true, true, a6, a7, this.hasSubDirs(fileStatus.getPath())));
                }
            } else if (ls == null) {
                throw new Y31JanoServiceFileNotFoundException("El directorio '" + queryRegExp + "' no existe");
            }
            tt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(tt0, tt1, 3, "tiempo en ejecutar el for (FileStatus fileStatus : ls)", 11));
        }
        catch (IOException e) {
            e.printStackTrace(pw);
            success = false;
            throw new Y31JanoServiceGenericException((Throwable)e);
        }
        catch (Y31JanoServiceAccesDeniedException e) {
            e.printStackTrace(pw);
            success = false;
            throw e;
        }
        catch (Y31JanoServiceFileNotFoundException e) {
            e.printStackTrace(pw);
            success = false;
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace(pw);
            success = false;
            throw new Y31JanoServiceGenericException((Throwable)e);
        }
        finally {
            t1 = System.currentTimeMillis();
            if (!success) {
                errorMessge = ((Object)baos).toString();
            }
            Y31JanoServiceTrace item = new Y31JanoServiceTrace("list", null, null, xlnetsInfo, null, queryRegExp, t0, t1, null, Boolean.valueOf(success), errorMessge, t1 - t0, null, "local");
            try {
                item.setAtoms(atoms);
                Y31JanoServiceTraceJMSMangerWL11.publish(item);
            }
            catch (Y31JanoServiceTraceJmsException e) {}
        }
        return res;
    }

    private static boolean exist(String path) throws IOException {
        return Y31JanoServiceImpl.exist(new Path(path));
    }

    private static boolean exist(Path path) throws IOException {
        return fs.exists(path);
    }

    private static boolean isDir(String path) throws IOException {
        return Y31JanoServiceImpl.isDir(new Path(path));
    }

    private static boolean isDir(Path path) throws IOException {
        return !fs.isFile(path);
    }

    public Y31AttachmentBean createFolder(Document xlnetsToken, String path) throws Y31JanoServiceGenericException, Y31JanoServiceFileNameFormatException, Y31JanoServiceMongoDbGenericException, Y31JanoServiceAccesDeniedException, Y31JanoServiceEventJmsException {
        long t0 = System.currentTimeMillis();
        long t1 = System.currentTimeMillis();
        long tt0 = System.currentTimeMillis();
        long tt1 = System.currentTimeMillis();
        ArrayList<Y31JanoServiceTraceAtom> atoms = new ArrayList<Y31JanoServiceTraceAtom>();
        String xlnetsInfo = "Error de seguridad";
        String path2 = Y31JanoServiceTool.normalize((String)path, (boolean)true);
        Path toPath = new Path(path2);
        Y31AttachmentBean a = new Y31AttachmentBean();
        boolean success = true;
        String errorMessge = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos, true);
        try {
            tt0 = System.currentTimeMillis();
            Y31XlnetsInfoBean tokenInfoBean = Y31JanoServiceSecurityTool.getXlnetsAuditInfo(xlnetsToken);
            tt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(tt0, tt1, 0, "tiempo en ejecutar getXlnetsAuditInfo()", 0));
            tt0 = System.currentTimeMillis();
            Y31JanoServiceSecurityTool.validateReadAccess(path, tokenInfoBean);
            tt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(tt0, tt1, 1, "tiempo en ejecutar validateAccess()", 1));
            tt0 = System.currentTimeMillis();
            Y31JanoServiceSecurityTool.validateWriteAccess(path, tokenInfoBean, fs);
            tt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(tt0, tt1, 1, "tiempo en ejecutar validateWriteAccess()", 15));
            xlnetsInfo = tokenInfoBean.toTrace();
            tt0 = System.currentTimeMillis();
            boolean success2 = Y31JanoServiceImpl.mkdir(toPath);
            tt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(tt0, tt1, 3, "tiempo en ejecutar mkdir", 17));
            if (!success2) {
                success = false;
                errorMessge = "Se ha producido un error en la acci\u00ef\u00bf\u00bdn y no se ha realizado (FileUtil.copy(fs, fromPath, fs, toPath, false, conf);) " + path2 + "," + path2;
                throw new Y31JanoServiceGenericException("Se ha producido un error en la acci\u00ef\u00bf\u00bdn y no se ha realizado");
            }
            tt0 = System.currentTimeMillis();
            long ttt0 = System.currentTimeMillis();
            long ttt1 = System.currentTimeMillis();
            ttt0 = System.currentTimeMillis();
            String a1 = Y31JanoServiceTool.getFileNameFromCompletPath((String)path2);
            ttt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(ttt0, ttt1, 4, "tiempo en ejecutar Y31JanoServiceImpl.getFileNameFromCompletPath()", 12));
            String a2 = path2;
            ttt0 = System.currentTimeMillis();
            String a3 = Y31JanoServiceMimeTypeTool.getMimeTypeFromCompletePath(path2);
            ttt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(ttt0, ttt1, 5, "tiempo en ejecutar Y31JanoServiceImpl.getMimeTypeFromCompletePath()", 12));
            ttt0 = System.currentTimeMillis();
            Long a4 = Y31JanoServiceImpl.size(toPath);
            ttt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(ttt0, ttt1, 6, "tiempo en ejecutar Y31JanoServiceImpl.size()", 13));
            ttt0 = System.currentTimeMillis();
            Long a5 = Y31JanoServiceImpl.getTtlFromCompletePath(path2);
            ttt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(ttt0, ttt1, 7, "tiempo en ejecutar Y31JanoServiceImpl.getTtlFromCompletePath()", 14));
            a = new Y31AttachmentBean(a1, a2, a3, a4, a5, null, true, true, true, true, new Date(), new Date(), false);
            tt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(tt0, tt1, 8, "tiempo en ejecutar new Y31AttachmentBean()", 4));
            ttt0 = System.currentTimeMillis();
            Y31JanoServiceEventsJMSManger.publish(Y31JanoServiceTool.getPathFromCompletPath((String)path2), Y31JanoServiceTool.getFileNameFromCompletPath((String)path2), xlnetsInfo, Y31JanoServiceEventsJMSManger.EventWhat.PUT);
            tt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(tt0, tt1, 6, "tiempo en ejecutar Y31JanoServiceEventsJMSManger.publish()", 5));
        }
        catch (IOException e) {
            e.printStackTrace(pw);
            success = false;
            throw new Y31JanoServiceGenericException((Throwable)e);
        }
        catch (Y31JanoServiceAccesDeniedException e) {
            e.printStackTrace(pw);
            success = false;
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace(pw);
            success = false;
            throw new Y31JanoServiceGenericException((Throwable)e);
        }
        finally {
            t1 = System.currentTimeMillis();
            if (!success && errorMessge == null) {
                errorMessge = ((Object)baos).toString();
            }
            Y31JanoServiceTrace item = new Y31JanoServiceTrace("put", a.getSize(), a.getTtl(), xlnetsInfo, null, path2, t0, t1, null, Boolean.valueOf(success), errorMessge, t1 - t0, null, "local");
            try {
                item.setAtoms(atoms);
                Y31JanoServiceTraceJMSMangerWL11.publish(item);
            }
            catch (Y31JanoServiceTraceJmsException e) {}
        }
        try {
            Y31JanoServiceTrace item;
            this.putMetaData(xlnetsToken, a, item);
        }
        catch (Exception e) {
            // empty catch block
        }
        return a;
    }

    private static boolean mkdir(Path path) throws IOException {
        if (fs.isFile(path)) {
            throw new IOException(path.toString() + " no un fichero");
        }
        if (fs.isDirectory(path)) {
            throw new IOException(path.toString() + " el directorio ya existe");
        }
        return fs.mkdirs(path);
    }

    public void delete(Document xlnetsToken, String path) throws Y31JanoServiceFileNameFormatException, Y31JanoServiceGenericException, Y31JanoServiceAccesDeniedException, Y31JanoServiceFileNotFoundException {
        long t0 = System.currentTimeMillis();
        long t1 = System.currentTimeMillis();
        long tt0 = System.currentTimeMillis();
        long tt1 = System.currentTimeMillis();
        ArrayList<Y31JanoServiceTraceAtom> atoms = new ArrayList<Y31JanoServiceTraceAtom>();
        String xlnetsInfo = "Error de seguridad";
        String path2 = Y31JanoServiceTool.normalize((String)path, (boolean)true);
        Path pathPath = new Path(path2);
        boolean success = true;
        String errorMessge = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos, true);
        try {
            tt0 = System.currentTimeMillis();
            Y31XlnetsInfoBean tokenInfoBean = Y31JanoServiceSecurityTool.getXlnetsAuditInfo(xlnetsToken);
            tt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(tt0, tt1, 0, "tiempo en ejecutar getXlnetsAuditInfo()", 0));
            tt0 = System.currentTimeMillis();
            Y31JanoServiceSecurityTool.validateReadAccess(path2, tokenInfoBean);
            tt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(tt0, tt1, 1, "tiempo en ejecutar validateAccess()", 1));
            xlnetsInfo = tokenInfoBean.toTrace();
            if (!Y31JanoServiceImpl.exist(pathPath)) {
                success = false;
                errorMessge = "El fichero " + path2 + " no existe en el file system remoto";
                throw new Y31JanoServiceFileNotFoundException("El fichero " + path2 + " no existe en el file system remoto");
            }
            tt0 = System.currentTimeMillis();
            boolean success2 = fs.delete(new Path(path2), false);
            tt1 = System.currentTimeMillis();
            atoms.add(new Y31JanoServiceTraceAtom(tt0, tt1, 3, "fs.delete(new Path(path2), false)", 12));
            if (!success2) {
                success = false;
                errorMessge = "Se ha producido un error en la accion y no se ha realizado (fs.delete(new Path(path2), false);) " + path2;
                throw new Y31JanoServiceGenericException("Se ha producido un error en la accion y no se ha realizado");
            }
        }
        catch (Y31JanoServiceFileNotFoundException e) {
            e.printStackTrace(pw);
            success = false;
            throw e;
        }
        catch (IOException e) {
            e.printStackTrace(pw);
            success = false;
            throw new Y31JanoServiceGenericException((Throwable)e);
        }
        catch (Y31JanoServiceAccesDeniedException e) {
            e.printStackTrace(pw);
            success = false;
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace(pw);
            success = false;
            throw new Y31JanoServiceGenericException((Throwable)e);
        }
        finally {
            t1 = System.currentTimeMillis();
            if (!success && errorMessge == null) {
                errorMessge = ((Object)baos).toString();
            }
            Y31JanoServiceTrace item = new Y31JanoServiceTrace("delete", null, null, xlnetsInfo, path2, null, t0, t1, null, Boolean.valueOf(success), errorMessge, t1 - t0, null, "local");
            try {
                item.setAtoms(atoms);
                Y31JanoServiceTraceJMSMangerWL11.publish(item);
            }
            catch (Y31JanoServiceTraceJmsException e) {}
        }
        try {
            this.deleteMetaData(xlnetsToken, path2);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static void deletePath(String path) throws IOException {
        fs.delete(new Path(path), false);
    }

    private static long size(Path path) throws IOException {
        if (!fs.isFile(path)) {
            return 0L;
        }
        return fs.getFileStatus(path).getLen();
    }

    private static long size(String path) throws IOException {
        Path p = new Path(path);
        return Y31JanoServiceImpl.size(p);
    }

    private void putMetaData(Document xlnetsToken, Y31AttachmentBean a, Y31JanoServiceTrace trace) throws Y31JanoServiceFileNameFormatException, Y31JanoServiceGenericException, Y31JanoServiceMongoDbGenericException, Y31JanoServiceEventJmsException, Y31JanoServiceAccesDeniedException {
        if (!a.getFilePath().startsWith("/metadata_user") && !a.getFilePath().startsWith("/metadata")) {
            Y31AttachmentBeanExt abe = new Y31AttachmentBeanExt(a);
            String path = Y31JanoServiceTool.path2MetaDataPath((String)a.getFilePath());
            String s = new JSONSerializer().exclude(new String[]{"*.class"}).serialize((Object)abe);
            s = s + "\n";
            ByteArrayInputStream bais = new ByteArrayInputStream(s.getBytes());
            this.put(xlnetsToken, bais, path, true, new Long(-1L));
        }
    }

    private void deleteMetaData(Document xlnetsToken, String path) throws Y31JanoServiceFileNameFormatException, Y31JanoServiceGenericException, Y31JanoServiceMongoDbGenericException, Y31JanoServiceEventJmsException, Y31JanoServiceAccesDeniedException, Y31JanoServiceFileNotFoundException {
        if (!path.startsWith("/metadata_user") && !path.startsWith("/metadata")) {
            String mpath = Y31JanoServiceTool.path2MetaDataPath((String)path);
            this.delete(xlnetsToken, mpath);
        }
    }

    private static Date getCreationDateFromPath(String path) throws IOException {
        return new Date(fs.getFileStatus(new Path(path)).getModificationTime());
    }

    private static Date getModificationDateFromPath(String path) throws IOException {
        return new Date(fs.getFileStatus(new Path(path)).getModificationTime());
    }

    private static Long getTtlFromCompletePath(String path) {
        Y31AttachmentBeanExt abe = new Y31AttachmentBeanExt();
        if (!path.startsWith("/metadata_user") && !path.startsWith("/metadata")) {
            try {
                String mpathTo = Y31JanoServiceTool.path2MetaDataPath((String)path);
                FSDataInputStream fsdata = fs.open(new Path(mpathTo));
                StringWriter sw = new StringWriter();
                IOUtils.copy((InputStream)fsdata, (Writer)sw);
                abe = (Y31AttachmentBeanExt)new JSONDeserializer().use(null, Y31AttachmentBeanExt.class).deserialize(sw.toString());
                fsdata.close();
            }
            catch (Y31JanoServiceFileNameFormatException e) {
            }
            catch (IOException e) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return abe.getTtl();
    }

    private boolean hasSubDirs(Path path) throws IOException {
        FileStatus[] children = fs.listStatus(path);
        for (int i = 0; i < children.length; ++i) {
            if (!children[i].isDir()) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        JANO_OPERATION_SUFIX = "";
        initStatus = "";
        conf = new Configuration();
        String PRE_DEFAULT_HADOOP_HOST = "hdfs://ejld024:8100";
        Boolean PRE_STRICT_SECURITY_CHECKER = true;
        String PRE_JANO_REST_END_POINT = "";
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = Y31JanoServiceImpl.class.getClassLoader();
                initStatus = initStatus + "Cargando classloader de la Y31JanoServiceImpl.class.getClassLoader() <br/>";
            } else {
                initStatus = initStatus + "Cargando classloader de la Thread.currentThread().getContextClassLoader() <br/>";
            }
            InputStream inputStream = null;
            inputStream = cl.getResourceAsStream("w11/com/ejie/y31/service/impl/y31.properties");
            if (inputStream == null) {
                inputStream = cl.getResourceAsStream("y31/y31.properties");
                initStatus = initStatus + "Cargando y31.properties del classloader general de weblogic cl.getResourceAsStream('y31/y31.properties') <br/>";
            } else {
                initStatus = initStatus + "Cargando y31.properties del jar de la implementaci\u00f3n cl.getResourceAsStream('w11/com/ejie/y31/service/impl/y31.properties') <br/>";
            }
            properties = new Properties();
            try {
                if (inputStream != null) {
                    properties.load(inputStream);
                    if (properties.getProperty("DEFAULT_HADOOP_HOST") != null && properties.getProperty("DEFAULT_HADOOP_HOST").length() > 0) {
                        PRE_DEFAULT_HADOOP_HOST = properties.getProperty("DEFAULT_HADOOP_HOST");
                    }
                    if (properties.getProperty("Y31_JANO_REST_END_POINT") != null && properties.getProperty("Y31_JANO_REST_END_POINT").length() > 0) {
                        PRE_JANO_REST_END_POINT = properties.getProperty("Y31_JANO_REST_END_POINT");
                    }
                    if (properties.getProperty("STRICT_SECURITY_CHECKER") != null && properties.getProperty("STRICT_SECURITY_CHECKER").length() > 0) {
                        PRE_STRICT_SECURITY_CHECKER = Boolean.parseBoolean(properties.getProperty("STRICT_SECURITY_CHECKER"));
                    }
                    if (properties.getProperty("JANO_OPERATION_SUFIX") != null && properties.getProperty("JANO_OPERATION_SUFIX").length() > 0) {
                        JANO_OPERATION_SUFIX = properties.getProperty("JANO_OPERATION_SUFIX");
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                initStatus = initStatus + "Error al cargar el properties ... " + e.getMessage();
            }
        }
        finally {
            STRICT_SECURITY_CHECKER = PRE_STRICT_SECURITY_CHECKER;
            DEFAULT_HADOOP_HOST = PRE_DEFAULT_HADOOP_HOST;
            JANO_REST_END_POINT = PRE_JANO_REST_END_POINT;
            conf.set(FS_DEFAULT_NAME_PARAM_NAME, DEFAULT_HADOOP_HOST);
            conf.set(DFS_REPLICATION_PARAM_NAME, DEFAULT_HADOOP_REPLICATION);
            conf.set(DFS_BLOCKSIZE_PARAM_NAME, DEFAULT_HADOOP_BLOCK_SIZE);
            conf.set(DFS_PERMISSIONS_PARAM_NAME, DEFAULT_DFS_PERMISSIONS);
            try {
                fs = FileSystem.get((Configuration)conf);
            }
            catch (IOException e) {
                e.printStackTrace();
                initStatus = initStatus + "Error al inicializar el HDFS fs = FileSystem.get(conf) " + e.getMessage() + "<br/>";
            }
        }
    }
}

