#!/bin/bash

_DEBUG=false


##########################
# usage
##########################
usage ()
{
        echo "Usage: y31ApiBatchUP.sh (options) [user] [pass] [comando ...] [params...]"
        echo "Options: "
        echo "  -d | --debug"
        echo "  -v | --verbose  "
        echo "  -h | --help     "
        echo
        echo "+ User: usuario aplicacion xlnets"
        echo "+ Pass: password aplicacion xlnets"
        echo "+ Comando: [ info, list, put, putd, putdf, get, getd, getdf, move, copy, delete, deleted, deletedf ]"
        echo "  info            [path]          path del nodo remoto"
        echo "  list            [path]          path del directorio remoto"
        echo "                  (withFolder)    default: true; indica si queremos mostrar directorios o slo ficheros"
        echo "  put             [pathFrom]      path local del fichero a subir"
        echo "                  [pathTo]        path remoto del fichero a subir. ej: /t17i/fichero.txt"
        echo "                  (preserveName)  normalizacin de nombre. default: _false_"
        echo "                  (ttl)           tiempo de vida. default: _15 das_"
        echo "  putd            [pathFrom]      path local del directorio con ficheros a subir. no recursivo"
        echo "                  [pathTo]        path remoto del directorio ej: /t17i "
        echo "                  (preserveName)  "
        echo "                  (ttl)"
        echo "  putdf           [filePath]      fichero local con 1 fila por cada directorio a subir 'pathFrom#pathTo'. no recursivo"
        echo "                  (preserveName)  "
        echo "                  (ttl)           "
        echo "  get             [filePathFrom]  ruta remota del archivo a obtener"
        echo "                  (filePathTo)    ruta local del fichero a descargar"
        echo "  getd            [pathFrom]      ruta remota del directorio a obtener. no recursivo"
        echo "                  (pathTo)        ruta local en donde depositar el directorio a obtener. default: _cwd_"
        echo "                  (delete)        _true_ si se quiere eliminar el contenido en servidor. default: false"
        echo "  getdf           [filePath]      fichero local con 1 fila por directorio a descargar 'pathFrom#pathTo'. no recursivo"
        echo "  move            [pathFrom]      ruta del fichero remoto from"
        echo "                  [pathTo]        ruta del fichero remoto to"
        echo "                  (preserveName)  "
        echo "  copy            [pathFrom]"
        echo "                  [pathTo]"
        echo "                  (preserveName)  "
        echo "  delete          [path]          ruta del fichero remoto"
        echo "  deleted         [path]          ruta del directorio remoto a eliminar. no recursivo. no se elimina el propio dir"
        echo "  deletedf        [filePath]      fichero local con 1 fila por cada directorio a eliminar. no recursivo. no se elimina el propio dir"
        echo
}

##########################
# debug
##########################
debug(){
        if [ $_DEBUG = true ] ; then
                echo $@
        fi
}


##########################
# init
##########################
init ()
{
        BASE_URL="http://svc.integracion.jakina.ejiedes.net/y31dApiJSUserWAR"

        Y31_INFO_URL="$BASE_URL/Y31JanoServiceInfoServlet"
        Y31_LIST_URL="$BASE_URL/Y31JanoServiceListServlet"
        Y31_PUT_URL="$BASE_URL/Y31JanoServicePutServlet"
        Y31_MV_URL="$BASE_URL/Y31JanoServiceMoveServlet"
        Y31_CP_URL="$BASE_URL/Y31JanoServiceCopyServlet"
        Y31_GET_URL="$BASE_URL/Y31JanoServiceGetServlet"
        Y31_DEL_URL="$BASE_URL/Y31JanoServiceDeleteServlet"

        if [ $1 ] && [ $2 ] && [ $3 ];  then
                y31_comando=$3
                y31_user=$1
                y31_pass=$2
                debug "-- Comando '$y31_comando'"
                debug "-- Credenciales XLNets '$y31_user/$y31_pass'"
        fi
}



##########################
# utils
##########################

isSuccess(){
        debug "-- IsSuccess | params: '$@'"
        y31_success=`echo $@ | json | egrep '^\[.?,?\"success\"\]' | cut -f 2 | head -1`
        debug "-- IsSuccess | success: '$y31_success'"
        if [ $y31_success = true ] ; then
                return 0
        else
                return -1
        fi
}


processResponse(){
        debug "-- Process response | response: $@"
        if [ -z "$1" ] ; then
                echo "El servidor no responde"
                exit -1
        fi

        isSuccess $@
        if [ $? -eq 0 ] ; then
                debug "-- Process response | return 0"
                return 0
        else
                y31_statusCode=$(echo $@ | json | egrep '^\[\"statusCode\"\]' | cut -f 2 | head -1)
                debug "-- Process Response | statusCode: '$y31_statusCode'"
                if [ -z "$y31_statusCode" ] ; then
                        return $y31_statusCode
                else
                        return -1
                fi
        fi
}


getListFiles(){
        debug "-- GetListFiles | params : '$@'"
        y31_listFiles=`echo $@ |  json | egrep '^\[.+,\"filePath\"\]' | cut -f 2 | sed "s/\"//g"`
        debug $y31_listFiles
}


##########################
# commands
##########################


# ---------------
# -- INFO
# ---------------
info(){
        debug "-- Info | hadoop_file_path: '$4'"
        if [ ! -z "$4" ] ; then
                y31_response=$(curl -s -d "xlnets_user=$y31_user" -d "xlnets_password=$y31_pass" -d "hadoop_file_path=$4" $Y31_INFO_URL)
                echo "$y31_response"
                processResponse $y31_response
                return
        else
                echo "-- Se require especificar [path]"
                usage
                return -1
        fi
}

# --------------
# -- LIST
# --------------
list(){
        debug "-- List | hadoop_dir_path: '$4' | withFolder: '$5'"
        if [ ! -z "$4" ] ; then
                if [ -z "$5" ] ; then
                        y31_withFolders=true
                else
                        y31_withFolders=$5
                fi
                y31_response=$(curl -s -d "xlnets_user=$y31_user" -d "xlnets_password=$y31_pass" -d "hadoop_dir_path=$4" -d "with_folders=$y31_withFolders" $Y31_LIST_URL)
                debug "List | response '$y31_response'"
                if [ -z "$y31_response" ] ; then
                        debug "-- List | El directorio no tiene ficheros"
                        return
                else
                        echo "$y31_response"
                        processResponse $y31_response
                        return
                fi
        else
                echo "-- Se requiere especificar [path]"
                usage
                return -1
        fi
}

# --------------
# -- PUT
# --------------

put(){
        debug "-- Put | pathFrom: '$4' | pathTo: '$5' | preserveName: '$6' | ttl: '$7'"
        if [ ! -z "$4" ] && [ ! -z "$5" ] ; then

                if [ ! -e "$4" ] ; then
                        echo "-- El fichero especificado '$4' no existe en local"
                        return -1
                fi

                if [ -z "$6" ] ; then
                        y31_preserveName=false
                else
                        y31_preserveName=$6

                        if [ -z "$7" ] ; then
                                y31_ttl=1296000
                        else
                                y31_ttl=$7
                        fi
                fi
                y31_response=$(curl -s -F "xlnets_user=$y31_user" -F "xlnets_password=$y31_pass" -F "hadoop_file_path=$5" -F "y31_ttl=$y31_ttl" -F "hadoop_preserve_name=$y31_preserveName" -F "app_=@$4" $Y31_PUT_URL )
                echo "$y31_response"
                processResponse $y31_response
                debug
                return
        else
                echo "-- Se requiere especificar [pathFrom] [pathTo]"
                usage
                return -1
        fi
}

putd(){
        debug "-- Put Dir | pathFrom: '$4' | pathTo: '$5' | preserveName: '$6' | ttl: '$7'"
        if [ ! -z "$4" ] && [ ! -z "$5" ] ; then

                if [ ! -d "$4" ] ; then
                        echo "-- El directorio especificado '$4' no existe en local"
                        return -1
                fi


                if [ -z "$6" ] ; then
                        y31_preserveName=false
                else
                        y31_preserveName=$6

                        if [ -z "$7" ]
                        then
                                y31_ttl=1296000
                        else
                                y31_ttl=$7
                        fi
                fi

                for file in `find $4 -maxdepth 1 -type f | awk -F/ '{print $NF}'` ; do
                        put $1 $2 $3 $4/$file $5/$file $y31_preserveName $y31_ttl
                        if [ $? -ne 0 ] ; then
                                debug "-- Put Dir Error | statusCode: '$?'"
                                return $?
                        fi
                        debug
                done
                return
        else
                echo "-- Se requiere especificar [pathFrom] [pathTo]"
                usage
                return -1
        fi

}

putdf(){
        debug "-- Put Dirs in file | fileName: '$4' | preserveName: '$5' | ttl: '$6'"
        if [ ! -z "$4" ] ; then

                if [ ! -e "$4" ] ; then
                        echo "-- El fichero especificado '$4' no existe en local"
                        return -1
                fi

                y31_putdf_files=`cat $4`
                for putf in ${y31_putdf_files[@]} ; do
                        pathFrom=${putf%%#*}
                        pathTo=${putf##*#}

                        debug "-- Put Dirs in file | pathFrom: '$pathFrom'"
                        if [ -d $pathFrom ]; then
                                putd $1 $2 $3 $pathFrom $pathTo $6 $7
                        else
                                echo "-- El directorio especificado '$pathFrom' no existe en local"
                                return -1
                        fi

                        y31_lastReturn=$?
                        if [ $y31_lastReturn -ne 0 ] ; then
                                debug "-- Put Dirs in files | statusCode: '$y31_lastReturn'"
                                return $?
                        fi
                        debug
                done
        else
                echo "-- Se requiere especificar [fileName] "
                usage
                return -1
        fi
}


# --------------
# -- GET
# --------------
get(){
        debug "-- Get | filePathFrom: '$4' | filePathTo: '$5'"
        if [ ! -z "$4" ] ; then
                y31_fileName=`echo $4 | awk -F/ '{print $NF}'`

                if [ -z "$5" ] ; then
                        y31_pathTo="$(dirname $0)/$y31_fileName"
                else
                        y31_pathTo="$5"
                fi

                if [ -d $y31_pathTo ] ; then
                        echo "-- El fichero destino especificado es un directorio. Se require especificar [filePathTo]"
                fi

                debug "-- Get | y31_pathTo: '$y31_pathTo'"

                # miramos previamente si existe, para ver si procesar fichero resultante o no
                y31_response=$(curl -s -d "xlnets_user=$y31_user" -d "xlnets_password=$y31_pass" -d "hadoop_file_path=$4" $Y31_INFO_URL)
                processResponse $y31_response
                if [ $? -eq 0 ] ; then
                        curl -s --create-dirs -o $y31_pathTo -d "xlnets_user=$y31_user" -d "xlnets_password=$y31_pass" -d "hadoop_file_path=$4" $Y31_GET_URL
                else
                        debug "-- El fichero a obtener '$4' no existe"
                        echo "$y31_response"
                fi
                debug
                return
        else
                echo "-- Se requiere especificar [filePathFrom] [filePathTo]"
                usage
                return -1
        fi
}

getd(){
        debug "-- Get directory | pathFrom: '$4' | pathTo: '$5' | delete: '$6'"
        if [ ! -z "$4" ] ; then

                if [ -z "$5" ] ; then
                        y31_dirTo="$(dirname $0)"
                else
                        y31_dirTo=$5

                        if [ -z "$6" ] ; then
                                y31_delete=false
                        else
                                y31_delete=$6
                        fi
                        debug "-- Get dir | delete: '$y31_delete'"
                fi


                # listamos ficheros
                # ----------------------
                y31_listResponse=$(curl -s -d "xlnets_user=$y31_user" -d "xlnets_password=$y31_pass" -d "hadoop_dir_path=$4" -d "with_folders=false" $Y31_LIST_URL)
                if [ -z "$y31_listResponse" ] ; then
                        echo "-- Get directory | El directorio '$4' no tiene ficheros"
                        return
                fi
                debug "-- Get directory file | List response: $y31_listResponse"

                processResponse $y31_listResponse
                if [ $? -ne 0 ]; then
                        echo "$y31_listResponse"
                        return $?
                else
                        getListFiles $y31_listResponse

                        # por cada fichero lo descargamos y borramos
                        # ---------------------------------------------
                        for file in $y31_listFiles
                        do
                                debug "-- Get directory file | $file "
                                y31_fileName=`echo $file | awk -F/ '{print $NF}'`
                                get $1 $2 $3 $file $y31_dirTo/$y31_fileName

                                if [ "$y31_delete" = "true" ]; then
                                        debug "-- Get directory | Fichero '$file' eliminado"
                                        delete $1 $2 $3 $file
                                fi
                                debug
                        done
                fi
        else
                echo "-- Se requiere especificar [pathFrom]"
                usage
                return -1
        fi
}

getdf(){
        debug "-- Get dirs in file | fileName: '$4' | delete: '$5'"
        if [ ! -z "$4" ] ; then

                if [ ! -e "$4" ] ; then
                        echo "-- El fichero especificado '$4' no existe en local"
                        return -1
                fi

                if [ -z "$5" ] ; then
                        y31_delete=false
                else
                        y31_delete=$5
                fi
                debug "-- Get dirs in file | delete: '$y31_delete'"

                y31_getdf_files=`cat $4`
                for getf in ${y31_getdf_files[@]} ; do
                        pathFrom=${getf%%#*}
                        pathTo=${getf##*#}

                        debug "-- Get Dirs in file | pathFrom: '$pathFrom'"

                        ##
                        # @note: aqui se podra hacer igual que en el putdf y poder bajar ficheros y/o directorios
                        # al contrario que el put, con el get no sabemos si son ficheros o dirs si no tratamos cada nodo
                        ##

                        getd $1 $2 $3 $pathFrom $pathTo $y31_delete
                        debug

                        if [ $? -ne 0 ] ; then
                                echo "--Get Dirs in files | statusCode: '$?'"
                                return $?
                        fi
                        debug
                done
        else
                echo "-- Se requiere especificar [fileName] "
                usage
                return -1
        fi
}


# --------------
# -- MOVE
# --------------
move(){
        debug "-- Move | pathFrom: '$4' | pathTo: '$5' | preserveName:'$6'"
        if [ ! -z "$4" ]  && [ ! -z "$5" ] ; then
                if [ -z "$6" ] ; then
                        y31_preservNname=false
                else
                        y31_preserveName=$6
                fi

                y31_response=$(curl -s -d "xlnets_user=$y31_user" -d "xlnets_password=$y31_pass" -d "hadoop_file_from=$4" -d "hadoop_file_to=$5" -d "hadoop_preserve_name=$y31_preserveName" $Y31_MV_URL)
                echo "$y31_response"
                processResponse $y31_response
                debug
        else
                echo "-- Se requiere especificar [pathFrom] [pathTo]"
                usage
        fi
}



# --------------
# -- COPY
# --------------

copy(){
        debug "-- Copy | pathFrom: '$4' | pathTo: '$5' | preserveName:'$6'"
        if [ ! -z "$4" ] && [ ! -z "$5" ] ; then
                if [ -z "$6" ]; then
                        y31_preserveName=false
                else
                        y31_preserveName=$6
                fi
                y31_response=$(curl  -s -d "xlnets_user=$y31_user" -d "xlnets_password=$y31_pass" -d "hadoop_file_from=$4" -d "hadoop_file_to=$5" -d "hadoop_preserve_name=$y31_preserveName" $Y31_CP_URL )
                echo "$y31_response"
                processResponse $y31_response
                debug
                return
        else
                echo "-- Se requiere especificar [pathFrom] [pathTo]"
                usage
                return -1
        fi
}


# --------------
# -- DELETE
# --------------

delete(){
        debug "-- Delete | path: '$4'"
        if [ ! -z "$4" ] ; then
                y31_response=$(curl -s -d "xlnets_user=$y31_user" -d "xlnets_password=$y31_pass" -d "hadoop_file_path=$4" $Y31_DEL_URL)
                if [ -z "$y31_response" ] ; then
                        debug "-- Delete | Borrado realizado satisfactoriamente"
                        return
                else
                        echo "$y31_response"
                        processResponse $y31_response
                        debug
                        return
                fi
        else
                echo "-- Se requiere especificar [path]"
                usage
                return -1
        fi
}


deleted(){
        debug "-- Delete Dir | path: '$4'"
        if [ ! -z "$4" ] ; then

                # listamos ficheros
                # ----------------------

                y31_listResponse=$(curl -s -d "xlnets_user=$y31_user" -d "xlnets_password=$y31_pass" -d "hadoop_dir_path=$4" -d "with_folders=false" $Y31_LIST_URL)

                if [ -z "$y31_listResponse" ] ; then
                        debug "-- Delete Dir | El directorio no tiene ficheros"
                        return
                fi

                processResponse $y31_listResponse

                if [ $? -ne 0 ]; then
                        return $?
                else
                        getListFiles $y31_listResponse

                        # borramos ficheros hijo
                        # ---------------------------------------------
                        for file in $y31_listFiles ; do
                                debug "-- Delete Dir | file: '$file'"
                                delete $1 $2 $3 $file

                                if [ $? -ne 0 ] ; then
                                        debug "-- Delete Dir | statusCode: '$?'"
                                        return $?
                                fi
                        done
                fi
                debug
                return
        else
                echo "-- Se requiere especificar [path]"
                usage
                return -1
        fi

}

deletedf(){
        debug "-- Delete Dirs in File | filePath: '$4'"
        if [ ! -z "$4" ] ; then

                if [ ! -e "$4" ] ; then
                        echo "-- El fichero especificado '$4' no existe en local"
                        return -1
                fi
                y31_deletedf_dirs=`cat $4`
                for deldir in ${y31_deletedf_dirs[@]} ; do

                        debug "-- Delete Dirs in file | pathFrom: '$deldir'"
                        deleted $1 $2 $3 $deldir
                        if [ $? -ne 0 ] ; then
                                debug "--Delete Dirs in files | delete dir statusCode: '$?'"
                                return $?
                        fi
                        debug
                done
        else
                echo "-- Se requiere especificar [fileName] "
                usage
                return -1
        fi
}


##########################
# main
##########################


while [ "$1" != "" ]; do
        case $1 in
                -d | --debug )
                        set -x
                        shift
                        ;;
                -v | --verbose )
                        _DEBUG=true
                        shift
                        ;;

                -h | --help )
                        usage
                        exit
                        ;;
                * )
                         break
                         ;;
        esac
done

init $@
y31_comandoUpper=`echo $y31_comando | tr '[:lower:]' '[:upper:]'`
case $y31_comandoUpper in

        "INFO")         info $@;;
        "LIST")         list $@;;

        "PUTDF")        putdf $@;;
        "PUTD")         putd $@;;
        "PUT")          put $@;;

        "GETDF")        getdf $@;;
        "GETD")         getd $@;;
        "GET")          get $@;;

        "MOVE")         move $@;;
        "COPY")         copy $@;;

        "DELETEDF")     deletedf $@;;
        "DELETED")      deleted $@;;
        "DELETE")       delete $@;;

        *)
                        echo "-- El comando '$y31_comando' no se reconoce"
                        usage;;
esac
exit

