//___________________________________________________________________________\\
// PopUpWindow object
// Pass it a DIV name to use a DHTML popUp
function PopUpWindow(divName) {
	// Method mappings
		this.getPositionAnchorRelative = PopUpWindow_getPositionAnchorRelative;
		this.setPosition = PopUpWindow_setPosition;
		this.moveTo = PopUpWindow_moveTo;
		this.populate = PopUpWindow_populate;
		this.refresh = PopUpWindow_refresh;
		this.showPopUp = PopUpWindow_showPopUp;
		this.hidePopUp = PopUpWindow_hidePopUp;
		this.setSize = PopUpWindow_setSize;
		this.isClicked = PopUpWindow_isClicked;
		this.autoHide = PopUpWindow_autoHide;
		this.hideIfNotClicked = PopUpWindow_hideIfNotClicked;
		this.attachEvents = PopUpWindow_attachEvents;

	// Inicializacion
		// Array de popUpWindow Objects que almacena todos los popUps
		if (!window.popUpWindowObjects) { 
			window.popUpWindowObjects = new Array(); 
		}		
		// Indice de este popUpWindow dentro del array de popUps
		if (!window.popUpWindowIndex) { 
			window.popUpWindowIndex = 0; 
		}
		this.index = popUpWindowIndex++;
		// Aadir la ventana en un array que controla las ventanas abiertas
		popUpWindowObjects[this.index] = this;

		this.popUpWindow = null;			// La ventana (puede ser una referencia a un div o un msgbox)....
		this.width=0;						// Ancho del popUp
		this.height=0;						// Alto del popUp
		this.populated = false;				// Se ha establecido el contenido del popUp?
		this.visible = false;				// Es visible el popUp?
		this.autoHideEnabled = false;		// El popUp se oculta automaticamente cuando se pincha fuera de el?
		this.isMoveable = true;				// El popUp se puede mover (drag & drop)?
		this.title = "";					// Titulo del popUp
		this.contents = "";					// El html del popUp
		this.x = 0;							// La posicion x (left) del borde superior izquierdo del popUp
		this.y = 0;							// La posicion y (top) del borde superior izquierdo del popUp
		this.offsetX = 0;					
		this.offsetY = 0;
		
		if (arguments.length > 0) {
			this.type = "DIV";
			if (ie6 || ns6) {
				this.popUpWindow = document.getElementById(arguments[0]);
			} else if (ie4) { 
				this.popUpWindow = document.all[arguments[0]];
			} else if (ns4) { 
				this.popUpWindow = document.layers[arguments[0]]; 
			}
			if (this.popUpWindow == null) alert("ERROR EN EL HTML\r\nNo existe el div o layer '" + arguments[0]);
			// Establecer las propiedades de la capa
			this.popUpWindow.style.border = 1.5;
			this.popUpWindow.style.borderStyle = "solid";
			this.popUpWindow.style.position = "absolute";
			this.popUpWindow.style.visibility = "hidden";
			this.popUpWindow.style.zIndex = 100;
		} else {
			this.type="WINDOW";				// Un popUp en base a una ventana emergente
		}
}
//___________________________________________________________________________\\
/**
 * Funcion que aade al codigo del evento onMouseUp y onMouseDown del documento, el 
 * codigo JS necesario para drag & drop y para habilitar la propiedad autoHide que
 * esconde la ventana cuando se pincha fuera de ella
 */ 
function PopUpWindow_attachEvents() {
	if (ns4) {
		document.captureEvents(Event.MOUSEUP);
	}
	// Guardar los antiguos codigos de evento
	window.popUpWindowOldOnMouseUpEvent = document.onmouseup;
	window.popUpWindowOldOnMouseDownEvent = document.onmousedown;
	
	// Atachar los eventos drag & drop y el evento que permite esconder la ventana
	// cuando se pincha fuera de ella si la propiedad autoHide est habilitad
	var strEvent = "";
	if (this.isMoveable) {
		strEvent = "window.dragging = false;" + (window.popUpWindowOldMouseUpEvent != null ? "window.popUpWindowOldMouseUpEvent();":"") + "PopUpWindow_hidePopUpWindows();";
	} else {
		strEvent = (window.popUpWindowOldMouseUpEvent != null ? "window.popUpWindowOldMouseUpEvent();":"") + "PopUpWindow_hidePopUpWindows();";
	}
	document.onmouseup = new Function(strEvent);

	if (this.isMoveable) {
		strEvent = (window.popUpWindowOldMouseDownEvent != null ? "window.popUpWindowOldMouseDownEvent();":"") + "popUpWindow_InitializeDrag();";
	} else {
		strEvent = (window.popUpWindowOldMouseDownEvent != null ? "window.popUpWindowOldMouseDownEvent();":"");
	}
	document.onmousedown = new Function(strEvent);
	
}
//___________________________________________________________________________\\
/** Posiciona una ventana popUp al lado del anchor <a> cuyo nombre se pasa */
function PopUpWindow_getPositionAnchorRelative(anchorname) {
	var coordinates;
	if (this.type == "WINDOW") {
		coordinates = getAnchorPositionScreenRelative(anchorname);
	} else {
		coordinates = getAnchorPositionWindowRelative(anchorname);
	}
	this.x = coordinates.x;
	this.y = coordinates.y;		
}
//___________________________________________________________________________\\
/** Posiciona una ventana popUp en las coordenadas que se pasan */
function PopUpWindow_setPosition(left,top) {
	this.x = left;
	this.y = top;
}
//___________________________________________________________________________\\
/** Mueve una ventana popUp en las coordenadas que se pasan */
function PopUpWindow_moveTo(left,top) {
	this.x = left;
	this.y = top;
	if (this.type == "DIV") {
		this.popUpWindow.style.left = this.x;
		this.popUpWindow.style.top = this.y;
	} else {
		this.popUpWindow.moveTo(this.x,this.y);
	}
}
//___________________________________________________________________________\\
/** Establece el tamao (width/height) de un popUp tipo div */
function PopUpWindow_setSize(width,height) {
	this.width = width;
	this.height = height;
}
//___________________________________________________________________________\\
/** Llena una ventana con el conteido HTML */
function PopUpWindow_populate(contents) {
	this.contents = contents;
	if (this.type == "DIV") this.refresh();
	this.populated = true;
}
//___________________________________________________________________________\\
/** Refresca los contenidos mostrados en una ventana */
function PopUpWindow_refresh() {
	var strContents = "";
	if (this.type == "DIV") {
		// Si la ventana es movible, aadir al contenido la barra superior
		if (this.isMoveable) {
			strContents = getMoveablePopUpWindowHTML(this.index,this.title,this.contents);
		} else {
			strContents = this.contents;
		}
		// Establecer el html interno
		if (ie6 || ns6 || ie4) {
			this.popUpWindow.innerHTML = strContents;
		} else if (ns4) { 
			this.popUpWindow.document.open();
			this.popUpWindow.document.writeln(strContents);
			this.popUpWindow.document.close();
		}
	} else {
		strContents = getIndependentWindowHTML(this,this.contents);
		if (strContents != null && this.popUpWindow != null && !this.popUpWindow.closed) {
			this.popUpWindow.document.open();
			this.popUpWindow.document.writeln(strContents);		
			//this.popUpWindow.document.close();	// No descomentar... casca!!
		}
	}
}
//___________________________________________________________________________\\
/**
 * Muestra y posiciona una ventana en relacion a la posicion del anchor <a>
 * que se pasa
 */
function PopUpWindow_showPopUp(anchorname) {
	// Si se pasa como argumento un anchor, mostrar el popup relativo a el
	if (arguments.length == 1) {
		this.getPositionAnchorRelative(anchorname);
	} else {
		this.x = (screen.availWidth - this.width) / 2;
		this.y = (screen.availHeight - this.height) / 2;
	}
	// Si la ventana se va a ir fuera de la ventana, moverla...
	if (screen && screen.availHeight) {
		if ((this.y + this.height) > screen.availHeight) {
			this.y = screen.availHeight - this.height;
		}
	}
	if (screen && screen.availWidth) {
		if ((this.x + this.width) > screen.availWidth) {
			this.x = screen.availWidth - this.width;
		}
	}
	this.x += this.offsetX;
	this.y += this.offsetY;
	if (!this.populated && (this.contents != "")) {
		this.populated = true;
		this.refresh();
	}
	if (this.type == "DIV") {
		// Show the DIV object
		this.popUpWindow.style.left = this.x;
		this.popUpWindow.style.top = this.y;
		this.popUpWindow.style.width = this.width;
		this.popUpWindow.style.Heigth = this.height;
		this.popUpWindow.style.visibility = "visible";
	} else {
		if (this.popUpWindow == null || this.popUpWindow.closed) {
			this.popUpWindow = window.open("about:blank","window_" + anchorname,"toolbar=no,location=no,status=no,menubar=no,scrollbars=no,resizable=no,alwaysRaised,dependent,titlebar=no," + 
																				"width=" + this.width + "," + 
																				"height=" + this.height + "," + 
																				"screenX=" + this.x + "," + 
																				"left=" + this.x + "," + 
																				"screenY=" + this.y + "," + 
																				"top=" + this.y + "");
		}
		this.refresh();
	}
	// Preparar el drag & drop y la propiedad autoHide
	this.attachEvents();
}
//___________________________________________________________________________\\
/** Oculta una ventana popUp */
function PopUpWindow_hidePopUp() {
	if (this.type == "DIV") {
		this.popUpWindow.style.visibility = "hidden";
	} else {
		if (this.popUpWindow && !this.popUpWindow.closed) {
			this.popUpWindow.close();
			this.popUpWindow = null;
		}
	}
}
//___________________________________________________________________________\\
/** Se le pasa un evento y devuelve si se ha hecho click en el popUp o fuera de el */
function PopUpWindow_isClicked(e) {
	if (this.type != "DIV") return false;
	if (ns4) {
		var clickX = e.pageX;
		var clickY = e.pageY;
		var t = this.popUpWindow;
		if ((clickX > t.left) && (clickX < t.left+t.clip.width) && (clickY > t.top) && (clickY < t.top+t.clip.height)) {
			return true;
		} else { 
			return false; 
		}
	} else if (ie6 || ie4) { 	// Need to hard-code this to trap IE for error-handling
		var t = window.event.srcElement;
		while (t.parentElement != null) {
			if (t.id == this.popUpWindow.id) {
				return true;
			}
			t = t.parentElement;
		}
		return false;
	} else if (ns4) {
		var t = e.originalTarget;
		while (t.parentNode != null) {
			if (t.id == this.popUpWindow.id) {
				return true;
			}
			t = t.parentNode;
		}
		return false;
	}
	return false;
}
//___________________________________________________________________________\\
/** 
 * Se le pasa un evento y devuelve si se puede cerrar el popUp dependiendo de 
 * si se ha hecho click en el popUp o fuera de el 
 */
function PopUpWindow_hideIfNotClicked(e) {
	if (this.autoHideEnabled && !this.isClicked(e)) {
		this.hidePopUp();
	}
}
//___________________________________________________________________________\\
/** Si se hace click fuera del popUp se cierra la ventana */
function PopUpWindow_autoHide() {
	this.autoHideEnabled = true;
}



//____________________________________________________________________________\\
/////////////////////////////////
//drag drop function for NS 4////
/////////////////////////////////
	var popUpWindow_DragSwitch = 0;
	var nsx;		// PosX for NS
	var nsy;		// PosY for NS
	var nstemp;	

	function popUpWindow_DragDropNS(name){
		if (!ns4) return;
		temp = eval(name);
		temp.captureEvents(Event.MOUSEDOWN | Event.MOUSEUP);
		temp.onmousedown = popUpWindow_GoNS;
		temp.onmousemove = popUpWindow_DragNS;
		temp.onmouseup = popUpWindow_StopNS;
	}
	function popUpWindow_GoNS(e){
		temp.captureEvents(Event.MOUSEMOVE);
		nsx = e.x;
		nsy = e.y;
	}
	function popUpWindow_DragNS(e){
		if (popUpWindow_DragSwitch == 1) {
			temp.moveBy(e.x-nsx,e.y-nsy);
			return false;
		}
	}
	function popUpWindow_StopNS(){
		temp.releaseEvents(Event.MOUSEMOVE);
	}
/////////////////////////////////////////
//drag drop function for ie4+ and NS6////
/////////////////////////////////////////
	window.popUpInDragProcess = null;		// El popUp que se esta moviendo en estos momentos
	window.dragging = false;				// Se est moviendo un popup
	var tempX = 0;		// Posicin left de la ventana
	var tempY = 0;		// Posicin top de la ventana
	var offsetX = 0;
	var offsetY = 0;
		
	function popUpWindow_DragDrop(e) {
		if (!ns6 && window.dragging) {
			window.popUpInDragProcess.style.left = tempX + event.clientX-offsetX;
			window.popUpInDragProcess.style.top = tempY + event.clientY-offsetY;
			return false;
		} else if (ns6 && window.dragging) {
			window.popUpInDragProcess.style.left = tempX + e.clientX-offsetX;
			window.popUpInDragProcess.style.top = tempY + e.clientY-offsetY;
			return false;
		}
	}
	function popUpWindow_InitializeDrag(e) {	
		var firedObj = ns6 ? e.target : event.srcElement;	// El objeto que genero el evento
		var topElement = ns6 ? "HTML" : "BODY";

		// Encontrar el div en el que se define el popup. Recordar que el nombre
		// del div ha de comenzar por p01popUpWindow
		while ( firedObj.tagName != topElement && firedObj.id.indexOf("p01popUpWindow") != 0 ) {
			firedObj = ns6 ?firedObj.parentNode : firedObj.parentElement;		// Ir buscando el div con id='p01popUpWindow<loquesea>'
		}
		if ( firedObj.id.indexOf("p01popUpWindow") == 0 ) {
			window.popUpInDragProcess = firedObj;
			// Mover la ventanita
			offsetX = (ie4 || ie6) ? event.clientX : e.clientX;
			offsetY = (ie4 || ie6) ? event.clientY : e.clientY;

			tempX = parseInt(window.popUpInDragProcess.style.left);
			tempY = parseInt(window.popUpInDragProcess.style.top);

			window.dragging = true;		// Se esta moviendo un objeto
			document.onmousemove = popUpWindow_DragDrop;
		}
	}


//==========================================================================\\
//                 FUNCIONES AUXILIARES PARA VENTANAS                       \\
//==========================================================================\\
//____________________________________________________________________________\\
	/**
	 * Obtiene el html de una ventana movible, en ventana independiente
     */
	function getIndependentWindowHTML(oWindow,contents) {
		var calHtml = "";
		calHtml += "<html>\n";
		calHtml += "<head>\n";
		calHtml += 		"<title>" + oWindow.title + "</title>\n";
		calHtml += 		"<link rel='stylesheet' type='text/css' href='/parquemovil/styles/p01/p01calendar.css'/>"
		calHtml += 		"<script language='JavaScript' src='/parquemovil/js/p01/p01calendar.js'></script>\n";
		calHtml += "</head>\n";
		calHtml += "<body marginwidth='0' marginheight='0' topmargin='0' rightMargin='0' leftMargin='0'\n";
		calHtml += 	"<center>\n";
		calHtml += 	"<table width='100%' border='1' borderwidth='0' cellspacing='0' cellpadding='0'>\n";
		calHtml += 		"<tr>\n";
		calHtml += 			"<td id='popUpContents'>\n";
		calHtml += contents + "\n";
		calHtml += 			"</td>\n";
		calHtml += 		"</tr>\n";
		calHtml += 	"</table>\n";
		calHtml += 	"</center>\n";
		calHtml += "</body>\n";
		calHtml += "</html>\n";
		return calHtml;
	}
//____________________________________________________________________________\\
	/**
	 * Obtiene el html de una ventana movible, aadiendo a los contenidos
	 * una barra para poder hacer drag & drop
     */
	function getMoveablePopUpWindowHTML(index,title,contents) {
		var sHtml = "";
		sHtml += "<table class='p01popUpWindow' border='0' cellspacing='0' cellpadding='3'>\r\n";
		// Fila superior para mover la ventana
		sHtml +=	"<tr class='p01popUpWindowDragBar'>\r\n";
		sHtml +=		"<td width='100%'>\r\n";
		sHtml +=			"<ilayer width='100%' onSelectStart='return false'>\r\n";
		sHtml +=				"<layer width='100%' onMouseOver='popUpWindow_DragSwitch=1; if(ns4) popUpWindow_DragDropNS(popUpWindow)' onMouseOout='popUpWindow_DragSwitch=0'>\r\n";
		sHtml += title + "\r\n";	// El titulo de la barra para hacer drag & drop
		sHtml +=				"</layer>\r\n";
		sHtml +=			"</ilayer>\r\n";
		sHtml +=		"</td>\r\n";
		sHtml +=		"<td>\r\n";
		sHtml +=			"<a href='#' onClick='JavaScript:PopUpWindow_hidePopUpWindow(" + index + ");return false'>\r\n";
		sHtml +=				"<img src='/parquemovil/images/p01close.gif' width='16' height='14' border='0'>\r\n";
		sHtml +=			"</a>\r\n";
		sHtml +=		"</td>\r\n";
		sHtml +=	"</tr>\r\n";
		// Contenidos de la ventana
		sHtml +=	"<tr>\r\n";
		sHtml +=		"<td width='100%' id='popUpContents' colspan='2'>\r\n";
		sHtml += contents + "\r\n";	// Los contenidos de la ventanita...
		sHtml +=		"</td>\r\n";
		sHtml +=	"</tr>\r\n";
		sHtml += "</table>\r\n";
		return sHtml;
	}
//___________________________________________________________________________\\
/** 
 * Si la propiedad autoHide est habilitada, oculta las ventanas cuando se 
 * pincha fuera de una de ellas
 */
function PopUpWindow_hidePopUpWindows(e) {
	for (var i=0; i < window.popUpWindowObjects.length; i++) {
		if (window.popUpWindowObjects[i] != null) {
			var p = window.popUpWindowObjects[i];
			p.hideIfNotClicked(e);
		}
	}
}
//___________________________________________________________________________\\
/** Oculta la ventana cuyo indice se pasa como parametro */
function PopUpWindow_hidePopUpWindow(index) {
	if (window.popUpWindowObjects == null) return;
	var currWin = window.popUpWindowObjects[index];
	if (currWin == null) return;
	currWin.hidePopUp();
}



