<?xml version="1.0" encoding="ISO-8859-1"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:fo="http://www.w3.org/1999/XSL/Format"
	version="1.0">
			<xsl:import href="\datos\m05b\file\templates\main.xsl"/>
	<xsl:template match="/">
		<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
		<fo:layout-master-set>
		    <fo:simple-page-master 
			margin-right="1.5cm"
			margin-left="1.5cm"
			margin-bottom="0.2cm"
			margin-top="0.3cm"
			page-width="29.7cm"
			page-height="21cm"
			master-name="first">
				<fo:region-body margin-top="2.5cm" margin-bottom="2.5cm"/>
				<fo:region-before extent="2cm" margin-bottom="2.5cm"/>
				<fo:region-after extent="2cm" margin-bottom="0cm"/>
			</fo:simple-page-master>
		</fo:layout-master-set>  
		<fo:page-sequence master-reference="first"> 
			<fo:static-content flow-name="xsl-region-before">
					<fo:block margin-left="7.7cm">
					<fo:external-graphic src="/datos/m05b/file/images/fop/cabeceraHacFin.jpg" height="1.7cm" width="12cm" />
				</fo:block>
			</fo:static-content> 
			<fo:static-content flow-name="xsl-region-after">
				<fo:block text-align="center" font-size="10pt">
					<!--fo:external-graphic src="c:/datos/t64a/file/imgs/behe.gif" /-->
					<fo:block text-align="right" margin-top="-1cm">
						-<fo:page-number/>-
					</fo:block>
				</fo:block>
			</fo:static-content> 
			<fo:flow flow-name="xsl-region-body">
				<fo:table border-collapse="collapse" table-layout="fixed"    margin-bottom="10pt"  width="100%">
					<fo:table-column column-width="4cm"/>
					<fo:table-column column-width="2cm"/>
					<fo:table-column column-width="2cm"/>
					<fo:table-column column-width="3cm"/>
					<fo:table-column column-width="2cm"/>
					<fo:table-column column-width="2cm"/>
					<fo:table-column column-width="2cm"/>
					<fo:table-column column-width="4cm"/>
					<fo:table-column column-width="2cm"/>
					<fo:table-body>
						<fo:table-row >
							<fo:table-cell xsl:use-attribute-sets="cabeceraprincipal" number-columns-spanned="9"> 
								<fo:block>Autoak motaren arabera: <xsl:value-of select="datos/anio"/></fo:block>								
							</fo:table-cell>
						</fo:table-row>
						<fo:table-row >
								<fo:table-cell xsl:use-attribute-sets="cabecera" > 
									<fo:block>Saila</fo:block>								
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cabecera" > 
									<fo:block>Matrikula</fo:block>								
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cabecera" > 
									<fo:block>Marka</fo:block>								
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cabecera" > 
									<fo:block>Modeloa</fo:block>								
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cabecera" > 
									<fo:block>Matrikula maila</fo:block>								
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cabecera" > 
									<fo:block>Eguneraketa data</fo:block>								
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cabecera" > 
									<fo:block>Egungo kilometroak</fo:block>								
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cabecera" > 
									<fo:block>Ibilgailu maila</fo:block>								
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cabecera" > 
									<fo:block>Egoera</fo:block>								
								</fo:table-cell>
							</fo:table-row>
						<xsl:for-each select="datos/asignaciones/vehiculo">
							<fo:table-row xsl:use-attribute-sets="bordenormal" >
								<fo:table-cell xsl:use-attribute-sets="lineaizquierda" > 
									<fo:block><xsl:value-of select="departamento"/></fo:block>								
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="linea" > 
									<fo:block><xsl:value-of select="matricula"/></fo:block>								
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="linea" > 
									<fo:block><xsl:value-of select="marca"/></fo:block>								
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="linea" > 
									<fo:block><xsl:value-of select="modelo"/></fo:block>								
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="linea" > 
									<fo:block><xsl:value-of select="fechaMatricula"/></fo:block>								
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="linea" > 
									<fo:block><xsl:value-of select="fechaAlta"/></fo:block>								
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="linea" > 
									<fo:block><xsl:value-of select='format-number(kmActuales, "#.##0", "euro")'/></fo:block>										
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="linea" > 
									<fo:block><xsl:value-of select="rangoVehiculo"/></fo:block>								
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="linea" > 
									<fo:block><xsl:value-of select="situacion"/></fo:block>								
								</fo:table-cell>
							</fo:table-row>
						</xsl:for-each>
					</fo:table-body>
				</fo:table>
			</fo:flow>
		</fo:page-sequence>
	</fo:root>	
</xsl:template>
</xsl:stylesheet>
