<?xml version="1.0" encoding="ISO-8859-1"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:fo="http://www.w3.org/1999/XSL/Format"
	version="1.0">
		<xsl:decimal-format name="euro" decimal-separator=","
grouping-separator="."/>


	<xsl:attribute-set name="cabeceraprincipal" >
  <xsl:attribute name="font-size">12pt</xsl:attribute>
  <xsl:attribute name="font-family">Helvetica</xsl:attribute>
  <xsl:attribute name="font-style">normal</xsl:attribute>
  <xsl:attribute name="font-weight">bold</xsl:attribute>  
  <xsl:attribute name="color">black</xsl:attribute>  
  <xsl:attribute name="line-height">14pt</xsl:attribute> 
  <xsl:attribute name="background-color">#efefef</xsl:attribute>  
    <xsl:attribute name="text-align">center</xsl:attribute>  
	<xsl:attribute name="padding">5pt</xsl:attribute>  
	<xsl:attribute name="margin-bottom">10pt</xsl:attribute>  
		   <xsl:attribute name="border-color">black</xsl:attribute>
  <xsl:attribute name="border-width">0.8pt</xsl:attribute>
  <xsl:attribute name="border-style">solid</xsl:attribute> 
</xsl:attribute-set>
<xsl:attribute-set name="cabecera" >
  <xsl:attribute name="font-size">10pt</xsl:attribute>
  <xsl:attribute name="font-family">Helvetica</xsl:attribute>
  <xsl:attribute name="font-style">normal</xsl:attribute>
  <xsl:attribute name="font-weight">bold</xsl:attribute>  
  <xsl:attribute name="color">black</xsl:attribute>  
  <xsl:attribute name="line-height">14pt</xsl:attribute> 
  <xsl:attribute name="background-color">White</xsl:attribute>  
    <xsl:attribute name="text-align">center</xsl:attribute>  
	<xsl:attribute name="padding">5pt</xsl:attribute>  
	<xsl:attribute name="margin-bottom">10pt</xsl:attribute>
	   <xsl:attribute name="border-color">black</xsl:attribute>
  <xsl:attribute name="border-width">0.8pt</xsl:attribute>
  <xsl:attribute name="border-style">solid</xsl:attribute>  	
</xsl:attribute-set>
<xsl:attribute-set name="linea" >
  <xsl:attribute name="font-size">7pt</xsl:attribute>
  <xsl:attribute name="font-family">Helvetica</xsl:attribute>
  <xsl:attribute name="font-style">normal</xsl:attribute>
  <xsl:attribute name="font-weight">normal</xsl:attribute>  
  <xsl:attribute name="color">black</xsl:attribute>  
  <xsl:attribute name="line-height">10pt</xsl:attribute> 
  <xsl:attribute name="background-color">white</xsl:attribute>  
    <xsl:attribute name="text-align">center</xsl:attribute>  
	<xsl:attribute name="padding">5pt</xsl:attribute>  
	<xsl:attribute name="margin-bottom">10pt</xsl:attribute>  
	   <xsl:attribute name="border-color">black</xsl:attribute>
  <xsl:attribute name="border-width">0.8pt</xsl:attribute>
  <xsl:attribute name="border-style">solid</xsl:attribute>  
</xsl:attribute-set>
<xsl:attribute-set name="lineaizquierda" >
  <xsl:attribute name="font-size">7pt</xsl:attribute>
  <xsl:attribute name="font-family">Helvetica</xsl:attribute>
  <xsl:attribute name="font-style">normal</xsl:attribute>
  <xsl:attribute name="font-weight">normal</xsl:attribute>  
  <xsl:attribute name="color">black</xsl:attribute>  
  <xsl:attribute name="line-height">10pt</xsl:attribute> 
  <xsl:attribute name="background-color">white</xsl:attribute>  
    <xsl:attribute name="text-align">left</xsl:attribute>  
	<xsl:attribute name="padding">5pt</xsl:attribute>  
	<xsl:attribute name="margin-bottom">10pt</xsl:attribute>  
	   <xsl:attribute name="border-color">black</xsl:attribute>
  <xsl:attribute name="border-width">0.8pt</xsl:attribute>
  <xsl:attribute name="border-style">solid</xsl:attribute>  
</xsl:attribute-set>
<xsl:attribute-set name="bordenormal" >
   <xsl:attribute name="border-color">black</xsl:attribute>
  <xsl:attribute name="border-width">1pt</xsl:attribute>
  <xsl:attribute name="border-style">solid</xsl:attribute>    
</xsl:attribute-set> 




	<xsl:template match="/">
		<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
		<fo:layout-master-set>
		    <fo:simple-page-master 
			margin-right="1.5cm"
			margin-left="1.5cm"
			margin-bottom="0.2cm"
			margin-top="0.3cm"
			page-width="29.7cm"
			page-height="21cm"
			master-name="first">
				<fo:region-body margin-top="2.5cm" margin-bottom="2.5cm"/>
				<fo:region-before extent="2cm" margin-bottom="2.5cm"/>
				<fo:region-after extent="2cm" margin-bottom="0cm"/>
			</fo:simple-page-master>
		</fo:layout-master-set>  
		<fo:page-sequence master-reference="first"> 
			<fo:static-content flow-name="xsl-region-before">
				<fo:block margin-left="7.7cm">
					<fo:external-graphic src="/datos/m05b/file/images/fop/cabeceraHacFin.jpg" height="1.7cm" width="12cm" />
				</fo:block>
			</fo:static-content> 
			<fo:static-content flow-name="xsl-region-after">
				<fo:block text-align="center" font-size="10pt">
					<!--fo:external-graphic src="c:/datos/t64a/file/imgs/behe.gif" /-->
					<fo:block text-align="right" margin-top="-1cm">
						-<fo:page-number/>-
					</fo:block>
				</fo:block>
			</fo:static-content> 
			<fo:flow flow-name="xsl-region-body">
				<fo:table border-collapse="collapse" table-layout="fixed"    margin-bottom="10pt"  width="100%">
					<fo:table-column column-width="1.5cm"/>
					<fo:table-column column-width="2.5cm"/>
					<fo:table-column column-width="2.5cm"/>
					<fo:table-column column-width="3.5cm"/>
					<fo:table-column column-width="1.5cm"/>
					<fo:table-column column-width="1.5cm"/>
					<fo:table-column column-width="1.5cm"/>
					<fo:table-column column-width="2cm"/>
					<fo:table-column column-width="2.5cm"/>
					<fo:table-body>
						<fo:table-row >
							<fo:table-cell xsl:use-attribute-sets="cabeceraprincipal" number-columns-spanned="9"> 
								<fo:block>Zehapen zerrenda</fo:block>								
							</fo:table-cell>
						</fo:table-row>
						<fo:table-row >	
						          
								<fo:table-cell xsl:use-attribute-sets="cabecera" > 
									<fo:block>Maila</fo:block>								
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cabecera" > 
									<fo:block>Matrikula</fo:block>								
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cabecera" > 
									<fo:block>Marka</fo:block>								
								</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cabecera" > 
									<fo:block>Modeloa</fo:block>								
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cabecera" > 
									<fo:block>Zehapena</fo:block>								
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cabecera" > 
									<fo:block>Salaketa urtea</fo:block>								
								</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cabecera" > 
									<fo:block>Zehapen data</fo:block>								
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cabecera" > 
									<fo:block>Expedientea</fo:block>								
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cabecera" > 
									<fo:block>NANa</fo:block>								
								</fo:table-cell>
							</fo:table-row>
						<xsl:for-each select="datos/lineas/sancion">
							<fo:table-row xsl:use-attribute-sets="bordenormal" >
								<fo:table-cell xsl:use-attribute-sets="lineaizquierda" > 
									<fo:block><xsl:value-of select="rango"/></fo:block>								
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="linea" > 
									<fo:block><xsl:value-of select="matricula"/></fo:block>								
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="linea" > 
									<fo:block><xsl:value-of select="marca"/></fo:block>								
								</fo:table-cell>
										<fo:table-cell xsl:use-attribute-sets="lineaizquierda" > 
									<fo:block><xsl:value-of select="modelo"/></fo:block>								
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="linea" > 
									<fo:block><xsl:value-of select="sancion"/></fo:block>								
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="linea" > 
									<fo:block><xsl:value-of select="anioDenuncia"/></fo:block>								
								</fo:table-cell>
										<fo:table-cell xsl:use-attribute-sets="lineaizquierda" > 
									<fo:block><xsl:value-of select="fechaSancion"/></fo:block>								
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="linea" > 
									<fo:block><xsl:value-of select="expediente"/></fo:block>								
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="linea" > 
									<fo:block><xsl:value-of select="dni"/></fo:block>								
								</fo:table-cell>
							</fo:table-row>
						</xsl:for-each>
					</fo:table-body>
				</fo:table>
				
				<fo:block  font-family="Helvetica" font-size="7pt" padding="20pt" >Emaitza kopurua:<xsl:value-of select="count(datos/lineas/tasa)"/></fo:block>		
			</fo:flow>
		</fo:page-sequence>
	</fo:root>	
</xsl:template>
</xsl:stylesheet>
