package m05bTransferenciasEJB;

import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

import m05bBD.m05bTransferencias;

/**
 * This class is the Bean Implementation for the Entity EJB <tt>M05TransferenciasEB</tt>.
 *
 * @see     m05.exe.Transferencias
 * @see     m05.exe.M05TransferenciasEB
 * @see     m05.exe.M05TransferenciasEBPK
 * @see     m05.exe.M05TransferenciasEBHome
 */

abstract public class m05TransferenciasBean implements EntityBean {

    private EntityContext ctx;



  /**
   * Returns the Taller information of this E-EJB.
   */
  public m05bTransferencias getTransferencias(){
    m05bTransferencias transfe = new m05bTransferencias();

    transfe.setTra_matricula(getTra_matricula());
    transfe.setTra_codigo(getTra_codigo());
    transfe.setTra_fdesde(getTra_fdesde());
    transfe.setTra_fhasta(getTra_fhasta());
    transfe.setTra_rango(getTra_rango());
    transfe.setTra_importe(getTra_importe());


    return transfe;
  }

  /**
   * Sets the Taller information of this E-EJB.
   * @exception P2GException
   *              If the given Taller <tt>tra_matricula</tt>
   *              <tt>tra_fdesde</tt><tt>tra_fhasta</tt> field
   *              does not match the primary key that is in the E-EJB.
   */
  public void setTransferencias(m05bTransferencias transfe)
    throws Exception{

    //the primary key is never modified!!
    if (getTra_codigo() != transfe.getTra_codigo())
      throw new CreateException ("Cannot modify a different taller");

    setTra_rango(transfe.getTra_rango());
    setTra_importe(transfe.getTra_importe());
    setTra_fdesde(transfe.getTra_fdesde());
    setTra_matricula(transfe.getTra_matricula());
    setTra_fhasta(transfe.getTra_fhasta());


  }

  abstract public String getTra_matricula();
  abstract public void setTra_matricula(String n);

  abstract public String getTra_fdesde();
  abstract public void setTra_fdesde(String n);

  abstract public String getTra_fhasta();
  abstract public void setTra_fhasta(String n);

  abstract public String getTra_rango();
  abstract public void setTra_rango(String n);

  abstract public String getTra_importe();
  abstract public void setTra_importe(String n);

  abstract public String getTra_codigo();
  abstract public void setTra_codigo(String n);



  public void ejbActivate() {
  }

  public void ejbPassivate() {
  }

  public void setEntityContext(EntityContext ctx) {
    this.ctx = ctx;
  }

  public void unsetEntityContext() {
    this.ctx = null;
  }

  public void ejbLoad() {
  }

  public void ejbStore() {
  }

  public void ejbRemove()
    throws RemoveException
  {
  }

  /**
   * This function initializes the Taller
   * information of this E-EJB.
   * It assigns a new primary key to the Taller.
   */
  public m05TransferenciasPK ejbCreate(m05bTransferencias transfe)
    throws CreateException
  {
    try {
      setTra_codigo(getTra_codigo());

    } catch (Exception e) {
      throw new CreateException (e.getMessage());
    }
    setTra_matricula(transfe.getTra_matricula());
    setTra_fdesde(transfe.getTra_fdesde());
    setTra_fhasta(transfe.getTra_fhasta());
    setTra_rango(transfe.getTra_rango());
    setTra_importe(transfe.getTra_importe());
    return null;
  }

  public void ejbPostCreate(m05bTransferencias transfe)
  {
  }


}
