package m05bTiposReformaEJB;

import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

import m05bBD.m05bTiposReforma;


/**
 * This class is the Bean Implementation for the Entity EJB <tt>M05TiposReformaEB</tt>.
 *
 * @see     m05.exe.TiposReforma
 * @see     m05.exe.M05TiposReformaEB
 * @see     m05.exe.M05TiposReformaEBPK
 * @see     m05.exe.M05TiposReformaEBHome
 */
abstract public class m05TiposReformaBean implements EntityBean {
  
  private EntityContext ctx;



  /** 
   * This is the primary key.
   * It is the clave, which is the primary key 
   * in table <tt>m0538t00</tt>.
   */

  /**
   * Returns the Seguro information of this E-EJB.
   */    
  public m05bTiposReforma getTiposReforma(){
    m05bTiposReforma tiposreforma = new m05bTiposReforma();
    
    tiposreforma.setTrf_codigo(getTrf_codigo());
    tiposreforma.setTrf_descripcion(getTrf_descripcion());
    tiposreforma.setTrf_descripcionEu(getTrf_descripcionEu());
    return tiposreforma;	
  }    

  /**
   * Sets the TiposReforma information of this E-EJB.
   * @exception P2GException 
   *              If the given Seguro <tt>trf_codigo</tt> field 
   *              does not match the primary key that is in the E-EJB.
   */   
  public void setTiposReforma(m05bTiposReforma tiposreforma)
    throws Exception{
   
    //the primary key is never modified!!
    if (getTrf_codigo() != tiposreforma.getTrf_codigo())
      throw new CreateException ("Cannot modify a different seguro");
      
    setTrf_descripcion(tiposreforma.getTrf_descripcion());
    
    setTrf_descripcionEu(tiposreforma.getTrf_descripcionEu());

  }   	
  
  abstract public String getTrf_codigo();
  abstract public void setTrf_codigo(String n);
  
  abstract public String getTrf_descripcion();
  abstract public void setTrf_descripcion(String n);

  abstract public String getTrf_descripcionEu();
  abstract public void setTrf_descripcionEu(String n);

  public void ejbActivate() {
  }

  public void ejbPassivate() {
  }

  public void setEntityContext(EntityContext ctx) {
    this.ctx = ctx;
  }

  public void unsetEntityContext() {
    this.ctx = null;
  }

  public void ejbLoad() {
  }
  
  public void ejbStore() {
  }

  public void ejbRemove()
    throws RemoveException
  {
  }

  /**
   * This function initializes the TiposReforma 
   * information of this E-EJB.
   * It assigns a new primary key to the Tipos de Reforma.
   */ 
  public m05TiposReformaPK ejbCreate(m05bTiposReforma tiposreforma) 
    throws CreateException
  {
    try {
      setTrf_codigo(getTrf_codigo());
    } catch (Exception e) {
      throw new CreateException (e.getMessage());
    }    
    setTrf_descripcion(tiposreforma.getTrf_descripcion());
    setTrf_descripcionEu(tiposreforma.getTrf_descripcionEu());
    return null;      	
  }

  public void ejbPostCreate(m05bTiposReforma tiposreforma) 
  {
  }

 
}
