package m05bTasasEJB;

import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

import m05bBD.m05bTasas;


/**
 * This class is the Bean Implementation for the Entity EJB <tt>M05TasasEB</tt>.
 *
 * @see     m05.exe.Tasas
 * @see     m05.exe.M05TasasEB
 * @see     m05.exe.M05TasasEBPK
 * @see     m05.exe.M05TasasEBHome

 */
abstract public class m05TasasBean implements EntityBean {
  
  private EntityContext ctx;



  /** 
   * This is the primary key.
   * It is the clave, which is the primary key 
   * in table <tt>m0532t00</tt>.
   */

  /**
   * Returns the Tasas information of this E-EJB.
   */    
  public m05bTasas getTasas(){
    m05bTasas tasa = new m05bTasas();
    
    tasa.setTas_codigo(getTas_codigo());
    tasa.setTas_matricula(getTas_matricula());
    tasa.setTas_concepto(getTas_concepto());
    tasa.setTas_municipio(getTas_municipio());
    tasa.setTas_observacion(getTas_observacion());
    tasa.setTas_fecha(getTas_fecha());
    tasa.setTas_importe(getTas_importe());

    
    return tasa;	
  }    

  /**
   * Sets the Tasas information of this E-EJB.
   * @exception P2GException 
   *              If the given Tasas <tt>tas_codigo</tt> field 
   *              does not match the primary key that is in the E-EJB.
   */   
  public void setTasas(m05bTasas tasa)
    throws Exception{
   
    //the primary key is never modified!!
    if (getTas_codigo() != tasa.getTas_codigo())
      throw new CreateException ("Cannot modify a different tasa");
      
    setTas_matricula(tasa.getTas_matricula());
    setTas_concepto(tasa.getTas_concepto());
    setTas_municipio(tasa.getTas_municipio());
    setTas_observacion(tasa.getTas_observacion());
    setTas_fecha(tasa.getTas_fecha());
    setTas_importe(tasa.getTas_importe());
    
  }   	
  
  abstract public String getTas_codigo();
  abstract public void setTas_codigo(String n);
  
  abstract public String getTas_matricula();
  abstract public void setTas_matricula(String n);

  abstract public String getTas_concepto();
  abstract public void setTas_concepto(String n);
  
  abstract public String getTas_municipio();
  abstract public void setTas_municipio(String n);
  
  abstract public String getTas_observacion();
  abstract public void setTas_observacion(String n);
  
  
  abstract public String getTas_fecha();
  abstract public void setTas_fecha(String n);
  
  abstract public String getTas_importe();
  abstract public void setTas_importe(String n);


  public void ejbActivate() {
  }

  public void ejbPassivate() {
  }

  public void setEntityContext(EntityContext ctx) {
    this.ctx = ctx;
  }

  public void unsetEntityContext() {
    this.ctx = null;
  }

  public void ejbLoad() {
  }
  
  public void ejbStore() {
  }

  public void ejbRemove()
    throws RemoveException
  {
  }

  /**
   * This function initializes the Tasas 
   * information of this E-EJB.
   * It assigns a new primary key to the Tasas.
   */ 
  public m05TasasPK ejbCreate(m05bTasas tasa) 
    throws CreateException
  {
    try {
      setTas_codigo(getTas_codigo());
    } catch (Exception e) {
      throw new CreateException (e.getMessage());
    }    
    setTas_matricula(tasa.getTas_matricula());
    setTas_concepto(tasa.getTas_concepto());
    setTas_municipio(tasa.getTas_municipio());
    setTas_observacion(tasa.getTas_observacion());
    setTas_fecha(tasa.getTas_fecha());
    setTas_importe(tasa.getTas_importe());
    return null;      	
  }

  public void ejbPostCreate(m05bTasas tasa) 
  {
  }

 
}
