package m05bTallerEJB;

import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

import m05bBD.m05bTaller;


/**
 * This class is the Bean Implementation for the Entity EJB <tt>M05TallerEB</tt>.
 *
 * @see     m05.exe.Taller
 * @see     m05.exe.M05TallerEB
 * @see     m05.exe.M05TallerEBPK
 * @see     m05.exe.M05TallerEBHome
 * @author <a href="mailto:paco.gomez@terra.com">Paco Gomez</a>.
 *         Professional J2EE Programming with BEA WebLogic Server, 
 *         by Gomez & Zadrozny, Copyright &#169; 2000. 
 */
abstract public class m05TallerBean implements EntityBean {
  
  private EntityContext ctx;

 

  
  /**
   * Returns the Taller information of this E-EJB.
   */    
  public m05bTaller getTaller(){
    m05bTaller taller = new m05bTaller();
    
    taller.setTal_codigo(getTal_codigo());
    taller.setTal_poblacion(getTal_poblacion());
    taller.setTal_descripcion(getTal_descripcion());
    taller.setTal_direccion(getTal_direccion());
    taller.setTal_telefono(getTal_telefono());
    taller.setTal_marca(getTal_marca());
    taller.setTal_propio(getTal_propio());
    taller.setTal_rama(getTal_rama());
    
    
    return taller;	
  }    

  /**
   * Sets the Taller information of this E-EJB.
   * @exception P2GException 
   *              If the given Taller <tt>tal_codigo</tt> field 
   *              does not match the primary key that is in the E-EJB.
   */   
  public void setTaller(m05bTaller taller)
    throws Exception{
   
    //the primary key is never modified!!
    if (getTal_codigo() != taller.getTal_codigo())
      throw new CreateException ("Cannot modify a different taller");
      
    setTal_poblacion(taller.getTal_poblacion());
    setTal_descripcion(taller.getTal_descripcion());
    setTal_direccion(taller.getTal_direccion());
    setTal_telefono(taller.getTal_telefono());
    setTal_marca(taller.getTal_marca());
    setTal_propio(taller.getTal_propio());
    setTal_rama(taller.getTal_rama());
  }   	
  
  abstract public String getTal_codigo();
  abstract public void setTal_codigo(String n);
  
  abstract public String getTal_poblacion();
  abstract public void setTal_poblacion(String n);

  abstract public String getTal_descripcion();
  abstract public void setTal_descripcion(String n);
  
  abstract public String getTal_direccion();
  abstract public void setTal_direccion(String n);

  abstract public String getTal_telefono();
  abstract public void setTal_telefono(String n);

  abstract public String getTal_marca();
  abstract public void setTal_marca(String n);

  abstract public String getTal_propio();
  abstract public void setTal_propio(String n);

  abstract public String getTal_rama();
  abstract public void setTal_rama(String n);

  public void ejbActivate() {
  }

  public void ejbPassivate() {
  }

  public void setEntityContext(EntityContext ctx) {
    this.ctx = ctx;
  }

  public void unsetEntityContext() {
    this.ctx = null;
  }

  public void ejbLoad() {
  }
  
  public void ejbStore() {
  }

  public void ejbRemove()
    throws RemoveException
  {
  }

  /**
   * This function initializes the Taller 
   * information of this E-EJB.
   * It assigns a new primary key to the Taller.
   */ 
  public m05TallerPK ejbCreate(m05bTaller taller) 
    throws CreateException
  {
    try {
      setTal_codigo(getTal_codigo());
    } catch (Exception e) {
      throw new CreateException (e.getMessage());
    }    
    setTal_poblacion(taller.getTal_poblacion());
    setTal_descripcion(taller.getTal_descripcion());
    setTal_direccion(taller.getTal_direccion());
    setTal_telefono(taller.getTal_telefono());
    setTal_marca(taller.getTal_marca());
    setTal_propio(taller.getTal_propio());
    setTal_rama(taller.getTal_rama());
    
    return null;
  }

  public void ejbPostCreate(m05bTaller taller) 
  {
  }

 
}
