package m05bTablaEJB;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

import m05bBD.m05bTabla;

/**
 * This class is the Bean Implementation for the Entity EJB <tt>M05TablaEB</tt>.
 *
 * @see     m05.exe.Tabla
 * @see     m05.exe.M05TablaEB
 * @see     m05.exe.M05TablaEBPK
 * @see     m05.exe.M05TablaEBHome
 * @author <a href="mailto:paco.gomez@terra.com">Paco Gomez</a>.
 *         Professional J2EE Programming with BEA WebLogic Server, 
 *         by Gomez & Zadrozny, Copyright &#169; 2000. 
 */
abstract public class m05TablaBean implements EntityBean {
  
  private EntityContext ctx;


  /** 
   * This is the primary key.
   * It is the clave, which is the primary key 
   * in table <tt>M0598T00</tt>.
   */
 /* public long tab_codigo          = 0;
  
  public String tab_descripcion      = "";*/
  
  /**
   * Returns the Tabla information of this E-EJB.
   */    
  public m05bTabla getTabla(){
    m05bTabla tabla = new m05bTabla();
    
    tabla.setTab_codigo(getTab_codigo());
    tabla.setTab_descripcion(getTab_descripcion());
    
    return tabla;	
  }    

  /**
   * Sets the Tabla information of this E-EJB.
   * @exception P2GException 
   *              If the given Tabla <tt>tab_codigo</tt> field 
   *              does not match the primary key that is in the E-EJB.
   */   
  public void setTabla(m05bTabla tabla)
    throws Exception{
   
    //the primary key is never modified!!
    if (getTab_codigo() != tabla.getTab_codigo())
      throw new CreateException ("Cannot modify a different tabla");
      
    setTab_codigo(tabla.getTab_codigo());
    setTab_descripcion(tabla.getTab_descripcion());
  }   	

  abstract public long getTab_codigo();
  abstract public void setTab_codigo(long n);

  abstract public String getTab_descripcion();
  abstract public void setTab_descripcion(String n);

  public void ejbActivate() {
  }

  public void ejbPassivate() {
  }

  public void setEntityContext(EntityContext ctx) {
    this.ctx = ctx;
  }

  public void unsetEntityContext() {
    this.ctx = null;
  }

  public void ejbLoad() {
  }
  
  public void ejbStore() {
  }

  public void ejbRemove()
    throws RemoveException
  {
  }

  /**
   * This function initializes the Tabla 
   * information of this E-EJB.
   * It assigns a new primary key to the Tabla.
   * @see #getNewOrderNum()
   */ 
  public m05TablaPK ejbCreate(m05bTabla tabla) 
    throws CreateException
  {
    try {
      setTab_codigo(getNewTab_codigo().longValue());
    } catch (Exception e) {
      throw new CreateException (e.getMessage());
    }    
    setTab_codigo(tabla.getTab_codigo());
    setTab_codigo(tabla.getTab_codigo());
    return null;      	
  }

  public void ejbPostCreate(m05bTabla tabla) 
  {
  }

  /**
   * This function finds a new primary key for this EJB.
   * It uses a sequence value from the database 
   * (<tt>M0502T00</tt>).
   * @see #ejbCreate(Tabla tabla)
   */
  private Long getNewTab_codigo() throws Exception { 

    Connection conn     = null;
    Statement  stmt     = null;
    ResultSet  resultSet= null;
    long       orderNum = 0;

    try {
      conn = DriverManager.getConnection("jdbc20:weblogic:oracle");
      stmt = conn.createStatement();
      stmt.executeQuery("select max(codigo) + 1 from m0598t00");
      resultSet = stmt.getResultSet();
      if ((resultSet != null) && (resultSet.next())) {
        setTab_codigo(resultSet.getLong(1));
      } else {
        throw new CreateException ("ejbCreate: select failed to return a value");
      }
    } 
    catch (SQLException sqe) {
      throw new CreateException (sqe.getMessage());
    } 
    finally {
      try{
        if (resultSet != null) resultSet.close();      
        if (stmt != null)      stmt.close();
        if (conn != null)      conn.close();
      }
      catch(Exception w){
        System.err.println("Warning: m05TablaEBBean.getNewTab_codigo: " + w);
      }         
    }
    return new Long(getTab_codigo());
  }

}
