package m05bSolicitudReserva_UsuarioEJB;

import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

import m05bBD.m05bMunicipio;
import m05bBD.m05bProvincia;
import m05bBD.m05bSolicitudReserva_Usuario;

/**
 * This class is the Bean Implementation for the Entity EJB <tt>M05SolicitudReserva_UsuarioEB</tt>.
 *
 * @see     m05.exe.SolicitudReserva_Usuario
 * @see     m05.exe.M05SolicitudReserva_UsuarioEB
 * @see     m05.exe.M05SolicitudReserva_UsuarioEBPK
 * @see     m05.exe.M05SolicitudReserva_UsuarioEBHome
 */
abstract public class m05SolicitudReserva_UsuarioBean implements EntityBean {
  private EntityContext ctx;

  /**
   * This is the primary key.
   * It is the clave, which is the primary key
   * in table <tt>m05101t00</tt>.
   */

  /**
   * Returns the Personal information of this E-EJB.
   */
  public m05bSolicitudReserva_Usuario getSolicitudReserva_Usuario() {

    m05bSolicitudReserva_Usuario SolicitudReserva_Usuario = new m05bSolicitudReserva_Usuario();

    SolicitudReserva_Usuario.setIdSolicitud(getIdSolicitud());
    SolicitudReserva_Usuario.setCodSolicitante(getCodSolicitante());
    SolicitudReserva_Usuario.setDni(getDni());
    SolicitudReserva_Usuario.setNombre_apellidos(getNombre_apellidos());
    SolicitudReserva_Usuario.setTelefono(getTelefono());
    SolicitudReserva_Usuario.setTelefonoMovil(getTelefonoMovil());
    SolicitudReserva_Usuario.setDomicilio(getDomicilio());

    m05bProvincia provincia = new m05bProvincia();
    provincia.setCodigo(getCodProvincia());
    SolicitudReserva_Usuario.setProvincia(provincia);

    m05bMunicipio municipio = new m05bMunicipio();
    municipio.setCodigo(getCodMunicipio());
    SolicitudReserva_Usuario.setMunicipio(municipio);

    SolicitudReserva_Usuario.setCodPostal(getCodPostal());
    SolicitudReserva_Usuario.setPuesto(getPuesto());
    SolicitudReserva_Usuario.setCodDepartamento(getCodDepartamento());
    SolicitudReserva_Usuario.setDesccDepartamento(getDesccDepartamento());
    SolicitudReserva_Usuario.setDesceDepartamento(getDesceDepartamento());
    SolicitudReserva_Usuario.setCodDireccion(getCodDireccion());
    SolicitudReserva_Usuario.setDesccDireccion(getDesccDireccion());
    SolicitudReserva_Usuario.setDesceDireccion(getDesceDireccion());
    
    return SolicitudReserva_Usuario;
  }

  /**
   * Sets the SolicitudReserva_Usuario information of this E-EJB.
   * @exception P2GException 
   *              If the given Personal <tt>per_dni</tt> field 
   *              does not match the primary key that is in the E-EJB.
   */
  public void setSolicitudReserva_Usuario(m05bSolicitudReserva_Usuario SolicitudReserva_Usuario) throws Exception {
    //the primary key is never modified!!
    if (!(getIdSolicitud().intValue() == SolicitudReserva_Usuario.getIdSolicitud().intValue()
    		&& getCodSolicitante().equals(SolicitudReserva_Usuario.getCodSolicitante())))
    	throw new CreateException ("Cannot modify a different Solicitud reserva_Usuario");

    setDni(SolicitudReserva_Usuario.getDni());
    setNombre_apellidos(SolicitudReserva_Usuario.getNombre_apellidos());
    setTelefono(SolicitudReserva_Usuario.getTelefono());
    setTelefonoMovil(SolicitudReserva_Usuario.getTelefonoMovil());
    setDomicilio(SolicitudReserva_Usuario.getDomicilio());
    setCodProvincia(SolicitudReserva_Usuario.getProvincia().getCodigo());
    setCodMunicipio(SolicitudReserva_Usuario.getMunicipio().getCodigo());
    setCodPostal(SolicitudReserva_Usuario.getCodPostal());
    setPuesto(SolicitudReserva_Usuario.getPuesto());
    setCodDepartamento(SolicitudReserva_Usuario.getCodDepartamento());
    setDesccDepartamento(SolicitudReserva_Usuario.getDesccDepartamento());
    setDesceDepartamento(SolicitudReserva_Usuario.getDesceDepartamento());
    setCodDireccion(SolicitudReserva_Usuario.getCodDireccion());
    setDesccDireccion(SolicitudReserva_Usuario.getDesccDireccion());
    setDesceDireccion(SolicitudReserva_Usuario.getDesceDireccion());
  }

  
  abstract public Integer getIdSolicitud();
  abstract public void setIdSolicitud(Integer n);

  abstract public String getCodSolicitante();
  abstract public void setCodSolicitante(String n);

  abstract public String getDni();
  abstract public void setDni(String n);

  abstract public String getNombre_apellidos();
  abstract public void setNombre_apellidos(String n);

  abstract public String getTelefono();
  abstract public void setTelefono(String n);
  
  abstract public String getTelefonoMovil();
  abstract public void setTelefonoMovil(String n);

  abstract public String getDomicilio();
  abstract public void setDomicilio(String n);
  
  abstract public String getCodProvincia();
  abstract public void setCodProvincia(String n);
  
  abstract public String getCodMunicipio();
  abstract public void setCodMunicipio(String n);

  abstract public String getCodPostal();
  abstract public void setCodPostal(String n);
  
  abstract public String getPuesto();
  abstract public void setPuesto(String n);
  
  abstract public String getCodDepartamento();
  abstract public void setCodDepartamento(String n);
  
  abstract public String getDesccDepartamento();
  abstract public void setDesccDepartamento(String n);
  
  abstract public String getDesceDepartamento();
  abstract public void setDesceDepartamento(String n);
  
  abstract public String getCodDireccion();
  abstract public void setCodDireccion(String n);
  
  abstract public String getDesccDireccion();
  abstract public void setDesccDireccion(String n);
  
  abstract public String getDesceDireccion();
  abstract public void setDesceDireccion(String n);
  
  
  public void ejbActivate() { }

  public void ejbPassivate() { }

  public void setEntityContext(EntityContext ctx) {
	  this.ctx = ctx;
  }

  public void unsetEntityContext() {
	  this.ctx = null;
  }

  public void ejbLoad() { }

  public void ejbStore() { }

  public void ejbRemove() throws RemoveException  { }

  /**
   * This function initializes the Personal
   * information of this E-EJB
   * It assigns a new primary key to the Personal.
   */
  public m05SolicitudReserva_UsuarioPK ejbCreate(m05bSolicitudReserva_Usuario SolicitudReserva_Usuario) throws CreateException
  {
    try {
    	setIdSolicitud(getIdSolicitud());
    	setCodSolicitante(getCodSolicitante());
    } catch (Exception e) {
      throw new CreateException (e.getMessage());
    }

    setDni(SolicitudReserva_Usuario.getDni());
    setNombre_apellidos(SolicitudReserva_Usuario.getNombre_apellidos());
    setTelefono(SolicitudReserva_Usuario.getTelefono());
    setTelefonoMovil(SolicitudReserva_Usuario.getTelefonoMovil());
    setDomicilio(SolicitudReserva_Usuario.getDomicilio());
    setCodProvincia(SolicitudReserva_Usuario.getProvincia().getCodigo());
    setCodMunicipio(SolicitudReserva_Usuario.getMunicipio().getCodigo());
    setCodPostal(SolicitudReserva_Usuario.getCodPostal());
    setPuesto(SolicitudReserva_Usuario.getPuesto());
    setCodDepartamento(SolicitudReserva_Usuario.getCodDepartamento());
    setDesccDepartamento(SolicitudReserva_Usuario.getDesccDepartamento());
    setDesceDepartamento(SolicitudReserva_Usuario.getDesceDepartamento());
    setCodDireccion(SolicitudReserva_Usuario.getCodDireccion());
    setDesccDireccion(SolicitudReserva_Usuario.getDesccDireccion());
    setDesceDireccion(SolicitudReserva_Usuario.getDesceDireccion());

    return null;
  }
  
  public void ejbPostCreate(m05bSolicitudReserva_Usuario SolicitudReserva_Usuario) { }
}