package m05bSolicitudReservaEJB;

import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Iterator;

import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import m05bBD.m05bSolicitudReserva;
import m05bBD.m05bSolicitudReserva_Usuario;
import m05bBD.m05bSolicitudReserva_Validacion;
import m05bClasses.m05bFileLog;
import m05bSolicitudReserva_UsuarioEJB.m05SolicitudReserva_Usuario;
import m05bSolicitudReserva_UsuarioEJB.m05SolicitudReserva_UsuarioHome;
import m05bSolicitudReserva_ValidacionEJB.m05SolicitudReserva_Validacion;
import m05bSolicitudReserva_ValidacionEJB.m05SolicitudReserva_ValidacionHome;

/**
 * This class is the Bean Implementation for the Entity EJB <tt>M05SolicitudReservaEB</tt>.
 *
 * @see     m05.exe.SolicitudReserva
 * @see     m05.exe.M05SolicitudReservaEB
 * @see     m05.exe.M05SolicitudReservaEBPK
 * @see     m05.exe.M05SolicitudReservaEBHome
 */
abstract public class m05SolicitudReservaBean implements EntityBean {
  private EntityContext ctx;

  /**
   * This is the primary key.
   * It is the clave, which is the primary key
   * in table <tt>m05100t00</tt>.
   */

  /**
   * Returns the Personal information of this E-EJB.
   */
  public m05bSolicitudReserva getSolicitudReserva() {

    m05bSolicitudReserva SolicitudReserva = new m05bSolicitudReserva();

    SolicitudReserva.setIdSolicitud(getIdSolicitud());
    SolicitudReserva.setFechaSolicitud(getFechaSolicitud());
    SolicitudReserva.setFechaIni(getFechaIni());
    SolicitudReserva.setFechaFin(getFechaFin());
    SolicitudReserva.setCodAsignacion(getCodAsignacion());
    SolicitudReserva.setBloqueo(getBloqueo());
    
    /*Los obtenemos de otras tablas*/
    m05bSolicitudReserva_Usuario usuario = null;
    m05bFileLog miLog = new m05bFileLog();
	try {
		InitialContext ctx2;
		ctx2 = new InitialContext();
		m05SolicitudReserva_UsuarioHome solicitudReserva_UsuarioEBHome = (m05SolicitudReserva_UsuarioHome) ctx2.lookup("m05SolicitudReserva_Usuario");
		m05SolicitudReserva_Usuario solicitudReserva_UsuarioEB = solicitudReserva_UsuarioEBHome.findByIdSolicitud(getIdSolicitud());
		usuario = solicitudReserva_UsuarioEB.getSolicitudReserva_Usuario();
	} catch (NamingException e) {
		// TODO Auto-generated catch block
		
		miLog.addTraza(e);
	} catch (RemoteException e) {
		// TODO Auto-generated catch block
		miLog.addTraza(e);
	} catch (FinderException e) {
		// TODO Auto-generated catch block
		miLog.addTraza(e);
	}
    SolicitudReserva.setUsuario(usuario);

    m05bSolicitudReserva_Validacion[] validaciones = null;
	try {
		InitialContext ctx2;
		ctx2 = new InitialContext();
		m05SolicitudReserva_ValidacionHome solicitudReserva_ValidacionEBHome = (m05SolicitudReserva_ValidacionHome) ctx2.lookup("m05SolicitudReserva_Validacion");
		Collection solicitudReserva_ValidacionEB = solicitudReserva_ValidacionEBHome.findByIdSolicitud(getIdSolicitud());
		if (solicitudReserva_ValidacionEB != null && solicitudReserva_ValidacionEB.size() > 0)
		{
			int i=0;
			validaciones = new m05bSolicitudReserva_Validacion[solicitudReserva_ValidacionEB.size()];
			for (Iterator it = solicitudReserva_ValidacionEB.iterator(); it.hasNext(); )
			{
				validaciones[i] = ((m05SolicitudReserva_Validacion) it.next()).getSolicitudReserva_Validacion();
				i++;
			}
		}
	} catch (NamingException e) {
		// TODO Auto-generated catch block
		miLog.addTraza(e);		
	} catch (RemoteException e) {
		// TODO Auto-generated catch block
		miLog.addTraza(e);	
	} catch (FinderException e) {
		// TODO Auto-generated catch block
		miLog.addTraza(e);	
	}
    SolicitudReserva.setValidaciones(validaciones);
    /**/
    
    return SolicitudReserva;
  }

  /**
   * Sets the SolicitudReserva information of this E-EJB.
   * @exception P2GException 
   *              If the given Personal <tt>per_dni</tt> field 
   *              does not match the primary key that is in the E-EJB.
   */
  public void setSolicitudReserva(m05bSolicitudReserva SolicitudReserva) throws Exception {
    //the primary key is never modified!!
    if (getIdSolicitud().intValue() != SolicitudReserva.getIdSolicitud().intValue())
    	throw new CreateException ("Cannot modify a different Solicitud reserva");

    setFechaSolicitud(SolicitudReserva.getFechaSolicitud());
    setFechaIni(SolicitudReserva.getFechaIni());
    setFechaFin(SolicitudReserva.getFechaFin());
    setCodAsignacion(SolicitudReserva.getCodAsignacion());
    setBloqueo(SolicitudReserva.getBloqueo());
  }


  abstract public Integer getIdSolicitud();
  abstract public void setIdSolicitud(Integer n);

  abstract public String getFechaSolicitud();
  abstract public void setFechaSolicitud(String n);

  abstract public String getFechaIni();
  abstract public void setFechaIni(String n);

  abstract public String getFechaFin();
  abstract public void setFechaFin(String n);

  abstract public Integer getCodAsignacion();
  abstract public void setCodAsignacion(Integer n);
  
  abstract public String getBloqueo();
  abstract public void setBloqueo(String n);


  public void ejbActivate() { }

  public void ejbPassivate() { }

  public void setEntityContext(EntityContext ctx) {
	  this.ctx = ctx;
  }

  public void unsetEntityContext() {
	  this.ctx = null;
  }

  public void ejbLoad() { }

  public void ejbStore() { }

  public void ejbRemove() throws RemoveException  { }

  /**
   * This function initializes the Personal
   * information of this E-EJB
   * It assigns a new primary key to the Personal.
   */
  public m05SolicitudReservaPK ejbCreate(m05bSolicitudReserva SolicitudReserva) throws CreateException
  {
    try {
    	setIdSolicitud(getIdSolicitud());
    } catch (Exception e) {
      throw new CreateException (e.getMessage());
    }

    setIdSolicitud(SolicitudReserva.getIdSolicitud());
    setFechaSolicitud(SolicitudReserva.getFechaSolicitud());
    setFechaIni(SolicitudReserva.getFechaIni());
    setFechaFin(SolicitudReserva.getFechaFin());
    setCodAsignacion(SolicitudReserva.getCodAsignacion());
    setBloqueo(SolicitudReserva.getBloqueo());

    return null;
  }
  
  public void ejbPostCreate(m05bSolicitudReserva SolicitudReserva) { }
}